-- Indexes for existing BA/field operations tables in current 'sentient' DB

-- users
ALTER TABLE users ADD INDEX idx_users_utype (utype);
ALTER TABLE users ADD INDEX idx_users_city (city);
ALTER TABLE users ADD INDEX idx_users_area (area);
ALTER TABLE users ADD INDEX idx_users_username (username);
ALTER TABLE users ADD INDEX idx_users_ba_no (ba_no);

-- brand
ALTER TABLE brand ADD INDEX idx_brand_cid (cid);
ALTER TABLE brand ADD INDEX idx_brand_brname (brname);

-- store
ALTER TABLE store ADD INDEX idx_store_city (city);
ALTER TABLE store ADD INDEX idx_store_area (area);
ALTER TABLE store ADD INDEX idx_store_unique_name (unique_name);

-- assignments
ALTER TABLE assignments ADD INDEX idx_assignments_stid (stid);
ALTER TABLE assignments ADD INDEX idx_assignments_brid (brid);
ALTER TABLE assignments ADD INDEX idx_assignments_uid (uid);
ALTER TABLE assignments ADD INDEX idx_assignments_asstatus (asstatus);
ALTER TABLE assignments ADD INDEX idx_assignments_asdate (asdate);

-- user_attendance
ALTER TABLE user_attendance ADD INDEX idx_uatt_uid (uid);
ALTER TABLE user_attendance ADD INDEX idx_uatt_asid (asid);
ALTER TABLE user_attendance ADD INDEX idx_uatt_attendance_date (attendance_date);
ALTER TABLE user_attendance ADD INDEX idx_uatt_uatdate (uatdate);
ALTER TABLE user_attendance ADD INDEX idx_uatt_statuses (stock_status, price_status, sale_status);

-- visits
ALTER TABLE visits ADD INDEX idx_visits_uid (uid);
ALTER TABLE visits ADD INDEX idx_visits_stid (stid);
ALTER TABLE visits ADD INDEX idx_visits_brid (brid);
ALTER TABLE visits ADD INDEX idx_visits_vdate (vdate);
ALTER TABLE visits ADD INDEX idx_visits_vstatus (vstatus);

-- visit_plan
ALTER TABLE visit_plan ADD INDEX idx_visit_plan_uid (uid);
ALTER TABLE visit_plan ADD INDEX idx_visit_plan_visit_date (visit_date);
ALTER TABLE visit_plan ADD INDEX idx_visit_plan_vpstatus (vpstatus);

-- visit_plan_detail
ALTER TABLE visit_plan_detail ADD INDEX idx_visit_plan_detail_vpid (vpid);
ALTER TABLE visit_plan_detail ADD INDEX idx_visit_plan_detail_uid (uid);
ALTER TABLE visit_plan_detail ADD INDEX idx_visit_plan_detail_stid (stid);
ALTER TABLE visit_plan_detail ADD INDEX idx_visit_plan_detail_brid (brid);
ALTER TABLE visit_plan_detail ADD INDEX idx_visit_plan_detail_asid (asid);
ALTER TABLE visit_plan_detail ADD INDEX idx_visit_plan_detail_vpddate (vpddate);

-- survey_record
ALTER TABLE survey_record ADD INDEX idx_survey_record_surid (surid);
ALTER TABLE survey_record ADD INDEX idx_survey_record_asid (asid);
ALTER TABLE survey_record ADD INDEX idx_survey_record_uid (uid);
ALTER TABLE survey_record ADD INDEX idx_survey_record_surrdate (surrdate);

-- survey_record_detail
ALTER TABLE survey_record_detail ADD INDEX idx_survey_record_detail_surrid (surrid);
ALTER TABLE survey_record_detail ADD INDEX idx_survey_record_detail_field (surdfield);

