-- Run these statements on your MySQL server (preferably during a maintenance window).
-- Create indexes used by frequent WHERE/JOIN/ORDER BY clauses and search pages.

-- tmp_purchase
ALTER TABLE tmp_purchase ADD INDEX idx_tmp_purchase_tpurdate (tpurdate);
ALTER TABLE tmp_purchase ADD INDEX idx_tmp_purchase_tpurdid (tpurdid);

-- accounts
ALTER TABLE accounts ADD INDEX idx_accounts_acmid (acmid);
ALTER TABLE accounts ADD INDEX idx_accounts_aid (aid);
ALTER TABLE accounts ADD INDEX idx_accounts_gtno (gtno);
ALTER TABLE accounts ADD INDEX idx_accounts_aname (aname);
ALTER TABLE accounts ADD INDEX idx_accounts_aemail (aemail);
ALTER TABLE accounts ADD INDEX idx_accounts_amobile (amobile);

-- raw materials and categories
ALTER TABLE rawmaterials ADD INDEX idx_rawmaterials_rid (rid);
ALTER TABLE rawmaterials ADD INDEX idx_rawmaterials_rmid (rmid);
ALTER TABLE rawmaterials ADD INDEX idx_rawmaterials_rcid (rcid);
ALTER TABLE rmaincategory ADD INDEX idx_rmaincategory_rmid (rmid);
ALTER TABLE rcategory ADD INDEX idx_rcategory_rcid (rcid);

-- subscriptions and submembers
ALTER TABLE subscriptions ADD INDEX idx_subscriptions_subid (subid);
ALTER TABLE subscriptions ADD INDEX idx_subscriptions_aid (aid);
ALTER TABLE subscriptions ADD INDEX idx_subscriptions_subgtno (subgtno);
ALTER TABLE subscriptions ADD INDEX idx_subscriptions_subtitle (subtitle);
ALTER TABLE submembers ADD INDEX idx_submembers_smid (smid);
ALTER TABLE submembers ADD INDEX idx_submembers_aid (aid);
ALTER TABLE submembers ADD INDEX idx_submembers_subid (subid);
ALTER TABLE submembers ADD INDEX idx_submembers_smgtno (smgtno);
ALTER TABLE submembers ADD INDEX idx_submembers_smname (smname);
ALTER TABLE submembers ADD INDEX idx_submembers_smemail (smemail);
ALTER TABLE submembers ADD INDEX idx_submembers_smmobile (smmobile);

-- invoices
ALTER TABLE invoices ADD INDEX idx_invoices_invid (invid);
ALTER TABLE invoices ADD INDEX idx_invoices_aid (aid);
ALTER TABLE invoices ADD INDEX idx_invoices_invdate (invdate);
ALTER TABLE invoices ADD INDEX idx_invoices_invstatus (invstatus);

-- booking and slots
ALTER TABLE booking ADD INDEX idx_booking_btype (btype);
ALTER TABLE booking ADD INDEX idx_booking_aid (aid);
ALTER TABLE booking ADD INDEX idx_booking_slid (slid);
ALTER TABLE booking ADD INDEX idx_booking_bookdate (bookdate);
ALTER TABLE booking ADD INDEX idx_booking_btimefrom (btimefrom);
ALTER TABLE booking ADD INDEX idx_booking_btimeto (btimeto);
ALTER TABLE slots ADD INDEX idx_slots_slid (slid);

-- Optional: FULLTEXT indexes for faster search (MySQL 5.6+ InnoDB / 5.7+ recommended)
-- Uncomment if you want full-text search and then update queries to use MATCH() AGAINST()
-- ALTER TABLE accounts ADD FULLTEXT ft_accounts (gtno, aname, aemail, amobile);
-- ALTER TABLE subscriptions ADD FULLTEXT ft_subscriptions (subgtno, subtitle);
-- ALTER TABLE submembers ADD FULLTEXT ft_submembers (smgtno, smname, smemail, smmobile);
-- ALTER TABLE invoices ADD FULLTEXT ft_invoices (remarks);
-- ALTER TABLE booking ADD FULLTEXT ft_booking (btitle);
-- ALTER TABLE slots ADD FULLTEXT ft_slots (sltitle);


