<?php
  require_once("includes/functions.php");
  include_once("includes/errors.php");
  ba_loggedin();
  /*if(isset($_SESSION['user']))
  {
    header("Location: main.php");
  }
  else
  {
    if(!isset($_SESSION['tmp_user']))
    {
      header("Location: index.php");  
    }
  }*/

  if($_REQUEST['lat'] == "")
  {
    header("Location: logout.php?err=4");  
  }
  $asquery = $db->prepare("SELECT A.asid, A.stid, A.uid, ST.stid, ST.store_name, ST.store_code, ST.city, ST.stlat, ST.stlong FROM assignments A 
                        INNER JOIN store ST ON A.stid = ST.stid WHERE A.uid = ?");
  $asquery->execute(array($_COOKIE['ba']));
  while($asrow = $asquery->fetch())
  {
      $stlat = $asrow['stlat'];
      $stlong = $asrow['stlong'];
      
      $store_name = $asrow['store_name'];
      $city = $asrow['city'];
  }
  $user_lat = $_REQUEST['lat'];
  $user_long = $_REQUEST['long'];

  /**
   * Calculates the great-circle distance between two points, with
   * the Haversine formula.
   * @param float $latitudeFrom Latitude of start point in [deg decimal]
   * @param float $longitudeFrom Longitude of start point in [deg decimal]
   * @param float $latitudeTo Latitude of target point in [deg decimal]
   * @param float $longitudeTo Longitude of target point in [deg decimal]
   * @param float $earthRadius Mean earth radius in [m]
   * @return float Distance between points in [m] (same as earthRadius)
   */
  function haversineGreatCircleDistance($latitudeFrom, $longitudeFrom, $latitudeTo, $longitudeTo, $earthRadius = 6371000)
  {
    // convert from degrees to radians
    $latFrom = deg2rad($latitudeFrom);
    $lonFrom = deg2rad($longitudeFrom);
    $latTo = deg2rad($latitudeTo);
    $lonTo = deg2rad($longitudeTo);

    $latDelta = $latTo - $latFrom;
    $lonDelta = $lonTo - $lonFrom;

    $angle = 2 * asin(sqrt(pow(sin($latDelta / 2), 2) +
      cos($latFrom) * cos($latTo) * pow(sin($lonDelta / 2), 2)));
    return $angle * $earthRadius;
  }
  
  $meter_distance = haversineGreatCircleDistance($user_lat, $user_long, $stlat, $stlong, $earthRadius = 6371000);

  //$meter_distance = distance($stlat, $stlong, $user_lat, $user_long, "K") * 1000;
  //echo("Store: $stlat / $stlong <br> user: $user_lat / $user_long <br>");  
  //echo number_format($meter_distance,2);die;
      
  if(isset($_REQUEST['btnNext']))
  {

    do_verify_logout_location($db,$URL,$_REQUEST['lat'],$_REQUEST['long']);
  } 
  if(isset($_REQUEST['btnCancel']))
  {
    header("Location: main.php");
  }
?>
<!doctype html>

<html
  lang="en"
  class="light-style layout-wide customizer-hide"
  dir="ltr"
  data-theme="theme-default"
  data-assets-path="assets/"
  data-template="vertical-menu-template-free"
  data-style="light">
  <head>
    <meta charset="utf-8" />
    <meta
      name="viewport"
      content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />

    <title>Sentient App - Verify Logout Location</title>

    <meta name="description" content="" />

    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="assets/img/favicon/favicon.ico" />

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
      href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&ampdisplay=swap"
      rel="stylesheet" />

    <link rel="stylesheet" href="assets/vendor/fonts/remixicon/remixicon.css" />

    <!-- Menu waves for no-customizer fix -->
    <link rel="stylesheet" href="assets/vendor/libs/node-waves/node-waves.css" />

    <!-- Core CSS -->
    <link rel="stylesheet" href="assets/vendor/css/core.css" class="template-customizer-core-css" />
    <link rel="stylesheet" href="assets/vendor/css/theme-default.css" class="template-customizer-theme-css" />
    <link rel="stylesheet" href="assets/css/demo.css" />

    <!-- Vendors CSS -->
    <link rel="stylesheet" href="assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.css" />

    <!-- Page CSS -->
    <!-- Page -->
    <link rel="stylesheet" href="assets/vendor/css/pages/page-auth.css" />

    <!-- Helpers -->
    <script src="assets/vendor/js/helpers.js"></script>
    <!--! Template customizer & Theme config files MUST be included after core stylesheets and helpers.js in the <head> section -->
    <!--? Config:  Mandatory theme config file contain global vars & default theme options, Set your preferred theme option in this file.  -->
    <script src="assets/js/config.js"></script>
  </head>

  <body>
    <!-- Content -->

    <div class="position-relative">
      <div class="authentication-wrapper authentication-basic container-p-y">
        <div class="authentication-inner py-6 mx-4">
          <!-- Login -->
          <div class="card p-7">
            <!-- Logo -->
            <div class="app-brand justify-content-center mt-5">
              <a href="index.html" class="app-brand-link gap-3">
                <span class="app-brand-logo demo">
                  <span style="color: #9055fd">
                    <img src="assets/img/sentient_logo.png" width="75">
                  </span>
                </span>
                <span class="app-brand-text demo text-heading fw-semibold">Sentient App</span>
              </a>
            </div>
            <!-- /Logo -->

            <div class="card-body mt-1">
              

              <form id="formAuthentication" class="mb-5" method="POST">
                <div class="form-floating form-floating-outline mb-5">
                  
                  <h6>Verify Logout Location</h6>
                  <?php if($meter_distance > 50){ ?>
                  <span style="color:red;">Your current location is more then 50 meters away form your login point</span>
                  <?php } ?>
                  
                  <h5 class="mb-1">Store: <?php echo($store_name); ?>, <?php echo($city); ?></h5>
                  <iframe style="border: 0;" src="https://maps.google.com/maps?q=<?php echo($stlat); ?>,<?php echo($stlong); ?>&amp;hl=es;z=14&amp;output=embed" width="100%" height="250" frameborder="0" allowfullscreen="allowfullscreen"></iframe>
                  <p class="mb-5"><small>Lat: <?php echo($stlat); ?> | Long: <?php echo($stlong); ?></small></p>
                 

                  <h5 class="mb-1">Your Current Location</h5>
                  <iframe style="border: 0;" src="https://maps.google.com/maps?q=<?php echo($user_lat); ?>,<?php echo($user_long); ?>&amp;hl=es;z=14&amp;output=embed" width="100%" height="250" frameborder="0" allowfullscreen="allowfullscreen"></iframe>
                  <p id="demo" class="mb-5"><small>Lat: <?php echo($user_lat); ?> | Long: <?php echo($user_long); ?></small></p>
                  <input type="hidden" name="hdnLat" value="<?php echo($user_lat); ?>">
                  <input type="hidden" name="hdnLong" value="<?php echo($user_long); ?>">
                  <br>

                  <h5 class="mb-1" style="color: red;">Distance: <?php echo(number_format($meter_distance,2)); ?> Meters</h5>
                </div>
                
                <div class="mb-5">
                    <?php
                        // Testing Accounts which will bypass location restrictions
                        // id = 430 - testlhr_ba1347
                        // id = 431 - testrwp_ba1348    
                        // id = 432 - testkhi_ba1349
                        if($meter_distance < 100)
                        {
                    ?>
                    <button name="btnNext" class="btn btn-primary d-grid w-100" type="submit">Confirm Logout</button>
                    <br>
                    <?php
                        }else{
                            if($_SESSION['ba'] == 430 || $_SESSION['ba'] == 431 || $_SESSION['ba'] == 432 || $_SESSION['ba'] == 446 || $_REQUEST['t'] == "mohsin")
                            {
                    ?>
                    <button name="btnNext" class="btn btn-primary d-grid w-100" type="submit">Confirm Logout</button>
                    <br>
                    <?php } } ?>
                  <button name="btnCancel" class="btn btn-danger d-grid w-100" type="submit">Cancel Logout</button>
                </div>
              </form>
              
            </div>
          </div>
          <!-- /Login -->
          
          <img
            src="assets/img/illustrations/auth-basic-mask-light.png"
            class="authentication-image d-none d-lg-block"
            height="172"
            alt="triangle-bg"
            data-app-light-img="illustrations/auth-basic-mask-light.png"
            data-app-dark-img="illustrations/auth-basic-mask-dark.png" />
          
        </div>
      </div>
    </div>
    <script>
        const x = document.getElementById("demo");
        
        function getLocation() {
          if (navigator.geolocation) {
            navigator.geolocation.getCurrentPosition(showPosition);
          } else { 
            x.innerHTML = "Geolocation is not supported by this browser.";
          }
        }
        
        function showPosition(position) {
          x.innerHTML = "Latitude: " + position.coords.latitude + 
          "<br>Longitude: " + position.coords.longitude;
        }
    </script>

    <!-- / Content -->

    

    <!-- Core JS -->
    <!-- build:js assets/vendor/js/core.js -->
    <script src="assets/vendor/libs/jquery/jquery.js"></script>
    <script src="assets/vendor/libs/popper/popper.js"></script>
    <script src="assets/vendor/js/bootstrap.js"></script>
    <script src="assets/vendor/libs/node-waves/node-waves.js"></script>
    <script src="assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js"></script>
    <script src="assets/vendor/js/menu.js"></script>

    <!-- endbuild -->

    <!-- Vendors JS -->

    <!-- Main JS -->
    <script src="assets/js/main.js"></script>

    <!-- Page JS -->

    <!-- Place this tag before closing body tag for github widget button. -->
    <script async defer src="https://buttons.github.io/buttons.js"></script>
  </body>
</html>
