<?php
  require_once("includes/functions.php");
  include_once("includes/errors.php");
  
  if(isset($_SESSION['ba']))
  {
    header("Location: main.php");
  }
  else
  {
    if(!isset($_SESSION['tmp_ba']))
    {
      header("Location: index.php");  
    }
  }
  
  /*if(isset($_REQUEST['btnUpload']))
  {
    upload_selfie($db,$URL);
  }*/ 

  
  if(isset($_REQUEST['btnConfirm']))
  {
      upload_selfie($db,$URL,$_REQUEST['lat'],$_REQUEST['long']);
  }

  if(isset($_REQUEST['btnSave']))
  {
    header("Location: upload_selfie.php?lat=".$_REQUEST['lat']."&long=".$_REQUEST['long']."&err=1&s=1");
  }


  if(isset($_REQUEST['btnCancel']))
  {
    do_cancel_login($db,$URL);
  }
?>
<!doctype html>

<html
  lang="en"
  class="light-style layout-wide customizer-hide"
  dir="ltr"
  data-theme="theme-default"
  data-assets-path="assets/"
  data-template="vertical-menu-template-free"
  data-style="light">
  <head>
    <meta charset="utf-8" />
    <meta
      name="viewport"
      content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />

    <title>Sentient App - Upload Selfie</title>

    <meta name="description" content="" />

    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="assets/img/favicon/favicon.ico" />

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
      href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&ampdisplay=swap"
      rel="stylesheet" />

    <link rel="stylesheet" href="assets/vendor/fonts/remixicon/remixicon.css" />

    <!-- Menu waves for no-customizer fix -->
    <link rel="stylesheet" href="assets/vendor/libs/node-waves/node-waves.css" />

    <!-- Core CSS -->
    <link rel="stylesheet" href="assets/vendor/css/core.css" class="template-customizer-core-css" />
    <link rel="stylesheet" href="assets/vendor/css/theme-default.css" class="template-customizer-theme-css" />
    <link rel="stylesheet" href="assets/css/demo.css" />

    <!-- Vendors CSS -->
    <link rel="stylesheet" href="assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.css" />

    <!-- Page CSS -->
    <!-- Page -->
    <link rel="stylesheet" href="assets/vendor/css/pages/page-auth.css" />

    <!-- Helpers -->
    <script src="assets/vendor/js/helpers.js"></script>
    <!--! Template customizer & Theme config files MUST be included after core stylesheets and helpers.js in the <head> section -->
    <!--? Config:  Mandatory theme config file contain global vars & default theme options, Set your preferred theme option in this file.  -->
    <script src="assets/js/config.js"></script>
  </head>

  <body>
    <!-- Content -->

    <div class="position-relative">
      <div class="authentication-wrapper authentication-basic container-p-y">
        <div class="authentication-inner py-6 mx-4">
          <!-- Login -->
          <div class="card p-7">
            <!-- Logo -->
            <div class="app-brand justify-content-center mt-5">
              <a href="index.html" class="app-brand-link gap-3">
                <span class="app-brand-logo demo">
                  <span style="color: #9055fd">
                    <img src="assets/img/sentient_logo.png" width="75">
                  </span>
                </span>
                <span class="app-brand-text demo text-heading fw-semibold">Sentient App</span>
              </a>
            </div>
            <!-- /Logo -->

            <div class="card-body mt-1">

                <div align="center" class="form-floating form-floating-outline mb-5">
                  <table>
                    <?php
                      if(isset($_REQUEST['s']))
                      {

                          $at_date = date("d-m-Y");

                          $query = $db->prepare("SELECT uatid, uid, attendance_date, timein_image FROM user_attendance WHERE uid = ? AND attendance_date = ?");
                          $query->execute(array($_SESSION['tmp_ba'], $at_date));
                          while($row = $query->fetch())
                          {
                    ?>
                    <tr>
                      <td align="left">
                        <img width="325" src="assets/uploads/ba/<?php echo($row['timein_image']); ?>">
                      </td>
                    </tr>
                    <?php
                          }
                      }
                      else
                      {    
                    ?>    
                    <tr>
                      <td align="left">
                        <img id="previewImage" style="display: none; max-width: 250px; height: auto;">
                      </td>
                    </tr>
                    <tr>
                      <td>
                          <form id="uploadForm">
                              <input type="file" id="imageUpload" accept="image/*" capture="camera">
                              <br><br>
                               <button type="submit" name="btnimage" class="btn btn-primary d-grid w-100" type="submit">Upload Selfie</button>
                             <!--  <input type="submit" class="btn btn-primary d-grid w-100" value="Upload Selfie" style="background-color: #333;"> -->
                          </form>
                          <img id="previewImage" style="display: none; max-width: 250px; height: auto;">
                      </td>
                    </tr>
                    <?php
                      }
                    ?>
                  </table>                  
                </div>
                <form name="Form1" method="post">
                <div class="mb-5">
                  <?php
                    if(isset($_REQUEST['s']))
                    {

                  ?>
                  <button name="btnConfirm" class="btn btn-success d-grid w-100" type="submit">Next</button>
                  <br>
                  <?php
                    }
                    else
                    {
                  ?>
                  <button name="btnSave" class="btn btn-danger d-grid w-100" type="submit">Save</button>
                  <br>
                  <?php
                    }
                  ?>
                  
                  <!-- <button name="btnCancel" class="btn btn-danger d-grid w-100" type="submit">Cancel Login</button> -->
                </div>
                </form>
              
            </div>
          </div>
          <!-- /Login -->
          <img
            src="assets/img/illustrations/tree-3.png"
            alt="auth-tree"
            class="authentication-image-object-left d-none d-lg-block" />
          <img
            src="assets/img/illustrations/auth-basic-mask-light.png"
            class="authentication-image d-none d-lg-block"
            height="172"
            alt="triangle-bg"
            data-app-light-img="illustrations/auth-basic-mask-light.png"
            data-app-dark-img="illustrations/auth-basic-mask-dark.png" />
          <img
            src="assets/img/illustrations/tree.png"
            alt="auth-tree"
            class="authentication-image-object-right d-none d-lg-block" />
        </div>
      </div>
    </div>

    <!-- / Content -->

   

    <!-- Core JS -->
    <!-- build:js assets/vendor/js/core.js -->
    <script src="assets/vendor/libs/jquery/jquery.js"></script>
    <script src="assets/vendor/libs/popper/popper.js"></script>
    <script src="assets/vendor/js/bootstrap.js"></script>
    <script src="assets/vendor/libs/node-waves/node-waves.js"></script>
    <script src="assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js"></script>
    <script src="assets/vendor/js/menu.js"></script>

    <!-- endbuild -->

    <!-- Vendors JS -->

    <!-- Main JS -->
    <script src="assets/js/main.js"></script>

    <!-- Page JS -->

    <!-- Place this tag before closing body tag for github widget button. -->
    <script async defer src="https://buttons.github.io/buttons.js"></script>
    <script>
        
        document.Form1.elements['btnSave'].disabled = true;
        
        function resizeImage(file, maxWidth, maxHeight, callback) {
            const reader = new FileReader();
            reader.readAsDataURL(file);
            
            reader.onload = function(event) {
                const img = new Image();
                img.src = event.target.result;
                
                img.onload = function() {
                    const canvas = document.createElement('canvas');
                    let width = img.width;
                    let height = img.height;
                    
                    if (width > maxWidth || height > maxHeight) {
                        if (width > height) {
                            height *= maxWidth / width;
                            width = maxWidth;
                        } else {
                            width *= maxHeight / height;
                            height = maxHeight;
                        }
                    }
                    
                    canvas.width = width;
                    canvas.height = height;
                    const ctx = canvas.getContext('2d');
                    ctx.drawImage(img, 0, 0, width, height);
                    
                    canvas.toBlob((blob) => {
                        callback(blob, canvas.toDataURL());
                    }, file.type);
                };
            };
        }

        document.getElementById("uploadForm").addEventListener("submit", function(event) {
            event.preventDefault(); // Prevent the default form submission

            const fileInput = document.getElementById("imageUpload");
            const file = fileInput.files[0];

            if (file) {
                resizeImage(file, 800, 600, function(resizedBlob, imageDataUrl) {
                    document.getElementById("previewImage").src = imageDataUrl;
                    document.getElementById("previewImage").style.display = "block";

                    const formData = new FormData();
                    formData.append("image", resizedBlob, file.name);
                    
                    fetch("ba_upload.php", {
                        method: "POST",
                        body: formData
                    }).then(response => response.text())
                      .then(data => console.log(data))
                      .catch(error => console.error("Error:", error));
                      
                      document.Form1.elements['btnSave'].disabled = false;
                });
            } else {
                alert("Please select an image!");
            }
        });
    </script>
  </body>
</html>
