<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Image Resize & Upload</title>
</head>
<body>
    <h2>Upload and Resize Image</h2>
    <form id="uploadForm">
        <input type="file" id="imageUpload">
        <input type="submit" value="Upload">
    </form>
    <img id="previewImage" style="display: none; max-width: 250px; height: auto;">

    <script>
        function resizeImage(file, maxWidth, maxHeight, callback) {
            const reader = new FileReader();
            reader.readAsDataURL(file);
            
            reader.onload = function(event) {
                const img = new Image();
                img.src = event.target.result;
                
                img.onload = function() {
                    const canvas = document.createElement('canvas');
                    let width = img.width;
                    let height = img.height;
                    
                    if (width > maxWidth || height > maxHeight) {
                        if (width > height) {
                            height *= maxWidth / width;
                            width = maxWidth;
                        } else {
                            width *= maxHeight / height;
                            height = maxHeight;
                        }
                    }
                    
                    canvas.width = width;
                    canvas.height = height;
                    const ctx = canvas.getContext('2d');
                    ctx.drawImage(img, 0, 0, width, height);
                    
                    canvas.toBlob((blob) => {
                        callback(blob, canvas.toDataURL());
                    }, file.type);
                };
            };
        }

        document.getElementById("uploadForm").addEventListener("submit", function(event) {
            event.preventDefault(); // Prevent the default form submission

            const fileInput = document.getElementById("imageUpload");
            const file = fileInput.files[0];

            if (file) {
                resizeImage(file, 800, 600, function(resizedBlob, imageDataUrl) {
                    document.getElementById("previewImage").src = imageDataUrl;
                    document.getElementById("previewImage").style.display = "block";

                    const formData = new FormData();
                    formData.append("image", resizedBlob, file.name);
                    
                    fetch("upload.php", {
                        method: "POST",
                        body: formData
                    }).then(response => response.text())
                      .then(data => console.log(data))
                      .catch(error => console.error("Error:", error));
                });
            } else {
                alert("Please select an image!");
            }
        });
    </script>
</body>
</html>
