<?php  
  require_once("includes/functions.php");
  include_once("includes/errors.php");
  sup_loggedin();
  //echo($_COOKIE['asid']);die;
?>
<!doctype html>

<html
  lang="en"
  class="light-style layout-menu-fixed layout-compact"
  dir="ltr"
  data-theme="theme-default"
  data-assets-path="assets/"
  data-template="vertical-menu-template-free"
  data-style="light">
  <head>
    <meta charset="utf-8" />
    <meta
      name="viewport"
      content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />

    <title>Sentient App - Visit Plans</title>

    <meta name="description" content="" />

    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="assets/img/favicon/favicon.ico" />

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
      href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&ampdisplay=swap"
      rel="stylesheet" />

    <link rel="stylesheet" href="assets/vendor/fonts/remixicon/remixicon.css" />

    <!-- Menu waves for no-customizer fix -->
    <link rel="stylesheet" href="assets/vendor/libs/node-waves/node-waves.css" />

    <!-- Core CSS -->
    <link rel="stylesheet" href="assets/vendor/css/core.css" class="template-customizer-core-css" />
    <link rel="stylesheet" href="assets/vendor/css/theme-default.css" class="template-customizer-theme-css" />
    <link rel="stylesheet" href="assets/css/demo.css" />

    <!-- Vendors CSS -->
    <link rel="stylesheet" href="assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.css" />
    <link rel="stylesheet" href="assets/vendor/libs/apex-charts/apex-charts.css" />

    <!-- Page CSS -->

    <!-- Helpers -->
    <script src="assets/vendor/js/helpers.js"></script>
    <!--! Template customizer & Theme config files MUST be included after core stylesheets and helpers.js in the <head> section -->
    <!--? Config:  Mandatory theme config file contain global vars & default theme options, Set your preferred theme option in this file.  -->
    <script src="assets/js/config.js"></script>
  </head>

  <body>
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
      <div class="layout-container">
        <!-- Menu -->

        <?php include("su_left_menu.php"); ?>
        
        <!-- / Menu -->

        <!-- Layout container -->
        <div class="layout-page">
          <!-- Navbar -->

          <?php include("top_menu.php"); ?>

          <!-- / Navbar -->

          <!-- Content wrapper -->
          <div class="content-wrapper">
            <!-- Content -->

            <div class="container-xxl flex-grow-1 container-p-y">
              <div class="row gy-6">
               
               
                

                <!-- Data Tables -->
                <div class="col-12">
                  <div class="card overflow-hidden">

                    <h5 class="card-header">Visit Plans</h5>
                    <div class="table-responsive">
                      <table class="table table-sm">
                        <?php
                          $query = $db->prepare("SELECT * FROM visit_plan WHERE uid =? ORDER BY vpid DESC");
                          $query->execute(array($_COOKIE['sup']));  
                          $num_store = $query->rowCount();
                        ?>
                        <thead>
                          <tr>
                            <th class="text-truncate">Visit Date</th>
                            <th class="text-truncate">Title</th>
                            <th class="text-truncate">Stores</th>
                            <th class="text-truncate">Visited</th>
                            <th class="text-truncate">Created On</th>
                            <th class="text-truncate">Status <input type="hidden" name="hdnStore" value="<?php echo($num_store); ?>"></th>
                          </tr>
                        </thead>
                        <tbody>
                          <?php
                            if($num_store > 0)
                            {
                                while($row = $query->fetch())
                                {
                                  $vpid = $row['vpid'];

                                  /// all stores
                                  $vpdquery1 = $db->prepare("SELECT * FROM visit_plan_detail WHERE vpid=?");
                                  $vpdquery1->execute(array($vpid));
                                  $num_stores = $vpdquery1->rowCount();

                                  /// visited  stores
                                  $vpdquery2 = $db->prepare("SELECT * FROM visit_plan_detail WHERE vpid=? AND visit_time!=?");
                                  $vpdquery2->execute(array($vpid,0));
                                  $num_visited_stores = $vpdquery2->rowCount();


                          ?>
                          <tr>
                            <td class="text-truncate"><?php echo(date("d-m-Y",$row['visit_date'])); ?></td>
                            <td class="text-truncate"><a href="su_plan_detail.php?vpid=<?php echo($row['vpid']); ?>"><?php echo($row['vptitle']); ?></a></td>
                            <th class="text-truncate"><?php echo($num_stores); ?></th>
                            <td class="text-truncate"><?php echo($num_visited_stores); ?></td>
                            <td class="text-truncate"><?php echo(date("d-m-Y h:i A",$row['vpdate'])); ?></td>
                            <td>
                              <?php if($row['vpstatus'] == 0){ ?>
                              <span class="badge bg-label-warning rounded-pill">Pending</span>
                              <?php }else{ ?>
                              <span class="badge bg-label-success rounded-pill">Completed</span>
                              <?php } ?>
                            </td>
                          </tr>
                          <?php
                                }
                            }
                            else{
                          ?>
                          <tr><td>No Plans Created Yet</td></tr>
                          <?php    
                            }    
                          ?>
                        </tbody>
                      </table>
                    </div>
                  </div>
                </div>
                <!--/ Data Tables -->
              </div>
            </div>
            <!-- / Content -->

            <footer class="content-footer footer bg-footer-theme">
              <div class="container-xxl">
                <div
                  class="footer-container d-flex align-items-center justify-content-between py-4 flex-md-row flex-column">
                  <div class="text-body mb-12 mb-md-0">
                    ©
                    <script>
                      document.write(new Date().getFullYear());
                    </script>
                     - Sentient
                  </div>
                </div>
              </div>
            </footer>

            <div class="content-backdrop fade"></div>
          </div>
          <!-- Content wrapper -->
        </div>
        <!-- / Layout page -->
      </div>
      
      <!-- Overlay -->
      <div class="layout-overlay layout-menu-toggle"></div>
    </div>
    <!-- / Layout wrapper -->
    
    
    <!-- Core JS -->
    <!-- build:js assets/vendor/js/core.js -->
    <script src="assets/vendor/libs/jquery/jquery.js"></script>
    <script src="assets/vendor/libs/popper/popper.js"></script>
    <script src="assets/vendor/js/bootstrap.js"></script>
    <script src="assets/vendor/libs/node-waves/node-waves.js"></script>
    <script src="assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js"></script>
    <script src="assets/vendor/js/menu.js"></script>

    <!-- endbuild -->

    <!-- Vendors JS -->
    <script src="assets/vendor/libs/apex-charts/apexcharts.js"></script>

    <!-- Main JS -->
    <script src="assets/js/main.js"></script>

    <!-- Page JS -->
    <script src="assets/js/dashboards-analytics.js"></script>

    <!-- Place this tag before closing body tag for github widget button. -->
    <script async defer src="https://buttons.github.io/buttons.js"></script>
  </body>
</html>
