<?php  
  require_once("includes/functions.php");
  include_once("includes/errors.php");
  sup_loggedin();
  //echo($_COOKIE['asid']);die;

?>
<!doctype html>

<html
  lang="en"
  class="light-style layout-menu-fixed layout-compact"
  dir="ltr"
  data-theme="theme-default"
  data-assets-path="assets/"
  data-template="vertical-menu-template-free"
  data-style="light">
  <head>
    <meta charset="utf-8" />
    <meta
      name="viewport"
      content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />

    <title>Sentient App - Visit Detail</title>

    <meta name="description" content="" />

    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="assets/img/favicon/favicon.ico" />

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
      href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&ampdisplay=swap"
      rel="stylesheet" />

    <link rel="stylesheet" href="assets/vendor/fonts/remixicon/remixicon.css" />

    <!-- Menu waves for no-customizer fix -->
    <link rel="stylesheet" href="assets/vendor/libs/node-waves/node-waves.css" />

    <!-- Core CSS -->
    <link rel="stylesheet" href="assets/vendor/css/core.css" class="template-customizer-core-css" />
    <link rel="stylesheet" href="assets/vendor/css/theme-default.css" class="template-customizer-theme-css" />
    <link rel="stylesheet" href="assets/css/demo.css" />

    <!-- Vendors CSS -->
    <link rel="stylesheet" href="assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.css" />
    <link rel="stylesheet" href="assets/vendor/libs/apex-charts/apex-charts.css" />

    <!-- Page CSS -->

    <!-- Helpers -->
    <script src="assets/vendor/js/helpers.js"></script>
    <!--! Template customizer & Theme config files MUST be included after core stylesheets and helpers.js in the <head> section -->
    <!--? Config:  Mandatory theme config file contain global vars & default theme options, Set your preferred theme option in this file.  -->
    <script src="assets/js/config.js"></script>
    <style>
      .img_container {
        position: relative;
      }

      .img_bottomright {
        position: absolute;
        bottom: 0px;
        right: 0px;
        font-size: 16px;
        color: white;
        padding: 5px;
      }

      .img_topleft {
        position: absolute;
        top: 0;
        left: 0;
        font-size: 110px;
        font-weight: bold;
        color: balck;
        padding: 5px;
      }

      img { 
        width: 70%;
        height: auto;
      }
    </style>
  </head>

  <body onload="return getLocation();">
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
      <div class="layout-container">
        <!-- Menu -->

        <?php include("su_left_menu.php"); ?>
        
        <!-- / Menu -->

        <!-- Layout container -->
        <div class="layout-page">
          <!-- Navbar -->

          <?php include("top_menu.php"); ?>

          <!-- / Navbar -->
          
          <!-- Content wrapper -->
          <div class="content-wrapper">
            <!-- Content -->
            <div class="container-xxl flex-grow-1 container-p-y">
              <!-- Basic Layout -->
              <?php
                  $vsquery = $db->prepare("SELECT VS.vid, VS.uid, VS.stid, VS.brid, VS.ba_uid, VS.sup_uid, VS.remarks, VS.attendance_code, VS.vlat, VS.vlong, VS.vimage, VS.post_date, BR.brid, BR.brname, US.uid, US.su_no, US.fullname, ST.stid, ST.store_code, ST.store_name, ST.city, ST.stlat, ST.stlong  FROM visits VS 
                              INNER JOIN brand BR ON VS.brid = BR.brid  
                              INNER JOIN users US ON VS.uid = US.uid  
                              INNER JOIN store ST ON VS.stid = ST.stid WHERE VS.vid=?");
                  $vsquery->execute(array($_REQUEST['id']));
                  while($vsrow = $vsquery->fetch())
                  {
                    $vid = $vsrow['vid'];
                    $uid = $vsrow['uid'];
                    $stid = $vsrow['stid'];
                    $brid = $vsrow['brid'];
                    $brname = $vsrow['brname'];
                    $vimage = $vsrow['vimage'];
                    $attendance_code = $vsrow['attendance_code'];
                    $ba_uid = $vsrow['ba_uid'];
                    
                    if($vsrow['post_date'] != 0) { $post_date = date("d-m-Y h:i A",$vsrow['post_date']); } else{ $post_date = "N/A"; }
                    //// get brand name

                    $store_name = $vsrow['store_name'].": ST-".$vsrow['store_code'];
                    $supervisor = $vsrow['fullname'].": SU-".$vsrow['su_no'];
                      
                    if($ba_uid == 0)
                    {
                      $ba_name = ""; 
                    }
                    else
                    {
                      $baquery = $db->prepare("SELECT uid, fullname FROM users WHERE uid = ?");
                      $baquery->execute(array($ba_uid));
                      while($barow = $baquery->fetch())
                      {
                        $ba_name = $barow['fullname']; 
                      }
                    }  

                    if($attendance_code == "")
                    {
                      $remarks = $vsrow['remarks']; 
                    }
                    else
                    {
                      $atquery = $db->prepare("SELECT attid, attendance_type, attendance_code FROM attendance_type WHERE attendance_code = ? ORDER BY attid ASC LIMIT 0,1");
                      $atquery->execute(array($attendance_code));
                      while($atrow = $atquery->fetch())
                      {
                        $remarks = $atrow['attendance_type']; 
                      }
                    }

                    $visit_date = date("d-m-Y H:i A",$vsrow['post_date']);
                    
                    $vlat = $vsrow['vlat'];
                    $vlong = $vsrow['vlong'];

                    $stlat = $vsrow['stlat'];
                    $stlong = $vsrow['stlong'];

                    $store_city = $vsrow['city'];
              ?>
              <div class="row">
                <div class="col-xl">
                  <div class="card mb-12">
                    <div class="card-header d-flex justify-content-between align-items-center">
                      <h5 class="mb-0"><?php echo(ucwords($store_name)); ?></h5>

                      <small class="text-body float-end"><?php echo(ucwords($store_city)); ?></small>

                    </div>

                    <div>
                      <?php if($vimage != ""){ ?>
                      <div class="img_container">
                          <img src="assets/uploads/su/<?php echo($vimage); ?>" style="width: 100%;">   
                          <div style="background-color: black; color: white;" class="img_bottomright">
                            <?php echo($ba_name); ?>
                            <br>
                            <?php echo(ucwords($brname)); ?>
                            <br>
                            Visit Date: <?php echo($visit_date); ?>
                          </div>
                      </div>
                      <?php }else{ ?>
                      <div class="img_container" style="background-color: lightgrey; width: 100%; height: 450px;">
                        <div class="img_topleft"><?php echo($attendance_code); ?></div>
                          <div style="background-color: black;" class="img_bottomright">
                            <h5><?php echo(ucwords($store_name)); ?></h5>
                            <h5><?php echo($ba_name); ?></h5>
                            <h5><?php echo($brname); ?></h5>
                          <h5>Visit Date: <?php echo($visit_date); ?></h5>
                          </div>

                      </div>
                      <?php } ?>  
                      <br>
                        &nbsp;
                        <?php echo($remarks); ?>
                    </div>

                   

                  </div>
                  
                </div>
                
              </div>
              <?php
                }
              ?>


            </div>
            <!-- / Content -->
            <footer class="content-footer footer bg-footer-theme">
              <div class="container-xxl">
                <div
                  class="footer-container d-flex align-items-center justify-content-between py-4 flex-md-row flex-column">
                  <div class="text-body mb-12 mb-md-0">
                    ©
                    <script>
                      document.write(new Date().getFullYear());
                    </script>
                     - Sentient
                  </div>
                </div>
              </div>
            </footer>

        </div>
        <!-- / Layout page -->
      </div>

      <!-- Overlay -->
      <div class="layout-overlay layout-menu-toggle"></div>
    </div>
    <!-- / Layout wrapper -->

    <script>
        const x = document.getElementById("demo");
        
        function getLocation() {
          if (navigator.geolocation) {
            navigator.geolocation.getCurrentPosition(showPosition);
          } else { 
            x.innerHTML = "Geolocation is not supported by this browser.";
          }

          var lat   = document.Form.elements['hdnlat'].value;
          var long   = document.Form.elements['hdnlong'].value;
          
          alert(lat);return false; 
        }
        
        function showPosition(position) {
          x.innerHTML = "<br><b>Your Current Position: Lat: "+ position.coords.latitude +" | Long: " + position.coords.longitude +"  <input type='hidden' name='hdnlat' value='" + position.coords.latitude +"'> <input type='hidden' name='hdnlong' value='" + position.coords.longitude +"'>";
        }


    </script>
    
    <!-- Core JS -->
    <!-- build:js assets/vendor/js/core.js -->
    <script src="assets/vendor/libs/jquery/jquery.js"></script>
    <script src="assets/vendor/libs/popper/popper.js"></script>
    <script src="assets/vendor/js/bootstrap.js"></script>
    <script src="assets/vendor/libs/node-waves/node-waves.js"></script>
    <script src="assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js"></script>
    <script src="assets/vendor/js/menu.js"></script>

    <!-- endbuild -->

    <!-- Vendors JS -->
    <script src="assets/vendor/libs/apex-charts/apexcharts.js"></script>

    <!-- Main JS -->
    <script src="assets/js/main.js"></script>

    <!-- Page JS -->
    <script src="assets/js/dashboards-analytics.js"></script>

    <!-- Place this tag before closing body tag for github widget button. -->
    <script async defer src="https://buttons.github.io/buttons.js"></script>
    <script>

        document.Form.elements['btnSubmit'].disabled = true; 
       

        function resizeImage(file, maxWidth, maxHeight, callback) {
            const reader = new FileReader();
            reader.readAsDataURL(file);
            
            reader.onload = function(event) {
                const img = new Image();
                img.src = event.target.result;
                
                img.onload = function() {
                    const canvas = document.createElement('canvas');
                    let width = img.width;
                    let height = img.height;
                    
                    if (width > maxWidth || height > maxHeight) {
                        if (width > height) {
                            height *= maxWidth / width;
                            width = maxWidth;
                        } else {
                            width *= maxHeight / height;
                            height = maxHeight;
                        }
                    }
                    
                    canvas.width = width;
                    canvas.height = height;
                    const ctx = canvas.getContext('2d');
                    ctx.drawImage(img, 0, 0, width, height);
                    
                    canvas.toBlob((blob) => {
                        callback(blob, canvas.toDataURL());
                    }, file.type);
                };
            };
        }

        document.getElementById("uploadForm").addEventListener("submit", function(event) {
            event.preventDefault(); // Prevent the default form submission

            const fileInput = document.getElementById("imageUpload");
            const file = fileInput.files[0];

            if (file) {
                resizeImage(file, 800, 600, function(resizedBlob, imageDataUrl) {
                    document.getElementById("previewImage").src = imageDataUrl;
                    document.getElementById("previewImage").style.display = "block";

                    const formData = new FormData();
                    formData.append("image", resizedBlob, file.name);
                    
                    fetch("su_visit_upload.php?t=<?php echo($_REQUEST['t']); ?>", {
                        method: "POST",
                        body: formData
                    }).then(response => response.text())
                      .then(data => console.log(data))
                      .catch(error => console.error("Error:", error));

                      document.Form.elements['btnSubmit'].disabled = false; 
        
                });
            } else {
                alert("Please select an image!");
            }
        });
    </script>
  </body>
</html>
