<?php  
  require_once("includes/functions.php");
  include_once("includes/errors.php");
  sup_loggedin();
  //echo($_COOKIE['asid']);die;

  if(isset($_REQUEST['btnReturn']))
  {
      header("Location: su_visit_plans.php");
  }
?>
<!doctype html>

<html
  lang="en"
  class="light-style layout-menu-fixed layout-compact"
  dir="ltr"
  data-theme="theme-default"
  data-assets-path="assets/"
  data-template="vertical-menu-template-free"
  data-style="light">
  <head>
    <meta charset="utf-8" />
    <meta
      name="viewport"
      content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />

    <title>Sentient App - Visit Plan Detail</title>

    <meta name="description" content="" />

    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="assets/img/favicon/favicon.ico" />

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
      href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&ampdisplay=swap"
      rel="stylesheet" />

    <link rel="stylesheet" href="assets/vendor/fonts/remixicon/remixicon.css" />

    <!-- Menu waves for no-customizer fix -->
    <link rel="stylesheet" href="assets/vendor/libs/node-waves/node-waves.css" />

    <!-- Core CSS -->
    <link rel="stylesheet" href="assets/vendor/css/core.css" class="template-customizer-core-css" />
    <link rel="stylesheet" href="assets/vendor/css/theme-default.css" class="template-customizer-theme-css" />
    <link rel="stylesheet" href="assets/css/demo.css" />

    <!-- Vendors CSS -->
    <link rel="stylesheet" href="assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.css" />
    <link rel="stylesheet" href="assets/vendor/libs/apex-charts/apex-charts.css" />

    <!-- Ajax -->
    <script src="ajax/ajaxfunctions.js"></script>

    <!-- Page CSS -->

    <!-- Helpers -->
    <script src="assets/vendor/js/helpers.js"></script>
    <!--! Template customizer & Theme config files MUST be included after core stylesheets and helpers.js in the <head> section -->
    <!--? Config:  Mandatory theme config file contain global vars & default theme options, Set your preferred theme option in this file.  -->
    <script src="assets/js/config.js"></script>

    <script type="text/javascript" language="javascript">
     function update_status(id1,id2,num)
      {
        var cd;
        cd = confirm("Are you sure to update visit status?");
        if(cd)
        {
          // var lat   = document.Form.elements['hdnlat'].value;
          // var long   = document.Form.elements['hdnlong'].value;

          var lat   = "1000";
          var long   = "250";
          var url       = "update_plan_status.php?num="+num+"&id1="+id1+"&id2="+id2+"&lat="+lat+"&long="+long;
          var containerid = "showStatus"+num;
          return GetPage(url, containerid);
        }
      }  
  </script>
  </head>

  <body onload="return getLocation();">
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
      <div class="layout-container">
        <!-- Menu -->

        <?php include("su_left_menu.php"); ?>
        
        <!-- / Menu -->

        <!-- Layout container -->
        <div class="layout-page">
          <!-- Navbar -->

          <?php include("top_menu.php"); ?>

          <!-- / Navbar -->
          <form name="Form" method="post">
          <!-- Content wrapper -->
          <div class="content-wrapper">
            <!-- Content -->
            <div class="container-xxl flex-grow-1 container-p-y">
              <!-- Basic Layout -->
              <div class="row">
                <div class="col-xl">
                  <div class="card mb-12">
                    <div class="card-header d-flex justify-content-between align-items-center">
                      <h5 class="mb-0">Visit Detail</h5>
                      <small class="text-body float-end">Supervisor Plan</small>
                    </div>
                    <div class="card-body">
                        <?php
                          $vpquery = $db->prepare("SELECT * FROM visit_plan WHERE vpid = ?");
                          $vpquery->execute(array($_REQUEST['vpid']));
                          while($vprow = $vpquery->fetch())
                          {
                        ?>   
                        <div class="form-floating form-floating-outline mb-6">
                          <b>Visit Date:</b> <?php echo(date("d-m-Y",$vprow['visit_date'])); ?>
                        </div>                 
                        <div class="form-floating form-floating-outline mb-6">
                          <b>Title:</b> <?php echo($vprow['vptitle']); ?>
                        </div>
                        <div class="form-floating form-floating-outline mb-6">
                          <textarea
                            id="basic-default-description" name="txtDescription"
                            class="form-control"
                            placeholder="Plan description goes here"
                            style="height: 60px"><?php echo($vprow['vpdescription']); ?></textarea>
                          <label for="basic-default-description">Remarks</label>
                        </div>
                        
                        <div class="form-floating form-floating-outline mb-6">
                          <b>Created On:</b> <?php echo(date("d-m-Y h:i A",$vprow['vpdate'])); ?>
                        </div>
                        <div class="form-floating form-floating-outline mb-6">
                          <div id="demo"></div>
                        </div>

                        
                        
                        <button type="submit" name="btnReturn" class="btn btn-danger">Return Back</button>
                        <?php
                          }
                        ?>
                    </div>
                  </div>


                  <div class="row gy-6">
               
               
                

                <!-- Data Tables -->
                <div class="col-12">
                  <div class="card overflow-hidden">

                    <h5 class="card-header">Visiting Stores</h5>
                    <div class="table-responsive">
                      <table class="table table-sm">
                        <?php
                            $stquery = $db->prepare("SELECT VPD.vpdid, VPD.vpid, VPD.uid, VPD.stid, VPD.brid, VPD.vpdstatus, VPD.visit_time, VPD.vpddate, ST.stid, ST.store_code, ST.store_name, ST.city, BR.brid, BR.brname FROM visit_plan_detail VPD INNER JOIN store ST ON VPD.stid = ST.stid INNER JOIN brand BR ON VPD.brid = BR.brid WHERE VPD.vpid=?");
                            $stquery->execute(array($_REQUEST['vpid']));
                            $num_store = $stquery->rowCount();
                        ?>
                        <thead>
                          <tr>
                            <th class="text-truncate">Sr.</th>
                            <th class="text-truncate">Store</th>
                            <th class="text-truncate">City</th>
                            <th class="text-truncate">Brand</th>
                            <th class="text-truncate">Status <input type="hidden" name="hdnStore" value="<?php echo($num_store); ?>"></th>
                          </tr>
                        </thead>
                        <tbody>
                          <?php
                            $count = 0;
                            while($strow = $stquery->fetch())
                            {
                              $count++;
                          ?>
                          <tr>
                            <td class="text-truncate"><?php echo($count); ?>. </td>
                            <td class="text-truncate">
                              ST-<?php echo($strow['store_code']); ?> <?php echo($strow['store_name']); ?>
                              <input type="hidden" name="hdnStid<?php echo($count); ?>" value="<?php echo($strow['stid']); ?>">  
                            </td>
                            <th class="text-truncate"><?php echo($strow['city']) ?></th>
                            <td class="text-truncate"><?php echo($strow['brname']) ?></td>
                            <td class="text-truncate">
                              <div id="showStatus<?php echo($count); ?>">
                                <?php
                                  if($strow['visit_time'] == 0){
                                ?>
                                <a href="#" onclick="return update_status(<?php echo($strow['vpid']); ?>,<?php echo($strow['vpdid']); ?>,<?php echo($count); ?>)"><span class="badge bg-label-danger rounded-pill">Visit Pending</span></a>
                                <?php }else{ ?>
                                <span class="badge bg-label-success rounded-pill">Visited On: <?php echo(date("d-m-Y h:i A",$strow['visit_time'])); ?></span>
                                <?php } ?>
                              </div>
                            </td>
                          </tr>
                          <?php
                            }
                          ?>
                        </tbody>
                      </table>
                    </div>
                  </div>
                </div>
                <!--/ Data Tables -->
              </div>

                </div>
                
              </div>
            </div>
            </form>
            <!-- / Content -->
            <footer class="content-footer footer bg-footer-theme">
              <div class="container-xxl">
                <div
                  class="footer-container d-flex align-items-center justify-content-between py-4 flex-md-row flex-column">
                  <div class="text-body mb-12 mb-md-0">
                    ©
                    <script>
                      document.write(new Date().getFullYear());
                    </script>
                     - Sentient
                  </div>
                </div>
              </div>
            </footer>

        </div>
        <!-- / Layout page -->
      </div>
      <script>
          const x = document.getElementById("demo");
          
          function getLocation() {
            if (navigator.geolocation) {
              navigator.geolocation.getCurrentPosition(showPosition);
            } else { 
              x.innerHTML = "Geolocation is not supported by this browser.";
            }

            var lat   = document.Form.elements['hdnlat'].value;
            var long   = document.Form.elements['hdnlong'].value;
            
            //alert(lat);return false; 
          }
          
          function showPosition(position) {
            x.innerHTML = "<b>Your Current Position</b> Lat: "+ position.coords.latitude +" | Long: " + position.coords.longitude +"  <input type='hidden' name='hdnlat' value='" + position.coords.latitude +"'> <input type='hidden' name='hdnlong' value='" + position.coords.longitude +"'>";
          }


      </script>
      <!-- Overlay -->
      <div class="layout-overlay layout-menu-toggle"></div>
    </div>
    <!-- / Layout wrapper -->

    
    <!-- Core JS -->
    <!-- build:js assets/vendor/js/core.js -->
    <script src="assets/vendor/libs/jquery/jquery.js"></script>
    <script src="assets/vendor/libs/popper/popper.js"></script>
    <script src="assets/vendor/js/bootstrap.js"></script>
    <script src="assets/vendor/libs/node-waves/node-waves.js"></script>
    <script src="assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js"></script>
    <script src="assets/vendor/js/menu.js"></script>

    <!-- endbuild -->

    <!-- Vendors JS -->
    <script src="assets/vendor/libs/apex-charts/apexcharts.js"></script>

    <!-- Main JS -->
    <script src="assets/js/main.js"></script>

    <!-- Page JS -->
    <script src="assets/js/dashboards-analytics.js"></script>

    <!-- Place this tag before closing body tag for github widget button. -->
    <script async defer src="https://buttons.github.io/buttons.js"></script>
  </body>
</html>
