<?php  
  require_once("includes/functions.php");
  include_once("includes/errors.php");
  sup_loggedin();
  //echo($_COOKIE['asid']);die;
?>
<!doctype html>

<html
  lang="en"
  class="light-style layout-menu-fixed layout-compact"
  dir="ltr"
  data-theme="theme-default"
  data-assets-path="assets/"
  data-template="vertical-menu-template-free"
  data-style="light">
  <head>
    <meta charset="utf-8" />
    <meta
      name="viewport"
      content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />

    <title>Sentient App - Dashboard</title>

    <meta name="description" content="" />

    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="assets/img/favicon/favicon.ico" />

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
      href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&ampdisplay=swap"
      rel="stylesheet" />

    <link rel="stylesheet" href="assets/vendor/fonts/remixicon/remixicon.css" />

    <!-- Menu waves for no-customizer fix -->
    <link rel="stylesheet" href="assets/vendor/libs/node-waves/node-waves.css" />

    <!-- Core CSS -->
    <link rel="stylesheet" href="assets/vendor/css/core.css" class="template-customizer-core-css" />
    <link rel="stylesheet" href="assets/vendor/css/theme-default.css" class="template-customizer-theme-css" />
    <link rel="stylesheet" href="assets/css/demo.css" />

    <!-- Vendors CSS -->
    <link rel="stylesheet" href="assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.css" />
    <link rel="stylesheet" href="assets/vendor/libs/apex-charts/apex-charts.css" />

    <!-- Page CSS -->
    <style>
      #loader {
        position: fixed;
        z-index: 9999;
        background: white;
        width: 100%;
        height: 100%;
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
      }
      body.loaded #loader {
        opacity: 0;
        visibility: hidden;
        transition: opacity 0.5s ease-out;
      }
      .progress {
        width: 50%;
        height: 20px;
      }
    </style>
    <!-- Page CSS -->

    <!-- Helpers -->
    <script src="assets/vendor/js/helpers.js"></script>
    <!--! Template customizer & Theme config files MUST be included after core stylesheets and helpers.js in the <head> section -->
    <!--? Config:  Mandatory theme config file contain global vars & default theme options, Set your preferred theme option in this file.  -->
    <script src="assets/js/config.js"></script>
  </head>

  <body>
     <!-- Loader -->
    <div id="loader">
      <h5>Loading, please wait...</h5>
      <div class="progress mt-3">
        <div id="progress-bar" class="progress-bar progress-bar-striped progress-bar-animated bg-primary" role="progressbar" style="width: 0%"></div>
      </div>
    </div>
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
      <div class="layout-container">
        <!-- Menu -->

        <?php include("su_left_menu.php"); ?>
        
        <!-- / Menu -->

        <!-- Layout container -->
        <div class="layout-page">
          <!-- Navbar -->

          <?php include("top_menu.php"); ?>

          <!-- / Navbar -->

          <!-- Content wrapper -->
          <div class="content-wrapper">
            <!-- Content -->

            <div class="container-xxl flex-grow-1 container-p-y">
              <div class="row gy-6">
               
                <!-- Transactions -->
                <div class="col-lg-12">
                  <div class="card h-100">
                    <div class="card-header">
                      <div class="d-flex align-items-center justify-content-between">
                        <h5 class="card-title m-0 me-2">Supervisor Dashboard</h5>
                      </div>
                    </div>
                    <div class="card-body pt-lg-10">
                      <div class="row g-6">
                        <div class="col-md-3 col-6">
                          <div class="d-flex align-items-center">
                            <div class="avatar">
                              <a href="su_attendance.php">
                              <div class="avatar-initial bg-primary rounded shadow-xs">
                                <i class="ri-survey-line ri-24px"></i>
                              </div>
                              </a>
                            </div>
                            <div class="ms-3">
                              <a href="su_attendance.php">
                                <p class="mb-0">Attendance</p>
                              </a>
                            </div>
                          </div>
                        </div>
                        <div class="col-md-3 col-6">
                          <div class="d-flex align-items-center">
                            <div class="avatar">
                              <a href="su_visit_stores.php">
                              <div class="avatar-initial bg-success rounded shadow-xs">
                                <i class="ri-store-line ri-24px"></i>
                              </div>
                              </a>
                            </div>
                            <div class="ms-3">
                              <a href="su_visit_stores.php"><p class="mb-0">Store Visit</p></a>
                            </div>
                          </div>
                        </div>
                        <div class="col-md-3 col-6">
                          <div class="d-flex align-items-center">
                            <div class="avatar">
                              <a href="su_create_visit_store.php?t=<?php echo(time()); ?>">
                              <div class="avatar-initial bg-warning rounded shadow-xs">
                                <i class="ri-pencil-line ri-24px"></i>
                              </div>
                              </a>
                            </div>
                            <div class="ms-3">
                              <a href="su_create_visit_store.php?t=<?php echo(time()); ?>"><p class="mb-0">Create Visit</p></a>
                            </div>
                          </div>
                        </div>
                        <div class="col-md-3 col-6">
                          <div class="d-flex align-items-center">
                            <div class="avatar">
                              <a href="su_update_profile.php">
                              <div class="avatar-initial bg-info rounded shadow-xs">
                                <i class="ri-profile-line ri-24px"></i>
                              </div>
                              </a>
                            </div>
                            <div class="ms-3">
                              <a href="su_update_profile.php">
                                <p class="mb-0">Update Profile</p>
                              </a>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
                <!--/ Transactions -->

              
            
              
            
                

                <!-- Data Tables -->
                <div class="col-12">
                  
                  <?php
                    $asquery = $db->prepare("SELECT ASS.asid, ASS.stid, ASS.supuid, ASS.asstatus, ST.stid, ST.store_name, ST.city FROM assignments ASS 
                                      INNER JOIN store ST ON ASS.stid = ST.stid 
                                      WHERE ASS.supuid=? AND ASS.asstatus=? LIMIT 0,10");
                    $asquery->execute(array($_COOKIE['sup'],0));
                    while($asrow = $asquery->fetch())
                    {
                      $asid = $asrow['asid'];
                  ?>
                  <br>
                  <h6><?php echo($asrow['store_name']); ?>, <?php echo($asrow['city']); ?></h6>
                  <div class="card overflow-hidden">
                     <div class="table-responsive">
                      <table class="table table-sm">
                        <thead>
                          <tr>
                            <th class="text-truncate">Date</th>
                            <th class="text-truncate">BA Name</th>
                            <th class="text-truncate">Total Sale</th>
                            <th class="text-truncate">Qty Status</th>
                            <th class="text-truncate">Price Status</th>
                            <th class="text-truncate">Sale Status</th>
                          </tr>
                        </thead>
                        <tbody>
                          <?php
                              $current_date = date("d-m-Y");
                              $aslquery = $db->prepare("SELECT ASL.assid, ASL.uid, ASL.asid, ASL.sale_date, SUM(sale_qty) AS total_sale, US.uid, US.fullname, US.ba_no FROM assignment_sale ASL INNER JOIN users US ON ASL.uid = US.uid WHERE ASL.asid = ?  GROUP BY ASL.sale_date ORDER BY ASL.assid DESC LIMIT 0,5");
                              $aslquery->execute(array($asid));
                              while($aslrow = $aslquery->fetch())
                              {
                                  $sale_date = $aslrow['sale_date'];
                                  $uid = $aslrow['uid'];

                                  $uaquery = $db->prepare("SELECT * FROM user_attendance WHERE uid = ? AND attendance_date = ?");
                                  $uaquery->execute(array($uid,$sale_date));
                                  while($uarow = $uaquery->fetch())
                                  {
                                      if($current_date == $sale_date)
                                      {
                                          if($uarow['stock_status'] == 0)
                                          {
                                              $qty_status_1 = "warning";
                                              $qty_status_2 = "Pending";  
                                          }
                                          else
                                          {
                                            $qty_status_1 = "success";
                                            $qty_status_2 = "Completed";
                                          }

                                          if($uarow['price_status'] == 0)
                                          {
                                              $price_status_1 = "warning";
                                              $price_status_2 = "Pending";  
                                          }
                                          else
                                          {
                                            $price_status_1 = "success";
                                            $price_status_2 = "Completed";
                                          } 

                                          if($uarow['sale_status'] == 0)
                                          {
                                              $sale_status_1 = "warning";
                                              $sale_status_2 = "Pending";  
                                          }
                                          else
                                          {
                                            $sale_status_1 = "success";
                                            $sale_status_2 = "Completed";
                                          } 
                                      }
                                      else
                                      {
                                        if($uarow['stock_status'] == 0)
                                        {
                                            $qty_status_1 = "danger";
                                            $qty_status_2 = "Incomplete";  
                                        }
                                        else
                                        {
                                          $qty_status_1 = "success";
                                          $qty_status_2 = "Completed";
                                        }

                                        if($uarow['price_status'] == 0)
                                        {
                                            $price_status_1 = "danger";
                                            $price_status_2 = "Incomplete";  
                                        }
                                        else
                                        {
                                          $price_status_1 = "success";
                                          $price_status_2 = "Completed";
                                        }

                                        if($uarow['sale_status'] == 0)
                                        {
                                            $sale_status_1 = "danger";
                                            $sale_status_2 = "Incomplete";  
                                        }
                                        else
                                        {
                                          $sale_status_1 = "success";
                                          $sale_status_2 = "Completed";
                                        }
                                      }
                                  }
                          ?>
                          <tr>
                            <td class="text-truncate"><a href="su_sale_detail.php?uid=<?php echo($aslrow['uid']); ?>&sale_date=<?php echo($aslrow['sale_date']); ?>"><?php echo($aslrow['sale_date']); ?></a></td>
                            <td class="text-truncate">BA-<?php echo($aslrow['ba_no']); ?> <?php echo($aslrow['fullname']); ?></td>
                            <td class="text-truncate"><?php echo($aslrow['total_sale']); ?></td>
                            <td><span class="badge bg-label-<?php echo($qty_status_1); ?> rounded-pill"><?php echo($qty_status_2); ?></span></td>
                            <td><span class="badge bg-label-<?php echo($price_status_1); ?> rounded-pill"><?php echo($price_status_2); ?></span></td>
                            <td><span class="badge bg-label-<?php echo($sale_status_1); ?> rounded-pill"><?php echo($sale_status_2); ?></span></td>
                          </tr>
                          <?php
                              }
                          ?>
                        </tbody>
                      </table>
                    </div>
                  </div>
                  <?php } ?>
                </div>
                <!--/ Data Tables -->
              </div>
            </div>
            <!-- / Content -->

            <footer class="content-footer footer bg-footer-theme">
              <div class="container-xxl">
                <div
                  class="footer-container d-flex align-items-center justify-content-between py-4 flex-md-row flex-column">
                  <div class="text-body mb-12 mb-md-0">
                    ©
                    <script>
                      document.write(new Date().getFullYear());
                    </script>
                     - Sentient
                  </div>
                </div>
              </div>
            </footer>

            <div class="content-backdrop fade"></div>
          </div>
          <!-- Content wrapper -->
        </div>
        <!-- / Layout page -->
      </div>

      <!-- Overlay -->
      <div class="layout-overlay layout-menu-toggle"></div>
    </div>
    <!-- / Layout wrapper -->

    
    <!-- Core JS -->
    <!-- build:js assets/vendor/js/core.js -->
    <script src="assets/vendor/libs/jquery/jquery.js"></script>
    <script src="assets/vendor/libs/popper/popper.js"></script>
    <script src="assets/vendor/js/bootstrap.js"></script>
    <script src="assets/vendor/libs/node-waves/node-waves.js"></script>
    <script src="assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js"></script>
    <script src="assets/vendor/js/menu.js"></script>

    <!-- endbuild -->

    <!-- Vendors JS -->
    <script src="assets/vendor/libs/apex-charts/apexcharts.js"></script>

    <!-- Main JS -->
    <script src="assets/js/main.js"></script>

    <!-- Page JS -->
    <script src="assets/js/dashboards-analytics.js"></script>

    <!-- Place this tag before closing body tag for github widget button. -->
    <script async defer src="https://buttons.github.io/buttons.js"></script>
    
    <script>
      // Simulate progress bar loading
      let progress = 0;
      const progressBar = document.getElementById('progress-bar');
      const interval = setInterval(() => {
        progress += 1;
        progressBar.style.width = progress + '%';
        if (progress >= 100) {
          clearInterval(interval);
          document.body.classList.add('loaded');
        }
      }, 30); // Adjust speed here
    </script>
  </body>
</html>
