<?php  
  require_once("includes/functions.php");
  include_once("includes/errors.php");
  sup_loggedin();
  //echo($_COOKIE['asid']);die;
  //http://localhost/sentient/ba_app/su_create_visit_store.php?t=1760964737&store=101,%204,%20365,%20544,%20167&hdnlat=31.5891584&hdnlong=74.4664727&ver=1
  if(isset($_REQUEST['btnSubmit']))
  {
      if($_REQUEST['hdnDist'] <= 200 )
      {
          create_visit_store($db,$URL,$_REQUEST['t']);  
      }
      else
      {
          header("Location: su_create_visit_store.php?t=".$_REQUEST['t']."&store=".$_REQUEST['store']."&hdnlat=".$_REQUEST['hdnlat']."&hdnlong=".$_REQUEST['hdnlong']."&ver=1&v=2");
      }
  }

  if(isset($_REQUEST['ver']))
  {
      $arr = explode(',', $_REQUEST['store']);
      $stid = $arr[0];
      $brid = $arr[1];
      $ba_uid = $arr[2];
      $sup_uid = $arr[3];
      $as_asid = $arr[4];

      $user_lat = $_REQUEST['hdnlat'];
      $user_long = $_REQUEST['hdnlong'];

      /**
       * Calculates the great-circle distance between two points, with
       * the Haversine formula.
       * @param float $latitudeFrom Latitude of start point in [deg decimal]
       * @param float $longitudeFrom Longitude of start point in [deg decimal]
       * @param float $latitudeTo Latitude of target point in [deg decimal]
       * @param float $longitudeTo Longitude of target point in [deg decimal]
       * @param float $earthRadius Mean earth radius in [m]
       * @return float Distance between points in [m] (same as earthRadius)
       */
      function haversineGreatCircleDistance($latitudeFrom, $longitudeFrom, $latitudeTo, $longitudeTo, $earthRadius = 6371000)
      {
        // convert from degrees to radians
        $latFrom = deg2rad($latitudeFrom);
        $lonFrom = deg2rad($longitudeFrom);
        $latTo = deg2rad($latitudeTo);
        $lonTo = deg2rad($longitudeTo);

        $latDelta = $latTo - $latFrom;
        $lonDelta = $lonTo - $lonFrom;

        $angle = 2 * asin(sqrt(pow(sin($latDelta / 2), 2) +
          cos($latFrom) * cos($latTo) * pow(sin($lonDelta / 2), 2)));
        return $angle * $earthRadius;
      }


      $stquery = $db->prepare("SELECT * FROM store WHERE stid = ?");
      $stquery->execute(array($stid));
      while($strow = $stquery->fetch())
      {
          $stlat = $strow['stlat'];
          $stlong = $strow['stlong'];
      }

      $meter_distance = haversineGreatCircleDistance($user_lat, $user_long, $stlat, $stlong, $earthRadius = 6371000);

      $store_distance = round($meter_distance);
  }
  else
  {
      $stid = 0;
      $as_asid = 0;
      $store_distance = 500;
  }
?>
<!doctype html>

<html
  lang="en"
  class="light-style layout-menu-fixed layout-compact"
  dir="ltr"
  data-theme="theme-default"
  data-assets-path="assets/"
  data-template="vertical-menu-template-free"
  data-style="light">
  <head>
    <meta charset="utf-8" />
    <meta
      name="viewport"
      content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />

    <title>Sentient App - Create Visit Store</title>

    <meta name="description" content="" />

    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="assets/img/favicon/favicon.ico" />

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
      href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&ampdisplay=swap"
      rel="stylesheet" />

    <link rel="stylesheet" href="assets/vendor/fonts/remixicon/remixicon.css" />

    <!-- Menu waves for no-customizer fix -->
    <link rel="stylesheet" href="assets/vendor/libs/node-waves/node-waves.css" />

    <!-- Core CSS -->
    <link rel="stylesheet" href="assets/vendor/css/core.css" class="template-customizer-core-css" />
    <link rel="stylesheet" href="assets/vendor/css/theme-default.css" class="template-customizer-theme-css" />
    <link rel="stylesheet" href="assets/css/demo.css" />

    <!-- Vendors CSS -->
    <link rel="stylesheet" href="assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.css" />
    <link rel="stylesheet" href="assets/vendor/libs/apex-charts/apex-charts.css" />

    <!-- Page CSS -->
    <style>
      #loader {
        position: fixed;
        z-index: 9999;
        background: white;
        width: 100%;
        height: 100%;
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
      }
      body.loaded #loader {
        opacity: 0;
        visibility: hidden;
        transition: opacity 0.5s ease-out;
      }
      .progress {
        width: 50%;
        height: 20px;
      }
    </style>
    <!-- Page CSS -->

    <!-- Helpers -->
    <script src="assets/vendor/js/helpers.js"></script>
    <!--! Template customizer & Theme config files MUST be included after core stylesheets and helpers.js in the <head> section -->
    <!--? Config:  Mandatory theme config file contain global vars & default theme options, Set your preferred theme option in this file.  -->
    <script src="assets/js/config.js"></script>

    <script>
      function calc_distance()
      {
        //alert("moHSIN");return false;
        var store     = document.Form.elements['cboStore'].value;
        var hdnlat     = document.Form.elements['hdnlat'].value;
        var hdnlong     = document.Form.elements['hdnlong'].value;
        var hdnt     = document.Form.elements['hdnt'].value;
        window.location.replace("su_create_visit_store.php?t="+hdnt+"&store="+store+"&hdnlat="+hdnlat+"&hdnlong="+hdnlong+"&ver=1");
      }

      function rest_data()
      {
        //alert("moHSIN");return false;
        var hdnt     = document.Form.elements['hdnt'].value;
        window.location.replace("su_create_visit_store.php?t="+hdnt);
      }

    </script>
  </head>

  <body onload="return getLocation();">
      <!-- Loader -->
    <div id="loader">
      <h5>Loading, please wait...</h5>
      <div class="progress mt-3">
        <div id="progress-bar" class="progress-bar progress-bar-striped progress-bar-animated bg-primary" role="progressbar" style="width: 0%"></div>
      </div>
    </div>
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
      <div class="layout-container">
        <!-- Menu -->

        <?php include("su_left_menu.php"); ?>
        
        <!-- / Menu -->

        <!-- Layout container -->
        <div class="layout-page">
          <!-- Navbar -->

          <?php include("top_menu.php"); ?>

          <!-- / Navbar -->
          
          <!-- Content wrapper -->
          <div class="content-wrapper">
            <!-- Content -->
            <div class="container-xxl flex-grow-1 container-p-y">
              <!-- Basic Layout -->
              <div class="row">
                <div class="col-xl">
                  <div class="card mb-12">
                    <div class="card-header d-flex justify-content-between align-items-center">
                      <h5 class="mb-0">Create Visit</h5>

                      <small class="text-body float-end">Supervisor Plan</small>

                    </div>
                    <div class="card-body">
                        <?php
                            $vmquery = $db->prepare("SELECT vmid, vimage, vimage_date FROM visit_image WHERE vimage_date = ? ORDER BY vmid DESC LIMIT 0,1");
                            $vmquery->execute(array($_REQUEST['t']));
                            $num_img = $vmquery->rowCount();
                            if($num_img == 0)
                            {
                        ?>
                        <div class="form-floating form-floating-outline mb-6">
                          <img id="previewImage" style="display: none; max-width: 250px; height: auto;"> 
                          <form id="uploadForm">
                              <table>
                                <tr>
                                  <td>
                                    <input class="form-control" type="file"  id="imageUpload" accept="image/*" capture="camera" />
                                    <input type="hidden" name="hdnt" value="<?php echo($_REQUEST['t']); ?>">
                                  </td>
                                </tr>
                                <tr>
                                    <td><button type="submit" name="btnimage" class="btn btn-primary d-grid w-100" type="submit">Upload Selfie</button></td>
                                </tr>
                                <tr>
                                  <td align="left"><small style="color:red;">Note: image upload is required</small></td>
                                </tr>
                              </table>
                          </form>
                        </div>
                        <?php
                            }
                            else
                            {
                                while($vmrow = $vmquery->fetch())
                                {
                        ?>
                        <div class="form-floating form-floating-outline mb-6">
                          <img id="previewImage" style="max-width: 250px; height: auto;" src="assets/uploads/su/<?php echo($vmrow['vimage']); ?>"> 
                          <form id="uploadForm">
                              <table>
                                <tr>
                                  <td>
                                    <input class="form-control" type="file"  id="imageUpload" accept="image/*" capture="camera" />
                                    <input type="hidden" name="hdnt" value="<?php echo($_REQUEST['t']); ?>">
                                  </td>
                                </tr>
                                <tr>
                                    <td><button type="submit" name="btnimage" class="btn btn-primary d-grid w-100" type="submit">Upload Selfie</button></td>
                                </tr>
                                <tr>
                                  <td align="left"><small style="color:red;">Note: image upload is required</small></td>
                                </tr>
                              </table>
                          </form>
                        </div>
                        <?php          
                                } 
                            }
                        ?>
                        <form name="Form" id="Form" method="post">
                        <div class="form-floating form-floating-outline mb-6">
                            <?php
                                $arr_sup = ["489", "179", "222", "1288", "1205", "1289", "159", "124", "1311", "1290", "943", "1025", "413", "415"];

                                if (in_array($_COOKIE['sup'], $arr_sup)) {
                                    
                                    $stquery = $db->prepare("SELECT ASS.asid, ASS.stid, ASS.brid, ASS.uid, ASS.supuid, ASS.asstatus, ST.stid, ST.store_code, ST.store_name, ST.city, BR.brid, BR.brname FROM assignments ASS INNER JOIN store ST ON ASS.stid = ST.stid INNER JOIN brand BR ON ASS.brid = BR.brid WHERE ASS.asstatus=? ORDER BY ST.store_name ASC");
                                    $stquery->execute(array(0));

                                } else {
                                    $stquery = $db->prepare("SELECT ASS.asid, ASS.stid, ASS.brid, ASS.uid, ASS.supuid, ASS.asstatus, ST.stid, ST.store_code, ST.store_name, ST.city, BR.brid, BR.brname FROM assignments ASS INNER JOIN store ST ON ASS.stid = ST.stid INNER JOIN brand BR ON ASS.brid = BR.brid WHERE ASS.supuid=? AND ASS.asstatus=? ORDER BY ST.store_name ASC");
                                    $stquery->execute(array($_COOKIE['sup'],0));
                                }
                            ?>
                            <select class="select2 form-select" name="cboStore" id="cboStore" aria-label="Default select example" onchange="return calc_distance();">
                              <option value="0"></option>
                            <?php
                                
                                while($strow = $stquery->fetch())
                                {
                                  $asid = $strow['asid'];
                                  $uid = $strow['uid'];
                                  $supuid = $strow['supuid'];
                                  if($strow['uid'] > 0)
                                  {
                                      $baquery = $db->prepare("SELECT uid, ba_no, fullname, username, city FROM users WHERE uid = ?");
                                      $baquery->execute(array($uid));
                                      if($baquery->rowCount() == 0)
                                      {
                                        $ba_name = "Undefined";
                                        $ba_username = "Undefined";
                                      }
                                      while($barow = $baquery->fetch())
                                      {
                                        $ba_no = $barow['ba_no'];
                                        $ba_name = $barow['fullname'];
                                        $ba_city = $barow['city'];
                                        $ba_username = $barow['username'];  
                                      }

                                      if($as_asid != 0)
                                      {
                                        if($as_asid == $strow['asid']) { $selected = "selected"; } else{ $selected = ""; }
                                      }
                                      else{ $selected = ""; }
                            ?>
                            <option <?php echo($selected); ?> value="<?php echo($strow['stid']); ?>, <?php echo($strow['brid']); ?>, <?php echo($strow['uid']); ?>, <?php echo($strow['supuid']); ?>, <?php echo($strow['asid']); ?>"><?php echo($strow['store_name']); ?> ST-<?php echo($strow['store_code']); ?> - <?php echo($strow['brname']); ?> - <?php echo($ba_name); ?></option>
                            <?php
                                  }
                                }  
                            ?>
                          </select>
                          <label for="cboStore">Select Store</label>
                        </div>
                        
                        
                        <div class="form-floating form-floating-outline mb-6">
                          <textarea
                            id="basic-default-description" name="txtDescription"
                            class="form-control"
                            placeholder="Plan description goes here"
                            style="height: 60px"></textarea>
                          <label for="basic-default-description">Remarks</label>
                          <input type="hidden" name="hdnt" value="<?php echo($_REQUEST['t']); ?>">
                        </div>
                        <div class="form-floating form-floating-outline mb-6">
                            <table>
                                <tr>
                                    <td><input type="checkbox" name="chkCritical"  id="chkCritical" value="1"></td>
                                    <td style="color: red;">&nbsp;Alarming</td>
                                </tr>
                            </table>
                        </div>
                        <div class="form-floating form-floating-outline mb-6">
                            <table>
                                <tr>
                                    <td><input type="checkbox" name="chkVisitType"  id="chkVisitType" value="1"></td>
                                    <td>&nbsp;Visit from Outside</td>
                                </tr>
                            </table>
                        </div>
                        <div class="form-floating form-floating-outline mb-6">
                            <table>
                                <tr>
                                    <td><strong>Visit Time</strong> &nbsp;</td>
                                    <td><input type="radio" name="rdoVisitTime" checked id="rdoVisitTime" value="random"></td>
                                    <td>&nbsp;Random</td>
                                    <td>&nbsp;&nbsp;<input type="radio" name="rdoVisitTime"  id="rdoVisitTime" value="opening"></td>
                                    <td>&nbsp;Opening</td>
                                    <td>&nbsp;&nbsp;<input type="radio" name="rdoVisitTime"  id="rdoVisitTime" value="closing"></td>
                                    <td>&nbsp;Closing</td>
                                </tr>
                            </table>
                        </div>
                        <?php
                          if(isset($_REQUEST['ver']))
                          {
                        ?>
                        <div class="form-floating form-floating-outline mb-6">
                            <table>
                                <tr>
                                    
                                    <td style="color: red; font-weight: bold;">
                                        &nbsp;Note: Your Current location from selected store is <?php echo($store_distance); ?> Meters. Allowed limit is 200 Meters.

                                        <?php if($store_distance < 200){ ?>
                                          <input type="hidden" name="hdnVisit" id="hdnVisit" value="1">
                                        <?php }else{ ?>
                                          <input type="hidden" name="hdnVisit" id="hdnVisit" value="0">
                                        <?php } ?>
                                        <input type="hidden" name="hdnDist" id="hdnDist" value="<?php echo($store_distance); ?>">
                                    </td>
                                </tr>
                            </table>
                        </div>
                        <?php      
                          }
                          else
                          {
                        ?>
                        <div class="form-floating form-floating-outline mb-6">
                            <table>
                                <tr>
                                    
                                    <td style="color: red; font-weight: bold;">
                                        &nbsp;Note: Allowed limit is 200 Meters.
                                        <input type="hidden" name="hdnVisit" id="hdnVisit" value="0">
                                        <input type="hidden" name="hdnDist" id="hdnDist" value="0">
                                    </td>
                                </tr>
                            </table>
                        </div>
                        <?php    
                          }  
                        ?>
                        <button type="submit" name="btnSubmit" id="btnSubmit" class="btn btn-primary">Create Visit</button>
                        <button type="button" name="btnRefresh" class="btn btn-success" onclick="return rest_data();">Refresh</button>
                        
                        <button type="submit" name="btnCancel" class="btn btn-danger">Cancel</button>
                        <div id="demo"></div>
                      </form>
                    </div>
                  </div>
                  
                </div>
                
              </div>
            </div>
            <!-- / Content -->
            <footer class="content-footer footer bg-footer-theme">
              <div class="container-xxl">
                <div
                  class="footer-container d-flex align-items-center justify-content-between py-4 flex-md-row flex-column">
                  <div class="text-body mb-12 mb-md-0">
                    ©
                    <script>
                      document.write(new Date().getFullYear());
                    </script>
                     - Sentient
                  </div>
                </div>
              </div>
            </footer>

        </div>
        <!-- / Layout page -->
      </div>

      <!-- Overlay -->
      <div class="layout-overlay layout-menu-toggle"></div>
    </div>
    <!-- / Layout wrapper -->

    <script>
        const x = document.getElementById("demo");
        
        function getLocation() {
          if (navigator.geolocation) {
            navigator.geolocation.getCurrentPosition(showPosition);
          } else { 
            x.innerHTML = "Geolocation is not supported by this browser.";
          }

          var lat   = document.Form.elements['hdnlat'].value;
          var long   = document.Form.elements['hdnlong'].value;
          
          alert(lat);return false; 
        }
        
        function showPosition(position) {
          x.innerHTML = "<br><b>Your Current Position: Lat: "+ position.coords.latitude +" | Long: " + position.coords.longitude +"  <input type='hidden' name='hdnlat' value='" + position.coords.latitude +"'> <input type='hidden' name='hdnlong' value='" + position.coords.longitude +"'>";
        }


    </script>
    
    <!-- Core JS -->
    <!-- build:js assets/vendor/js/core.js -->
    <script src="assets/vendor/libs/jquery/jquery.js"></script>
    <script src="assets/vendor/libs/popper/popper.js"></script>
    <script src="assets/vendor/js/bootstrap.js"></script>
    <script src="assets/vendor/libs/node-waves/node-waves.js"></script>
    <script src="assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js"></script>
    <script src="assets/vendor/js/menu.js"></script>

    <!-- endbuild -->

    <!-- Vendors JS -->
    <script src="assets/vendor/libs/select2/select2.js"></script>
    <script src="assets/vendor/libs/apex-charts/apexcharts.js"></script>

    <!-- Main JS -->
    <script src="assets/js/main.js"></script>

    <!-- Page JS -->
    <script src="assets/js/dashboards-analytics.js"></script>

    <!-- Place this tag before closing body tag for github widget button. -->
    <script async defer src="https://buttons.github.io/buttons.js"></script>
    <script>

        <?php if($num_img == 0 || $store_distance > 200){ ?>
        document.Form.elements['btnSubmit'].disabled = true; 
       <?php } ?>



        function resizeImage(file, maxWidth, maxHeight, callback) {
            const reader = new FileReader();
            reader.readAsDataURL(file);
            
            reader.onload = function(event) {
                const img = new Image();
                img.src = event.target.result;
                
                img.onload = function() {
                    const canvas = document.createElement('canvas');
                    let width = img.width;
                    let height = img.height;
                    
                    if (width > maxWidth || height > maxHeight) {
                        if (width > height) {
                            height *= maxWidth / width;
                            width = maxWidth;
                        } else {
                            width *= maxHeight / height;
                            height = maxHeight;
                        }
                    }
                    
                    canvas.width = width;
                    canvas.height = height;
                    const ctx = canvas.getContext('2d');
                    ctx.drawImage(img, 0, 0, width, height);
                    
                    canvas.toBlob((blob) => {
                        callback(blob, canvas.toDataURL());
                    }, file.type);
                };
            };
        }

        document.getElementById("uploadForm").addEventListener("submit", function(event) {
            event.preventDefault(); // Prevent the default form submission

            const fileInput = document.getElementById("imageUpload");
            const file = fileInput.files[0];

            if (file) {
                resizeImage(file, 800, 600, function(resizedBlob, imageDataUrl) {
                    document.getElementById("previewImage").src = imageDataUrl;
                    document.getElementById("previewImage").style.display = "block";

                    const formData = new FormData();
                    formData.append("image", resizedBlob, file.name);
                    
                    fetch("su_visit_upload.php?t=<?php echo($_REQUEST['t']); ?>", {
                        method: "POST",
                        body: formData
                    }).then(response => response.text())
                      .then(data => console.log(data))
                      .catch(error => console.error("Error:", error));

                      document.Form.elements['btnSubmit'].disabled = false; 

                      
                
                });
                
            } else {
                alert("Please select an image!");
            }
        });
    </script>
    
    <script>
      // Simulate progress bar loading
      let progress = 0;
      const progressBar = document.getElementById('progress-bar');
      const interval = setInterval(() => {
        progress += 1;
        progressBar.style.width = progress + '%';
        if (progress >= 100) {
          clearInterval(interval);
          document.body.classList.add('loaded');
        }
      }, 30); // Adjust speed here
    </script>
  </body>
</html>
