<?php
  include("includes/functions.php");
  include("includes/errors.php");
  ba_loggedin();

  if(isset($_REQUEST['btnSave']))
  {
    save_com_sale($db,$URL);
  }
  
  if(isset($_REQUEST['btnPost']))
  {
    post_com_sale($db,$URL);
  }
?>
<!doctype html>

<html
  lang="en"
  class="light-style layout-menu-fixed layout-compact"
  dir="ltr"
  data-theme="theme-default"
  data-assets-path="assets/"
  data-template="vertical-menu-template-free"
  data-style="light">
  <head>
    <meta charset="utf-8" />
    <meta
      name="viewport"
      content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />

    <title>Sentient App - Post Competition Sale</title>

    <meta name="description" content="" />

    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="assets/img/favicon/favicon.ico" />

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
      href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&ampdisplay=swap"
      rel="stylesheet" />

    <link rel="stylesheet" href="assets/vendor/fonts/remixicon/remixicon.css" />

    <!-- Menu waves for no-customizer fix -->
    <link rel="stylesheet" href="assets/vendor/libs/node-waves/node-waves.css" />

    <!-- Core CSS -->
    <link rel="stylesheet" href="assets/vendor/css/core.css" class="template-customizer-core-css" />
    <link rel="stylesheet" href="assets/vendor/css/theme-default.css" class="template-customizer-theme-css" />
    <link rel="stylesheet" href="assets/css/demo.css" />

    <!-- Vendors CSS -->
    <link rel="stylesheet" href="assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.css" />

    <!-- Page CSS -->

    <!-- Helpers -->
    <script src="assets/vendor/js/helpers.js"></script>
    <!--! Template customizer & Theme config files MUST be included after core stylesheets and helpers.js in the <head> section -->
    <!--? Config:  Mandatory theme config file contain global vars & default theme options, Set your preferred theme option in this file.  -->
    <script src="assets/js/config.js"></script>
    <script type="text/javascript" language="javascript">
      function selectText1(num) {
        const input = document.getElementById("txtIntQty"+num);
        input.focus();
        input.select();
      }
      function selectText2(num) {
        const input = document.getElementById("txtProQty"+num);
        input.focus();
        input.select();
      }
      function postRecords()
      {
        var cd;
        cd = confirm("Are you sure to post data?");
        if(cd)
        {
          return true;
        }
      }
    </script>

  </head>

  <body>
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
      <div class="layout-container">
        <!-- Menu -->

        <?php include("left_menu.php"); ?>
        <!-- / Menu -->

        <!-- Layout container -->
        <div class="layout-page">
          <!-- Navbar -->

          <?php include("top_menu.php"); ?>

          <!-- / Navbar -->

          <!-- Content wrapper -->
          <div class="content-wrapper">
            <!-- Content -->

            <form name="Form" method="post">
            <div class="container-xxl flex-grow-1 container-p-y">
              <div class="row g-6">


                <div class="col-xl-6">
                  <!-- HTML5 Inputs -->
                  <div class="card mb-6">
                    <h5 class="card-header">Competition Data - <?php echo($user_brand); ?> <br><small>Post Date: <?php echo(date("d-m-Y")); ?></small>
                      <?php if(isset($_REQUEST['err'])){ ?>
                      <br>
                      <small style="color: red;">Competition Data Saved Successfully!</small><br>
                      <?php }if($user_comsale_status == 1){ ?>
                        <small style="color: red;">Competition Data Posted!</small>
                      <?php } ?>
                    </h5>
                    <div class="card-body">
                      <?php
                          $usership_query = $db->prepare("SELECT asuid, uid, sale_date, asustatus FROM usership WHERE uid = ? AND sale_date = ?");
                          $usership_query->execute(array($user_uid, date("d-m-Y")));
                          while($usership_row = $usership_query->fetch())
                          {
                              $usership_status = $usership_row['asustatus'];
                          }

                          $count = 0;
                          $current_date = date("d-m-Y");
                          $query = $db->prepare("SELECT URD.asudid, URD.asuid, URD.uid, URD.brid, URD.cbrid, URD.com_sale, CB.cbrid, CB.cbrname FROM usership_detail URD 
                              INNER JOIN cbrand CB ON URD.cbrid = CB.cbrid WHERE URD.uid=? AND URD.sale_date = ? ORDER BY CB.cbrid ASC");
                          $query->execute(array($_COOKIE['ba'],$current_date));
                          $num_qty = $query->rowCount();
                      ?>
                      <input type="hidden" name="hdnQty" value="<?php echo($num_qty); ?>">
                      
                        
                        <table width="100%">
                          <tr>
                            <td><h6 style="color: orange;">Competition Sale</h6></div>
                            </td>
                          </tr>
                          <?php
                              while($row = $query->fetch())
                              {
                                $count++;
                          ?>
                          <tr>
                            <td>
                              <div class="form-floating form-floating-outline mb-6">
                                <input class="form-control" <?php if($user_comsale_status == 1) { echo "Disabled"; } ?> type="number" name="txtComQty<?php echo($count); ?>" value="<?php echo($row['com_sale']); ?>" placeholder="Enter Quantity" id="txtComQty<?php echo($count); ?>" step=".001"  onClick="return selectText1(<?php echo($count); ?>); " />
                                <input type="hidden" name="hdnid<?php echo($count); ?>" value="<?php echo($row['asudid']); ?>">
                                <label for="html5-number-input"><?php echo($row['cbrname']); ?></label>
                              </div>
                            </td>
                          </tr>
                          <?php
                              }
                              
                          ?>
                        </table>
                    </div>
                  </div>
                  <div class="mb-6">
                    <table width="100%">
                      <tr>
                        <td><button <?php if($user_comsale_status == 1) { echo "Disabled"; } ?> name="btnSave" class="btn btn-warning d-grid w-100" type="submit">Save</button>
                        </td>
                        <td><button <?php if($user_comsale_status == 1) { echo "Disabled"; } ?> name="btnPost" class="btn btn-success d-grid w-100" type="submit" onClick="return postRecords();">Post</button>
                  </td>
                      </tr>
                    </table>
                  
                  </div>
                  <div class="mb-3">
                  </div>
                </div>
              </div>
            </div>
            <!-- / Content -->
            </form>
            <!-- Footer -->
            <footer class="content-footer footer bg-footer-theme">
              <div class="container-xxl">
                <div
                  class="footer-container d-flex align-items-center justify-content-between py-4 flex-md-row flex-column">
                  <div class="text-body mb-12 mb-md-0">
                    ©
                    <script>
                      document.write(new Date().getFullYear());
                    </script>
                     - Sentient
                  </div>
                </div>
              </div>
            </footer>
            <!-- / Footer -->

            <div class="content-backdrop fade"></div>
          </div>
          <!-- Content wrapper -->
        </div>
        <!-- / Layout page -->
      </div>

      <!-- Overlay -->
      <div class="layout-overlay layout-menu-toggle"></div>
    </div>
    <!-- / Layout wrapper -->

    <?php // include("post_buttons.php"); ?>
    
    <!-- Core JS -->
    <!-- build:js assets/vendor/js/core.js -->
    <script src="assets/vendor/libs/jquery/jquery.js"></script>
    <script src="assets/vendor/libs/popper/popper.js"></script>
    <script src="assets/vendor/js/bootstrap.js"></script>
    <script src="assets/vendor/libs/node-waves/node-waves.js"></script>
    <script src="assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js"></script>
    <script src="assets/vendor/js/menu.js"></script>

    <!-- endbuild -->

    <!-- Vendors JS -->

    <!-- Main JS -->
    <script src="assets/js/main.js"></script>

    <!-- Page JS -->

    <script src="assets/js/form-basic-inputs.js"></script>

    <!-- Place this tag before closing body tag for github widget button. -->
    <script async defer src="https://buttons.github.io/buttons.js"></script>
  </body>
</html>
