<?php
  require("includes/functions.php");
  include("includes/errors.php");
  ba_loggedin();
?>
<!doctype html>

<html
  lang="en"
  class="light-style layout-menu-fixed layout-compact"
  dir="ltr"
  data-theme="theme-default"
  data-assets-path="assets/"
  data-template="vertical-menu-template-free"
  data-style="light">
  <head>
    <meta charset="utf-8" />
    <meta
      name="viewport"
      content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />

    <title>Sentient App</title>

    <meta name="description" content="" />

    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="assets/img/favicon/favicon.ico" />

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
      href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&ampdisplay=swap"
      rel="stylesheet" />

    <link rel="stylesheet" href="assets/vendor/fonts/remixicon/remixicon.css" />

    <!-- Menu waves for no-customizer fix -->
    <link rel="stylesheet" href="assets/vendor/libs/node-waves/node-waves.css" />

    <!-- Core CSS -->
    <link rel="stylesheet" href="assets/vendor/css/core.css" class="template-customizer-core-css" />
    <link rel="stylesheet" href="assets/vendor/css/theme-default.css" class="template-customizer-theme-css" />
    <link rel="stylesheet" href="assets/css/demo.css" />

    <!-- Vendors CSS -->
    <link rel="stylesheet" href="assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.css" />
    <link rel="stylesheet" href="assets/vendor/libs/apex-charts/apex-charts.css" />

    <!-- Page CSS -->

    <!-- Helpers -->
    <script src="assets/vendor/js/helpers.js"></script>
    <!--! Template customizer & Theme config files MUST be included after core stylesheets and helpers.js in the <head> section -->
    <!--? Config:  Mandatory theme config file contain global vars & default theme options, Set your preferred theme option in this file.  -->
    <script src="assets/js/config.js"></script>
  </head>

  <body>
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
      <div class="layout-container">
        <!-- Menu -->

        <?php include("left_menu.php"); ?>
        
        <!-- / Menu -->

        <!-- Layout container -->
        <div class="layout-page">
          <!-- Navbar -->

          <?php include("top_menu.php"); ?>

          <!-- / Navbar -->

          <!-- Content wrapper -->
          <div class="content-wrapper">
            <!-- Content -->

            <div class="container-xxl flex-grow-1 container-p-y">
              <div class="row gy-6">
               
                <!-- Transactions -->
                <div class="col-lg-12">
                  <div class="card h-100">
                    <div class="card-header">
                      <div class="d-flex align-items-center justify-content-between">
                        <h5 class="card-title m-0 me-2">Transactions</h5>
                        <div class="dropdown">
                          <button
                            class="btn text-muted p-0"
                            type="button"
                            id="transactionID"
                            data-bs-toggle="dropdown"
                            aria-haspopup="true"
                            aria-expanded="false">
                            <i class="ri-more-2-line ri-24px"></i>
                          </button>
                          <div class="dropdown-menu dropdown-menu-end" aria-labelledby="transactionID">
                            <a class="dropdown-item" href="javascript:void(0);">Refresh</a>
                            <a class="dropdown-item" href="javascript:void(0);">Share</a>
                            <a class="dropdown-item" href="javascript:void(0);">Update</a>
                          </div>
                        </div>
                      </div>
                      <p class="small mb-0"><span class="h6 mb-0">Total 48.5% Growth</span></p>
                    </div>
                    <div class="card-body pt-lg-10">
                      <div class="row g-6">
                        <div class="col-md-3 col-6">
                          <div class="d-flex align-items-center">
                            <div class="avatar">
                              <div class="avatar-initial bg-primary rounded shadow-xs">
                                <i class="ri-pie-chart-2-line ri-24px"></i>
                              </div>
                            </div>
                            <div class="ms-3">
                              <p class="mb-0">Sales</p>
                              <h5 class="mb-0">245k</h5>
                            </div>
                          </div>
                        </div>
                        <div class="col-md-3 col-6">
                          <div class="d-flex align-items-center">
                            <div class="avatar">
                              <div class="avatar-initial bg-success rounded shadow-xs">
                                <i class="ri-group-line ri-24px"></i>
                              </div>
                            </div>
                            <div class="ms-3">
                              <p class="mb-0">Customers</p>
                              <h5 class="mb-0">12.5k</h5>
                            </div>
                          </div>
                        </div>
                        <div class="col-md-3 col-6">
                          <div class="d-flex align-items-center">
                            <div class="avatar">
                              <div class="avatar-initial bg-warning rounded shadow-xs">
                                <i class="ri-macbook-line ri-24px"></i>
                              </div>
                            </div>
                            <div class="ms-3">
                              <p class="mb-0">Product</p>
                              <h5 class="mb-0">1.54k</h5>
                            </div>
                          </div>
                        </div>
                        <div class="col-md-3 col-6">
                          <div class="d-flex align-items-center">
                            <div class="avatar">
                              <div class="avatar-initial bg-info rounded shadow-xs">
                                <i class="ri-money-dollar-circle-line ri-24px"></i>
                              </div>
                            </div>
                            <div class="ms-3">
                              <p class="mb-0">Revenue</p>
                              <h5 class="mb-0">$88k</h5>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
                <!--/ Transactions -->
                <!-- Data Tables -->
                <div class="col-12">
                  <div class="card overflow-hidden">
                    <div class="table-responsive">
                      <table class="table table-sm">
                        <thead>
                          <tr>
                            <th class="text-truncate">Date</th>
                            <th class="text-truncate">Store</th>
                            <th class="text-truncate">Total Sale</th>
                            <th class="text-truncate">Qty Status</th>
                            <th class="text-truncate">Price Status</th>
                            <th class="text-truncate">Sale Status</th>
                          </tr>
                        </thead>
                        <tbody>
                          <?php
                            $current_date = date("d-m-Y");
                            $uaquery = $db->prepare("SELECT * FROM user_attendance WHERE uid = ? ORDER BY uatid DESC LIMIT 0,10");
                            $uaquery->execute(array($_COOKIE['ba'],));
                            while($uarow = $uaquery->fetch())
                            {
                              $uid = $uarow['uid'];
                              $attendance_date = $uarow['attendance_date'];

                              $asquery = $db->prepare("SELECT ASS.uid,ASS.asid,ASS.sale_date, SUM(ASS.sale_qty) AS total_sale, ST.stid, ST.store_name, ST.city FROM assignment_sale ASS 
                                  INNER JOIN assignments A ON ASS.asid = A.asid 
                                  INNER JOIN store ST ON A.stid = ST.stid 
                                  WHERE ASS.uid = ? AND ASS.sale_date = ?");
                              $asquery->execute(array($uid,$attendance_date));
                              while($asrow = $asquery->fetch())
                              {
                                  $store_name = $asrow['store_name'];
                                  $store_city = $asrow['city'];
                                  $total_sale = $asrow['total_sale'];
                              }

                              if($current_date == $attendance_date)
                              {
                                  if($uarow['stock_status'] == 0)
                                  {
                                      $qty_status_1 = "warning";
                                      $qty_status_2 = "Pending";  
                                  }
                                  else
                                  {
                                    $qty_status_1 = "success";
                                    $qty_status_2 = "Completed";
                                  }

                                  if($uarow['price_status'] == 0)
                                  {
                                      $price_status_1 = "warning";
                                      $price_status_2 = "Pending";  
                                  }
                                  else
                                  {
                                    $price_status_1 = "success";
                                    $price_status_2 = "Completed";
                                  } 

                                  if($uarow['sale_status'] == 0)
                                  {
                                      $sale_status_1 = "warning";
                                      $sale_status_2 = "Pending";  
                                  }
                                  else
                                  {
                                    $sale_status_1 = "success";
                                    $sale_status_2 = "Completed";
                                  } 
                              }
                              else
                              {
                                if($uarow['stock_status'] == 0)
                                {
                                    $qty_status_1 = "danger";
                                    $qty_status_2 = "Incomplete";  
                                }
                                else
                                {
                                  $qty_status_1 = "success";
                                  $qty_status_2 = "Completed";
                                }

                                if($uarow['price_status'] == 0)
                                {
                                    $price_status_1 = "danger";
                                    $price_status_2 = "Incomplete";  
                                }
                                else
                                {
                                  $price_status_1 = "success";
                                  $price_status_2 = "Completed";
                                }

                                if($uarow['sale_status'] == 0)
                                {
                                    $sale_status_1 = "danger";
                                    $sale_status_2 = "Incomplete";  
                                }
                                else
                                {
                                  $sale_status_1 = "success";
                                  $sale_status_2 = "Completed";
                                }
                              }
                              if($total_sale != Null)
                              {
                          ?>
                          <tr>
                            <td class="text-truncate"><a href="sale_detail.php?atdate=<?php echo($attendance_date); ?>"><?php echo($attendance_date); ?></a></td>
                            <td class="text-truncate"><?php echo($store_name) ?>, <?php echo($store_city) ?></td>
                            <td class="text-truncate"><?php echo($total_sale); ?></td>
                            <td><span class="badge bg-label-<?php echo($qty_status_1); ?> rounded-pill"><?php echo($qty_status_2); ?></span></td>
                            <td><span class="badge bg-label-<?php echo($price_status_1); ?> rounded-pill"><?php echo($price_status_2); ?></span></td>
                            <td><span class="badge bg-label-<?php echo($sale_status_1); ?> rounded-pill"><?php echo($sale_status_2); ?></span></td>
                          </tr>
                          <?php } } ?>
                          
                          
                          
                          
                        </tbody>
                      </table>
                    </div>
                  </div>
                </div>
                <!--/ Data Tables -->
              </div>
            </div>
            <!-- / Content -->

            <!-- Footer -->
            <footer class="content-footer footer bg-footer-theme">
              <div class="container-xxl">
                <div
                  class="footer-container d-flex align-items-center justify-content-between py-4 flex-md-row flex-column">
                  <div class="text-body mb-12 mb-md-0">
                    ©
                    <script>
                      document.write(new Date().getFullYear());
                    </script>
                     - Sentient
                  </div>
                </div>
              </div>
            </footer>
            <!-- / Footer -->

            <div class="content-backdrop fade"></div>
          </div>
          <!-- Content wrapper -->
        </div>
        <!-- / Layout page -->
      </div>

      <!-- Overlay -->
      <div class="layout-overlay layout-menu-toggle"></div>
    </div>
    <!-- / Layout wrapper -->

    
    <?php include("post_buttons.php"); ?>
    <!-- Core JS -->
    <!-- build:js assets/vendor/js/core.js -->
    <script src="assets/vendor/libs/jquery/jquery.js"></script>
    <script src="assets/vendor/libs/popper/popper.js"></script>
    <script src="assets/vendor/js/bootstrap.js"></script>
    <script src="assets/vendor/libs/node-waves/node-waves.js"></script>
    <script src="assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js"></script>
    <script src="assets/vendor/js/menu.js"></script>

    <!-- endbuild -->

    <!-- Vendors JS -->
    <script src="assets/vendor/libs/apex-charts/apexcharts.js"></script>

    <!-- Main JS -->
    <script src="assets/js/main.js"></script>

    <!-- Page JS -->
    <script src="assets/js/dashboards-analytics.js"></script>

    <!-- Place this tag before closing body tag for github widget button. -->
    <script async defer src="https://buttons.github.io/buttons.js"></script>
  </body>
</html>
