<?php
  require("includes/functions.php");
  include("includes/errors.php");
  ba_loggedin();
?>
<!doctype html>

<html
  lang="en"
  class="light-style layout-menu-fixed layout-compact"
  dir="ltr"
  data-theme="theme-default"
  data-assets-path="assets/"
  data-template="vertical-menu-template-free"
  data-style="light">
  <head>
    <meta charset="utf-8" />
    <meta
      name="viewport"
      content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />

    <title>Sentient App</title>

    <meta name="description" content="" />

    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="assets/img/favicon/favicon.ico" />

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
      href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&ampdisplay=swap"
      rel="stylesheet" />

    <link rel="stylesheet" href="assets/vendor/fonts/remixicon/remixicon.css" />

    <!-- Menu waves for no-customizer fix -->
    <link rel="stylesheet" href="assets/vendor/libs/node-waves/node-waves.css" />

    <!-- Core CSS -->
    <link rel="stylesheet" href="assets/vendor/css/core.css" class="template-customizer-core-css" />
    <link rel="stylesheet" href="assets/vendor/css/theme-default.css" class="template-customizer-theme-css" />
    <link rel="stylesheet" href="assets/css/demo.css" />

    <!-- Vendors CSS -->
    <link rel="stylesheet" href="assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.css" />
    <link rel="stylesheet" href="assets/vendor/libs/apex-charts/apex-charts.css" />

    <!-- Page CSS -->
    <style>
      #loader {
        position: fixed;
        z-index: 9999;
        background: white;
        width: 100%;
        height: 100%;
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
      }
      body.loaded #loader {
        opacity: 0;
        visibility: hidden;
        transition: opacity 0.5s ease-out;
      }
      .progress {
        width: 50%;
        height: 20px;
      }
    </style>
    <!-- Page CSS -->

    <!-- Helpers -->
    <script src="assets/vendor/js/helpers.js"></script>
    <!--! Template customizer & Theme config files MUST be included after core stylesheets and helpers.js in the <head> section -->
    <!--? Config:  Mandatory theme config file contain global vars & default theme options, Set your preferred theme option in this file.  -->
    <script src="assets/js/config.js"></script>
  </head>

  <body>
       <!-- Loader -->
    <div id="loader">
      <h5>Loading, please wait...</h5>
      <div class="progress mt-3">
        <div id="progress-bar" class="progress-bar progress-bar-striped progress-bar-animated bg-primary" role="progressbar" style="width: 0%"></div>
      </div>
    </div>
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
      <div class="layout-container">
        <!-- Menu -->

        <?php include("left_menu.php"); ?>
        
        <!-- / Menu -->

        <!-- Layout container -->
        <div class="layout-page">
          <!-- Navbar -->

          <?php include("top_menu.php"); ?>

          <!-- / Navbar -->

          <!-- Content wrapper -->
          <div class="content-wrapper">
            <!-- Content -->

            <div class="container-xxl flex-grow-1 container-p-y">
              <div class="row gy-6">
               
                

                <?php
                    $month = date("m");
                    $year = date("Y");
                    
                    //$current_month = date("m");

                    $first_day_of_month = date("$year-$month-01"); // hard-coded '01' for first day
                    $last_day_of_month  = date("$year-$month-d");
                    $last_day_this_month  = date("$year-$month-t");

                    $first_day_timestamp =  strtotime($first_day_of_month);
                    $last_day_timestamp  = strtotime($last_day_of_month) + 86399;
                    $number_of_days = date("d",$last_day_timestamp);
                    if($number_of_days >= 30)
                    {
                        $attendance_days = $number_of_days - 4;
                    }
                    else
                    {
                        $attendance_days = $number_of_days;
                    }
                    
                    $query = $db->prepare("SELECT ASS.assid, ASS.uid, ASS.asid, ASS.brid, ASS.pid, ASS.assid, ASS.sale_date, ASS.assid, SUM(sale_qty) AS total_sale, ASS.assdate, ASA.asid, ASA.stid, ASA.brid, ASA.asshift, ASA.asoffday, ASA.asstarttime, ASA.asofftime, ASA.storetarget, ASA.supuid, B.brid, B.brname, ST.stid, ST.store_name, ST.city, ST.channel, U.uid, U.fullname FROM assignment_sale ASS 
                      INNER JOIN assignments ASA ON ASS.asid = ASA.asid 
                      INNER JOIN brand B ON ASA.brid = B.brid 
                      INNER JOIN store ST ON ASA.stid = ST.stid 
                      INNER JOIN users U ON ASA.uid = U.uid WHERE assdate BETWEEN $first_day_timestamp AND 
                                    $last_day_timestamp AND ASS.uid = ".$_COOKIE['ba']." GROUP BY ASS.asid ORDER BY ASS.assid DESC LIMIT 0,1");
                      $query->execute();
                      if($query->rowCount() > 0)
                      {
                          
                          while($row = $query->fetch())
                          {
                            $asid = $row['asid'];
                            $sup_uid = $row['supuid'];
                            $uid = $row['uid'];
                            $total_sale = $row['total_sale'];
                            $storetarget = $row['storetarget'];
                            
                            $ba_name = $row['fullname'];
                            $store_name = $row['store_name'];                            
                            

                            $monthly_target = $storetarget * 26;
                            
                            

                            if($sup_uid != 0)
                            {
                              $supquery1 = $db->prepare("SELECT uid, su_no, fullname FROM users WHERE uid=?");
                              $supquery1->execute(array($sup_uid));
                              while($suprow1 = $supquery1->fetch())
                              {
                                $supervisor = $suprow1['fullname'].": SU-".$suprow1['su_no'];
                              }
                            }
                            else
                            {
                              $supervisor = "<span style='color:red;'>Not Assigned</span>";
                            }
                            
                            /// calculate working days
                            
                            $uaquery = $db->prepare("SELECT uid, asid, attendance_date, timein FROM user_attendance WHERE uid = $uid AND asid = $asid AND timein > 0 AND uatdate BETWEEN $first_day_timestamp AND $last_day_timestamp");
                            $uaquery->execute();
                            $num_working_days = $uaquery->rowCount();
                            //echo($num_working_days);die;
                            if($num_working_days > 0)
                            {
                                $avg_attendance = $num_working_days / $attendance_days  * 100;  
                            }
                            else
                            {
                              $avg_attendance = 0;
                            }
                            
                            /// target till date
                            $target_till_date = $num_working_days * $storetarget;
                            
                            /// daily achivement 
                            if($total_sale > 0)
                            {
                              if($num_working_days > 0)
                              {
                                $daily_sale = $total_sale / $num_working_days;    
                              }
                              else
                              {
                                $daily_sale = 0;
                              }
                            } 
                            else{
                              $daily_sale = 0;
                            }

                            if($daily_sale > 0)
                            {
                              if($storetarget > 0)
                              {
                                $daily_sale_achivement = $daily_sale / $storetarget  * 100;   
                              }
                              else
                              {
                                $daily_sale_achivement = 100; 
                              }
                            }
                            else
                            {
                              $daily_sale_achivement = 0;
                            }
                            
                            /// monthly achivement
                            if($monthly_target > 0)
                            {
                              if($total_sale > 0)
                              {
                                $monthly_sale_achivement = $total_sale / $monthly_target * 100;   
                              }
                              else
                              {
                                $monthly_sale_achivement = 0;
                              }
                            } 
                            else{
                              if($total_sale > 0)
                              {
                                $monthly_sale_achivement = 100;   
                              }
                            }
                            
                            
                            
                            

                            /// per day avg

                            if($num_working_days > 0)
                            {
                              $avg_sale = $total_sale / $num_working_days;  
                            }
                            else
                            {
                              $avg_sale = 0;
                            }

                            /// remaining target

                            $taget_left = $total_sale - $storetarget;


                            /// monthly achivement 



                            //// calculate usership

                            $usdquery = $db->prepare("SELECT uid, SUM(interception) AS total_interception, SUM(productive) AS total_productive, asuddate FROM usership_detail WHERE uid = $uid AND asuddate BETWEEN $first_day_timestamp AND $last_day_timestamp");
                            $usdquery->execute();
                            while($usdrow = $usdquery->fetch())
                            {
                              $total_interception = $usdrow['total_interception'];
                              $total_productive = $usdrow['total_productive'];
                            }

                            if($total_interception > 0 && $total_productive > 0)
                            {
                              $avg_usership = $total_productive / $total_interception  * 100; 
                            }
                            else
                            {
                              if($total_productive > 0)
                              {
                                $avg_usership = 100;  
                              }
                              else
                              {
                                $avg_usership = 0;
                              }
                              
                            }

                            $remaining_target = $monthly_target - $total_sale;



                          $UatQuery = $db->prepare("SELECT uatid, uid, timein, uatapp_id FROM user_attendance WHERE uid = ? ORDER BY uatid DESC LIMIT 0,1");
                          $UatQuery->execute(array($_COOKIE['ba']));
                          while($UatObj = $UatQuery->fetch())
                          {
                            //21st July at 5:00 PM
                            $UserAttendanceTimein = date('d-m-Y  H:i:s', $UatObj['timein']); 
                          }
        
                          $AtlQuery = $db->prepare("SELECT atlid , uid, app_id FROM attendance_log WHERE uid = ? ORDER BY atlid DESC LIMIT 0,1");
                          $AtlQuery->execute(array($_COOKIE['ba']));
                          if($AtlQuery->rowCount() == 0)
                          {
                            $UserAppID = "";
                          }
                          else
                          {
                            while($AtlObj = $AtlQuery->fetch())
                            {
                              //21st July at 5:00 PM
                              $UserAppID = $AtlObj['app_id']; 
                            }
                            //echo("SER 2 | $UserAppID");
                            
                          }
                          if($UserAppID == ""){ $app_ver = "2.0"; } else{ $app_ver = "3.0 - Latest"; }
                  ?>
                <!-- Transactions -->
                <div class="col-lg-12">
                  <div class="card h-100">
                    <div class="card-header">
                      <div class="d-flex align-items-center justify-content-between">
                        <h5 class="card-title m-0 me-2">Profile</h5>
                      </div>
                    </div>
                    <div class="card-body pt-lg-12">
                      <div class="row g-12">
                        
                        <div class="col-md-3 col-6">
                          <div class="d-flex align-items-center">
                            <div class="ms-3">
                              <p class="mb-0">Name</p>
                              <h6 class="mb-0"><?php echo($row['fullname']); ?></h6>
                            </div>
                          </div>
                        </div>

                        <div class="col-md-3 col-6">
                          <div class="d-flex align-items-center">
                            <div class="ms-3">
                              <p class="mb-0">Brand</p>
                              <h6 class="mb-0"><?php echo($row['brname']); ?></h6>
                            </div>
                          </div>
                        </div>

                        <div class="col-md-3 col-6">
                          <div class="d-flex align-items-center">
                            <div class="ms-3">
                              <p class="mb-0">Store</p>
                              <h6 class="mb-0"><?php echo($row['store_name']); ?></h6>
                            </div>
                          </div>
                        </div>

                        <div class="col-md-3 col-6">
                          <div class="d-flex align-items-center">
                            <div class="ms-3">
                              <p class="mb-0">City</p>
                              <h6 class="mb-0"><?php echo($row['city']); ?></h6>
                            </div>
                          </div>
                        </div>
                        
                       
                      </div>
                    </div>
                  </div>
                </div>
                <!--/ Transactions -->



                <!-- Transactions -->
                <div class="col-lg-12">
                  <div class="card h-100">
                    <div class="card-header">
                      <div class="d-flex align-items-center justify-content-between">
                        <h5 class="card-title m-0 me-2">Dashboard</h5>
                        
                      </div>
                    </div>
                    <div class="card-body pt-lg-10">
                      <div class="row g-6">
                        <div class="col-md-3 col-6">
                          <div class="d-flex align-items-center">
                            <div class="avatar">
                              <a href="post_qty.php">
                              <div class="avatar-initial bg-danger rounded shadow-xs">
                                <i class="ri-logout-box-r-line ri-24px"></i>
                              </div>
                              </a>
                            </div>
                            <br>
                            <div class="ms-3">
                              <a href="post_qty.php"><p class="mb-0">Stock</p></a>
                            </div>
                          </div>
                        </div>
                        <div class="col-md-3 col-6">
                          <div class="d-flex align-items-center">
                            <div class="avatar">
                              <a href="post_price.php">
                              <div class="avatar-initial bg-warning rounded shadow-xs">
                                <i class="ri-money-dollar-circle-line ri-24px"></i>
                              </div>
                            </a>
                            </div>
                            <div class="ms-3">
                              <a href="post_price.php"><p class="mb-0">Price</p></a>
                            </div>
                          </div>
                        </div>
                        <?php
                            $current_date = date("d-m-Y");
                            $us_query = $db->prepare("SELECT asuid, uid, sale_date FROM usership WHERE uid = ? AND sale_date = ? ORDER BY asuid ASC");
                            $us_query->execute(array($_COOKIE['ba'],$current_date));
                            if($us_query->rowCount() > 0)
                            {
                        ?>
                        <div class="col-md-3 col-6">
                          <div class="d-flex align-items-center">
                            
                            <div class="avatar">
                              <a href="post_usership.php">
                              <div class="avatar-initial bg-info rounded shadow-xs">
                                <i class="ri-user-3-line ri-24px"></i>
                              </div>
                              </a>
                            </div>
                            <div class="ms-3">
                              <a href="post_usership.php">
                              <p class="mb-0">Usership</p></a>
                            </div>
                          </div>
                        </div>
                        <div class="col-md-3 col-6">
                          <div class="d-flex align-items-center">
                            <div class="avatar">
                              <a href="post_com_sale.php">
                              <div class="avatar-initial bg-success rounded shadow-xs">
                                <i class="ri-shopping-bag-line ri-24px"></i>
                              </div>
                              </a>
                            </div>
                            <div class="ms-3">
                              <a href="post_com_sale.php">
                              <p class="mb-0">Competition Sales</p>
                            </a>
                            </div>
                          </div>
                        </div>
                        <?php
                            }
                        ?>
                        <div class="col-md-3 col-6">
                          <div class="d-flex align-items-center">
                            <div class="avatar">
                              <a href="post_samples.php">
                              <div class="avatar-initial bg-secondary rounded shadow-xs">
                                <i class="ri-shopping-bag-4-line ri-24px"></i>
                              </div>
                            </a>
                            </div>
                            <br>
                            <div class="ms-3">
                              <a href="post_samples.php"><p class="mb-0">Samples</p></a>
                            </div>
                          </div>
                        </div>
                        <?php
                            if($user_assignment_deal_status == 1){
                        ?>
                        <div class="col-md-3 col-6">
                          <div class="d-flex align-items-center">
                            <div class="avatar">
                              <a href="post_deals.php">
                              <div class="avatar-initial bg-primary rounded shadow-xs">
                                <i class="ri-shopping-bag-4-line ri-24px"></i>
                              </div>
                            </a>
                            </div>
                            <br>
                            <div class="ms-3">
                              <a href="post_deals.php"><p class="mb-0">Deals</p></a>
                            </div>
                          </div>
                        </div>
                        <?php
                          }if($user_assignment_sample_status == 1){
                        ?> 
                        <div class="col-md-3 col-6">
                          <div class="d-flex align-items-center">
                            <div class="avatar">
                              <a href="post_samples.php">
                              <div class="avatar-initial bg-success rounded shadow-xs">
                                <i class="ri-shopping-cart-2-line ri-24px"></i>
                              </div>
                              </a>
                            </div>
                            <br>
                            <div class="ms-3">
                              <a href="post_samples.php"><p class="mb-0">Sales</p></a>
                            </div>
                          </div>
                        </div>
                        <?php } ?>
                        <div class="col-md-3 col-6">
                          <div class="d-flex align-items-center">
                            <a href="post_samples.php">
                            <div class="avatar">
                              <a href="ba_attendance.php">
                              <div class="avatar-initial bg-danger rounded shadow-xs">
                                <i class="ri-shopping-bag-4-line ri-24px"></i>
                              </div>
                              </a>
                            </div>
                          </a>
                            <br>
                            <div class="ms-3">
                              <a href="ba_attendance.php"><p class="mb-0">Attendance</p></a>
                            </div>
                          </div>
                        </div>
                           
                      </div>
                    </div>
                  </div>
                </div>
                <!--/ Transactions -->

                <!-- Transactions -->
                <div class="col-lg-12">
                  <div class="card h-100">
                    <div class="card-header">
                      <div class="d-flex align-items-center justify-content-between">
                        <h5 class="card-title m-0 me-2">Sales Performance</h5>
                        
                      </div>

                      <p class="small mb-0">Logged in @ <?php echo($UserAttendanceTimein); ?></p>
                    </div>
                    <div class="card-body pt-lg-12">
                      <div class="row g-12">
                        <div class="col-md-3 col-6">
                          <div class="d-flex align-items-center">
                            <div class="ms-3">
                              <p class="mb-0">BA Name</p>
                              <h6 class="mb-0"><?php echo($ba_name); ?></h6>
                            </div>
                          </div>
                        </div>
                        
                        <div class="col-md-3 col-6">
                          <div class="d-flex align-items-center">
                            <div class="ms-3">
                              <p class="mb-0">Store Name</p>
                              <h6 class="mb-0"><?php echo($store_name); ?></h6>
                            </div>
                          </div>
                        </div>
                        
                        <div class="col-md-3 col-6">
                          <div class="d-flex align-items-center">
                            <div class="ms-3">
                              <p class="mb-0">Target Per Day</p>
                              <h6 class="mb-0"><?php echo($storetarget); ?></h6>
                            </div>
                          </div>
                        </div>

                        <div class="col-md-3 col-6">
                          <div class="d-flex align-items-center">
                            <div class="ms-3">
                              <p class="mb-0">Monthly Target</p>
                              <h6 class="mb-0"><?php echo($monthly_target); ?></h6>
                            </div>
                          </div>
                        </div>

                        <div class="col-md-3 col-6">
                          <div class="d-flex align-items-center">
                            <div class="ms-3">
                              <p class="mb-0">Target Till Date</p>
                              <h6 class="mb-0"><?php echo($target_till_date); ?></h6>
                            </div>
                          </div>
                        </div>

                        <div class="col-md-3 col-6">
                          <div class="d-flex align-items-center">
                            <div class="ms-3">
                              <p class="mb-0">Total Sales</p>
                              <h6 class="mb-0"><?php echo($total_sale); ?></h6>
                            </div>
                          </div>
                        </div>

                        <div class="col-md-3 col-6">
                          <div class="d-flex align-items-center">
                            <div class="ms-3">
                              <p class="mb-0">Daily Achivement %</p>
                              <h6 class="mb-0"><?php echo(round($daily_sale_achivement)); ?>%</h6>
                            </div>
                          </div>
                        </div>

                        <div class="col-md-3 col-6">
                          <div class="d-flex align-items-center">
                            <div class="ms-3">
                              <p class="mb-0">MTD Achivement %</p>
                              <h6 class="mb-0"><?php echo(round($monthly_sale_achivement)); ?>%</h6>
                            </div>
                          </div>
                        </div>

                        

                        <div class="col-md-3 col-6">
                          <div class="d-flex align-items-center">
                            <div class="ms-3">
                              <p class="mb-0">Per Day AVG</p>
                              <h6 class="mb-0"><?php echo(round($avg_sale)); ?></h6>
                            </div>
                          </div>
                        </div>

                        <div class="col-md-3 col-6">
                          <div class="d-flex align-items-center">
                            <div class="ms-3">
                              <p class="mb-0">Remaining Target</p>
                              <h6 class="mb-0"><?php echo($remaining_target); ?></h6>
                            </div>
                          </div>
                        </div>
                        
                        
                      </div>
                    </div>
                  </div>
                </div>
                <!--/ Transactions -->

                <?php
                      }
                  }    
                ?>

                <!-- Data Tables -->
                <div class="col-12">
                  <div class="card overflow-hidden">
                    <div class="table-responsive">
                      <table class="table table-sm">
                        <thead>
                          <tr>
                            <th class="text-truncate">Date</th>
                            <th class="text-truncate">Store</th>
                            <th class="text-truncate">Total Sale</th>
                            <th class="text-truncate">Qty Status</th>
                            <th class="text-truncate">Price Status</th>
                            <th class="text-truncate">Sale Status</th>
                          </tr>
                        </thead>
                        <tbody>
                          <?php
                            $current_date = date("d-m-Y");
                            $uaquery = $db->prepare("SELECT uatid, uid, asid, attendance_date FROM user_attendance WHERE uid = ? ORDER BY uatid DESC LIMIT 0,10");
                            $uaquery->execute(array($_COOKIE['ba']));
                            while($uarow = $uaquery->fetch())
                            {
                              $uid = $uarow['uid'];
                              $attendance_date = $uarow['attendance_date'];

                              $asquery = $db->prepare("SELECT ASS.uid,ASS.asid,ASS.sale_date, SUM(ASS.sale_qty) AS total_sale, ST.stid, ST.store_name, ST.city FROM assignment_sale ASS 
                                  INNER JOIN assignments A ON ASS.asid = A.asid 
                                  INNER JOIN store ST ON A.stid = ST.stid 
                                  WHERE ASS.uid = ? AND ASS.sale_date = ?");
                              $asquery->execute(array($uid,$attendance_date));
                              while($asrow = $asquery->fetch())
                              {
                                  $store_name = $asrow['store_name'];
                                  $store_city = $asrow['city'];
                                  $total_sale = $asrow['total_sale'];
                              }

                              if($current_date == $attendance_date)
                              {
                                  if($uarow['stock_status'] == 0)
                                  {
                                      $qty_status_1 = "warning";
                                      $qty_status_2 = "Pending";  
                                  }
                                  else
                                  {
                                    $qty_status_1 = "success";
                                    $qty_status_2 = "Completed";
                                  }

                                  if($uarow['price_status'] == 0)
                                  {
                                      $price_status_1 = "warning";
                                      $price_status_2 = "Pending";  
                                  }
                                  else
                                  {
                                    $price_status_1 = "success";
                                    $price_status_2 = "Completed";
                                  } 

                                  if($uarow['sale_status'] == 0)
                                  {
                                      $sale_status_1 = "warning";
                                      $sale_status_2 = "Pending";  
                                  }
                                  else
                                  {
                                    $sale_status_1 = "success";
                                    $sale_status_2 = "Completed";
                                  } 
                              }
                              else
                              {
                                if($uarow['stock_status'] == 0)
                                {
                                    $qty_status_1 = "danger";
                                    $qty_status_2 = "Incomplete";  
                                }
                                else
                                {
                                  $qty_status_1 = "success";
                                  $qty_status_2 = "Completed";
                                }

                                if($uarow['price_status'] == 0)
                                {
                                    $price_status_1 = "danger";
                                    $price_status_2 = "Incomplete";  
                                }
                                else
                                {
                                  $price_status_1 = "success";
                                  $price_status_2 = "Completed";
                                }

                                if($uarow['sale_status'] == 0)
                                {
                                    $sale_status_1 = "danger";
                                    $sale_status_2 = "Incomplete";  
                                }
                                else
                                {
                                  $sale_status_1 = "success";
                                  $sale_status_2 = "Completed";
                                }
                              }
                              if($total_sale != Null)
                              {
                          ?>
                          <tr>
                            <td class="text-truncate"><a href="sale_detail.php?atdate=<?php echo($attendance_date); ?>"><?php echo($attendance_date); ?></a></td>
                            <td class="text-truncate"><?php echo($store_name) ?>, <?php echo($store_city) ?></td>
                            <td class="text-truncate"><?php echo($total_sale); ?></td>
                            <td><span class="badge bg-label-<?php echo($qty_status_1); ?> rounded-pill"><?php echo($qty_status_2); ?></span></td>
                            <td><span class="badge bg-label-<?php echo($price_status_1); ?> rounded-pill"><?php echo($price_status_2); ?></span></td>
                            <td><span class="badge bg-label-<?php echo($sale_status_1); ?> rounded-pill"><?php echo($sale_status_2); ?></span></td>
                          </tr>
                          <?php } } ?>
                          
                        </tbody>
                      </table>
                    </div>
                  </div>
                </div>
                <!--/ Data Tables -->
              </div>
            </div>
            <!-- / Content -->

            <!-- Footer -->
            <footer class="content-footer footer bg-footer-theme">
              <div class="container-xxl">
                <div
                  class="footer-container d-flex align-items-center justify-content-between py-4 flex-md-row flex-column">
                  <div class="text-body mb-12 mb-md-0">
                    ©
                    <script>
                      document.write(new Date().getFullYear());
                    </script>
                     - Sentient
                  </div>
                </div>
              </div>
            </footer>
            <!-- / Footer -->

            <div class="content-backdrop fade"></div>
          </div>
          <!-- Content wrapper -->
        </div>
        <!-- / Layout page -->
      </div>

      <!-- Overlay -->
      <div class="layout-overlay layout-menu-toggle"></div>
    </div>
    <!-- / Layout wrapper -->

    
    <?php include("post_buttons.php"); ?>
    <!-- Core JS -->
    <!-- build:js assets/vendor/js/core.js -->
    <script src="assets/vendor/libs/jquery/jquery.js"></script>
    <script src="assets/vendor/libs/popper/popper.js"></script>
    <script src="assets/vendor/js/bootstrap.js"></script>
    <script src="assets/vendor/libs/node-waves/node-waves.js"></script>
    <script src="assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js"></script>
    <script src="assets/vendor/js/menu.js"></script>

    <!-- endbuild -->

    <!-- Vendors JS -->
    <script src="assets/vendor/libs/apex-charts/apexcharts.js"></script>

    <!-- Main JS -->
    <script src="assets/js/main.js"></script>

    <!-- Page JS -->
    <script src="assets/js/dashboards-analytics.js"></script>

    <!-- Place this tag before closing body tag for github widget button. -->
    <script async defer src="https://buttons.github.io/buttons.js"></script>
    
    <script>
      // Simulate progress bar loading
      let progress = 0;
      const progressBar = document.getElementById('progress-bar');
      const interval = setInterval(() => {
        progress += 1;
        progressBar.style.width = progress + '%';
        if (progress >= 100) {
          clearInterval(interval);
          document.body.classList.add('loaded');
        }
      }, 30); // Adjust speed here
    </script>
  </body>
</html>
