<?php  
  require_once("includes/functions.php");
  include_once("includes/errors.php");
  if(!isset($_COOKIE['ba']) && !isset($_COOKIE['sup']))
  {
    header("Location: index.php?");
  }

  if(isset($_COOKIE['suptype']))
  {
      do_logout($db,$URL);  
  }
  else
  {
    if(isset($_REQUEST['btnNext']))
    {
        header("Location: verify_logout_location.php?lat=".$_REQUEST['hdnlat']."&long=".$_REQUEST['hdnlong']."");
    }
    if(isset($_REQUEST['btnCancel']))
    {
        header("Location: main.php?");
    }
?>
<!doctype html>
<html
  lang="en"
  class="light-style layout-wide customizer-hide"
  dir="ltr"
  data-theme="theme-default"
  data-assets-path="assets/"
  data-template="vertical-menu-template-free"
  data-style="light">
  <head>
    <meta charset="utf-8" />
    <meta
      name="viewport"
      content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />

    <title>Sentient App - Verify Logout Location</title>

    <meta name="description" content="" />

    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="assets/img/favicon/favicon.ico" />

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
      href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&ampdisplay=swap"
      rel="stylesheet" />

    <link rel="stylesheet" href="assets/vendor/fonts/remixicon/remixicon.css" />

    <!-- Menu waves for no-customizer fix -->
    <link rel="stylesheet" href="assets/vendor/libs/node-waves/node-waves.css" />

    <!-- Core CSS -->
    <link rel="stylesheet" href="assets/vendor/css/core.css" class="template-customizer-core-css" />
    <link rel="stylesheet" href="assets/vendor/css/theme-default.css" class="template-customizer-theme-css" />
    <link rel="stylesheet" href="assets/css/demo.css" />

    <!-- Vendors CSS -->
    <link rel="stylesheet" href="assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.css" />

    <!-- Page CSS -->
    <!-- Page -->
    <link rel="stylesheet" href="assets/vendor/css/pages/page-auth.css" />

    <!-- Helpers -->
    <script src="assets/vendor/js/helpers.js"></script>
    <!--! Template customizer & Theme config files MUST be included after core stylesheets and helpers.js in the <head> section -->
    <!--? Config:  Mandatory theme config file contain global vars & default theme options, Set your preferred theme option in this file.  -->
    <script src="assets/js/config.js"></script>
  </head>

  <body onload="return getLocation();">
    <!-- Content -->
    <div class="position-relative">
      <div class="authentication-wrapper authentication-basic container-p-y">
        <div class="authentication-inner py-6 mx-4">
          <!-- Login -->
          <div class="card p-7">
            <!-- Logo -->
            <div class="app-brand justify-content-center mt-5">
              <a href="index.html" class="app-brand-link gap-3">
                <span class="app-brand-logo demo">
                  <span style="color: #9055fd">
                    <img src="assets/img/sentient_logo.png" width="75">
                  </span>
                </span>
                <span class="app-brand-text demo text-heading fw-semibold">Sentient App</span>
              </a>
            </div>
            <!-- /Logo -->

            <div class="card-body mt-1">
              <form id="formAuthentication" class="mb-5" method="POST">
                <div class="form-floating form-floating-outline mb-5">
                  
                  <h5 class="mb-1">Start Logout Process</h5>
                  <?php if(isset($_REQUEST['err'])){                  
                    if($_REQUEST['err'] == 4) { $error = "Unable to get User coordinates, Please enbale device location or assign app location rights"; }
                    
                  ?>
                  <p class="mb-5" style="color:red;"><?php echo($error); ?></p>
                  <?php } ?>
                  <!-- <div id="demo"></div> -->
                </div>

                <div id="demo" class="mb-5">
                  <small>Loading coordinates please wait...</small>
                  <button name="btnNext" disabled class="btn btn-primary d-grid w-100" type="submit">Start Process</button>
                  <br>
                  <button name="btnCancel" class="btn btn-danger d-grid w-100" type="submit">Cancel Logout</button>
                </div>
              </form>
     
            </div>
          </div>
          <!-- /Login -->
          
          <img
            src="assets/img/illustrations/auth-basic-mask-light.png"
            class="authentication-image d-none d-lg-block"
            height="172"
            alt="triangle-bg"
            data-app-light-img="illustrations/auth-basic-mask-light.png"
            data-app-dark-img="illustrations/auth-basic-mask-dark.png" />
          
        </div>
      </div>
    </div>
    <script>
        const x = document.getElementById("demo");
        
        function getLocation() {
          if (navigator.geolocation) {
            navigator.geolocation.getCurrentPosition(showPosition);
          } else { 
            x.innerHTML = "Geolocation is not supported by this browser.";
          }

          var lat   = document.Form.elements['hdnlat'].value;
          var long   = document.Form.elements['hdnlong'].value;
          
          alert(lat);return false; 
        }
        
        function showPosition(position) {
          x.innerHTML = "<b>Your Current Position</b><br> Lat: "+ position.coords.latitude +" | Long: " + position.coords.longitude +"  <input type='hidden' name='hdnlat' value='" + position.coords.latitude +"'> <input type='hidden' name='hdnlong' value='" + position.coords.longitude +"'><br><br><button name='btnNext' class='btn btn-primary d-grid w-100' type='submit'>Start Process</button><br><button name='btnCancel' class='btn btn-danger d-grid w-100' type='submit'>Cancel Logout</button>";
        }


    </script>
    <!-- / Content -->
    <!-- Core JS -->
    <!-- build:js assets/vendor/js/core.js -->
    <script src="assets/vendor/libs/jquery/jquery.js"></script>
    <script src="assets/vendor/libs/popper/popper.js"></script>
    <script src="assets/vendor/js/bootstrap.js"></script>
    <script src="assets/vendor/libs/node-waves/node-waves.js"></script>
    <script src="assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js"></script>
    <script src="assets/vendor/js/menu.js"></script>

    <!-- endbuild -->

    <!-- Vendors JS -->

    <!-- Main JS -->
    <script src="assets/js/main.js"></script>

    <!-- Page JS -->

    <!-- Place this tag before closing body tag for github widget button. -->
    <script async defer src="https://buttons.github.io/buttons.js"></script>
  </body>
</html>
<?php
  }
?>