<?php
	include("includes/functions.php");
	include("includes/session.php");
	include("includes/errors.php");
	chk_login();
?>
<!doctype html>
<html>
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
	<!-- Apple devices fullscreen -->
	<meta name="apple-mobile-web-app-capable" content="yes" />
	<!-- Apple devices fullscreen -->
	<meta names="apple-mobile-web-app-status-bar-style" content="black-translucent" />

	<title>Sentient - Work Orders</title>

	<!-- Bootstrap -->
	<link rel="stylesheet" href="css/bootstrap.min.css">
	<!-- jQuery UI -->
	<link rel="stylesheet" href="css/plugins/jquery-ui/jquery-ui.min.css">
	<!-- dataTables -->
	<link rel="stylesheet" href="css/plugins/datatable/TableTools.css">
	<!-- chosen -->
	<link rel="stylesheet" href="css/plugins/chosen/chosen.css">
	<!-- Theme CSS -->
	<link rel="stylesheet" href="css/style.css">
	<!-- Color CSS -->
	<link rel="stylesheet" href="css/themes.css">

	<!-- jQuery -->
	<script src="js/jquery.min.js"></script>

	<!-- Nice Scroll -->
	<script src="js/plugins/nicescroll/jquery.nicescroll.min.js"></script>
	<!-- imagesLoaded -->
	<script src="js/plugins/imagesLoaded/jquery.imagesloaded.min.js"></script>
	<!-- jQuery UI -->
	<script src="js/plugins/jquery-ui/jquery-ui.js"></script>
	<!-- slimScroll -->
	<script src="js/plugins/slimscroll/jquery.slimscroll.min.js"></script>
	<!-- Bootstrap -->
	<script src="js/bootstrap.min.js"></script>
	<!-- Bootbox -->
	<script src="js/plugins/bootbox/jquery.bootbox.js"></script>
	<!-- New DataTables -->
	<script src="js/plugins/momentjs/jquery.moment.min.js"></script>
	<script src="js/plugins/momentjs/moment-range.min.js"></script>
	<script src="js/plugins/datatables/jquery.dataTables.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.tableTools.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.colReorder.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.colVis.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.scroller.min.js"></script>

	<!-- Chosen -->
	<script src="js/plugins/chosen/chosen.jquery.min.js"></script>

	<!-- Theme framework -->
	<script src="js/eakroko.min.js"></script>
	<!-- Theme scripts -->
	<script src="js/application.min.js"></script>
	<!-- Just for demonstration -->
	<script src="js/demonstration.min.js"></script>
	<!--[if lte IE 9]>
	<script src="js/plugins/placeholder/jquery.placeholder.min.js"></script>
	<script>
		$(document).ready(function () {
			$('input, textarea').placeholder();
		});
	</script>
	<![endif]-->
	<script language="javascript" type="text/javascript">
		function DeleteWorkOrder(woid)
		{
			var cd;
			cd = confirm("Are you sure to delete?");
			if(cd)
			{
				window.location.href = "delete_workorder.php?woid="+woid;
			}
		}
	</script>
	<!-- Favicon -->
	<link rel="shortcut icon" href="../img/favicon.png" />
	<!-- Apple devices Homescreen icon -->
	<link rel="apple-touch-icon-precomposed" href="img/apple-touch-icon-precomposed.png" />

</head>

<body class='theme-grey'>
<?php
	$modalcount = 0;
	$count = 0;
	$query = $db->prepare("SELECT * FROM workorder ORDER BY woid DESC");
	$query->execute();
	while($row = $query->fetch())
	{
		$modalcount++;
		$woid = $row['woid'];
?>
<div id="modal-<?php echo($modalcount); ?>" class="modal fade" role="dialog">
	<div class="modal-dialog">
		<div class="modal-content">
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
				<h4 class="modal-title" id="myModalLabel">WO-<?php echo($woid); ?></h4>
			</div>
			<!-- /.modal-header -->
			<div class="modal--body">
				<table width="100%" cellspacing="0" cellpadding="0">
					<?php 
						$wodquery = $db->prepare("SELECT * FROM workorderdetail WD INNER JOIN products P ON WD.pid = P.pid 
													INNER JOIN maincategory M ON P.id = M.id INNER JOIN category C ON P.cid = C.cid WHERE WD.woid = ?");
						$wodquery->execute(array($woid));
						while($wodrow = $wodquery->fetch())
						{
							$count++;
							$woid 	= $wodrow['woid'];
							$wodid 	= $wodrow['wodid'];
							$id 	= $wodrow['pid'];
							$pid 	= $wodrow['pid'];
							$szid 	= $wodrow['szid'];
							$maincategory 	= $wodrow['maincategory'];
							$category 	= $wodrow['category'];
							$pname 	= $wodrow['pname'];
							// $qty 	= $wodrow['woqty'];
							// $comqty = $wodrow['comqty'];
							// $balance = (int)$qty - (int)$comqty;

							// Total Barcodes
							$bcquery = $db->prepare("SELECT bcid, pid, szid, wodid  FROM product_barcodes WHERE wodid = ?");
							$bcquery->execute(array($wodid));
							$qty = $bcquery->rowCount();
							
							// Not Instock Barcodes
							$bcquery1 = $db->prepare("SELECT bcid, pid, szid, wodid, bcstatus  FROM product_barcodes WHERE pid = ? AND szid = ? AND wodid = ? AND bcstatus = ?");
							$bcquery1->execute(array($pid,$szid,$wodid,0));
							$notinstock_qty = $bcquery1->rowCount();

							// Instock Barcodes
							$bcquery2 = $db->prepare("SELECT bcid, pid, szid, wodid, bcstatus  FROM product_barcodes WHERE pid = ? AND szid = ? AND wodid = ? AND bcstatus = ?");
							$bcquery2->execute(array($pid,$szid,$wodid,1));
							$instock_qty = $bcquery2->rowCount();

							// Sold Barcodes
							$bcquery3 = $db->prepare("SELECT bcid, pid, szid, wodid, bcstatus  FROM product_barcodes WHERE pid = ? AND szid = ? AND wodid = ? AND bcstatus = ?");
							$bcquery3->execute(array($pid,$szid,$wodid,2));
							$sold_qty = $bcquery3->rowCount();

							// Canceled Barcodes
							$bcquery4 = $db->prepare("SELECT bcid, pid, szid, wodid, bcstatus  FROM product_barcodes WHERE pid = ? AND szid = ? AND wodid = ? AND bcstatus = ?");
							$bcquery4->execute(array($pid,$szid,$wodid,3));
							$canceled_qty = $bcquery4->rowCount();

							

							$iquery = $db->prepare("SELECT * FROM images WHERE pid=$pid ORDER BY imgid ASC LIMIT 0,1");
							$iquery->execute();
							
							if($iquery->rowCount() > 0)
							{
								while($irow = $iquery->fetch())
								{
									$Image = "../images/products/smallimages/".$irow['image'];
								}
							}
							else
							{
								$Image = "../images/no_image.png";
							}
							$sizequery = $db->prepare("SELECT * FROM product_sizes WHERE szid=?");
							$sizequery->execute(array($szid));
							while($sizerow = $sizequery->fetch())
							{
								$size = $sizerow['size']." - ".$sizerow['sku'];
							}
					?>
					<tr>
						<td height="35" align="left" style="border-bottom: 1px solid #eee; background-color: #eee;">
							&nbsp;&nbsp;<b><?php echo($maincategory." ".$category." ".$pname); ?> <?php echo($size); ?></b>		
							<br>
							&nbsp;
							<small>
								<span style="color:black;">Total: <?php echo($qty); ?></span> | 
								<span style="color:orange;">Not Instock: <?php echo($notinstock_qty); ?></span> | 
								<span style="color:green;">Instock: <?php echo($instock_qty); ?></span> | 
								<span style="color:red;">Sold: <?php echo($sold_qty); ?></span> | 
								<span style="color:brown;">Canceled: <?php echo($canceled_qty); ?></span>
							</small>	
						</td>
						<td height="35" align="center" style="border-bottom: 1px solid #eee; background-color: #eee; font-weight: bold;">Status</td>
					</tr>
					<?php
							$pbcount = 0;
							$pbquery = $db->prepare("SELECT * FROM product_barcodes PB INNER JOIN product_sizes PS ON PB.szid = PS.szid WHERE PB.pid = ? AND PB.szid=? AND wodid=?");
							$pbquery->execute(array($pid,$szid,$wodid));
							while($pbrow = $pbquery->fetch())
							{
								$pbcount++;
								if($pbrow['bcstatus'] == 0){ $status = "<span style='color: orange;'>Not Instock</span>"; }
								if($pbrow['bcstatus'] == 1){ $status = "<span style='color: green;'>Instock</span>"; }
								if($pbrow['bcstatus'] == 2){ $status = "<span style='color: red;'>Sold</span>"; }
								if($pbrow['bcstatus'] == 3){ $status = "<span style='color: brown;'>Canceled</span>"; }
					?>
					<tr>
						<td height="35" align="left" style="border-bottom: 1px solid #eee;">&nbsp;<?php echo($pbcount); ?>. <?php echo($pbrow['barcode']); ?></td>
						<td height="35" align="center" style="border-bottom: 1px solid #eee;"><span style="color:green;"><?php echo($status); ?></span></td>
					</tr>
					<?php
							}
						}	
					?>
				</table>
			</div>
			<!-- /.modal-body -->
			<div class="modal-footer">
				<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
				<!--<button type="button" class="btn btn-primary">Save changes</button>-->
			</div>
			<!-- /.modal-footer -->
		</div>
		<!-- /.modal-content -->
	</div>
	<!-- /.modal-dialog -->
</div>
<!-- /#modal-1.modal fade -->
<?php } ?>

<!-- HEADER START -->
<?php include("top.php"); ?>
<!-- HEADER END -->
<div class="container-fluid" id="content">
<div id="left">
	<form action="search-results.php" method="GET" class='search-form'>
		<div class="search-pane">
			<input type="text" name="search" placeholder="Search here...">
			<button type="submit">
				<i class="fa fa-search"></i>
			</button>
		</div>
	</form>
	<!-- QUICK LINKS -->
	<?php include("left.php"); ?>
	<!-- QUICK LINKS -->
</div>
<div id="main">
<div class="container-fluid">
<div class="page-header">
	<div class="pull-left">
		<h1><i class="fa fa-table"></i> Manage Work Orders</h1>
	</div>
	<div class="pull-right">
	</div>
</div>
<div class="breadcrumbs">
	<ul>
		<li>
			<a href="main.php">Home</a>
			<i class="fa fa-angle-right"></i>
		</li>
		<li>
			<a href="workorders.php">Work Orders</a>
			<i class="fa fa-angle-right"></i>
		</li>
		<li>
			<a href="addworkorder.php">Create New Work Order</a>
		</li>
	</ul>
	<div class="close-bread">
		<a href="#">
			<i class="fa fa-times"></i>
		</a>
	</div>
</div>
<?php
	if(isset($_REQUEST['err']))
	{
?>
<div class="alert alert-success alert-dismissable">
	<button type="button" class="close" data-dismiss="alert">&times;</button>
	<?php echo($ErrMsg); ?>
</div>
<?php
	}
?>	
<div class="row">
	<div class="col-sm-12">
		<div class="box box-color box-bordered">
			<div class="box-title">
				<h3>Manage Work Orders</h3>
			</div>
			<div class="box-content nopadding hscroll">
				<table class="table table-hover table-nomargin table-bordered dataTable">
					<thead>
					<tr>
						<th>Sr.</th>
						<th>Work Order #</th>
						<th align="center" class='hidden-350'>Start Date</th>
						<th align="center" class='hidden-350'>Complete Date</th>
						<th align="center" class='hidden-350'>Qty</th>
						<th align="center" class='hidden-350'>In Progress</th>
						<th align="center" class='hidden-350'>Finished</th>
						<th align="center" class='hidden-350'>Canceled</th>						
						<th align="center" class='hidden-350'>Status</th>
						<th class='hidden-480'>Options</th>
					</tr>
					</thead>
					<tbody>
					<?php
						$count = 0;
						$query = $db->prepare("SELECT * FROM workorder ORDER BY woid DESC");
						$query->execute();
						while($row = $query->fetch())
						{
							$count++;
							$woid = $row['woid'];
							
							// $wodquery = $db->prepare("SELECT SUM(woqty) as wo_qty, SUM(comqty) as com_qty FROM workorderdetail WHERE woid=?");
							// $wodquery->execute(array($woid));
							// while($wodrow = $wodquery->fetch())
							// {
							// 	$wo_qty = $wodrow['wo_qty'];
							// 	$com_qty = $wodrow['com_qty'];

							// 	$inprog_qty = $wo_qty - $com_qty;
							// }

							// Total Barcodes
							$bcquery = $db->prepare("SELECT bcid, woid  FROM product_barcodes WHERE woid = ?");
							$bcquery->execute(array($woid));
							$total_barcodes = $bcquery->rowCount();
							
							// Instock Barcodes
							$bcquery1 = $db->prepare("SELECT bcid, woid, bcstatus  FROM product_barcodes WHERE woid = ? AND bcstatus IN (?,?)");
							$bcquery1->execute(array($woid,1,2));
							$total_instock_barcodes = $bcquery1->rowCount();

							// Canceled Barcodes
							$bcquery2 = $db->prepare("SELECT bcid, woid, bcstatus  FROM product_barcodes WHERE woid = ? AND bcstatus = ?");
							$bcquery2->execute(array($woid,3));
							$canceled_barcodes = $bcquery2->rowCount();

							$inprog_qty = 	$total_barcodes - $total_instock_barcodes - $canceled_barcodes;						

					?>
					<tr>
						<td width="50" align="center" class='hidden-350'><?php echo($count); ?></td>
						<td width="500">WO-<?php echo($row['woid']); ?> &nbsp;  <?php echo($row['woremarks']); ?></td>
						<td width="100" align="center" class='hidden-350'><?php echo(date("d/m/Y",$row['startdate'])); ?></td>
						<td width="100" align="center" class='hidden-350'><?php if($row['completedate'] != 0) { echo(date("d/m/Y",$row['completedate'])); } ?></td>
						<td width="100" align="center" class='hidden-350'><?php echo($total_barcodes); ?></td>
						<td width="100" align="center" class='hidden-350'><?php echo($inprog_qty); ?></td>
						<td width="100" align="center" class='hidden-350'><?php echo($total_instock_barcodes); ?></td>
						<td width="100" align="center" class='hidden-350'><?php echo($canceled_barcodes); ?></td>
						<td width="100" align="center" class='hidden-350'>
							<?php
								if($row['wostatus'] == 0){
							?>
							<span style="color: red;">In Progress</span>
							<?php		
								}
								else
								{
							?>
							<span style="color: green;">Completed</span>
							<?php		
								}
							?>
						</td>
						<td align="center" width="50" class='hidden-480'>
							<a href="#modal-<?php echo($count); ?>" role="button" class="btn" data-toggle="modal"><i class="fa fa-eye"></i></a>
							
							<a href="view_workorder.php?woid=<?php echo($woid); ?>" class="btn" rel="tooltip" title="View">
								<i class="fa fa-edit"></i>
							</a>
							<?php if($total_instock_barcodes == 0){ ?>
							<a href="javascript:Void(0);" class="btn" rel="tooltip" title="Delete" onclick="return DeleteWorkOrder(<?php echo($woid); ?>);">
								<i class="fa fa-times"></i>
							</a>
							<?php } ?>
						</td>
					</tr>
					<?php
						}
					?>
					</tbody>
				</table>
			</div>
		</div>
	</div>
</div>
</div>
</div>
</div>
</body>
</html>
