<?php
	include("includes/functions.php");
	include("includes/session.php");
	include("includes/errors.php");
	chk_login1();
	//if($UserSalesReport == 0) { header("Location: main.php"); }

	// if(isset($_REQUEST['btnPdf']))
	// {
	// 	pdf_sales_report($db,$URL,$_REQUEST['cboCustomer'],$_REQUEST['cboInvoiceType'],$_REQUEST['startdate'],$_REQUEST['enddate']);
	// }

	/**
   * Calculates the great-circle distance between two points, with
   * the Haversine formula.
   * @param float $latitudeFrom Latitude of start point in [deg decimal]
   * @param float $longitudeFrom Longitude of start point in [deg decimal]
   * @param float $latitudeTo Latitude of target point in [deg decimal]
   * @param float $longitudeTo Longitude of target point in [deg decimal]
   * @param float $earthRadius Mean earth radius in [m]
   * @return float Distance between points in [m] (same as earthRadius)
   */
  	function haversineGreatCircleDistance($latitudeFrom, $longitudeFrom, $latitudeTo, $longitudeTo, $earthRadius = 6371000)
  	{
    	// convert from degrees to radians
    	$latFrom = deg2rad($latitudeFrom);
    	$lonFrom = deg2rad($longitudeFrom);
    	$latTo = deg2rad($latitudeTo);
    	$lonTo = deg2rad($longitudeTo);

    	$latDelta = $latTo - $latFrom;
    	$lonDelta = $lonTo - $lonFrom;

    	$angle = 2 * asin(sqrt(pow(sin($latDelta / 2), 2) +
    	  cos($latFrom) * cos($latTo) * pow(sin($lonDelta / 2), 2)));
    	return $angle * $earthRadius;
  	}
?>
<!doctype html>
<html>
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
	<!-- Apple devices fullscreen -->
	<meta name="apple-mobile-web-app-capable" content="yes" />
	<!-- Apple devices fullscreen -->
	<meta names="apple-mobile-web-app-status-bar-style" content="black-translucent" />

	<title>Sentient - Supervisor Visit Store Wise</title>

	<!-- Bootstrap -->
	<link rel="stylesheet" href="css/bootstrap.min.css">
	<!-- jQuery UI -->
	<link rel="stylesheet" href="css/plugins/jquery-ui/jquery-ui.min.css">
	<!-- dataTables -->
	<link rel="stylesheet" href="css/plugins/datatable/TableTools.css">
	<!-- chosen -->
	<link rel="stylesheet" href="css/plugins/chosen/chosen.css">
	<!-- Theme CSS -->
	<link rel="stylesheet" href="css/style.css">
	<!-- Color CSS -->
	<link rel="stylesheet" href="css/themes.css">
	<!-- chosen -->
	<link rel="stylesheet" href="css/plugins/chosen/chosen.css">
	<!-- Ajax -->
	<script src="ajax/ajaxfunctions.js"></script>

	<!-- jQuery -->
	<script src="js/jquery.min.js"></script>

	<!-- Nice Scroll -->
	<script src="js/plugins/nicescroll/jquery.nicescroll.min.js"></script>
	<!-- imagesLoaded -->
	<script src="js/plugins/imagesLoaded/jquery.imagesloaded.min.js"></script>
	<!-- jQuery UI -->
	<script src="js/plugins/jquery-ui/jquery-ui.js"></script>
	<!-- slimScroll -->
	<script src="js/plugins/slimscroll/jquery.slimscroll.min.js"></script>
	<!-- Bootstrap -->
	<script src="js/bootstrap.min.js"></script>
	<!-- Bootbox -->
	<script src="js/plugins/bootbox/jquery.bootbox.js"></script>
	<!-- Chosen -->
	<script src="js/plugins/chosen/chosen.jquery.min.js"></script>
	<!-- Datepicker -->
	<script src="js/plugins/datepicker/bootstrap-datepicker.js"></script>
	
	<!-- New DataTables -->
	<script src="js/plugins/momentjs/jquery.moment.min.js"></script>
	<script src="js/plugins/momentjs/moment-range.min.js"></script>
	<script src="js/plugins/datatables/jquery.dataTables.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.tableTools.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.colReorder.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.colVis.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.scroller.min.js"></script>

	<!-- Chosen -->
	<script src="js/plugins/chosen/chosen.jquery.min.js"></script>

	<!-- Theme framework -->
	<script src="js/eakroko.min.js"></script>
	<!-- Theme scripts -->
	<script src="js/application.min.js"></script>
	<!-- Just for demonstration -->
	<script src="js/demonstration.min.js"></script>
	<script language="javascript" type="text/javascript">
		function PrintReport()
		{
			var fromdate = document.Form.fromdate.value;
			var todate = document.Form.todate.value;
			var stid = document.Form.cboStore.value;
			var id = document.Form.cboSupervisor.value;
			var city = document.Form.cboCity.value;
			var stcid = document.Form.cboStoreChain.value;
			var distance_type = document.Form.cboDistanceType.value;
			var distance = document.Form.txtDistance.value;

			window.open( "visit_store_wise_status.php?fromdate="+fromdate+"&todate="+todate+"&stid="+stid+"&id="+id+"&city="+city+"&stcid="+stcid+"&distance_type="+distance_type+"&distance="+distance+"", "_self")			
		}
	</script>
	<!--[if lte IE 9]>
	<script src="js/plugins/placeholder/jquery.placeholder.min.js"></script>
	<script>
		$(document).ready(function () {
			$('input, textarea').placeholder();
		});
	</script>
	<![endif]-->

	<!-- Favicon -->
	<link rel="shortcut icon" href="../img/favicon.png" />
	<!-- Apple devices Homescreen icon -->
	<link rel="apple-touch-icon-precomposed" href="img/apple-touch-icon-precomposed.png" />

</head>

<body class='theme-grey'>
<!-- HEADER START -->
<?php include("top.php"); ?>
<!-- HEADER END -->
<div class="container-fluid" id="content">
<div id="left">
	<form action="search-results.php" method="GET" class='search-form'>
		<div class="search-pane">
			<input type="text" name="search" placeholder="Search here...">
			<button type="submit">
				<i class="fa fa-search"></i>
			</button>
		</div>
	</form>
	<!-- QUICK LINKS -->
	<?php include("left.php"); ?>
	<!-- QUICK LINKS -->
</div>
<div id="main">
<div class="container-fluid">
<div class="page-header">
	<div class="pull-left">
		<h1><i class="fa fa-table"></i> Supervisor Visit Store Wise</h1>
	</div>
	<div class="pull-right">
	</div>
</div>
<div class="breadcrumbs">
	<ul>
		<li>
			<a href="main.php">Home</a>
			<i class="fa fa-angle-right"></i>
		</li>
		<li>
			<a href="#">Supervisor Visit Store Wise</a>
			<i class="fa fa-angle-right"></i>
		</li>
		
	</ul>
	<div class="close-bread">
		<a href="#">
			<i class="fa fa-times"></i>
		</a>
	</div>
</div>
<?php
	if(isset($_REQUEST['err']))
	{
?>
<div class="alert alert-success alert-dismissable">
	<button type="button" class="close" data-dismiss="alert">&times;</button>
	<?php echo($ErrMsg); ?>
</div>
<?php
	}
?>	
<div class="row">
	<div class="col-sm-12">
		<div class="box">
			
			<div class="box-content nopadding">
				<form name="Form" method="post">
				<table width="100%" class="table table-hover table-nomargin dataTable">
					
					<tbody>
					<tr>
						<td width="10%">From Date</td>
						<td width="40%">
						<input type="date" name="fromdate" value="<?php echo(date("Y-m-d")); ?>" class="form-control">
						</td>
						<td width="10%">To Date</td>
						<td width="40%">
						<input type="date" name="todate" value="<?php echo(date("Y-m-d")); ?>" class="form-control">
						</td>
					</tr>
					
					<tr>
						<td >City</td>
						<td>
							<select name="cboCity" id="cboCity" class="chosen-select form-control">
								<option value="0">All</option>
								<?php
									$cquery = $db->prepare("SELECT * FROM cities WHERE citstatus = 0 ORDER BY city_name ASC");
									$cquery->execute();
									while($crow = $cquery->fetch())
									{
								?>	
								<option value="<?php echo($crow['city_name']); ?>"><?php echo($crow['city_code']); ?> - <?php echo($crow['city_name']); ?></option>
								<?php
									}
								?>
							</select>
						
						</td>
						<td >Chain Store</td>
						<td>
						<select name="cboStoreChain" class="chosen-select form-control">
							<option value="0">Select Store Chain</option>
							<?php
								$scquery = $db->prepare("SELECT * FROM store_chain WHERE stcstatus = 0 ORDER BY store_chain ASC");
								$scquery->execute();
								while($scrow = $scquery->fetch())
								{
							?>
							<option value="<?php echo($scrow['store_chain']); ?>"><?php echo($scrow['store_chain']); ?></option>
							<?php } ?>
						</select>
						</td>
					</tr>
					
					<tr>
						<td >Store</td>
						<td>
						<select name="cboStore" class="chosen-select form-control">
							<option value="0">All</option>
							<?php
								$stquery = $db->prepare("SELECT * FROM store WHERE ststatus = 0 ORDER BY store_name ASC");
								$stquery->execute();
								while($strow = $stquery->fetch())
								{
							?>	
							<option value="<?php echo($strow['stid']); ?>"><?php echo(ucwords($strow['store_name'])); ?>, <?php echo(ucwords($strow['city'])); ?>: ST-<?php echo($strow['store_code']); ?></option>
							<?php
								}
							?>
						</select>
						</td>
						<td >Supervisor</td>
						<td>
						<select name="cboSupervisor" class="chosen-select form-control">
							<option value="0"> </option>
							<?php
								$supquery = $db->prepare("SELECT * FROM users WHERE utype=? AND ustatus = ? ORDER BY fullname ASC");
								$supquery->execute(array(3,0));
								while($suprow = $supquery->fetch())
								{
							?>	
							<option value="<?php echo($suprow['uid']); ?>"><?php echo(ucwords($suprow['fullname'])); ?>: SU-<?php echo($suprow['su_no']); ?></option>
							<?php
								}
							?>
						</select>
						</td>
					</tr>
					
					<tr>
						<td style="padding-top:40px;">Distance</td>
						<td colspan="3">
						<table cellpadding="0" cellspacing="0">
							<tr>
								<td>
								<select name="cboDistanceType" class="select form-control">
									<option value="0">All</option>
									<option value="1">Greater Than</option>
									<option value="2">Less Than</option>
								</select>
								</td>
								<td>
									<table>
										<tr>
											<td><input type="number" name="txtDistance" value="0" class="form-control"></td>
										</tr>
									</table>
									
								</td>
							</tr>
						</table>
						</td>
					</tr>
					<tr>
						<td colspan="4" align="right">
							<div class="form-actions">
								<input name="btnPrint" type="button" class="btn btn-primary" value="  Submit  " onclick="return PrintReport();">
								<!-- <input name="btnPdf" type="submit" class="btn btn-primary" value="  Export PDF  "> -->
							</div>
						</td>
					</tr>
					</tbody>
				</table>
				</form>
			</div>
		</div>
	</div>
</div>
<div class="row">
	<div class="col-sm-12">
		<div class="box">
			
			<div class="box-content">
				<table class="table table-hover table-nomargin table-bordered">
					<thead>
						<tr>
							<th>Sr</th>
							<th>Date</th>
							<th>Brand</th>
							<th>Remarks</th>
							<th>Coordinates</th>
							<th>Distance from Store</th>
							<th>Posted At</th>
						</tr>
					</thead>
					<?php
						$uid = $_REQUEST['id'];
						$stid = $_REQUEST['stid'];
						
						$from_date_timestamp = strtotime($_REQUEST['fromdate']);
						$to_date_timestamp = strtotime($_REQUEST['todate']);

						$from_date = date("d-m-Y",$from_date_timestamp);
						$to_date = date("d-m-Y",$to_date_timestamp);

						if($_REQUEST['id'] != 0)
						{
							$uid = $_REQUEST['id'];
							$suquery = $db->prepare("SELECT uid, su_no, fullname FROM users WHERE uid=?");
							$suquery->execute(array($uid));
							while($surow = $suquery->fetch())
							{
								$su_name = $surow['fullname'].": SU-".$surow['su_no'];
							}
							$q1 = "AND VS.uid = '$uid'";

						}
						else
						{
							$su_name = "All";
							$q1 = "";
						}

						if($_REQUEST['stid'] != 0)
						{
							$stid = $_REQUEST['stid'];
							$stquery = $db->prepare("SELECT stid, store_code, store_name, city FROM store WHERE stid=?");
							$stquery->execute(array($stid));
							while($strow = $stquery->fetch())
							{
								$store_name = $strow['store_name'].", ".$strow['city'].": ST-".$strow['store_code'];
							}
							$q2 = "AND VS.stid = '$stid'";
							$q2_1 = "AND ST.stid = '$stid'";

						}
						else
						{
							$store_name = "All";
							$q2 = "";
							$q2_1 = "";
						}

						if($_REQUEST['city'] != 0 && $_REQUEST['city'] != "")
						{
							$stcity = $_REQUEST['city'];


							/*echo("'".str_replace(",","','",$stcity)."'");
							echo("<br>");
							$temp = array(0,1);
							*/
							//$st_city = "'".str_replace(",","','",$stcity)."'";										
							//$result = "'" . implode ( "', '", $temp ) . "'";

							//echo($result);
							$q3 = "AND ST.city = '$stcity'";
						}
						else{
							$stcity = "All";
							$q3 = "";
						}

						if($_REQUEST['stcid'] != 0)
						{
							$store_chain = $_REQUEST['stcid'];
							$q4 = "AND ST.chain_store = '$store_chain'";

						}
						else{
							$store_chain = "All";
							$q4 = "";
						}
						$distance_value = $_REQUEST['distance'];
						if($_REQUEST['distance_type'] == 0) { $distance_type = "All"; }
						if($_REQUEST['distance_type'] == 1) { $distance_type = "Greater Than $distance_value Meters"; }
						if($_REQUEST['distance_type'] == 2) { $distance_type = "Less Than $distance_value Meters"; }

				        $stquery = $db->prepare("SELECT ASS.asid, ASS.stid, ASS.brid, ASS.uid, ASS.supuid, ASS.asstatus, ST.stid, ST.store_code, ST.store_name, ST.city, BR.brid, BR.brname FROM assignments ASS INNER JOIN store ST ON ASS.stid = ST.stid INNER JOIN brand BR ON ASS.brid = BR.brid WHERE ASS.supuid=".$_REQUEST['id']." AND ASS.asstatus=0 $q2_1 $q3 $q4 GROUP BY ASS.stid");
                        $stquery->execute();
                        while($strow = $stquery->fetch())
                        {
                        	$storeid = $strow['stid'];
                        	if($strow['uid'] > 0)
                        	{
                    ?>
					<tbody>
						<tr>
							<td align="left" class="title" colspan="7" style="background-color: dimgrey; color:white; font-weight: bold;" height="25">ST-<?php echo($strow['store_code']); ?> <?php echo($strow['store_name']); ?>, <?php echo($strow['city']); ?></td>
						</tr>
					</tbody>
					
						<?php
								$count = 0;
								$vsquery = $db->prepare("SELECT * FROM visits VS 
														INNER JOIN users US ON VS.uid = US.uid  
														INNER JOIN store ST ON VS.stid = ST.stid WHERE VS.vdate BETWEEN $from_date_timestamp AND $to_date_timestamp AND VS.stid = $storeid ORDER BY VS.vid DESC");
								$vsquery->execute();
								while($vsrow = $vsquery->fetch())
								{
									
									$vid = $vsrow['vid'];
									$uid = $vsrow['uid'];
									$stid = $vsrow['stid'];

									if($vsrow['post_date'] != 0)
									{
										$post_date = date("d-m-Y h:i A",$vsrow['post_date']);
									}
									else
									{
										$post_date = "N/A";
									}
									//// get brand name

									$store_name = $vsrow['store_name'].", ".$vsrow['city'].": ST-".$vsrow['store_code'];
									$supervisor = $vsrow['fullname'].": SU-".$vsrow['su_no'];
									$remarks = $vsrow['remarks'];
									$visit_date = date("d-m-Y",$vsrow['vdate']);
									
									$vlat = $vsrow['vlat'];
									$vlong = $vsrow['vlong'];

									$stlat = $vsrow['stlat'];
									$stlong = $vsrow['stlong'];

									$store_city = $vsrow['city'];

									if($stlat != "" && $stlong != "")
									{
										$meter_distance = haversineGreatCircleDistance($vlat, $vlong, $stlat, $stlong, $earthRadius = 6371000);
										$sup_distance = $meter_distance;
									}
									else
									{
										$meter_distance = "N/A";
										$sup_distance = 0;
									}
									$distance_status = 0;
									if($_REQUEST['distance_type'] > 0)
									{
										if($_REQUEST['distance_type'] == 1) { if($_REQUEST['distance'] <= $sup_distance) { $distance_status = 1; } else{ $distance_status = 0; } }
										if($_REQUEST['distance_type'] == 2) { if($_REQUEST['distance'] >= $sup_distance) { $distance_status = 1; } else{ $distance_status = 0; } }
									}
									else{
										$distance_status = 1;
									}
									//echo($distance_status);
									if($distance_status == 1)
									{
										$count++;
							?>
							<tbody>	
							<tr>
								<td align="center" class="title" height="25"><?php echo($count); ?>. </td>
								<td align="left"><?php echo(ucwords($visit_date)); ?></td>
								<td align="left">
								<?php
										$ascount = 0;
										$asquery = $db->prepare("SELECT * FROM assignments ASA INNER JOIN brand BR ON ASA.brid = BR.brid WHERE ASA.supuid = ? AND ASA.stid = ?");
										$asquery->execute(array($uid, $stid));
										while($asrow = $asquery->fetch())
										{
											$ascount++;

											if($ascount ==1) { $comma = ""; } else{ $comma = "<br>"; }
											echo($comma.$asrow['brname']);
										}		
								?>
								</td>
								<td align="left"><?php echo(ucwords($remarks)); ?></td>
								<td align="left">Lat: <?php echo($vlat); ?><br>Long: <?php echo($vlong); ?></td>
								<td align="right"><?php if($meter_distance != "N/A") {echo(number_format($meter_distance,2)." Meters");} else{ echo("N/A"); } ?></td>
								<td align="center"><?php echo($post_date); ?></td>
							</tr>
							</tbody>	
							<?php
									}
								}
							}
						}													
								if($count == 0)
								{
							?>
							<tbody>	
							<tr>
								<td align="center" class="title" height="25"> </td>
								<td align="center"></td>
								<td align="center"><span style="color:red; font-weight:bold;">No Records Found!</span></td>
								<td align="center"></td>
								<td align="right">&nbsp;</td>
								<td align="right">&nbsp;</td>
								<td align="right">&nbsp;</td>
							</tr>
							</tbody>	
							<?php
								}	
							?>
				</table>
				
			</div>
		</div>
	</div>
</div>
</div>
</div>
</div>
</body>
</html>