<?php
	include("includes/functions.php");
	include("includes/session.php");
	include("includes/errors.php");
	chk_login();
	if($UserAmenityLog == 0) { header("Location: main.php"); }

	if(isset($_REQUEST['btnCancel']))
	{
		header("Location: amenity_log.php?");
	}
?>
<!doctype html>
<html>
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
	<!-- Apple devices fullscreen -->
	<meta name="apple-mobile-web-app-capable" content="yes" />
	<!-- Apple devices fullscreen -->
	<meta names="apple-mobile-web-app-status-bar-style" content="black-translucent" />

	<title>Sentient - View Amenity Log Entry</title>

	<!-- Bootstrap -->
	<link rel="stylesheet" href="css/bootstrap.min.css">
	<!-- jQuery UI -->
	<link rel="stylesheet" href="css/plugins/jquery-ui/jquery-ui.min.css">
	<!-- Theme CSS -->
	<link rel="stylesheet" href="css/style.css">
	<!-- Color CSS -->
	<link rel="stylesheet" href="css/themes.css">

	<!-- Ajax -->
	<script src="ajax/ajaxfunctions.js"></script>

	<!-- jQuery -->
	<script src="js/jquery.min.js"></script>

	<!-- Nice Scroll -->
	<script src="js/plugins/nicescroll/jquery.nicescroll.min.js"></script>
	<!-- imagesLoaded -->
	<script src="js/plugins/imagesLoaded/jquery.imagesloaded.min.js"></script>
	<!-- jQuery UI -->
	<script src="js/plugins/jquery-ui/jquery-ui.js"></script>
	<!-- slimScroll -->
	<script src="js/plugins/slimscroll/jquery.slimscroll.min.js"></script>
	<!-- Bootstrap -->
	<script src="js/bootstrap.min.js"></script>
	<!-- Bootbox -->
	<script src="js/plugins/bootbox/jquery.bootbox.js"></script>
	<!-- Bootbox -->
	<script src="js/plugins/form/jquery.form.min.js"></script>
	<!-- Datepicker -->
	<script src="js/plugins/datepicker/bootstrap-datepicker.js"></script>
	<!-- Validation -->
	<script src="js/plugins/validation/jquery.validate.min.js"></script>
	<script src="js/plugins/validation/additional-methods.min.js"></script>

	<!-- Theme framework -->
	<script src="js/eakroko.min.js"></script>
	<!-- Theme scripts -->
	<script src="js/application.min.js"></script>
	<!-- Just for demonstration -->
	<script src="js/demonstration.min.js"></script>
	<script type="text/javascript" src="datepickercontrol.js"></script>
	<script language="JavaScript">
		if (navigator.platform.toString().toLowerCase().indexOf("linux") != -1)
		{ document.write('<link type="text/css" rel="stylesheet" href="datepickercontrol_lnx.css">'); }
		else
		{ document.write('<link type="text/css" rel="stylesheet" href="datepickercontrol.css">'); }
	</script>
	
	<link type="text/css" rel="stylesheet" href="content.css">
	<!-- Datepicker -->
	<link rel="stylesheet" href="css/plugins/datepicker/datepicker.css">
	<!--[if lte IE 9]>
		<script src="js/plugins/placeholder/jquery.placeholder.min.js"></script>
		<script>
			$(document).ready(function() {
				$('input, textarea').placeholder();
			});
		</script>
	<![endif]-->

	<!-- Favicon -->
	<link rel="shortcut icon" href="../img/favicon.png" />
	<!-- Apple devices Homescreen icon -->
	<link rel="apple-touch-icon-precomposed" href="img/apple-touch-icon-precomposed.png" />

</head>


<body class='theme-grey'>
<!-- HEADER START -->
	<?php include("top.php"); ?>
	<!-- HEADER END -->
	<div class="container-fluid" id="content">
		<div id="left">
			<form action="search-results.php" method="GET" class='search-form'>
				<div class="search-pane">
					<input type="text" name="search" placeholder="Search here...">
					<button type="submit">
						<i class="fa fa-search"></i>
					</button>
				</div>
			</form>
			<!-- QUICK LINKS -->
			<?php include("left.php"); ?>
			<!-- QUICK LINKS -->	
		</div>
		<div id="main">
			<div class="container-fluid">
				<div class="page-header">
					<div class="pull-left">
						<h1>View Amenity Log Entry</h1>
					</div>
				</div>
				<div class="breadcrumbs">
					<ul>
						<li>
							<a href="main.php">Home</a>
							<i class="fa fa-angle-right"></i>
						</li>
						<li>
							<a href="amenity_log.php">Membership Amenity Log</a>
							<i class="fa fa-angle-right"></i>
						</li>
						<li>
							<a href="addamenity_log.php">Add Amenity Log Entry</a>
						</li>
					</ul>
					<div class="close-bread">
						<a href="#">
							<i class="fa fa-times"></i>
						</a>
					</div>
				</div>
				<form name="Form" action="#" method="POST" class='form-horizontal form-validate' id="bb" enctype="MULTIPART/FORM-DATA">
				<div class="row">
					<div class="col-sm-12">
						<div class="box">
							<div class="box-content">
									<div id="ShowGtNo"></div>
									<div id="ShowMembership"></div>
									<?php
										if(isset($_REQUEST['err']))
										{
									?>
									<div class="alert alert-success alert-dismissable">
										<button type="button" class="close" data-dismiss="alert">&times;</button>
										<?php echo($ErrMsg); ?>
									</div>
									<?php
										}
										$amquery = $db->prepare("SELECT * FROM amenity_log AL INNER JOIN subscriptions S ON AL.subid = S.subid INNER JOIN accounts A ON S.aid = A.aid WHERE AL.amlid=?");
										$amquery->execute(array($_REQUEST['amlid']));
										while($row = $amquery->fetch())
										{
											$amlid 	  = $row['amlid'];
											$subid 	  = $row['subid'];
											$slid 	  = $row['slid'];
											$bid 	  = $row['bid'];							
											$amvalue  = $row['amvalue'];
											$amdetail  = $row['amdetail'];
											
											if($row['amtype'] == 1)
					                      	{
					                          $AmType = "Paper Printing";
					                          $value = $row['amvalue'];
						                    }
					                      	if($row['amtype'] == 2)
					                      	{
					                        	$AmType = "Meeting Room";

					                        	$bquery = $db->prepare("SELECT * FROM booking WHERE bid=?");
					                        	$bquery->execute(array($bid));
					                        	while($brow = $bquery->fetch())
					                        	{
					                        		$seconds = $brow['btimeto'] - $brow['btimefrom'];

					                            	$days = floor($seconds / 86400);
					                            	$seconds %= 86400;

					                            	$hours = floor($seconds / 3600);
					                            	$seconds %= 3600;

					                            	$minutes = floor($seconds / 60);
					                            	$seconds %= 60;
					                              
					                            	if($hours != 0) { $conf_hrs = "$hours Hrs "; } else{ $conf_hrs = ""; }
					                            	if($minutes != 0) { $conf_mins = "$minutes Mins"; } else{ $conf_mins = ""; }

					                            	$value = $conf_hrs.$conf_mins;
					                          	}
					                      	}
						                      if($row['amtype'] == 3)
						                      {
						                          $AmType = "Conference Room";
						                          $bquery = $db->prepare("SELECT * FROM booking WHERE bid=?");
						                          $bquery->execute(array($bid));
						                          while($brow = $bquery->fetch())
						                          {

						                              $seconds = $brow['btimeto'] - $brow['btimefrom'];

						                              $days = floor($seconds / 86400);
						                              $seconds %= 86400;

						                              $hours = floor($seconds / 3600);
						                              $seconds %= 3600;

						                              $minutes = floor($seconds / 60);
						                              $seconds %= 60;
						                              
						                              if($hours != 0) { $conf_hrs = "$hours Hrs "; } else{ $conf_hrs = ""; }
						                              if($minutes != 0) { $conf_mins = "$minutes Mins"; } else{ $conf_mins = ""; }

						                              $amvalue = $conf_hrs.$conf_mins;
						                          	

						                          }
						                          $value = $amvalue;


						                      }
						                      if($row['amtype'] == 4)
						                      {
						                          $AmType = "Generator";
						                          $value = $row['amvalue'];
						                      }
						                      if($row['amtype'] == 5)
						                      {
						                          $AmType = "Electricity";
						                          $value = $crow['amvalue'];
						                      }
						                      if($row['amtype'] == 6)
						                      {
						                          $AmType = "Gas";
						                          $value = $row['amvalue'];
						                      }
						                      if($row['amtype'] == 7)
						                      {
						                          $AmType = "GITMIT Card Replacement";
						                          $value = $row['amvalue'];
						                      }
						                      if($row['amtype'] == 8)
						                      {
						                          $AmType = "GITMIT Card Lost / Not Returned";
						                          $value = $row['amvalue'];
						                      }
											$amdate  = date("d/m/Y",$row['amdate']);
											

											$membership  = $row['subgtno']."-".$row['subtitle'];
											$customer 	 = $row['gtno']."-".$row['aname']." (".$row['aemail'].")";
									?>
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Customer</label>
										<div class="col-sm-10">
											<?php echo($customer); ?>
										</div>
									</div>
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Membership</label>
										<div class="col-sm-10">
											<?php echo($membership); ?>
										</div>
									</div>
									
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Amenity Type <span style="color: red;">*</span></label>
										<div class="col-sm-10">
											<?php echo($AmType); ?>
										</div>
									</div>
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Date</label>
										<div class="col-sm-10">
											<?php echo($amdate); ?>
										</div>
									</div>
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Qty</label>
										<div class="col-sm-10">
											<?php echo($value); ?>
										</div>
									</div>	
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Detail</label>
										<div class="col-sm-10">
											<?php echo($amdetail); ?>
										</div>
									</div>	
									<?php
										}
									?>								
								</div>	
							</div>
						</div>

					</div>
					<div class="form-actions">
						<input name="btnCancel" type="submit" class="btn btn-primary" value="  Return Back  ">
					</div>
				</div>
				</form>
			</div>
		</div>
	</div>
</body>
</html>
