<?php
	include("includes/functions.php");
	include("includes/session.php");
	include("includes/errors.php");
	chk_login();

	if(isset($_REQUEST['btnSubmit']))
	{
		header("Location: returns.php?");
	}
?>
<!doctype html>
<html>
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
	<!-- Apple devices fullscreen -->
	<meta name="apple-mobile-web-app-capable" content="yes" />
	<!-- Apple devices fullscreen -->
	<meta names="apple-mobile-web-app-status-bar-style" content="black-translucent" />

	<title>Sentient - View Return</title>
	
	<!-- Bootstrap -->
	<link rel="stylesheet" href="css/bootstrap.min.css">
	<!-- jQuery UI -->
	<link rel="stylesheet" href="css/plugins/jquery-ui/jquery-ui.min.css">
	<!-- Theme CSS -->
	<link rel="stylesheet" href="css/style.css">
	<!-- Color CSS -->
	<link rel="stylesheet" href="css/themes.css">

	<!-- Ajax -->
	<script src="ajax/ajaxfunctions.js"></script>
	
	<!-- jQuery -->
	<script src="js/jquery.min.js"></script>

	<!-- Nice Scroll -->
	<script src="js/plugins/nicescroll/jquery.nicescroll.min.js"></script>
	<!-- imagesLoaded -->
	<script src="js/plugins/imagesLoaded/jquery.imagesloaded.min.js"></script>
	<!-- jQuery UI -->
	<script src="js/plugins/jquery-ui/jquery-ui.js"></script>
	<!-- slimScroll -->
	<script src="js/plugins/slimscroll/jquery.slimscroll.min.js"></script>
	<!-- Bootstrap -->
	<script src="js/bootstrap.min.js"></script>
	<!-- Bootbox -->
	<script src="js/plugins/bootbox/jquery.bootbox.js"></script>
	<!-- Bootbox -->
	<script src="js/plugins/form/jquery.form.min.js"></script>
	<!-- Validation -->
	<script src="js/plugins/validation/jquery.validate.min.js"></script>
	<script src="js/plugins/validation/additional-methods.min.js"></script>
	<!-- CKEditor -->
	<script src="js/plugins/ckeditor/ckeditor.js"></script>
	<!-- Theme framework -->
	<script src="js/eakroko.min.js"></script>
	<!-- Theme scripts -->
	<script src="js/application.min.js"></script>
	<!-- Just for demonstration -->
	<script src="js/demonstration.min.js"></script>

	<!--[if lte IE 9]>
		<script src="js/plugins/placeholder/jquery.placeholder.min.js"></script>
		<script>
			$(document).ready(function() {
				$('input, textarea').placeholder();
			});
		</script>
	<![endif]-->

	<!-- Favicon -->
	<link rel="shortcut icon" href="img/favicon.ico" />
	<!-- Apple devices Homescreen icon -->
	<link rel="apple-touch-icon-precomposed" href="img/apple-touch-icon-precomposed.png" />
	<script type="text/javascript">
		function getinvoice(invoice_type)
		{
			aid = document.Form.cboCustomer.value;
			var url	  		= "chk_invoice.php?aid="+aid+"&invoice_type="+invoice_type;
			var containerid = "ShowInvoice";
			return GetPage(url, containerid);
		}
		function getproduct(invid)
		{
			var url	  		= "chk_invproduct.php?invid="+invid;
			var containerid = "ShowProduct";
			return GetPage(url, containerid);
		}
		function getqty(pid)
		{
			invid = document.Form.cboInvoice.value;	
			var url	  		= "chk_invqty.php?invid="+invid+"&pid="+pid;
			var containerid = "ShowQty";
			return GetPage(url, containerid);
		}
	</script>
</head>

<body class='theme-grey'>
	<!-- HEADER START -->
	<?php include("top.php"); ?>
	<!-- HEADER END -->
	<div class="container-fluid" id="content">
		<div id="left">
			<form action="search-results.html" method="GET" class='search-form'>
				<div class="search-pane">
					<input type="text" name="search" placeholder="Search here...">
					<button type="submit">
						<i class="fa fa-search"></i>
					</button>
				</div>
			</form>
			<!-- QUICK LINKS -->
			<?php include("left.php"); ?>
			<!-- QUICK LINKS -->	
		</div>
		<div id="main">
			<div class="container-fluid">
				<div class="page-header">
					<div class="pull-left">
						<h1>View Return</h1>
					</div>
				</div>
				<div class="breadcrumbs">
					<ul>
						<li>
							<a href="main.php">Home</a>
							<i class="fa fa-angle-right"></i>
						</li>
						<li>
							<a href="returns.php">Manage Returns</a>
							<i class="fa fa-angle-right"></i>
						</li>
						<li>
							<a href="add_return.php">Create New Return</a>
						</li>
					</ul>
					<div class="close-bread">
						<a href="#">
							<i class="fa fa-times"></i>
						</a>
					</div>
				</div>
				<form name="Form" action="#" method="POST" class='form-horizontal form-validate' id="bb" enctype="MULTIPART/FORM-DATA">
				<div class="row">
					<div class="col-sm-12">
						<div class="box">
							<div class="box-content">
									<div id="ShowUser"></div>
									<div id="GetProduct"></div>
									<?php
										if(isset($_REQUEST['err']))
										{
									?>
									<div class="alert alert-danger alert-dismissable">
										<button type="button" class="close" data-dismiss="alert">&times;</button>
										<?php echo($ErrMsg); ?>
									</div>
									<?php
										}
                                        $query = $db->prepare("SELECT * FROM returns WHERE rid=?");
                                        $query->execute(array($_REQUEST['rid']));
                                        while($row = $query->fetch())
                                        {  
    										$return_barcode = $row['return_barcode'];
									?>
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Return Type</label>
										<div class="col-sm-10">
											<?php if($row['rtype'] == 1){ echo("Item Replacement"); } else{ echo("Item Returned"); } ?>
										</div>
									</div>
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Invoice No</label>
										<div class="col-sm-10" id="ShowInvoice">
											INV-<?php echo($row['invid']); ?>
										</div>
									</div>
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Returned Item</label>
										<div class="col-sm-10" id="ShowProduct">
											<?php echo($row['return_barcode']); ?>
										</div>
									</div>
									<?php if($row['replace_barcode'] != ""){ ?>
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Replace Item</label>
										<div class="col-sm-10" id="ShowProduct1">
											<?php echo($row['replace_barcode']); ?>
										</div>
									</div>
									<?php
										}else{
											$pquery = $db->prepare("SELECT * FROM product_barcodes PB INNER JOIN products P ON PB.pid = P.pid WHERE PB.barcode = ?");
											$pquery->execute(array($return_barcode));
											while($prow = $pquery->fetch())
											{
												$pid = $prow['pid'];
												$szid = $prow['pid'];
											}
									?>
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Returned Item</label>
										<div class="col-sm-10" id="ShowProduct">
											<select name="cboProduct1" class="control-label col-sm-8">
											    <option value="0"> </option>
											    <?php
													$Query = $db->prepare("SELECT * FROM product_barcodes PB INNER JOIN product_sizes PS ON PB.szid = PS.szid INNER JOIN products P ON PB.pid = P.pid WHERE PB.pid = ? AND  PB.szid = ? AND PB.bctype = ? AND PB.bcstatus = ?");
													$Query->execute(array($pid,$szid,'a',1));
													if($Query->rowCount() > 0)
													{
											        	while($row = $Query->fetch())
											        	{
											    ?>
											    <option value="<?php echo($row['barcode']); ?>"><?php echo($row['barcode']); ?> | <?php echo($row['pname']); ?> | SKU: <?php echo($row['sku']); ?> | Size: <?php echo($row['size']); ?></option>
											    <?php
											        	}
													}
													else
													{
											    ?>
											    <option value="0"> </option>
											    <?php
													}
												?>
											</select>
										</div>
									</div>
									<?php } ?>
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Refund Amount</label>
										<div class="col-sm-2">
                                            <?php echo($row['refund_amount']); ?>
                                        </div>
									</div>
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Remarks</label>
										<div class="col-sm-10">
                                            <?php echo($row['remarks']); ?>
										</div>
									</div>
                                    <div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Return Date</label>
										<div class="col-sm-10">
                                            <?php echo(date("d-m-Y h:i A", $row['rdate'])); ?>
										</div>
									</div>
                                    <?php
                                        }
                                    ?>
								</div>	
							</div>
						</div>
					</div>
					<div class="form-actions">
						<input name="btnSubmit" type="submit" class="btn btn-primary" value="  Back  ">
						
					</div>
				</div>		
				</form>
			</div>
		</div>
	</div>
</body>
</html>
