<?php
	include("includes/functions.php");
	include("includes/session.php");
	include("includes/errors.php");
	chk_login();

	if(isset($_REQUEST['btnSubmit']))
	{
		header("Location: purchase_returns.php?");
	}
?>
<!doctype html>
<html>
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
	<!-- Apple devices fullscreen -->
	<meta name="apple-mobile-web-app-capable" content="yes" />
	<!-- Apple devices fullscreen -->
	<meta names="apple-mobile-web-app-status-bar-style" content="black-translucent" />

	<title>Sentient - View Purchase Return</title>
	
	<!-- Bootstrap -->
	<link rel="stylesheet" href="css/bootstrap.min.css">
	<!-- jQuery UI -->
	<link rel="stylesheet" href="css/plugins/jquery-ui/jquery-ui.min.css">
	<!-- Theme CSS -->
	<link rel="stylesheet" href="css/style.css">
	<!-- Color CSS -->
	<link rel="stylesheet" href="css/themes.css">

	<!-- Ajax -->
	<script src="ajax/ajaxfunctions.js"></script>
	
	<!-- jQuery -->
	<script src="js/jquery.min.js"></script>

	<!-- Nice Scroll -->
	<script src="js/plugins/nicescroll/jquery.nicescroll.min.js"></script>
	<!-- imagesLoaded -->
	<script src="js/plugins/imagesLoaded/jquery.imagesloaded.min.js"></script>
	<!-- jQuery UI -->
	<script src="js/plugins/jquery-ui/jquery-ui.js"></script>
	<!-- slimScroll -->
	<script src="js/plugins/slimscroll/jquery.slimscroll.min.js"></script>
	<!-- Bootstrap -->
	<script src="js/bootstrap.min.js"></script>
	<!-- Bootbox -->
	<script src="js/plugins/bootbox/jquery.bootbox.js"></script>
	<!-- Bootbox -->
	<script src="js/plugins/form/jquery.form.min.js"></script>
	<!-- Validation -->
	<script src="js/plugins/validation/jquery.validate.min.js"></script>
	<script src="js/plugins/validation/additional-methods.min.js"></script>
	<!-- CKEditor -->
	<script src="js/plugins/ckeditor/ckeditor.js"></script>
	<!-- Theme framework -->
	<script src="js/eakroko.min.js"></script>
	<!-- Theme scripts -->
	<script src="js/application.min.js"></script>
	<!-- Just for demonstration -->
	<script src="js/demonstration.min.js"></script>

	<!--[if lte IE 9]>
		<script src="js/plugins/placeholder/jquery.placeholder.min.js"></script>
		<script>
			$(document).ready(function() {
				$('input, textarea').placeholder();
			});
		</script>
	<![endif]-->

	<!-- Favicon -->
	<link rel="shortcut icon" href="img/favicon.ico" />
	<!-- Apple devices Homescreen icon -->
	<link rel="apple-touch-icon-precomposed" href="img/apple-touch-icon-precomposed.png" />
</head>

<body class='theme-grey'>
	<!-- HEADER START -->
	<?php include("top.php"); ?>
	<!-- HEADER END -->
	<div class="container-fluid" id="content">
		<div id="left">
			<form action="search-results.html" method="GET" class='search-form'>
				<div class="search-pane">
					<input type="text" name="search" placeholder="Search here...">
					<button type="submit">
						<i class="fa fa-search"></i>
					</button>
				</div>
			</form>
			<!-- QUICK LINKS -->
			<?php include("left.php"); ?>
			<!-- QUICK LINKS -->	
		</div>
		<div id="main">
			<div class="container-fluid">
				<div class="page-header">
					<div class="pull-left">
						<h1>View Purchase Return</h1>
					</div>
				</div>
				<div class="breadcrumbs">
					<ul>
						<li>
							<a href="main.php">Home</a>
							<i class="fa fa-angle-right"></i>
						</li>
						<li>
							<a href="purchase_returns.php">Manage Purchase Returns</a>
							<i class="fa fa-angle-right"></i>
						</li>
						<li>
							<a href="add_purchase_return.php">Create Purchase Return</a>
						</li>
					</ul>
					<div class="close-bread">
						<a href="#">
							<i class="fa fa-times"></i>
						</a>
					</div>
				</div>
				<form name="Form" action="#" method="POST" class='form-horizontal form-validate' id="bb" enctype="MULTIPART/FORM-DATA">
				<div class="row">
					<div class="col-sm-12">
						<div class="box">
							<div class="box-content">
									<div id="ShowUser"></div>
									<div id="GetProduct"></div>
									<?php
										if(isset($_REQUEST['err']))
										{
									?>
									<div class="alert alert-danger alert-dismissable">
										<button type="button" class="close" data-dismiss="alert">&times;</button>
										<?php echo($ErrMsg); ?>
									</div>
									<?php
										}
                                        $query = $db->prepare("SELECT * FROM pur_returns PR INNER JOIN accounts A on PR.aid = A.aid 
                                                                                        INNER JOIN purchase PUR ON PR.purid = PUR.purid 
                                                                                        INNER JOIN rawmaterials R ON PR.rid = R.rid 
                                                                                        WHERE PR.pureid=?");
                                        $query->execute(array($_REQUEST['pureid']));
                                        while($row = $query->fetch())
                                        {
                                            $purno = "PUR-".str_pad($row['purid'], 4, "0", STR_PAD_LEFT);
									?>
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Vendor</label>
										<div class="col-sm-10">
											<?php echo($row['aname']." ".$row['aemail']); ?>
										</div>
									</div>
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Purchase No</label>
										<div class="col-sm-10" id="ShowInvoice">
											<?php echo($purno); ?>
										</div>
									</div>
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Raw Material</label>
										<div class="col-sm-10" id="ShowProduct">
											<?php echo($row['rname']); ?>
										</div>
									</div>
									
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Returned Qty</label>
										<div class="col-sm-2">
                                            <?php echo($row['qty']); ?>
                                        </div>
									</div>
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Returned Amount</label>
										<div class="col-sm-2">
                                            <?php echo($row['reamount']); ?>
                                        </div>
									</div>
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Remarks</label>
										<div class="col-sm-10">
                                            <?php echo($row['reremarks']); ?>
										</div>
									</div>
                                    <div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Return Date</label>
										<div class="col-sm-10">
                                            <?php echo(date("d-m-Y h:i A", $row['redate'])); ?>
										</div>
									</div>
                                    <?php
                                        }
                                    ?>
								</div>	
							</div>
						</div>
					</div>
					<div class="form-actions">
						<input name="btnSubmit" type="submit" class="btn btn-primary" value="  Back  ">
						
					</div>
				</div>		
				</form>
			</div>
		</div>
	</div>
</body>
</html>
