<?php
	include("includes/functions.php");
	include("includes/session.php");
	include("includes/errors.php");
	chk_login();

	
	if(isset($_REQUEST['btnEmail']))
	{
		email_income_invoice($db,$URL,$_REQUEST['invid']);
	}
	
	if(isset($_REQUEST['btnUpdate']))
	{
		update_income_invoice($db,$URL,$_REQUEST['invid']);
	}
	if(isset($_REQUEST['btnPdf']))
	{
		pdf_income_invoice($db,$URL,$_REQUEST['invid']);
	}
?>
<!doctype html>
<html>

<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
	<!-- Apple devices fullscreen -->
	<meta name="apple-mobile-web-app-capable" content="yes" />
	<!-- Apple devices fullscreen -->
	<meta names="apple-mobile-web-app-status-bar-style" content="black-translucent" />

	<title>Sentient - View Income Tax Invoice</title>

	<!-- Bootstrap -->
	<link rel="stylesheet" href="css/bootstrap.min.css">
	<!-- jQuery UI -->
	<link rel="stylesheet" href="css/plugins/jquery-ui/jquery-ui.min.css">
	<!-- Theme CSS -->
	<link rel="stylesheet" href="css/style.css">
	<!-- Color CSS -->
	<link rel="stylesheet" href="css/themes.css">

	<!-- Ajax -->
	<script src="ajax/ajaxfunctions.js"></script>

	<!-- jQuery -->
	<script src="js/jquery.min.js"></script>

	<!-- Nice Scroll -->
	<script src="js/plugins/nicescroll/jquery.nicescroll.min.js"></script>
	<!-- imagesLoaded -->
	<script src="js/plugins/imagesLoaded/jquery.imagesloaded.min.js"></script>
	<!-- jQuery UI -->
	<script src="js/plugins/jquery-ui/jquery-ui.js"></script>
	<!-- slimScroll -->
	<script src="js/plugins/slimscroll/jquery.slimscroll.min.js"></script>
	<!-- Bootstrap -->
	<script src="js/bootstrap.min.js"></script>
	<!-- Bootbox -->
	<script src="js/plugins/bootbox/jquery.bootbox.js"></script>
	<!-- Bootbox -->
	<script src="js/plugins/form/jquery.form.min.js"></script>
	<!-- Datepicker -->
	<script src="js/plugins/datepicker/bootstrap-datepicker.js"></script>
	<!-- Validation -->
	<script src="js/plugins/validation/jquery.validate.min.js"></script>
	<script src="js/plugins/validation/additional-methods.min.js"></script>

	<!-- Theme framework -->
	<script src="js/eakroko.min.js"></script>
	<!-- Theme scripts -->
	<script src="js/application.min.js"></script>
	<!-- Just for demonstration -->
	<script src="js/demonstration.min.js"></script>
	<script type="text/javascript" src="datepickercontrol.js"></script>
	<script language="JavaScript">
		if (navigator.platform.toString().toLowerCase().indexOf("linux") != -1)
		{ document.write('<link type="text/css" rel="stylesheet" href="datepickercontrol_lnx.css">'); }
		else
		{ document.write('<link type="text/css" rel="stylesheet" href="datepickercontrol.css">'); }
	</script>
	<script type="text/javascript" language="javascript">	
		function PrintInvoice(invid)
		{
			window.open( "print_income_invoice.php?invid="+invid , "myWindow", "status = 1, scrollbars=1, height = 650, WIDTH= 900, resizable = 1, top = 0" )
		}
	</script>
	<link type="text/css" rel="stylesheet" href="content.css">
	<!-- Datepicker -->
	<link rel="stylesheet" href="css/plugins/datepicker/datepicker.css">
	<!--[if lte IE 9]>
		<script src="js/plugins/placeholder/jquery.placeholder.min.js"></script>
		<script>
			$(document).ready(function() {
				$('input, textarea').placeholder();
			});
		</script>
	<![endif]-->

	<!-- Favicon -->
	<link rel="shortcut icon" href="../img/favicon.png" />
	<!-- Apple devices Homescreen icon -->
	<link rel="apple-touch-icon-precomposed" href="img/apple-touch-icon-precomposed.png" />

</head>

<body class='theme-grey'>
<!-- HEADER START -->
	<?php include("top.php"); ?>
	<!-- HEADER END -->
	<div class="container-fluid" id="content">
		<div id="left">
			<form action="search-results.php" method="GET" class='search-form'>
				<div class="search-pane">
					<input type="text" name="search" placeholder="Search here...">
					<button type="submit">
						<i class="fa fa-search"></i>
					</button>
				</div>
			</form>
			<!-- QUICK LINKS -->
			<?php include("left.php"); ?>
			<!-- QUICK LINKS -->	
		</div>
		<div id="main">
			<div class="container-fluid">
				<div class="page-header">
					<div class="pull-left">
						<h1><i class="fa fa-table"></i> View Income Tax Invoice</h1>
					</div>
					<div class="pull-right">
					</div>
				</div>
				<div class="breadcrumbs">
					<ul>
						<li>
							<a href="main.php">Home</a>
							<i class="fa fa-angle-right"></i>
						</li>
						<li>
							<a href="income_invoices.php">Income Tax Invoice</a>
							<i class="fa fa-angle-right"></i>
						</li>
						<li>
							<a href="add_income_invoice.php">Create New Income Tax Invoice</a>
						</li>
					</ul>
					<div class="close-bread">
						<a href="#">
							<i class="fa fa-times"></i>
						</a>
					</div>
				</div>
				<form name="Form" action="#" method="POST" class='form-horizontal form-validate' id="bb" enctype="MULTIPART/FORM-DATA">
				<div class="row">
					<div class="col-sm-12">
						<div class="box">
							<div class="box-content">
								
									<div id="ShowUser"></div>
									<?php
										if(isset($_REQUEST['err']))
										{
									?>
									<div class="alert alert-success alert-dismissable">
										<button type="button" class="close" data-dismiss="alert">&times;</button>
										<?php echo($ErrMsg); ?>
									</div>
									<?php
										}
											$query = $db->prepare("SELECT * FROM invoices I INNER JOIN accounts A ON I.aid = A.aid WHERE I.invid = ?");
											$query->execute(array($_REQUEST['invid']));
											while($row = $query->fetch())
											{
												$invid = $row['invid'];
												$invno = "IN-".str_pad($row['invno'], 4, "0", STR_PAD_LEFT);
												$aid = $row['aid'];
												$uid = $row['uid'];

												$totalqty    = $row['totalqty'];
												$subamount = $row['totalamount'] + $row['discount'];
												$discount = $row['discount'];
												$totalamount = $row['totalamount'];
												$paid   	 = $row['paid'];
												$balance 	 = $row['balance'];
									?>
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Invoice #</label>
										<div class="col-sm-2">
											<?php echo($invno); ?>
										</div>
									</div>
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Date</label>
										<div class="col-sm-2">
											<?php echo(date("d/m/Y",$row['invdate'])); ?>
										</div>
									</div>
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Customer</label>
										<div class="col-sm-10"><?php echo($row['aname']." - ".$row['aemail']); ?></div>
									</div>
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Remarks</label>
										<div class="col-sm-10"><?php echo($row['remarks']); ?></div>
									</div>
									<?php
										if($uid != 0)
										{
											$uquery = $db->prepare("SELECT * FROM users WHERE uid=?");
											$uquery->execute(array($uid));
											while($urow = $uquery->fetch())
											{
									?>
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Created By</label>
										<div class="col-sm-10"><?php echo($urow['username']." - ".$urow['fullname']); ?></div>
									</div>
									<?php
											}
										}	
									}
									?>
									<div id="GetNumRow" class="form-group">
										<table width="100%" cellspacing="5" cellpadding="5" >
											<?php
												$count = 0;
												$invquery = $db->prepare("SELECT * FROM invoicedetail ID INNER JOIN products P ON ID.pid = P.pid WHERE ID.invid = ?");
												$invquery->execute(array($_REQUEST['invid']));
												$numitems = $invquery->rowCount();
												if($numitems > 0)
												{
											?>
											<tr>
												<td align="left" bgcolor="#CCCCCC" height="35"> <b>Sr#</b></td>
												<td align="left" bgcolor="#CCCCCC" align="left"><b>Details</b></td>
												<td align="center" bgcolor="#CCCCCC"><b>Image</b></td>
												<td align="center" bgcolor="#CCCCCC"><b>Qty</b></td>
												<td align="right" bgcolor="#CCCCCC"><b>Unit Price</b></td>
												<td align="right" bgcolor="#CCCCCC"><b>Total</b></td>
											</tr>
											<?php
												while($invrow = $invquery->fetch())
												{
													$count++;
													$pid = $invrow['pid'];
													$iquery = $db->prepare("SELECT * FROM images WHERE pid=$pid ORDER BY imgid ASC LIMIT 0,1");
													$iquery->execute();
													
													if($iquery->rowCount() > 0)
													{
														while($irow = $iquery->fetch())
														{
															$Image = "../images/products/smallimages/".$irow['image'];
														}
													}
													else
													{
														$Image = "../images/no_image.png";
													}
											?>
											<tr><td height="10"></td></tr>
											<tr>
												<td align="left" style="border-bottom: 1px solid #eee;"><?php echo($count); ?>.</td>
												<td align="left" width="720" style="border-bottom: 1px solid #eee;">
													<?php echo($invrow['pname']); ?>
													<input type="hidden" name="hdnPid<?php echo($count); ?>" value="<?php echo($invrow['pid']); ?>">
												</td>
												<td align="center" style="border-bottom: 1px solid #eee;"><img src="<?php echo($Image); ?>" width="50"></td>
												<td align="right" style="border-bottom: 1px solid #eee;"><?php echo($invrow['unitprice']); ?></td>
												<td align="center" style="border-bottom: 1px solid #eee;"><?php echo($invrow['invqty']); ?></td>
												<td align="right" style="border-bottom: 1px solid #eee;" align="left"><?php echo($invrow['totalprice']); ?></td>
											</tr>
											<?php
												}
											?>
											<tr><td height="3"></td></tr>
											<tr>
												<td height="40" align="right" colspan="4"><strong>Sub Total</strong></td>
												<td align="right">
													<input type="text" name="txtTotalQty" readonly class="form-control" style="text-align:center; width:100px;" value="<?php echo($totalqty); ?>">
												</td>
												<td align="right">
													<input type="text" name="txtSubTotalCost" readonly class="form-control" style="text-align:right; width:150px;" value="<?php echo($subamount); ?>">
													
												</td>
											</tr>
											<tr>
												<td height="40" align="right" colspan="4"><strong>Discount</strong></td>
												<td></td>
												<td align="right"><input type="text" name="txtDiscount" class="form-control" value="<?php echo($discount); ?>" style="text-align:right; width:150px;"></td>
											</tr>
											<tr>
												<td height="40" align="right" colspan="4"><strong>Total</strong></td>
												<td></td>
												<td align="right"><input type="text" name="txtTotal" class="form-control" value="<?php echo($totalamount); ?>" style="text-align:right; width:150px;"></td>
											</tr>
											<tr>
												<td height="40" align="right" colspan="4"><strong>Paid</strong></td>
												<td></td>
												<td align="right"><input type="text" name="txtPaid" class="form-control" value="<?php echo($paid); ?>" style="text-align:right; width:150px;"></td>
											</tr>
											<tr>
												<td height="40" align="right" colspan="4"><strong>Balance</strong></td>
												<td></td>
												<td align="right"><input type="text" name="txtBalance" readonly value="<?php echo($balance); ?>" readonly class="form-control" style="text-align:right; width:150px;"></td>
											</tr>
										</table>
									</div>
									<div class="form-actions">
										<input name="btnPrint" type="button" onclick="return PrintInvoice(<?php echo($_REQUEST['invid']); ?>);" class="btn btn-primary" value="  Print Customer Invoice  ">
										<!--<button name="btnEmail" type="submit" class="btn btn-success">Email Invoice</button>
										<button name="btnPdf" type="submit" class="btn btn-danger">Download PDF</button>-->
										<button name="btnCancel" type="submit" class="btn">Cancel</button>
									</div>
									<?php } ?>
								</div>
							</div>
						</div>
					</div>
				</div>
				
				</form>
			</div>
		</div>
	</div>
</body>
</html>
