<?php
	include("includes/functions_member.php");
	include("includes/session_member.php");
	include("includes/errors.php");
	chk_login();
?>
<!doctype html>
<html>
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
	<!-- Apple devices fullscreen -->
	<meta name="apple-mobile-web-app-capable" content="yes" />
	<!-- Apple devices fullscreen -->
	<meta names="apple-mobile-web-app-status-bar-style" content="black-translucent" />

	<title>Sentient - Update Profile</title>

	<!-- Bootstrap -->
	<link rel="stylesheet" href="css/bootstrap.min.css">
	<!-- jQuery UI -->
	<link rel="stylesheet" href="css/plugins/jquery-ui/jquery-ui.min.css">
	<!-- Theme CSS -->
	<link rel="stylesheet" href="css/style.css">
	<!-- Color CSS -->
	<link rel="stylesheet" href="css/themes.css">

	<!-- Ajax -->
	<script src="ajax/ajaxfunctions.js"></script>

	<!-- jQuery -->
	<script src="js/jquery.min.js"></script>

	<!-- Nice Scroll -->
	<script src="js/plugins/nicescroll/jquery.nicescroll.min.js"></script>
	<!-- imagesLoaded -->
	<script src="js/plugins/imagesLoaded/jquery.imagesloaded.min.js"></script>
	<!-- jQuery UI -->
	<script src="js/plugins/jquery-ui/jquery-ui.js"></script>
	<!-- slimScroll -->
	<script src="js/plugins/slimscroll/jquery.slimscroll.min.js"></script>
	<!-- Bootstrap -->
	<script src="js/bootstrap.min.js"></script>
	<!-- Bootbox -->
	<script src="js/plugins/bootbox/jquery.bootbox.js"></script>
	<!-- Bootbox -->
	<script src="js/plugins/form/jquery.form.min.js"></script>
	<!-- Validation -->
	<script src="js/plugins/validation/jquery.validate.min.js"></script>
	<script src="js/plugins/validation/additional-methods.min.js"></script>

	<!-- Theme framework -->
	<script src="js/eakroko.min.js"></script>
	<!-- Theme scripts -->
	<script src="js/application.min.js"></script>
	<!-- Just for demonstration -->
	<script src="js/demonstration.min.js"></script>

	<!--[if lte IE 9]>
		<script src="js/plugins/placeholder/jquery.placeholder.min.js"></script>
		<script>
			$(document).ready(function() {
				$('input, textarea').placeholder();
			});
		</script>
	<![endif]-->

	<!-- Favicon -->
	<link rel="shortcut icon" href="../img/favicon.png" />
	<!-- Apple <div></div>evices Homescreen icon -->
	<link rel="apple-touch-icon-precomposed" href="img/apple-touch-icon-precomposed.png" />
	
</head>

<body class='theme-grey'>
<!-- HEADER START -->
	<?php include("member_top.php"); ?>
	<!-- HEADER END -->
	<div class="container-fluid" id="content">
		<div id="left">
			<form action="search-results.php" method="GET" class='search-form'>
				<div class="search-pane">
					<input type="text" name="search" placeholder="Search here...">
					<button type="submit">
						<i class="fa fa-search"></i>
					</button>
				</div>
			</form>
			<!-- QUICK LINKS -->
			<?php include("left.php"); ?>
			<!-- QUICK LINKS -->	
		</div>
		<div id="main">
			<div class="container-fluid">
				<div class="page-header">
					<div class="pull-left">
						<h1>Update Profile</h1>
					</div>
				</div>
				<div class="breadcrumbs">
					<ul>
						<li>
							<a href="member_main.php">Home</a>
							<i class="fa fa-angle-right"></i>
						</li>
						<li>
							<a href="#">Update Profile</a>
							<i class="fa fa-angle-right"></i>
						</li>
						
					</ul>
					<div class="close-bread">
						<a href="#">
							<i class="fa fa-times"></i>
						</a>
					</div>
				</div>
				<?php
					$query = $db->prepare("SELECT * FROM accounts WHERE aid = ?");
					$query->execute(array($AID));
					while($row = $query->fetch())
					{
						$Aid = $row['aid'];
						$Refid = $row['refid'];
						if($row['actype'] == 1) { $A1 = "SELECTED"; $A2 = ""; $A3 = ""; }
						if($row['actype'] == 2) { $A1 = ""; $A2 = "SELECTED"; $A3 = ""; }
						if($row['actype'] == 3) { $A1 = ""; $A2 = ""; $A3 = "SELECTED"; }

						$Lid = $row['lid'];
						$Aid = $row['aid'];
						$Aid = $row['aid'];
				?>
				<form name="Form" method="POST" class='form-horizontal form-validate' id="bb" enctype="MULTIPART/FORM-DATA">
				<div class="row">
					<div class="col-sm-12">
						<div class="box">
							<div class="box-content">
								
									<div id="ShowUser"></div>
									<?php
										if(isset($_REQUEST['err']))
										{
									?>
									<div class="alert alert-success alert-dismissable">
										<button type="button" class="close" data-dismiss="alert">&times;</button>
										<?php echo($ErrMsg); ?>
									</div>
									<?php
										}
									?>
									<div id="ShowMember"></div>
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Refrence</label>
										<div class="col-sm-10">
											<select disabled name="cboRefrence" class="control-label col-sm-4">
												<option value="0">Select Refrence</option>
												<?php
													$catquery = $db->prepare("SELECT * FROM accounts WHERE acmid = 2 ORDER BY aname ASC");
													$catquery->execute();
													while($catrow = $catquery->fetch())
													{
												?>
												<option <?php if($catrow['aid'] == $Refid) { echo("SELECTED"); } ?> value="<?php echo($catrow['aid']); ?>"><?php echo($catrow['aid'].". ".$catrow['aname']." (".$catrow['aemail'].")"); ?></option>
												<?php } ?>
											</select>
										</div>
									</div>
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Account Type</label>
										<div class="col-sm-10">
											<select name="cboAccountType" class="control-label col-sm-4">
												<option <?php echo($A1); ?> value="1">Gold (Refills = 30)</option>
												<option <?php echo($A2); ?> value="2">Platinum (Refills = 60)</option>
												<option <?php echo($A3); ?> value="3">Diamond (Refills = 90)</option>
											</select>
										</div>
									</div>
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Select Location</label>
										<div class="col-sm-10">
											<select name="cboLocation" class="control-label col-sm-4">
												<?php
													if($User_Type != 0) { $l1 = "WHERE lid = ".$UserLid; } else{ $l1 = ""; }
													$lquery = $db->prepare("SELECT * FROM locations $l1 ORDER BY lname ASC");
													$lquery->execute();
													while($lrow = $lquery->fetch())
													{
												?>
												<option <?php if($lrow['lid'] == $Lid) { echo("SELECTED"); } ?> value="<?php echo($lrow['lid']); ?>"><?php echo($lrow['lname']); ?></option>
												<?php
													}
												?>
											</select>
										</div>
									</div>
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Account Name</label>
										<div class="col-sm-10">
											<input type="text" name="txtName" id="textfield" disabled value="<?php echo($row['aname']); ?>" class="form-control" data-rule-required="true" data-rule-minlength="2">
										</div>
									</div>
									
									<div class="form-group">
										<label for="emailfield" class="control-label col-sm-2">Email</label>
										<div class="col-sm-10">
											<input type="text" name="txtEmail" id="emailfield" disabled  value="<?php echo($row['aemail']); ?>" class="form-control" data-rule-email="true" onchange="return chkMemner(this.value);" data-rule-required="true">
										</div>
									</div>
									
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Contact Name</label>
										<div class="col-sm-10">
											<input type="text" name="txtContactName" id="textfield" value="<?php echo($row['contactname']); ?>" class="form-control" data-rule-minlength="2">
										</div>
									</div>
								
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Address</label>
										<div class="col-sm-10">
											<input type="text" name="txtAddress" id="textfield" value="<?php echo($row['aaddress']); ?>" class="form-control" data-rule-minlength="2">
										</div>
									</div>
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">City</label>
										<div class="col-sm-10">
											<input type="text" name="txtCity" id="textfield" value="<?php echo($row['acity']); ?>" class="form-control"  data-rule-minlength="2">
										</div>
									</div>
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Phone</label>
										<div class="col-sm-10">
											<input type="text" name="txtPhone" id="textfield" value="<?php echo($row['aphone']); ?>" class="form-control" data-rule-minlength="2">
										</div>
									</div>
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Mobile</label>
										<div class="col-sm-10">
											<input type="text" name="txtMobile" id="textfield" value="<?php echo($row['amobile']); ?>" class="form-control" data-rule-minlength="2">
										</div>
									</div>
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Fax No</label>
										<div class="col-sm-10">
											<input type="text" name="txtFax" id="textfield" value="<?php echo($row['afax']); ?>" class="form-control" data-rule-minlength="2">
										</div>
									</div>
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Bank Account</label>
										<div class="col-sm-10">
											<input type="text" name="txtBankAccount" id="textfield" value="<?php echo($row['bankaccount']); ?>" class="form-control" data-rule-minlength="2">
										</div>
									</div>
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Bank Details</label>
										<div class="col-sm-10">
											<input type="text" name="txtBankDetails" id="textfield" value="<?php echo($row['bankdetail']); ?>" class="form-control" data-rule-minlength="2">
										</div>
									</div>
								</div>	
							</div>
						</div>
					</div>
					<div class="col-sm-12">
						<div class="box box-bordered box-color green">
							<div class="box-title">
								<h3>
									<i class="fa fa-bars"></i>Manage Refills</h3>
							</div>
							<div class="box-content nopadding">
								<div class="tabs-container">
									<ul class="tabs tabs-inline tabs-left">
										<li class='active'>
											<a href="#first" data-toggle='tab'>
												<i></i>Current Status</a>
										</li>
										<li>
											<a href="#second" data-toggle='tab'>
												<i></i>Refill Ledger</a>
										</li>
										<li>
											<a href="#thirds" data-toggle='tab'>
												<i></i>Add Transaction</a>
										</li>
									</ul>
								</div>
								<?php
									$sumreledger = $db->prepare("SELECT aid, SUM(received) AS totalreceived, SUM(payment) AS totalused FROM reledger WHERE aid = ? ");
									$sumreledger->execute(array($_REQUEST['aid']));
									while($sumrow = $sumreledger->fetch())
									{
										$sum_received = $sumrow['totalreceived'];
										$sum_used = $sumrow['totalused'];
									}
									$totalreledger = $db->prepare("SELECT aid, balance FROM reledger WHERE aid = ? ORDER BY releid DESC LIMIT 0,1");
									$totalreledger->execute(array($_REQUEST['aid']));
									while($totalrow = $totalreledger->fetch())
									{
										$total_balance = $totalrow['balance'];
									}


								?>
								<div class="tab-content padding tab-content-inline">
									<div class="tab-pane active" id="first">
										<p>
											<h1 style="color: orange">Total Refills: <?php echo($sum_received); ?></h1>
											<br>
											<h1 style="color: red">Consumed:  <?php echo($sum_used); ?></h1>
											<br>
											<h1 style="color: green">Total Balance: <?php echo($total_balance); ?></h1>
											<input type="hidden" name="hdnBalance" value="<?php echo($total_balance); ?>">
										</p>
									</div>
									<div class="tab-pane" id="second">
										<table class="table table-hover table-nomargin">
											<thead>
												<tr>
													<th>Sr.</th>
													<th>Date</th>
													<th>Details</th>
													<th class='hidden-350'>Received</th>
													<th class='hidden-350'>Used</th>
													<th class='hidden-350'>Balance</th>
												</tr>
											</thead>
											<tbody>
												<?php
													$recount = 0;
													$requery = $db->prepare("SELECT * FROM reledger WHERE aid=? ORDER BY releid DESC");
													$requery->execute(array($_REQUEST['aid']));
													while($rerow = $requery->fetch())
													{
														$recount++;
												?>
												<tr>
													<td><?php echo($recount); ?></td>
													<td><?php echo(date("d/m/Y", $rerow['reldate'])); ?></td>
													<td align="left"><?php echo($rerow['detail']); ?></td>
													<td class='hidden-350'><span style="color: orange"><?php echo($rerow['received']); ?></span></td>
													<td class='hidden-480'><span style="color: red"><?php echo($rerow['payment']); ?></span></td>
													<td class='hidden-480'><span style="color: green"><?php echo($rerow['balance']); ?></span></td>
												</tr>
												<?php } ?>
											</tbody>
										</table>
									</div>
									<div class="tab-pane" id="thirds">
										<table class="table table-hover table-nomargin dataTable">
											<tbody>
											
											<tr>
												<td width="30%">Amount</td>
												<td width="70%">
												<input type="text" name="txtReAmount" class="form-control">
												</td>
											</tr>
											<tr>
												<td width="30%">Details</td>
												<td width="70%">
												<input type="text" name="txtReDetail" class="form-control">
												</td>
											</tr>
											<tr>
												<td colspan="2" align="right">
													<div class="form-actions">
														<input name="btnReSubmit" type="submit" class="btn btn-primary" value="  Add Refill  ">
														
													</div>
												</td>
											</tr>
											</tbody>
										</table>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>

				<div class="form-actions">
					<input name="btnSubmit" type="submit" class="btn btn-primary" value="  Update Member  ">
					<button type="button" class="btn">Cancel</button>
				</div>
				</form>
			<?php } ?>
			</div>
		</div>
	</div>
</body>
</html>