<?php
	include("includes/functions.php");
	include("includes/session.php");
	include("includes/errors.php");
	chk_login1();
	
	if(isset($_REQUEST['btnXls']))
	{
		$from_date = strtotime($_REQUEST['fromdate']);
		$to_date = strtotime($_REQUEST['todate']) + 86399;
		$surid = $_REQUEST['cboSurvey'];

		include("PhpXlsxGenerator-master/PhpXlsxGenerator.php");
		$fileName = "survey-data_" . date('Y-m-d his') . ".xlsx";


		/// Header
		$surquery = $db->prepare("SELECT SUR.surid, SUR.brid, SUR.surtitle, B.brid, B.brname FROM survey SUR INNER JOIN brand B ON SUR.brid = B.brid ORDER BY SUR.surid ASC");
		$surquery->execute();
		while($surrow = $surquery->fetch())
		{
			$survey = $surrow['brname']."-".$surrow['surtitle'];
		}
		$excelData[] = array('Survey: ', $survey, 'From Date:', date("d-m-Y",$from_date), 'To Date:', date("d-m-Y",$to_date)); 

		/// Title
		$headerData = array();
		$sdquery = $db->prepare("SELECT * FROM survey_detail WHERE surid = ? ORDER BY surdid ASC");
		$sdquery->execute(array($surid));
		while($sdrow = $sdquery->fetch())
		{
			array_push($headerData, $sdrow['surfield']);
		}
		array_push($headerData, "Posted By");
		$excelData[] = $headerData;

		/// Body
		$srcount = 0;
		$srquery = $db->prepare("SELECT * FROM survey_record SR INNER JOIN users U ON SR.uid = U.uid 
								WHERE SR.surid = ? AND SR.surrdate BETWEEN ? AND ? ORDER BY SR.surrid DESC");
		$srquery->execute(array($surid,$from_date, $to_date));
		while($srrow = $srquery->fetch())
		{
			$srcount++;
			$surrid = $srrow['surrid'];
			$post_date = date("d-m-Y h:i A",$srrow['surrdate']);
			$ba = $srrow['fullname']." BA:".$srrow['ba_no'];
			
			$srdcount = 0;
			$lineData = array();
			$srdquery = $db->prepare("SELECT * FROM survey_record_detail WHERE surrid = ? ORDER BY surrdid ASC");
			$srdquery->execute(array($surrid));
			while($srdrow = $srdquery->fetch())
			{
				$srdcount++;
				if($srdrow['surdvalue'] != "") { $value = $srdrow['surdvalue']; } else{ $value = "n/a"; }
			
				array_push($lineData, $value);
			}
			array_push($lineData, $ba." ON ".$post_date);	
			$excelData[] = $lineData;
		}


		// Export data to excel and download as xlsx file 
		$xlsx = CodexWorld\PhpXlsxGenerator::fromArray( $excelData ); 
		$xlsx->downloadAs($fileName); 
		exit;
	}
?>
<!doctype html>
<html>
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
	<!-- Apple devices fullscreen -->
	<meta name="apple-mobile-web-app-capable" content="yes" />
	<!-- Apple devices fullscreen -->
	<meta names="apple-mobile-web-app-status-bar-style" content="black-translucent" />

	<title>Sentient - Survey Report</title>

	<!-- Bootstrap -->
	<link rel="stylesheet" href="css/bootstrap.min.css">
	<!-- jQuery UI -->
	<link rel="stylesheet" href="css/plugins/jquery-ui/jquery-ui.min.css">
	<!-- dataTables -->
	<link rel="stylesheet" href="css/plugins/datatable/TableTools.css">
	<!-- chosen -->
	<link rel="stylesheet" href="css/plugins/chosen/chosen.css">
	<!-- Theme CSS -->
	<link rel="stylesheet" href="css/style.css">
	<!-- Color CSS -->
	<link rel="stylesheet" href="css/themes.css">
	<!-- chosen -->
	<link rel="stylesheet" href="css/plugins/chosen/chosen.css">
	<!-- Ajax -->
	<script src="ajax/ajaxfunctions.js"></script>

	<!-- jQuery -->
	<script src="js/jquery.min.js"></script>

	<!-- Nice Scroll -->
	<script src="js/plugins/nicescroll/jquery.nicescroll.min.js"></script>
	<!-- imagesLoaded -->
	<script src="js/plugins/imagesLoaded/jquery.imagesloaded.min.js"></script>
	<!-- jQuery UI -->
	<script src="js/plugins/jquery-ui/jquery-ui.js"></script>
	<!-- slimScroll -->
	<script src="js/plugins/slimscroll/jquery.slimscroll.min.js"></script>
	<!-- Bootstrap -->
	<script src="js/bootstrap.min.js"></script>
	<!-- Bootbox -->
	<script src="js/plugins/bootbox/jquery.bootbox.js"></script>
	<!-- Chosen -->
	<script src="js/plugins/chosen/chosen.jquery.min.js"></script>
	<!-- Datepicker -->
	<script src="js/plugins/datepicker/bootstrap-datepicker.js"></script>
	
	<!-- New DataTables -->
	<script src="js/plugins/momentjs/jquery.moment.min.js"></script>
	<script src="js/plugins/momentjs/moment-range.min.js"></script>
	<script src="js/plugins/datatables/jquery.dataTables.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.tableTools.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.colReorder.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.colVis.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.scroller.min.js"></script>

	<!-- Chosen -->
	<script src="js/plugins/chosen/chosen.jquery.min.js"></script>

	<!-- Theme framework -->
	<script src="js/eakroko.min.js"></script>
	<!-- Theme scripts -->
	<script src="js/application.min.js"></script>
	<!-- Just for demonstration -->
	<script src="js/demonstration.min.js"></script>
	<script language="javascript" type="text/javascript">
		function PrintReport()
		{
			var fromdate = document.Form.fromdate.value;
			var todate = document.Form.todate.value;
			var id = document.Form.cboSurvey.value;
			
			window.open( "print_survey_report.php?fromdate="+fromdate+"&todate="+todate+"&id="+id+"", "myWindow", "status = 1, scrollbars=1, height = 1000, WIDTH= 1600, resizable = 1, top = 0" )
		}
	</script>
	<!--[if lte IE 9]>
	<script src="js/plugins/placeholder/jquery.placeholder.min.js"></script>
	<script>
		$(document).ready(function () {
			$('input, textarea').placeholder();
		});
	</script>
	<![endif]-->

	<!-- Favicon -->
	<link rel="shortcut icon" href="../img/favicon.png" />
	<!-- Apple devices Homescreen icon -->
	<link rel="apple-touch-icon-precomposed" href="img/apple-touch-icon-precomposed.png" />

</head>

<body class='theme-grey'>
<!-- HEADER START -->
<?php include("top.php"); ?>
<!-- HEADER END -->
<div class="container-fluid" id="content">
<div id="left">
	<form action="search-results.php" method="GET" class='search-form'>
		<div class="search-pane">
			<input type="text" name="search" placeholder="Search here...">
			<button type="submit">
				<i class="fa fa-search"></i>
			</button>
		</div>
	</form>
	<!-- QUICK LINKS -->
	<?php include("left.php"); ?>
	<!-- QUICK LINKS -->
</div>
<div id="main">
<div class="container-fluid">
<div class="page-header">
	<div class="pull-left">
		<h1><i class="fa fa-table"></i> Survey Report</h1>
	</div>
	<div class="pull-right">
	</div>
</div>
<div class="breadcrumbs">
	<ul>
		<li>
			<a href="main.php">Home</a>
			<i class="fa fa-angle-right"></i>
		</li>
		<li>
			<a href="survey_report.php">Survey Report</a>
			<i class="fa fa-angle-right"></i>
		</li>
		
	</ul>
	<div class="close-bread">
		<a href="#">
			<i class="fa fa-times"></i>
		</a>
	</div>
</div>
<?php
	if(isset($_REQUEST['err']))
	{
?>
<div class="alert alert-success alert-dismissable">
	<button type="button" class="close" data-dismiss="alert">&times;</button>
	<?php echo($ErrMsg); ?>
</div>
<?php
	}
?>	
<div class="row">
	<div class="col-sm-6">
		<div class="box box-color box-bordered">
			<div class="box-title">
				<h3>Survey Report</h3>
			</div>
			<div class="box-content nopadding">
				<form name="Form" method="post">
				<table width="100%" class="table table-hover table-nomargin dataTable">
					
					<tbody>
					<tr>
						<td>From Date</td>
						<td>
						<input type="date" name="fromdate" value="<?php echo(date("Y-m-d")); ?>" class="form-control">
						</td>
					</tr>
					<tr>
						<td>From Date</td>
						<td>
						<input type="date" name="todate" value="<?php echo(date("Y-m-d")); ?>" class="form-control">
						</td>
					</tr>
					
					<tr>
						<td >Survey</td>
						<td>
						<select name="cboSurvey" class="chosen-select form-control">
							<?php
								$surquery = $db->prepare("SELECT SUR.surid, SUR.brid, SUR.surtitle, B.brid, B.brname FROM survey SUR INNER JOIN brand B ON SUR.brid = B.brid ORDER BY SUR.surid ASC");
								$surquery->execute();
								while($surrow = $surquery->fetch())
								{
							?>	
							<option value="<?php echo($surrow['surid']); ?>"><?php echo($surrow['brname']); ?> - BA:<?php echo($surrow['surtitle']); ?></option>
							<?php
								}
							?>
						</select>
						</td>
					</tr>
					
					
					<tr>
						<td colspan="2" align="right">
							<div class="form-actions">
								<input name="btnPrint" type="button" class="btn btn-primary" value="  Print Report  " onclick="return PrintReport();">
								<input name="btnXls" type="submit" class="btn btn-success" value="  Export Excel  ">
							</div>
						</td>
					</tr>
					</tbody>
				</table>
				</form>
			</div>
		</div>
	</div>
</div>
</div>
</div>
</div>
</body>
</html>