<?php
	include("includes/functions.php");
	include("includes/session.php");
	include("includes/errors.php");
	chk_login();
	chk_booking_amenity($db,$URL);
	if($UserAddMembership == 0 && $UserEditMembership == 0 && $UserDeleteMembership == 0) { header("Location: main.php"); }
?>
<!doctype html>
<html>
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
	<!-- Apple devices fullscreen -->
	<meta name="apple-mobile-web-app-capable" content="yes" />
	<!-- Apple devices fullscreen -->
	<meta names="apple-mobile-web-app-status-bar-style" content="black-translucent" />

	<title>Sentient - Customer Memberships</title>

	<!-- Bootstrap -->
	<link rel="stylesheet" href="css/bootstrap.min.css">
	<!-- jQuery UI -->
	<link rel="stylesheet" href="css/plugins/jquery-ui/jquery-ui.min.css">
	<!-- dataTables -->
	<link rel="stylesheet" href="css/plugins/datatable/TableTools.css">
	<!-- chosen -->
	<link rel="stylesheet" href="css/plugins/chosen/chosen.css">
	<!-- Theme CSS -->
	<link rel="stylesheet" href="css/style.css">
	<!-- Color CSS -->
	<link rel="stylesheet" href="css/themes.css">

	<!-- jQuery -->
	<script src="js/jquery.min.js"></script>

	<!-- Nice Scroll -->
	<script src="js/plugins/nicescroll/jquery.nicescroll.min.js"></script>
	<!-- imagesLoaded -->
	<script src="js/plugins/imagesLoaded/jquery.imagesloaded.min.js"></script>
	<!-- jQuery UI -->
	<script src="js/plugins/jquery-ui/jquery-ui.js"></script>
	<!-- slimScroll -->
	<script src="js/plugins/slimscroll/jquery.slimscroll.min.js"></script>
	<!-- Bootstrap -->
	<script src="js/bootstrap.min.js"></script>
	<!-- Bootbox -->
	<script src="js/plugins/bootbox/jquery.bootbox.js"></script>
	<!-- New DataTables -->
	<script src="js/plugins/momentjs/jquery.moment.min.js"></script>
	<script src="js/plugins/momentjs/moment-range.min.js"></script>
	<script src="js/plugins/datatables/jquery.dataTables.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.tableTools.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.colReorder.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.colVis.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.scroller.min.js"></script>

	<!-- Chosen -->
	<script src="js/plugins/chosen/chosen.jquery.min.js"></script>

	<!-- Theme framework -->
	<script src="js/eakroko.min.js"></script>
	<!-- Theme scripts -->
	<script src="js/application.min.js"></script>
	<!-- Just for demonstration -->
	<script src="js/demonstration.min.js"></script>
	<script language="javascript" type="text/javascript">
		function DeleteSubs(subid)
		{
			var cd;
			cd = confirm("Are you sure to delete?");
			if(cd)
			{
				window.location.href = "delete_subs.php?subid="+subid;
			}
		}

		function PrintSubMembers(subid)
		{
			var startdate = '';
			var enddate = '';

			window.open( "print_additional_member_report.php?subid="+subid+"", "myWindow", "status = 1, scrollbars=1, height = 1000, WIDTH= 1200, resizable = 1, top = 0" )
		}
	</script>
	<!--[if lte IE 9]>
	<script src="js/plugins/placeholder/jquery.placeholder.min.js"></script>
	<script>
		$(document).ready(function () {
			$('input, textarea').placeholder();
		});
	</script>
	<![endif]-->

	<!-- Favicon -->
	<link rel="shortcut icon" href="../img/favicon.png" />
	<!-- Apple devices Homescreen icon -->
	<link rel="apple-touch-icon-precomposed" href="img/apple-touch-icon-precomposed.png" />

</head>

<body class='theme-grey'>
<!-- HEADER START -->
<?php include("top.php"); ?>
<!-- HEADER END -->
<div class="container-fluid" id="content">
<div id="left">
	<form action="search-results.php" method="GET" class='search-form'>
		<div class="search-pane">
			<input type="text" name="search" placeholder="Search here...">
			<button type="submit">
				<i class="fa fa-search"></i>
			</button>
		</div>
	</form>
	<!-- QUICK LINKS -->
	<?php include("left.php"); ?>
	<!-- QUICK LINKS -->
</div>
<div id="main">
<div class="container-fluid">
<div class="page-header">
	<div class="pull-left">
		<h1><i class="fa fa-table"></i> Customer Membership</h1>
	</div>
	<div class="pull-right">
	</div>
</div>
<div class="breadcrumbs">
	<ul>
		<li>
			<a href="main.php">Home</a>
			<i class="fa fa-angle-right"></i>
		</li>
		<li>
			<a href="subscriptions.php">Memberships</a>
			<i class="fa fa-angle-right"></i>
		</li>
		<?php if($UserAddMembership == 1){ ?>
		<li>
			<a href="addsubs.php">Create New Membership</a>
		</li>
		<?php } ?>
	</ul>
	<div class="close-bread">
		<a href="#">
			<i class="fa fa-times"></i>
		</a>
	</div>
</div>
<?php
	if(isset($_REQUEST['err']))
	{
?>
<div class="alert alert-success alert-dismissable">
	<button type="button" class="close" data-dismiss="alert">&times;</button>
	<?php echo($ErrMsg); ?>
</div>
<?php
	}
?>	
<div class="row">
	<div class="col-sm-12">
		<div class="box box-color box-bordered">
			<div class="box-title">
				<h3>Manage Membership</h3>
			</div>
			<div class="box-content nopadding hscroll">
				<table class="table table-hover table-nomargin table-bordered dataTable">
					<thead>
					<tr>
						<th>Sr.</th>
						<th>Memberships</th>
						<th>Customer</th>
						<th align="center" class='hidden-350'>Team</th>
						<th align="center" class='hidden-350'>Start Date</th>
						<th align="center" class='hidden-350'>End Date</th>
						<th align="center" class='hidden-350'>Package</th>
						<th align="center" class='hidden-350'>Status</th>
						<th class='hidden-480'>Options</th>
					</tr>
					</thead>
					<tbody>
					<?php
						$Count = 0;
						$Query = $db->prepare("SELECT * FROM subscriptions S INNER JOIN accounts A ON S.aid = A.aid WHERE S.subarchived = ? ORDER BY S.subid DESC");
						$Query->execute(array(0));
						while($row = $Query->fetch())
						{
							$Count++;
							$aid 		= $row['aid'];
							$subid 		= $row['subid'];
							$title 	 	= $row['subtitle'];
							
							$subquery = $db->prepare("SELECT * FROM submembers WHERE subid=? AND smarchived = ?");
							$subquery->execute(array($subid,0));
							$nummembers = $subquery->rowCount();

							if($row['startdate'] != 0) { $startdate  = date("d/m/Y",$row['startdate']); } else{ $startdate  = ""; }
							if($row['enddate'] != 0) {$enddate  = date("d/m/Y",$row['enddate']); } else{ $enddate = ''; };

							$price 	 	 = $row['subunitprice'];
							$customer 	 = $row['gtno']." - ".$row['aname']." (".$row['aemail'].")";
					?>
					<tr>
						<td width="50" align="left" class='hidden-350'><?php echo($Count); ?></td>
						<td width="500">
							<?php if($UserEditMembership == 1){ ?>
								<a href="editsubs.php?subid=<?php echo($subid); ?>"><?php echo($row['subgtno']." - ".$title); ?></a>
							<?php }else{ echo($row['subgtno']." - ".$title); } ?>
						</td>
						<td width="500">
							<?php if($UserEditCustomer == 1){ ?>
							<a href="editcustomer.php?aid=<?php echo($row['aid']); ?>" title="<?php echo($customer); ?>">
								<?php echo($customer); ?>
							</a>
							<?php } else { echo($customer); } ?>
						</td>
						<td width="100" align="center" class='hidden-350'><a href="#" onclick="return PrintSubMembers(<?php echo($subid); ?>);"><?php echo($nummembers); ?></a></td>
						<td width="100" align="center" class='hidden-350'><?php echo($startdate); ?></td>
						<td width="100" align="center" class='hidden-350'><?php echo($enddate); ?></td>
						<td width="100" align="right" class='hidden-350'>Rs. <?php echo(number_format($price)); ?></td>
						<td width="100" align="center" class='hidden-350'>
							<?php if($row['substatus'] == 1){ ?>
							<span style="color:red">Disabled</span>
							<?php }else{ ?>
							<span style="color:green">Enabled</span>
							<?php } ?>

						</td>	
						<td width="100" class='hidden-480'>
							<?php if($UserEditMembership == 1){ ?>
							<a href="editsubs.php?subid=<?php echo($subid); ?>" class="btn" rel="tooltip" title="Edit">
								<i class="fa fa-edit"></i>
							</a>
							<?php }if($UserDeleteMembership == 1){ ?>
							<a href="javascript:Void(0);" class="btn" rel="tooltip" title="Delete" onclick="return DeleteSubs(<?php echo($subid); ?>)">
								<i class="fa fa-times"></i>
							</a>
							<?php } ?>
						</td>
					</tr>
					<?php
						}
					?>
					</tbody>
				</table>
			</div>
		</div>
	</div>
</div>
</div>
</div>
</div>
</body>
</html>