<?php
	include("includes/functions_member.php");
	include("includes/session_member.php");
	include("includes/errors.php");
	chk_login();
?>
<!doctype html>
<html>
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
	<!-- Apple devices fullscreen -->
	<meta name="apple-mobile-web-app-capable" content="yes" />
	<!-- Apple devices fullscreen -->
	<meta names="apple-mobile-web-app-status-bar-style" content="black-translucent" />

	<title>Sentient - Refill Log</title>

	<!-- Bootstrap -->
	<link rel="stylesheet" href="css/bootstrap.min.css">
	<!-- jQuery UI -->
	<link rel="stylesheet" href="css/plugins/jquery-ui/jquery-ui.min.css">
	<!-- dataTables -->
	<link rel="stylesheet" href="css/plugins/datatable/TableTools.css">
	<!-- chosen -->
	<link rel="stylesheet" href="css/plugins/chosen/chosen.css">
	<!-- Theme CSS -->
	<link rel="stylesheet" href="css/style.css">
	<!-- Color CSS -->
	<link rel="stylesheet" href="css/themes.css">

	<!-- jQuery -->
	<script src="js/jquery.min.js"></script>

	<!-- Nice Scroll -->
	<script src="js/plugins/nicescroll/jquery.nicescroll.min.js"></script>
	<!-- imagesLoaded -->
	<script src="js/plugins/imagesLoaded/jquery.imagesloaded.min.js"></script>
	<!-- jQuery UI -->
	<script src="js/plugins/jquery-ui/jquery-ui.js"></script>
	<!-- slimScroll -->
	<script src="js/plugins/slimscroll/jquery.slimscroll.min.js"></script>
	<!-- Bootstrap -->
	<script src="js/bootstrap.min.js"></script>
	<!-- Bootbox -->
	<script src="js/plugins/bootbox/jquery.bootbox.js"></script>
	<!-- New DataTables -->
	<script src="js/plugins/momentjs/jquery.moment.min.js"></script>
	<script src="js/plugins/momentjs/moment-range.min.js"></script>
	<script src="js/plugins/datatables/jquery.dataTables.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.tableTools.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.colReorder.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.colVis.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.scroller.min.js"></script>

	<!-- Chosen -->
	<script src="js/plugins/chosen/chosen.jquery.min.js"></script>

	<!-- Theme framework -->
	<script src="js/eakroko.min.js"></script>
	<!-- Theme scripts -->
	<script src="js/application.min.js"></script>
	<!-- Just for demonstration -->
	<script src="js/demonstration.min.js"></script>
	
	<!--[if lte IE 9]>
	<script src="js/plugins/placeholder/jquery.placeholder.min.js"></script>
	<script>
		$(document).ready(function () {
			$('input, textarea').placeholder();
		});
	</script>
	<![endif]-->

	<!-- Favicon -->
	<link rel="shortcut icon" href="../img/favicon.png" />
	<!-- Apple devices Homescreen icon -->
	<link rel="apple-touch-icon-precomposed" href="img/apple-touch-icon-precomposed.png" />

</head>

<body class='theme-grey'>
<!-- HEADER START -->
<?php include("member_top.php"); ?>
<!-- HEADER END -->
<div class="container-fluid" id="content">
<div id="left">
	<form action="search-results.php" method="GET" class='search-form'>
		<div class="search-pane">
			<input type="text" name="search" placeholder="Search here...">
			<button type="submit">
				<i class="fa fa-search"></i>
			</button>
		</div>
	</form>
	<!-- QUICK LINKS -->
	<?php include("left.php"); ?>
	<!-- QUICK LINKS -->
</div>
<div id="main">
<div class="container-fluid">
<div class="page-header">
		<?php
			$sumreledger = $db->prepare("SELECT aid, SUM(received) AS totalreceived, SUM(payment) AS totalused FROM reledger WHERE aid = ? ");
			$sumreledger->execute(array($AID));
			while($sumrow = $sumreledger->fetch())
			{
				$sum_received = $sumrow['totalreceived'];
				$sum_used = $sumrow['totalused'];
			}
			$totalreledger = $db->prepare("SELECT aid, balance FROM reledger WHERE aid = ? ORDER BY releid DESC LIMIT 0,1");
			$totalreledger->execute(array($AID));
			while($totalrow = $totalreledger->fetch())
			{
				$total_balance = $totalrow['balance'];
			}


		?>	<div class="pull-left">
		<h1>
			<span style="color: orange"> Total Refills: <?php echo($sum_received); ?></span>
			<span style="color: red"> Comsumed: <?php echo($sum_used); ?></span>
			<span style="color: green"> Balance: <?php echo($total_balance); ?></span>
		</h1>
	</div>
	<div class="pull-right">
	</div>
</div>
<div class="breadcrumbs">
	<ul>
		<li>
			<a href="member_main.php">Home</a>
			<i class="fa fa-angle-right"></i>
		</li>
		<li>
			<a href="refill_log.php">Refill Log</a>
			<i class="fa fa-angle-right"></i>
		</li>
		
	</ul>
	<div class="close-bread">
		<a href="#">
			<i class="fa fa-times"></i>
		</a>
	</div>
</div>
<?php
	if(isset($_REQUEST['err']))
	{
?>
<div class="alert alert-success alert-dismissable">
	<button type="button" class="close" data-dismiss="alert">&times;</button>
	<?php echo($ErrMsg); ?>
</div>
<?php
	}
?>	
<div class="row">
	<div class="col-sm-12">
		<div class="box box-color box-bordered">
			<div class="box-title">
				<h3>Refill Log</h3>
			</div>
			<div class="box-content nopadding">
				<table class="table table-hover table-nomargin table-bordered dataTable">
					<thead>
					<tr>
						<th align="center" class='hidden-350'>Sr #</th>
						<th align="center" class='hidden-350'>Date</th>
						<th align="center" class='hidden-350'>Details</th>
						<th align="center" class='hidden-350'>Received</th>
						<th align="center" class='hidden-350'>Used</th>
						<th align="center" class='hidden-350'>Balance</th>
					</tr>
					</thead>
					<tbody>
					<?php
						$recount = 0;
						$requery = $db->prepare("SELECT * FROM reledger WHERE aid=? ORDER BY releid DESC");
						$requery->execute(array($AID));
						while($rerow = $requery->fetch())
						{
							$recount++;
					?>
					<tr>
						<td><?php echo($recount); ?></td>
						<td><?php echo(date("d/m/Y", $rerow['reldate'])); ?></td>
						<td align="left"><?php echo($rerow['detail']); ?></td>
						<td class='hidden-350'><span style="color: orange"><?php echo($rerow['received']); ?></span></td>
						<td class='hidden-480'><span style="color: red"><?php echo($rerow['payment']); ?></span></td>
						<td class='hidden-480'><span style="color: green"><?php echo($rerow['balance']); ?></span></td>
					</tr>
					<?php } ?>
					</tbody>
				</table>
			</div>
		</div>
	</div>
</div>
</div>
</div>
</div>
</body>
</html>
