<?php
	include("includes/functions.php");
	include("includes/session.php");
	include("includes/errors.php");
	chk_login();
?>
<!doctype html>
<html>
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
	<!-- Apple devices fullscreen -->
	<meta name="apple-mobile-web-app-capable" content="yes" />
	<!-- Apple devices fullscreen -->
	<meta names="apple-mobile-web-app-status-bar-style" content="black-translucent" />

	<title>Sentient - Raw Materials</title>

	<!-- Bootstrap -->
	<link rel="stylesheet" href="css/bootstrap.min.css">
	<!-- jQuery UI -->
	<link rel="stylesheet" href="css/plugins/jquery-ui/jquery-ui.min.css">
	<!-- dataTables -->
	<link rel="stylesheet" href="css/plugins/datatable/TableTools.css">
	<!-- chosen -->
	<link rel="stylesheet" href="css/plugins/chosen/chosen.css">
	<!-- Theme CSS -->
	<link rel="stylesheet" href="css/style.css">
	<!-- Color CSS -->
	<link rel="stylesheet" href="css/themes.css">

	<!-- jQuery -->
	<script src="js/jquery.min.js"></script>

	<!-- Nice Scroll -->
	<script src="js/plugins/nicescroll/jquery.nicescroll.min.js"></script>
	<!-- imagesLoaded -->
	<script src="js/plugins/imagesLoaded/jquery.imagesloaded.min.js"></script>
	<!-- jQuery UI -->
	<script src="js/plugins/jquery-ui/jquery-ui.js"></script>
	<!-- slimScroll -->
	<script src="js/plugins/slimscroll/jquery.slimscroll.min.js"></script>
	<!-- Bootstrap -->
	<script src="js/bootstrap.min.js"></script>
	<!-- Bootbox -->
	<script src="js/plugins/bootbox/jquery.bootbox.js"></script>
	<!-- New DataTables -->
	<script src="js/plugins/momentjs/jquery.moment.min.js"></script>
	<script src="js/plugins/momentjs/moment-range.min.js"></script>
	<script src="js/plugins/datatables/jquery.dataTables.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.tableTools.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.colReorder.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.colVis.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.scroller.min.js"></script>

	<!-- Chosen -->
	<script src="js/plugins/chosen/chosen.jquery.min.js"></script>

	<!-- Theme framework -->
	<script src="js/eakroko.min.js"></script>
	<!-- Theme scripts -->
	<script src="js/application.min.js"></script>
	<!-- Just for demonstration -->
	<script src="js/demonstration.min.js"></script>
	<script language="javascript" type="text/javascript">
		function DeleteRawMaterial(rid)
		{
			var cd;
			cd = confirm("Are you sure to delete?");
			if(cd)
			{
				window.location.href = "delete_rawmaterial.php?rid="+rid;
			}
		}
	</script>
	<!--[if lte IE 9]>
	<script src="js/plugins/placeholder/jquery.placeholder.min.js"></script>
	<script>
		$(document).ready(function () {
			$('input, textarea').placeholder();
		});
	</script>
	<![endif]-->

	<!-- Favicon -->
	<link rel="shortcut icon" href="../img/favicon.png" />
	<!-- Apple devices Homescreen icon -->
	<link rel="apple-touch-icon-precomposed" href="img/apple-touch-icon-precomposed.png" />

</head>

<body class='theme-grey'>
<!-- HEADER START -->
<?php include("top.php"); ?>
<!-- HEADER END -->
<div class="container-fluid" id="content">
<div id="left">
	<form action="search-results.php" method="GET" class='search-form'>
		<div class="search-pane">
			<input type="text" name="search" placeholder="Search here...">
			<button type="submit">
				<i class="fa fa-search"></i>
			</button>
		</div>
	</form>
	<!-- QUICK LINKS -->
	<?php include("left.php"); ?>
	<!-- QUICK LINKS -->
</div>
<div id="main">
<div class="container-fluid">
<div class="page-header">
	<div class="pull-left">
		<h1><i class="fa fa-table"></i> Manage Raw Materials</h1>
	</div>
	<div class="pull-right">
	<img src="images/dazzle_logo.jpg" width="150" alt="">
		
	</div>
</div>
<div class="breadcrumbs">
	<ul>
		<li>
			<a href="main.php">Home</a>
			<i class="fa fa-angle-right"></i>
		</li>
		<li>
			<a href="rawmaterials.php">Raw Materials</a>
			<i class="fa fa-angle-right"></i>
		</li>
		<li>
			<a href="addrawmaterial.php">Create Raw Material</a>
		</li>
	</ul>
	<div class="close-bread">
		<a href="#">
			<i class="fa fa-times"></i>
		</a>
	</div>
</div>
<?php
	if(isset($_REQUEST['err']))
	{
?>
<div class="alert alert-success alert-dismissable">
	<button type="button" class="close" data-dismiss="alert">&times;</button>
	<?php echo($ErrMsg); ?>
</div>
<?php
	}
?>	
<div class="row">
	<div class="col-sm-12">
		<div class="box box-color">
			<div class="box-content nopadding hscroll">
				<table class="table table-hover table-nomargin table-bordered dataTable">
					<thead>
					<tr>
						<th>Sr.</th>
						<th>Raw Materials</th>
						<th align="center" class='hidden-350'>Unit Type</th>
						<th align="center" class='hidden-350'>Color</th>
						<th align="center" class='hidden-350'>Instock</th>
						<th align="center" class='hidden-350'>In Progress</th>
						<th align="center" class='hidden-350'>Price</th>
						<th align="center" class='hidden-350'>Image</th>
						<th class='hidden-480'>Options</th>
					</tr>
					</thead>
					<tbody>
					<?php
						if(isset($_REQUEST['rmid']) && isset($_REQUEST['rcid'])) { $q1 = "WHERE R.rmid = ".$_REQUEST['rmid']." AND R.rcid = ".$_REQUEST['rcid'].""; } else{ $q1 = ""; }

						$Count = 0;
						$Query = $db->prepare("SELECT * FROM rawmaterials R INNER JOIN rmaincategory RM ON R.rmid = RM.rmid $q1 ORDER BY R.rname ASC");
						$Query->execute();
						while($row = $Query->fetch())
						{
							$Count++;
							$Rmid 		 = $row['rmid'];
							$Rcid 		 = $row['rcid'];
							$Rid 		 = $row['rid'];
							$UnitType = $row['unittype'];
							$Color = $row['rcolor'];
							$RawMainCategory = $row['rmaincategory'];
							
							$Name 	 	 = $row['rname'];
							$Price 		 = $row['rprice'];

							if($_SESSION['usertype'] == 0)
							{
								$rlocation = " AND lid=1";
							}
							else
							{
								$rlocation = "";
							}

							$rlquery = $db->prepare("SELECT * FROM rawlocation WHERE rid=$Rid $rlocation");
							$rlquery->execute();								
							if($rlquery->rowCount() > 0)
							{
								while($rlrow = $rlquery->fetch())
								{
									$qty		 = $rlrow['qty'];
									$inprog_qty = $rlrow['inprog_qty'];
								}
							}
							else
							{
								$qty = "0";
								$inprog_qty = "0";
							}

							if($Rcid > 0)
							{
								$rcquery = $db->prepare("SELECT * FROM rcategory WHERE rcid=$Rcid");
								$rcquery->execute();	
								while($rcrow = $rcquery->fetch())
								{
									$RawCategory = " - ".$rcrow['rcategory'];
								}
							}
							else
							{
								$RawCategory = "";
							}
														
							if($row['rimage'] != "")
							{
								$Image = "<a href='../images/rawmaterials/".$row['rimage']."' target='_blank'><img src='../images/rawmaterials/".$row['rimage']."' width='50'></a>";
							}
							else
							{
								$Image = "<img src='../images/no_image.png' width='50'>";
							}
					?>
					<tr>
						<td width="50"><?php echo($Count); ?></td>
						<td width="850"><?php echo($RawMainCategory.$RawCategory." - ".$Name); ?></td>
						<td width="100" align="center" class='hidden-350'><?php echo($UnitType); ?></td>
						<td width="100" align="center" class='hidden-350'><?php echo($Color); ?></td>
						<td width="100" align="center" class='hidden-350'><?php echo($qty); ?></td>
						<td width="100" align="center" class='hidden-350'><?php echo($inprog_qty); ?></td>
						<td width="100" align="center" class='hidden-350'><?php echo(number_format($Price,2)); ?></td>
						<td align="center" class='hidden-350'><?php echo($Image); ?></td>
						<td width="120" class='hidden-480'>
							<a href="editrawmaterial.php?rid=<?php echo($Rid); ?>" class="btn" rel="tooltip" title="Edit">
								<i class="fa fa-edit"></i>
							</a>
							<a href="javascript:Void(0);" class="btn" rel="tooltip" title="Delete" onclick="return DeleteRawMaterial(<?php echo($Rid); ?>)">
								<i class="fa fa-times"></i>
							</a>
						</td>
					</tr>
					<?php
						}
					?>
					</tbody>
				</table>
			</div>
		</div>
	</div>
</div>
</div>
</div>
</div>
</body>
</html>