<?php
	include("includes/functions.php");
	include("includes/session.php");
	include("includes/errors.php");
	chk_login1($db,$URL);

	/**
   * Calculates the great-circle distance between two points, with
   * the Haversine formula.
   * @param float $latitudeFrom Latitude of start point in [deg decimal]
   * @param float $longitudeFrom Longitude of start point in [deg decimal]
   * @param float $latitudeTo Latitude of target point in [deg decimal]
   * @param float $longitudeTo Longitude of target point in [deg decimal]
   * @param float $earthRadius Mean earth radius in [m]
   * @return float Distance between points in [m] (same as earthRadius)
   */
  	function haversineGreatCircleDistance($latitudeFrom, $longitudeFrom, $latitudeTo, $longitudeTo, $earthRadius = 6371000)
  	{
    	// convert from degrees to radians
    	$latFrom = deg2rad($latitudeFrom);
    	$lonFrom = deg2rad($longitudeFrom);
    	$latTo = deg2rad($latitudeTo);
    	$lonTo = deg2rad($longitudeTo);

    	$latDelta = $latTo - $latFrom;
    	$lonDelta = $lonTo - $lonFrom;

    	$angle = 2 * asin(sqrt(pow(sin($latDelta / 2), 2) +
    	  cos($latFrom) * cos($latTo) * pow(sin($lonDelta / 2), 2)));
    	return $angle * $earthRadius;
  	}
?>

<!doctype html>
<html>

<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
	<!-- Apple devices fullscreen -->
	<meta name="apple-mobile-web-app-capable" content="yes" />
	<!-- Apple devices fullscreen -->
	<meta names="apple-mobile-web-app-status-bar-style" content="black-translucent" />

	<title>Sentient - Supervisor Store Wise Visit Report</title>

	<!-- Bootstrap -->
	<link rel="stylesheet" href="css/bootstrap.min.css">
	<!-- jQuery UI -->
	<link rel="stylesheet" href="css/plugins/jquery-ui/jquery-ui.min.css">
	<!-- dataTables -->
	<link rel="stylesheet" href="css/plugins/datatable/TableTools.css">
	<!-- chosen -->
	<link rel="stylesheet" href="css/plugins/chosen/chosen.css">
	<!-- Theme CSS -->
	<link rel="stylesheet" href="css/style.css">
	<!-- Color CSS -->
	<link rel="stylesheet" href="css/themes.css">

	<!-- jQuery -->
	<script src="js/jquery.min.js"></script>

	<!-- Nice Scroll -->
	<script src="js/plugins/nicescroll/jquery.nicescroll.min.js"></script>
	<!-- imagesLoaded -->
	<script src="js/plugins/imagesLoaded/jquery.imagesloaded.min.js"></script>
	<!-- jQuery UI -->
	<script src="js/plugins/jquery-ui/jquery-ui.js"></script>
	<!-- slimScroll -->
	<script src="js/plugins/slimscroll/jquery.slimscroll.min.js"></script>
	<!-- Bootstrap -->
	<script src="js/bootstrap.min.js"></script>
	<!-- Bootbox -->
	<script src="js/plugins/bootbox/jquery.bootbox.js"></script>
	<!-- New DataTables -->
	<script src="js/plugins/momentjs/jquery.moment.min.js"></script>
	<script src="js/plugins/momentjs/moment-range.min.js"></script>
	<script src="js/plugins/datatables/jquery.dataTables.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.tableTools.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.colReorder.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.colVis.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.scroller.min.js"></script>

	<!-- Chosen -->
	<script src="js/plugins/chosen/chosen.jquery.min.js"></script>

	<!-- Theme framework -->
	<script src="js/eakroko.min.js"></script>
	<!-- Theme scripts -->
	<script src="js/application.min.js"></script>
	<!-- Just for demonstration -->
	<script src="js/demonstration.min.js"></script>

	<!--[if lte IE 9]>
		<script src="js/plugins/placeholder/jquery.placeholder.min.js"></script>
		<script>
			$(document).ready(function() {
				$('input, textarea').placeholder();
			});
		</script>
	<![endif]-->

	<!-- Favicon -->
	<link rel="shortcut icon" href="img/favicon.png" />
	<!-- Apple devices Homescreen icon -->
	<link rel="apple-touch-icon-precomposed" href="img/apple-touch-icon-precomposed.png" />

</head>

<body>
	<div class="container-fluid nav-hidden" id="content">
		<div id="main">
			<div class="container-fluid">
				
				
				<div class="row">
					<div class="col-sm-12">
						<div class="box">
							
							<div class="box-content">
								<div class="invoice-info">
									
									<div class="invoice-from">
										<br>
										<img src="images/sentient_logo.jpg" width="125">
								
										<address>
											Sentient
											<br>Lahore
											
										</address>
									</div>
									
									<div class="invoice-infos">
										<h1>Store Wise Visit Report</h1>
										<?php
											$uid = $_REQUEST['id'];
											$stid = $_REQUEST['stid'];
											$brid = $_REQUEST['brid'];
											
											$from_date_timestamp = strtotime($_REQUEST['fromdate']);
											$to_date_timestamp = strtotime($_REQUEST['todate']);

											$from_date = date("d-m-Y",$from_date_timestamp);
											$to_date = date("d-m-Y",$to_date_timestamp);

											if($_REQUEST['id'] != 0)
											{
												$uid = $_REQUEST['id'];
												$suquery = $db->prepare("SELECT uid, su_no, fullname FROM users WHERE uid=?");
												$suquery->execute(array($uid));
												while($surow = $suquery->fetch())
												{
													$su_name = $surow['fullname'].": SU-".$surow['su_no'];
												}
												$q1 = "AND VS.uid = '$uid'";

											}
											else
											{
												$su_name = "All";
												$q1 = "";
											}

											if($_REQUEST['stid'] != 0)
											{
												$stid = $_REQUEST['stid'];
												$stquery = $db->prepare("SELECT stid, store_code, store_name, city FROM store WHERE stid=?");
												$stquery->execute(array($stid));
												while($strow = $stquery->fetch())
												{
													$store_name = $strow['store_name'].", ".$strow['city'].": ST-".$strow['store_code'];
												}
												$q2 = "AND VS.stid = '$stid'";
												$q2_1 = "AND ST.stid = '$stid'";

											}
											else
											{
												$store_name = "All";
												$q2 = "";
												$q2_1 = "";
											}

											if($_REQUEST['city'] != 0 && $_REQUEST['city'] != "")
											{
												$stcity = $_REQUEST['city'];


												/*echo("'".str_replace(",","','",$stcity)."'");
												echo("<br>");
												$temp = array(0,1);
												*/
												//$st_city = "'".str_replace(",","','",$stcity)."'";										
												//$result = "'" . implode ( "', '", $temp ) . "'";

												//echo($result);
												$q3 = "AND ST.city = '$stcity'";
											}
											else{
												$stcity = "All";
												$q3 = "";
											}

											if($_REQUEST['stcid'] != 0 && $_REQUEST['stcid'] != "")
											{
												$store_chain = $_REQUEST['stcid'];


												/*echo("'".str_replace(",","','",$stcity)."'");
												echo("<br>");
												$temp = array(0,1);
						*/
												$st_store_chain= "'".str_replace(",","','",$store_chain)."'";										
												//$result = "'" . implode ( "', '", $temp ) . "'";

												//echo($result);
												$q4 = "AND ST.chain_store IN ($st_store_chain)";

											}
											else{
												$store_chain = "All";
												$q4 = "";
											}

											if($_REQUEST['brid'] != 0)
											{
												$brid = $_REQUEST['brid'];
												$brquery = $db->prepare("SELECT brid, brname FROM brand WHERE brid=?");
												$brquery->execute(array($brid));
												while($brrow = $brquery->fetch())
												{
													$brand_name = $brrow['brname'];
												}
												$q5 = "AND VS.brid = '$brid'";
												$q5_1 = "AND BR.brid = '$brid'";

											}
											else
											{
												$brand_name = "All";
												$q5 = "";
												$q5_1 = "";
											}
											$q6 = "AND VS.uid NOT IN (489, 179, 222, 1288, 1205, 1289, 159, 124, 1311, 1290, 943, 1025, 413, 415)";
					
											$distance_value = $_REQUEST['distance'];
											if($_REQUEST['distance_type'] == 0) { $distance_type = "All"; }
											if($_REQUEST['distance_type'] == 1) { $distance_type = "Greater Than $distance_value Meters"; }
											if($_REQUEST['distance_type'] == 2) { $distance_type = "Less Than $distance_value Meters"; }
										?>

										<table>
											<tr><td>&nbsp;</td></tr>
											<tr><td align="left"><b>From Date: <?php echo($from_date); ?></b></td></tr>
											<tr><td align="left"><b>To Date: <?php echo($to_date); ?></b></td></tr>
											<tr><td align="left"><b>Brand: <?php echo($brand_name); ?></b></td></tr>
											<tr><td align="left"><b>City: <?php echo($stcity); ?></b></td></tr>
											<tr><td align="left"><b>Supervisor: <?php echo($su_name); ?></b></td></tr>
											<tr><td align="left"><b>Store Chain: <?php echo($store_chain); ?></b></td></tr>
											<tr><td align="left"><b>Store: <?php echo($store_name); ?></b></td></tr>
											<tr><td align="left"><b>Distance: <?php echo($distance_type); ?></b></td></tr>
										</table>
									</div>
								</div>
								<table class="table table-hover table-nomargin table-bordered">
									<thead>
										<tr>
											<th>Sr</th>
											<th>Date</th>
											<th>Brand</th>
											<th>Remarks</th>
											<th>Coordinates</th>
											<th>Distance from Store</th>
											<th>Posted At</th>
										</tr>
									</thead>

									<?php
										$count = 0;
								        $stquery = $db->prepare("SELECT * FROM visits VS INNER JOIN store ST ON VS.stid = ST.stid INNER JOIN brand BR ON VS.brid = BR.brid WHERE VS.post_date <> 0 AND VS.vdate BETWEEN $from_date_timestamp AND $to_date_timestamp $q1 $q2 $q3 $q4 $q5 $q6 GROUP BY VS.stid");
		                                $stquery->execute();
		                                while($strow = $stquery->fetch())
		                                {
		                                	$storeid = $strow['stid'];
		                            ?>
									<tbody>
										<tr>
											<td align="left" class="title" colspan="7" style="background-color: dimgrey; color:white; font-weight: bold;" height="25">ST-<?php echo($strow['store_code']); ?> <?php echo($strow['store_name']); ?>, <?php echo($strow['city']); ?></td>
										</tr>
									</tbody>
									
										<?php
												$count = 0;
												$vsquery = $db->prepare("SELECT * FROM visits VS 
																		INNER JOIN users US ON VS.uid = US.uid  
																		INNER JOIN store ST ON VS.stid = ST.stid WHERE VS.vdate BETWEEN $from_date_timestamp AND $to_date_timestamp AND VS.stid = $storeid $q5 $q6 ORDER BY VS.post_date ASC");
												$vsquery->execute();
												while($vsrow = $vsquery->fetch())
												{
													
													$vid = $vsrow['vid'];
													$uid = $vsrow['uid'];
													$stid = $vsrow['stid'];
													$brid = $vsrow['brid'];

													if($vsrow['post_date'] != 0)
													{
														$post_date = date("d-m-Y h:i A",$vsrow['post_date']);
													}
													else
													{
														$post_date = "N/A";
													}
													//// get brand name

													$store_name = $vsrow['store_name'].", ".$vsrow['city'].": ST-".$vsrow['store_code'];
													$supervisor = $vsrow['fullname'].": SU-".$vsrow['su_no'];
													$remarks = $vsrow['remarks'];
													$visit_date = date("d-m-Y",$vsrow['vdate']);
													
													$vlat = $vsrow['vlat'];
													$vlong = $vsrow['vlong'];

													$stlat = $vsrow['stlat'];
													$stlong = $vsrow['stlong'];

													$store_city = $vsrow['city'];

													if($stlat != "" && $stlong != "")
													{
														$meter_distance = "N/A";
														$sup_distance = 0;
														// $meter_distance = haversineGreatCircleDistance($vlat, $vlong, $stlat, $stlong, $earthRadius = 6371000);
														// $sup_distance = $meter_distance;
													}
													else
													{
														$meter_distance = "N/A";
														$sup_distance = 0;
													}
													$distance_status = 0;
													if($_REQUEST['distance_type'] > 0)
													{
														if($_REQUEST['distance_type'] == 1) { if($_REQUEST['distance'] <= $sup_distance) { $distance_status = 1; } else{ $distance_status = 0; } }
														if($_REQUEST['distance_type'] == 2) { if($_REQUEST['distance'] >= $sup_distance) { $distance_status = 1; } else{ $distance_status = 0; } }
													}
													else{
														$distance_status = 1;
													}
													//echo($distance_status);
													if($distance_status == 1)
													{
														$count++;
											?>
											<tbody>	
											<tr>
												<td align="center" class="title" height="25"><?php echo($count); ?>. </td>
												<td align="left"><?php echo(ucwords($visit_date)); ?></td>
												<td align="left">
												<?php
													$ascount = 0;
														
													if($brid == 0)
													{
														$asquery = $db->prepare("SELECT * FROM assignments ASA INNER JOIN brand BR ON ASA.brid = BR.brid WHERE ASA.supuid = ? AND ASA.stid = ?");
														$asquery->execute(array($uid, $stid));
															
													}
													else
													{
														$asquery = $db->prepare("SELECT * FROM assignments ASA INNER JOIN brand BR ON ASA.brid = BR.brid WHERE ASA.supuid = ? AND ASA.stid = ? AND ASA.brid = ?");
														$asquery->execute(array($uid, $stid, $brid));
													}	

													while($asrow = $asquery->fetch())
													{
														$ascount++;

														if($ascount ==1) { $comma = ""; } else{ $comma = "<br>"; }
														echo($comma.$asrow['brname']);
													}
												?>
												</td>
												<td align="left"><?php echo(ucwords($remarks)); ?></td>
												<td align="left">Lat: <?php echo($vlat); ?><br>Long: <?php echo($vlong); ?></td>
												<td align="right"><?php if($meter_distance != "N/A") {echo(number_format($meter_distance,2)." Meters");} else{ echo("N/A"); } ?></td>
												<td align="center"><?php echo($post_date); ?></td>
											</tr>
											</tbody>	
											<?php
													}
												}
											}
																							
												if($count == 0)
												{
											?>
											<tbody>	
											<tr>
												<td align="center" class="title" height="25"> </td>
												<td align="center"></td>
												<td align="center"><span style="color:red; font-weight:bold;">No Records Found!</span></td>
												<td align="center"></td>
												<td align="right">&nbsp;</td>
												<td align="right">&nbsp;</td>
												<td align="right">&nbsp;</td>
											</tr>
											</tbody>	
											<?php
												}	
											?>
								</table>
								<div class="box-title">
								<div align="left" class="col-sm-6"><h6><b>Report Name:</b> Supervisor Visit Report</h6></div>
								<div align="right" class="col-sm-6"><h6><b>Printed By:</b> <?php echo($UserFullName); ?> <b>On</b> <?php echo(date("F d, Y h:i A")); ?> </h6></div>
							</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</body>

</html>