<?php
	include("includes/functions.php");
	include("includes/session.php");
	include("includes/errors.php");
	chk_login1($db,$URL);

	/**
   * Calculates the great-circle distance between two points, with
   * the Haversine formula.
   * @param float $latitudeFrom Latitude of start point in [deg decimal]
   * @param float $longitudeFrom Longitude of start point in [deg decimal]
   * @param float $latitudeTo Latitude of target point in [deg decimal]
   * @param float $longitudeTo Longitude of target point in [deg decimal]
   * @param float $earthRadius Mean earth radius in [m]
   * @return float Distance between points in [m] (same as earthRadius)
   */
  	function haversineGreatCircleDistance($latitudeFrom, $longitudeFrom, $latitudeTo, $longitudeTo, $earthRadius = 6371000)
  	{
    	// convert from degrees to radians
    	$latFrom = deg2rad($latitudeFrom);
    	$lonFrom = deg2rad($longitudeFrom);
    	$latTo = deg2rad($latitudeTo);
    	$lonTo = deg2rad($longitudeTo);

    	$latDelta = $latTo - $latFrom;
    	$lonDelta = $lonTo - $lonFrom;

    	$angle = 2 * asin(sqrt(pow(sin($latDelta / 2), 2) +
    	  cos($latFrom) * cos($latTo) * pow(sin($lonDelta / 2), 2)));
    	return $angle * $earthRadius;
  	}
?>
<!doctype html>
<html>

<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
	<!-- Apple devices fullscreen -->
	<meta name="apple-mobile-web-app-capable" content="yes" />
	<!-- Apple devices fullscreen -->
	<meta names="apple-mobile-web-app-status-bar-style" content="black-translucent" />

	<title>Sentient - QA Visit Report</title>

	<!-- Bootstrap -->
	<link rel="stylesheet" href="css/bootstrap.min.css">
	<!-- jQuery UI -->
	<link rel="stylesheet" href="css/plugins/jquery-ui/jquery-ui.min.css">
	<!-- dataTables -->
	<link rel="stylesheet" href="css/plugins/datatable/TableTools.css">
	<!-- chosen -->
	<link rel="stylesheet" href="css/plugins/chosen/chosen.css">
	<!-- Theme CSS -->
	<link rel="stylesheet" href="css/style.css">
	<!-- Color CSS -->
	<link rel="stylesheet" href="css/themes.css">

	<!-- jQuery -->
	<script src="js/jquery.min.js"></script>

	<!-- Nice Scroll -->
	<script src="js/plugins/nicescroll/jquery.nicescroll.min.js"></script>
	<!-- imagesLoaded -->
	<script src="js/plugins/imagesLoaded/jquery.imagesloaded.min.js"></script>
	<!-- jQuery UI -->
	<script src="js/plugins/jquery-ui/jquery-ui.js"></script>
	<!-- slimScroll -->
	<script src="js/plugins/slimscroll/jquery.slimscroll.min.js"></script>
	<!-- Bootstrap -->
	<script src="js/bootstrap.min.js"></script>
	<!-- Bootbox -->
	<script src="js/plugins/bootbox/jquery.bootbox.js"></script>
	<!-- New DataTables -->
	<script src="js/plugins/momentjs/jquery.moment.min.js"></script>
	<script src="js/plugins/momentjs/moment-range.min.js"></script>
	<script src="js/plugins/datatables/jquery.dataTables.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.tableTools.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.colReorder.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.colVis.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.scroller.min.js"></script>

	<!-- Chosen -->
	<script src="js/plugins/chosen/chosen.jquery.min.js"></script>

	<!-- Theme framework -->
	<script src="js/eakroko.min.js"></script>
	<!-- Theme scripts -->
	<script src="js/application.min.js"></script>
	<!-- Just for demonstration -->
	<script src="js/demonstration.min.js"></script>

	<!--[if lte IE 9]>
		<script src="js/plugins/placeholder/jquery.placeholder.min.js"></script>
		<script>
			$(document).ready(function() {
				$('input, textarea').placeholder();
			});
		</script>
	<![endif]-->

	<!-- Favicon -->
	<link rel="shortcut icon" href="img/favicon.png" />
	<!-- Apple devices Homescreen icon -->
	<link rel="apple-touch-icon-precomposed" href="img/apple-touch-icon-precomposed.png" />
	<script language="javascript" type="text/javascript">
		function DownloadPdf(vid)
		{
			var cd;
			cd = confirm("Are you sure to download PDF?");
			if(cd)
			{
				window.location.href = "download_visit_pdf.php?vid="+vid;
			}
		}
	</script>
</head>

<body>
	<form name="Form" method="post" enctype="multipart form-data">
	<div class="container-fluid nav-hidden" id="content">
		<div id="main">
			<div class="container-fluid">
				
				
				<div class="row">
					<div class="col-sm-12">
						<div class="box">
							
							<div class="box-content">
								<div class="invoice-info">
									<?php
										$uid = $_REQUEST['id'];
										$stid = $_REQUEST['stid'];
										
										$from_date_timestamp = strtotime($_REQUEST['fromdate']);
										$to_date_timestamp = strtotime($_REQUEST['todate']) + 86399;

										$from_date = date("d-m-Y",$from_date_timestamp);
										$to_date = date("d-m-Y",$to_date_timestamp);

										if($_REQUEST['id'] != 0)
										{
											$uid = $_REQUEST['id'];
											$suquery = $db->prepare("SELECT uid, su_no, fullname FROM users WHERE uid=?");
											$suquery->execute(array($uid));
											while($surow = $suquery->fetch())
											{
												$su_name = $surow['fullname'].": SU-".$surow['su_no'];
											}
												$q1 = "AND VS.uid = '$uid'";
												$q1_1 = "AND VS.sup_uid = '$uid'";

											}
											else
											{
												$su_name = "All";
												$q1 = "AND VS.uid IN (489, 179, 222, 1288, 1205, 1289, 159, 124, 1311, 1290, 943, 1025, 413, 415)";
												$q1_1 = "";
											}

											if($_REQUEST['stid'] != 0)
											{
												$stid = $_REQUEST['stid'];
												$stquery = $db->prepare("SELECT stid, store_code, store_name, city FROM store WHERE stid=?");
												$stquery->execute(array($stid));
												while($strow = $stquery->fetch())
												{
													$store_name = $strow['store_name'].", ".$strow['city'].": ST-".$strow['store_code'];
												}
												$q2 = "AND VS.stid = '$stid'";

											}
											else
											{
												$store_name = "All";
												$q2 = "";
											}

											if($_REQUEST['city'] != 0 && $_REQUEST['city'] != "")
											{
												$stcity = $_REQUEST['city'];


												/*echo("'".str_replace(",","','",$stcity)."'");
												echo("<br>");
												$temp = array(0,1);
												*/
												//$st_city = "'".str_replace(",","','",$stcity)."'";										
												//$result = "'" . implode ( "', '", $temp ) . "'";

												//echo($result);
												$q3 = "AND ST.city = '$stcity'";
											}
											else{
												$stcity = "All";
												$q3 = "";
											}

											if($_REQUEST['stcid'] != 0 && $_REQUEST['stcid'] != "")
											{
												$store_chain = $_REQUEST['stcid'];


												/*echo("'".str_replace(",","','",$stcity)."'");
												echo("<br>");
												$temp = array(0,1);
						*/
												$st_store_chain= "'".str_replace(",","','",$store_chain)."'";										
												//$result = "'" . implode ( "', '", $temp ) . "'";

												//echo($result);
												$q4 = "AND ST.chain_store IN ($st_store_chain)";

											}
											else{
												$store_chain = "All";
												$q4 = "";
											}

											if($_REQUEST['brid'] != 0)
											{
												$brid = $_REQUEST['brid'];
												$brquery = $db->prepare("SELECT brid, brname FROM brand WHERE brid=?");
												$brquery->execute(array($brid));
												while($brrow = $brquery->fetch())
												{
													$brand_name = $brrow['brname'];
												}
												$q5 = "AND VS.brid = '$brid'";
											}
											else
											{
												$brand_name = "All";
												$q5 = "";
											}
											if($_REQUEST['alarming'] == 1)
											{
												$q6 = "AND VS.critical_type = 1";
											}
											else
											{
												$q6 = "";
											}

											if($_REQUEST['visit_time'] != 0)
											{
												$visit_time = ucfirst($_REQUEST['visit_time']);
												$q7 = "AND VS.visit_time = '$visit_time'";	
											}
											else
											{
												$visit_time = "All";
												$q7 = "";
											}

											if($_REQUEST['visit_type'] != "all")
											{
												if($_REQUEST['visit_type'] == 0)
												{
													$visit_type = "Visit from Inside";
													$q8 = "AND VS.visit_type = 0";	
												}
												else
												{
													$visit_type = "Visit from Outside";
													$q8 = "AND VS.visit_type = 1";
												}
											}
											else
											{
												$visit_type = "All";
												$q8 = "";
											}

											$distance_value = $_REQUEST['distance'];
											if($_REQUEST['distance_type'] == 0) { $distance_type = "All"; }
											if($_REQUEST['distance_type'] == 1) { $distance_type = "Greater Than $distance_value Meters"; }
											if($_REQUEST['distance_type'] == 2) { $distance_type = "Less Than $distance_value Meters"; }
	                                        
	                                        $brquery = $db->prepare("SELECT * FROM visits VS 
																	INNER JOIN users US ON VS.uid = US.uid 
																	INNER JOIN store ST ON VS.stid = ST.stid 
																	WHERE VS.post_date <> 0 AND VS.vdate BETWEEN $from_date_timestamp AND $to_date_timestamp $q1 $q2 $q3 $q4 $q5 $q6 $q7 $q8 GROUP BY VS.stid ORDER BY VS.post_date ASC");
											$brquery->execute();
											$num_visit = $brquery->rowCount();

											$vsquery = $db->prepare("SELECT * FROM visits VS 
																	INNER JOIN users US ON VS.uid = US.uid 
																	INNER JOIN store ST ON VS.stid = ST.stid 
																	WHERE VS.post_date <> 0 AND VS.vdate BETWEEN $from_date_timestamp AND $to_date_timestamp $q1 $q2 $q3 $q4 $q5 $q6 $q7 $q8 ORDER BY VS.post_date ASC");
											$vsquery->execute();
											
											$vsbrquery = $db->prepare("SELECT * FROM visits VS 
																	INNER JOIN users US ON VS.uid = US.uid 
																	INNER JOIN store ST ON VS.stid = ST.stid 
																	WHERE VS.post_date <> 0 AND VS.brid <> 0 AND VS.vdate BETWEEN $from_date_timestamp AND $to_date_timestamp $q1 $q2 $q3 $q4 $q5 $q6 $q7 $q8 GROUP BY VS.brid ORDER BY ST.store_name ASC");
											$vsbrquery->execute();
											
										
											$num_brand = $vsbrquery->rowCount();


	                                        if($num_visit > 0)
	                                        {
	                                        	
											$vsquery1 = $db->prepare("SELECT * FROM visits VS 
																	INNER JOIN users US ON VS.uid = US.uid 
																	INNER JOIN store ST ON VS.stid = ST.stid 
																	WHERE VS.post_date <> 0 AND VS.vdate BETWEEN $from_date_timestamp AND $to_date_timestamp $q1 $q2 $q3 $q4 $q5 $q6 $q7 $q8 ORDER BY VS.post_date ASC LIMIT 0,1");
											$vsquery1->execute();
											while($vsrow1 = $vsquery1->fetch())
											{
											    $vid1 = $vsrow1['vid'];
												$post_date1 = $vsrow1['post_date'];
												$stlat1 = $vsrow1['stlat'];
												$stlong1 = $vsrow1['stlong'];
											}

											$vsquery2 = $db->prepare("SELECT * FROM visits VS 
																	INNER JOIN users US ON VS.uid = US.uid 
																	INNER JOIN store ST ON VS.stid = ST.stid 
																	WHERE VS.post_date <> 0 AND VS.vdate BETWEEN $from_date_timestamp AND $to_date_timestamp $q1 $q2 $q3 $q4 $q5 $q6 $q7 $q8 ORDER BY VS.post_date DESC LIMIT 0,1");
											$vsquery2->execute();
											while($vsrow2 = $vsquery2->fetch())
											{
												$post_date2 = $vsrow2['post_date'];
												$stlat2 = $vsrow2['stlat'];
												$stlong2 = $vsrow2['stlong'];
											}

											if($stlat1 != "" && $stlong1 != "" && $stlat2 != "" && $stlong2 != "")
											{
												$meter_distance = haversineGreatCircleDistance($stlat1, $stlong1, $stlat2, $stlong2, $earthRadius = 6371000);
												$sup_distance = $meter_distance / 1000;
											}
											else
											{
												$meter_distance = "N/A";
												$sup_distance = 0;
											}

											//echo($post_date1."/".$post_date2);
											$time_difference = $post_date2 - $post_date1;
											//echo($time_difference);
											if ($time_difference > 0) {

												$seconds = $time_difference;
												$days = floor($seconds / 86400);
							                    $seconds %= 86400;

							                    $hours = floor($seconds / 3600);
							                    $seconds %= 3600;

							                    $minutes = floor($seconds / 60);
							                    $seconds %= 60;
							                      
							                    $total_hrs ="".str_pad($hours, 2, "0", STR_PAD_LEFT).":".str_pad($minutes, 2, "0", STR_PAD_LEFT)."";
											}
											else
											{
												$total_hrs ="";
											}	
                                        }


										
									?>
									<div class="invoice-from">
										<table>
											<tr>
												<td valign="top">
													<br>
													<?php
														if(isset($_REQUEST['tr']))
														{
													?>
													<a href="print_visit_internal_report.php?fromdate=<?php echo($_REQUEST['fromdate']); ?>&todate=<?php echo($_REQUEST['todate']); ?>&stid=<?php echo($_REQUEST['stid']); ?>&brid=<?php echo($_REQUEST['brid']); ?>&id=<?php echo($_REQUEST['id']); ?>&city=<?php echo($_REQUEST['city']); ?>&stcid=<?php echo($_REQUEST['stcid']); ?>&distance_type=<?php echo($_REQUEST['distance_type']); ?>&distance=<?php echo($_REQUEST['distance']); ?>&alarming=<?php echo($_REQUEST['alarming']); ?>&visit_time=<?php echo($_REQUEST['visit_time']); ?>">
														<img src="images/sentient_logo.jpg" width="125">
													</a>
													<?php
														}
														else
														{
													?>
													<a href="print_visit_internal_report.php?fromdate=<?php echo($_REQUEST['fromdate']); ?>&todate=<?php echo($_REQUEST['todate']); ?>&stid=<?php echo($_REQUEST['stid']); ?>&brid=<?php echo($_REQUEST['brid']); ?>&id=<?php echo($_REQUEST['id']); ?>&city=<?php echo($_REQUEST['city']); ?>&stcid=<?php echo($_REQUEST['stcid']); ?>&distance_type=<?php echo($_REQUEST['distance_type']); ?>&distance=<?php echo($_REQUEST['distance']); ?>&alarming=<?php echo($_REQUEST['alarming']); ?>&visit_time=<?php echo($_REQUEST['visit_time']); ?>&tr=1">
														<img src="images/sentient_logo.jpg" width="125">
													</a>
													<?php		
														}
													?>

												<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
												<td>
												<?php if($num_visit > 0){ ?>	
												<strong>Summary</strong>
												<table width="150%" border="1" height="65" cellpadding="15" cellspacing="15">
													<tr>
														<td align="left" height="35">&nbsp;<strong>Total Store Visited:</strong></td>
														<td width="100" align="center" height="35">&nbsp;<strong><?php echo($num_visit); ?></strong></td>
													</tr>
													<tr>
														<td align="left" height="35">&nbsp;<strong>Total Brands Visited:</strong></td>
														<td align="center" height="35">&nbsp;<strong><?php echo($num_brand); ?></strong></td>
													</tr>
													<tr>
														<td align="left" height="35">&nbsp;<strong>First Visit:</strong></td>
														<td align="center" height="35">&nbsp;<strong><?php echo(date("h:i A", $post_date1)); ?></strong></td>
													</tr>
													<tr>
														<td align="left" height="35">&nbsp;<strong>Last Visit:</strong></td>
														<td align="center" height="35">&nbsp;<strong><?php echo(date("h:i A", $post_date2)); ?></strong></td>
													</tr>
													<tr>
														<td align="left" height="35">&nbsp;<strong>Total Hrs:</strong></td>
														<td align="center" height="35">&nbsp;<strong><?php echo($total_hrs); ?></strong></td>
													</tr>
													<?php if($_REQUEST['id'] != 0){ ?>	
													<tr>
														<td align="left" height="35">&nbsp;<strong>Total Distance Covered:</strong></td>
														<td align="center" height="35">&nbsp;<strong>
															<?php if($meter_distance != "N/A") 
															{ echo(number_format($meter_distance/1000,2)." Km");} else{ echo("N/A"); } ?>	
														</strong></td>
													</tr>
													<?php }  ?>
												</table>
												<?php } ?>
												</td>
											</tr>
										</table>
									</div>
									<div class="invoice-infos">
										<h1>QA Visit Report</h1>
										<table>
											<tr><td>&nbsp;</td></tr>
											<tr><td align="left"><b>From Date: <?php echo($from_date); ?></b></td></tr>
											<tr><td align="left"><b>To Date: <?php echo($to_date); ?></b></td></tr>
											<tr><td align="left"><b>Brand: <?php echo($brand_name); ?></b></td></tr>
											<tr><td align="left"><b>City: <?php echo($stcity); ?></b></td></tr>
											<tr><td align="left"><b>Supervisor: <?php echo($su_name); ?></b></td></tr>
											<tr><td align="left"><b>Store Chain: <?php echo($store_chain); ?></b></td></tr>
											<tr><td align="left"><b>Store: <?php echo($store_name); ?></b></td></tr>
											<tr><td align="left"><b>Distance: <?php echo($distance_type); ?></b></td></tr>
											<tr><td align="left"><b>Visit Time: <?php echo($visit_time); ?></b></td></tr>
											<tr><td align="left"><b>Visit Type: <?php echo($visit_type); ?></b></td></tr>
										</table>
									</div>
								</div>
								<table class="table table-hover table-nomargin table-bordered dataTable" data-nosearch data-nopagination data-noinfo>
									<thead>
										<tr>
											<th>Sr</th>
											<th>Brand</th>
											<th>City</th>
											<th>Store</th>
											<th>BA</th>
											<th>QA</th>
											<th>Remarks</th>
											<th>Visit Date</th>
											<th>Supervisor</th>
											<th>Distance from Store</th>
											<th>Posted At</th>
											<th>Photo</th>
											<th>Visit Time</th>
											<th>Visit Type</th>
											<?php
												if(isset($_REQUEST['tr']))
												{
											?>
											<th>Devices</th>
											<?php
												}
											?>
											<th>PDF</th>
										</tr>
									</thead>
									<tbody>
										<?php
												$count = 0;
												
												while($vsrow = $vsquery->fetch())
												{
													$vid = $vsrow['vid'];
													$uid = $vsrow['uid'];
													$stid = $vsrow['stid'];
													$brid = $vsrow['brid'];
													$ba_uid = $vsrow['ba_uid'];
													$sup_uid = $vsrow['sup_uid'];
													$critical_type = $vsrow['critical_type'];

													$app_id = $vsrow['app_id'];
													$vapp_id = $vsrow['vapp_id'];

													if($critical_type == 1)
													{
														$bg_type = "style='background-color: #FFD7D9; font-weight: bold;'";
													}
													else
													{
														$bg_type = "";
													}

													if($vsrow['visit_type'] == 0)
													{
														$stvisit_type = "Inside Store";
													}	
													else									
													{
														$stvisit_type = "Outside Store";
													}

													//$brname = $vsrow['brname'];
													$vimage = $vsrow['vimage'];

													$visittime = $vsrow['visit_time'];

													$attendance_code = $vsrow['attendance_code'];

													if($vsrow['post_date'] != 0) { $post_date = date("h:i A",$vsrow['post_date']); } else{ $post_date = "N/A"; }
													//// get brand name

													$store_name = $vsrow['store_name'].", ".$vsrow['city'].": ST-".$vsrow['store_code'];
													$supervisor = $vsrow['fullname'].": SU-".$vsrow['su_no'];
													if($attendance_code == "")
													{
														$remarks = $vsrow['remarks'];	
													}
													else
													{
														$atquery = $db->prepare("SELECT * FROM attendance_type WHERE attendance_code = ?");
														$atquery->execute(array($attendance_code));
														while($atrow = $atquery->fetch())
														{
															$remarks = $atrow['attendance_type'];	
														}
													}
													$visit_date = date("d-m-Y",$vsrow['vdate']);
													
													$vlat = $vsrow['vlat'];
													$vlong = $vsrow['vlong'];

													$stlat = $vsrow['stlat'];
													$stlong = $vsrow['stlong'];

													$store_city = $vsrow['city'];

													if($stlat != "" && $stlong != "")
													{
														$meter_distance = haversineGreatCircleDistance($vlat, $vlong, $stlat, $stlong, $earthRadius = 6371000);
														$sup_distance = $meter_distance;
													}
													else
													{
														$meter_distance = "N/A";
														$sup_distance = 0;
													}
													$distance_status = 0;
													if($_REQUEST['distance_type'] > 0)
													{
														if($_REQUEST['distance_type'] == 1) { if($_REQUEST['distance'] <= $sup_distance) { $distance_status = 1; } else{ $distance_status = 0; } }
														if($_REQUEST['distance_type'] == 2) { if($_REQUEST['distance'] >= $sup_distance) { $distance_status = 1; } else{ $distance_status = 0; } }
													}
													else{
														$distance_status = 1;
													}
													//echo($distance_status);
													if($distance_status == 1)
													{
														$count++;
											?>	
											<tr <?php echo($bg_type); ?>>
												<td align="center" class="title" height="25"><?php echo($count); ?>. </td>
												<td align="left">
												<?php
													//echo($vid." / ".$brid);
													if($brid == 0)
													{
														$brquery = $db->prepare("SELECT * FROM assignments ASA INNER JOIN brand BR ON ASA.brid = BR.brid WHERE ASA.supuid = ? AND ASA.stid = ?");
														$brquery->execute(array($uid, $stid));
															
													}
													else
													{
														$brquery = $db->prepare("SELECT * FROM brand WHERE brid = ?");
														$brquery->execute(array($brid));
														while($brrow = $brquery->fetch())
														{
															
															echo($brrow['brname']);
														}
													}	

													
												?>
												</td>
												<td align="left"><?php echo(ucwords($store_city)); ?></td>
												<td align="left"><?php echo(ucwords($store_name)); ?></td>
												<td align="left">
												<?php
													////echo($vid." / ".$brid);
													//echo($ba_uid);
													if($ba_uid != 0)
													{
														$baquery = $db->prepare("SELECT * FROM users WHERE uid = ?");
														$baquery->execute(array($ba_uid));
														while($barow = $baquery->fetch())
														{
															
															echo($barow['fullname']." BA-".$barow['ba_no']);
														}	
													}
												?>
												</td>
					                            <td align="left"><?php echo(ucwords($supervisor)); ?></td>
												<td align="left"><?php echo(ucwords($remarks)); ?></td>
												<td align="left"><?php echo($visit_date); ?></td>
												<td align="left">
												<?php
													//echo($vid." / ".$brid);
													if($sup_uid != 0)
													{
														$supquery = $db->prepare("SELECT * FROM users WHERE uid = ?");
														$supquery->execute(array($sup_uid));
														while($suprow = $supquery->fetch())
														{
															
															echo($suprow['fullname']." SU-".$suprow['su_no']);
														}	
													}
												?>
												</td>
												<td align="right"><?php if($meter_distance != "N/A") {echo(number_format($meter_distance,2)." Meters");} else{ echo("N/A"); } ?></td>
												<td align="center"><?php echo($post_date); ?></td>
												<td>
													<?php if($vimage != ""){ ?>
													<a href="../ba_app/assets/uploads/su/<?php echo($vimage); ?>" target="_blank"><img src="../ba_app/assets/uploads/su/<?php echo($vimage); ?>" width="100"></a>
													<?php } ?>	
												</td>
												<td align="center"><?php echo($visittime); ?></td>
												<td align="center"><?php echo($stvisit_type); ?></td>
												<?php
													if(isset($_REQUEST['tr']))
													{
												?>
												<td align="center">
											    	<?php
														if($vapp_id != "")
														{
															if($app_id == $vapp_id)
															{
																$device_msg = "$vapp_id <br> <small style='color: green; font-weight: bold;'>Registered</small>";
																$alt_user = "";
															}
															else
															{
																$device_msg = "$vapp_id <br> <small style='color: red; font-weight: bold;'>Unregistered</small>";
																$baquery = $db->prepare("SELECT * FROM users WHERE app_id = ?");
																$baquery->execute(array($vapp_id));
																if($baquery->rowCount() > 0)
																{
																	while($barow = $baquery->fetch())
																	{
																		$alt_user = $barow['username'];
																	}
																}
															}
														}
														else
														{
															$device_msg = "$vapp_id <br> <small style='color: red; font-weight: bold;'>Unregistered</small>";
															$alt_user = "";
														}		
											    		
											    		echo($device_msg."&nbsp;&nbsp;".$alt_user);
													?>
													
												</td>
												<?php
													}
												?>
												<td>
													<a href="javascript:Void(0);" class="btn" rel="tooltip" title="PDF" onclick="return DownloadPdf(<?php echo($vid); ?>);">
															<i class="fa fa-file-o"></i>
														</a>
												</td>
											</tr>
											<?php
													}
												}							
												if($count == 0)
												{
											?>
											<tr>
												<td align="center" class="title" height="25"> </td>
												<td align="center"></td>
												<td align="center"></td>
												<td align="center"></td>
												<td align="right">&nbsp;</td>
												<td align="right"><span style="color:red; font-weight:bold;">No Records Found!</span></td>
												<td align="right">&nbsp;</td>
												<td align="right">&nbsp;</td>
												<td align="right">&nbsp;</td>
												<td align="right">&nbsp;</td>
												<td align="right">&nbsp;</td>
											</tr>
											<?php
												}	
											?>
									</tbody>
								</table>
								<div class="box-title">
								<div align="left" class="col-sm-6"><h6><b>Report Name:</b> Supervisor Visit Report</h6></div>
								<div align="right" class="col-sm-6"><h6><b>Printed By:</b> <?php echo($UserFullName); ?> <b>On</b> <?php echo(date("F d, Y h:i A")); ?> </h6></div>
							</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</form>	
</body>

</html>