<?php
	include("includes/functions.php");
	include("includes/session.php");
	include("includes/errors.php");
	chk_login1();
?>
<!doctype html>
<html>

<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
	<!-- Apple devices fullscreen -->
	<meta name="apple-mobile-web-app-capable" content="yes" />
	<!-- Apple devices fullscreen -->
	<meta names="apple-mobile-web-app-status-bar-style" content="black-translucent" />

	<title>Sentient - Usership Report</title>

	<!-- Bootstrap -->
	<link rel="stylesheet" href="css/bootstrap.min.css">
	<!-- jQuery UI -->
	<link rel="stylesheet" href="css/plugins/jquery-ui/jquery-ui.min.css">
	<!-- dataTables -->
	<link rel="stylesheet" href="css/plugins/datatable/TableTools.css">
	<!-- chosen -->
	<link rel="stylesheet" href="css/plugins/chosen/chosen.css">
	<!-- Theme CSS -->
	<link rel="stylesheet" href="css/style.css">
	<!-- Color CSS -->
	<link rel="stylesheet" href="css/themes.css">

	<!-- jQuery -->
	<script src="js/jquery.min.js"></script>

	<!-- Nice Scroll -->
	<script src="js/plugins/nicescroll/jquery.nicescroll.min.js"></script>
	<!-- imagesLoaded -->
	<script src="js/plugins/imagesLoaded/jquery.imagesloaded.min.js"></script>
	<!-- jQuery UI -->
	<script src="js/plugins/jquery-ui/jquery-ui.js"></script>
	<!-- slimScroll -->
	<script src="js/plugins/slimscroll/jquery.slimscroll.min.js"></script>
	<!-- Bootstrap -->
	<script src="js/bootstrap.min.js"></script>
	<!-- Bootbox -->
	<script src="js/plugins/bootbox/jquery.bootbox.js"></script>
	<!-- New DataTables -->
	<script src="js/plugins/momentjs/jquery.moment.min.js"></script>
	<script src="js/plugins/momentjs/moment-range.min.js"></script>
	<script src="js/plugins/datatables/jquery.dataTables.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.tableTools.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.colReorder.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.colVis.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.scroller.min.js"></script>

	<!-- Chosen -->
	<script src="js/plugins/chosen/chosen.jquery.min.js"></script>

	<!-- Theme framework -->
	<script src="js/eakroko.min.js"></script>
	<!-- Theme scripts -->
	<script src="js/application.min.js"></script>
	<!-- Just for demonstration -->
	<script src="js/demonstration.min.js"></script>

	<!--[if lte IE 9]>
		<script src="js/plugins/placeholder/jquery.placeholder.min.js"></script>
		<script>
			$(document).ready(function() {
				$('input, textarea').placeholder();
			});
		</script>
	<![endif]-->

	<!-- Favicon -->
	<link rel="shortcut icon" href="img/favicon.png" />
	<!-- Apple devices Homescreen icon -->
	<link rel="apple-touch-icon-precomposed" href="img/apple-touch-icon-precomposed.png" />

</head>

<body>
	<div class="container-fluid nav-hidden" id="content">
		<div id="main">
			<div class="container-fluid">
				
				
				<div class="row">
					<div class="col-sm-12">
						<div class="box">
							
							<div class="box-content">
								<div class="invoice-info">
									
									<div class="invoice-from">
										<br>
										<img src="images/sentient_logo.jpg" width="125">
								
										<address>
											Sentient
											<br>Lahore
											
										</address>
									</div>
									
									<div class="invoice-infos">
										<h1>Usership Report</h1>
										<?php
											$atdate = strtotime($_REQUEST['date']);
											$sale_date = date("d-m-Y",$atdate);
											$q1 = "WHERE US.sale_date = '$sale_date'";

											$weekday_atdate = date("l",$atdate);

											if($_REQUEST['city'] != 0 && $_REQUEST['city'] != "")
											{
												$stcity = $_REQUEST['city'];


												/*echo("'".str_replace(",","','",$stcity)."'");
												echo("<br>");
												$temp = array(0,1);
	*/
												$st_city = "'".str_replace(",","','",$stcity)."'";										
												//$result = "'" . implode ( "', '", $temp ) . "'";

												//echo($result);
												$q2 = "AND ST.city IN ($st_city)";

											}
											else{
												$stcity = "All";
												$q2 = "";
											}	

											if($_REQUEST['brid'] != 0)
											{
												$brid = $_REQUEST['brid'];
												$q3 = "AND ASA.brid = $brid";
												$q3_1 = "AND ASA.brid = $brid";
												
												$brquery = $db->prepare("SELECT brid, brname FROM brand WHERE brid=?");
												$brquery->execute(array($brid));
												while($brrow = $brquery->fetch())
												{
													$brand = $brrow['brname'];
												}

											}
											else{
												$brid = 0;
												$q3 = "";
												$q3_1 = "";
												$brand = "All";
											}

											if($_REQUEST['stcid'] != 0 && $_REQUEST['stcid'] != "")
											{
												$store_chain = $_REQUEST['stcid'];


												/*echo("'".str_replace(",","','",$stcity)."'");
												echo("<br>");
												$temp = array(0,1);
						*/
												$st_store_chain= "'".str_replace(",","','",$store_chain)."'";										
												//$result = "'" . implode ( "', '", $temp ) . "'";

												//echo($result);
												$q4 = "AND ST.chain_store IN ($st_store_chain)";

											}
											else{
												$store_chain = "All";
												$q4 = "";
											}

											if($_REQUEST['id'] != 0)
											{
												$supid = $_REQUEST['id'];
												$supquery = $db->prepare("SELECT uid, su_no, fullname FROM users WHERE uid=?");
												$supquery->execute(array($supid));
												while($suprow = $supquery->fetch())
												{
													$supervisor = $suprow['fullname'].": SU-".$suprow['su_no'];
												}
												$q5 = "AND ASA.supuid = '$supid'";

											}
											else{
												$supid = 0;
												$supervisor = "All";
												$q5 = "";
											}

											$usdquery1 = $db->prepare("SELECT * FROM usership_detail USD INNER JOIN cbrand CB ON USD.cbrid = CB.cbrid WHERE USD.brid = ? AND USD.sale_date = ? GROUP BY CB.cbrid ORDER BY CB.cbrid ASC");
											$usdquery1->execute(array($_REQUEST['brid'],$sale_date));

											$usdquery2 = $db->prepare("SELECT * FROM usership_detail USD INNER JOIN cbrand CB ON USD.cbrid = CB.cbrid WHERE USD.brid = ? AND USD.sale_date = ? GROUP BY CB.cbrid ORDER BY CB.cbrid ASC");
											$usdquery2->execute(array($_REQUEST['brid'],$sale_date));

											$num_brand = $usdquery1->rowCount();
										?>
										<table>
											<tr><td>&nbsp;</td></tr>
											<tr><td align="left"><b>Date: <?php echo($sale_date); ?></b></td></tr>
											<tr><td align="left"><b>City: <?php echo($stcity); ?></b></td></tr>
											<tr><td align="left"><b>Brand: <?php echo($brand); ?></b></td></tr>	
											<tr><td align="left"><b>Supervisor: <?php echo($supervisor); ?></b></td></tr>
											<tr><td align="left"><b>Chain Store: <?php echo($store_chain); ?></b></td></tr>
										</table>
									</div>
								</div>
								<?php
									if($num_brand == 0)
									{
								?>
								<table width="100%">
									<tr>
										<td align="center"><span style="color:red;">No Record Found!</span></td>
									</tr>
								</table>
								
								<?php
									}
									else{
								?>
								<table class="table table-hover table-nomargin table-bordered" data-nosearch data-nopagination data-noinfo>
									<thead>
										<tr>
											<th style="background-color: darkblue; color:white;" colspan="6"></th>
											<th style="background-color: darkblue; color:white;" colspan="2">Usership</th>
											<th style="background-color: darkblue; color:white;" colspan="<?php echo($num_brand); ?>">Interception</th>
											<th style="background-color: darkblue; color:white;" colspan="<?php echo($num_brand); ?>">Productive Interception</th>
										</tr>
										<tr>
											<th>Sr</th>
											<th>Store Name</th>
											<th>BA Name</th>
											<th>City</th>
											<th>IMT/LMT</th>
											<th>Supervisor</th>

											<th style="background-color: lightblue;">Interception</th>
											<th style="background-color: lightblue;">Productive</th>

											<?php
												while($usdrow1 = $usdquery1->fetch())
												{
											?>
											<th style="background-color: lightyellow;"><?php echo($usdrow1['cbrname']); ?></th>
											<?php
												}
											?>
											
											<?php
												while($usdrow2 = $usdquery2->fetch())
												{
											?>
											<th style="background-color: lightgreen;"><?php echo($usdrow2['cbrname']); ?></th>
											<?php
												}
											?>
										</tr>

										
									</thead>
									
										
									<tbody>
										<?php
											$count = 0;
											$array_asuid = array();
											$usquery = $db->prepare("SELECT * FROM usership US INNER JOIN users U ON US.uid = U.uid 
																	INNER JOIN assignments ASA ON US.asid = ASA.asid 
																	INNER JOIN store ST ON ASA.stid = ST.stid 
																	WHERE US.brid = ? AND US.sale_date = ? $q2 $q3 $q4");
											$usquery->execute(array($_REQUEST['brid'], $sale_date));
											while($usrow = $usquery->fetch())
											{
												$count++;
												$asuid = $usrow['asuid'];
												$sup_uid = $usrow['supuid'];
												$store_code = $usrow['store_code'];
												$store_name = $usrow['store_name'];
												$store_city = $usrow['city'];
												$store_channel = $usrow['channel'];

												$uid = $usrow['uid'];
												$ba_no = $usrow['ba_no'];
												$fullname = $usrow['fullname'];
												$username = $usrow['username'];
												$ba_city = $usrow['city'];

												array_push($array_asuid, $asuid);
												
												if($sup_uid != 0)
												{
													$supquery1 = $db->prepare("SELECT uid, su_no, fullname FROM users WHERE uid=?");
													$supquery1->execute(array($sup_uid));
													while($suprow1 = $supquery1->fetch())
													{
														$supervisor = $suprow1['fullname'].": SU-".$suprow1['su_no'];
													}
												}
												else
												{
													$supervisor = "<span style='color:red;'>Not Assigned</span>";
												}

												/// SUM interception
												$sum_usdquery = $db->prepare("SELECT SUM(interception) AS total_interception, SUM(productive) AS total_productive FROM usership_detail  WHERE asuid = ?");
												$sum_usdquery->execute(array($asuid));
												while($sum_usrow = $sum_usdquery->fetch())
												{
													$total_interception = $sum_usrow['total_interception'];
													$total_productive = $sum_usrow['total_productive'];
												}
										?>
										<tr>
											<td align="center" class="title" height="25"><?php echo($count); ?>. </td>
											<td align="left" class="title" height="25"><?php echo(ucwords($store_name)." :ST-".$store_code); ?></td>
											<td align="left" class="title" height="25"><?php echo(ucwords($fullname).", ".ucwords($ba_city)." (".$username.") :BA-".$ba_no); ?></td>
											<td align="left" class="title" height="25"><?php echo($store_city); ?></td>
											<td align="left" class="title" height="25"><?php echo($store_channel); ?></td>
											<td align="left" class="title" height="25"><?php echo(ucwords($supervisor)); ?></td>

											<td align="center" class="title" height="25"><?php echo($total_interception); ?></td>
											<td align="center" class="title" height="25"><?php echo($total_productive); ?></td>

											<?php
												
												$usdquery3 = $db->prepare("SELECT * FROM usership_detail WHERE asuid = ? ORDER BY cbrid ASC");
												$usdquery3->execute(array($asuid));
												while($usdrow3 = $usdquery3->fetch())
												{
													
											?>
											<td align="center" class="title" height="25"><?php echo($usdrow3['interception']); ?></td>
											<?php
												}
											?>

											<?php
												$usdquery3 = $db->prepare("SELECT * FROM usership_detail WHERE asuid = ? ORDER BY cbrid ASC");
												$usdquery3->execute(array($asuid));
												while($usdrow3 = $usdquery3->fetch())
												{
											?>
											<td align="center" class="title" height="25"><?php echo($usdrow3['productive']); ?></td>
											<?php
												}
											?>
										</tr>
										<?php
											}
											if($count > 0)
											{
										?>
										<tr>
											<td align="left" colspan="8"><strong>TOTAL</strong></td>

											<?php
												$string_asuid=implode(",",$array_asuid);
												$usdquery4 = $db->prepare("SELECT * FROM usership_detail WHERE brid = ? AND sale_date = ? GROUP BY cbrid ORDER BY cbrid ASC");
												$usdquery4->execute(array($_REQUEST['brid'],$sale_date));
												while($usdrow4 = $usdquery4->fetch())
												{
													// count interceptions
													$cbrid = $usdrow4['cbrid'];

													$usd_query4 = $db->prepare("SELECT SUM(interception) AS total_interceptions FROM usership_detail WHERE cbrid = $cbrid AND sale_date = '$sale_date' AND asuid IN ($string_asuid)");
													/*echo("SELECT SUM(interception) AS total_interceptions FROM usership_detail WHERE cbrid = $cbrid AND sale_date = '$sale_date' AND asuid IN ($string_asuid)");*/
													$usd_query4->execute();
													while($usd_row4 = $usd_query4->fetch())
													{
														$total_interceptions = $usd_row4['total_interceptions'];
													}

													
											?>
											<td align="center" class="title" height="25"><strong><?php echo($total_interceptions); ?></strong></td>
											<?php
												}
											?>

											<?php
												$usdquery5 = $db->prepare("SELECT * FROM usership_detail WHERE brid = ? AND sale_date = ? GROUP BY cbrid ORDER BY cbrid ASC");
												$usdquery5->execute(array($_REQUEST['brid'],$sale_date));
												while($usdrow5 = $usdquery5->fetch())
												{
													// count interceptions
													$cbrid = $usdrow5['cbrid'];

													$usd_query5 = $db->prepare("SELECT SUM(productive) AS total_productives FROM usership_detail WHERE cbrid = $cbrid AND sale_date = '$sale_date' AND asuid IN ($string_asuid)");
													$usd_query5->execute();
													while($usd_row5 = $usd_query5->fetch())
													{
														$total_productives = $usd_row5['total_productives'];
													}
											?>
											<td align="center" class="title" height="25"><strong><?php echo($total_productives); ?></strong></td>
											<?php
												}
											?>
										</tr>
										<?php }else{ ?>
										<tr>
											<td align="center" colspan="8"><span style="color: red;">No Record Found!</span></td>
										</tr>
										<?php } ?>
									</tbody>
										
										
									
								</table>
							<?php } ?>
								<div class="box-title">
								<div align="left" class="col-sm-6"><h6><b>Report Name:</b> Usership Report</h6></div>
								<div align="right" class="col-sm-6"><h6><b>Printed By:</b> <?php echo($UserFullName); ?> <b>On</b> <?php echo(date("F d, Y h:i A")); ?> </h6></div>
							</div>
							</div>


						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</body>

</html>