<?php
	include("includes/functions.php");
	include("includes/session.php");
	include("includes/errors.php");
	chk_login1();
?>
<!doctype html>
<html>

<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
	<!-- Apple devices fullscreen -->
	<meta name="apple-mobile-web-app-capable" content="yes" />
	<!-- Apple devices fullscreen -->
	<meta names="apple-mobile-web-app-status-bar-style" content="black-translucent" />

	<title>Sentient - Print Survey Report</title>

	<!-- Bootstrap -->
	<link rel="stylesheet" href="css/bootstrap.min.css">
	<!-- jQuery UI -->
	<link rel="stylesheet" href="css/plugins/jquery-ui/jquery-ui.min.css">
	<!-- dataTables -->
	<link rel="stylesheet" href="css/plugins/datatable/TableTools.css">
	<!-- chosen -->
	<link rel="stylesheet" href="css/plugins/chosen/chosen.css">
	<!-- Theme CSS -->
	<link rel="stylesheet" href="css/style.css">
	<!-- Color CSS -->
	<link rel="stylesheet" href="css/themes.css">

	<!-- jQuery -->
	<script src="js/jquery.min.js"></script>

	<!-- Nice Scroll -->
	<script src="js/plugins/nicescroll/jquery.nicescroll.min.js"></script>
	<!-- imagesLoaded -->
	<script src="js/plugins/imagesLoaded/jquery.imagesloaded.min.js"></script>
	<!-- jQuery UI -->
	<script src="js/plugins/jquery-ui/jquery-ui.js"></script>
	<!-- slimScroll -->
	<script src="js/plugins/slimscroll/jquery.slimscroll.min.js"></script>
	<!-- Bootstrap -->
	<script src="js/bootstrap.min.js"></script>
	<!-- Bootbox -->
	<script src="js/plugins/bootbox/jquery.bootbox.js"></script>
	<!-- New DataTables -->
	<script src="js/plugins/momentjs/jquery.moment.min.js"></script>
	<script src="js/plugins/momentjs/moment-range.min.js"></script>
	<script src="js/plugins/datatables/jquery.dataTables.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.tableTools.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.colReorder.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.colVis.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.scroller.min.js"></script>

	<!-- Chosen -->
	<script src="js/plugins/chosen/chosen.jquery.min.js"></script>

	<!-- Theme framework -->
	<script src="js/eakroko.min.js"></script>
	<!-- Theme scripts -->
	<script src="js/application.min.js"></script>
	<!-- Just for demonstration -->
	<script src="js/demonstration.min.js"></script>

	<!--[if lte IE 9]>
		<script src="js/plugins/placeholder/jquery.placeholder.min.js"></script>
		<script>
			$(document).ready(function() {
				$('input, textarea').placeholder();
			});
		</script>
	<![endif]-->

	<!-- Favicon -->
	<link rel="shortcut icon" href="img/favicon.png" />
	<!-- Apple devices Homescreen icon -->
	<link rel="apple-touch-icon-precomposed" href="img/apple-touch-icon-precomposed.png" />

</head>

<body>
	<div class="container-fluid nav-hidden" id="content">
		<div id="main">
			<div class="container-fluid">
				
				
				<div class="row">
					<div class="col-sm-12">
						<div class="box">
							
							<div class="box-content">
								<div class="invoice-info">
									
									<div class="invoice-from">
										<br>
										<img src="images/sentient_logo.jpg" width="125">
								
										<address>
											Sentient
											<br>Lahore
											
										</address>
									</div>
									
									<div class="invoice-infos">
										<h1>Survey Report</h1>
										<?php
											$surid = $_REQUEST['id'];
											$from_date_timestamp = strtotime($_REQUEST['fromdate']);
											$to_date_timestamp = strtotime($_REQUEST['todate']) + 86399;

											$from_date = date("d-m-Y",$from_date_timestamp);
											$to_date = date("d-m-Y",$to_date_timestamp);

											$datediff = $to_date_timestamp - $from_date_timestamp;

											$num_days = round($datediff / (60 * 60 * 24));

											$q1 = "AND SUR.surrdate BETWEEN $from_date_timestamp AND $to_date_timestamp";

											$surquery = $db->prepare("SELECT * FROM survey WHERE surid=?");
											$surquery->execute(array($surid));
											while($surrow = $surquery->fetch())
											{
												if($surrow['surtitle'] != "") { $survey = $surrow['surtitle']; } else{ $survey = "N/A"; }
												$surdate = date("d-m-Y h:i A", $surrow['surdate']);
											}
										?>
										<table>
											<tr><td>&nbsp;</td></tr>
											<tr><td align="left"><b>Survey: <?php echo($survey); ?></b></td></tr>
											<tr><td align="left"><b>From Date: <?php echo($from_date); ?></b></td></tr>
											<tr><td align="left"><b>To Date: <?php echo($to_date); ?></b></td></tr>
										</table>
									</div>
								</div>
								<table class="table table-hover table-nomargin table-bordered dataTable" data-nosearch data-nopagination data-noinfo>
									<thead>
										<tr>
											<th>Sr</th>
											<?php
												$surdquery = $db->prepare("SELECT * FROM survey_detail WHERE surid=? ORDER BY surdid ASC");
												$surdquery->execute(array($surid));
												while($surdrow = $surdquery->fetch())
												{
											?>
											<th><?php if($surdrow['surfield'] != ""){ echo($surdrow['surfield']); } else{ echo("N/A"); } ?></th>
											<?php
												}
											?>
											<th>Brand</th>
											<th>Store</th>
											<th>Posted By</th>
										</tr>
									</thead>
									
										<?php
												$count = 0;
												$surrquery = $db->prepare("SELECT * FROM survey_record SUR 
														INNER JOIN assignments ASA ON SUR.asid = ASA.asid 
														INNER JOIN brand BR ON ASA.brid = BR.brid 
														INNER JOIN store ST ON ASA.stid = ST.stid 
														INNER JOIN users US ON SUR.uid = US.uid WHERE SUR.surid = ".$_REQUEST['id']." $q1 ORDER BY SUR.surrid ASC");
												$surrquery->execute();
												if($surrquery->rowCount() == 0)
												{
										?>
										<tbody>
										<tr>
											<td align="center"><span style="color:red; font-weight:bold;">No Records Found!</span></td>
										</tr>
										</tbody>
										<?php			
												}
												else
												{
													while($surrrow = $surrquery->fetch())
													{
														$count++;					
														$surrid = $surrrow['surrid'];
														$posted_on = date("d-m-Y h:i A",$surrrow['surrdate']);
											?>	
											<tbody>
											<tr>
												<td align="left" class="title" height="25">&nbsp;<?php echo($count); ?>. </td>
												<?php
														$surrdquery = $db->prepare("SELECT * FROM survey_record_detail WHERE surrid = ? ORDER BY surrdid ASC");
														$surrdquery->execute(array($surrid));
														while($surrdrow = $surrdquery->fetch())
														{
												?>
												<td align="left">&nbsp;<?php if($surrdrow['surdvalue'] != ""){ echo(ucwords($surrdrow['surdvalue'])); } else{ echo("N/A"); } ?></td>
												<?php
														}
												?>
												<td align="left"><?php echo($surrrow['brname']); ?></td>
												<td align="left"><?php echo($surrrow['store_name']); ?>: ST-<?php echo($surrrow['store_code'].", ".$surrrow['city']);  ?></td>
												<td align="left">
													<?php echo("BA-".$surrrow['ba_no']." | ".$surrrow['fullname']); ?>
													<br>
													<small style="font-weight:bold;"><?php echo($posted_on); ?></small>
														
												</td>	
											</tr>
											</tbody>
											<?php
													}
												}	
											?>
								</table>
								<div class="box-title">
								<div align="left" class="col-sm-6"><h6><b>Report Name:</b> Survey Report</h6></div>
								<div align="right" class="col-sm-6"><h6><b>Printed By:</b> <?php echo($UserFullName); ?> <b>On</b> <?php echo(date("F d, Y h:i A")); ?> </h6></div>
							</div>
							</div>


						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</body>

</html>