<?php
	include("includes/functions.php");
	include("includes/session.php");
	include("includes/errors.php");
	chk_login1($db,$URL);

	/**
   * Calculates the great-circle distance between two points, with
   * the Haversine formula.
   * @param float $latitudeFrom Latitude of start point in [deg decimal]
   * @param float $longitudeFrom Longitude of start point in [deg decimal]
   * @param float $latitudeTo Latitude of target point in [deg decimal]
   * @param float $longitudeTo Longitude of target point in [deg decimal]
   * @param float $earthRadius Mean earth radius in [m]
   * @return float Distance between points in [m] (same as earthRadius)
   */
  	function haversineGreatCircleDistance($latitudeFrom, $longitudeFrom, $latitudeTo, $longitudeTo, $earthRadius = 6371000)
  	{
    	// convert from degrees to radians
    	$latFrom = deg2rad($latitudeFrom);
    	$lonFrom = deg2rad($longitudeFrom);
    	$latTo = deg2rad($latitudeTo);
    	$lonTo = deg2rad($longitudeTo);

    	$latDelta = $latTo - $latFrom;
    	$lonDelta = $lonTo - $lonFrom;

    	$angle = 2 * asin(sqrt(pow(sin($latDelta / 2), 2) +
    	  cos($latFrom) * cos($latTo) * pow(sin($lonDelta / 2), 2)));
    	return $angle * $earthRadius;
  	}

  	if(isset($_REQUEST['t']))
  	{
  		header("Location: print_supervisor_attendance_report.php?fromdate=".$_REQUEST['fromdate']."&todate=".$_REQUEST['todate']."&lid=".$_REQUEST['lid']."&id=".$_REQUEST['id']."t=".$_REQUEST['t']."");
  	}
?>
<!doctype html>
<html>

<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
	<!-- Apple devices fullscreen -->
	<meta name="apple-mobile-web-app-capable" content="yes" />
	<!-- Apple devices fullscreen -->
	<meta names="apple-mobile-web-app-status-bar-style" content="black-translucent" />

	<title>Sentient - Staff Attendance Report</title>

	<!-- Bootstrap -->
	<link rel="stylesheet" href="css/bootstrap.min.css">
	<!-- jQuery UI -->
	<link rel="stylesheet" href="css/plugins/jquery-ui/jquery-ui.min.css">
	<!-- dataTables -->
	<link rel="stylesheet" href="css/plugins/datatable/TableTools.css">
	<!-- chosen -->
	<link rel="stylesheet" href="css/plugins/chosen/chosen.css">
	<!-- Theme CSS -->
	<link rel="stylesheet" href="css/style.css">
	<!-- Color CSS -->
	<link rel="stylesheet" href="css/themes.css">

	<!-- jQuery -->
	<script src="js/jquery.min.js"></script>

	<!-- Nice Scroll -->
	<script src="js/plugins/nicescroll/jquery.nicescroll.min.js"></script>
	<!-- imagesLoaded -->
	<script src="js/plugins/imagesLoaded/jquery.imagesloaded.min.js"></script>
	<!-- jQuery UI -->
	<script src="js/plugins/jquery-ui/jquery-ui.js"></script>
	<!-- slimScroll -->
	<script src="js/plugins/slimscroll/jquery.slimscroll.min.js"></script>
	<!-- Bootstrap -->
	<script src="js/bootstrap.min.js"></script>
	<!-- Bootbox -->
	<script src="js/plugins/bootbox/jquery.bootbox.js"></script>
	<!-- New DataTables -->
	<script src="js/plugins/momentjs/jquery.moment.min.js"></script>
	<script src="js/plugins/momentjs/moment-range.min.js"></script>
	<script src="js/plugins/datatables/jquery.dataTables.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.tableTools.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.colReorder.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.colVis.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.scroller.min.js"></script>

	<!-- Chosen -->
	<script src="js/plugins/chosen/chosen.jquery.min.js"></script>

	<!-- Theme framework -->
	<script src="js/eakroko.min.js"></script>
	<!-- Theme scripts -->
	<script src="js/application.min.js"></script>
	<!-- Just for demonstration -->
	<script src="js/demonstration.min.js"></script>

	<!--[if lte IE 9]>
		<script src="js/plugins/placeholder/jquery.placeholder.min.js"></script>
		<script>
			$(document).ready(function() {
				$('input, textarea').placeholder();
			});
		</script>
	<![endif]-->

	<!-- Favicon -->
	<link rel="shortcut icon" href="img/favicon.png" />
	<!-- Apple devices Homescreen icon -->
	<link rel="apple-touch-icon-precomposed" href="img/apple-touch-icon-precomposed.png" />

</head>

<body>
	<div class="container-fluid nav-hidden" id="content">
		<div id="main">
			<div class="container-fluid">
				
				
				<div class="row">
					<div class="col-sm-12">
						<div class="box">
							
							<div class="box-content">
								<div class="invoice-info">
									
									<div class="invoice-from">
										<br>
										<?php
											if(isset($_REQUEST['tr']))
											{
										?>
										<a href="print_supervisor_attendance_report.php?fromdate=<?php echo($_REQUEST['fromdate']); ?>&todate=<?php echo($_REQUEST['todate']); ?>&lid=<?php echo($_REQUEST['lid']); ?>&id=<?php echo($_REQUEST['id']); ?>">
											<img src="images/sentient_logo.jpg" width="125">
										</a>
										<?php
											}
											else
											{
										?>
										<a href="print_supervisor_attendance_report.php?fromdate=<?php echo($_REQUEST['fromdate']); ?>&todate=<?php echo($_REQUEST['todate']); ?>&lid=<?php echo($_REQUEST['lid']); ?>&id=<?php echo($_REQUEST['id']); ?>&tr=1">
											<img src="images/sentient_logo.jpg" width="125">
										</a>
										<?php		
											}
										?>
										<address>
											Sentient
											<br>Lahore
										</address>
									</div>
									
									<div class="invoice-infos">
										<h1>Staff Attendance Report</h1>
										<?php
											$uid = $_REQUEST['id'];
											$lid = $_REQUEST['lid'];
											
											$from_date_timestamp = strtotime($_REQUEST['fromdate']);
											$to_date_timestamp = strtotime($_REQUEST['todate']) + 86399;

											$from_date = date("d-m-Y",$from_date_timestamp);
											$to_date = date("d-m-Y",$to_date_timestamp);

											if($_REQUEST['id'] != 0)
											{
												$uid = $_REQUEST['id'];
												$suquery = $db->prepare("SELECT uid, su_no, fullname FROM users WHERE uid=?");
												$suquery->execute(array($uid));
												while($surow = $suquery->fetch())
												{
													$su_name = $surow['fullname'].": SU-".$surow['su_no'];
												}
												$q1 = "AND SA.uid = '$uid'";

											}
											else
											{
												$su_name = "All";
												$q1 = "";
											}

											if($_REQUEST['lid'] != 0)
											{
												$lid = $_REQUEST['lid'];
												$lquery = $db->prepare("SELECT * FROM locations WHERE lid=?");
												$lquery->execute(array($lid));
												while($lrow = $lquery->fetch())
												{
													$location = $lrow['lname'];
												}
												$q2 = "AND L.lid = '$lid'";
												$q2_1 = "AND L.lid = '$lid'";
											}
											else
											{
												$location = "All";
												$q2 = "";
												$q2_1 = "";
											}

											
										?>
										<table>
											<tr><td>&nbsp;</td></tr>
											<tr><td align="left"><b>From Date: <?php echo($from_date); ?></b></td></tr>
											<tr><td align="left"><b>To Date: <?php echo($to_date); ?></b></td></tr>
											<tr><td align="left"><b>Location: <?php echo($location); ?></b></td></tr>
											<tr><td align="left"><b>Supervisor: <?php echo($su_name); ?></b></td></tr>
										</table>
									</div>
								</div>
								<table class="table table-hover table-nomargin table-bordered">
									<thead>
										<tr>
											<th>Sr</th>
											<th>Date</th>
											<th>Supervisor</th>
											<th>Remarks</th>
											<th>Coordinates</th>
											<th>Distance from Office</th>
											<th>Logged in At</th>
										    <?php if(isset($_REQUEST['tr'])){ ?>
										    <th>Devices</th>
										    <?php } ?>
										</tr>
									</thead>
									<?php
										  $saquery = $db->prepare("SELECT * FROM su_attendance SA INNER JOIN users U ON SA.uid = U.uid INNER JOIN locations L ON U.lid = L.lid WHERE SA.suattimein BETWEEN $from_date_timestamp AND $to_date_timestamp $q1 $q2 GROUP BY L.lid");
		                                $saquery->execute();
		                                if($saquery->rowCount() == 0)
		                                {
		                            ?>
		                            <tbody>
										<tr>
											<td align="center" colspan="7">No Record Found!</td>
										</tr>
									</tbody>
		                            <?php    	
		                                }
		                                else
		                                {
		                                	while($sarow = $saquery->fetch())
		                                	{
		                                		$su_lid = $sarow['lid'];
		                                		$su_location = $sarow['lname'];
		                                		$su_lat = $sarow['llat'];
		                                		$su_long = $sarow['llong'];

		                                		$user_app_id = $sarow['app_id'];
												//$suat_app_id = $sarow['suatapp_id'];
												
												
		                            ?>
									<tbody>
										<tr>
											<td align="left" class="title" colspan="8" style="background-color: dimgrey; color:white; font-weight: bold;" height="25"><?php echo($sarow['lname']); ?></td>
										</tr>
									</tbody>
									
										<?php
												$count = 0;
											  	$vsquery = $db->prepare("SELECT * FROM su_attendance SA 
																		INNER JOIN users US ON SA.uid = US.uid 
																		WHERE SA.suattimein BETWEEN $from_date_timestamp AND $to_date_timestamp $q1  GROUP BY SA.suatid ORDER BY SA.suatid DESC ");
												$vsquery->execute();
												while($vsrow = $vsquery->fetch())
												{
													
													$uid = $vsrow['uid'];
													$lid = $vsrow['lid'];
													$attendance_date = $vsrow['suat_date'];
													$user_app_id = $vsrow['app_id'];		
													$suatlat = $vsrow['suatlat'];	
													$suatlong = $vsrow['suatlong'];	
													$login_time = date("d-m-Y h:i:s A",$vsrow['suattimein']);
													$meter_distance = haversineGreatCircleDistance($suatlat, $suatlong, $su_lat, $su_long, $earthRadius = 6371000);
														$su_distance = $meter_distance;
														
													if($su_lid == $lid){
													    $count++;
											?>
											<tbody>	
												
											<tr>
												<td align="center" class="title" height="25"><?php echo($count); ?>.</td>
												<td align="left"><?php echo($login_time); ?></td>
												<td align="left">SU-<?php echo($vsrow['su_no']); ?> <?php echo($vsrow['fullname']); ?></td>
												<td align="left"><?php echo($vsrow['suatremarks']); ?> <?php echo($vsrow['fullname']); ?></td>
												<td align="left">Lat: <?php echo($su_lat); ?><br>Long: <?php echo($su_long); ?></td>
												<td align="left"><?php echo(number_format($meter_distance,2)." Meters"); ?></td>
												<td align="left"><?php echo($login_time); ?></td>
											    <?php if(isset($_REQUEST['tr'])){ ?>
											    <td align="left">
												<?php

													$atlquery = $db->prepare("SELECT * FROM attendance_log WHERE uid = ? AND attendance_date = ? ORDER BY atlid ASC");
													$atlquery->execute(array($uid, $attendance_date));
													if($atlquery->rowCount() == 0)
													{
														$device_msg = "<small style='font-weight: bold;'>N/A</small>";
													}
													else
													{
														while($atlrow = $atlquery->fetch())
														{
															$atl_app_id = $atlrow['app_id'];
															$atl_date = date("d-m-Y h:i A",$atlrow['atldate']);
														
															if($user_app_id != "")
															{
																$baquery = $db->prepare("SELECT * FROM users WHERE app_id = ?");
																$baquery->execute(array($atl_app_id));
																if($baquery->rowCount() > 0)
																{
																	while($barow = $baquery->fetch())
																	{
																		$alt_user = $barow['username'];
																	}
																}
																else
																{
																	$alt_user = "";
																}

																if($user_app_id == $atl_app_id)
																{
																	$device_msg = "$atl_app_id <br> <small style='color: green; font-weight: bold;'>Registered</small>";
																}
																else
																{

																	$device_msg = "$atl_app_id ($alt_user)<br> <small style='color: red; font-weight: bold;'>Unregistered</small>";
																}
															}
															else
															{
																$device_msg = "$atl_app_id <br> <small style='color: red; font-weight: bold;'>Unregistered</small>";
															}
															echo($device_msg." at ".$atl_date." (".$atlrow['atldate'].")<br>");
														}
													}

													
												?>
												</td>
												<?php } ?>
											</tr>
											</tbody>
											<?php
													    }
												    }
											    }
		                                    }												
												
											?>
											
								</table>
								<div class="box-title">
								<div align="left" class="col-sm-6"><h6><b>Report Name:</b> Staff Attendance Report</h6></div>
								<div align="right" class="col-sm-6"><h6><b>Printed By:</b> <?php echo($UserFullName); ?> <b>On</b> <?php echo(date("F d, Y h:i A")); ?> </h6></div>
							</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</body>

</html>