<?php
	include("includes/functions.php");
	include("includes/session.php");
	include("includes/errors.php");
	chk_login1($db,$URL);

	/**
   * Calculates the great-circle distance between two points, with
   * the Haversine formula.
   * @param float $latitudeFrom Latitude of start point in [deg decimal]
   * @param float $longitudeFrom Longitude of start point in [deg decimal]
   * @param float $latitudeTo Latitude of target point in [deg decimal]
   * @param float $longitudeTo Longitude of target point in [deg decimal]
   * @param float $earthRadius Mean earth radius in [m]
   * @return float Distance between points in [m] (same as earthRadius)
   */
  	function haversineGreatCircleDistance($latitudeFrom, $longitudeFrom, $latitudeTo, $longitudeTo, $earthRadius = 6371000)
  	{
    	// convert from degrees to radians
    	$latFrom = deg2rad($latitudeFrom);
    	$lonFrom = deg2rad($longitudeFrom);
    	$latTo = deg2rad($latitudeTo);
    	$lonTo = deg2rad($longitudeTo);

    	$latDelta = $latTo - $latFrom;
    	$lonDelta = $lonTo - $lonFrom;

    	$angle = 2 * asin(sqrt(pow(sin($latDelta / 2), 2) +
    	  cos($latFrom) * cos($latTo) * pow(sin($lonDelta / 2), 2)));
    	return $angle * $earthRadius;
  	}
?>
<!doctype html>
<html>

<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
	<!-- Apple devices fullscreen -->
	<meta name="apple-mobile-web-app-capable" content="yes" />
	<!-- Apple devices fullscreen -->
	<meta names="apple-mobile-web-app-status-bar-style" content="black-translucent" />

	<title>Sentient - Supervisor Visit Summary Report</title>

	<!-- Bootstrap -->
	<link rel="stylesheet" href="css/bootstrap.min.css">
	<!-- jQuery UI -->
	<link rel="stylesheet" href="css/plugins/jquery-ui/jquery-ui.min.css">
	<!-- dataTables -->
	<link rel="stylesheet" href="css/plugins/datatable/TableTools.css">
	<!-- chosen -->
	<link rel="stylesheet" href="css/plugins/chosen/chosen.css">
	<!-- Theme CSS -->
	<link rel="stylesheet" href="css/style.css">
	<!-- Color CSS -->
	<link rel="stylesheet" href="css/themes.css">

	<!-- jQuery -->
	<script src="js/jquery.min.js"></script>

	<!-- Nice Scroll -->
	<script src="js/plugins/nicescroll/jquery.nicescroll.min.js"></script>
	<!-- imagesLoaded -->
	<script src="js/plugins/imagesLoaded/jquery.imagesloaded.min.js"></script>
	<!-- jQuery UI -->
	<script src="js/plugins/jquery-ui/jquery-ui.js"></script>
	<!-- slimScroll -->
	<script src="js/plugins/slimscroll/jquery.slimscroll.min.js"></script>
	<!-- Bootstrap -->
	<script src="js/bootstrap.min.js"></script>
	<!-- Bootbox -->
	<script src="js/plugins/bootbox/jquery.bootbox.js"></script>
	<!-- New DataTables -->
	<script src="js/plugins/momentjs/jquery.moment.min.js"></script>
	<script src="js/plugins/momentjs/moment-range.min.js"></script>
	<script src="js/plugins/datatables/jquery.dataTables.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.tableTools.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.colReorder.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.colVis.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.scroller.min.js"></script>

	<!-- Chosen -->
	<script src="js/plugins/chosen/chosen.jquery.min.js"></script>

	<!-- Theme framework -->
	<script src="js/eakroko.min.js"></script>
	<!-- Theme scripts -->
	<script src="js/application.min.js"></script>
	<!-- Just for demonstration -->
	<script src="js/demonstration.min.js"></script>

	<!--[if lte IE 9]>
		<script src="js/plugins/placeholder/jquery.placeholder.min.js"></script>
		<script>
			$(document).ready(function() {
				$('input, textarea').placeholder();
			});
		</script>
	<![endif]-->

	<!-- Favicon -->
	<link rel="shortcut icon" href="img/favicon.png" />
	<!-- Apple devices Homescreen icon -->
	<link rel="apple-touch-icon-precomposed" href="img/apple-touch-icon-precomposed.png" />

</head>

<body>
	<div class="container-fluid nav-hidden" id="content">
		<div id="main">
			<div class="container-fluid">
				
				
				<div class="row">
					<div class="col-sm-12">
						<div class="box">
							
							<div class="box-content">
								<div class="invoice-info">
									
									<div class="invoice-from">
										<br>
										<img src="images/sentient_logo.jpg" width="125">
								
										<address>
											Sentient
											<br>Lahore
											
										</address>
									</div>
									
									<div class="invoice-infos">
										<h1>Visit Summary Report</h1>
										<?php
											$uid = $_REQUEST['id'];
											$stid = $_REQUEST['stid'];

											$from_date_timestamp = strtotime($_REQUEST['fromdate']);
											$to_date_timestamp = strtotime($_REQUEST['todate']) + 86399;

											$from_date = date("d-m-Y",$from_date_timestamp);
											$to_date = date("d-m-Y",$to_date_timestamp);

											if($_REQUEST['id'] != 0)
											{
												$uid = $_REQUEST['id'];
												$suquery = $db->prepare("SELECT uid, su_no, fullname FROM users WHERE uid=?");
												$suquery->execute(array($uid));
												while($surow = $suquery->fetch())
												{
													$su_name = $surow['fullname'].": SU-".$surow['su_no'];
												}
												$q1 = "AND V.uid = '$uid'";

											}
											else
											{
												$su_name = "All";
												$q1 = "";
											}

											if($_REQUEST['stid'] != 0)
											{
												$stid = $_REQUEST['stid'];
												$stquery = $db->prepare("SELECT stid, store_code, store_name, city FROM store WHERE stid=?");
												$stquery->execute(array($stid));
												while($strow = $stquery->fetch())
												{
													$store_name = $strow['store_name'].", ".$strow['city'].": ST-".$strow['store_code'];
												}
												$q2 = "AND V.stid = '$stid'";
												$q2_1 = "AND ST.stid = '$stid'";

											}
											else
											{
												$store_name = "All";
												$q2 = "";
												$q2_1 = "";
											}

											if($_REQUEST['city'] != 0 && $_REQUEST['city'] != "")
											{
												$stcity = $_REQUEST['city'];


												/*echo("'".str_replace(",","','",$stcity)."'");
												echo("<br>");
												$temp = array(0,1);
												*/
												//$st_city = "'".str_replace(",","','",$stcity)."'";										
												//$result = "'" . implode ( "', '", $temp ) . "'";

												//echo($result);
												$q3 = "AND ST.city = '$stcity'";
											}
											else{
												$stcity = "All";
												$q3 = "";
											}

											if($_REQUEST['stcid'] != 0 && $_REQUEST['stcid'] != "")
											{
												$store_chain = $_REQUEST['stcid'];


												/*echo("'".str_replace(",","','",$stcity)."'");
												echo("<br>");
												$temp = array(0,1);
						*/
												$st_store_chain= "'".str_replace(",","','",$store_chain)."'";										
												//$result = "'" . implode ( "', '", $temp ) . "'";

												//echo($result);
												$q4 = "AND ST.chain_store IN ($st_store_chain)";

											}
											else{
												$store_chain = "All";
												$q4 = "";
											}
											$q5 = "AND V.uid NOT IN (489, 179, 222, 1288, 1205, 1289, 159, 124, 1311, 1290, 943, 1025, 413, 415)";
								
										?>
										<table>
											<tr><td>&nbsp;</td></tr>
											<tr><td align="left"><b>From Date: <?php echo($from_date); ?></b></td></tr>
											<tr><td align="left"><b>To Date: <?php echo($to_date); ?></b></td></tr>
											<tr><td align="left"><b>City: <?php echo($stcity); ?></b></td></tr>
											<tr><td align="left"><b>Supervisor: <?php echo($su_name); ?></b></td></tr>
											<tr><td align="left"><b>Store Chain: <?php echo($store_chain); ?></b></td></tr>
											<tr><td align="left"><b>Store: <?php echo($store_name); ?></b></td></tr>
										</table>
									</div>
								</div>
								<table class="table table-hover table-nomargin table-bordered">
									<?php

										$count = 0;
								        $query = $db->prepare("SELECT * FROM visits V INNER JOIN users U ON V.uid = U.uid INNER JOIN store ST ON V.stid = ST.stid WHERE V.vdate BETWEEN $from_date_timestamp AND $to_date_timestamp $q1 $q2 $q3 $q4 $q5 GROUP BY V.uid");
		                                $query->execute();
		                                while($row = $query->fetch())
		                                {

		                                	$uid = $row['uid'];
		                                	$storeid = $row['stid'];
		                            ?>
									<thead>
										<tr>
											<td align="left" class="title" colspan="7" style="background-color: dimgrey; color:white; font-weight: bold;" height="25"><?php echo($row['fullname']); ?>: SU-<?php echo($row['su_no']); ?></td>
										</tr>
										<tr>
											<th>Sr</th>
											<th>Store</th>
											<th>City</th>
											<th>Brand</th>
											<th>Total Visits</th>
											<th>Last Visit</th>
											<th>Days Ago</th>
										</tr>
									</tbody>

											<?php
												$num_visits = array();
												/// Num Brands
												$brquery = $db->prepare("SELECT * FROM assignments WHERE supuid = $uid GROUP BY brid");
												$brquery->execute();
												$num_brands = $brquery->rowCount();

												$vsquery = $db->prepare("SELECT * FROM assignments ASA INNER JOIN brand BR ON ASA.brid = BR.brid INNER JOIN store ST ON ASA.stid = ST.stid WHERE ASA.supuid = $uid $q2_1 $q3 $q4 GROUP BY ASA.stid");
												$vsquery->execute();
												while($vsrow = $vsquery->fetch())
												{
													$uid = $vsrow['supuid'];
													$stid = $vsrow['stid'];

													//$brand = $vsrow['brname'];
													// $stlat = $vsrow['stlat'];
													// $stlong = $vsrow['stlong'];
													// echo($stlat."<br>");

													$store_name = $vsrow['store_name'].", ".$vsrow['city'].": ST-".$vsrow['store_code'];
													$store_city = $vsrow['city'];

													/// num visit
													$nvquery = $db->prepare("SELECT COUNT(vid) AS total_visit, stid, uid FROM visits WHERE vdate BETWEEN ? AND ? AND uid = ? AND stid = ?");
													$nvquery->execute(array($from_date_timestamp,$to_date_timestamp,$uid,$stid));
													while($nvrow = $nvquery->fetch())
													{
														$total_visit = $nvrow['total_visit'];
													}
													if($total_visit > 0){ array_push($num_visits, $total_visit); }

													/// check last visit
													$lvquery = $db->prepare("SELECT * FROM visits WHERE vdate BETWEEN ? AND ? AND uid = ? AND stid = ? ORDER BY vid DESC LIMIT 0,1");
													$lvquery->execute(array($from_date_timestamp,$to_date_timestamp,$uid,$stid));
													if($lvquery->rowCount() > 0)
													{
														while($lvrow = $lvquery->fetch())
														{
															if($lvrow['post_date'] != 0)
															{
																$post_time = $lvrow['post_date'];
																$post_date = date("d-m-Y h:i A",$lvrow['post_date']);

																$total_hrs_time_difference = time() - $lvrow['post_date'];	

																if ($total_hrs_time_difference > 0) {

																	
																	$seconds2 = $total_hrs_time_difference;
																	$days2 = floor($seconds2 / 86400);
												                    $seconds2 %= 86400;

												                    $hours2 = floor($seconds2 / 3600);
												                    $seconds2 %= 3600;

												                    $minutes2 = floor($seconds2 / 60);
												                    $seconds2 %= 60;
												                     
												                    $total_days = $days2;
												                    // $total_working_hrs ="".str_pad($hours2, 2, "0", STR_PAD_LEFT).":".str_pad($minutes2, 2, "0", STR_PAD_LEFT)."";
																}
																else
																{
																	$post_time = 0;
																	// $total_working_hrs ="";
																	$total_days = "";
																}
															}
															else
															{
																$post_time = 0;
																$post_date = "N/A";
																$total_days = "";
															}
														}	
													}
													else
													{
														$post_time = 0;
														$post_date = "N/A";
														$total_days = "";
													}
													$count++;
											?>
											<tbody>	
											<tr>
												<td align="center" class="title" height="25"><?php echo($count); ?>. </td>
												<td align="left"><?php echo($store_name); ?></td>
												<td align="left"><?php echo($store_city); ?></td>
												<td align="left">
												<?php
														$ascount = 0;
														$asquery = $db->prepare("SELECT * FROM assignments ASA INNER JOIN brand BR ON ASA.brid = BR.brid WHERE ASA.supuid = ? AND ASA.stid = ?");
														$asquery->execute(array($uid, $stid));
														while($asrow = $asquery->fetch())
														{
															$ascount++;

															if($ascount ==1) { $comma = ""; } else{ $comma = ", "; }
															echo($comma.$asrow['brname']);
														}		
												?>
												</td>
												<td align="center"><?php echo($total_visit); ?></td>
												<td align="center"><?php echo($post_date); ?></td>
												<td align="center"><?php echo($total_days); ?></td>
											</tr>
											</tbody>	
											<?php
													}
											?>
											<tr style="background-color: lightyellow;">
												<td align="right" colspan="3"><strong>Total Brands</strong>&nbsp;</td>
												<td><strong><?php echo($num_brands); ?></strong></td>
												<td align="center"><strong><?php print_r(array_sum($num_visits)); ?></strong></td>
												<td colspan="2"></td>
											</tr>
											<?php		
												}
											
																							
												if($count == 0)
												{
											?>
											<tbody>	
											<tr>
												<td align="center" class="title" height="25"> </td>
												<td align="center"></td>
												<td align="center"><span style="color:red; font-weight:bold;">No Records Found!</span></td>
												<td align="center"></td>
												<td align="right">&nbsp;</td>
												<td align="right">&nbsp;</td>
												<td align="right">&nbsp;</td>
											</tr>
											</tbody>	
											<?php
												}	
											?>
								</table>
								<div class="box-title">
								<div align="left" class="col-sm-6"><h6><b>Report Name:</b> Supervisor Visits Summary Report</h6></div>
								<div align="right" class="col-sm-6"><h6><b>Printed By:</b> <?php echo($UserFullName); ?> <b>On</b> <?php echo(date("F d, Y h:i A")); ?> </h6></div>
							</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</body>

</html>