<?php
	include("includes/functions.php");
	include("includes/session.php");
	include("includes/errors.php");
	chk_login1();
?>
<!doctype html>
<html>

<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
	<!-- Apple devices fullscreen -->
	<meta name="apple-mobile-web-app-capable" content="yes" />
	<!-- Apple devices fullscreen -->
	<meta names="apple-mobile-web-app-status-bar-style" content="black-translucent" />

	<title>Sentient - Supervisor Login Report</title>

	<!-- Bootstrap -->
	<link rel="stylesheet" href="css/bootstrap.min.css">
	<!-- jQuery UI -->
	<link rel="stylesheet" href="css/plugins/jquery-ui/jquery-ui.min.css">
	<!-- dataTables -->
	<link rel="stylesheet" href="css/plugins/datatable/TableTools.css">
	<!-- chosen -->
	<link rel="stylesheet" href="css/plugins/chosen/chosen.css">
	<!-- Theme CSS -->
	<link rel="stylesheet" href="css/style.css">
	<!-- Color CSS -->
	<link rel="stylesheet" href="css/themes.css">

	<!-- jQuery -->
	<script src="js/jquery.min.js"></script>

	<!-- Nice Scroll -->
	<script src="js/plugins/nicescroll/jquery.nicescroll.min.js"></script>
	<!-- imagesLoaded -->
	<script src="js/plugins/imagesLoaded/jquery.imagesloaded.min.js"></script>
	<!-- jQuery UI -->
	<script src="js/plugins/jquery-ui/jquery-ui.js"></script>
	<!-- slimScroll -->
	<script src="js/plugins/slimscroll/jquery.slimscroll.min.js"></script>
	<!-- Bootstrap -->
	<script src="js/bootstrap.min.js"></script>
	<!-- Bootbox -->
	<script src="js/plugins/bootbox/jquery.bootbox.js"></script>
	<!-- New DataTables -->
	<script src="js/plugins/momentjs/jquery.moment.min.js"></script>
	<script src="js/plugins/momentjs/moment-range.min.js"></script>
	<script src="js/plugins/datatables/jquery.dataTables.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.tableTools.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.colReorder.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.colVis.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.scroller.min.js"></script>

	<!-- Chosen -->
	<script src="js/plugins/chosen/chosen.jquery.min.js"></script>

	<!-- Theme framework -->
	<script src="js/eakroko.min.js"></script>
	<!-- Theme scripts -->
	<script src="js/application.min.js"></script>
	<!-- Just for demonstration -->
	<script src="js/demonstration.min.js"></script>

	<!--[if lte IE 9]>
		<script src="js/plugins/placeholder/jquery.placeholder.min.js"></script>
		<script>
			$(document).ready(function() {
				$('input, textarea').placeholder();
			});
		</script>
	<![endif]-->

	<!-- Favicon -->
	<link rel="shortcut icon" href="img/favicon.png" />
	<!-- Apple devices Homescreen icon -->
	<link rel="apple-touch-icon-precomposed" href="img/apple-touch-icon-precomposed.png" />

</head>

<body>
	<div class="container-fluid nav-hidden" id="content">
		<div id="main">
			<div class="container-fluid">
				
				
				<div class="row">
					<div class="col-sm-12">
						<div class="box">
							
							<div class="box-content">
								<div class="invoice-info">
									
									<div class="invoice-from">
										<br>
										
										
											<img src="images/sentient_logo.jpg" width="125">
										
										<address>
											Sentient
											<br>Lahore
											
										</address>
									</div>
									
									<div class="invoice-infos">
										<h1>Supervisor Login Report</h1>
										<?php
											$atdate1 = strtotime($_REQUEST['date']);
											$atdate2 = strtotime($_REQUEST['date']) + 86399;
											
											$attendance_date = date("d-m-Y",$atdate1);
											$q1 = "AND ATT.atldate BETWEEN $atdate1 AND $atdate2";


											

											if($_REQUEST['id'] != 0)
											{
												$supid = $_REQUEST['id'];
												$supquery = $db->prepare("SELECT uid, su_no, fullname FROM users WHERE uid=?");
												$supquery->execute(array($supid));
												while($suprow = $supquery->fetch())
												{
													$supervisor = $suprow['fullname'].": SU-".$suprow['su_no'];
												}
												$q2 = "AND ATT.uid = '$supid'";

											}
											else{
												$supid = 0;
												$supervisor = "All";
												$q2 = "";
											}

											
										?>
										<table>
											<tr><td>&nbsp;</td></tr>
											<tr><td align="left"><b>Date: <?php echo($attendance_date); ?></b></td></tr>
											<tr><td align="left"><b>Supervisor: <?php echo($supervisor); ?></b></td></tr>
															
										</table>
									</div>
								</div>
								<table class="table table-hover table-nomargin table-bordered dataTable" data-nosearch data-nopagination data-noinfo>
									<thead>
										<tr>
											<th>Sr.</th>
											<th>Supervisor</th>
											<th>Username</th>
											<th>City</th>
											<th>Active Time</th>
											<th>Devices</th>
										</tr>
									</thead>
										<tbody>
										<?php
											$count = 0;
											//echo("SELECT * FROM attendance_log WHERE attendance_date = '".$attendance_date."' $q2");die;
											$uaquery = $db->prepare("SELECT ATT.attendance_date, ATT.uid, ATT.app_id, ATT.atldate, U.uid FROM attendance_log ATT INNER JOIN users U ON ATT.uid = U.uid WHERE ATT.attendance_date = '".$attendance_date."' $q2 AND U.utype = 3");
											$uaquery->execute();
											while($uarow = $uaquery->fetch())
											{
												$count++;
												$uid = $uarow['uid'];
												$su_app_id = $uarow['app_id'];
												$login_time = date("d-m-Y h:i A",$uarow['atldate']);

												$atlquery = $db->prepare("SELECT * FROM users WHERE uid = ?");
												$atlquery->execute(array($uid));
												while($atlrow = $atlquery->fetch())
												{	
													$user_app_id = $atlrow['app_id'];
													$fullname = $atlrow['fullname'];
													$username = $atlrow['username'];
													$su_city = $atlrow['city'];
												}						
										?>
										<tr>
											<td align="center" class="title" height="25">&nbsp;<?php echo($count); ?>. </td>
											<td align="left" ><?php echo(ucwords($fullname)); ?></td>
											<td align="left" ><?php echo($username); ?></td>
											<td align="left" ><?php echo($su_city); ?></td>
											<td align="center" ><?php echo($login_time); ?></td>

											
										    <td align="center">
										    	<?php
										    		echo("<table width='100%'>");
														
													if($user_app_id != "")
													{
														if($user_app_id == $su_app_id)
														{
															$device_msg = "$su_app_id <small style='color: green; font-weight: bold;'>Registered</small>";
															$alt_user = "";
														}
														else
														{
															$device_msg = "$su_app_id <small style='color: red; font-weight: bold;'>Unregistered</small>";
															$baquery = $db->prepare("SELECT * FROM users WHERE app_id = ?");
															$baquery->execute(array($su_app_id));
															if($baquery->rowCount() > 0)
															{
																while($barow = $baquery->fetch())
																{
																	$alt_user = $barow['username'];
																}
															}
															else
															{
																$alt_user = "Not Found!";
															}
														}
													}
													else
													{
														$device_msg = "$su_app_id <small style='color: red; font-weight: bold;'>Unregistered</small>";
														$alt_user = "";
													}
													echo("<tr>
															<td align='left'>$device_msg </td>
															<td align='left'>$alt_user </td>
														</tr>");
													echo("</table>");
												
											?>
											</td>
											<?php
												}
											?>
										</tr>
										</tbody>
										<?php
											
											if($count == 0)
											{
										?>
										<tbody>
										<tr>
											<td align="center" colspan="12"><span style="color:red; font-weight:bold;">No Records Found!</span></td>
										</tr>
										</tbody>
										<?php
											}
										?>
										
									
								</table>
								<div class="box-title">
								<div align="left" class="col-sm-6"><h6><b>Report Name:</b> Supervisor Login Report</h6></div>
								<div align="right" class="col-sm-6"><h6><b>Printed By:</b> <?php echo($UserFullName); ?> <b>On</b> <?php echo(date("F d, Y h:i A")); ?> </h6></div>
							</div>
							</div>


						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</body>

</html>