<?php
	include("includes/functions.php");
	include("includes/session.php");
	include("includes/errors.php");
	chk_login1($db,$URL);

	/**
   * Calculates the great-circle distance between two points, with
   * the Haversine formula.
   * @param float $latitudeFrom Latitude of start point in [deg decimal]
   * @param float $longitudeFrom Longitude of start point in [deg decimal]
   * @param float $latitudeTo Latitude of target point in [deg decimal]
   * @param float $longitudeTo Longitude of target point in [deg decimal]
   * @param float $earthRadius Mean earth radius in [m]
   * @return float Distance between points in [m] (same as earthRadius)
   */
  	function haversineGreatCircleDistance($latitudeFrom, $longitudeFrom, $latitudeTo, $longitudeTo, $earthRadius = 6371000)
  	{
    	// convert from degrees to radians
    	$latFrom = deg2rad($latitudeFrom);
    	$lonFrom = deg2rad($longitudeFrom);
    	$latTo = deg2rad($latitudeTo);
    	$lonTo = deg2rad($longitudeTo);

    	$latDelta = $latTo - $latFrom;
    	$lonDelta = $lonTo - $lonFrom;

    	$angle = 2 * asin(sqrt(pow(sin($latDelta / 2), 2) +
    	  cos($latFrom) * cos($latTo) * pow(sin($lonDelta / 2), 2)));
    	return $angle * $earthRadius;
  	}
?>
<!doctype html>
<html>

<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
	<!-- Apple devices fullscreen -->
	<meta name="apple-mobile-web-app-capable" content="yes" />
	<!-- Apple devices fullscreen -->
	<meta names="apple-mobile-web-app-status-bar-style" content="black-translucent" />

	<title>Sentient - Store Not Visited Report</title>

	<!-- Bootstrap -->
	<link rel="stylesheet" href="css/bootstrap.min.css">
	<!-- jQuery UI -->
	<link rel="stylesheet" href="css/plugins/jquery-ui/jquery-ui.min.css">
	<!-- dataTables -->
	<link rel="stylesheet" href="css/plugins/datatable/TableTools.css">
	<!-- chosen -->
	<link rel="stylesheet" href="css/plugins/chosen/chosen.css">
	<!-- Theme CSS -->
	<link rel="stylesheet" href="css/style.css">
	<!-- Color CSS -->
	<link rel="stylesheet" href="css/themes.css">

	<!-- jQuery -->
	<script src="js/jquery.min.js"></script>

	<!-- Nice Scroll -->
	<script src="js/plugins/nicescroll/jquery.nicescroll.min.js"></script>
	<!-- imagesLoaded -->
	<script src="js/plugins/imagesLoaded/jquery.imagesloaded.min.js"></script>
	<!-- jQuery UI -->
	<script src="js/plugins/jquery-ui/jquery-ui.js"></script>
	<!-- slimScroll -->
	<script src="js/plugins/slimscroll/jquery.slimscroll.min.js"></script>
	<!-- Bootstrap -->
	<script src="js/bootstrap.min.js"></script>
	<!-- Bootbox -->
	<script src="js/plugins/bootbox/jquery.bootbox.js"></script>
	<!-- New DataTables -->
	<script src="js/plugins/momentjs/jquery.moment.min.js"></script>
	<script src="js/plugins/momentjs/moment-range.min.js"></script>
	<script src="js/plugins/datatables/jquery.dataTables.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.tableTools.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.colReorder.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.colVis.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.scroller.min.js"></script>

	<!-- Chosen -->
	<script src="js/plugins/chosen/chosen.jquery.min.js"></script>

	<!-- Theme framework -->
	<script src="js/eakroko.min.js"></script>
	<!-- Theme scripts -->
	<script src="js/application.min.js"></script>
	<!-- Just for demonstration -->
	<script src="js/demonstration.min.js"></script>

	<!--[if lte IE 9]>
		<script src="js/plugins/placeholder/jquery.placeholder.min.js"></script>
		<script>
			$(document).ready(function() {
				$('input, textarea').placeholder();
			});
		</script>
	<![endif]-->

	<!-- Favicon -->
	<link rel="shortcut icon" href="img/favicon.png" />
	<!-- Apple devices Homescreen icon -->
	<link rel="apple-touch-icon-precomposed" href="img/apple-touch-icon-precomposed.png" />

</head>

<body>
	<div class="container-fluid nav-hidden" id="content">
		<div id="main">
			<div class="container-fluid">
				
				
				<div class="row">
					<div class="col-sm-12">
						<div class="box">
							
							<div class="box-content">
								<div class="invoice-info">
									
									<div class="invoice-from">
										<br>
										<img src="images/sentient_logo.jpg" width="125">
								
										<address>
											Sentient
											<br>Lahore
											
										</address>
									</div>
									
									<div class="invoice-infos">
										<h1>Store Not Visited Report</h1>
										<?php
											$brid = $_REQUEST['brid'];
											$uid = $_REQUEST['id'];
											$stid = $_REQUEST['stid'];
											$city = $_REQUEST['city'];
											$stcid = $_REQUEST['stcid'];
											$sttype = $_REQUEST['sttype'];

											$from_date_timestamp = strtotime($_REQUEST['fromdate']);
											$to_date_timestamp = strtotime($_REQUEST['todate']) + 86399;

											$from_date = date("d-m-Y",$from_date_timestamp);
											$to_date = date("d-m-Y",$to_date_timestamp);

											if($_REQUEST['id'] != 0)
											{
												$uid = $_REQUEST['id'];
												$suquery = $db->prepare("SELECT uid, su_no, fullname FROM users WHERE uid=?");
												$suquery->execute(array($uid));
												while($surow = $suquery->fetch())
												{
													$su_name = $surow['fullname'].": SU-".$surow['su_no'];
												}
												$q1 = "AND VS.uid = '$uid'";
											}
											else
											{
												$su_name = "All";
												$q1 = "";
											}

											if($_REQUEST['stid'] != 0)
											{
												$stid = $_REQUEST['stid'];
												$stquery = $db->prepare("SELECT stid, store_code, store_name, city FROM store WHERE stid=?");
												$stquery->execute(array($stid));
												while($strow = $stquery->fetch())
												{
													$store_name = $strow['store_name'].", ".$strow['city'].": ST-".$strow['store_code'];
												}
												$q2 = "AND stid = '$stid'";

											}
											else
											{
												$store_name = "All";
												$q2 = "";
											}

											if($_REQUEST['city'] != 0 && $_REQUEST['city'] != "")
											{
												$stcity = $_REQUEST['city'];


												/*echo("'".str_replace(",","','",$stcity)."'");
												echo("<br>");
												$temp = array(0,1);
												*/
												//$st_city = "'".str_replace(",","','",$stcity)."'";										
												//$result = "'" . implode ( "', '", $temp ) . "'";

												//echo($result);
												$q3 = "AND city = '$stcity'";
											}
											else{
												$stcity = "All";
												$q3 = "";
											}

											if($_REQUEST['stcid'] != 0 && $_REQUEST['stcid'] != "")
											{
												$store_chain = $_REQUEST['stcid'];
												/*echo("'".str_replace(",","','",$stcity)."'");
												echo("<br>");
												$temp = array(0,1);
												*/
												$st_store_chain= "'".str_replace(",","','",$store_chain)."'";										
												//$result = "'" . implode ( "', '", $temp ) . "'";

												//echo($result);
												$q4 = "AND chain_store IN ($st_store_chain)";

											}
											else{
												$store_chain = "All";
												$q4 = "";
											}
											/*if($_REQUEST['stcid'] != 0)
											{
												$store_chain = $_REQUEST['stcid'];
												$q4 = "AND chain_store = '$store_chain'";

											}
											else{
												$store_chain = "All";
												$q4 = "";
											}*/

											if($_REQUEST['brid'] != 0)
											{
												$brid = $_REQUEST['brid'];
												$q5 = "AND ASA.brid = $brid";
												$brquery = $db->prepare("SELECT brid, brname FROM brand WHERE brid=?");
												$brquery->execute(array($brid));
												while($brrow = $brquery->fetch())
												{
													$brand = $brrow['brname'];
												}

											}
											else{
												$brid = 0;
												$q5 = "";
												$brand = "All";
											}

											if($_REQUEST['sttype'] != 0)
											{
												$sttype = $_REQUEST['sttype'];

												if($sttype == 1)
												{
													$q6 = "AND ststatus = 0";
													$store_status = "Active";
												}
												if($sttype == 2)
												{
													$q6 = "AND ststatus = 1";
													$store_status = "Inactive";
												}
											}
											else{
												$q6 = "";
												$store_status = "All";
											}
											
										?>
										<table>
											<tr><td>&nbsp;</td></tr>
											<tr><td align="left"><b>From Date: <?php echo($from_date); ?></b></td></tr>
											<tr><td align="left"><b>To Date: <?php echo($to_date); ?></b></td></tr>
											<tr><td align="left"><b>Brand: <?php echo($brand); ?></b></td></tr>
											<tr><td align="left"><b>City: <?php echo($stcity); ?></b></td></tr>
											<tr><td align="left"><b>Supervisor: <?php echo($su_name); ?></b></td></tr>
											<tr><td align="left"><b>Store Chain: <?php echo($store_chain); ?></b></td></tr>
											<tr><td align="left"><b>Store: <?php echo($store_name); ?></b></td></tr>
											<tr><td align="left"><b>Store Status: <?php echo($store_status); ?></b></td></tr>
										</table>
									</div>
								</div>
								<table class="table table-hover table-nomargin table-bordered dataTable" data-nosearch data-nopagination data-noinfo>
									<thead>
										<tr>
											<th>Sr</th>
											<th>Brand</th>
											<th>City</th>
											<th>Store</th>
											<th>Supervisor</th>
											<th>Remarks</th>
											<th>Last Visit Date</th>
											<th>Visited At</th>
											<th>Days Ago</th>
										</tr>
									</thead>
									<tbody>
										<?php
												$count = 0;
												$stquery = $db->prepare("SELECT * FROM store WHERE ststatus = 0 $q2 $q3 $q4 $q6 ORDER BY store_name ASC");
												$stquery->execute();
												while($strow = $stquery->fetch())
												{
													$stid = $strow['stid'];
													$store_name = $strow['store_name'].", ".$strow['city'].": ST-".$strow['store_code'];
													$stlat = $strow['stlat'];
													$stlong = $strow['stlong'];
													$store_city = $strow['city'];

													/// check last visit
													$lvquery = $db->prepare("SELECT * FROM visits VS INNER JOIN users U ON VS.uid = U.uid 
																	WHERE VS.vdate  BETWEEN $from_date_timestamp AND $to_date_timestamp AND VS.stid = $stid $q1 ORDER BY VS.vid DESC");
													$lvquery->execute();
													if($lvquery->rowCount() == 0)
													{
														$lastvquery = $db->prepare("SELECT * FROM visits VS INNER JOIN users U ON VS.uid = U.uid 
																WHERE VS.stid = $stid $q1 ORDER BY VS.vid DESC LIMIT 0,1");
														$lastvquery->execute();
														if($lastvquery->rowCount() > 0)
														{
															while($lastvrow = $lastvquery->fetch())
															{
																$vid = $lastvrow['vid'];
																$uid = $lastvrow['uid'];
																$stid = $lastvrow['stid'];
																$remarks = $lastvrow['remarks'];
																$supervisor = $lastvrow['fullname']." SU -".$lastvrow['su_no'];
																$last_visit_date = date("d-m-Y",$lastvrow['vdate']);

																$post_time = $lastvrow['vdate'];
																if($lastvrow['post_date'] > 0)
																{
																	$post_date = date("h:i A",$lastvrow['post_date']);	
																}
																else
																{
																	$post_date = "N/A";
																
																}
																
																$total_hrs_time_difference = time() - $lastvrow['vdate'];	

																if ($total_hrs_time_difference > 0) {

																	
																	$seconds2 = $total_hrs_time_difference;
																	$days2 = floor($seconds2 / 86400);
												                    $seconds2 %= 86400;

												                    $hours2 = floor($seconds2 / 3600);
												                    $seconds2 %= 3600;

												                    $minutes2 = floor($seconds2 / 60);
												                    $seconds2 %= 60;
												                     
												                    $total_days = $days2;
												                    // $total_working_hrs ="".str_pad($hours2, 2, "0", STR_PAD_LEFT).":".str_pad($minutes2, 2, "0", STR_PAD_LEFT)."";
																}
																else
																{
																	$post_time = 0;
																	// $total_working_hrs ="";
																	$total_days = "N/A";
																}

																/*if($lastvrow['post_date'] != 0)
																{
																	
																}
																else
																{
																	$post_time = 0;
																	$post_date = "N/A";
																	$total_days = "N/A";
																}*/
															}
															$asquery = $db->prepare("SELECT * FROM assignments ASA INNER JOIN brand BR ON ASA.brid = BR.brid WHERE ASA.supuid = $uid AND ASA.stid = $stid AND BR.brstatus = 0 AND ASA.asstatus = 0 $q5");
															$asquery->execute();
															$num_assignment = $asquery->rowCount();
															if($num_assignment > 0)
															{
																$count++;						
											?>	
											<tr>
												<td align="center" class="title" height="25"><?php echo($count); ?>. </td>
												<td align="left">
												<?php
													$ascount = 0;
													while($asrow = $asquery->fetch())
													{
														$ascount++;
														if($ascount ==1) { $comma = ""; } else{ $comma = ", "; }
														echo($comma.$asrow['brname']);
													}		
												?>
												</td>
												<td align="left"><?php echo(ucwords($store_city)); ?></td>
												<td align="left"><?php echo(ucwords($store_name)); ?></td>
												
												<td align="left"><?php echo($supervisor); ?></td>
												<td align="left"><?php echo($remarks); ?></td>
												<td align="left"><?php echo($last_visit_date); ?></td>
												<!-- <td align="left">Lat: <br>Long: </td>
												<td align="right"></td> -->
												<td align="center"><?php echo($post_date); ?></td>
												<td align="center">
													<?php if($total_days < 4){ echo($total_days); } else{ echo("<span style='color: red; font-weight: bold;'>$total_days</span>"); } ?>
												</td>
											</tr>
											<?php
														}
													}
												}												
											
											}		
											?>
									</tbody>
								</table>
								<div class="box-title">
								<div align="left" class="col-sm-6"><h6><b>Report Name:</b> Store Not Visit Report</h6></div>
								<div align="right" class="col-sm-6"><h6><b>Printed By:</b> <?php echo($UserFullName); ?> <b>On</b> <?php echo(date("F d, Y h:i A")); ?> </h6></div>
							</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</body>

</html>