<?php
	include("includes/functions.php");
	include("includes/session.php");
	include("includes/errors.php");
	chk_login1($db,$URL);
?>
<!doctype html>
<html>

<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
	<!-- Apple devices fullscreen -->
	<meta name="apple-mobile-web-app-capable" content="yes" />
	<!-- Apple devices fullscreen -->
	<meta names="apple-mobile-web-app-status-bar-style" content="black-translucent" />

	<title>Sentient - Score - WH Stock Report</title>

	<!-- Bootstrap -->
	<link rel="stylesheet" href="css/bootstrap.min.css">
	<!-- jQuery UI -->
	<link rel="stylesheet" href="css/plugins/jquery-ui/jquery-ui.min.css">
	<!-- dataTables -->
	<link rel="stylesheet" href="css/plugins/datatable/TableTools.css">
	<!-- chosen -->
	<link rel="stylesheet" href="css/plugins/chosen/chosen.css">
	<!-- Theme CSS -->
	<link rel="stylesheet" href="css/style.css">
	<!-- Color CSS -->
	<link rel="stylesheet" href="css/themes.css">

	<!-- jQuery -->
	<script src="js/jquery.min.js"></script>

	<!-- Nice Scroll -->
	<script src="js/plugins/nicescroll/jquery.nicescroll.min.js"></script>
	<!-- imagesLoaded -->
	<script src="js/plugins/imagesLoaded/jquery.imagesloaded.min.js"></script>
	<!-- jQuery UI -->
	<script src="js/plugins/jquery-ui/jquery-ui.js"></script>
	<!-- slimScroll -->
	<script src="js/plugins/slimscroll/jquery.slimscroll.min.js"></script>
	<!-- Bootstrap -->
	<script src="js/bootstrap.min.js"></script>
	<!-- Bootbox -->
	<script src="js/plugins/bootbox/jquery.bootbox.js"></script>
	<!-- New DataTables -->
	<script src="js/plugins/momentjs/jquery.moment.min.js"></script>
	<script src="js/plugins/momentjs/moment-range.min.js"></script>
	<script src="js/plugins/datatables/jquery.dataTables.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.tableTools.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.colReorder.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.colVis.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.scroller.min.js"></script>

	<!-- Chosen -->
	<script src="js/plugins/chosen/chosen.jquery.min.js"></script>

	<!-- Theme framework -->
	<script src="js/eakroko.min.js"></script>
	<!-- Theme scripts -->
	<script src="js/application.min.js"></script>
	<!-- Just for demonstration -->
	<script src="js/demonstration.min.js"></script>

	<!--[if lte IE 9]>
		<script src="js/plugins/placeholder/jquery.placeholder.min.js"></script>
		<script>
			$(document).ready(function() {
				$('input, textarea').placeholder();
			});
		</script>
	<![endif]-->

	<!-- Favicon -->
	<link rel="shortcut icon" href="img/favicon.png" />
	<!-- Apple devices Homescreen icon -->
	<link rel="apple-touch-icon-precomposed" href="img/apple-touch-icon-precomposed.png" />

</head>

<body>
	<div class="container-fluid nav-hidden" id="content">
		<div id="main">
			<div class="container-fluid">
				
				
				<div class="row">
					<div class="col-sm-12">
						<div class="box">
							
							<div class="box-content">
								<div class="invoice-info">
									
									<div class="invoice-from">
										<br>
										<img src="images/sentient_logo.jpg" width="125">
								
										<address>
											Sentient
											<br>Lahore
											
										</address>
									</div>
									
									<div class="invoice-infos">
										<h1>Score - WH Stock Report</h1>
										<?php
											$atdate = strtotime($_REQUEST['date']);
											$attendance_date = date("d-m-Y",$atdate);
											$q1 = "WHERE UA.attendance_date = '$attendance_date'";

											if($_REQUEST['city'] != 0)
											{
												$stcity = $_REQUEST['city'];
												$q2 = "AND ST.city = '$stcity'";

											}
											else{
												$stcity = "All";
												$q2 = "";
											}	

											if($_REQUEST['brid'] != 0)
											{
												$brid = $_REQUEST['brid'];
												$q3 = "AND ASS.brid = $brid";
												$brquery = $db->prepare("SELECT brid, brname FROM brand WHERE brid=?");
												$brquery->execute(array($brid));
												while($brrow = $brquery->fetch())
												{
													$brand = $brrow['brname'];
												}

											}
											else{
												$brid = 0;
												$q3 = "";
												$brand = "All";
											}

											if($_REQUEST['stcid'] != 0 && $_REQUEST['stcid'] != "")
											{
												$store_chain = $_REQUEST['stcid'];


												/*echo("'".str_replace(",","','",$stcity)."'");
												echo("<br>");
												$temp = array(0,1);
						*/
												$st_store_chain= "'".str_replace(",","','",$store_chain)."'";										
												//$result = "'" . implode ( "', '", $temp ) . "'";

												//echo($result);
												$q4 = "AND ST.chain_store IN ($st_store_chain)";

											}
											else{
												$store_chain = "All";
												$q4 = "";
											}
											// if($_REQUEST['stcid'] != 0)
											// {
											// 	$store_chain = $_REQUEST['stcid'];
											// 	$q4 = "AND ST.chain_store = '$store_chain'";

											// }
											// else{
											// 	$store_chain = "All";
											// 	$q4 = "";
											// }
											if($_REQUEST['supuid'] != 0)
											{
												$supid = $_REQUEST['supuid'];
												$supquery = $db->prepare("SELECT uid, su_no, fullname FROM users WHERE uid=?");
												$supquery->execute(array($supid));
												while($suprow = $supquery->fetch())
												{
													$supervisor = $suprow['fullname'].": SU-".$suprow['su_no'];
												}
												$q5 = "AND ASS.supuid = '$supid'";

											}
											else{
												$supid = 0;
												$supervisor = "All";
												$q5 = "";
											}
										?>
										<table>
											<tr><td>&nbsp;</td></tr>
											<tr><td align="left"><b>Date: <?php echo($attendance_date); ?></b></td></tr>
											<tr><td align="left"><b>City: <?php echo($stcity); ?></b></td></tr>
											<tr><td align="left"><b>Brand: <?php echo($brand); ?></b></td></tr>	
											<tr><td align="left"><b>Supervisor: <?php echo($supervisor); ?></b></td></tr>
											<tr><td align="left"><b>Chain Store: <?php echo($store_chain); ?></b></td></tr>
										</table>
									</div>
								</div>
								<table class="table table-hover table-nomargin table-bordered dataTable" data-nosearch data-nopagination data-noinfo>
									<thead>
										<tr>
											<th>Sr</th>
											<th>Store Name</th>
											<th>Supervisor</th>
											<th>Brand</th>
											<th>BA Name</th>
											<th>City</th>
											<th>Total Stock</th>
											<?php 
												$pquery = $db->prepare("SELECT * FROM products WHERE brid = ? ORDER BY pid ASC");
												$pquery->execute(array($_REQUEST['brid']));
												while($prow = $pquery->fetch())
												{
											?>
											<th><?php if($prow['pname'] == ""){ echo("N/A"); } else{ echo($prow['pname']); } ?></th>
											<?php
												}
											?>
										</tr>
									</thead>
									<tbody>
										<?php
												$count = 0;
												$uaquery = $db->prepare("SELECT * FROM user_attendance UA INNER JOIN users U ON UA.uid = U.uid $q1");
												$uaquery->execute();
												while($uarow = $uaquery->fetch())
												{
													$uid = $uarow['uid'];
													$attendance_date = $uarow['attendance_date'];
													$ba_no = $uarow['ba_no'];
													$fullname = $uarow['fullname'];
													$uatvalue = $uarow['uatvalue'];

													if($uarow['timein'] > 0){ $timein = date("h:i A",$uarow['timein']); } else{ $timein = "None"; }
													if($uarow['timeout'] > 0){ $timeout = date("h:i A",$uarow['timeout']); } else{ $timeout = "None"; }



													$adquery = $db->prepare("SELECT * FROM assignments ASS  
																		INNER JOIN store ST ON ASS.stid = ST.stid 
																	   INNER JOIN brand BR ON ASS.brid = BR.brid WHERE ASS.uid = $uid $q2 $q3 $q4 $q5");
													$adquery->execute();
													if($adquery->rowCount() > 0)
													{
														while($adrow = $adquery->fetch())
														{
															$asid = $adrow['asid'];
															$supuid 	= $adrow['supuid'];
															$store_code = $adrow['store_code'];
															$store_name = $adrow['store_name'];
															$store_city = $adrow['city'];
															$store_open_time = $adrow['open_time'];
															$off_day = $adrow['asoffday'];
															$brand = $adrow['brname'];
														}

														if($supuid != 0)
														{
															$supquery1 = $db->prepare("SELECT uid, su_no, fullname FROM users WHERE uid=?");
															$supquery1->execute(array($supuid));
															while($suprow1 = $supquery1->fetch())
															{
																$store_supervisor = $suprow1['fullname'].": SU-".$suprow1['su_no'];
															}
														}
														else
														{
															$store_supervisor = "<span style='color:red;'>Not Assigned</span>";
														}
														$numsalequery = $db->prepare("SELECT uid, asid, asdid, sale_date, SUM(stock_qty) AS total_stock FROM assignment_sale WHERE uid=? AND asid = ? AND sale_date=?");
														$numsalequery->execute(array($uid,$asid,$attendance_date));
														while($numrow = $numsalequery->fetch())
														{
															$total_stock = $numrow['total_stock'];
														}												
														$count++;
											?>	
											<tr>
												<td align="center" class="title" height="25"><?php echo($count); ?>. </td>
												<td align="left">&nbsp;<?php echo(ucwords($store_name)." :ST-".$store_code); ?></td>
												<td align="left">&nbsp;<?php echo(ucwords($store_supervisor)); ?></td>
												<td align="center"><?php echo(ucwords($brand)); ?></td>
												<td align="left">&nbsp;<?php echo(ucwords($fullname)." :BA-".$ba_no); ?></td>
												<td align="center"><?php echo($store_city); ?></td>
												<td align="center"><?php echo($total_stock); ?></td>

												<?php
													$asaquery = $db->prepare("SELECT * FROM assignment_sale WHERE uid = ? AND sale_date = ? ORDER BY pid ASC");
													$asaquery->execute(array($uid, $attendance_date));
													while($asarow = $asaquery->fetch())
													{
												?>
												<td align="center"><?php echo($asarow['stock_qty']); ?></td>
												<?php
													}
												?>
											</tr>
											<?php
													}	
												}										
												if($count == 0)
												{
											?>	
											<tr>
												<td align="center" colspan="9"><span style="color:red; font-weight:bold;">No Records Found!</span></td>
											</tr>
											<?php
												}
											?>
									</tbody>
								</table>
								<div class="box-title">
								<div align="left" class="col-sm-6"><h6><b>Report Name:</b> Stock Report</h6></div>
								<div align="right" class="col-sm-6"><h6><b>Printed By:</b> <?php echo($UserFullName); ?> <b>On</b> <?php echo(date("F d, Y h:i A")); ?> </h6></div>
							</div>
							</div>


						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</body>

</html>