<?php
	include("includes/functions.php");
	include("includes/session.php");
	include("includes/errors.php");
	chk_login1();
?>
<!doctype html>
<html>

<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
	<!-- Apple devices fullscreen -->
	<meta name="apple-mobile-web-app-capable" content="yes" />
	<!-- Apple devices fullscreen -->
	<meta names="apple-mobile-web-app-status-bar-style" content="black-translucent" />

	<title>Sentient - BA Sales Watch Report</title>

	<!-- Bootstrap -->
	<link rel="stylesheet" href="css/bootstrap.min.css">
	<!-- jQuery UI -->
	<link rel="stylesheet" href="css/plugins/jquery-ui/jquery-ui.min.css">
	<!-- dataTables -->
	<link rel="stylesheet" href="css/plugins/datatable/TableTools.css">
	<!-- chosen -->
	<link rel="stylesheet" href="css/plugins/chosen/chosen.css">
	<!-- Theme CSS -->
	<link rel="stylesheet" href="css/style.css">
	<!-- Color CSS -->
	<link rel="stylesheet" href="css/themes.css">

	<!-- jQuery -->
	<script src="js/jquery.min.js"></script>

	<!-- Nice Scroll -->
	<script src="js/plugins/nicescroll/jquery.nicescroll.min.js"></script>
	<!-- imagesLoaded -->
	<script src="js/plugins/imagesLoaded/jquery.imagesloaded.min.js"></script>
	<!-- jQuery UI -->
	<script src="js/plugins/jquery-ui/jquery-ui.js"></script>
	<!-- slimScroll -->
	<script src="js/plugins/slimscroll/jquery.slimscroll.min.js"></script>
	<!-- Bootstrap -->
	<script src="js/bootstrap.min.js"></script>
	<!-- Bootbox -->
	<script src="js/plugins/bootbox/jquery.bootbox.js"></script>
	<!-- New DataTables -->
	<script src="js/plugins/momentjs/jquery.moment.min.js"></script>
	<script src="js/plugins/momentjs/moment-range.min.js"></script>
	<script src="js/plugins/datatables/jquery.dataTables.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.tableTools.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.colReorder.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.colVis.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.scroller.min.js"></script>

	<!-- Chosen -->
	<script src="js/plugins/chosen/chosen.jquery.min.js"></script>

	<!-- Theme framework -->
	<script src="js/eakroko.min.js"></script>
	<!-- Theme scripts -->
	<script src="js/application.min.js"></script>
	<!-- Just for demonstration -->
	<script src="js/demonstration.min.js"></script>

	<!--[if lte IE 9]>
		<script src="js/plugins/placeholder/jquery.placeholder.min.js"></script>
		<script>
			$(document).ready(function() {
				$('input, textarea').placeholder();
			});
		</script>
	<![endif]-->

	<!-- Favicon -->
	<link rel="shortcut icon" href="img/favicon.png" />
	<!-- Apple devices Homescreen icon -->
	<link rel="apple-touch-icon-precomposed" href="img/apple-touch-icon-precomposed.png" />

</head>

<body>
	<div class="container-fluid nav-hidden" id="content">
		<div id="main">
			<div class="container-fluid">
				
				
				<div class="row">
					<div class="col-sm-12">
						<div class="box">
							
							<div class="box-content">
								<div class="invoice-info">
									
									<div class="invoice-from">
										<br>
										<img src="images/sentient_logo.jpg" width="125">
								
										<address>
											Sentient
											<br>Lahore
											
										</address>
									</div>
									
									<div class="invoice-infos">
										<h1>BA Sales Watch Report</h1>
										<?php
											$uid = $_REQUEST['id'];
											$stid = $_REQUEST['stid'];
											$stcid = $_REQUEST['stcid'];
											$brid = $_REQUEST['brid'];
											$city = $_REQUEST['city'];
											$supuid = $_REQUEST['supuid'];

											$num_sale_days = 26;
											
											$arr = explode('-', $_REQUEST['month']);
											$month = $arr[0];
											$year = $arr[1];

											$current_month = date("m");
											
											if($current_month == $month)
											{
												$first_day_of_month = date("$year-$month-01"); // hard-coded '01' for first day
												$last_day_of_month  = date("$year-$month-d");
												$last_day_this_month  = date("$year-$month-t");
											}
											else
											{
												$first_day_of_month = date("$year-$month-01"); // hard-coded '01' for first day
												$timestamp = strtotime($first_day_of_month);
												$last_day_of_month  = date("$year-$month-t", $timestamp);
											}

											$first_day_timestamp = 	strtotime($first_day_of_month);
											$last_day_timestamp  = strtotime($last_day_of_month) + 86399;

											$number_of_days = date("d",$last_day_timestamp);
											
											$attendance_days = $number_of_days - 4;

											if($_REQUEST['brid'] != 0)
											{
												$brid = $_REQUEST['brid'];
												$q1 = "AND ASS.brid = $brid";
												
												$brquery = $db->prepare("SELECT brid, brname FROM brand WHERE brid=?");
												$brquery->execute(array($brid));
												while($brrow = $brquery->fetch())
												{
													$brand = $brrow['brname'];
												}
											}
											else{
												$brid = 0;
												$q1 = "";
												
												$brand = "All";
											}	

											if($_REQUEST['stcid'] != 0 && $_REQUEST['stcid'] != "")
											{
												$store_chain = $_REQUEST['stcid'];


												/*echo("'".str_replace(",","','",$stcity)."'");
												echo("<br>");
												$temp = array(0,1);
						*/
												$st_store_chain= "'".str_replace(",","','",$store_chain)."'";										
												//$result = "'" . implode ( "', '", $temp ) . "'";

												//echo($result);
												$q2 = "AND ST.chain_store IN ($st_store_chain)";

											}
											else{
												$store_chain = "All";
												$q2 = "";
											}

											if($_REQUEST['stid'] != 0)
											{
												$stid = $_REQUEST['stid'];
												$stquery = $db->prepare("SELECT stid, store_code, store_name, city FROM store WHERE stid=?");
												$stquery->execute(array($stid));
												while($strow = $stquery->fetch())
												{
													$store_name = $strow['store_name'];
												}
												$q3 = "AND ASA.stid = '$stid'";
											}
											else
											{
												$store_name = "All";
												$q3 = "";
											}

											if($_REQUEST['id'] != 0)
											{
												$baquery = $db->prepare("SELECT uid, ba_no, fullname FROM users WHERE uid=?");
												$baquery->execute(array($uid));
												while($barow = $baquery->fetch())
												{
													$ba_name = $barow['fullname'].": BA-".$barow['ba_no'];
												}
												$q4 = "AND ASS.uid = '$uid'";
											}
											else
											{
												$ba_name = "All";
												$q4 = "";
											}

											if($_REQUEST['city'] != 0 && $_REQUEST['city'] != "")
											{
												$stcity = $_REQUEST['city'];
												/*echo("'".str_replace(",","','",$stcity)."'");
												echo("<br>");
												$temp = array(0,1);*/
												//$st_city = "'".str_replace(",","','",$stcity)."'";										
												//$result = "'" . implode ( "', '", $temp ) . "'";
												//echo($result);
												$q5 = "AND ST.city = '$stcity'";
											}
											else{
												$stcity = "All";
												$q5 = "";
											}	

											if($_REQUEST['supuid'] != 0)
											{
												$supid = $_REQUEST['supuid'];
												$supquery = $db->prepare("SELECT uid, su_no, fullname FROM users WHERE uid=?");
												$supquery->execute(array($supid));
												while($suprow = $supquery->fetch())
												{
													$supervisor = $suprow['fullname'].": SU-".$suprow['su_no'];
												}
												$q6 = "AND ASA.supuid = '$supid'";

											}
											else{
												$supid = 0;
												$supervisor = "All";
												$q6 = "";
											}
											

										?>
										<table>
											<tr><td>&nbsp;</td></tr>
											<tr><td align="left"><b>Month: <?php echo(date("F Y",$first_day_timestamp)); ?></b></td></tr>
											<tr><td align="left"><b>Brand: <?php echo($brand); ?></b></td></tr>	
											<tr><td align="left"><b>Store Chain: <?php echo($store_chain); ?></b></td></tr>
											<tr><td align="left"><b>Store: <?php echo($store_name); ?></b></td></tr>
											<tr><td align="left"><b>Supervisor: <?php echo($supervisor); ?></b></td></tr>
											<tr><td align="left"><b>BA: <?php echo($ba_name); ?></b></td></tr>
											<tr><td align="left"><b>City: <?php echo($stcity); ?></b></td></tr>
										</table>
									</div>
								</div>
								
								<table class="table table-hover table-nomargin table-bordered" data-nosearch data-nopagination data-noinfo>
									<thead>
										<tr>
											<th>Sr</th>
											<th>BA Name</th>
											<th>Store Name</th>											
											<th>City</th>
											<th>Supervisor Name</th>
											<th style="background-color: #CBFFA9;">Total Sales</th>
											<th style="background-color: #CBFFA9;">Monthly Target</th>
											<th style="background-color: #CBFFA9;">Monthly Achievement</th>
											<th style="background-color: #CBFFA9;">Target Till Date</th>
											<th style="background-color: #CBFFA9;">MTD Achivement %</th>
											<th style="background-color: #CBFFA9;">Per Day AVG</th>
											<th style="background-color: #CBFFA9;">Remaining Target</th>
											<!-- <th style="background-color: #CBFFA9;">Target Per Day</th>
											<th style="background-color: #CBFFA9;">Daily Achivement %</th> -->
										</tr>
									</thead>		
									<tbody>
										<?php
											$count = 0;
											$query = $db->prepare("SELECT ASS.assid, ASS.uid, ASS.asid, ASS.brid, ASS.pid, ASS.assid, ASS.sale_date, ASS.assid, SUM(sale_qty) AS total_sale, ASS.assdate, ASA.asid, ASA.stid, ASA.asshift, ASA.asoffday, ASA.asstarttime, ASA.asofftime, ASA.storetarget, ASA.supuid, ST.stid, ST.store_name, ST.city, ST.channel, U.uid, U.fullname FROM assignment_sale ASS INNER JOIN assignments ASA ON ASS.asid = ASA.asid INNER JOIN store ST ON ASA.stid = ST.stid INNER JOIN users U ON ASA.uid = U.uid WHERE assdate BETWEEN $first_day_timestamp AND 
																		$last_day_timestamp $q1 $q2 $q3 $q4 $q5 $q6 GROUP BY ASS.asid ORDER BY ASS.assid ASC");
											$query->execute();
											if($query->rowCount() == 0)
											{
										?>
										<tr>
											<td align="center" colspan="22" style="color: red;">No Record Found!</td>
										</tr>
										<?php			
											}
											else
											{
												/// array section

												$array_attendance_days = array();
												$array_working_days = array();
												$array_attendance_age = array();
												$array_total_interception = array();
												$array_total_productive = array();
												$array_interception_age = array();
												$array_target_per_day = array();
												$array_monthly_target = array();
												$array_target_till_date = array();
												$array_total_sales = array();
												$array_daily_achievement = array();
												$array_mtd_achievement = array();
												$array_per_day_avg = array();
												$array_remaining_target = array();

												while($row = $query->fetch())
												{
													$count++;
													$asid = $row['asid'];
													$sup_uid = $row['supuid'];
													$uid = $row['uid'];
													$total_sale = $row['total_sale'];
													$storetarget = $row['storetarget'];	

													$monthly_target = $storetarget * 26;


													if($sup_uid != 0)
													{
														$supquery1 = $db->prepare("SELECT uid, su_no, fullname FROM users WHERE uid=?");
														$supquery1->execute(array($sup_uid));
														while($suprow1 = $supquery1->fetch())
														{
															$supervisor = $suprow1['fullname'].": SU-".$suprow1['su_no'];
														}
													}
													else
													{
														$supervisor = "<span style='color:red;'>Not Assigned</span>";
													}

													/// calculate working days
													$uaquery = $db->prepare("SELECT * FROM user_attendance WHERE uid = $uid AND asid = $asid AND timein > 0 AND uatdate BETWEEN $first_day_timestamp AND $last_day_timestamp");
													$uaquery->execute();
													$num_working_days = $uaquery->rowCount();

													if($num_working_days > 0)
													{
														$avg_attendance = $num_working_days / $attendance_days  * 100;	
													}
													else
													{
														$avg_attendance = 0;
													}

													/// target till date
													$target_till_date = $num_working_days * $storetarget;
													
													/// daily achivement 
													if($total_sale > 0)
													{
														if($num_working_days > 0)
														{
															$daily_sale = $total_sale / $num_working_days;		
														}
														else
														{
															$daily_sale = 0;
														}
													}	
													else{
														$daily_sale = 0;
													}

													if($daily_sale > 0)
													{
														if($storetarget > 0)
														{
															$daily_sale_achivement = $daily_sale / $storetarget  * 100;		
														}
														else
														{
															$daily_sale_achivement = 100;	
														}
													}
													else
													{
														$daily_sale_achivement = 0;
													}

													/// monthly achivement
													if($monthly_target > 0)
													{
														if($total_sale > 0)
														{
															$monthly_sale_achivement = $total_sale / $monthly_target * 100;		
														}
														else
														{
															$monthly_sale_achivement = 0;
														}
													}	
													else{
														if($total_sale > 0)
														{
															$monthly_sale_achivement = 100;		
														}
													}

													

													/// per day avg

													if($num_working_days > 0)
													{
														$avg_sale = $total_sale / $num_working_days;	
													}
													else
													{
														$avg_sale = 0;
													}

													/// remaining target

													$taget_left = $total_sale - $storetarget;


													/// monthly achivement 



													//// calculate usership

													$usdquery = $db->prepare("SELECT uid, SUM(interception) AS total_interception, SUM(productive) AS total_productive, asuddate FROM usership_detail WHERE uid = $uid AND asuddate BETWEEN $first_day_timestamp AND $last_day_timestamp");
													$usdquery->execute();
													while($usdrow = $usdquery->fetch())
													{
														$total_interception = $usdrow['total_interception'];
														$total_productive = $usdrow['total_productive'];
													}

													if($total_interception > 0 && $total_productive > 0)
													{
														$avg_usership = $total_productive / $total_interception  * 100;	
													}
													else
													{
														if($total_productive > 0)
														{
															$avg_usership = 100;	
														}
														else
														{
															$avg_usership = 0;
														}
														
													}

													$remaining_target = $monthly_target - $total_sale;

													//// inset data in array 
													array_push($array_attendance_days, $attendance_days);
													array_push($array_working_days, $num_working_days);
													array_push($array_attendance_age, round($avg_attendance));
													if($total_interception){array_push($array_total_interception, $total_interception);}
													if($total_productive){array_push($array_total_productive, $total_productive);}
													
													array_push($array_interception_age, $avg_usership);
													array_push($array_target_per_day, $storetarget);
													array_push($array_monthly_target, $monthly_target);
													array_push($array_target_till_date, $target_till_date);
													array_push($array_total_sales, $total_sale);
													array_push($array_daily_achievement, round($daily_sale_achivement));
													array_push($array_mtd_achievement, round($monthly_sale_achivement));
													array_push($array_per_day_avg, round($avg_sale));
													array_push($array_remaining_target, $remaining_target);
										?>
											
										<tr>
											<td align="center" class="title" height="25"><?php echo($count); ?></td>
											<td align="left" class="title" height="25"><?php echo($row['fullname']); ?></td>
											<td align="left" class="title" height="25"><?php echo($row['store_name']); ?></td>
											<td align="left" class="title" height="25"><?php echo($row['city']); ?></td>
											<td align="left" class="title" height="25"><?php echo($supervisor); ?></td>
											<td align="center" class="title" height="25"><?php echo($total_sale); ?></td>
											<td align="center" class="title" height="25"><?php echo($monthly_target); ?></td>
											<td align="center" class="title" height="25"><?php echo(round($monthly_sale_achivement)); ?>%</td>
											<td align="center" class="title" height="25"><?php echo($target_till_date); ?></td>
											<td align="center" class="title" height="25"><?php echo(round($daily_sale_achivement)); ?>%</td>
											<td align="center" class="title" height="25"><?php echo(round($avg_sale)); ?></td>
											<td align="center" class="title" height="25"><?php echo($remaining_target); ?></td>

										</tr>
										<?php
												}
											}	

											//  $array_attendance_days = array();
											// 	$array_working_days = array();
											// 	$array_attendance_age = array();
											// 	$array_total_interception = array();
											// 	$array_total_productive = array();
											// 	$array_interception_age = array();
											// 	$array_target_per_day = array();
											// 	$array_monthly_target = array();
											// 	$array_target_till_date = array();
											// 	$array_total_sales = array();
											// 	$array_daily_achievement = array();
											// 	$array_mtd_achievement = array();
											// 	$array_per_day_avg = array();
											// 	$array_remaining_target = array();
										?>
										<tr style="background-color: #eee;">
											<td colspan="5"></td>
											<td align="center"><b><?php print_r(array_sum($array_total_sales)); ?></b></td>
											<td align="center"><b><?php print_r(array_sum($array_monthly_target)); ?></b></td>
											<td align="center"><b><?php print_r(array_sum($array_mtd_achievement)); ?></b></td>
											<td align="center"><b><?php print_r(array_sum($array_target_till_date)); ?></b></td>
											<td align="center"><b><?php print_r(array_sum($array_daily_achievement)); ?>%</b></td>
											<td align="center"><b><?php print_r(array_sum($array_per_day_avg)); ?></b></td>
											<td align="center"><b><?php print_r(array_sum($array_remaining_target)); ?></b></td>
											<!-- <td align="center"><b><?php // print_r(array_sum($array_target_per_day)); ?></b></td> -->
											
											
											
											
											
											
										</tr>
									</tbody>

								</table>
								<div class="box-title">
								<div align="left" class="col-sm-6"><h6><b>Report Name:</b> Sales Analysis Report</h6></div>
								<div align="right" class="col-sm-6"><h6><b>Printed By:</b> <?php echo($UserFullName); ?> <b>On</b> <?php echo(date("F d, Y h:i A")); ?> </h6></div>
							</div>
							</div>


						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</body>

</html>