<?php
	include("includes/functions.php");
	include("includes/session.php");
	include("includes/errors.php");
	chk_login1($db,$URL);
?>
<!doctype html>
<html>

<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
	<!-- Apple devices fullscreen -->
	<meta name="apple-mobile-web-app-capable" content="yes" />
	<!-- Apple devices fullscreen -->
	<meta names="apple-mobile-web-app-status-bar-style" content="black-translucent" />

	<title>Sentient - Price Report</title>

	<!-- Bootstrap -->
	<link rel="stylesheet" href="css/bootstrap.min.css">
	<!-- jQuery UI -->
	<link rel="stylesheet" href="css/plugins/jquery-ui/jquery-ui.min.css">
	<!-- dataTables -->
	<link rel="stylesheet" href="css/plugins/datatable/TableTools.css">
	<!-- chosen -->
	<link rel="stylesheet" href="css/plugins/chosen/chosen.css">
	<!-- Theme CSS -->
	<link rel="stylesheet" href="css/style.css">
	<!-- Color CSS -->
	<link rel="stylesheet" href="css/themes.css">

	<!-- jQuery -->
	<script src="js/jquery.min.js"></script>

	<!-- Nice Scroll -->
	<script src="js/plugins/nicescroll/jquery.nicescroll.min.js"></script>
	<!-- imagesLoaded -->
	<script src="js/plugins/imagesLoaded/jquery.imagesloaded.min.js"></script>
	<!-- jQuery UI -->
	<script src="js/plugins/jquery-ui/jquery-ui.js"></script>
	<!-- slimScroll -->
	<script src="js/plugins/slimscroll/jquery.slimscroll.min.js"></script>
	<!-- Bootstrap -->
	<script src="js/bootstrap.min.js"></script>
	<!-- Bootbox -->
	<script src="js/plugins/bootbox/jquery.bootbox.js"></script>
	<!-- New DataTables -->
	<script src="js/plugins/momentjs/jquery.moment.min.js"></script>
	<script src="js/plugins/momentjs/moment-range.min.js"></script>
	<script src="js/plugins/datatables/jquery.dataTables.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.tableTools.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.colReorder.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.colVis.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.scroller.min.js"></script>

	<!-- Chosen -->
	<script src="js/plugins/chosen/chosen.jquery.min.js"></script>

	<!-- Theme framework -->
	<script src="js/eakroko.min.js"></script>
	<!-- Theme scripts -->
	<script src="js/application.min.js"></script>
	<!-- Just for demonstration -->
	<script src="js/demonstration.min.js"></script>

	<!--[if lte IE 9]>
		<script src="js/plugins/placeholder/jquery.placeholder.min.js"></script>
		<script>
			$(document).ready(function() {
				$('input, textarea').placeholder();
			});
		</script>
	<![endif]-->

	<!-- Favicon -->
	<link rel="shortcut icon" href="img/favicon.png" />
	<!-- Apple devices Homescreen icon -->
	<link rel="apple-touch-icon-precomposed" href="img/apple-touch-icon-precomposed.png" />

</head>

<body>
	<div class="container-fluid nav-hidden" id="content">
		<div id="main">
			<div class="container-fluid">
				
				
				<div class="row">
					<div class="col-sm-12">
						<div class="box">
							
							<div class="box-content">
								<div class="invoice-info">
									
									<div class="invoice-from">
										<br>
										<img src="images/sentient_logo.jpg" width="125">
								
										<address>
											Sentient
											<br>Lahore
											
										</address>
									</div>
									
									<div class="invoice-infos">
										<h1>Price Report</h1>
										<?php
											$atdate = strtotime($_REQUEST['date']);
											$attendance_date = date("d-m-Y",$atdate);
											$q1 = "WHERE ASA.sale_date = '$attendance_date'";


											if($_REQUEST['id'] != 0)
											{
												$id = $_REQUEST['id'];
												$uquery = $db->prepare("SELECT uid, fullname, ba_no FROM users WHERE uid=?");
												$uquery->execute(array($id));
												while($urow = $uquery->fetch())
												{
													$ba_name = $urow['fullname'].": BA-".$urow['ba_no'];
												}
												$q2 = "AND ASA.uid = $id";

											}
											else{
												$id = 0;
												$ba_name = "All";
												$q2 = "";
											}
										?>
										<table>
											<tr><td>&nbsp;</td></tr>
											<tr><td align="left"><b>Date: <?php echo($attendance_date); ?></b></td></tr>
											<tr><td align="left"><b>BA: <?php echo($ba_name); ?></b></td></tr>
										</table>
									</div>
								</div>
								<table class="table table-hover table-nomargin table-bordered dataTable" data-nosearch data-nopagination data-noinfo>
									<thead>
										<tr>
											<th>Sr</th>
											<th>Brand</th>
											<th>Product</th>
											<th>SKU</th>
											<th>Price</th>
										</tr>
									</thead>
									<tbody>
										<?php
												$count = 0;
												$total_target = array();
												$total_sales = array();
												$total_precentage = array();
												$asquery = $db->prepare("SELECT * FROM assignment_sale ASA 
																		INNER JOIN brand BR ON ASA.brid = BR.brid  
																		INNER JOIN products P ON ASA.pid = P.pid
																		INNER JOIN users U ON ASA.uid = U.uid $q1 $q2");
												$asquery->execute();
												while($uarow = $asquery->fetch())
												{
													$count++;
													$uid = $uarow['uid'];
													$ba_no = $uarow['ba_no'];
													$fullname = $uarow['fullname'];
													$brand = $uarow['brname'];
													$pname = $uarow['pname'];
													$sku = $uarow['sku'];
													$sale_price = $uarow['sale_price'];
											?>
											<tr>
												<td align="center" class="title" height="25"><?php echo($count); ?>. </td>
												<td align="center"><?php echo(ucwords($brand)); ?></td>
												<td align="left">&nbsp;<?php echo(ucwords($pname)); ?></td>
												<td align="center"><?php echo(ucwords($sku)); ?></td>
												<td align="right"><?php echo(number_format($sale_price,2)); ?>&nbsp;</td>
											</tr>
											<?php
												}										
												if($count == 0)
												{
											?>
											<tr>
												<td align="center" class="title" height="25"> </td>
												<td align="center"></td>
												<td align="center"><span style="color:red; font-weight:bold;">No Records Found!</span></td>
												<td align="center"></td>
												<td align="right">&nbsp;</td>
											</tr>
											
											<?php
												}
											?>
									</tbody>
								</table>
								<div class="box-title">
								<div align="left" class="col-sm-6"><h6><b>Report Name:</b> Price Report</h6></div>
								<div align="right" class="col-sm-6"><h6><b>Printed By:</b> <?php echo($UserFullName); ?> <b>On</b> <?php echo(date("F d, Y h:i A")); ?> </h6></div>
							</div>
							</div>


						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</body>

</html>