<?php
	include("includes/functions.php");
	include("includes/session.php");
	include("includes/errors.php");
	chk_login1($db,$URL);
?>
<!doctype html>
<html>

<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
	<!-- Apple devices fullscreen -->
	<meta name="apple-mobile-web-app-capable" content="yes" />
	<!-- Apple devices fullscreen -->
	<meta names="apple-mobile-web-app-status-bar-style" content="black-translucent" />

	<title>Sentient - Performance Report</title>

	<!-- Bootstrap -->
	<link rel="stylesheet" href="css/bootstrap.min.css">
	<!-- jQuery UI -->
	<link rel="stylesheet" href="css/plugins/jquery-ui/jquery-ui.min.css">
	<!-- dataTables -->
	<link rel="stylesheet" href="css/plugins/datatable/TableTools.css">
	<!-- chosen -->
	<link rel="stylesheet" href="css/plugins/chosen/chosen.css">
	<!-- Theme CSS -->
	<link rel="stylesheet" href="css/style.css">
	<!-- Color CSS -->
	<link rel="stylesheet" href="css/themes.css">

	<!-- jQuery -->
	<script src="js/jquery.min.js"></script>

	<!-- Nice Scroll -->
	<script src="js/plugins/nicescroll/jquery.nicescroll.min.js"></script>
	<!-- imagesLoaded -->
	<script src="js/plugins/imagesLoaded/jquery.imagesloaded.min.js"></script>
	<!-- jQuery UI -->
	<script src="js/plugins/jquery-ui/jquery-ui.js"></script>
	<!-- slimScroll -->
	<script src="js/plugins/slimscroll/jquery.slimscroll.min.js"></script>
	<!-- Bootstrap -->
	<script src="js/bootstrap.min.js"></script>
	<!-- Bootbox -->
	<script src="js/plugins/bootbox/jquery.bootbox.js"></script>
	<!-- New DataTables -->
	<script src="js/plugins/momentjs/jquery.moment.min.js"></script>
	<script src="js/plugins/momentjs/moment-range.min.js"></script>
	<script src="js/plugins/datatables/jquery.dataTables.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.tableTools.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.colReorder.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.colVis.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.scroller.min.js"></script>

	<!-- Chosen -->
	<script src="js/plugins/chosen/chosen.jquery.min.js"></script>

	<!-- Theme framework -->
	<script src="js/eakroko.min.js"></script>
	<!-- Theme scripts -->
	<script src="js/application.min.js"></script>
	<!-- Just for demonstration -->
	<script src="js/demonstration.min.js"></script>

	<!--[if lte IE 9]>
		<script src="js/plugins/placeholder/jquery.placeholder.min.js"></script>
		<script>
			$(document).ready(function() {
				$('input, textarea').placeholder();
			});
		</script>
	<![endif]-->

	<!-- Favicon -->
	<link rel="shortcut icon" href="img/favicon.png" />
	<!-- Apple devices Homescreen icon -->
	<link rel="apple-touch-icon-precomposed" href="img/apple-touch-icon-precomposed.png" />

</head>

<body>
	<div class="container-fluid nav-hidden" id="content">
		<div id="main">
			<div class="container-fluid">
				
				
				<div class="row">
					<div class="col-sm-12">
						<div class="box">
							
							<div class="box-content">
								<div class="invoice-info">
									
									<div class="invoice-from">
										<br>
										<img src="images/sentient_logo.jpg" width="125">
								
										<address>
											Sentient
											<br>Lahore
											
										</address>
									</div>
									
									<div class="invoice-infos">
										<h1>Performance Report</h1>
										<?php
											$uid = $_REQUEST['id'];
											$from_date_timestamp = strtotime($_REQUEST['fromdate']);
											$to_date_timestamp = strtotime($_REQUEST['todate']);

											$from_date = date("d-m-Y",$from_date_timestamp);
											$to_date = date("d-m-Y",$to_date_timestamp);

											if($_REQUEST['id'] != 0)
											{
												$uid = $_REQUEST['id'];
												$baquery = $db->prepare("SELECT uid, ba_no, fullname FROM users WHERE uid=?");
												$baquery->execute(array($uid));
												while($barow = $baquery->fetch())
												{
													$ba_name = $barow['fullname'].": BA-".$barow['ba_no'];
												}
												$q1 = "AND ASS.uid = '$uid'";

											}
											else
											{
												$ba_name = "";
												$q1 = "";
											}
										?>
										<table>
											<tr><td>&nbsp;</td></tr>
											<tr><td align="left"><b>From Date: <?php echo($from_date); ?></b></td></tr>
											<tr><td align="left"><b>To Date: <?php echo($to_date); ?></b></td></tr>
											<tr><td align="left"><b>BA: <?php echo($ba_name); ?></b></td></tr>	
										</table>
									</div>
								</div>
								<table class="table table-hover table-nomargin table-bordered dataTable" data-nosearch data-nopagination data-noinfo>
									<thead>
										<tr>
											<th>Brand</th>
											<th>City</th>
											<th>Store Name</th>
											<th>Date</th>
											<th>Day</th>
											<th>Late</th>
											<th>Log In</th>
											<th>Log Out</th>
											<th>Total Hrs</th>
											<th>Target</th>
											<th>Sales</th>
											<th>Achievement %</th>
										</tr>
									</thead>
									<tbody>
										<?php
												$total_days = array();
												$total_late_timestamp = array();
												$total_day_timestamp = array();
												$total_day_target = array();
												$total_day_sale = array();
												$total_percentage = array();

												$uat_query = $db->prepare("SELECT * FROM user_attendance WHERE uatdate BETWEEN $from_date_timestamp AND 
																			$to_date_timestamp GROUP BY attendance_date ORDER BY uatid ASC");
												$uat_query->execute();
												while($uatrow = $uat_query->fetch())
												{
													$attendance_date = $uatrow['attendance_date'];
													$attendance_day = date("D", strtotime($uatrow['attendance_date']));
													
													$query = $db->prepare("SELECT * FROM user_attendance UAT 
																INNER JOIN assignments ASS ON UAT.asid = ASS.asid 
																INNER JOIN brand BR ON ASS.brid = BR.brid 
																INNER JOIN store ST ON ASS.stid = ST.stid 
																WHERE UAT.uid = ? AND UAT.attendance_date = ?");
													$query->execute(array($uid,$attendance_date));
													if($query->rowCount() == 0)
													{
											?>	
											<tr>
												<td align="center">N/A</td>
												<td align="center">N/A</td>
												<td align="left">&nbsp;N/A</td>
												<td align="center"><?php echo($attendance_date); ?></td>
												<td align="center"><?php echo($attendance_day); ?></td>
												<td align="center">0:00</td>
												<td align="center">0:00</td>
												<td align="center">0:00</td>
												<td align="center">0:00</td>
												<td align="center">0</td>
												<td align="center">0</td>
												<td align="center">0%</td>
											</tr>
											<?php
													}
													else
													{
														while($row = $query->fetch())
														{
															$uatid = $row['uatid'];
															$asid = $row['asid'];
															$attendance_date = $row['attendance_date'];
															
															if($row['timein'] != 0){ $timein = date("h:i A",$row['timein']); } else{ $timein = "N/A"; }
															if($row['timeout'] != 0){ $timeout = date("h:i A",$row['timeout']); } else{ $timeout = "N/A"; }
															
															$attendance_day = date("D", strtotime($row['attendance_date']));	
															$storetarget = $row['storetarget'];
															$store_code = $row['store_code'];
															$store_name = $row['store_name'];
															$store_city = $row['city'];
															$brand = $row['brname'];

															$asstarttime = $row['store_starttime'];

															$stropenhr1 =  $attendance_date." ".$asstarttime;
															$store_open_timestamp = strtotime($stropenhr1);

															array_push($total_days, 1);

															/// ba time difference check for after store opening time
															$time_difference = $row['timein'] - $store_open_timestamp;
															if ($time_difference > 0) {

																array_push($total_late_timestamp, $time_difference);

																$seconds1 = $time_difference;
																$days1 = floor($seconds1 / 86400);
											                    $seconds1 %= 86400;

											                    $hours1 = floor($seconds1 / 3600);
											                    $seconds1 %= 3600;

											                    $minutes1 = floor($seconds1 / 60);
											                    $seconds1 %= 60;
											                      
											                    $total_late_hrs ="<span style='color:red;'>".str_pad($hours1, 2, "0", STR_PAD_LEFT).":".str_pad($minutes1, 2, "0", STR_PAD_LEFT)."</span>";

											              	}
															else
															{
																$total_late_hrs ="";
																array_push($total_late_timestamp, 0);
															}


															/// ba total hrs of the day
															if($row['timein'] != 0 && $row['timeout'] != 0)
															{
																$total_hrs_time_difference = $row['timeout'] - $row['timein'];	
															}
															else
															{
																$total_hrs_time_difference = 0;	
															}

															if ($total_hrs_time_difference > 0) {

																array_push($total_day_timestamp, $total_hrs_time_difference);

																$seconds2 = $total_hrs_time_difference;
																$days2 = floor($seconds2 / 86400);
											                    $seconds2 %= 86400;

											                    $hours2 = floor($seconds2 / 3600);
											                    $seconds2 %= 3600;

											                    $minutes2 = floor($seconds2 / 60);
											                    $seconds2 %= 60;
											                      
											                    $total_hrs ="".str_pad($hours2, 2, "0", STR_PAD_LEFT).":".str_pad($minutes2, 2, "0", STR_PAD_LEFT)."";
															}
															else
															{
																array_push($total_day_timestamp, 0);
																$total_hrs ="";
															}


															////////// Sales Target and Achievement ////////

															$asquery = $db->prepare("SELECT SUM(sale_qty) AS total_sale_qty, SUM(sale_target) AS total_sale_target FROM assignment_sale WHERE uid = ? AND asid = ? AND sale_date = ?");
															$asquery->execute(array($uid,$asid,$attendance_date));
															while($asrow = $asquery->fetch())
															{
																$total_sale_qty = $asrow['total_sale_qty'];
																$total_sale_target = $asrow['total_sale_target'];
															}
															array_push($total_day_target, $storetarget);
															array_push($total_day_sale, $total_sale_qty);
															
															if($total_sale_qty == 0 && $total_sale_target == 0)
															{
																$sale_percentage =  0;
															}
															else
															{
																if($total_sale_qty == 0) { $sale_percentage = 0; }
																if($total_sale_target == 0)
																{
																	$sale_percentage = 0; 
																	array_push($total_percentage, $sale_percentage); 
																}
															}

															if($total_sale_qty != 0 && $storetarget != 0)
															{
																$sale_percentage = $total_sale_qty / $storetarget * 100;
																array_push($total_percentage, $sale_percentage);
															}
											?>	
											<tr>
												<td align="center"><?php echo(ucwords($brand)." - ".$uatid); ?></td>
												<td align="center"><?php echo($store_city); ?></td>
												<td align="left">&nbsp;<?php echo(ucwords($store_name)." :ST-".$store_code); ?></td>
												<td align="center"><?php echo($attendance_date); ?></td>
												<td align="center"><?php echo($attendance_day); ?></td>
												<td align="center"><?php echo($total_late_hrs); ?></td>
												<td align="center"><?php echo($timein); ?></td>
												<td align="center"><?php echo($timeout); ?></td>
												<td align="center"><?php echo($total_hrs); ?></td>
												<td align="center"><?php echo($storetarget); ?></td>
												<td align="center"><?php echo($total_sale_qty); ?></td>
												<td align="center"><?php echo(number_format($sale_percentage,2)); ?>%</td>
											</tr>
											<?php
														}
													}	
												}	
											?>
									</tbody>
									<tbody>
										<tr style="background-color: #eee;">
												<td align="left" colspan="4" height="35">&nbsp; <b>Summary</b></td>
												
												<td align="center"><b><?php print_r(array_sum($total_days)); ?></b></td>
												<td align="center">
												<?php
													if(array_sum($total_day_sale) > 0 && array_sum($total_day_target) > 0)
													{
														$total_sale_percentage = array_sum($total_day_sale) / array_sum($total_day_target)  * 100;	
													}

														

													$seconds3 = array_sum($total_late_timestamp);
													$days3 = floor($seconds3 / 86400);
								                    $seconds3 %= 86400;

								                    $hours3 = floor($seconds3 / 3600);
								                    $seconds3 %= 3600;

								                    $minutes3 = floor($seconds3 / 60);
								                    $seconds3 %= 60;
								                      
								                    $total_late_hours ="".str_pad($hours3, 2, "0", STR_PAD_LEFT).":".str_pad($minutes3, 2, "0", STR_PAD_LEFT)."";
												?>
													<b><?php echo($total_late_hours); ?></b>
												</td>
												<td align="center"></td>
												<td align="center"></td>
												<td align="center">
													<?php
														$seconds4 = array_sum($total_day_timestamp);
														$days4 = floor($seconds4 / 86400);
									                    $seconds4 %= 86400;

									                    $hours4 = floor($seconds4 / 3600);
									                    $seconds4 %= 3600;

									                    $minutes4 = floor($seconds4 / 60);
									                    $seconds4 %= 60;
									                      
									                    $total_day_hours ="".str_pad($hours4, 2, "0", STR_PAD_LEFT).":".str_pad($minutes4, 2, "0", STR_PAD_LEFT)."";
													?>
													<b><?php echo($total_day_hours); ?></b>
												</td>
												<td align="center"><b><?php print_r(array_sum($total_day_target)); ?></b></td>
												<td align="center"><b><?php print_r(array_sum($total_day_sale)); ?></b></td>
												<td align="center"><b><?php if(array_sum($total_day_target) == 0){ echo("100"); } else{ echo(number_format($total_sale_percentage,2)); } ?>%</b></td>
											</tr>
									</tbody>
									<tbody>
										<tr style="background-color: #eee;">
												<td align="left" colspan="4" height="35">&nbsp; <b>Average</b></td>
												
												<td align="center"></td>
												<td align="center">
												<b>	
												<?php
													$sum_total_late_percentage = array_sum($total_late_timestamp);
													if($sum_total_late_percentage > 0)
													{
														$average = array_sum($total_late_timestamp) / count($total_late_timestamp);
														$average_late_timestamp = round($average);
													}
													else
													{
														$average_late_timestamp = 0;
													}
													//echo($average_late_timestamp."<br>");die;
													if($average_late_timestamp > 0)
													{
														//echo(round($average_late_timestamp));die;
														$seconds_late = $average_late_timestamp;
														$days_late = floor($seconds_late / 86400);
									                    $seconds_late %= 86400;

									                    $hours_late = floor($seconds_late / 3600);
									                    $seconds_late %= 3600;

									                    $minutes_late = floor($seconds_late / 60);
									                    $seconds_late %= 60;
									                      
									                    $average_late_hours ="".str_pad($hours_late, 2, "0", STR_PAD_LEFT).":".str_pad($minutes_late, 2, "0", STR_PAD_LEFT)."";
									                    echo($average_late_hours);
													}
													else{
														echo("0:00");
													}
												?>
												</b>
												</td>
												<td align="center"></td>
												<td align="center"></td>
												<td align="center">
													<b>
													<?php
														$sum_total_hrs_percentage = array_sum($total_day_timestamp);
														if($sum_total_hrs_percentage > 0)
														{
															$average_hrs = array_sum($total_day_timestamp) / count($total_day_timestamp);
															$average_hrs_timestamp = round($average_hrs);
			 												
														}
														else
														{
															$average_hrs_timestamp = 0;
														}
														if($average_hrs_timestamp > 0)
														{
															$seconds_hrs = $average_hrs_timestamp;
															$days_hrs = floor($seconds_hrs / 86400);
										                    $seconds_hrs %= 86400;

										                    $hours_hrs = floor($seconds_hrs / 3600);
										                    $seconds_hrs %= 3600;

										                    $minutes_hrs = floor($seconds_hrs / 60);
										                    $seconds_hrs %= 60;
										                      
										                    $average_hrs_hours ="".str_pad($hours_hrs, 2, "0", STR_PAD_LEFT).":".str_pad($minutes_hrs, 2, "0", STR_PAD_LEFT)."";
										                    echo($average_hrs_hours);
														}
														else{
															echo("0:00");
														}
													?>	
													</b>
												</td>
												
												<td align="center"></td>
												<td align="center">
													<?php
														$sum_total_day_sale_percentage = array_sum($total_day_sale);
														if($sum_total_day_sale_percentage > 0)
														{
															$average = array_sum($total_day_sale) / count($total_day_sale);
															$average_day_sale = round($average);
														}
														else
														{
															$average_day_sale = 0;
														}
													?>
													<b><?php echo($average_day_sale); ?></b>
												</td>
												<td align="center">
													<?php
														$sum_total_sale_percentage = array_sum($total_percentage);
														if($sum_total_sale_percentage > 0)
														{
															$average = array_sum($total_percentage) / count($total_percentage);
															$average_sale_percentage = round($average);
														}
														else
														{
															$average_sale_percentage = 0;
														}
													?>
													<b><?php echo(round($average_sale_percentage)); ?>%</b>
												</td>
											</tr>
									</tbody>
									<!-- 
									<tbody>
										<tr>
											<td colspan="12">&nbsp;</td>
										</tr>
									</tbody>
									<tbody>
										<tr align="left" style="background-color: lightblue;">
											<td colspan="9">&nbsp;<b>If performance remains the same, End of the month Sales will be:</b></td>
											<td align="center"><b>22:50</b></td>
											<td align="center"><b>22:50</b></td>
											<td align="center"><b>75%</b></td>
										</tr>
										<tr align="left" style="background-color: lightblue;">
											<td colspan="9">&nbsp;<b>If Target is to be met, Daily Sales for remaining days of the month must be:</b></td>
											<td align="center"><b>22:50</b></td>
											<td align="center"><b>22:50</b></td>
											<td align="center"><b>75%</b></td>
										</tr>
									</tbody>
									<tbody>
										<tr>
											<td colspan="12">&nbsp;</td>
										</tr>
									</tbody>
									<tbody>
										<tr align="left" style="background-color: lightsteelblue;">
											<td colspan="9">&nbsp;<b>Last Month:</b></td>
											<td align="center"><b>22:50</b></td>
											<td align="center"><b>22:50</b></td>
											<td align="center"><b>75%</b></td>
										</tr>
										<tr align="left" style="background-color: lightsteelblue;">
											<td colspan="9">&nbsp;<b>Average Last 3 Month:</b></td>
											<td align="center"><b>22:50</b></td>
											<td align="center"><b>22:50</b></td>
											<td align="center"><b>75%</b></td>
										</tr>
										<tr align="left" style="background-color: lightblue;">
											<td colspan="9">&nbsp;<b>If performance remains the same, End of the month Sales will be:</b></td>
											<td align="center"><b>22:50</b></td>
											<td align="center"><b>22:50</b></td>
											<td align="center"><b>75%</b></td>
										</tr>
									</tbody> -->

								</table>
								<div class="box-title">
								<div align="left" class="col-sm-6"><h6><b>Report Name:</b> Performance Report</h6></div>
								<div align="right" class="col-sm-6"><h6><b>Printed By:</b> <?php echo($UserFullName); ?> <b>On</b> <?php echo(date("F d, Y h:i A")); ?> </h6></div>
							</div>
							</div>


						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</body>

</html>