<?php
	include("includes/functions.php");
	include("includes/session.php");
	include("includes/errors.php");
	chk_login1($db,$URL);


	// echo(date("d-m-Y H:i A", 1759690800));

	// echo("<br>");

	// echo(date("d-m-Y H:i A", 1759749366));
	// echo("<br>");
	/**
   * Calculates the great-circle distance between two points, with
   * the Haversine formula.
   * @param float $latitudeFrom Latitude of start point in [deg decimal]
   * @param float $longitudeFrom Longitude of start point in [deg decimal]
   * @param float $latitudeTo Latitude of target point in [deg decimal]
   * @param float $longitudeTo Longitude of target point in [deg decimal]
   * @param float $earthRadius Mean earth radius in [m]
   * @return float Distance between points in [m] (same as earthRadius)
   */
  	function haversineGreatCircleDistance($latitudeFrom, $longitudeFrom, $latitudeTo, $longitudeTo, $earthRadius = 6371000)
  	{
    	// convert from degrees to radians
    	$latFrom = deg2rad($latitudeFrom);
    	$lonFrom = deg2rad($longitudeFrom);
    	$latTo = deg2rad($latitudeTo);
    	$lonTo = deg2rad($longitudeTo);

    	$latDelta = $latTo - $latFrom;
    	$lonDelta = $lonTo - $lonFrom;

    	$angle = 2 * asin(sqrt(pow(sin($latDelta / 2), 2) +
    	  cos($latFrom) * cos($latTo) * pow(sin($lonDelta / 2), 2)));
    	return $angle * $earthRadius;
  	}
?>
<!doctype html>
<html>

<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
	<!-- Apple devices fullscreen -->
	<meta name="apple-mobile-web-app-capable" content="yes" />
	<!-- Apple devices fullscreen -->
	<meta names="apple-mobile-web-app-status-bar-style" content="black-translucent" />

	<title>Sentient - Supervisor Visit - Photograph (Internal)</title>

	<!-- Bootstrap -->
	<link rel="stylesheet" href="css/bootstrap.min.css">
	<!-- jQuery UI -->
	<link rel="stylesheet" href="css/plugins/jquery-ui/jquery-ui.min.css">
	<!-- dataTables -->
	<link rel="stylesheet" href="css/plugins/datatable/TableTools.css">
	<!-- chosen -->
	<link rel="stylesheet" href="css/plugins/chosen/chosen.css">
	<!-- Theme CSS -->
	<link rel="stylesheet" href="css/style.css">
	<!-- Color CSS -->
	<link rel="stylesheet" href="css/themes.css">

	<!-- jQuery -->
	<script src="js/jquery.min.js"></script>

	<!-- Nice Scroll -->
	<script src="js/plugins/nicescroll/jquery.nicescroll.min.js"></script>
	<!-- imagesLoaded -->
	<script src="js/plugins/imagesLoaded/jquery.imagesloaded.min.js"></script>
	<!-- jQuery UI -->
	<script src="js/plugins/jquery-ui/jquery-ui.js"></script>
	<!-- slimScroll -->
	<script src="js/plugins/slimscroll/jquery.slimscroll.min.js"></script>
	<!-- Bootstrap -->
	<script src="js/bootstrap.min.js"></script>
	<!-- Bootbox -->
	<script src="js/plugins/bootbox/jquery.bootbox.js"></script>
	<!-- New DataTables -->
	<script src="js/plugins/momentjs/jquery.moment.min.js"></script>
	<script src="js/plugins/momentjs/moment-range.min.js"></script>
	<script src="js/plugins/datatables/jquery.dataTables.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.tableTools.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.colReorder.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.colVis.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.scroller.min.js"></script>

	<!-- Chosen -->
	<script src="js/plugins/chosen/chosen.jquery.min.js"></script>

	<!-- Theme framework -->
	<script src="js/eakroko.min.js"></script>
	<!-- Theme scripts -->
	<script src="js/application.min.js"></script>
	<!-- Just for demonstration -->
	<script src="js/demonstration.min.js"></script>

	<!--[if lte IE 9]>
		<script src="js/plugins/placeholder/jquery.placeholder.min.js"></script>
		<script>
			$(document).ready(function() {
				$('input, textarea').placeholder();
			});
		</script>
	<![endif]-->

	<!-- Favicon -->
	<link rel="shortcut icon" href="img/favicon.png" />
	<!-- Apple devices Homescreen icon -->
	<link rel="apple-touch-icon-precomposed" href="img/apple-touch-icon-precomposed.png" />
	<style>
	.img_container {
	  position: relative;
	}

	.img_bottomright {
	  position: absolute;
	  bottom: 0px;
	  right: 0px;
	  font-size: 16px;
	  color: white;
	  padding: 5px;
	}

	.img_topleft {
	  position: absolute;
	  top: 0;
	  left: 0;
	  font-size: 110px;
	  font-weight: bold;
	  color: balck;
	  padding: 5px;
	}

	img { 
	  width: 70%;
	  height: auto;
	}
	</style>
</head>

<body>
	<div class="container-fluid nav-hidden" id="content">
		<div id="main">
			<div class="container-fluid">
				
				
				<div class="row">
					<div class="col-sm-12">
						<div class="box">
							
							<div class="box-content">
								<div class="invoice-info">
									
									<div class="invoice-from">
										<br>
										<img src="images/sentient_logo.jpg" style="width: 125px;">
								
										<address>
											Sentient
											<br>Lahore
											
										</address>
									</div>
									
									<div class="invoice-infos">
										<h1>Supervisor Visit <br> Photograph (Internal)</h1>
										<?php
											$uid = $_REQUEST['id'];
											$stid = $_REQUEST['stid'];
											
											$from_date_timestamp = strtotime($_REQUEST['fromdate']);
											$to_date_timestamp = strtotime($_REQUEST['todate']) + 86399;

											$from_date = date("d-m-Y",$from_date_timestamp);
											$to_date = date("d-m-Y",$to_date_timestamp);

											if($_REQUEST['id'] != 0)
											{
												$uid = $_REQUEST['id'];
												$suquery = $db->prepare("SELECT uid, su_no, fullname FROM users WHERE uid=?");
												$suquery->execute(array($uid));
												while($surow = $suquery->fetch())
												{
													$su_name = $surow['fullname'].": SU-".$surow['su_no'];
												}
												$q1 = "AND VS.uid = '$uid'";

											}
											else
											{
												$su_name = "All";
												$q1 = "";
											}

											if($_REQUEST['stid'] != 0)
											{
												$stid = $_REQUEST['stid'];
												$stquery = $db->prepare("SELECT stid, store_code, store_name, city FROM store WHERE stid=?");
												$stquery->execute(array($stid));
												while($strow = $stquery->fetch())
												{
													$store_name = $strow['store_name'].", ".$strow['city'].": ST-".$strow['store_code'];
												}
												$q2 = "AND VS.stid = '$stid'";
											}
											else
											{
												$store_name = "All";
												$q2 = "";
											}

											if($_REQUEST['city'] != 0 && $_REQUEST['city'] != "")
											{
												$stcity = $_REQUEST['city'];


												/*echo("'".str_replace(",","','",$stcity)."'");
												echo("<br>");
												$temp = array(0,1);
												*/
												//$st_city = "'".str_replace(",","','",$stcity)."'";										
												//$result = "'" . implode ( "', '", $temp ) . "'";

												//echo($result);
												$q3 = "AND ST.city = '$stcity'";
											}
											else{
												$stcity = "All";
												$q3 = "";
											}

											if($_REQUEST['stcid'] != 0 && $_REQUEST['stcid'] != "")
											{
												$store_chain = $_REQUEST['stcid'];

												/*echo("'".str_replace(",","','",$stcity)."'");
												echo("<br>");
												$temp = array(0,1);
												*/
												$st_store_chain= "'".str_replace(",","','",$store_chain)."'";										
												//$result = "'" . implode ( "', '", $temp ) . "'";
												//echo($result);
												$q4 = "AND ST.chain_store IN ($st_store_chain)";
											}
											else{
												$store_chain = "All";
												$q4 = "";
											}

											if($_REQUEST['brid'] != 0)
											{
												$brid = $_REQUEST['brid'];
												$brquery = $db->prepare("SELECT brid, brname FROM brand WHERE brid=?");
												$brquery->execute(array($brid));
												while($brrow = $brquery->fetch())
												{
													$brand_name = $brrow['brname'];
												}
												$q5 = "AND VS.brid = '$brid'";
											}
											else
											{
												$brand_name = "All";
												$q5 = "";
											}
											$q6 = "AND VS.uid NOT IN (489, 179, 222, 1288, 1205, 1289, 159, 124, 1311, 1290, 943, 1025, 413, 415)";
								
											$distance_value = $_REQUEST['distance'];
											if($_REQUEST['distance_type'] == 0) { $distance_type = "All"; }
											if($_REQUEST['distance_type'] == 1) { $distance_type = "Greater Than $distance_value Meters"; }
											if($_REQUEST['distance_type'] == 2) { $distance_type = "Less Than $distance_value Meters"; }
										?>
										<table>
											<tr><td>&nbsp;</td></tr>
											<tr><td align="left"><b>From Date: <?php echo($from_date); ?></b></td></tr>
											<tr><td align="left"><b>To Date: <?php echo($to_date); ?></b></td></tr>
											<tr><td align="left"><b>Brand: <?php echo($brand_name); ?></b></td></tr>
											<tr><td align="left"><b>City: <?php echo($stcity); ?></b></td></tr>
											<tr><td align="left"><b>Supervisor: <?php echo($su_name); ?></b></td></tr>
											<tr><td align="left"><b>Store Chain: <?php echo($store_chain); ?></b></td></tr>
											<tr><td align="left"><b>Store: <?php echo($store_name); ?></b></td></tr>
											<tr><td align="left"><b>Distance: <?php echo($distance_type); ?></b></td></tr>
										</table>
									</div>
								</div>


								<div class="row">
									<div class="col-sm-12">
										<div class="box">
											<div class="box-title">
												<h3>
													<i class="fa fa-table"></i>
													Stores Not Visited
												</h3>
											</div>
											<div class="box-content nopadding">
												<?php
													$at_date = date("d-m-Y");
													$at_time_from = strtotime($at_date);
													$at_time_to = $at_time_from + 86399;
													
													
													$ncount = 0;
													$nvsquery = $db->prepare("SELECT * FROM visits VS 
																	INNER JOIN store ST ON VS.stid = ST.stid 
																	INNER JOIN cities CT ON ST.city = CT.city_name 
																   INNER JOIN brand BR ON VS.brid = BR.brid 
																   WHERE VS.post_date = 0 $q1 $q2 $q3 $q4 $q5 AND VS.vdate BETWEEN $from_date_timestamp AND $to_date_timestamp ORDER BY ST.store_name ASC");
													//$vsvalues = array($_REQUEST['id'], 0);
													$nvsquery->execute();
													if($nvsquery->rowCount() > 0)
													{
												?>
												<table class="table table-hover table-nomargin table-bordered dataTable" data-nosearch data-nopagination data-noinfo>
													<thead>
													<tr>
														<th class='hidden-1024'>Sr.</th>
														<th>Store</th>
														<th>Brand</th>
														<th>BA</th>
														<th>Supervisor</th>
														<th>Attendance Remarks</th>
														<th>Last Visited</th>
														<th>Days Ago</th>
													</tr>
													</thead>
													<tbody>
													<?php
														while($nvsrow = $nvsquery->fetch())
														{
															$ncount++;
															$vid = $nvsrow['vid'];
															$stid = $nvsrow['stid'];
															$brid = $nvsrow['brid'];
															
															$ba_uid = $nvsrow['ba_uid'];
															$sup_uid = $nvsrow['sup_uid'];
															$att_date = date("d-m-Y",$nvsrow['vdate']);

															if($ba_uid != 0 && $sup_uid != 0)
															{
																$baquery = $db->prepare("SELECT * FROM users WHERE uid=?");
																$baquery->execute(array($ba_uid));
																while($barow = $baquery->fetch())
																{
																	$ba_name = $barow['fullname'];
																}

																$suquery = $db->prepare("SELECT * FROM users WHERE uid=?");
																$suquery->execute(array($sup_uid));
																while($surow = $suquery->fetch())
																{
																	$sup_name = $surow['fullname'];
																}
															}
															else
															{
																$ba_name = "N/A";
																$sup_name = "N/A";
															}

															/// BA Remarks
															$uaquery = $db->prepare("SELECT * FROM user_attendance WHERE uid  = ? ORDER BY uatid DESC LIMIT 0,1");
															$uaquery->execute(array($ba_uid));
															while($uarow = $uaquery->fetch())
															{
																$attendance_date = $uarow['attendance_date'];
																$timein = $uarow['timein'];
																$uatremarks = $uarow['uatremarks'];
																
																if($uatremarks != "")
																{
																	$ba_remarks = $uatremarks;
																}
																else
																{
																	if($timein != 0)
																	{
																		$ba_remarks = "Present";
																	}
																	else
																	{
																		$ba_remarks = "N/A";
																	}
																}
															}

															/// Last Visit

															$vsquery = $db->prepare("SELECT * FROM visits WHERE vid < ? AND stid = ? AND brid = ? AND post_date <> ? ORDER BY vid DESC LIMIT 0,1");
															$vsquery->execute(array($vid, $stid, $brid,0));
															if($vsquery->rowCount() == 0)
															{
																$last_visit = "N/A";
																$total_days = "0";
																$weekday = "N/A";
															}
															else
															{
																while($vsrow = $vsquery->fetch())
																{
																	$post_date = $vsrow['post_date'];
																}
																$last_visit = date("d-m-Y H:i A",$post_date);
																$weekday = date("l",$post_date);
																
																$total_hrs_time_difference = time() - $post_date;	

																if ($total_hrs_time_difference > 0) {

																	$seconds2 = $total_hrs_time_difference;
																	$days2 = floor($seconds2 / 86400);
												                    $seconds2 %= 86400;

												                    $hours2 = floor($seconds2 / 3600);
												                    $seconds2 %= 3600;

												                    $minutes2 = floor($seconds2 / 60);
												                    $seconds2 %= 60;
												                    
												                    if($days2 > 0)
												                    {
												                    	$total_days = $days2;	
												                    } 
												                    else
												                    {
												                    	$total_days = 0;
																	}   
																}
																else
																{
																	$days2 = 0;
																	$post_time = 0;
																	$total_days = "";
																}
															}
													?>	
													<tr>
														<td class='hidden-1024'><?php echo($ncount); ?></td>
														<td><?php echo($nvsrow['store_name']); ?></td>
														<td><?php echo($nvsrow['brname']); ?></td>
														<td><?php echo($ba_name); ?></td>
														<td><?php echo($sup_name); ?></td>
														<td><?php echo($ba_remarks); ?> <small><?php echo($att_date); ?></small></td>
														<td><?php echo($last_visit); ?></td>
														<td class='hidden-1024'><?php echo($total_days); ?></td>
													</tr>
													<?php
														}	
													?>
													</tbody>
												</table>
												<?php
													}
												?>
											</div>
										</div>
									</div>
								</div>
																
								
								<div class="box-title">
								<div align="left" class="col-sm-6"><h6><b>Report Name:</b> Supervisor Not Visit Report</h6></div>
								<div align="right" class="col-sm-6"><h6><b>Printed By:</b> <?php echo($UserFullName); ?> <b>On</b> <?php echo(date("F d, Y h:i A")); ?> </h6></div>
							</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</body>

</html>