<?php
	include("includes/functions.php");
	include("includes/session.php");
	include("includes/errors.php");
	chk_login();
?>
<!doctype html>
<html>

<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
	<!-- Apple devices fullscreen -->
	<meta name="apple-mobile-web-app-capable" content="yes" />
	<!-- Apple devices fullscreen -->
	<meta names="apple-mobile-web-app-status-bar-style" content="black-translucent" />

	<title>Sentient - Print Ledger</title>

	<!-- Bootstrap -->
	<link rel="stylesheet" href="css/bootstrap.min.css">
	<!-- jQuery UI -->
	<link rel="stylesheet" href="css/plugins/jquery-ui/jquery-ui.min.css">
	<!-- Theme CSS -->
	<link rel="stylesheet" href="css/style.css">
	<!-- Color CSS -->
	<link rel="stylesheet" href="css/themes.css">

	<!-- Ajax -->
	<script src="ajax/ajaxfunctions1.js"></script>


	<!-- jQuery -->
	<script src="js/jquery.min.js"></script>

	<!-- Nice Scroll -->
	<script src="js/plugins/nicescroll/jquery.nicescroll.min.js"></script>
	<!-- imagesLoaded -->
	<script src="js/plugins/imagesLoaded/jquery.imagesloaded.min.js"></script>
	<!-- jQuery UI -->
	<script src="js/plugins/jquery-ui/jquery-ui.js"></script>
	<!-- slimScroll -->
	<script src="js/plugins/slimscroll/jquery.slimscroll.min.js"></script>
	<!-- Bootstrap -->
	<script src="js/bootstrap.min.js"></script>
	<!-- Bootbox -->
	<script src="js/plugins/bootbox/jquery.bootbox.js"></script>
	<!-- Bootbox -->
	<script src="js/plugins/form/jquery.form.min.js"></script>
	<!-- Datepicker -->
	<script src="js/plugins/datepicker/bootstrap-datepicker.js"></script>
	<!-- Validation -->
	<script src="js/plugins/validation/jquery.validate.min.js"></script>
	<script src="js/plugins/validation/additional-methods.min.js"></script>

	<!-- Theme framework -->
	<script src="js/eakroko.min.js"></script>
	<!-- Theme scripts -->
	<script src="js/application.min.js"></script>
	<!-- Just for demonstration -->
	<script src="js/demonstration.min.js"></script>
	<script type="text/javascript" src="datepickercontrol.js"></script>
	<script language="JavaScript">
		if (navigator.platform.toString().toLowerCase().indexOf("linux") != -1)
		{ document.write('<link type="text/css" rel="stylesheet" href="datepickercontrol_lnx.css">'); }
		else
		{ document.write('<link type="text/css" rel="stylesheet" href="datepickercontrol.css">'); }
	</script>
	<link type="text/css" rel="stylesheet" href="content.css">
	<!-- Datepicker -->
	<link rel="stylesheet" href="css/plugins/datepicker/datepicker.css">
	<!--[if lte IE 9]>
		<script src="js/plugins/placeholder/jquery.placeholder.min.js"></script>
		<script>
			$(document).ready(function() {
				$('input, textarea').placeholder();
			});
		</script>
	<![endif]-->

	<!-- Favicon -->
	<link rel="shortcut icon" href="../img/favicon.png" />
	<!-- Apple devices Homescreen icon -->
	<link rel="apple-touch-icon-precomposed" href="img/apple-touch-icon-precomposed.png" />
</head>

<body class='theme-grey'>
<!-- HEADER START -->
<form name="Form" method="post">	
	<!-- HEADER END -->
	<div class="container-fluid" id="content">
		<table align="center" style="font-family: arial;" width="950" cellspacing="0" cellpadding="0">
			<tr><td>&nbsp;</td></tr>
			<tr>
				<td width="650" align="left" valign="top">
					<img src="images/dazzle_logo.jpg" width="100">
					<br><br>
					<b>Address</b>
					<br>
					<b>Lahore</b>
					<br>
					<b>0300 1234567</b>
				</td>
				<td width="300" align="left" valign="top">
					<?php
						$query = $db->prepare("SELECT * FROM ledger L INNER JOIN accounts A ON L.aid = A.aid WHERE A.aid = ? ORDER BY L.leid ASC LIMIT 0,1");
						$query->execute(array($_REQUEST['aid']));
						while($row = $query->fetch())
						{
							$totalbalance = number_format($row['balance']);
					?>	
					<h1>Account Ledger</h1>
					Account : <?php echo($row['aname']." (".$row['aemail'].")"); ?>
					<br>
					<?php }
						if($_REQUEST['startdate']!= "" && $_REQUEST['enddate']!= ""){ $ldate = "AND ldate BETWEEN ".strtotime(str_replace("/", "-", $_REQUEST['startdate']))." AND ".strtotime(str_replace("/", "-", $_REQUEST['enddate'])).""; ?>
						<b>Start Date : <?php echo($_REQUEST['startdate']); ?></b>
						<b>End Date : <?php echo($_REQUEST['enddate']); ?></b>
					<?php } else{ $ldate = ""; } ?>
					<div id="showLedger"></div>
				</td>
			</tr>
		</table>
		<br><br>
		<?php
			if(isset($_REQUEST['err']))
			{
		?>
		<table align="center" width="950">
			<tr>
				<td>
					<div class="alert alert-success alert-dismissable">
						<button type="button" class="close" data-dismiss="alert">&times;</button>
						<?php echo($ErrMsg); ?>
					</div>
				</td>
			</tr>
		</table>
		<?php
			}
		?>	
		<table align="center" width="950" style="border: 1px solid #CCC; font-family: arial;">
			<tr class="title">
				<td style="border: 1px solid #CCC;" width="50" align="center" bgcolor="#333" height="25"><span style="color: #fff; font-weight: bold;">Sr#</span></td>
				<td style="border: 1px solid #CCC;" width="60" align="left" bgcolor="#333" height="15">&nbsp;<b style="color: white;">Date</b></td>
				<td style="border: 1px solid #CCC;" align="left" bgcolor="#333" height="15">&nbsp;<b style="color: white;">Details</b></td>
				<td style="border: 1px solid #CCC;" width="90" align="right" bgcolor="#333" height="15"><b style="color: white;">Debit</b>&nbsp;</td>
				<td style="border: 1px solid #CCC;" width="90" align="right" bgcolor="#333" height="15"><b style="color: white;">Credit</b>&nbsp;</td>
				<td style="border: 1px solid #CCC;" width="100" align="right" bgcolor="#333" height="15"><b style="color: white;">Balance</b>&nbsp;</td>
			</tr>
			<?php
				$count = 0;
				$lequery = $db->prepare("SELECT * FROM ledger WHERE aid = ".$_REQUEST['aid']." $ldate ORDER BY leid DESC");
				$lequery->execute();
				if($lequery->rowCount() == 0)
				{
			?>
			<tr>
				<td align="center" colspan="6">
					No Record Found!
				</td>
			</tr>
			<?php		
				}
				else
				{
					while($lerow = $lequery->fetch())
					{
						$count++;
						if($lerow['debit'] != 0 && $lerow['credit'] != 0) {  $bgcolor = "#FFF"; }
						if($lerow['debit'] != 0 && $lerow['credit'] == 0) {  $bgcolor = "#FCEBEB"; }
						if($lerow['debit'] == 0 && $lerow['credit'] != 0) {  $bgcolor = "#EDFCEB"; }
						if($lerow['debit'] == 0 && $lerow['credit'] == 0) {  $bgcolor = "#FFF"; }
			?>
			<tr bgcolor="<?php echo($bgcolor); ?>">
				<td style="border: 1px solid #CCC;" align="center" class="title" height="25">&nbsp;<?php echo($count); ?></td>
				<td style="border: 1px solid #CCC;" align="left">&nbsp;<?php echo(date("d/m/Y",$lerow['ldate'])); ?></td>
				<td style="border: 1px solid #CCC;" align="left">
					<?php echo($lerow['detail']); ?>
				</td>
				<td style="border: 1px solid #CCC;" align="right"><?php echo(number_format($lerow['debit'])); ?>&nbsp;</td>
				<td style="border: 1px solid #CCC;" align="right"><?php echo(number_format($lerow['credit'])); ?>&nbsp;</td>
				<td style="border: 1px solid #CCC;" align="right"><?php echo(number_format($lerow['balance'])); ?>&nbsp;</td>
			</tr>
			<tr>
			<?php
					}
					$totalquery = $db->prepare("SELECT SUM(debit) AS totalreceived, SUM(credit) AS totalpayment FROM ledger WHERE aid = ".$_REQUEST['aid']." $ldate");
					$totalquery->execute();
					while($totalrow = $totalquery->fetch())
					{
			?>
			
				<td style="border: 1px solid #CCC;" align="right" height="35" colspan="3"></td>
				<td style="border: 1px solid #CCC;" align="right"><b><?php echo(number_format($totalrow['totalreceived'])); ?></b>&nbsp;</td>
				<td style="border: 1px solid #CCC;" align="right"><b><?php echo(number_format($totalrow['totalpayment'])); ?></b>&nbsp;</td>
			
			<?php
					}
					$balQuery = $db->prepare("SELECT balance FROM ledger WHERE aid = ".$_REQUEST['aid']." $ldate ORDER BY leid DESC LIMIT 0,1");
					$balQuery->execute();
					while($balrow = $balQuery->fetch())
					{
						$CurrentBalance = $balrow['balance'];
			?>
				<td style="border: 1px solid #CCC;" align="right"><b><?php echo(number_format($CurrentBalance)); ?></b>&nbsp;</td>
			<?php
					}
				}

			?>
				
			</tr>
		</table>
		<br><br>
		<table align="center" width="950" style="border: 1px solid #CCC; font-family: arial;">
			<tr class="footer" style="background-color: #107E7F">
				<td align="center" colspan="2">
					<span style="font-size: 12px; color: #fff; font-weight: bold;">	
						Thanks for Doing Business With Us <br> We are Always Happy to Serve You
					</span>
				</td>
			</tr>
		</table>
	</div>
</form>
</body>
</html>
