<?php
	include("includes/functions.php");
	include("includes/session.php");
	include("includes/errors.php");
	chk_login1();
?>
<!doctype html>
<html>

<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
	<!-- Apple devices fullscreen -->
	<meta name="apple-mobile-web-app-capable" content="yes" />
	<!-- Apple devices fullscreen -->
	<meta names="apple-mobile-web-app-status-bar-style" content="black-translucent" />

	<title>Sentient - Input Data Report</title>

	<!-- Bootstrap -->
	<link rel="stylesheet" href="css/bootstrap.min.css">
	<!-- jQuery UI -->
	<link rel="stylesheet" href="css/plugins/jquery-ui/jquery-ui.min.css">
	<!-- dataTables -->
	<link rel="stylesheet" href="css/plugins/datatable/TableTools.css">
	<!-- chosen -->
	<link rel="stylesheet" href="css/plugins/chosen/chosen.css">
	<!-- Theme CSS -->
	<link rel="stylesheet" href="css/style.css">
	<!-- Color CSS -->
	<link rel="stylesheet" href="css/themes.css">

	<!-- jQuery -->
	<script src="js/jquery.min.js"></script>

	<!-- Nice Scroll -->
	<script src="js/plugins/nicescroll/jquery.nicescroll.min.js"></script>
	<!-- imagesLoaded -->
	<script src="js/plugins/imagesLoaded/jquery.imagesloaded.min.js"></script>
	<!-- jQuery UI -->
	<script src="js/plugins/jquery-ui/jquery-ui.js"></script>
	<!-- slimScroll -->
	<script src="js/plugins/slimscroll/jquery.slimscroll.min.js"></script>
	<!-- Bootstrap -->
	<script src="js/bootstrap.min.js"></script>
	<!-- Bootbox -->
	<script src="js/plugins/bootbox/jquery.bootbox.js"></script>
	<!-- New DataTables -->
	<script src="js/plugins/momentjs/jquery.moment.min.js"></script>
	<script src="js/plugins/momentjs/moment-range.min.js"></script>
	<script src="js/plugins/datatables/jquery.dataTables.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.tableTools.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.colReorder.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.colVis.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.scroller.min.js"></script>

	<!-- Chosen -->
	<script src="js/plugins/chosen/chosen.jquery.min.js"></script>

	<!-- Theme framework -->
	<script src="js/eakroko.min.js"></script>
	<!-- Theme scripts -->
	<script src="js/application.min.js"></script>
	<!-- Just for demonstration -->
	<script src="js/demonstration.min.js"></script>

	<!--[if lte IE 9]>
		<script src="js/plugins/placeholder/jquery.placeholder.min.js"></script>
		<script>
			$(document).ready(function() {
				$('input, textarea').placeholder();
			});
		</script>
	<![endif]-->

	<!-- Favicon -->
	<link rel="shortcut icon" href="img/favicon.png" />
	<!-- Apple devices Homescreen icon -->
	<link rel="apple-touch-icon-precomposed" href="img/apple-touch-icon-precomposed.png" />

</head>

<body>
	<div class="container-fluid nav-hidden" id="content">
		<div id="main">
			<div class="container-fluid">
				
				
				<div class="row">
					<div class="col-sm-12">
						<div class="box">
							
							<div class="box-content">
								<div class="invoice-info">
									
									<div class="invoice-from">
										<br>
										<img src="images/sentient_logo.jpg" width="125">
								
										<address>
											Sentient
											<br>Lahore
											
										</address>
									</div>
									
									<div class="invoice-infos">
										<h1>Input Data Report</h1>
										<?php
											$uid = $_REQUEST['id'];
											$stid = $_REQUEST['stid'];
											$brid = $_REQUEST['stid'];
											$city = $_REQUEST['city'];
											
											$from_date_timestamp = strtotime($_REQUEST['fromdate']);
											$to_date_timestamp = strtotime($_REQUEST['todate']) + 86399;

											$from_date = date("d-m-Y",$from_date_timestamp);
											$to_date = date("d-m-Y",$to_date_timestamp);

											if($_REQUEST['id'] != 0)
											{
												$baquery = $db->prepare("SELECT uid, ba_no, fullname FROM users WHERE uid=?");
												$baquery->execute(array($uid));
												while($barow = $baquery->fetch())
												{
													$ba_name = $barow['fullname'].": BA-".$barow['ba_no'];
												}
												$q1 = "AND UAT.uid = '$uid'";
											}
											else
											{
												$ba_name = "All";
												$q1 = "";
											}

											if($_REQUEST['stid'] != 0)
											{
												$stid = $_REQUEST['stid'];
												$stquery = $db->prepare("SELECT stid, store_code, store_name, city FROM store WHERE stid=?");
												$stquery->execute(array($stid));
												while($strow = $stquery->fetch())
												{
													$store_name = $strow['store_name'];
												}
												$q2 = "AND ASA.stid = '$stid'";
											}
											else
											{
												$store_name = "All";
												$q2 = "";
											}

											if($_REQUEST['city'] != 0 && $_REQUEST['city'] != "")
											{
												$stcity = $_REQUEST['city'];
												/*echo("'".str_replace(",","','",$stcity)."'");
												echo("<br>");
												$temp = array(0,1);*/
												//$st_city = "'".str_replace(",","','",$stcity)."'";										
												//$result = "'" . implode ( "', '", $temp ) . "'";
												//echo($result);
												$q3 = "AND ST.city = '$stcity'";
											}
											else{
												$stcity = "All";
												$q3 = "";
											}	

											if($_REQUEST['brid'] != 0)
											{
												$brid = $_REQUEST['brid'];
												$q4 = "AND ASA.brid = $brid";
												
												$brquery = $db->prepare("SELECT brid, brname FROM brand WHERE brid=?");
												$brquery->execute(array($brid));
												while($brrow = $brquery->fetch())
												{
													$brand = $brrow['brname'];
												}
											}
											else{
												$brid = 0;
												$q4 = "";
												
												$brand = "All";
											}	

											$pquery = $db->prepare("SELECT * FROM products WHERE brid = ? ORDER BY pid ASC");
											$pquery->execute(array($brid));
											$num_skus = $pquery->rowCount();

											$cpquery1 = $db->prepare("SELECT * FROM com_brand COB INNER JOIN cbrand CB ON COB.cbrid = CB.cbrid WHERE COB.brid = ? AND COB.cbrid <> ? ORDER BY COB.cbrid ASC");
											$cpquery1->execute(array($brid,0));
											$num_cskus1 = $cpquery1->rowCount();	

											$cpquery2 = $db->prepare("SELECT * FROM com_brand COB INNER JOIN cbrand CB ON COB.cbrid = CB.cbrid WHERE COB.brid = ? AND COB.cbrid <> ? ORDER BY COB.cbrid ASC");
											$cpquery2->execute(array($brid,0));
											$num_cskus2 = $cpquery2->rowCount();	

										//	echo($num_skus." / ".$num_cskus1." / ".$num_cskus2);					
										?>
										<table>
											<tr><td>&nbsp;</td></tr>
											<tr><td align="left"><b>From Date: <?php echo($from_date); ?></b></td></tr>
											<tr><td align="left"><b>To Date: <?php echo($to_date); ?></b></td></tr>
											<tr><td align="left"><b>Brand: <?php echo($brand); ?></b></td></tr>	
											<tr><td align="left"><b>Store: <?php echo($store_name); ?></b></td></tr>
											<tr><td align="left"><b>BA: <?php echo($ba_name); ?></b></td></tr>
											<tr><td align="left"><b>City: <?php echo($stcity); ?></b></td></tr>
										</table>
									</div>
								</div>
								<?php
									$query = $db->prepare("SELECT * FROM user_attendance UAT INNER JOIN users U ON UAT.uid = U.uid 
															INNER JOIN assignments ASA ON UAT.asid = ASA.asid 
															INNER JOIN brand BR ON ASA.brid = BR.brid 
															INNER JOIN store ST ON ASA.stid = ST.stid 
															WHERE uatdate BETWEEN $from_date_timestamp AND $to_date_timestamp $q1 $q2 $q3 $q4");
									$query->execute();
									$num_brand = $query->rowCount();

									if($num_brand == 0)
									{
								?>
								<table>
									<tr>
										<td align="center"><span style="color:red;">No Record Found!</span></td>
									</tr>
								</table>
								
								<?php
									}
									else{
								?>
								<table class="table table-hover table-nomargin table-bordered" data-nosearch data-nopagination data-noinfo>
									<thead>
										<tr>
											<th style="background-color: seagreen; color:white;" colspan="8"></th>
											<th style="background-color: seagreen; color:white; text-align: center;" colspan="<?php echo($num_skus); ?>"></th>
											<th style="background-color: seagreen; color:white; text-align: center;" colspan="<?php echo($num_cskus1); ?>">Interception</th>
											<th style="background-color: seagreen; color:white; text-align: center;" colspan="<?php echo($num_cskus2); ?>">Productive</th>
										</tr>
										<tr>
											<th>Sr</th>
											<th>Date</th>
											<th>Store Name</th>
											<th>BA Name</th>
											<th>City</th>
											<th style="background-color: lightyellow;">Total Sales</th>
											<th style="background-color: #CDF5FD;">Interception</th>
											<th style="background-color: #CBFFA9;">Productive</th>
											

											<?php
												while($prow = $pquery->fetch())
												{
											?>
											<th style="background-color: lightyellow;"><?php echo($prow['pname']); ?></th>
											<?php
												}
											?>
											<?php
												while($cprow1 = $cpquery1->fetch())
												{
											?>
											<th style="background-color: #CDF5FD;"><?php echo($cprow1['cbrname']); ?></th>
											<?php
												}
											?>
											<?php
												while($cprow2 = $cpquery2->fetch())
												{
											?>
											<th style="background-color: #CBFFA9;"><?php echo($cprow2['cbrname']); ?></th>
											<?php
												}
											?>
										</tr>
									</thead>
										
									<tbody>
										<?php
											$count = 0;
											while($row = $query->fetch())
											{
												$count++;
												$ba_uid = $row['uid'];
												$sale_date = $row['attendance_date'];
												$store = $row['store_name'];
												$ba = $row['fullname'];

												/// Total Sale
												$asa_query = $db->prepare("SELECT uid, brid, sale_date, SUM(sale_qty) AS total_sale FROM assignment_sale WHERE uid = ? AND brid = ? AND sale_date = ?");
												$asa_values = array($ba_uid, $brid, $sale_date);
												$asa_query->execute($asa_values);
												while($asa_row = $asa_query->fetch())
												{
													$total_sale = $asa_row['total_sale'];
												}

												/// Total Intercept
												$us_query = $db->prepare("SELECT uid, brid, sale_date, SUM(interception) AS total_interception, SUM(productive) AS total_productive FROM usership_detail WHERE uid = ? AND brid = ? AND sale_date = ?");
												$us_values = array($ba_uid, $brid, $sale_date);
												$us_query->execute($us_values);
												while($us_row = $us_query->fetch())
												{
													$total_interception = $us_row['total_interception'];
													$total_productive = $us_row['total_productive'];
												}
										?>
										<tr>
											<td align="center" class="title" height="25"><?php echo($count); ?>. </td>
											<td align="left" class="title" height="25"><?php echo($sale_date); ?></td>
											<td align="left" class="title" height="25"><?php echo($store); ?></td>
											<td align="left" class="title" height="25"><?php echo($ba); ?></td>
											<td align="left" class="title" height="25"><?php echo($row['city']); ?></td>
											<td align="center" class="title" height="25"><?php if($total_sale ) {echo($total_sale);} else{echo("0");} ?></td>
											<td align="left" class="title" height="25"><?php if($total_interception ) {echo($total_interception);} else{echo("0");} ?></td>
											<td align="left" class="title" height="25"><?php if($total_productive ) {echo($total_productive);} else{echo("0");} ?></td>
											
											<?php
												$sale_query = $db->prepare("SELECT uid, brid, pid, sale_date, sale_qty FROM assignment_sale WHERE uid = ? AND brid = ? AND sale_date = ? ORDER BY pid ASC");
												$sale_values = array($ba_uid, $brid, $sale_date);
												$sale_query->execute($sale_values);
												$num_sale = $sale_query->rowCount();
												//echo($num_sale);

												while($sale_row = $sale_query->fetch())
												{
											?>
											<td align="center" class="title" height="25"><?php echo($sale_row['sale_qty']); ?></td>
											<?php
												}
												
												if($num_sale < $num_skus)
												{
													$extra_sku = $num_skus - $num_sale;
													for($i = 1; $i <= $extra_sku; $i++)
													{
											?>
											
											<td> 0 </td>
											<?php
													}
												}	
												$inter_query1 = $db->prepare("SELECT uid, brid, cbrid, sale_date, interception  FROM usership_detail WHERE uid = ? AND brid = ? AND cbrid <> ? AND sale_date = ? ORDER BY cbrid ASC");
												$inter_values1 = array($ba_uid, $brid, 0, $sale_date);
												$inter_query1->execute($inter_values1);
												while($inter_row1 = $inter_query1->fetch())
												{
											?>
											<td align="center" class="title" height="25"><?php echo($inter_row1['interception']); ?></td>
											<?php
												}	
											?>
											<?php
												$inter_query2 = $db->prepare("SELECT uid, brid, cbrid, sale_date, productive  FROM usership_detail WHERE uid = ? AND brid = ? AND cbrid <> ? AND sale_date = ? ORDER BY cbrid ASC");
												$inter_values2 = array($ba_uid, $brid, 0, $sale_date);
												$inter_query2->execute($inter_values2);
												while($inter_row2 = $inter_query2->fetch())
												{
													if($inter_row2['cbrid'] > 0){
											?>
											<td align="center" class="title" height="25"><?php echo($inter_row2['productive']); ?></td>
											<?php
													}
												}	
											?>
										</tr>
										<?php
											}
										?>
									</tbody>

								</table>
								<?php } ?>
								<div class="box-title">
								<div align="left" class="col-sm-6"><h6><b>Report Name:</b> Input Data Report</h6></div>
								<div align="right" class="col-sm-6"><h6><b>Printed By:</b> <?php echo($UserFullName); ?> <b>On</b> <?php echo(date("F d, Y h:i A")); ?> </h6></div>
							</div>
							</div>


						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</body>

</html>