<?php
	include("includes/functions.php");
	include("includes/session.php");
	include("includes/errors.php");
	chk_login1();
?>
<!doctype html>
<html>

<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
	<!-- Apple devices fullscreen -->
	<meta name="apple-mobile-web-app-capable" content="yes" />
	<!-- Apple devices fullscreen -->
	<meta names="apple-mobile-web-app-status-bar-style" content="black-translucent" />

	<title>Sentient - Input Data Report</title>

	<!-- Bootstrap -->
	<link rel="stylesheet" href="css/bootstrap.min.css">
	<!-- jQuery UI -->
	<link rel="stylesheet" href="css/plugins/jquery-ui/jquery-ui.min.css">
	<!-- dataTables -->
	<link rel="stylesheet" href="css/plugins/datatable/TableTools.css">
	<!-- chosen -->
	<link rel="stylesheet" href="css/plugins/chosen/chosen.css">
	<!-- Theme CSS -->
	<link rel="stylesheet" href="css/style.css">
	<!-- Color CSS -->
	<link rel="stylesheet" href="css/themes.css">

	<!-- jQuery -->
	<script src="js/jquery.min.js"></script>

	<!-- Nice Scroll -->
	<script src="js/plugins/nicescroll/jquery.nicescroll.min.js"></script>
	<!-- imagesLoaded -->
	<script src="js/plugins/imagesLoaded/jquery.imagesloaded.min.js"></script>
	<!-- jQuery UI -->
	<script src="js/plugins/jquery-ui/jquery-ui.js"></script>
	<!-- slimScroll -->
	<script src="js/plugins/slimscroll/jquery.slimscroll.min.js"></script>
	<!-- Bootstrap -->
	<script src="js/bootstrap.min.js"></script>
	<!-- Bootbox -->
	<script src="js/plugins/bootbox/jquery.bootbox.js"></script>
	<!-- New DataTables -->
	<script src="js/plugins/momentjs/jquery.moment.min.js"></script>
	<script src="js/plugins/momentjs/moment-range.min.js"></script>
	<script src="js/plugins/datatables/jquery.dataTables.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.tableTools.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.colReorder.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.colVis.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.scroller.min.js"></script>

	<!-- Chosen -->
	<script src="js/plugins/chosen/chosen.jquery.min.js"></script>

	<!-- Theme framework -->
	<script src="js/eakroko.min.js"></script>
	<!-- Theme scripts -->
	<script src="js/application.min.js"></script>
	<!-- Just for demonstration -->
	<script src="js/demonstration.min.js"></script>

	<!--[if lte IE 9]>
		<script src="js/plugins/placeholder/jquery.placeholder.min.js"></script>
		<script>
			$(document).ready(function() {
				$('input, textarea').placeholder();
			});
		</script>
	<![endif]-->

	<!-- Favicon -->
	<link rel="shortcut icon" href="img/favicon.png" />
	<!-- Apple devices Homescreen icon -->
	<link rel="apple-touch-icon-precomposed" href="img/apple-touch-icon-precomposed.png" />

</head>

<body>
	<div class="container-fluid nav-hidden" id="content">
		<div id="main">
			<div class="container-fluid">
				
				
				<div class="row">
					<div class="col-sm-12">
						<div class="box">
							
							<div class="box-content">
								<div class="invoice-info">
									
									<div class="invoice-from">
										<br>
										<img src="images/sentient_logo.jpg" width="125">
								
										<address>
											Sentient
											<br>Lahore
										</address>
									</div>
									
									<div class="invoice-infos">
										<h1>Input Data Report</h1>
										<?php

											$arr_total_sales = array();
											$arr_total_comp_sales = array();
											$arr_total_samples = array();
											$arr_total_deals = array();
											$arr_total_interception = array();
											$arr_total_productive = array();

									        $arr_pid = array();
									        $arr_cbrid1 = array();
									        $arr_cbrid2 = array();
									        $arr_cbrid3 = array();

									        
											

											$uid = $_REQUEST['id'];
											$stid = $_REQUEST['stid'];
											$brid = $_REQUEST['stid'];
											$city = $_REQUEST['city'];
											$deals = $_REQUEST['deals'];
											$supuid = $_REQUEST['supuid'];
											
											$from_date_timestamp = strtotime($_REQUEST['fromdate']);
											$to_date_timestamp = strtotime($_REQUEST['todate']) + 86399;

											$from_date = date("d-m-Y",$from_date_timestamp);
											$to_date = date("d-m-Y",$to_date_timestamp);

											if($_REQUEST['id'] != 0)
											{
												$baquery = $db->prepare("SELECT uid, ba_no, fullname FROM users WHERE uid=?");
												$baquery->execute(array($uid));
												while($barow = $baquery->fetch())
												{
													$ba_name = $barow['fullname'].": BA-".$barow['ba_no'];
												}
												$q1 = "AND U.uid = '$uid'";
											}
											else
											{
												$ba_name = "All";
												$q1 = "";
											}

											if($_REQUEST['stid'] != 0)
											{
												$stid = $_REQUEST['stid'];
												$stquery = $db->prepare("SELECT stid, store_code, store_name, city FROM store WHERE stid=?");
												$stquery->execute(array($stid));
												while($strow = $stquery->fetch())
												{
													$store_name = $strow['store_name'];
												}
												$q2 = "AND ASA.stid = '$stid'";
											}
											else
											{
												$store_name = "All";
												$q2 = "";
											}

											if($_REQUEST['city'] != 0 && $_REQUEST['city'] != "")
											{
												$stcity = $_REQUEST['city'];
												/*echo("'".str_replace(",","','",$stcity)."'");
												echo("<br>");
												$temp = array(0,1);*/
												//$st_city = "'".str_replace(",","','",$stcity)."'";										
												//$result = "'" . implode ( "', '", $temp ) . "'";
												//echo($result);
												$q3 = "AND ST.city = '$stcity'";
											}
											else{
												$stcity = "All";
												$q3 = "";
											}	

											if($_REQUEST['brid'] != 0)
											{
												$brid = $_REQUEST['brid'];
												$q4 = "AND ASA.brid = $brid";
												
												$brquery = $db->prepare("SELECT brid, brname FROM brand WHERE brid=?");
												$brquery->execute(array($brid));
												while($brrow = $brquery->fetch())
												{
													$brand = $brrow['brname'];
												}
											}
											else{
												$brid = 0;
												$q4 = "";
												
												$brand = "All";
											}

											if($_REQUEST['deals'] != "")
											{
												$deals = $_REQUEST['deals'];

												if($_REQUEST['deals'] == 1)
												{
													$q5 = "AND ASA.deal_status = 1";
													$deals_status = "Active";
												}
												else
												{
													$q5 = "AND ASA.deal_status = 0";
													$deals_status = "Inactive";
												}
											}
											else{
												$q5 = "";
												$deals_status = "All";
											}	
											if($_REQUEST['supuid'] != 0)
											{
												$supid = $_REQUEST['supuid'];
												$supquery = $db->prepare("SELECT uid, su_no, fullname FROM users WHERE uid=?");
												$supquery->execute(array($supid));
												while($suprow = $supquery->fetch())
												{
													$supervisor = $suprow['fullname'].": SU-".$suprow['su_no'];
												}
												$q6 = "AND ASA.supuid = '$supid'";

											}
											else{
												$supid = 0;
												$supervisor = "All";
												$q6 = "";
											}
											$pquery = $db->prepare("SELECT * FROM products WHERE brid = ? ORDER BY pname ASC");
											$pquery->execute(array($brid));
											$num_skus = $pquery->rowCount();

											$cpquery1 = $db->prepare("SELECT * FROM com_brand COB INNER JOIN cbrand CB ON COB.cbrid = CB.cbrid WHERE COB.brid = ? AND COB.cbrid <> ? ORDER BY CB.cbrname ASC");
											$cpquery1->execute(array($brid,0));
											$num_cskus1 = $cpquery1->rowCount();	

											$cpquery2 = $db->prepare("SELECT * FROM com_brand COB INNER JOIN cbrand CB ON COB.cbrid = CB.cbrid WHERE COB.brid = ? AND COB.cbrid <> ? ORDER BY CB.cbrname ASC");
											$cpquery2->execute(array($brid,0));
											$num_cskus2 = $cpquery2->rowCount();	

											$cpquery3 = $db->prepare("SELECT * FROM com_brand COB INNER JOIN cbrand CB ON COB.cbrid = CB.cbrid WHERE COB.brid = ? AND COB.cbrid <> ? ORDER BY CB.cbrname ASC");
											$cpquery3->execute(array($brid,0));
											$num_cskus3 = $cpquery3->rowCount();	

											//echo($num_skus." / ".$num_cskus1." / ".$num_cskus2);					
										?>
										<table>
											<tr><td>&nbsp;</td></tr>
											<tr><td align="left"><b>From Date: <?php echo($from_date); ?></b></td></tr>
											<tr><td align="left"><b>To Date: <?php echo($to_date); ?></b></td></tr>
											<tr><td align="left"><b>Brand: <?php echo($brand); ?></b></td></tr>	
											<tr><td align="left"><b>Store: <?php echo($store_name); ?></b></td></tr>
											<tr><td align="left"><b>Supervisor: <?php echo($supervisor); ?></b></td></tr>
											<tr><td align="left"><b>BA: <?php echo($ba_name); ?></b></td></tr>
											<tr><td align="left"><b>City: <?php echo($stcity); ?></b></td></tr>
											<tr><td align="left"><b>Deals Status: <?php echo($deals_status); ?></b></td></tr>
										</table>
									</div>
								</div>
								<?php
									$query = $db->prepare("SELECT UAT.uid, UAT.asid, UAT.attendance_date, UAT.store_starttime, UAT.store_offtime, UAT.timein, UAT.uatdeals, UAT.uatsamples, UAT.uatdate, U.uid, U.fullname, ASA.asid, ASA.stid, ASA.brid, ASA.supuid, BR.brid, BR.brname, ST.stid, ST.store_code, ST.store_name, ST.city  FROM user_attendance UAT 
															INNER JOIN users U ON UAT.uid = U.uid 
															INNER JOIN assignments ASA ON UAT.asid = ASA.asid 
															INNER JOIN brand BR ON ASA.brid = BR.brid 
															INNER JOIN store ST ON ASA.stid = ST.stid 
															WHERE uatdate BETWEEN $from_date_timestamp AND $to_date_timestamp $q1 $q2 $q3 $q4 $q5 $q6");

									// echo("SELECT UAT.uid, UAT.asid, UAT.attendance_date, UAT.store_starttime, UAT.store_offtime, UAT.timein, UAT.uatdate, U.uid, U.fullname, ASA.asid, ASA.stid, ASA.brid, BR.brid, BR.brname, ST.stid, ST.store_code, ST.store_name, ST.city  FROM user_attendance UAT 
									// 						INNER JOIN users U ON UAT.uid = U.uid 
									// 						INNER JOIN assignments ASA ON UAT.asid = ASA.asid 
									// 						INNER JOIN brand BR ON ASA.brid = BR.brid 
									// 						INNER JOIN store ST ON ASA.stid = ST.stid 
									// 						WHERE uatdate BETWEEN $from_date_timestamp AND $to_date_timestamp $q1 $q2 $q3 $q4 $q5 $q6");
									$query->execute();
									$num_brand = $query->rowCount();

									if($num_brand == 0)
									{
								?>
								<table>
									<tr>
										<td align="center"><span style="color:red;">No Record Found!</span></td>
									</tr>
								</table>
								
								<?php
									}
									else{
								?>
								<table class="table table-hover table-nomargin table-bordered" data-nosearch data-nopagination data-noinfo>
									<thead>
										<tr>
											<th style="background-color: seagreen; color:white;" colspan="12"></th>
											<th style="background-color: seagreen; color:white; text-align: center;" colspan="<?php echo($num_skus); ?>"><?php echo($brand); ?></th>
											<th style="background-color: seagreen; color:white; text-align: center;" colspan="<?php echo($num_cskus1); ?>">Interception</th>
											<th style="background-color: seagreen; color:white; text-align: center;" colspan="<?php echo($num_cskus2); ?>">Productive</th>
											<th style="background-color: seagreen; color:white; text-align: center;" colspan="<?php echo($num_cskus3); ?>">Competition Sale</th>
										</tr>
										<tr>
											<th>Sr</th>
											<th>Date</th>
											<th>Store Name</th>
											<th>Supervisor</th>
											<th>BA Name</th>
											<th>City</th>
											<th style="background-color: lightyellow;">Total Sales</th>
											<th style="background-color: lightpink;">Competition Sales</th>
											<th style="background-color: lightpink;">Total Samples</th>
											<th style="background-color: lightpink;">Total Deals</th>
											<th style="background-color: #CDF5FD;">Interception</th>
											<th style="background-color: #CBFFA9;">Productive</th>
											<?php
												while($prow = $pquery->fetch())
												{
												    array_push($arr_pid, $prow['pid']);
											?>
											<th style="background-color: lightyellow;"><?php echo($prow['pname']); ?></th>
											<?php
												}
											?>
											<?php
												while($cprow1 = $cpquery1->fetch())
												{
												    array_push($arr_cbrid1, $cprow1['cbrid']);
											?>
											<th style="background-color: #CDF5FD;"><?php echo($cprow1['cbrname']); ?></th>
											<?php
												}
											?>
											<?php
												while($cprow2 = $cpquery2->fetch())
												{
												    array_push($arr_cbrid2, $cprow2['cbrid']);
											?>
											<th style="background-color: #CBFFA9;"><?php echo($cprow2['cbrname']); ?></th>
											<?php
												}
											?>
											<?php
												while($cprow3 = $cpquery3->fetch())
												{
												    array_push($arr_cbrid3, $cprow3['cbrid']);
											?>
											<th style="background-color: lightpink;"><?php echo($cprow3['cbrname']); ?></th>
											<?php
												}
											?>
										</tr>
									</thead>
										
									<tbody>
										<?php
											$count = 0;
											while($row = $query->fetch())
											{
												$count++;
												$sup_uid = $row['supuid'];
												$ba_uid = $row['uid'];
												$asid = $row['asid'];
												$sale_date = $row['attendance_date'];
												$store = $row['store_name'];
												$ba = $row['fullname'];
												$uatdeals = $row['uatdeals'];
												$uatsamples = $row['uatsamples'];

												if($sup_uid != 0)
												{
													$supquery1 = $db->prepare("SELECT uid, su_no, fullname FROM users WHERE uid=?");
													$supquery1->execute(array($sup_uid));
													while($suprow1 = $supquery1->fetch())
													{
														$store_supervisor = $suprow1['fullname'].": SU-".$suprow1['su_no'];
													}
												}
												else
												{
													$store_supervisor = "<span style='color:red;'>Not Assigned</span>";
												}

												/// Total Sale
												$asa_query = $db->prepare("SELECT uid, brid, sale_date, SUM(sale_qty) AS total_sale FROM assignment_sale WHERE uid = ? AND brid = ? AND sale_date = ?");
												$asa_values = array($ba_uid, $brid, $sale_date);
												$asa_query->execute($asa_values);
												while($asa_row = $asa_query->fetch())
												{
													$total_sale = $asa_row['total_sale'];
												}

												/// Competition Sale
												$comp_query = $db->prepare("SELECT uid, brid, sale_date, SUM(com_sale) AS total_com_sale FROM usership_detail WHERE uid = ? AND brid = ? AND sale_date = ?");
												$comp_values = array($ba_uid, $brid, $sale_date);
												$comp_query->execute($comp_values);
												while($comp_row = $comp_query->fetch())
												{
													$total_com_sale = $comp_row['total_com_sale'];
												}

												/// Total Intercept
												$us_query = $db->prepare("SELECT uid, brid, sale_date, SUM(interception) AS total_interception, SUM(productive) AS total_productive FROM usership_detail WHERE uid = ? AND brid = ? AND sale_date = ?");
												$us_values = array($ba_uid, $brid, $sale_date);
												$us_query->execute($us_values);
												while($us_row = $us_query->fetch())
												{
													$total_interception = $us_row['total_interception'];
													$total_productive = $us_row['total_productive'];
												}
										?>
										<tr>
											<td align="center" class="title" height="25"><?php echo($count); ?>. </td>
											<td align="left" class="title" height="25"><?php echo($sale_date); ?></td>
											<td align="left" class="title" height="25"><?php echo($store); ?></td>
											<td align="left" class="title" height="25"><?php echo($store_supervisor); ?></td>
											<td align="left" class="title" height="25">
												<?php echo($ba); ?>
												<?php echo("uid:". $ba_uid); ?>
												<?php echo("asid:". $asid); ?>
											</td>
											<td align="left" class="title" height="25"><?php echo($row['city']); ?></td>
											<td align="center" class="title" height="25">
												<?php if($total_sale ) {echo($total_sale); array_push($arr_total_sales, $total_sale);} else{echo("0");} ?>
											</td>
											<td align="center" class="title" height="25">
												<?php if($total_com_sale ) {echo($total_com_sale); array_push($arr_total_comp_sales, $total_com_sale);} else{echo("0");} ?>
											</td>
											<td align="center" class="title" height="25">
												<?php if($uatsamples ) {echo($uatsamples); array_push($arr_total_samples, $uatsamples);} else{echo("0");} ?>
													
											</td>
											<td align="center" class="title" height="25">
												<?php if($uatdeals ) {echo($uatdeals); array_push($arr_total_deals, $uatdeals);} else{echo("0");} ?>
													
											</td>
											<td align="center" class="title" height="25">
												<?php if($total_interception ) {echo($total_interception); array_push($arr_total_interception, $total_interception);} else{echo("0");} ?>
													
											</td>
											<td align="center" class="title" height="25">
												<?php if($total_productive ) {echo($total_productive); array_push($arr_total_productive, $total_productive);} else{echo("0");} ?>
													
											</td>
											
											<?php
												$arr_pid_qty = array();	
												$sale_query = $db->prepare("SELECT ASA.assid, ASA.uid, ASA.brid, ASA.pid, ASA.sale_date, ASA.sale_qty, P.pid, P.pname FROM assignment_sale ASA 
												            INNER JOIN products P ON ASA.pid = P.pid 
												            WHERE ASA.uid = ? AND ASA.brid = ? AND ASA.sale_date = ? ORDER BY P.pname ASC");
												$sale_values = array($ba_uid, $brid, $sale_date);
												$sale_query->execute($sale_values);
												$num_sale = $sale_query->rowCount();
												if($num_sale > 0)
											    {
											        while($sale_row = $sale_query->fetch())
											        {
											        	//echo($sale_row['uid']."/".$sale_row['pid']."/".$sale_row['sale_qty']."<br>");
											            $sale_qty = $sale_row['sale_qty'];
											            array_push($arr_pid_qty, $sale_row['pid']."/".$sale_row['sale_qty']);
											        }
											    }
											    else
											    {
											        $sale_qty = "<b>0</b>";
											    }

											    foreach($arr_pid as $arrpid)
											    {
											    	$array = $arr_pid_qty;
													$search = $arrpid."/";

													$matches = preg_grep("/^" . preg_quote($search, "/") . "/", $array);
													if (!empty($matches)) {
													    foreach ($matches as $match) {
													        //echo "<br>Found: " . $match . "";
													        $arr_sale = explode("/",$match);
													        $sale_qty = $arr_sale[1];
													    }
													} else {
													    $sale_qty = "<b>0</b>";
													}
											?>
											<td align="center" class="title" style="background-color: #FCFCF1;" height="25"><?php echo($sale_qty); ?></td>
											<?php
												}	
												$arr_cbrid1_qty = array();
												$inter_query1 = $db->prepare("SELECT UD.uid, UD.brid, UD.cbrid, UD.sale_date, UD.interception, CB.cbrid, CB.cbrname FROM usership_detail UD INNER JOIN cbrand CB ON UD.cbrid = CB.cbrid WHERE UD.uid = ? AND UD.brid = ? AND UD.cbrid <> ? AND UD.sale_date = ? ORDER BY CB.cbrname ASC");
												$inter_values1 = array($ba_uid, $brid, 0, $sale_date);
												$inter_query1->execute($inter_values1);
												$num_inter = $inter_query1->rowCount();
												if($num_inter > 0)
											    {
											        while($inter_row1 = $inter_query1->fetch())
											        {
											        	array_push($arr_cbrid1_qty, $inter_row1['cbrid']."/".$inter_row1['interception']);
											            $interception = $inter_row1['interception'];
											        }
											    }
											    else
											    {
											        $interception = "<b>0</b>";
											    }

												foreach($arr_cbrid1 as $arr1)
											    {
    												$array1 = $arr_cbrid1_qty;
													$search1 = $arr1."/";

													$matches1 = preg_grep("/^" . preg_quote($search1, "/") . "/", $array1);
													if (!empty($matches1)) {
													    foreach ($matches1 as $match1) {
													        //echo "<br>Found: " . $match . "";
													        $arr_interception = explode("/",$match1);
													        $interception_qty = $arr_interception[1];
													    }
													} else {
													    $interception_qty = "<b>0</b>";
													}
												
											?>
											<td align="center" class="title" style="background-color: #EEFAFC;" height="25"><?php echo($interception_qty); ?></td>
											<?php
												}
												$arr_cbrid2_qty = array();
											
												$inter_query2 = $db->prepare("SELECT UD.uid, UD.brid, UD.cbrid, UD.sale_date, UD.productive, CB.cbrid, CB.cbrname FROM usership_detail UD INNER JOIN cbrand CB ON UD.cbrid = CB.cbrid WHERE UD.uid = ? AND UD.brid = ? AND UD.cbrid <> ? AND UD.sale_date = ? ORDER BY CB.cbrname ASC");
												$inter_values2 = array($ba_uid, $brid, 0, $sale_date);
												$inter_query2->execute($inter_values2);
												$num_productive = $inter_query2->rowCount();
												if($num_productive > 0)
											    {
											        while($inter_row2 = $inter_query2->fetch())
												    {
												    	array_push($arr_cbrid2_qty, $inter_row2['cbrid']."/".$inter_row2['productive']);
											            $productive = $inter_row2['productive'];
											        }
											    }
											    else
											    {
											        $productive = "<b>0</b>";
											    }
											   	
											   	foreach($arr_cbrid2 as $arr2)
											    {
    												
    												$array2 = $arr_cbrid2_qty;
													$search2 = $arr2."/";

													$matches2 = preg_grep("/^" . preg_quote($search2, "/") . "/", $array2);
													if (!empty($matches2)) {
													    foreach ($matches2 as $match2) {
													        //echo "<br>Found: " . $match . "";
													        $arr_productive = explode("/",$match2);
													        $productive_qty = $arr_productive[1];
													    }
													} else {
													    $productive_qty = "<b>0</b>";
													}
																						?>
											<td align="center" class="title" style="background-color: #EAFDDE;" height="25"><?php echo($productive_qty); ?></td>
											<?php
												}
												$arr_cbrid3_qty = array();
												$inter_query3 = $db->prepare("SELECT UD.uid, UD.brid, UD.cbrid, UD.sale_date, UD.com_sale, CB.cbrid, CB.cbrname FROM usership_detail UD INNER JOIN cbrand CB ON UD.cbrid = CB.cbrid WHERE UD.uid = ? AND UD.brid = ? AND UD.cbrid <> ? AND UD.sale_date = ? ORDER BY CB.cbrname ASC");
											    $inter_values3 = array($ba_uid, $brid, 0, $sale_date);
											    $inter_query3->execute($inter_values3);
											    $num_com_sale = $inter_query3->rowCount();   
										    
											    if($num_com_sale > 0)
											    {
											        while($inter_row3 = $inter_query3->fetch())
											        {
											        	array_push($arr_cbrid3_qty, $inter_row3['cbrid']."/".$inter_row3['com_sale']);
											            $com_sale = $inter_row3['com_sale'];
											        }
											    }
											    else
											    {
											        $com_sale = "0";
											    }										
										    	foreach($arr_cbrid3 as $arr3)
											    {      
											        $array3 = $arr_cbrid3_qty;
													$search3 = $arr3."/";

													$matches3 = preg_grep("/^" . preg_quote($search3, "/") . "/", $array3);
													if (!empty($matches3)) {
													    foreach ($matches3 as $match3) {
													        //echo "<br>Found: " . $match . "";
													        $arr_com_sale = explode("/",$match3);
													        $com_sale_qty = $arr_com_sale[1];
													    }
													} else {
													    $com_sale_qty = "<b>0</b>";
													}
											?>        
											<td align="center" class="title" style="background-color: #FBE1E5;" height="25">
											    <?php echo($com_sale_qty); ?>
										   	</td>
											<?php
											    }
											?>
												
										</tr>
										<?php
											}
										
										?>
										<tr>
											<td align="left" style="background-color: #eee;" colspan="6">&nbsp; <strong>Total: </strong></td>
											<td align="center" style="background-color: #eee;"><strong><?php print_r(array_sum($arr_total_sales)); ?></strong></td>
											<td align="center" style="background-color: #eee;"><strong><?php print_r(array_sum($arr_total_comp_sales)); ?></strong></td>
											<td align="center" style="background-color: #eee;"><strong><?php print_r(array_sum($arr_total_samples)); ?></strong></td>
											<td align="center" style="background-color: #eee;"><strong><?php print_r(array_sum($arr_total_deals)); ?></strong></td>
											<td align="center" style="background-color: #eee;"><strong><?php print_r(array_sum($arr_total_interception)); ?></strong></td>
											<td align="center" style="background-color: #eee;"><strong><?php print_r(array_sum($arr_total_productive)); ?></strong></td>
										</tr>
									</tbody>

								</table>
								<?php } ?>
								<div class="box-title">
								<div align="left" class="col-sm-6"><h6><b>Report Name:</b> Input Data Report</h6></div>
								<div align="right" class="col-sm-6"><h6><b>Printed By:</b> <?php echo($UserFullName); ?> <b>On</b> <?php echo(date("F d, Y h:i A")); ?> </h6></div>
							</div>
							</div>


						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</body>

</html>