<?php
	include("includes/functions.php");
	include("includes/session.php");
	include("includes/errors.php");
	chk_login1();
?>
<!doctype html>
<html>

<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
	<!-- Apple devices fullscreen -->
	<meta name="apple-mobile-web-app-capable" content="yes" />
	<!-- Apple devices fullscreen -->
	<meta names="apple-mobile-web-app-status-bar-style" content="black-translucent" />

	<title>Sentient - BA Data Report</title>

	<!-- Bootstrap -->
	<link rel="stylesheet" href="css/bootstrap.min.css">
	<!-- jQuery UI -->
	<link rel="stylesheet" href="css/plugins/jquery-ui/jquery-ui.min.css">
	<!-- dataTables -->
	<link rel="stylesheet" href="css/plugins/datatable/TableTools.css">
	<!-- chosen -->
	<link rel="stylesheet" href="css/plugins/chosen/chosen.css">
	<!-- Theme CSS -->
	<link rel="stylesheet" href="css/style.css">
	<!-- Color CSS -->
	<link rel="stylesheet" href="css/themes.css">

	<!-- jQuery -->
	<script src="js/jquery.min.js"></script>

	<!-- Nice Scroll -->
	<script src="js/plugins/nicescroll/jquery.nicescroll.min.js"></script>
	<!-- imagesLoaded -->
	<script src="js/plugins/imagesLoaded/jquery.imagesloaded.min.js"></script>
	<!-- jQuery UI -->
	<script src="js/plugins/jquery-ui/jquery-ui.js"></script>
	<!-- slimScroll -->
	<script src="js/plugins/slimscroll/jquery.slimscroll.min.js"></script>
	<!-- Bootstrap -->
	<script src="js/bootstrap.min.js"></script>
	<!-- Bootbox -->
	<script src="js/plugins/bootbox/jquery.bootbox.js"></script>
	<!-- New DataTables -->
	<script src="js/plugins/momentjs/jquery.moment.min.js"></script>
	<script src="js/plugins/momentjs/moment-range.min.js"></script>
	<script src="js/plugins/datatables/jquery.dataTables.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.tableTools.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.colReorder.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.colVis.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.scroller.min.js"></script>

	<!-- Chosen -->
	<script src="js/plugins/chosen/chosen.jquery.min.js"></script>

	<!-- Theme framework -->
	<script src="js/eakroko.min.js"></script>
	<!-- Theme scripts -->
	<script src="js/application.min.js"></script>
	<!-- Just for demonstration -->
	<script src="js/demonstration.min.js"></script>

	<!--[if lte IE 9]>
		<script src="js/plugins/placeholder/jquery.placeholder.min.js"></script>
		<script>
			$(document).ready(function() {
				$('input, textarea').placeholder();
			});
		</script>
	<![endif]-->

	<!-- Favicon -->
	<link rel="shortcut icon" href="img/favicon.png" />
	<!-- Apple devices Homescreen icon -->
	<link rel="apple-touch-icon-precomposed" href="img/apple-touch-icon-precomposed.png" />

</head>

<body>
	<div class="container-fluid nav-hidden" id="content">
		<div id="main">
			<div class="container-fluid">
				
				
				<div class="row">
					<div class="col-sm-12">
						<div class="box">
							
							<div class="box-content">
								<div class="invoice-info">
									
									<div class="invoice-from">
										<br>
										<img src="images/sentient_logo.jpg" width="125">
								
										<address>
											Sentient
											<br>Lahore
											
										</address>
									</div>
									
									<div class="invoice-infos">
										<h1>BA Data Report</h1>
										<?php
											if($_REQUEST['city'] != 0)
											{
												$ba_city = $_REQUEST['city'];
												$q1 = "AND city = '$ba_city'";

											}
											else{
												$ba_city = "All";
												$q1 = "";
											}
											if($_REQUEST['stid'] != 0)
											{
												$stid = $_REQUEST['stid'];
												$q2 = "AND ASS.stid = $stid";
												$stquery = $db->prepare("SELECT stid, store_code, store_name FROM store WHERE stid=?");
												$stquery->execute(array($stid));
												while($strow = $stquery->fetch())
												{
													$store = $strow['store_name'].": ST-".$strow['store_code'];
												}
											}
											else{
												$store = "All";
												$q2 = "";
											}
											if($_REQUEST['brid'] != 0)
											{	
												$brid = $_REQUEST['brid'];
												$q3 = "AND ASS.brid = $brid";
												$brquery = $db->prepare("SELECT brid, brname FROM brand WHERE brid=?");
												$brquery->execute(array($brid));
												while($brrow = $brquery->fetch())
												{
													$brand = $brrow['brname'];
												}
											}
											else{
												$brid = 0;
												$q3 = "";
												$brand = "All";
											}

											if($_REQUEST['supuid'] != 0)
											{
												$supid = $_REQUEST['supuid'];
												$supquery = $db->prepare("SELECT uid, su_no, fullname FROM users WHERE uid=?");
												$supquery->execute(array($supid));
												while($suprow = $supquery->fetch())
												{
													$supervisor = $suprow['fullname'].": SU-".$suprow['su_no'];
												}
												$q4 = "AND ASS.supuid = '$supid'";

											}
											else{
												$supid = 0;
												$supervisor = "All";
												$q4 = "";
											}
										?>
										<table>
											<tr><td>&nbsp;</td></tr>
											<tr><td align="left"><b>City: <?php echo($ba_city); ?></b></td></tr>
											<tr><td align="left"><b>Chain Store: <?php echo($store); ?></b></td></tr>
											<tr><td align="left"><b>Supervisor: <?php echo($supervisor); ?></b></td></tr>	
											<tr><td align="left"><b>Brand: <?php echo($brand); ?></b></td></tr>	
										</table>
									</div>
								</div>
								<table class="table table-hover table-nomargin table-bordered dataTable" data-nosearch data-nopagination data-noinfo>
									<thead>
										<tr>
											<th>Sr</th>
											<th>Brand</th>
											<th>City</th>
											
											<th>Store Name</th>
											<th>Supervisor</th>
											<th>BA Name</th>
											<th>IBAN</th>
											<th>Cell Number</th>
											<th>Area</th>
											<th>Address</th>
											<th>BA Username</th>
										</tr>
									</thead>
									
										<?php
												$count = 0;
												$uaquery = $db->prepare("SELECT * FROM users WHERE utype = 4 AND ustatus = 0 $q1");
												$uaquery->execute();
												while($uarow = $uaquery->fetch())
												{
													
													$uid = $uarow['uid'];
													$ba_no = $uarow['ba_no'];
													$fullname = $uarow['fullname'];
													$username = $uarow['username'];
													$city = $uarow['city'];
													$area = $uarow['area'];
													$address = $uarow['address'];
													$bank_iban = $uarow['bank_iban'];
													$mobileno = $uarow['mobileno1'];

													if($q2 == "" && $q3 == "" && $q4 == "")
													{
														$count++;
														$asquery = $db->prepare("SELECT * FROM assignments ASS INNER JOIN store ST ON ASS.stid = ST.stid INNER JOIN brand BR ON ASS.brid = BR.brid WHERE ASS.uid=$uid");
														$asquery->execute();
														if($asquery->rowCount() == 0)
														{
															$brand_name = "N/A";
															$store_name = "Not Assigned";
															$store_supervisor = "<span style='color:red;'>Not Assigned</span>";
														}
														else
														{
															while($asrow = $asquery->fetch())
															{
																$store_name = $asrow['store_name'].": ST-".$asrow['store_code'];
																$brand_name = $asrow['brname'];
																$supuid 	= $asrow['supuid'];

																if($supuid != 0)
																{
																	$supquery1 = $db->prepare("SELECT uid, su_no, fullname FROM users WHERE uid=?");
																	$supquery1->execute(array($supuid));
																	while($suprow1 = $supquery1->fetch())
																	{
																		$store_supervisor = $suprow1['fullname'].": SU-".$suprow1['su_no'];
																	}
																}
																else
																{
																	$store_supervisor = "<span style='color:red;'>Not Assigned</span>";
																}
															}

														}
											?>	
											<tbody>
											<tr>
												<td align="center" class="title" height="25">&nbsp;<?php echo($count); ?>. </td>
												<td align="center"><?php echo(ucwords($brand_name)); ?></td>
												<td align="center"><?php echo($city); ?></td>
												<td align="left">&nbsp;<?php echo(ucwords($store_name)); ?></td>
												<td align="left">&nbsp;<?php echo(ucwords($store_supervisor)); ?></td>
												<td align="left">&nbsp;<?php echo(ucwords($fullname)." :BA-".$ba_no); ?></td>
												
												
												<td align="center"><?php echo($bank_iban); ?></td>
												<td align="center"><?php echo($mobileno); ?></td>
												<td align="center"><?php echo($area); ?></td>
												<td align="left">&nbsp;<?php echo($address); ?></td>
												<td align="left">&nbsp;<?php echo(ucwords($username)); ?></td>	
											</tr>
											</tbody>
											<?php
													}
													else
													{
														$asquery = $db->prepare("SELECT * FROM assignments ASS INNER JOIN store ST ON ASS.stid = ST.stid INNER JOIN brand BR ON ASS.brid = BR.brid WHERE ASS.uid=$uid $q2 $q3 $q4");
														$asquery->execute();
														if($asquery->rowCount() > 0)
														{
															$count++;
															while($asrow = $asquery->fetch())
															{
																$store_name = $asrow['store_name'].": ST-".$asrow['store_code'];
																$brand_name = $asrow['brname'];
																$supuid 	= $asrow['supuid'];
																if($supuid != 0)
																{
																	$supquery1 = $db->prepare("SELECT uid, su_no, fullname FROM users WHERE uid=?");
																	$supquery1->execute(array($supuid));
																	while($suprow1 = $supquery1->fetch())
																	{
																		$store_supervisor = $suprow1['fullname'].": SU-".$suprow1['su_no'];
																	}
																}
																else
																{
																	$store_supervisor = "<span style='color:red;'>Not Assigned</span>";
																}
															}
											?>
											<tbody>
											<tr>
												<td align="center" class="title" height="25">&nbsp;<?php echo($count); ?>. </td>
												<td align="center"><?php echo(ucwords($brand_name)); ?></td>
												<td align="center"><?php echo($city); ?></td>
												<td align="left">&nbsp;<?php echo(ucwords($store_name)); ?></td>
												<td align="left">&nbsp;<?php echo(ucwords($store_supervisor)); ?></td>
												<td align="left">&nbsp;<?php echo(ucwords($fullname)." :BA-".$ba_no); ?></td>
												
												
												<td align="center"><?php echo($bank_iban); ?></td>
												<td align="center"><?php echo($mobileno); ?></td>
												<td align="center"><?php echo($area); ?></td>
												<td align="left">&nbsp;<?php echo($address); ?></td>
												<td align="left">&nbsp;<?php echo(ucwords($username)); ?></td>	
											</tr>
											</tbody>
												<?php			
														}
													}	
												}											
												if($count == 0)
												{
											?>
											<tr>
												<td align="center" colspan="8"><span style="color:red; font-weight:bold;">No Records Found!</span></td>
											</tr>
											<?php
												}
											?>
								</table>
								<div class="box-title">
								<div align="left" class="col-sm-6"><h6><b>Report Name:</b> BA Data Report</h6></div>
								<div align="right" class="col-sm-6"><h6><b>Printed By:</b> <?php echo($UserFullName); ?> <b>On</b> <?php echo(date("F d, Y h:i A")); ?> </h6></div>
							</div>
							</div>


						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</body>

</html>