<?php
	include("includes/functions.php");
	include("includes/session.php");
	include("includes/errors.php");
	chk_login1($db,$URL);
?>
<!doctype html>
<html>

<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
	<!-- Apple devices fullscreen -->
	<meta name="apple-mobile-web-app-capable" content="yes" />
	<!-- Apple devices fullscreen -->
	<meta names="apple-mobile-web-app-status-bar-style" content="black-translucent" />

	<title>Sentient - BA Attendance Report</title>

	<!-- Bootstrap -->
	<link rel="stylesheet" href="css/bootstrap.min.css">
	<!-- jQuery UI -->
	<link rel="stylesheet" href="css/plugins/jquery-ui/jquery-ui.min.css">
	<!-- dataTables -->
	<link rel="stylesheet" href="css/plugins/datatable/TableTools.css">
	<!-- chosen -->
	<link rel="stylesheet" href="css/plugins/chosen/chosen.css">
	<!-- Theme CSS -->
	<link rel="stylesheet" href="css/style.css">
	<!-- Color CSS -->
	<link rel="stylesheet" href="css/themes.css">

	<!-- jQuery -->
	<script src="js/jquery.min.js"></script>

	<!-- Nice Scroll -->
	<script src="js/plugins/nicescroll/jquery.nicescroll.min.js"></script>
	<!-- imagesLoaded -->
	<script src="js/plugins/imagesLoaded/jquery.imagesloaded.min.js"></script>
	<!-- jQuery UI -->
	<script src="js/plugins/jquery-ui/jquery-ui.js"></script>
	<!-- slimScroll -->
	<script src="js/plugins/slimscroll/jquery.slimscroll.min.js"></script>
	<!-- Bootstrap -->
	<script src="js/bootstrap.min.js"></script>
	<!-- Bootbox -->
	<script src="js/plugins/bootbox/jquery.bootbox.js"></script>
	<!-- New DataTables -->
	<script src="js/plugins/momentjs/jquery.moment.min.js"></script>
	<script src="js/plugins/momentjs/moment-range.min.js"></script>
	<script src="js/plugins/datatables/jquery.dataTables.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.tableTools.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.colReorder.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.colVis.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.scroller.min.js"></script>

	<!-- Chosen -->
	<script src="js/plugins/chosen/chosen.jquery.min.js"></script>

	<!-- Theme framework -->
	<script src="js/eakroko.min.js"></script>
	<!-- Theme scripts -->
	<script src="js/application.min.js"></script>
	<!-- Just for demonstration -->
	<script src="js/demonstration.min.js"></script>

	<!--[if lte IE 9]>
		<script src="js/plugins/placeholder/jquery.placeholder.min.js"></script>
		<script>
			$(document).ready(function() {
				$('input, textarea').placeholder();
			});
		</script>
	<![endif]-->

	<!-- Favicon -->
	<link rel="shortcut icon" href="img/favicon.png" />
	<!-- Apple devices Homescreen icon -->
	<link rel="apple-touch-icon-precomposed" href="img/apple-touch-icon-precomposed.png" />

</head>

<body>
	<div class="container-fluid nav-hidden" id="content">
		<div id="main">
			<div class="container-fluid">
				
				
				<div class="row">
					<div class="col-sm-12">
						<div class="box">
							
							<div class="box-content">
								<div class="invoice-info">
									
									<div class="invoice-from">
										<br>
										<img src="images/sentient_logo.jpg" width="125">
								
										<address>
											Sentient
											<br>Lahore
											
										</address>
									</div>
									
									<div class="invoice-infos">
										<h1>BA Attendance Report</h1>
										<?php
											$from_date_timestamp = strtotime($_REQUEST['fromdate']);
											$to_date_timestamp = strtotime($_REQUEST['todate']) + 86399;

											$from_date = date("d-m-Y",$from_date_timestamp);
											$to_date = date("d-m-Y",$to_date_timestamp);

											$datediff = $to_date_timestamp - $from_date_timestamp;

											$num_days = round($datediff / (60 * 60 * 24));


											$q1 = "WHERE UA.uatdate BETWEEN $from_date_timestamp AND $to_date_timestamp";

											if($_REQUEST['city'] != 0)
											{
												$stcity = $_REQUEST['city'];
												$q2 = "AND ST.city = '$stcity'";

											}
											else{
												$stcity = "All";
												$q2 = "";
											}

											if($_REQUEST['brid'] != 0)
											{
												$brid = $_REQUEST['brid'];
												$q3 = "AND BR.brid = $brid";
												$brquery = $db->prepare("SELECT brid, brname FROM brand WHERE brid=?");
												$brquery->execute(array($brid));
												while($brrow = $brquery->fetch())
												{
													$brand = $brrow['brname'];
												}

											}
											else{
												$brid = 0;
												$q3 = "";
												$brand = "All";
											}

											if($_REQUEST['stcid'] != 0 && $_REQUEST['stcid'] != "")
											{
												$store_chain = $_REQUEST['stcid'];


												/*echo("'".str_replace(",","','",$stcity)."'");
												echo("<br>");
												$temp = array(0,1);
						*/
												$st_store_chain= "'".str_replace(",","','",$store_chain)."'";										
												//$result = "'" . implode ( "', '", $temp ) . "'";

												//echo($result);
												$q4 = "AND ST.chain_store IN ($st_store_chain)";

											}
											else{
												$store_chain = "All";
												$q4 = "";
											}
											if($_REQUEST['id'] != 0)
											{
												$supid = $_REQUEST['id'];
												$supquery = $db->prepare("SELECT uid, su_no, fullname FROM users WHERE uid=?");
												$supquery->execute(array($supid));
												while($suprow = $supquery->fetch())
												{
													$supervisor = $suprow['fullname'].": SU-".$suprow['su_no'];
												}
												$q5 = "AND ASS.supuid = '$supid'";

											}
											else{
												$supid = 0;
												$supervisor = "All";
												$q5 = "";
											}
											if($_REQUEST['uid'] != 0)
											{
												$ba_uid = $_REQUEST['uid'];
												$uquery = $db->prepare("SELECT uid, ba_no, fullname FROM users WHERE uid=?");
												$uquery->execute(array($ba_uid));
												while($urow = $uquery->fetch())
												{
													$ba_name = $urow['fullname'].": BA-".$urow['ba_no'];
												}
												$q6 = "AND ASS.uid = $ba_uid";
												$q61 = "AND uid = $ba_uid";
												$q62 = "AND UAT.uid = $ba_uid";
											}
											else{
												$ba_uid = 0;
												$ba_name = "All";
												$q6 = "";
												$q61 = "";
												$q62 = "";
											}
										?>
										<table>
											<tr><td>&nbsp;</td></tr>
											<tr><td align="left"><b>From Date: <?php echo($from_date); ?></b></td></tr>
											<tr><td align="left"><b>To Date: <?php echo($to_date); ?></b></td></tr>
											<tr><td align="left"><b>Brand: <?php echo($brand); ?></b></td></tr>	
											<tr><td align="left"><b>City: <?php echo($stcity); ?></b></td></tr>
											<tr><td align="left"><b>Supervisor: <?php echo($supervisor); ?></b></td></tr>
											<tr><td align="left"><b>Chain Store: <?php echo($store_chain); ?></b></td></tr>
											<tr><td align="left"><b>BA: <?php echo($ba_name); ?></b></td></tr>
										</table>
									</div>
								</div>
								<table class="table table-hover table-nomargin table-bordered" data-nosearch data-nopagination data-noinfo>
									<thead>
										<tr>
											<th style="background-color: black; color: white;"><span class="title-font">Sr</span></th>
											<th style="background-color: black; color: white;"><span class="title-font">Brand</span></th>
											<th style="background-color: black; color: white;"><span class="title-font">&nbsp;Store Name</span></th>
											<th style="background-color: black; color: white;"><span class="title-font">&nbsp;BA Name</span></th>
											<th style="background-color: yellow;"><span class="title-font1" style="color: black;">Total Days</span></th>
											<th style="background-color: yellow;"><span class="title-font1" style="color: black;">Total Days</span></th>
											<th style="background-color: yellow;"><span class="title-font1" style="color: black;">Absent</span></th>
											<th style="background-color: yellow;"><span class="title-font1" style="color: black;">Leave</span></th>
											<th style="background-color: yellow;"><span class="title-font1" style="color: black;">WO</span></th>
											<?php
												$uat_query = $db->prepare("SELECT * FROM user_attendance WHERE uatdate BETWEEN $from_date_timestamp AND $to_date_timestamp $q61 GROUP BY attendance_date");
												$uat_query->execute();
												while($uatrow = $uat_query->fetch())
												{
													$att_date1 = date("d", strtotime($uatrow['attendance_date']));
													$att_date2 = date("D", strtotime($uatrow['attendance_date']));
											?>
											<th align="center" style="background-color: navy; color: white;" height="15">
												<span class="title-font">
													<?php echo("&nbsp;&nbsp;".$att_date1."&nbsp;&nbsp;<br>".$att_date2); ?>
												</span>
											</th>
											<?php
												}
											?>
										</tr>
										
									</thead>
									<tbody>
										<?php
												$count = 0;
												$titlecount = 0;
												$uaquery = $db->prepare("SELECT * FROM assignment_sale ASS 
																	INNER JOIN assignments ASA ON ASS.asid = ASA.asid 
																	INNER JOIN users U ON ASS.uid = U.uid 
																	INNER JOIN store ST ON ASA.stid = ST.stid 
																	INNER JOIN brand BR ON ASS.brid = BR.brid WHERE ASS.asid <> 0 $q2 $q3 $q4 $q5 $q6 
																	 GROUP BY ASS.asid ORDER BY BR.brname ASC");
												$uaquery->execute();
												while($uarow = $uaquery->fetch())
												{
													$titlecount++;
													$uid = $uarow['uid'];
													$asid = $uarow['asid'];
													$ba_no = $uarow['ba_no'];
													$fullname = $uarow['fullname'];
													$brand_name = $uarow['brname'];
													$store_name = $uarow['store_name'];
													$store_city = $uarow['city'];
													//$doj = date("d-m-Y",$uarow['udate']);

													/// total Present
													$uaquery1 = $db->prepare("SELECT uid, asid, timein, uatvalue, uatdate FROM user_attendance WHERE (uatvalue = 'P' OR timein <> 0) AND uatvalue <> 'A' AND asid = $asid  AND uatdate BETWEEN $from_date_timestamp AND $to_date_timestamp");
													$uaquery1->execute();
													$total_present = $uaquery1->rowCount();

													/// total Absent
													$uaquery2 = $db->prepare("SELECT asid, timein, uatvalue, uatdate FROM user_attendance WHERE asid = $asid AND uatvalue = 'A' AND uatdate BETWEEN $from_date_timestamp AND $to_date_timestamp");
													$uaquery2->execute();
													$ba_absent = $uaquery2->rowCount();

													/// total Leave
													$uaquery3 = $db->prepare("SELECT asid, timein, uatvalue, uatdate FROM user_attendance WHERE asid = $asid AND uatvalue = 'L' AND uatdate BETWEEN $from_date_timestamp AND $to_date_timestamp");
													$uaquery3->execute();
													$total_leave = $uaquery3->rowCount();

													/// total WO
													$uaquery4 = $db->prepare("SELECT asid, timein, uatvalue, uatdate FROM user_attendance WHERE asid = $asid AND uatvalue = 'WO' AND uatdate BETWEEN $from_date_timestamp AND $to_date_timestamp");
													$uaquery4->execute();
													$total_wo = $uaquery4->rowCount();

													/// No Record  = total Absent
													$uaquery4a = $db->prepare("SELECT asid, timein, uatvalue, uatdate FROM user_attendance WHERE asid = $asid AND timein = 0 AND uatvalue = ' ' AND uatdate BETWEEN $from_date_timestamp AND $to_date_timestamp");
													$uaquery4a->execute();
													$ba_absent4a = $uaquery4a->rowCount();

													$total_absent = $ba_absent + $ba_absent4a;

													if($titlecount == 51)
													{
														$titlecount = 0;
											?>
											<tr class="title">
												<td align="center" style="background-color: black;" height="40">&nbsp;<span class="title-font">Sr No</span></td>
												<td align="center" style="background-color: black;" height="15"><span class="title-font">Brand</span></td>
												<td align="left" style="background-color: black;" height="15"><span class="title-font">&nbsp;Store Name</span></td>
												<td align="left" style="background-color: black;" height="15">&nbsp;<span class="title-font">&nbsp;BA Name</span></td>
												<td align="center" style="background-color: yellow;" height="15"><span class="title-font1" style="color: black;">Total Days</span></td>
												<td align="center" style="background-color: yellow;" height="15"><span class="title-font1" style="color: black;">Total Present</span></td>
												<td align="center" style="background-color: yellow;" height="15"><span class="title-font1" style="color: black;">Absent</span></td>
												<td align="center" style="background-color: yellow;" height="15"><span class="title-font1" style="color: black;">Leave</span></td>
												<td align="center" style="background-color: yellow;" height="15"><span class="title-font1" style="color: black;">WO</span></td>
												<?php
													$uat_query = $db->prepare("SELECT * FROM user_attendance WHERE uatdate BETWEEN $from_date_timestamp AND $to_date_timestamp $q61 GROUP BY attendance_date");
													$uat_query->execute();
													while($uatrow = $uat_query->fetch())
													{
														$att_date1 = date("d", strtotime($uatrow['attendance_date']));
														$att_date2 = date("D", strtotime($uatrow['attendance_date']));
												?>
												<td align="center" style="background-color: navy;" height="15"><span class="title-font">
													<?php echo("&nbsp;&nbsp;".$att_date1."&nbsp;&nbsp;<br>".$att_date2); ?>
														
													</span></td>
												<?php
													}
												?>
											</tr>
											<?php			
													}
													else
													{
														$count++;
											?>
											<tr>
												<td align="center" class="title" height="25">&nbsp;<?php echo($count); ?>. </td>
												<td align="center"><?php echo($brand_name); ?></td>
												<td align="left">&nbsp;<?php echo($store_name."<br>&nbsp;".$store_city); ?></td>
												<td align="left">
												<?php
													$bg_color = array('cr1' => '#FFE5E5');


													$uacount = 0;
													$uaquery5 = $db->prepare("SELECT UAT.uid, UAT.asid, UAT.timein, UAT.uatcode, UAT.uatvalue, UAT.uatdate, U.uid, U.ba_no, U.fullname FROM user_attendance UAT INNER JOIN users U ON UAT.uid = U.uid WHERE UAT.asid = $asid  AND UAT.uatdate BETWEEN $from_date_timestamp AND $to_date_timestamp $q62 GROUP BY UAT.uid");
													$uaquery5->execute();
													while($uarow5 = $uaquery5->fetch())
													{
														$uacount++;
														$ba_uid = $uarow5['uid'];
														$ba_no = $uarow5['ba_no'];
														$ba_uatcode = $uarow5['uatcode'];

														if($uacount == 1){ $bg_color[$ba_uid] = "#CDF5FD"; }
														elseif ($uacount == 2) { $bg_color[$ba_uid] = "#CBFFA9"; }
														elseif ($uacount == 3) { $bg_color[$ba_uid] = "#FFE5E5"; }
														elseif ($uacount == 4) { $bg_color[$ba_uid] = "#F9F7C9"; }
														elseif ($uacount == 5) { $bg_color[$ba_uid] = "#E3DFFD"; }
                                                        elseif ($uacount == 6) { $bg_color[$ba_uid] = "#FECE88"; }
                                                        
														echo("&nbsp;<span style='background-color:".$bg_color[$ba_uid].";'>".$uarow5['fullname']."</span><br>");
												?>

												<?php } ?>
												</td>
												<td align="center" bgcolor="#ffffc5"><?php echo($num_days); ?></td>
												<td align="center" bgcolor="#ffffc5"><?php echo($total_present); ?></td>
												<td align="center" <?php if($total_absent > 2){ ?> style="background-color: lightpink;" <?php }else{ ?> bgcolor="#ffffc5" <?php } ?>><?php echo($total_absent); ?></td>
												<td align="center" bgcolor="#ffffc5"><?php echo($total_leave); ?></td>
												<td align="center" bgcolor="#ffffc5"><?php echo($total_wo); ?></td>

												<?php
													$uat_query1 = $db->prepare("SELECT * FROM user_attendance WHERE uatdate BETWEEN $from_date_timestamp AND $to_date_timestamp GROUP BY attendance_date");
													$uat_query1->execute();
													while($uatrow1 = $uat_query1->fetch())
													{
														$attendance_date = $uatrow1['attendance_date'];

														$uat_query2 = $db->prepare("SELECT * FROM user_attendance WHERE asid = $asid AND attendance_date = '$attendance_date' $q61");
														$uat_query2->execute();
														if($uat_query2->rowCount() == 0)
														{
															$ua_record = "&nbsp;";
														}
														else
														{
															while($uatrow2 = $uat_query2->fetch())
															{
																$uatid = $uatrow2['uatid'];
																$uat_uid = $uatrow2['uid'];
																$uat_code = $uatrow2['uatcode'];
																
																if($uatrow2['timein'] != 0)
																{
																	if($uatrow2['uatvalue'] != " " && $uatrow2['uatvalue'] != "")
																	{
																		if($uatrow2['uatvalue'] == "A"){ $ua_record = "<span style='color: red;'>A</span>"; }
																		else{ $ua_record = $uatrow2['uatvalue']; }
																	}
																	else
																	{
																		$ua_record = "<span style='color: darkgreen;'>P</span>";	
																	}	
																		
																}
																else
																{
																	if($uatrow2['timein'] == 0)
																	{
																		if($uatrow2['uatvalue'] != "")
																		{
																			if($uatrow2['uatvalue'] == "A"){ $ua_record = "<span style='color: red;'>A</span>"; }
																			elseif($uatrow2['uatvalue'] == "P"){ $ua_record = "<span style='color: darkgreen;'>P</span>"; }
																			else{
																				$ua_record = $uatrow2['uatvalue'];	
																			}
																			
																		}
																		else
																		{
																			$ua_record = "<span style='color: red;'>A</span>";	
																		}
																	}
																}

																if($uatrow2['timein'] == 0 && $uatrow2['uatvalue'] == " ")
																{
																	$ua_record = "<span style='color: red;'>A</span>";
																}
															}	
														}
												?>
												<td align="center" <?php if($ua_record !="&nbsp;"){ ?> style="background-color:<?php echo($bg_color[$uat_uid]); ?>;" <?php } ?> >
													<?php  ?>
													<?php
														if(isset($uat_code))
														{
															echo($ua_record);
															if($uat_code != " ")
															{
																echo("<br><span style='font-size:10px'>".$uat_code."</span>"); 
															}	
														}
													?>
													
														
												</td>
												<?php
													}
												?>
											</tr>
											<?php
												}
											}	
											?>
									</tbody>
								</table>
								<div class="box-title">
								<div align="left" class="col-sm-6"><h6><b>Report Name:</b> BA Data Report</h6></div>
								<div align="right" class="col-sm-6"><h6><b>Printed By:</b> <?php echo($UserFullName); ?> <b>On</b> <?php echo(date("F d, Y h:i A")); ?> </h6></div>
							</div>
							</div>


						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</body>

</html>