<?php
	include("includes/functions.php");
	include("includes/session.php");
	include("includes/errors.php");
	chk_login();

	if($UserPendingInvoice == 0) { header("Location: main.php"); }
	chk_booking_amenity($db,$URL);

	/////////// Function to Create Pending Invoices On Every 1st of the Month 3:00 AM /////////
	/*
	$subquery = $db->prepare("SELECT * FROM subscriptions WHERE aid = ? AND subid = ? AND substatus = ? AND  subarchived = ?");
	$subquery->execute(array(23,26,0,0));
	while($subrow = $subquery->fetch())
	{
		$Date = time();
		$remarks = "Membership Invoice for the Month of ".date("F, Y")."";
		$aid   = $subrow['aid'];
		$subid 	= $subrow['subid'];

		$printlimit 	  = $subrow['printlimit'];
		$printrate 	 	  = $subrow['printrate'];

		$generatorlimit   = $subrow['generatorlimit'];
		$generatorrate    = $subrow['generatorrate'];	

		$electricitylimit = $subrow['electricitylimit'];
		$electricityrate  = $subrow['electricityrate'];	

		$gaslimit 		  = $subrow['gaslimit'];
		$gasrate 		  = $subrow['gasrate'];	

		$pending_invoice = $db->prepare("SELECT * FROM pending_invoices WHERE aid=? AND subid=? AND remarks=?");
		$pending_invoice->execute(array($aid,$subid,$remarks));
		$num_pending_invoice = $pending_invoice->rowCount();

		$member_invoice = $db->prepare("SELECT * FROM invoices WHERE aid=? AND subid=? AND remarks=?");
		$member_invoice->execute(array($aid,$subid,$remarks));
		$num_member_invoice = $member_invoice->rowCount();

		if($num_pending_invoice == 0 && $num_member_invoice == 0)
		{
			$invquery = $db->prepare("INSERT INTO pending_invoices(aid, subid, remarks, pinvdate) VALUES(?,?,?,?)");
			$inv_values = array($aid,$subid,$remarks,$Date);
			if($invquery->execute($inv_values))
			{
				$pinvid = $db->lastInsertId();

				//// Total Active Additional Members ////
				$smquery = $db->prepare("SELECT * FROM submembers WHERE smname <> '' AND smarchived = 0 AND smstatus = 0 AND subid=$subid");
				$smquery->execute();
				$num_members = $smquery->rowCount(); // Note: All Addtional Members whos name are entered and there status and archived status is active will be counted in the invoice 

				$unitprice = $subrow['subunitprice'];
				$totalprice = $num_members * $unitprice;
				//////////////////////////////////////////

				echo("Total Members: $num_members x $unitprice = $totalprice <br><br>");

				/// Total Memebers Entry
				
				$total_members_entry = "Total Members: $num_members x $unitprice = $totalprice";
				
				$invdquery1 = $db->prepare("INSERT INTO pending_invoicedetail(pinvid,invdetail,invprice,invqty,invtotalprice,pinvdate) VALUES(?,?,?,?,?,?)");
				$invdvalues1 = array($pinvid,$total_members_entry,$unitprice,$num_members,$totalprice,$Date);
				$invdquery1->execute($invdvalues1);

				//// Calculate Total Hours & Extra Price for Extra Hrs for Conference & Meeting Rooms ////

				$conquery = $db->prepare("SELECT aid,subid,slid,SUM(amvalue) total_qty FROM amenity_log WHERE slid <> ? AND aid=? AND subid=? AND is_charged=? GROUP BY slid");
				$conquery->execute(array(0,$aid,$subid,0));
				while($conrow = $conquery->fetch())
				{
					$slid 	   = $conrow['slid'];
					$total_qty = $conrow['total_qty'];

					///  Convert extra units to Hrs & Mins ///
					$total_seconds = $total_qty * 3600;

                    $total_days = floor($total_seconds / 86400);
                    $total_seconds %= 86400;

                    $total_hours = floor($total_seconds / 3600);
                    $total_seconds %= 3600;

                    $total_minutes = floor($total_seconds / 60);
                    $total_seconds %= 60;

                    $total_time = str_pad($total_hours, 2, "0", STR_PAD_LEFT).":".str_pad($total_minutes, 2, "0", STR_PAD_LEFT);
                    ////////////////////////////////////////////

					$subslquery = $db->prepare("SELECT * FROM subslots SS INNER JOIN slots S ON SS.slid = S.slid WHERE SS.slid=? AND SS.aid=? AND SS.subid=?");
					$subslquery->execute(array($slid,$aid,$subid));
					while($subslrow = $subslquery->fetch())
					{
						$sltitle = $subslrow['sltitle'];
						$sublimit = $subslrow['subsllimit'];
						$subrate  = $subslrow['subslrate'];
					}

					if($total_qty > $sublimit)
					{
						$extra_hrs = $total_qty - $sublimit;
						$extra_amount = round($subrate * $extra_hrs);

						if(strlen(substr(strrchr($extra_hrs, "."), 1)) != 0) { $extra_hrs = str_replace(",","",number_format($extra_hrs,2)); } else{ $extra_hrs = $extra_hrs; }
						//if(strlen(substr(strrchr($extra_amount, "."), 1)) != 0) { $extra_amount = str_replace(",","",number_format($extra_amount,2)); } else{ $extra_amount = $extra_amount; }

						///  Convert extra units to Hrs & Mins ///
						$extra_seconds = $extra_hrs * 3600;

	                    $extra_days = floor($extra_seconds / 86400);
	                    $extra_seconds %= 86400;

	                    $extra_hours = floor($extra_seconds / 3600);
	                    $extra_seconds %= 3600;

	                    $extra_minutes = floor($extra_seconds / 60);
	                    $extra_seconds %= 60;

	                    $extra_time = str_pad($extra_hours, 2, "0", STR_PAD_LEFT).":".str_pad($extra_minutes, 2, "0", STR_PAD_LEFT);
	                    ////////////////////////////////////////////

						// echo("$sltitle : Rate = $subrate  ||  Limit = $sublimit || Consumed = $total_qty || $total_qty - $sublimit = $extra_hrs * $subrate = $extra_amount <br><br>");

						/// Total Conference & Meeting Room Hrs Entry ///
						$hrs_detail = "$sltitle : Rate = $subrate  ||  Limit = ".str_pad($sublimit, 2, "0", STR_PAD_LEFT).":00 || Consumed = $total_time || $total_time - ".str_pad($sublimit, 2, "0", STR_PAD_LEFT).":00 = $extra_time";
						$invdquery2 = $db->prepare("INSERT INTO pending_invoicedetail(pinvid,invdetail,invprice,invqty,invtotalprice,pinvdate) VALUES(?,?,?,?,?,?)");
						$invdvalues2 = array($pinvid,$hrs_detail,$subrate,$extra_hrs,$extra_amount,$Date);
						$invdquery2->execute($invdvalues2);
					}
				}

				////////////////////////////////////////////////////////////////////////////////
			
				//// Calculate Total Printing & Generator Hrs & Prices ////
				
				$prquery = $db->prepare("SELECT amtype,aid,subid,SUM(amvalue) total_qty FROM amenity_log WHERE amtype IN (?,?,?,?) AND aid=? AND subid=? AND is_charged=? GROUP BY amtype");
				$prquery->execute(array(1,4,5,6,$aid,$subid,0));
				while($prrow = $prquery->fetch())
				{
					$total_qty = $prrow['total_qty'];

					if($prrow['amtype'] == 1)
					{
						$amtype = "Paper Printing";
						if($total_qty > $printlimit)
						{
							$extra_prints       = $total_qty - $printlimit;
							$extra_print_amount = $printrate * $extra_prints;
							
							echo("$amtype: Rate: $printrate || Limit: $printlimit || Consumed: $total_qty || $total_qty - $extra_prints * $printrate = $extra_print_amount <br><br>");	

							/// Total Print Entry ///
							$print_detail = "$amtype: Rate: $printrate || Limit: $printlimit || Consumed: $total_qty || $total_qty - $extra_prints * $printrate = $extra_print_amount";
							$invdquery3   = $db->prepare("INSERT INTO pending_invoicedetail(pinvid,invdetail,invprice,invqty,invtotalprice,pinvdate) VALUES(?,?,?,?,?,?)");
							$invdvalues3  = array($pinvid,$print_detail,$printrate,$extra_prints,$extra_print_amount,$Date);
							$invdquery3->execute($invdvalues3);
						}
					}
					if($prrow['amtype'] == 4)
					{
						$amtype = "Generator";

						if($total_qty > $generatorlimit)
						{
							$extra_hrs        = $total_qty - $generatorlimit;
							$extra_hrs_amount = $generatorrate * $extra_hrs;
							
							echo("$amtype: Rate: $generatorrate || Limit: $generatorlimit || Consumed: $total_qty || $total_qty - $extra_hrs * $generatorrate = $extra_hrs_amount <br><br>");

							/// Total Generator Entry ///
							$generator_detail = "$amtype: Rate: $generatorrate || Limit: $generatorlimit || Consumed: $total_qty || $total_qty - $extra_hrs * $generatorrate = $extra_hrs_amount";
							$invdquery4   = $db->prepare("INSERT INTO pending_invoicedetail(pinvid,invdetail,invprice,invqty,invtotalprice,pinvdate) VALUES(?,?,?,?,?,?)");
							$invdvalues4  = array($pinvid,$generator_detail,$generatorrate,$extra_hrs,$extra_hrs_amount,$Date);
							$invdquery4->execute($invdvalues4);	
						}
					}
					if($prrow['amtype'] == 5)
					{
						$amtype = "Electricity";

						if($total_qty > $electricitylimit)
						{
							$extra_hrs        = $total_qty - $electricitylimit;
							$extra_hrs_amount = $electricityrate * $extra_hrs;
							
							echo("$amtype: Rate: $electricityrate || Limit: $electricitylimit || Consumed: $total_qty || $total_qty - $extra_hrs * $electricityrate = $extra_hrs_amount <br><br>");

							/// Total Electricity Entry ///
							$electricity_detail = "$amtype: Rate: $electricityrate || Limit: $electricitylimit || Consumed: $total_qty || $total_qty - $extra_hrs * $electricityrate = $extra_hrs_amount";
							$invdquery5   = $db->prepare("INSERT INTO pending_invoicedetail(pinvid,invdetail,invprice,invqty,invtotalprice,pinvdate) VALUES(?,?,?,?,?,?)");
							$invdvalues5  = array($pinvid,$electricity_detail,$electricityrate,$extra_hrs,$extra_hrs_amount,$Date);
							$invdquery5->execute($invdvalues5);	
						}
					}
					if($prrow['amtype'] == 6)
					{
						$amtype = "Gas";

						if($total_qty > $gaslimit)
						{
							$extra_hrs        = $total_qty - $gaslimit;
							$extra_hrs_amount = $gasrate * $extra_hrs;
							
							echo("$amtype: Rate: $gasrate || Limit: $gaslimit || Consumed: $total_qty || $total_qty - $extra_hrs * $gasrate = $extra_hrs_amount <br><br>");

							/// Total Gas Entry ///
							$gas_detail = "$amtype: Rate: $gasrate || Limit: $gaslimit || Consumed: $total_qty || $total_qty - $extra_hrs * $gasrate = $extra_hrs_amount";
							$invdquery6   = $db->prepare("INSERT INTO pending_invoicedetail(pinvid,invdetail,invprice,invqty,invtotalprice,pinvdate) VALUES(?,?,?,?,?,?)");
							$invdvalues6  = array($pinvid,$gas_detail,$gasrate,$extra_hrs,$extra_hrs_amount,$Date);
							$invdquery6->execute($invdvalues6);	
						}
					}
				}

				////////////////////////////////////////////////////////////////////////////////
			
				//// Calculate Total Of Invoice and update to Pending Invoice ////

				$spquery = $db->prepare("SELECT pinvid,SUM(invtotalprice) AS total_amount FROM pending_invoicedetail WHERE pinvid = ?");
				$spquery->execute(array($pinvid));
				while($sprow = $spquery->fetch())
				{
					$total_amount = $sprow['total_amount'];
				}

				$uquery = $db->prepare("UPDATE pending_invoices SET totalamount=? WHERE pinvid=?");
				$uquery->execute(array($total_amount,$pinvid));

				/// Update Amenity Log Status to Charged (Add to pending Invoice) //// 

				$uquery = $db->prepare("UPDATE amenity_log SET is_charged=? WHERE aid=? AND subid=? AND is_charged=?");
				$uquery->execute(array(1,$aid,$subid,0));
				die;
			}
		}
	}
	*/
?>
<!doctype html>
<html>
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
	<!-- Apple devices fullscreen -->
	<meta name="apple-mobile-web-app-capable" content="yes" />
	<!-- Apple devices fullscreen -->
	<meta names="apple-mobile-web-app-status-bar-style" content="black-translucent" />

	<title>Sentient - Pending Invoice</title>

	<!-- Bootstrap -->
	<link rel="stylesheet" href="css/bootstrap.min.css">
	<!-- jQuery UI -->
	<link rel="stylesheet" href="css/plugins/jquery-ui/jquery-ui.min.css">
	<!-- dataTables -->
	<link rel="stylesheet" href="css/plugins/datatable/TableTools.css">
	<!-- chosen -->
	<link rel="stylesheet" href="css/plugins/chosen/chosen.css">
	<!-- Theme CSS -->
	<link rel="stylesheet" href="css/style.css">
	<!-- Color CSS -->
	<link rel="stylesheet" href="css/themes.css">

	<!-- jQuery -->
	<script src="js/jquery.min.js"></script>

	<!-- Nice Scroll -->
	<script src="js/plugins/nicescroll/jquery.nicescroll.min.js"></script>
	<!-- imagesLoaded -->
	<script src="js/plugins/imagesLoaded/jquery.imagesloaded.min.js"></script>
	<!-- jQuery UI -->
	<script src="js/plugins/jquery-ui/jquery-ui.js"></script>
	<!-- slimScroll -->
	<script src="js/plugins/slimscroll/jquery.slimscroll.min.js"></script>
	<!-- Bootstrap -->
	<script src="js/bootstrap.min.js"></script>
	<!-- Bootbox -->
	<script src="js/plugins/bootbox/jquery.bootbox.js"></script>
	<!-- New DataTables -->
	<script src="js/plugins/momentjs/jquery.moment.min.js"></script>
	<script src="js/plugins/momentjs/moment-range.min.js"></script>
	<script src="js/plugins/datatables/jquery.dataTables.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.tableTools.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.colReorder.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.colVis.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.scroller.min.js"></script>

	<!-- Chosen -->
	<script src="js/plugins/chosen/chosen.jquery.min.js"></script>

	<!-- Theme framework -->
	<script src="js/eakroko.min.js"></script>
	<!-- Theme scripts -->
	<script src="js/application.min.js"></script>
	<!-- Just for demonstration -->
	<script src="js/demonstration.min.js"></script>
	<!--[if lte IE 9]>
	<script src="js/plugins/placeholder/jquery.placeholder.min.js"></script>
	<script>
		$(document).ready(function () {
			$('input, textarea').placeholder();
		});
	</script>
	<![endif]-->

	<!-- Favicon -->
	<link rel="shortcut icon" href="../img/favicon.png" />
	<!-- Apple devices Homescreen icon -->
	<link rel="apple-touch-icon-precomposed" href="img/apple-touch-icon-precomposed.png" />
	<script type="text/javascript" language="javascript">
		function PrintInvoice(pinvid)
		{
			window.open( "print_pending_invoice.php?pinvid="+pinvid , "myWindow", "status = 1, scrollbars=1, height = 650, WIDTH= 900, resizable = 1, top = 0" )
		}
		function DeleteInvoice(pinvid)
		{
			var cd;
			cd = confirm("Are you sure to delete?");
			if(cd)
			{
				window.location.href = "delete_pending_invoice.php?pinvid="+pinvid;
			}
		}
	</script>
</head>
<body class='theme-grey'>
<!-- HEADER START -->
<?php include("top.php"); ?>
<!-- HEADER END -->
<div class="container-fluid" id="content">
<div id="left">
	<form action="search-results.php" method="GET" class='search-form'>
		<div class="search-pane">
			<input type="text" name="search" placeholder="Search here...">
			<button type="submit">
				<i class="fa fa-search"></i>
			</button>
		</div>
	</form>
	<!-- QUICK LINKS -->
	<?php include("left.php"); ?>
	<!-- QUICK LINKS -->
</div>
<div id="main">
<div class="container-fluid">
<div class="page-header">
	<div class="pull-left">
		<h1><i class="fa fa-table"></i> Manage Pending Invoices</h1>
	</div>
	<div class="pull-right">
	</div>
</div>
<div class="breadcrumbs">
	<ul>
		<li>
			<a href="main.php">Home</a>
			<i class="fa fa-angle-right"></i>
		</li>
		<li>
			<a href="pending_invoices.php">Pending Invoice</a>
			<i class="fa fa-angle-right"></i>
		</li>
	</ul>
	<div class="close-bread">
		<a href="#">
			<i class="fa fa-times"></i>
		</a>
	</div>
</div>
<?php
	if(isset($_REQUEST['err']))
	{
?>
<div class="alert alert-success alert-dismissable">
	<button type="button" class="close" data-dismiss="alert">&times;</button>
	<?php echo($ErrMsg); ?>
</div>
<?php
	}
?>	
<div class="row">
	<div class="col-sm-12">
		<div class="box box-color box-bordered">
			<div class="box-title">
				<h3>Pending Invoices</h3>
			</div>
			<div class="box-content nopadding hscroll">
				<table class="table table-hover table-nomargin table-bordered dataTable">
					<thead>
					<tr>
						<th>Sr.</th>
						<th>Pending Invoice</th>
						<th>Membership</th>
						<th align="center" class='hidden-350'>Date</th>
						<th align="center" class='hidden-350'>Total Amount</th>
						<th align="center" class='hidden-350'>Status</th>
						<th class='hidden-480'>Options</th>
					</tr>
					</thead>
					<tbody>
					<?php
						$count = 0;
						$query = $db->prepare("SELECT * FROM pending_invoices PI INNER JOIN accounts A ON PI.aid = A.aid INNER JOIN subscriptions S ON PI.subid = S.subid ORDER BY PI.pinvid DESC");
						$query->execute();
						while($row = $query->fetch())
						{
							$count++;
					?>
					<tr>
						<td align="center" width="50"><a href="view_pending_invoice.php?pinvid=<?php echo($row['pinvid']); ?>"><?php echo($count); ?></a></td>
						<td width="500"><a href="view_pending_invoice.php?pinvid=<?php echo($row['pinvid']); ?>">PINV-<?php echo($row['pinvid']); ?> (<?php echo($row['gtno']); ?> <?php echo($row['aname']); ?> - <?php echo($row['aemail']); ?>)</a></td>
						<td width="500"><a href="view_pending_invoice.php?pinvid=<?php echo($row['pinvid']); ?>"><?php echo($row['subgtno']); ?> <?php echo($row['subtitle']); ?></a></td>
						<td width="100" align="center" class='hidden-350'><?php echo(date("d/m/Y",$row['pinvdate'])); ?></td>
						<td width="100" align="right" class='hidden-350'>PKR <?php echo(number_format($row['totalamount'])); ?></td>
						<td width="100" align="center" class='hidden-350'>Pending</td>
						<td align="center" width="150" class='hidden-480'>
							<a href="#" class="btn" rel="tooltip" title="View" onclick="return PrintInvoice(<?php echo($row['pinvid']); ?>);">
								<i class="fa fa-file"></i>
							</a>
							<a href="view_pending_invoice.php?pinvid=<?php echo($row['pinvid']); ?>" class="btn" rel="tooltip" title="View">
								<i class="fa fa-edit"></i>
							</a>
							<a href="javascript:Void(0);" class="btn" rel="tooltip" title="Delete" onclick="return DeleteInvoice(<?php echo($row['pinvid']); ?>)">
								<i class="fa fa-times"></i>
							</a>
						</td>
					</tr>
					<?php } ?>
					</tbody>
				</table>
			</div>
		</div>
	</div>
</div>
</div>
</div>
</div>
</body>
</html>
