<?php
	include("includes/functions.php");
	include("includes/session.php");
	include("includes/errors.php");
?>
<!doctype html>
<html>

<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
	<!-- Apple devices fullscreen -->
	<meta name="apple-mobile-web-app-capable" content="yes" />
	<!-- Apple devices fullscreen -->
	<meta names="apple-mobile-web-app-status-bar-style" content="black-translucent" />

	<title>Sentient - UI Elements</title>

	<!-- Bootstrap -->
	<link rel="stylesheet" href="css/bootstrap.min.css">
	<!-- jQuery UI -->
	<link rel="stylesheet" href="css/plugins/jquery-ui/jquery-ui.min.css">
	<!-- Notify -->
	<link rel="stylesheet" href="css/plugins/gritter/jquery.gritter.css">
	<!-- Theme CSS -->
	<link rel="stylesheet" href="css/style.css">
	<!-- Color CSS -->
	<link rel="stylesheet" href="css/themes.css">


	<!-- jQuery -->
	<script src="js/jquery.min.js"></script>

	<!-- Nice Scroll -->
	<script src="js/plugins/nicescroll/jquery.nicescroll.min.js"></script>
	<!-- imagesLoaded -->
	<script src="js/plugins/imagesLoaded/jquery.imagesloaded.min.js"></script>
	<!-- jQuery UI -->
	<script src="js/plugins/jquery-ui/jquery-ui.js"></script>
	<!-- slimScroll -->
	<script src="js/plugins/slimscroll/jquery.slimscroll.min.js"></script>
	<!-- Bootstrap -->
	<script src="js/bootstrap.min.js"></script>
	<!-- Bootbox -->
	<script src="js/plugins/bootbox/jquery.bootbox.js"></script>
	<!-- Notify -->
	<script src="js/plugins/gritter/jquery.gritter.min.js"></script>

	<!-- Theme framework -->
	<script src="js/eakroko.min.js"></script>
	<!-- Theme scripts -->
	<script src="js/application.min.js"></script>
	<!-- Just for demonstration -->
	<script src="js/demonstration.min.js"></script>

	<!--[if lte IE 9]>
		<script src="js/plugins/placeholder/jquery.placeholder.min.js"></script>
		<script>
			$(document).ready(function() {
				$('input, textarea').placeholder();
			});
		</script>
		<![endif]-->

	<!-- Favicon -->
	<link rel="shortcut icon" href="../img/favicon.png" />
	<!-- Apple devices Homescreen icon -->
	<link rel="apple-touch-icon-precomposed" href="img/apple-touch-icon-precomposed.png" />

</head>

<body class='theme-grey'>
	
	<?php
	    include("top.php");
		$bquery = $db->prepare("SELECT * FROM booking B INNER JOIN accounts A ON B.aid = A.aid INNER JOIN subscriptions SUB ON B.subid = SUB.subid INNER JOIN slots SL ON B.slid = SL.slid WHERE B.btype = 1 AND B.bstatus = 0");
      	$bquery->execute();
      	while($brow = $bquery->fetch())
      	{
      		$bid  = $brow['bid'];
      		$gtno  = $brow['gtno'];
      		$customer  = $brow['aname'];
      		$email  = $brow['aemail'];
      	  	$title  = $brow['btitle'];
      	  	$subtitle  = $brow['subtitle'];
      	  	$slot  = $brow['sltitle'];
      	  	$byear  = date("Y",$brow['bookdate']);
      	  	$bmonth = date("m",$brow['bookdate']) - 1;
        	$bday   = date("d",$brow['bookdate']);

    	//  $fromtime = explode(':', $brow['btimefrom']);
    	    $fromhrs  = date("H",$brow['btimefrom']);
    	    $frommins = date("i",$brow['btimefrom']);

    	//  $totime = explode(':', $brow['btimeto']);
    	    $tohrs  = date("H",$brow['btimeto']);
    	    $tomins = date("i",$brow['btimeto']);

    	    $from  = date("h:i A",$brow['btimefrom']);
			$to    = date("h:i A",$brow['btimeto']);
	?>
	<div id="modal-<?php echo($bid); ?>" class="modal fade" role="dialog">
		<div class="modal-dialog">
			<div class="modal-content">
				<div class="modal-header">
					<button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
					<h4 class="modal-title" id="myModalLabel"><?php echo($title); ?></h4>
				</div>
				<!-- /.modal-header -->
				<div class="modal-body">
					<table width="100%" cellspacing="5" cellpadding="5">
						<tr>
							<td height="30" width="20%" align="left"><b>Customer Name</b></td>
							<td width="80%" align="left"><?php echo($gtno); ?> <?php echo($customer); ?> (<?php echo($email); ?>)</td>
						</tr>
						<tr>
							<td height="30" width="20%" align="left"><b>Membership</b></td>
							<td width="80%" align="left"><?php echo($brow['subgtno']); ?> <?php echo($subtitle); ?></td>
						</tr>
						<tr>
							<td height="30" width="20%" align="left"><b>Room #</b></td>
							<td width="80%" align="left"><?php echo($slot); ?></td>
						</tr>
						<tr>
							<td height="30" width="20%" align="left"><b>Book Date</b></td>
							<td width="80%" align="left"><?php echo(date("d-m-Y",$brow['bookdate'])); ?></td>
						</tr>
						<tr>
							<td height="30" width="20%" align="left"><b>Timings</b></td>
							<td width="80%" align="left">From: <?php echo($from); ?> To: <?php echo($to); ?></td>
						</tr>
						<tr>
							<td height="30" width="20%" align="left"><b>Num of Hrs</b></td>
							<td width="80%" align="left"><?php echo($brow['numhrs']); ?></td>
						</tr>
					</table>
				</div>
				<!-- /.modal-body -->
				<div class="modal-footer">
					<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
				</div>
				<!-- /.modal-footer -->
			</div>
			<!-- /.modal-content -->
		</div>
		<!-- /.modal-dialog -->
	</div>
	<!-- /#modal-1.modal fade -->
	<br><br>
	<p>
		<a href="#modal-<?php echo($bid); ?>" role="button" class="btn" data-toggle="modal">Open Modal <?php echo($bid); ?></a>
	</p>
	<?php } ?>
</body>
</html>