<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Page Loader with Progress Bar</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    #loader {
      position: fixed;
      z-index: 9999;
      background: white;
      width: 100%;
      height: 100%;
      display: flex;
      flex-direction: column;
      align-items: center;
      justify-content: center;
    }
    body.loaded #loader {
      opacity: 0;
      visibility: hidden;
      transition: opacity 0.5s ease-out;
    }
    .progress {
      width: 50%;
      height: 20px;
    }
  </style>
</head>
<body>

<!-- Loader -->
<div id="loader">
  <h5>Loading, please wait...</h5>
  <div class="progress mt-3">
    <div id="progress-bar" class="progress-bar progress-bar-striped progress-bar-animated bg-primary" role="progressbar" style="width: 0%"></div>
  </div>
</div>

<!-- Main Content -->
<div class="container mt-5">
  <h1 class="text-center">Welcome to My Page</h1>
  <p>This content will appear after the loader disappears.</p>
</div>

<script>
  // Simulate progress bar loading
  let progress = 0;
  const progressBar = document.getElementById('progress-bar');
  const interval = setInterval(() => {
    progress += 1;
    progressBar.style.width = progress + '%';
    if (progress >= 100) {
      clearInterval(interval);
      document.body.classList.add('loaded');
    }
  }, 30); // Adjust speed here
</script>

</body>
</html>
