<?php
	include("connect.php");
	function clean($string)
	{
	   $string = str_replace(' ', '-', $string); // Replaces all spaces with hyphens.
	   return preg_replace('/[^A-Za-z0-9\-]/', '', $string); // Removes special chars.
	}
	
	function update_ba_attendance($db,$URL,$uatid,$value)
	{
		$query = $db->prepare("UPDATE user_attendance SET uatvalue=? WHERE uatid=?");
		$values = array($value,$uatid);
		$query->execute($values);
	}
	
	function submit_supervisor_visit_log($db,$URL)
	{
	  	$at_date = date("17-08-2025");
	  	$at_timestamp = strtotime($at_date);
	  	/// check for active assignment
	    
	    $attquery = $db->prepare("SELECT uid, asid, attendance_date FROM user_attendance WHERE attendance_date = ?");
		$attquery->execute(array($at_date));
	    while($attrow = $attquery->fetch())
	    {
	        $asid = $attrow['asid'];
	        $asquery = $db->prepare("SELECT * FROM assignments WHERE asid = ?");
    	    $asquery->execute(array($asid));
    	    while($asrow = $asquery->fetch())
    	    {
    	      	$asid = $asrow['asid'];
    	      	$uid = $asrow['uid'];
    	      	$stid = $asrow['stid'];
    	      	$brid = $asrow['brid'];
    	      	$asoffday = $asrow['asoffday'];
    	      	$asstarttime = $asrow['asstarttime'];
    	      	$asofftime = $asrow['asofftime'];
    	      	$supuid = $asrow['supuid'];
    	      	
    	      	if($uid !=0 && $supuid != 0)
    	      	{
    	      	    //// Supervisor Visit Record Generation
        		    $visitquery = $db->prepare("SELECT uid, vdate FROM visits WHERE uid = ? AND stid = ? AND brid = ? AND vdate = ?");
        		    $visitquery->execute(array($supuid, $stid, $brid, $at_timestamp));
        		    if($visitquery->rowCount() == 0)
        		    {
        		        $vquery = $db->prepare("INSERT INTO visits(uid, stid, brid, vdate) VALUES(?,?,?,?)");
        		      	$vvalues = array($supuid, $stid, $brid, $at_timestamp);
        		      	$vquery->execute($vvalues);
        		    }
    	      	}
    	    }    
	    }
	}  

	function submit_daily_ba_log($db,$URL)
	{
	  	$at_date = date("d-m-Y");
	  	$at_timestamp = strtotime($at_date);
	  	$at_weekday = date("l");
	    /// check for active assignment
	    $asquery = $db->prepare("SELECT * FROM assignments WHERE asstatus = ?");
	    $asquery->execute(array(0));
	    if($asquery->rowCount() > 0)
	    {
	      while($asrow = $asquery->fetch())
	      {
	      	$asid = $asrow['asid'];
	      	$uid = $asrow['uid'];
	      	$stid = $asrow['stid'];
	      	$brid = $asrow['brid'];
	      	$asoffday = $asrow['asoffday'];
	      	$asstarttime = $asrow['asstarttime'];
	      	$asofftime = $asrow['asofftime'];
	      	$supuid = $asrow['supuid'];
	      	
	      	if($uid !=0)
	      	{
	    		    // check attendance record
			      $attquery = $db->prepare("SELECT uid, attendance_date FROM user_attendance WHERE uid = ? AND attendance_date = ?");
			      $attquery->execute(array($uid, $at_date));
			      if($attquery->rowCount() == 0)
			      {
			      	$uaquery = $db->prepare("INSERT INTO user_attendance(uid, asid, attendance_date, store_starttime, store_offtime, uatdate) VALUES(?,?,?,?,?,?)");
			      	$uavalues = array($uid, $asid, $at_date, $asstarttime, $asofftime, time());
			      	$uaquery->execute($uavalues);
			      	// create attendance record
			        $asdquery = $db->prepare("SELECT asdid, asid, brid, pid, asdtarget FROM assignment_detail WHERE asid = ? AND asdstatus = ?");
			        $asdquery->execute(array($asid,0));
			        while($asdrow = $asdquery->fetch())
			        {
			        		$asdid = $asdrow['asdid'];
			        		$asid = $asdrow['asid'];
			        		$brid = $asdrow['brid'];
			        		$pid = $asdrow['pid'];
			        		$sale_target = $asdrow['asdtarget'];

			        		// create ba assignment sale record
					        $uaquery = $db->prepare("INSERT INTO assignment_sale(uid, asdid, asid, brid, pid, sale_date, sale_target, assdate) VALUES(?,?,?,?,?,?,?,?)");
					        $uavalues = array($uid, $asdid, $asid, $brid, $pid, $at_date, $sale_target, time());
					        $uaquery->execute($uavalues);			
			        }
			        
			        if($supuid > 0)
			        {
        			    //// Supervisor Visit Record Generation
        			    /*$visitquery = $db->prepare("SELECT uid, vdate FROM visits WHERE uid = ? AND stid = ? AND brid = ? AND vdate = ?");
        			    $visitquery->execute(array($supuid, $stid, $brid, $at_timestamp));
        			    if($visitquery->rowCount() == 0)
        			    {
        			    	$vquery = $db->prepare("INSERT INTO visits(uid, stid, brid, vdate) VALUES(?,?,?,?)");
        			      	$vvalues = array($supuid, $stid, $brid, $at_timestamp);
        			      	$vquery->execute($vvalues);
        			    }*/
        			    $vquery = $db->prepare("INSERT INTO visits(uid, stid, brid, ba_uid, sup_uid, vdate) VALUES(?,?,?,?,?,?)");
    			      	$vvalues = array($supuid, $stid, $brid, $uid, $supuid, $at_timestamp);
    			      	$vquery->execute($vvalues);
			        }
			        
			        // Usership Section
			        $comquery = $db->prepare("SELECT brid, cbrid FROM com_brand WHERE brid = ? ORDER BY combrid ASC");
			        $comquery->execute(array($brid));
			        if($comquery->rowCount() > 0)
			        {
		        		// create usership records
				        $ushquery = $db->prepare("INSERT INTO usership(uid, asid, brid, sale_date, asudate) VALUES(?,?,?,?,?)");
				      	$ushvalues = array($uid, $asid, $brid, $at_date, time());
				      	$ushquery->execute($ushvalues);
				      	$asuid = $db->lastInsertId();

		        		while($comrow = $comquery->fetch())
				        {
				        		$cbrid = $comrow['cbrid'];
				        		// create usership detail
				        	  $ushdquery = $db->prepare("INSERT INTO usership_detail(asuid, uid, brid, cbrid, sale_date, asuddate) VALUES(?,?,?,?,?,?)");
						        $ushdvalues = array($asuid, $uid, $brid, $cbrid, $at_date, time());
						        $ushdquery->execute($ushdvalues);
				        }
			        }
			      }	
			      
			      
	      	}
	      }
	    }  
	}
	function resize_image($file, $w, $h, $crop=FALSE)
	{
	    list($width, $height) = getimagesize($file);
	    $r = $width / $height;
	    if ($crop) {
	        if ($width > $height) {
	            $width = ceil($width-($width*abs($r-$w/$h)));
	        } else {
	            $height = ceil($height-($height*abs($r-$w/$h)));
	        }
	        $newwidth = $w;
	        $newheight = $h;
	    } else {
	        if ($w/$h > $r) {
	            $newwidth = $h*$r;
	            $newheight = $h;
	        } else {
	            $newheight = $w/$r;
	            $newwidth = $w;
	        }
	    }
	    $src = imagecreatefromjpeg($file);
	    $dst = imagecreatetruecolor($newwidth, $newheight);
	    imagecopyresampled($dst, $src, 0, 0, 0, 0, $newwidth, $newheight, $width, $height);

	    return $dst;
	}
	
	/////////////////  Update Brand Ambassador  /////////////////
	function update_visit($db,$URL,$id)
	{
		$date 	  = time();
		$remarks    = stripslashes($_REQUEST['txtRemarks']);
		$code    = stripslashes($_REQUEST['cboAttendanceType']);
		$hdnlat    = stripslashes($_REQUEST['hdnLat']);
		$hdnlong    = stripslashes($_REQUEST['hdnLong']);

		$post_date    = stripslashes($_REQUEST['date']);
		$hrs    = stripslashes($_REQUEST['cboHrs']);
		$mins    = stripslashes($_REQUEST['cboMins']);

		$posting_date = strtotime($post_date." ".$hrs.":".$mins);

		//echo($posting_date." / ".date("d-m-Y h:i A", $posting_date));die;


        $file_name   = "image";
		$File 	     = $_FILES[$file_name]['name'];		
		$TmpFile     = $_FILES[$file_name]['tmp_name'];

		$ext 	 	 = pathinfo($File, PATHINFO_EXTENSION);
		$rand 		 = rand();
		$newfilename = $rand.".".$ext;
		$target_path = "../ba_app/assets/uploads/su/";
		$target_path = $target_path . basename($newfilename);
		
		if($ext == "png" || $ext == "jpg")
		{
		    if(move_uploaded_file($TmpFile, $target_path))
			{
				$visit_image = $newfilename;
			}
			else
			{
				$visit_image = "";
			}
		}
		else
		{
			$visit_image = "";
		}

        
		

		////////////////////////////////////////

		$Query = $db->prepare("UPDATE visits SET remarks=?, attendance_code=?, vlat=?, vlong=?, vimage=?, vimage_date=?, post_date=?, post_type=? WHERE vid = ?");
		$values = array($remarks, $code, $hdnlat, $hdnlong, $visit_image, $date, $posting_date, 1, $id);
		if($Query->execute($values))
		{
			///////////////////// LOG SECTION /////////////////////
		    //$log = "$FullName - User has been created";
			//log_entry($log);
		    ///////////////////////////////////////////////////////
			header("Location: $URL/update_visit.php?vid=$id&err=3");
			die;
		}
	}

	function send_email($from,$from_title,$to,$subject,$message)
	{
		require("../phpmailer/PHPMailerAutoload.php");

		$mail = new PHPMailer;
		   
		$mail->setFrom($from, $from_title);
		$mail->addAddress($to);     // Add a recipient
		//$mail->addAddress('mohsinfighter@gmail.com');            // Name is optional
		//  $mail->addReplyTo('info@example.com', 'Information');
		//  $mail->addCC('cc@example.com');
		$mail->addBCC('info@corios.com.pk');

		//  $mail->addAttachment($pdf_file_name,$pdf_file_name);  // Add attachments
		//  $mail->addAttachment('/tmp/image.jpg', 'new.jpg');    // Optional name
		$mail->isHTML(true);                                  	  // Set email format to HTML

		$mail->Subject = $subject;
		$mail->Body    = $message;
		$mail->AltBody = "This is the body in plain text for non-HTML mail clients";

	  	if(!$mail->send()) {
	    	echo 'Message could not be sent.';
	    	echo 'Mailer Error: ' . $mail->ErrorInfo;
	  	} else {
	    	echo 'Message sent successfully.';
	  	} 
	}

	function delete_register($rid)
	{
		global $db;
		global $URL;
		
		$Query = $db->prepare("DELETE FROM register WHERE rid=?");
		if($Query->execute(array($rid)))
		{
			///////////////////// LOG SECTION /////////////////////
		    $log = "Online Registration has been deleted";
			log_entry($log);
		    ///////////////////////////////////////////////////////
			header("Location: registration.php?err=4");
		}
	}

	function log_entry($log)
	{
		global $db;
		global $URL;
	    $LogQuery = $db->prepare("INSERT INTO logdetail(logdate , deletedate  , detail , date) VALUES(? , ? , ? , ?)");
	    $LogValues = array($_SESSION['logdate'] , $_SESSION['deletedate'] , $log , time());
	    $LogQuery->execute($LogValues);
	}

	
	function edit_ledger($db,$URL,$acmid,$aid,$startdate,$enddate,$leid)
	{
	    $Query = $db->prepare("UPDATE ledger SET detail = ? WHERE aid = ? AND leid = ?");
	    $Values = array($_REQUEST['txtDetail'],$aid,$leid);
	    if($Query->execute($Values))
	    {
	    	header("Location: print_ledger.php?acmid=$acmid&aid=$aid&startdate=$startdate&enddate=$enddate&err=3");
	    	die;
	    }
	}

	function ledger_entry($aid,$detail,$debit,$credit,$balance,$date)
	{
		global $db;
		global $URL;

		$ledgerquery = $db->prepare("INSERT INTO ledger(aid , detail , debit , credit , balance , ldate) VALUES(?,?,?,?,?,?)");
		$ledgervalues = array($aid,$detail,$debit,$credit,$balance,$date);
		$ledgerquery->execute($ledgervalues);
	}

	function chk_ledger($db,$URL,$aid)
	{
		$ledquery = $db->prepare("SELECT * FROM ledger WHERE aid = ?");
		$ledquery->execute(array($aid));
		if($ledquery->rowCount() == 0)
		{
			$ledgerquery = $db->prepare("INSERT INTO ledger(aid , detail , ldate) VALUES(?,?,?)");
			$ledgervalues = array($aid,"Opening Balance",time());
			$ledgerquery->execute($ledgervalues);	
		}
	}

	function deposit_entry($aid,$gtno,$detail,$debit,$credit,$balance,$date)
	{
		global $db;
		global $URL;

		$ledgerquery = $db->prepare("INSERT INTO ledger(aid , refno , detail , debit , credit , balance , ldate) VALUES(?,?,?,?,?,?,?)");
		$ledgervalues = array($aid,$gtno,$detail,$debit,$credit,$balance,$date);
		$ledgerquery->execute($ledgervalues);
	}	

	function pdf_ledger($db,$URL,$aid,$startdate,$enddate)
	{
		$message = '<table align="center" style="font-family: arial;" width="950" cellspacing="0" cellpadding="0">
						<tr><td>&nbsp;</td></tr>
						<tr>
							<td width="650" align="left" valign="top">
								<img src="'.$URL.'/images/corios-logo.png" width="200">
								<br><br>
								<b>Building # 95/96, Street 8-C, Feroz Colony Outfall Road</b>
								<br>
								<b>Lahore</b>
								<br>
								<b>0300 4806769</b>
								<br>
								<b>0324 5131870</b>
							</td>
							<td width="300" align="left" valign="top">';

		$query = $db->prepare("SELECT * FROM ledger L INNER JOIN accounts A ON L.aid = A.aid WHERE A.aid = ? ORDER BY L.leid ASC LIMIT 0,1");
		$query->execute(array($aid));
		while($row = $query->fetch())
		{
			$totalbalance = number_format($row['balance']);

		$message.=			'<td width="350" align="left" valign="top">
								<h1>Account Ledger</h1>
								<br>
								<b>Account : '.$row['aname'].' - '.$row['aemail'].'</b>
								<br>';
		if($startdate != "" && $enddate !="")
		{
			$message.=				'<b>Start Date: '.$startdate.'</b>
									<br>
									<b>End Date: '.$enddate.'</b>';
			$ldate = "AND ldate BETWEEN ".strtotime(str_replace("/", "-", $_REQUEST['startdate']))." AND ".strtotime(str_replace("/", "-", $_REQUEST['enddate']))."";								
		}
		else
		{
			$ldate = "";
		}
		$message.=			'</td>
						</tr>
					</table>
					<br><br>
					<table align="center" width="950" style="border: 1px solid #CCC; font-family: arial;">
						<tr class="title">
							<td style="border: 1px solid #CCC;" width="50" align="center" bgcolor="#54271D" height="25"><span style="color: #fff; font-weight: bold;">Sr#</span></td>
							<td style="border: 1px solid #CCC;" width="60" align="left" bgcolor="#54271D" height="15">&nbsp;<b style="color: white;">Date</b></td>
							<td style="border: 1px solid #CCC;" align="left" bgcolor="#54271D" height="15">&nbsp;<b style="color: white;">Details</b></td>
							<td style="border: 1px solid #CCC;" width="90" align="right" bgcolor="#54271D" height="15"><b style="color: white;">Debit</b>&nbsp;</td>
							<td style="border: 1px solid #CCC;" width="90" align="right" bgcolor="#54271D" height="15"><b style="color: white;">Credit</b>&nbsp;</td>
							<td style="border: 1px solid #CCC;" width="100" align="right" bgcolor="#54271D" height="15"><b style="color: white;">Balance</b>&nbsp;</td>
						</tr>';
						$count = 0;
						$lequery = $db->prepare("SELECT * FROM ledger WHERE aid = $aid $ldate ORDER BY leid DESC");
						$lequery->execute();
						if($lequery->rowCount() == 0)
						{
		$message.=		'<tr>
							<td align="center" colspan="6">
								No Record Found!
							</td>
						</tr>';					
						}
						else
						{
							while($lerow = $lequery->fetch())
							{
								$count++;
								if($lerow['debit'] != 0 && $lerow['credit'] != 0) {  $bgcolor = "#FFF"; }
								if($lerow['debit'] != 0 && $lerow['credit'] == 0) {  $bgcolor = "#FCEBEB"; }
								if($lerow['debit'] == 0 && $lerow['credit'] != 0) {  $bgcolor = "#EDFCEB"; }


		$message .=		'<tr bgcolor="'.$bgcolor.'">
							<td style="border: 1px solid #CCC;" align="center" class="title" height="25">&nbsp;'.$count.'</td>
							<td style="border: 1px solid #CCC;" align="left">&nbsp;'.date("d/m/Y",$lerow['ldate']).'</td>
							<td style="border: 1px solid #CCC;" align="left">&nbsp;'.$lerow['detail'].'</td>
							<td style="border: 1px solid #CCC;" align="right">'.number_format($lerow['debit']).'&nbsp;</td>
							<td style="border: 1px solid #CCC;" align="right">'.number_format($lerow['credit']).'&nbsp;</td>
							<td style="border: 1px solid #CCC;" align="right">'.number_format($lerow['balance']).'&nbsp;</td>
						</tr>
						<tr>';
							}	
							$totalquery = $db->prepare("SELECT SUM(debit) AS totalreceived, SUM(credit) AS totalpayment FROM ledger WHERE aid = $aid $ldate");
							$totalquery->execute();
							while($totalrow = $totalquery->fetch())
							{
		$message.=			'<td style="border: 1px solid #CCC;" align="right" height="35" colspan="3"></td>
							<td style="border: 1px solid #CCC;" align="right"><b>'.number_format($totalrow['totalreceived']).'</b>&nbsp;</td>
							<td style="border: 1px solid #CCC;" align="right"> <b>'.number_format($totalrow['totalpayment']).'</b>&nbsp;</td>';
							}
							$balQuery = $db->prepare("SELECT balance FROM ledger WHERE aid = $aid $ldate ORDER BY leid DESC LIMIT 0,1");
							$balQuery->execute();
							while($balrow = $balQuery->fetch())
							{
								$CurrentBalance = $balrow['balance'];
		$message.=			'<td style="border: 1px solid #CCC;" align="right"> <b>'.number_format($CurrentBalance).'</b>&nbsp;</td>';	
							}	
		$message.=		'</tr>';
						}
		$message.=	'</table>
					<br><br>
					<table align="center" width="950" style="border: 1px solid #CCC; font-family: arial;">
						<tr class="footer" style="background-color: #107E7F">
							<td align="center" colspan="2">
								<span style="font-size: 12px; color: #fff; font-weight: bold;">	
									Thanks for Doing Business With Us <br> We are Always Happy to Serve You
								</span>
							</td>
						</tr>
					</table>';
		
			//echo($message);die;
			///////////////// PDF Creation //////////////////////////
			require_once __DIR__ . '/vendor/autoload.php';
			$mpdf = new \Mpdf\Mpdf();
			$pdf_file_name = "GITMIT Account Ledger ".$row['aname'].".pdf";

			$mpdf->WriteHTML($message);
			$mpdf->Output($pdf_file_name,"D");
			die;
        	////////////////////////////////////////////////////////
		}
	}

	function email_ledger($db,$URL,$aid,$startdate,$enddate)
	{
		$message = '<table align="center" style="font-family: arial;" width="950" cellspacing="0" cellpadding="0">
						<tr><td>&nbsp;</td></tr>
						<tr>
							<td width="650" align="left" valign="top">
								<img src="'.$URL.'/images/corios-logo.png" width="200">
								<br><br>
								<b>Building # 95/96, Street 8-C, Feroz Colony Outfall Road</b>
								<br>
								<b>Lahore</b>
								<br>
								<b>0300 4806769</b>
								<br>
								<b>0324 5131870</b>
							</td>
							<td width="300" align="left" valign="top">';

		$query = $db->prepare("SELECT * FROM ledger L INNER JOIN accounts A ON L.aid = A.aid WHERE A.aid = ? ORDER BY L.leid ASC LIMIT 0,1");
		$query->execute(array($aid));
		while($row = $query->fetch())
		{
			$totalbalance = number_format($row['balance']);

		$message.=			'<td width="350" align="left" valign="top">
								<h1>Account Ledger</h1>
								<br>
								<b>Account : '.$row['aname'].' - '.$row['aemail'].'</b>
								<br>';
		if($startdate != "" && $enddate !="")
		{
			$message.=				'<b>Start Date: '.$startdate.'</b>
									<br>
									<b>End Date: '.$enddate.'</b>';
			$ldate = "AND ldate BETWEEN ".strtotime(str_replace("/", "-", $_REQUEST['startdate']))." AND ".strtotime(str_replace("/", "-", $_REQUEST['enddate']))."";								
		}
		else
		{
			$ldate = "";
		}
		$message.=			'</td>
						</tr>
					</table>
					<br><br>
					<table align="center" width="950" style="border: 1px solid #CCC; font-family: arial;">
						<tr class="title">
							<td style="border: 1px solid #CCC;" width="50" align="center" bgcolor="#54271D" height="25"><span style="color: #fff; font-weight: bold;">Sr#</span></td>
							<td style="border: 1px solid #CCC;" width="60" align="left" bgcolor="#54271D" height="15">&nbsp;<b style="color: white;">Date</b></td>
							<td style="border: 1px solid #CCC;" align="left" bgcolor="#54271D" height="15">&nbsp;<b style="color: white;">Details</b></td>
							<td style="border: 1px solid #CCC;" width="90" align="right" bgcolor="#54271D" height="15"><b style="color: white;">Debit</b>&nbsp;</td>
							<td style="border: 1px solid #CCC;" width="90" align="right" bgcolor="#54271D" height="15"><b style="color: white;">Credit</b>&nbsp;</td>
							<td style="border: 1px solid #CCC;" width="100" align="right" bgcolor="#54271D" height="15"><b style="color: white;">Balance</b>&nbsp;</td>
						</tr>';
						$count = 0;
						$lequery = $db->prepare("SELECT * FROM ledger WHERE aid = $aid $ldate ORDER BY leid DESC");
						$lequery->execute();
						if($lequery->rowCount() == 0)
						{
		$message.=		'<tr>
							<td align="center" colspan="6">
								No Record Found!
							</td>
						</tr>';					
						}
						else
						{
							while($lerow = $lequery->fetch())
							{
								$count++;
								if($lerow['debit'] != 0 && $lerow['credit'] != 0) {  $bgcolor = "#FFF"; }
								if($lerow['debit'] != 0 && $lerow['credit'] == 0) {  $bgcolor = "#FCEBEB"; }
								if($lerow['debit'] == 0 && $lerow['credit'] != 0) {  $bgcolor = "#EDFCEB"; }


		$message .=		'<tr bgcolor="'.$bgcolor.'">
							<td style="border: 1px solid #CCC;" align="center" class="title" height="25">&nbsp;'.$count.'</td>
							<td style="border: 1px solid #CCC;" align="left">&nbsp;'.date("d/m/Y",$lerow['ldate']).'</td>
							<td style="border: 1px solid #CCC;" align="left">&nbsp;'.$lerow['detail'].'</td>
							<td style="border: 1px solid #CCC;" align="right">'.number_format($lerow['debit']).'&nbsp;</td>
							<td style="border: 1px solid #CCC;" align="right">'.number_format($lerow['credit']).'&nbsp;</td>
							<td style="border: 1px solid #CCC;" align="right">'.number_format($lerow['balance']).'&nbsp;</td>
						</tr>
						<tr>';
							}	
							$totalquery = $db->prepare("SELECT SUM(debit) AS totalreceived, SUM(credit) AS totalpayment FROM ledger WHERE aid = $aid $ldate");
							$totalquery->execute();
							while($totalrow = $totalquery->fetch())
							{
		$message.=			'<td style="border: 1px solid #CCC;" align="right" height="35" colspan="3"></td>
							<td style="border: 1px solid #CCC;" align="right"><b>'.number_format($totalrow['totalreceived']).'</b>&nbsp;</td>
							<td style="border: 1px solid #CCC;" align="right"> <b>'.number_format($totalrow['totalpayment']).'</b>&nbsp;</td>';
							}
							$balQuery = $db->prepare("SELECT balance FROM ledger WHERE aid = $aid $ldate ORDER BY leid DESC LIMIT 0,1");
							$balQuery->execute();
							while($balrow = $balQuery->fetch())
							{
								$CurrentBalance = $balrow['balance'];
		$message.=			'<td style="border: 1px solid #CCC;" align="right"> <b>'.number_format($CurrentBalance).'</b>&nbsp;</td>';	
							}	
		$message.=		'</tr>';
						}
		$message.=	'</table>
					<br><br>
					<table align="center" width="950" style="border: 1px solid #CCC; font-family: arial;">
						<tr class="footer" style="background-color: #107E7F">
							<td align="center" colspan="2">
								<span style="font-size: 12px; color: #fff; font-weight: bold;">	
									Thanks for Doing Business With Us <br> We are Always Happy to Serve You
								</span>
							</td>
						</tr>
					</table>';
		
		//echo($message);die;
			///////////////// PDF Creation //////////////////////////

			require_once __DIR__ . '/vendor/autoload.php';
			$mpdf = new \Mpdf\Mpdf();
			$pdf_file_name = "GITMIT Member Account Ledger ".$row['aname'].".pdf";

			$mpdf->WriteHTML($message);
			$mpdf->Output($pdf_file_name,"F");
			die;
        	////////////////////////////////////////////////////////

        	///////////////// Send Email //////////////////////////		
			
			require("../phpmailer/PHPMailerAutoload.php");

			$mail = new PHPMailer;
			   
			$mail->setFrom('no_reply@gitmit.com', 'GITMIT CO-WORKING SPACE');
			$mail->addAddress($row['aemail']);     // Add a recipient
			//$mail->addAddress('mohsinfighter@gmail.com');            // Name is optional
			//  $mail->addReplyTo('info@example.com', 'Information');
			//  $mail->addCC('cc@example.com');
			$mail->addBCC('mumtaz@lanwan.com.au');
			$mail->addBCC('info@gitmit.com');
            //$mail->addBCC('mohsin.raza01@live.com');
            
			$mail->addAttachment($pdf_file_name,$pdf_file_name);  // Add attachments
			//  $mail->addAttachment('/tmp/image.jpg', 'new.jpg');    // Optional name
			$mail->isHTML(true);                                  	  // Set email format to HTML

			$mail->Subject = "GITMIT Member Account Ledger ".$row['aname']."";
			$mail->Body    = $message;
			$mail->AltBody = "This is the body in plain text for non-HTML mail clients";

		  	if(!$mail->send()) {
		    	echo 'Message could not be sent.';
		    	echo 'Mailer Error: ' . $mail->ErrorInfo;
		  	} else {
		  		unlink($pdf_file_name);
		    	header("Location: ledger.php?err=60");
		  	}
		}
	}

	function pdf_deposit($db,$URL,$ldate)
	{
		$query = $db->prepare("SELECT * FROM ledger L INNER JOIN accounts A ON L.refno = A.gtno WHERE L.ldate=?");
		$query->execute(array($ldate));
		while($row = $query->fetch())
		{
		$message = '<table align="center" width="850" cellspacing="0" cellpadding="0">
						<tr>
							<td align="center">
								<img src="'.$URL.'/images/voucher_header.jpg" width="650">
							</td>
						</tr>
						<tr><td>&nbsp;</td></tr>
					</table>
					<table style="font-family:arial;" align="center" width="850" border="1">
						<tr class="title">
							<td width="50" colspan="2" align="center" bgcolor="#54271D" height="35">&nbsp;<span class="title-font" style="color:white;">REFUNDABLE SECURITY DEPOSIT RECEIPT</span></td>
						</tr>
						<tr>
							<td align="left" width="200" class="title" height="35">&nbsp;<b>Voucher #</b></td>
							<td align="left" class="title" height="35">&nbsp;'.$row['leid'].'</td>
						</tr>
						<tr>
							<td align="left" width="200" class="title" height="35">&nbsp;<b>GT #</b></td>
							<td align="left" class="title" height="35">&nbsp;'.$row['gtno'].'</td>
						</tr>
						<tr>
							<td align="left" width="200" class="title" height="35">&nbsp;<b>Customer</b></td>
							<td align="left" class="title" height="35">&nbsp;'.$row['aname'].'</td>
						</tr>
						
						<tr>
							<td align="left" class="title" height="35">&nbsp;<b>Security Deposit Amount</b></td>
							<td align="left" class="title" height="35">&nbsp;PKR '.number_format($row['credit']).'</td>
						</tr>
						<tr>
							<td align="left" class="title" height="35">&nbsp;<b>Date Submitted</b></td>
							<td align="left" class="title" height="35">&nbsp;'.date("d/m/Y",$row['ldate']).'</td>
						</tr>
						<tr>
							<td align="left" class="title" height="35">&nbsp;<b>Sec.Bond Beneficiary</b></td>
							<td align="left" class="title" height="35">&nbsp;'.$row['detail'].'</td>
						</tr>
					</table>
					<br><br>
					<table align="center" width="850" style="border: 1px solid #CCC; font-family: arial;">
						<tr class="footer" style="background-color: #107E7F">
							<td align="center" colspan="2">
								<span style="font-size: 12px; color: #fff; font-weight: bold;">	
									Thanks for Doing Business With Us <br> We are Always Happy to Serve You
								</span>
							</td>
						</tr>
					</table>';
		
			//echo($message);die;
			///////////////// PDF Creation //////////////////////////

			require_once __DIR__ . '/vendor/autoload.php';
			$mpdf = new \Mpdf\Mpdf();
			$pdf_file_name = "GITMIT Security Deposit ".$row['aname'].".pdf";

			$mpdf->WriteHTML($message);
			$mpdf->Output($pdf_file_name,"D");
			die;
        	////////////////////////////////////////////////////////
		}
	}

	function pdf_deposit_refund($db,$URL,$ldate)
	{
		$query = $db->prepare("SELECT * FROM ledger L INNER JOIN accounts A ON L.refno = A.gtno WHERE L.ldate=?");
		$query->execute(array($ldate));
		while($row = $query->fetch())
		{
		$message = '<table align="center" width="850" cellspacing="0" cellpadding="0">
						<tr>
							<td align="center">
								<img src="'.$URL.'/images/voucher_header.jpg" width="650">
							</td>
						</tr>
						<tr><td>&nbsp;</td></tr>
					</table>
					<table style="font-family:arial;" align="center" width="850" border="1">
						<tr class="title">
							<td width="50" colspan="2" align="center" bgcolor="#54271D" height="35">&nbsp;<span class="title-font" style="color:white;">SECURITY REFUND RECEIPT</span></td>
						</tr>
						<tr>
							<td align="left" width="200" class="title" height="35">&nbsp;<b>Voucher #</b></td>
							<td align="left" class="title" height="35">&nbsp;'.$row['leid'].'</td>
						</tr>
						<tr>
							<td align="left" width="200" class="title" height="35">&nbsp;<b>GT #</b></td>
							<td align="left" class="title" height="35">&nbsp;'.$row['gtno'].'</td>
						</tr>
						<tr>
							<td align="left" width="200" class="title" height="35">&nbsp;<b>Customer</b></td>
							<td align="left" class="title" height="35">&nbsp;'.$row['aname'].'</td>
						</tr>
						
						<tr>
							<td align="left" class="title" height="35">&nbsp;<b>Security Refunded Amount</b></td>
							<td align="left" class="title" height="35">&nbsp;PKR '.number_format($row['credit']).'</td>
						</tr>
						<tr>
							<td align="left" class="title" height="35">&nbsp;<b>Date Refunded</b></td>
							<td align="left" class="title" height="35">&nbsp;'.date("d/m/Y",$row['ldate']).'</td>
						</tr>
						<tr>
							<td align="left" class="title" height="35">&nbsp;<b>Detail</b></td>
							<td align="left" class="title" height="35">&nbsp;'.$row['detail'].'</td>
						</tr>
					</table>
					<br><br>
					<table align="center" width="850" style="border: 1px solid #CCC; font-family: arial;">
						<tr class="footer" style="background-color: #107E7F">
							<td align="center" colspan="2">
								<span style="font-size: 12px; color: #fff; font-weight: bold;">	
									Thanks for Doing Business With Us <br> We are Always Happy to Serve You
								</span>
							</td>
						</tr>
					</table>';
		
			//echo($message);die;
			///////////////// PDF Creation //////////////////////////

			require_once __DIR__ . '/vendor/autoload.php';
			$mpdf = new \Mpdf\Mpdf();
			$pdf_file_name = "GITMIT Security Refund ".$row['aname'].".pdf";

			$mpdf->WriteHTML($message);
			$mpdf->Output($pdf_file_name,"D");
			die;
        	////////////////////////////////////////////////////////
		}
	}

	function email_deposit($db,$URL,$ldate)
	{
		$query = $db->prepare("SELECT * FROM ledger L INNER JOIN accounts A ON L.refno = A.gtno WHERE L.ldate=?");
		$query->execute(array($ldate));
		while($row = $query->fetch())
		{
			$leid  = $row['leid'];
			$gtno  = $row['gtno'];
			$email = $row['aemail'];
			$name  = $row['aname'];

			$message = '<table align="center" width="850" cellspacing="0" cellpadding="0">
						<tr>
							<td align="center">
								<img src="'.$URL.'/images/voucher_header.jpg" width="650">
							</td>
						</tr>
						<tr><td>&nbsp;</td></tr>
					</table>
					<table style="font-family:arial;" align="center" width="850" border="1">
						<tr class="title">
							<td width="50" colspan="2" align="center" bgcolor="#54271D" height="35">&nbsp;<span class="title-font" style="color:white;">REFUNDABLE SECURITY DEPOSIT RECEIPT</span></td>
						</tr>
						<tr>
							<td align="left" width="200" class="title" height="35">&nbsp;<b>Voucher #</b></td>
							<td align="left" class="title" height="35">&nbsp;'.$row['leid'].'</td>
						</tr>
						<tr>
							<td align="left" width="200" class="title" height="35">&nbsp;<b>GT #</b></td>
							<td align="left" class="title" height="35">&nbsp;'.$row['gtno'].'</td>
						</tr>
						<tr>
							<td align="left" width="200" class="title" height="35">&nbsp;<b>Customer</b></td>
							<td align="left" class="title" height="35">&nbsp;'.$row['aname'].'</td>
						</tr>
						
						<tr>
							<td align="left" class="title" height="35">&nbsp;<b>Security Deposit Amount</b></td>
							<td align="left" class="title" height="35">&nbsp;PKR '.number_format($row['credit']).'</td>
						</tr>
						<tr>
							<td align="left" class="title" height="35">&nbsp;<b>Date Submitted</b></td>
							<td align="left" class="title" height="35">&nbsp;'.date("d/m/Y",$row['ldate']).'</td>
						</tr>
						<tr>
							<td align="left" class="title" height="35">&nbsp;<b>Sec.Bond Beneficiary</b></td>
							<td align="left" class="title" height="35">&nbsp;'.$row['detail'].'</td>
						</tr>
					</table>
					<br><br>
					<table align="center" width="850" style="border: 1px solid #CCC; font-family: arial;">
						<tr class="footer" style="background-color: #107E7F">
							<td align="center" colspan="2">
								<span style="font-size: 12px; color: #fff; font-weight: bold;">	
									Thanks for Doing Business With Us <br> We are Always Happy to Serve You
								</span>
							</td>
						</tr>
					</table>';

			//echo($message);die;

			///////////////// PDF Creation //////////////////////////

			require_once __DIR__ . '/vendor/autoload.php';
			$mpdf = new \Mpdf\Mpdf();
			$pdf_file_name = "$gtno $name Security Deposit Voucher $leid GITMIT.pdf";

			$mpdf->WriteHTML($message);
			$mpdf->Output($pdf_file_name,"F");

        	////////////////////////////////////////////////////////
        			
			///////////////// Send Email //////////////////////////		
			
			require("../phpmailer/PHPMailerAutoload.php");

			$mail = new PHPMailer;
			   
			$mail->setFrom('no_reply@gitmit.com', 'GITMIT CO-WORKING SPACE');
			$mail->addAddress($row['aemail']);     // Add a recipient
			//$mail->addAddress('mohsinfighter@gmail.com');            // Name is optional
			//  $mail->addReplyTo('info@example.com', 'Information');
			//  $mail->addCC('cc@example.com');
			$mail->addBCC('mumtaz@lanwan.com.au');
			$mail->addBCC('info@gitmit.com');
            //$mail->addBCC('mohsin.raza01@live.com');
            
			$mail->addAttachment($pdf_file_name,$pdf_file_name);  // Add attachments
			//  $mail->addAttachment('/tmp/image.jpg', 'new.jpg');    // Optional name
			$mail->isHTML(true);                                  	  // Set email format to HTML

			$mail->Subject = "$gtno $name Security Deposit Voucher# $leid";
			$mail->Body    = $message;
			$mail->AltBody = "This is the body in plain text for non-HTML mail clients";

		  	if(!$mail->send()) {
		    	echo 'Message could not be sent.';
		    	echo 'Mailer Error: ' . $mail->ErrorInfo;
		  	} else {
		  		unlink($pdf_file_name);
		    	header("Location: deposits.php?err=56");
		  	}
			////////////////////////////////////////////////////////
		}
	}

	function email_deposit_refund($db,$URL,$ldate)
	{
		$query = $db->prepare("SELECT * FROM ledger L INNER JOIN accounts A ON L.refno = A.gtno WHERE L.ldate=?");
		$query->execute(array($ldate));
		while($row = $query->fetch())
		{
			$leid = $row['leid'];
			$gtno = $row['gtno'];
			$email = $row['aemail'];
			$name = $row['aname'];

			$message = '<table align="center" width="850" cellspacing="0" cellpadding="0">
						<tr>
							<td align="center">
								<img src="'.$URL.'/images/voucher_header.jpg" width="650">
							</td>
						</tr>
						<tr><td>&nbsp;</td></tr>
					</table>
					<table style="font-family:arial;" align="center" width="850" border="1">
						<tr class="title">
							<td width="50" colspan="2" align="center" bgcolor="#54271D" height="35">&nbsp;<span class="title-font" style="color:white;">SECURITY REFUND RECEIPT</span></td>
						</tr>
						<tr>
							<td align="left" width="200" class="title" height="35">&nbsp;<b>Voucher #</b></td>
							<td align="left" class="title" height="35">&nbsp;'.$row['leid'].'</td>
						</tr>
						<tr>
							<td align="left" width="200" class="title" height="35">&nbsp;<b>GT #</b></td>
							<td align="left" class="title" height="35">&nbsp;'.$row['gtno'].'</td>
						</tr>
						<tr>
							<td align="left" width="200" class="title" height="35">&nbsp;<b>Customer</b></td>
							<td align="left" class="title" height="35">&nbsp;'.$row['aname'].'</td>
						</tr>
						
						<tr>
							<td align="left" class="title" height="35">&nbsp;<b>Security Refunded Amount</b></td>
							<td align="left" class="title" height="35">&nbsp;PKR '.number_format($row['credit']).'</td>
						</tr>
						<tr>
							<td align="left" class="title" height="35">&nbsp;<b>Date Refunded</b></td>
							<td align="left" class="title" height="35">&nbsp;'.date("d/m/Y",$row['ldate']).'</td>
						</tr>
						<tr>
							<td align="left" class="title" height="35">&nbsp;<b>Detail</b></td>
							<td align="left" class="title" height="35">&nbsp;'.$row['detail'].'</td>
						</tr>
					</table>
					<br><br>
					<table align="center" width="850" style="border: 1px solid #CCC; font-family: arial;">
						<tr class="footer" style="background-color: #107E7F">
							<td align="center" colspan="2">
								<span style="font-size: 12px; color: #fff; font-weight: bold;">	
									Thanks for Doing Business With Us <br> We are Always Happy to Serve You
								</span>
							</td>
						</tr>
					</table>';

			
			//echo($message);die;

			///////////////// PDF Creation //////////////////////////

			require_once __DIR__ . '/vendor/autoload.php';
			$mpdf = new \Mpdf\Mpdf();
			$pdf_file_name = "$gtno $name Security Refund Voucher# $leid GITMIT.pdf";

			$mpdf->WriteHTML($message);
			$mpdf->Output($pdf_file_name,"F");

        	////////////////////////////////////////////////////////
        			
			///////////////// Send Email //////////////////////////		
			
			require("phpmailer/PHPMailerAutoload.php");

			$mail = new PHPMailer;
			   
			$mail->setFrom('no_reply@gitmit.com', 'GITMIT CO-WORKING SPACE');
			//$mail->addAddress($row['aemail']);     // Add a recipient
			//$mail->addAddress('mohsinfighter@gmail.com');            // Name is optional
			//  $mail->addReplyTo('info@example.com', 'Information');
			//  $mail->addCC('cc@example.com');
			$mail->addBCC('mumtaz@lanwan.com.au');
			$mail->addBCC('info@gitmit.com');

			$mail->addAttachment($pdf_file_name,$pdf_file_name);  // Add attachments
			//  $mail->addAttachment('/tmp/image.jpg', 'new.jpg');    // Optional name
			$mail->isHTML(true);                                  	  // Set email format to HTML

			$mail->Subject = "$gtno $name Security Refund Voucher# $leid";
			$mail->Body    = $message;
			$mail->AltBody = "This is the body in plain text for non-HTML mail clients";

		  	if(!$mail->send()) {
		    	echo 'Message could not be sent.';
		    	echo 'Mailer Error: ' . $mail->ErrorInfo;
		  	} else {
		  		unlink($pdf_file_name);
		    	header("Location: refunds.php?err=56");
		  	}
			////////////////////////////////////////////////////////
		}
	}

	function pdf_membership_report($db,$URL,$aid,$startdate,$enddate)
	{

		$message = '<table align="center" style="font-family: arial;" width="950" cellspacing="0" cellpadding="0">
						<tr><td>&nbsp;</td></tr>
						<tr>
							<td width="650" align="left" valign="top">
								<img src="'.$URL.'/images/corios-logo.png" width="200">
								<br><br>
								<b>Building # 95/96, Street 8-C, Feroz Colony Outfall Road</b>
								<br>
								<b>Lahore</b>
								<br>
								<b>0300 4806769</b>
								<br>
								<b>0324 5131870</b>
							</td>';

		

		$message.=			'<td width="350" align="left" valign="top">
								<h1>Membership Report</h1>';
		if($aid == 0)
		{
			$subaid = "";
			$message.=		'<br><b>Account : All Customers</b>';
		}
		else
		{
			$subaid = "AND S.aid = ".$aid."";
			$aquery = $db->prepare("SELECT * FROM accounts WHERE aid = ?");
			$aquery->execute(array($aid));
			while($arow = $aquery->fetch())
			{
				$message.=		'<br><b>Account : '.$arow['aname'].' - '.$arow['aemail'].'</b>';
			}
		}
									
		if($startdate != "" && $enddate !="")
		{
			$message.=				'<b>Start Date: '.$startdate.'</b>
									<br>
									<b>End Date: '.$enddate.'</b>';
			$subdate = "AND S.subdate BETWEEN ".strtotime(str_replace("/", "-", $_REQUEST['startdate']))." AND ".strtotime(str_replace("/", "-", $_REQUEST['enddate']))."";								
		}
		else
		{
			$subdate = "";
		}

		$message.=			'</td>
						</tr>
					</table>
					<br><br>
					<table align="center" width="950" style="border: 1px solid #CCC; font-family: arial;">
						<tr class="title">
							<td style="border: 1px solid #CCC;" width="50" align="center" bgcolor="#54271D" height="25"><span style="color: #fff; font-weight: bold;">Sr#</span></td>
							<td style="border: 1px solid #CCC;" align="left" bgcolor="#54271D" height="15">&nbsp;<b style="color: white;">Membership</b></td>
							<td style="border: 1px solid #CCC;" align="left" bgcolor="#54271D" height="15">&nbsp;<b style="color: white;">Customer</b></td>
							<td style="border: 1px solid #CCC;" width="90" align="center" bgcolor="#54271D" height="15"><b style="color: white;">Team</b>&nbsp;</td>
							<td style="border: 1px solid #CCC;" width="90" align="center" bgcolor="#54271D" height="15"><b style="color: white;">Start Date</b></td>
							<td style="border: 1px solid #CCC;" width="90" align="center" bgcolor="#54271D" height="15"><b style="color: white;">End Date</b></td>
							<td style="border: 1px solid #CCC;" width="100" align="right" bgcolor="#54271D" height="15"><b style="color: white;">Package</b>&nbsp;</td>
						</tr>';
						$count = 0;
										
						$query = $db->prepare("SELECT * FROM subscriptions S INNER JOIN accounts A ON S.aid = A.aid WHERE S.substatus = 0 $subaid $subdate");
						$query->execute();
						if($query->rowCount() == 0)
						{
		$message.=		'<tr>
							<td align="center" colspan="7">
								No Record Found!
							</td>
						</tr>';					
						}
						else
						{
							while($row = $query->fetch())
							{
								$count++;

								$subid = $row['subid'];
								$plid = $row['plid'];
								$aid = $row['aid'];
								$lid = $row['lid'];

								if($row['startdate'] != 0) { $startdate  = date("d/m/Y",$row['startdate']); } else{ $startdate  = ""; }
								if($row['enddate'] != 0) {$enddate  = date("d/m/Y",$row['enddate']); } else{ $enddate = ''; };

								$price 	 	 = $row['subunitprice'];

								$subquery = $db->prepare("SELECT * FROM submembers WHERE subid=?");
								$subquery->execute(array($subid));
								$nummembers = $subquery->rowCount();


		$message .=		'<tr>
							<td style="border: 1px solid #CCC;" align="center" class="title" height="25">&nbsp;'.$count.'</td>
							<td style="border: 1px solid #CCC;" align="left">&nbsp;'.$row['subgtno'].'-'.$row['subtitle'].'</td>
							<td style="border: 1px solid #CCC;" align="left">&nbsp;'.$row['gtno'].'-'.$row['aname'].' - '.$row['aemail'].'</td>
							<td style="border: 1px solid #CCC;" align="center">'.$nummembers.'&nbsp;</td>
							<td style="border: 1px solid #CCC;" align="center">'.$startdate.'</td>
							<td style="border: 1px solid #CCC;" align="center">'.$enddate.'</td>
							<td style="border: 1px solid #CCC;" align="right">'.number_format($price).'&nbsp;</td>
						</tr>
						<tr>';
							}
						}
		$message.=	'</table>
					<br><br>
					<table align="center" width="950" style="border: 1px solid #CCC; font-family: arial;">
						<tr class="footer" style="background-color: #107E7F">
							<td align="center" colspan="2">
								<span style="font-size: 12px; color: #fff; font-weight: bold;">	
									Thanks for Doing Business With Us <br> We are Always Happy to Serve You
								</span>
							</td>
						</tr>
					</table>';
		
		//echo($message);die;
			///////////////// PDF Creation //////////////////////////

			require_once __DIR__ . '/vendor/autoload.php';
			$mpdf = new \Mpdf\Mpdf();
			$pdf_file_name = "Membership Report.pdf";

			$mpdf->WriteHTML($message);
			$mpdf->Output($pdf_file_name,"D");
			die;
        	////////////////////////////////////////////////////////
	}

	function pdf_additional_member_report($db,$URL,$subid)
	{

		$message = '<table align="center" style="font-family: arial;" width="1000" cellspacing="0" cellpadding="0">
						<tr><td>&nbsp;</td></tr>
						<tr>
							<td width="650" align="left" valign="top">
								<img src="'.$URL.'/images/corios-logo.png" width="200">
								<br><br>
								<b>Building # 95/96, Street 8-C, Feroz Colony Outfall Road</b>
								<br>
								<b>Lahore</b>
								<br>
								<b>0300 4806769</b>
								<br>
								<b>0324 5131870</b>
							</td>';

		

		$message.=			'<td width="420" align="left" valign="top">
								<h1>Additional Member Report</h1>';
		if($subid == 0)
		{
			$subaid = "";
			$message.=		'<br><b>Account : All Memberships</b>';
		}
		else
		{
			$subaid = "AND S.subid = ".$subid."";
			$aquery = $db->prepare("SELECT * FROM subscriptions S INNER JOIN accounts A ON S.aid = A.aid WHERE S.subid = ?");
			$aquery->execute(array($_REQUEST['subid']));
			while($arow = $aquery->fetch())
			{
				$message.=		'<br><b>Account : '.$arow['subgtno']."-".$arow['subtitle'].'</b> <br> <b>'.$arow['aconame'].'</b><br><b>'.$arow['aaddress'].', '.$arow['acity'].'</b><br>';
			}
		}

		$message.=			'</td>
						</tr>
					</table>
					<br><br>
					<table align="center" width="1000" style="border: 1px solid #CCC; font-family: arial;">
						<tr class="title">
							<td style="border: 1px solid #CCC;" width="100" align="center" bgcolor="#54271D" height="25"><span style="color: #fff; font-weight: bold;">GT#</span></td>
							<td style="border: 1px solid #CCC;" align="left" bgcolor="#54271D" height="15">&nbsp;<b style="color: white;">Member Name</b></td>
							<td style="border: 1px solid #CCC;" align="left" bgcolor="#54271D" height="15">&nbsp;<b style="color: white;">Email</b></td>
							<td style="border: 1px solid #CCC;" width="90" align="center" bgcolor="#54271D" height="15"><b style="color: white;">Mobile</b></td>
							<td style="border: 1px solid #CCC;" width="90" align="center" bgcolor="#54271D" height="15"><b style="color: white;">Cnic</b></td>
							<td style="border: 1px solid #CCC;" width="90" align="center" bgcolor="#54271D" height="15"><b style="color: white;">DOB</b></td>
							<td style="border: 1px solid #CCC;" align="left" bgcolor="#54271D" height="15">&nbsp;<b style="color: white;">Address</b></td>
							<td style="border: 1px solid #CCC;" width="60" align="center" bgcolor="#54271D" height="15">&nbsp;<b style="color: white;">Image</b></td>
						</tr>';
					
										
						$query = $db->prepare("SELECT * FROM subscriptions S INNER JOIN accounts A ON S.aid = A.aid WHERE S.substatus = 0 $subaid");
						$query->execute();
						if($query->rowCount() == 0)
						{
		$message.=		'<tr>
							<td align="center" colspan="7">
								No Record Found!
							</td>
						</tr>';					
						}
						else
						{
							while($row = $query->fetch())
							{
								$subid = $row['subid'];
								$plid = $row['plid'];
								$aid = $row['aid'];
								$lid = $row['lid'];

								

								$price 	 	 = $row['subunitprice'];

								$subquery = $db->prepare("SELECT * FROM submembers WHERE subid=$subid AND smname <> '' AND smarchived = 0 AND smstatus = 0");
								$subquery->execute();
		
								$nummembers = $subquery->rowCount();
		if($nummembers > 0)
		{
		$message.=		'<tr>
							<td align="left" colspan="8" style="background-color: #EEE">
								&nbsp;<b>'.$row['subgtno']."-".$row['subtitle'].' ( '.$row['gtno']." ".$row['aname']." - ".$row['aemail'].' )</b>
							</td>
						</tr>';
		}
								$aquery = $db->prepare("SELECT * FROM submembers WHERE subid = $subid AND smname <> '' AND smarchived = 0 AND smstatus = 0");
								$aquery->execute();
								while($arow = $aquery->fetch())
								{
									if($arow['smimage'] != "")
									{
										$Image = "../images/members/images/".$arow['smimage'];
									}
									else
									{
										$Image = "../images/no_image.png";
									}
		$message .=		'<tr>
							<td style="border: 1px solid #CCC;" align="center" class="title" height="25">&nbsp;'.$arow['smgtno'].'</td>
							<td style="border: 1px solid #CCC;" align="left">&nbsp;'.$arow['smname'].'</td>
							<td style="border: 1px solid #CCC;" align="left">&nbsp;'.$arow['smemail'].'</td>
							<td style="border: 1px solid #CCC;" align="center">'.$arow['smmobile'].'</td>
							<td style="border: 1px solid #CCC;" align="center">'.$arow['smcnic'].'</td>
							<td style="border: 1px solid #CCC;" align="center">'.$arow['smdob'].'</td>
							<td style="border: 1px solid #CCC;" align="left">&nbsp;'.$arow['smaddress'].'</td>
							<td style="border: 1px solid #CCC;" align="center"><img src='.$Image.' width="60"></td>
						</tr>
						<tr>';
								}
							}	
						}
		$message.=	'</table>
					<br><br>
					<table align="center" width="1000" style="border: 1px solid #CCC; font-family: arial;">
						<tr class="footer" style="background-color: #107E7F">
							<td align="center" colspan="2">
								<span style="font-size: 12px; color: #fff; font-weight: bold;">	
									Thanks for Doing Business With Us <br> We are Always Happy to Serve You
								</span>
							</td>
						</tr>
					</table>';
		//echo($message);die;
			///////////////// PDF Creation //////////////////////////

			require_once __DIR__ . '/vendor/autoload.php';
			$mpdf = new \Mpdf\Mpdf();
			$pdf_file_name = "Additional Members Report.pdf";

			$mpdf->WriteHTML($message);
			$mpdf->Output($pdf_file_name,"D");
			die;
        	////////////////////////////////////////////////////////
	}

	function pdf_sales_report($db,$URL,$aid,$invoice_type,$startdate,$enddate)
	{

		$message = '<table align="center" style="font-family: arial;" width="950" cellspacing="0" cellpadding="0">
						<tr><td>&nbsp;</td></tr>
						<tr>
							<td width="650" align="left" valign="top">
								<img src="'.$URL.'/images/corios-logo.png" width="200">
								<br><br>
								<b>Building # 95/96, Street 8-C, Feroz Colony Outfall Road</b>
								<br>
								<b>Lahore</b>
								<br>
								<b>0300 4806769</b>
								<br>
								<b>0324 5131870</b>
							</td>';

		

		$message.=			'<td width="300" align="left" valign="top">
								<h1>Sales Report</h1>';
		if($aid == 0)
		{
			$subaid = "";
			$message.=		'<br><b>Account : All Customers</b>';
		}
		else
		{
			$subaid = "AND S.aid = ".$aid."";
			$aquery = $db->prepare("SELECT * FROM accounts WHERE aid = ?");
			$aquery->execute(array($aid));
			while($arow = $aquery->fetch())
			{
				$message.=		'<br><b>Account : '.$arow['aname'].' - '.$arow['aemail'].'</b>';
			}
		}
		
		if($invoice_type == 0) { $invoicetype = "All"; }
		if($invoice_type == 1) { $invoicetype = "GST Sales"; }
		if($invoice_type == 2) { $invoicetype = "Income Tax Sales"; }
		if($invoice_type == 3) { $invoicetype = "Cash Sales"; }		

		$message.=		'<br><b>Invoice Type : '.$invoicetype.'</b>';			
		
		if($startdate != "" && $enddate !="")
		{
			$message.=				'<bR><b>Start Date: '.$startdate.'</b>
									<br>
									<b>End Date: '.$enddate.'</b>';
			$subdate = "AND I.invdate BETWEEN ".strtotime(str_replace("/", "-", $_REQUEST['startdate']))." AND ".strtotime(str_replace("/", "-", $_REQUEST['enddate']))."";
		}
		else
		{
			$subdate = "";
		}

		$message.=			'</td>
						</tr>
					</table>
					<br><br>
					<table align="center" width="950" style="border: 1px solid #CCC; font-family: arial;">
						<tr class="title">
							<td style="border: 1px solid #CCC;" width="50" align="center" bgcolor="#54271D" height="25"><span style="color: #fff; font-weight: bold;">Sr#</span></td>
							<td style="border: 1px solid #CCC;" align="left" bgcolor="#54271D" height="15">&nbsp;<b style="color: white;">Invoice</b></td>
							<td style="border: 1px solid #CCC;" align="left" bgcolor="#54271D" height="15">&nbsp;<b style="color: white;">Customer</b></td>
							<td style="border: 1px solid #CCC;" width="90" align="center" bgcolor="#54271D" height="15"><b style="color: white;">Invoice Date</b></td>
							<td style="border: 1px solid #CCC;" width="100" align="right" bgcolor="#54271D" height="15"><b style="color: white;">Amount</b>&nbsp;</td>
						</tr>';
						$count = 0;
										
						$query = $db->prepare("SELECT * FROM invoices I INNER JOIN accounts A ON I.aid = A.aid WHERE I.invid <> 0 $subaid $subdate");
						$query->execute();
						if($query->rowCount() == 0)
						{
		$message.=		'<tr>
							<td align="center" colspan="5">
								No Record Found!
							</td>
						</tr>';					
						}
						else
						{
							while($row = $query->fetch())
							{
								$count++;

								$invid = $row['invid'];
								if($row['invtype'] == 1){ $invtype = "GST"; }
								if($row['invtype'] == 2){ $invtype = "IT"; }
								if($row['invtype'] == 3){ $invtype = "CS"; }


		$message .=		'<tr>
							<td style="border: 1px solid #CCC;" align="center" class="title" height="25">&nbsp;'.$count.'</td>
							<td style="border: 1px solid #CCC;" align="left">&nbsp;'.$invtype.'-'.$row['invno'].' - '.$row['remarks'].'</td>
							<td style="border: 1px solid #CCC;" align="left">&nbsp;'.$row['aname'].' - '.$row['aemail'].'</td>
							<td style="border: 1px solid #CCC;" align="center">'.date("d/m/Y",$row['invdate']).'&nbsp;</td>
							<td style="border: 1px solid #CCC;" align="right">'.number_format($row['totalamount']).'&nbsp;</td>
						</tr>
						<tr>';
							}
						}
		$message.=	'</table>
					<br><br>
					<table align="center" width="950" style="border: 1px solid #CCC; font-family: arial;">
						<tr class="footer" style="background-color: #107E7F">
							<td align="center" colspan="2">
								<span style="font-size: 12px; color: #fff; font-weight: bold;">	
									Thanks for Doing Business With Us <br> We are Always Happy to Serve You
								</span>
							</td>
						</tr>
					</table>';
		
		//echo($message);die;
			///////////////// PDF Creation //////////////////////////

			require_once __DIR__ . '/vendor/autoload.php';
			$mpdf = new \Mpdf\Mpdf();
			$pdf_file_name = "Sales Report.pdf";

			$mpdf->WriteHTML($message);
			$mpdf->Output($pdf_file_name,"D");
			die;
        	////////////////////////////////////////////////////////
	}

	function pdf_security_deposit_report($db,$URL,$aid,$startdate,$enddate)
	{

		$message = '<table align="center" style="font-family: arial;" width="950" cellspacing="0" cellpadding="0">
						<tr><td>&nbsp;</td></tr>
						<tr>
							<td width="650" align="left" valign="top">
								<img src="'.$URL.'/images/corios-logo.png" width="200">
								<br><br>
								<b>Building # 95/96, Street 8-C, Feroz Colony Outfall Road</b>
								<br>
								<b>Lahore</b>
								<br>
								<b>0300 4806769</b>
								<br>
								<b>0324 5131870</b>
							</td>';

		

		$message.=			'<td width="350" align="left" valign="top">
								<h1>Security Deposit Report</h1>';
		if($aid == 0)
		{
			$subgtno = "";
			$message.=		'<br><b>Account : All Customers</b>';
		}
		else
		{
			$subgtno = "AND L.refno = ".$_REQUEST['gtno']."";
			$aquery = $db->prepare("SELECT * FROM accounts WHERE gtno = ?");
			$aquery->execute(array($_REQUEST['gtno']));
			while($arow = $aquery->fetch())
			{
				$message.=		'<br><b>Account : '.$arow['gtno'].'-'.$arow['aname'].' - '.$arow['aemail'].'</b>';
			}
		}
									
		if($startdate != "" && $enddate !="")
		{
			$message.=				'<bR><b>Start Date: '.$startdate.'</b>
									<br>
									<b>End Date: '.$enddate.'</b>';
			$subdate = "AND L.ldate BETWEEN ".strtotime(str_replace("/", "-", $_REQUEST['startdate']))." AND ".strtotime(str_replace("/", "-", $_REQUEST['enddate']))."";
		}
		else
		{
			$subdate = "";
		}

		$message.=			'</td>
						</tr>
					</table>
					<br><br>
					<table align="center" width="950" style="border: 1px solid #CCC; font-family: arial;">
						<tr class="title">
							<td style="border: 1px solid #CCC;" width="50" align="center" bgcolor="#54271D" height="25"><span style="color: #fff; font-weight: bold;">Sr#</span></td>
							<td style="border: 1px solid #CCC;" align="left" bgcolor="#54271D" height="15">&nbsp;<b style="color: white;">GT#</b></td>
							<td style="border: 1px solid #CCC;" align="left" bgcolor="#54271D" height="15">&nbsp;<b style="color: white;">Customer</b></td>
							<td style="border: 1px solid #CCC;" width="90" align="left" bgcolor="#54271D" height="15"><b style="color: white;">Detail</b></td>
							<td style="border: 1px solid #CCC;" width="90" align="center" bgcolor="#54271D" height="15"><b style="color: white;">Date</b></td>
							<td style="border: 1px solid #CCC;" width="100" align="right" bgcolor="#54271D" height="15"><b style="color: white;">Amount</b>&nbsp;</td>
						</tr>';
						$count = 0;
						$query = $db->prepare("SELECT * FROM ledger WHERE aid=13 AND refno <> '' $subgtno $subdate ORDER BY leid DESC");
						$query->execute();
						if($query->rowCount() == 0)
						{
		$message.=		'<tr>
							<td align="center" colspan="6">
								No Record Found!
							</td>
						</tr>';					
						}
						else
						{

							while($row = $query->fetch())
							{
								$refno = $row['refno'];
								$aquery = $db->prepare("SELECT * FROM accounts WHERE gtno = ?");
								$aquery->execute(array($refno));
								while($arow = $aquery->fetch())
								{
									$name  = $arow['aname'];
									$email = $arow['aemail'];
									$gtno  = $arow['gtno'];
								}

		$message .=		'<tr>
							<td style="border: 1px solid #CCC;" align="center" class="title" height="25">&nbsp;'.$count.'</td>
							<td style="border: 1px solid #CCC;" align="left" class="title" height="25">&nbsp;'.$gtno.'</td>
							<td style="border: 1px solid #CCC;" align="left">&nbsp;'.$name." - ".$email.'</td>
							<td style="border: 1px solid #CCC;" align="left">&nbsp;'.$row['detail'].'</td>
							<td style="border: 1px solid #CCC;" align="center">'.date("d/m/Y",$row['ldate']).'&nbsp;</td>
							<td style="border: 1px solid #CCC;" align="right">'.number_format($row['credit']).'&nbsp;</td>
						</tr>
						<tr>';
							}
						}
		$message.=	'</table>
					<br><br>
					<table align="center" width="950" style="border: 1px solid #CCC; font-family: arial;">
						<tr class="footer" style="background-color: #107E7F">
							<td align="center" colspan="2">
								<span style="font-size: 12px; color: #fff; font-weight: bold;">	
									Thanks for Doing Business With Us <br> We are Always Happy to Serve You
								</span>
							</td>
						</tr>
					</table>';
		
		//echo($message);die;
			///////////////// PDF Creation //////////////////////////

			require_once __DIR__ . '/vendor/autoload.php';
			$mpdf = new \Mpdf\Mpdf();
			$pdf_file_name = "Security Deposit Report.pdf";

			$mpdf->WriteHTML($message);
			$mpdf->Output($pdf_file_name,"D");
			die;
        	////////////////////////////////////////////////////////
	}

 	function do_login()
	{
		global $db;
		global $URL;
		
		$UserName = stripslashes($_REQUEST['txtUserName']);
		$Password = md5(stripslashes($_REQUEST['txtPassword']));

		if(isset($_REQUEST['chkRemember'])) { $Remember = stripslashes($_REQUEST['chkRemember']); } else{ $Remember = 0; }

		$Query = $db->prepare("SELECT * FROM users WHERE username = ? AND password = ? AND ustatus = ?");
		$values = array($UserName , $Password , 0);
		$Query->execute($values);
		if($Query->rowCount() > 0)
		{
			while($row = $Query->fetch())
			{
				$UID	= $row['uid'];
				$UType	= $row['utype'];
			}

			// $LogDate    			= time();
			// $DeleteDate 			= $LogDate + 864000;
			// $IP						= $_SERVER['REMOTE_ADDR'];
			// $_SESSION['logdate'] 	= $LogDate;
			// $_SESSION['deletedate'] = $DeleteDate;

			// // Log Entry
			// $LogQuery = $db->prepare("INSERT INTO logreport(uid , ip , logdate , deletedate) VALUES(?,?,?,?)");
			// $LogValues = array($UID , $IP , $LogDate , $DeleteDate);
			// $LogQuery->execute($LogValues);
			
			$UserExpireDate = time()+18000;
//			setcookie("user","$UID",$UserExpireDate);
//			setcookie("usertype","$UType",$UserExpireDate);

			setcookie("user", $UID, time() + 18000, "/"); 		// 5 Hours
			setcookie("usertype", $UType, time() + 18000, "/"); // 5 Hours

			$_SESSION['user']	  = $UID;
			$_SESSION['usertype'] = $UType;

			$_COOKIE['user'] 	 = $UID;
			$_COOKIE['usertype'] = $UType;

		//	echo($UID." , ".$_SESSION['user']." , ".$_COOKIE['user']." , ".$_COOKIE['usertype']);die;
			header ("Location: $URL/main.php?");
			die;
		}
		else
		{
			header("Location: $URL/index.php?err=1");
		}
	}
	function has_loggedin()
	{
		if(isset($_SESSION['user']) && isset($_SESSION['user_lid']))
		{
			//echo("MOHSIN".$_COOKIE['user']);die;
			header("Location: main.php?");
		}
	}
	function do_logout()
	{
		global $db;
		global $URL;
		
		if($_COOKIE['usertype'] == 0) { $err = 5; } else{ $err = 6; }
		unset($_SESSION['user']);
		unset($_SESSION['usertype']);

		setcookie("user", "", time() - 18000, "/"); 	// 5 Hours
		setcookie("usertype", "", time() - 18000, "/"); // 5 Hours
		header("Location: index.php?err=$err");	
	}

	/////////////////  Add Users  /////////////////
	function add_user($db,$URL)
	{
		include("thumb.php");
		
		$Date 	  = time();
		
		$UserName = stripslashes($_REQUEST['txtUserName']);
		$Password = md5($_REQUEST['txtPassword']);
		$Email    = stripslashes($_REQUEST['txtEmail']);	
		$FullName = stripslashes($_REQUEST['txtFullName']);
		$UserType = 1;
		$PhoneNo  = stripslashes($_REQUEST['txtPhoneNo']);
		$MobileNo = stripslashes($_REQUEST['txtMobileNo']);
		$CurrentAddress  = stripslashes($_REQUEST['txtCurrentAddress']);
		$Status   = $_REQUEST['cboStatus'];

		/////////////// RIGHTS SECTION /////////////////////

		if(isset($_REQUEST['chkBulk1'])) { $chkBulk1 = 1; } else{ $chkBulk1 = 0; }
		if(isset($_REQUEST['chkBulk2'])) { $chkBulk2 = 1; } else{ $chkBulk2 = 0; }
		if(isset($_REQUEST['chkBulk3'])) { $chkBulk3 = 1; } else{ $chkBulk3 = 0; }
		if(isset($_REQUEST['chkBulk4'])) { $chkBulk4 = 1; } else{ $chkBulk4 = 0; }
		if(isset($_REQUEST['chkBulk5'])) { $chkBulk5 = 1; } else{ $chkBulk5 = 0; }

		if(isset($_REQUEST['chkBrand1'])) { $chkBrand1 = 1; } else{ $chkBrand1 = 0; }
		if(isset($_REQUEST['chkBrand2'])) { $chkBrand2 = 1; } else{ $chkBrand2 = 0; }
		if(isset($_REQUEST['chkBrand3'])) { $chkBrand3 = 1; } else{ $chkBrand3 = 0; }
		if(isset($_REQUEST['chkBrand4'])) { $chkBrand4 = 1; } else{ $chkBrand4 = 0; }
		if(isset($_REQUEST['chkBrand5'])) { $chkBrand5 = 1; } else{ $chkBrand5 = 0; }
		if(isset($_REQUEST['chkBrand6'])) { $chkBrand6 = 1; } else{ $chkBrand6 = 0; }
		if(isset($_REQUEST['chkBrand7'])) { $chkBrand7 = 1; } else{ $chkBrand7 = 0; }
		if(isset($_REQUEST['chkBrand8'])) { $chkBrand8 = 1; } else{ $chkBrand8 = 0; }
		if(isset($_REQUEST['chkBrand9'])) { $chkBrand9 = 1; } else{ $chkBrand9 = 0; }
		if(isset($_REQUEST['chkBrand10'])) { $chkBrand10 = 1; } else{ $chkBrand10 = 0; }
		if(isset($_REQUEST['chkBrand11'])) { $chkBrand11 = 1; } else{ $chkBrand11 = 0; }
		if(isset($_REQUEST['chkBrand12'])) { $chkBrand12 = 1; } else{ $chkBrand12 = 0; }
		if(isset($_REQUEST['chkBrand13'])) { $chkBrand13 = 1; } else{ $chkBrand13 = 0; }
		if(isset($_REQUEST['chkBrand14'])) { $chkBrand14 = 1; } else{ $chkBrand14 = 0; }
		if(isset($_REQUEST['chkBrand15'])) { $chkBrand15 = 1; } else{ $chkBrand15 = 0; }
		
		if(isset($_REQUEST['chkStore1'])) { $chkStore1 = 1; } else{ $chkStore1 = 0; }
		if(isset($_REQUEST['chkStore2'])) { $chkStore2 = 1; } else{ $chkStore2 = 0; }
		if(isset($_REQUEST['chkStore3'])) { $chkStore3 = 1; } else{ $chkStore3 = 0; }
		if(isset($_REQUEST['chkStore4'])) { $chkStore4 = 1; } else{ $chkStore4 = 0; }
		if(isset($_REQUEST['chkStore5'])) { $chkStore5 = 1; } else{ $chkStore5 = 0; }
		if(isset($_REQUEST['chkStore6'])) { $chkStore6 = 1; } else{ $chkStore6 = 0; }
		if(isset($_REQUEST['chkStore7'])) { $chkStore7 = 1; } else{ $chkStore7 = 0; }
		if(isset($_REQUEST['chkStore8'])) { $chkStore8 = 1; } else{ $chkStore8 = 0; }
		if(isset($_REQUEST['chkStore9'])) { $chkStore9 = 1; } else{ $chkStore9 = 0; }
		if(isset($_REQUEST['chkStore10'])) { $chkStore10 = 1; } else{ $chkStore10 = 0; }
		if(isset($_REQUEST['chkStore11'])) { $chkStore11 = 1; } else{ $chkStore11 = 0; }
		if(isset($_REQUEST['chkStore12'])) { $chkStore12 = 1; } else{ $chkStore12 = 0; }
		
		if(isset($_REQUEST['chkBa1'])) { $chkBa1 = 1; } else{ $chkBa1 = 0; }
		if(isset($_REQUEST['chkBa2'])) { $chkBa2 = 1; } else{ $chkBa2 = 0; }
		if(isset($_REQUEST['chkBa3'])) { $chkBa3 = 1; } else{ $chkBa3 = 0; }
		if(isset($_REQUEST['chkBa4'])) { $chkBa4 = 1; } else{ $chkBa4 = 0; }
		if(isset($_REQUEST['chkBa5'])) { $chkBa5 = 1; } else{ $chkBa5 = 0; }
		if(isset($_REQUEST['chkBa6'])) { $chkBa6 = 1; } else{ $chkBa6 = 0; }
		if(isset($_REQUEST['chkBa7'])) { $chkBa7 = 1; } else{ $chkBa7 = 0; }
		if(isset($_REQUEST['chkBa8'])) { $chkBa8 = 1; } else{ $chkBa8 = 0; }
		if(isset($_REQUEST['chkBa9'])) { $chkBa9 = 1; } else{ $chkBa9 = 0; }
		if(isset($_REQUEST['chkBa10'])) { $chkBa10 = 1; } else{ $chkBa10 = 0; }
		
		if(isset($_REQUEST['chkReport1'])) { $chkReport1 = 1; } else{ $chkReport1 = 0; }
		if(isset($_REQUEST['chkReport2'])) { $chkReport2 = 1; } else{ $chkReport2 = 0; }
		if(isset($_REQUEST['chkReport3'])) { $chkReport3 = 1; } else{ $chkReport3 = 0; }
		if(isset($_REQUEST['chkReport4'])) { $chkReport4 = 1; } else{ $chkReport4 = 0; }
		if(isset($_REQUEST['chkReport5'])) { $chkReport5 = 1; } else{ $chkReport5 = 0; }
		if(isset($_REQUEST['chkReport6'])) { $chkReport6 = 1; } else{ $chkReport6 = 0; }
		if(isset($_REQUEST['chkReport7'])) { $chkReport7 = 1; } else{ $chkReport7 = 0; }
		if(isset($_REQUEST['chkReport8'])) { $chkReport8 = 1; } else{ $chkReport8 = 0; }
		if(isset($_REQUEST['chkReport9'])) { $chkReport9 = 1; } else{ $chkReport9 = 0; }
		if(isset($_REQUEST['chkReport10'])) { $chkReport10 = 1; } else{ $chkReport10 = 0; }
		if(isset($_REQUEST['chkReport11'])) { $chkReport11 = 1; } else{ $chkReport11 = 0; }
		if(isset($_REQUEST['chkReport12'])) { $chkReport12 = 1; } else{ $chkReport12 = 0; }
		if(isset($_REQUEST['chkReport13'])) { $chkReport13 = 1; } else{ $chkReport13 = 0; }
		if(isset($_REQUEST['chkReport14'])) { $chkReport14 = 1; } else{ $chkReport14 = 0; }
		if(isset($_REQUEST['chkReport15'])) { $chkReport15 = 1; } else{ $chkReport15 = 0; }
		if(isset($_REQUEST['chkReport16'])) { $chkReport16 = 1; } else{ $chkReport16 = 0; }
		if(isset($_REQUEST['chkReport17'])) { $chkReport17 = 1; } else{ $chkReport17 = 0; }
		if(isset($_REQUEST['chkReport18'])) { $chkReport18 = 1; } else{ $chkReport18 = 0; }
	
		////////////////////////////////////////////////////

		$Query = $db->prepare("INSERT INTO users(utype,username , password , email , fullname , mobileno1 , address , udate) VALUES(?,?,?,?,?,?,?,?)");
		$values = array($UserType, $UserName , $Password , $Email , $FullName , $MobileNo , $CurrentAddress , $Date);
		if($Query->execute($values))
		{
			$Uid = $db->lastInsertId();
			
			$Query2 = $db->prepare("INSERT INTO rights(uid, bulk_brands, bulk_products, bulk_stores, bulk_ba, bulk_supervisor, add_category, edit_category, delete_category, add_brand, edit_brand, delete_brand, add_cbrand, edit_cbrand, delete_cbrand, add_product, edit_product, delete_product, add_survey, edit_survey, delete_survey, add_area, edit_area, delete_area, add_city, edit_city, delete_city, add_schain, edit_schain, delete_schain, add_store, edit_store, delete_store, add_ba, edit_ba, delete_ba, ba_attendance_remarks, add_assignment, edit_assignment, delete_assignment, add_supervisor, edit_supervisor, delete_supervisor, activation_report, ba_data_report, daily_sale_report, attendance_report, sales_report, stock_report, price_report, performance_report, survey_report, usership_report, visit_report, visit_summary_report, store_wise_visit_report, supervisor_attendance_report, data_input_report, analysis_report, login_report, client_activation_report, udate) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
			
			$UserValues = array($Uid,$chkBulk1,$chkBulk2,$chkBulk3,$chkBulk4,$chkBulk5,$chkBrand1,$chkBrand2,$chkBrand3,$chkBrand4,$chkBrand5,$chkBrand6,$chkBrand7,$chkBrand8,$chkBrand9,$chkBrand10,$chkBrand11,$chkBrand12,$chkBrand13,$chkBrand14,$chkBrand15,$chkStore1,$chkStore2,$chkStore3,$chkStore4,$chkStore5,$chkStore6,$chkStore7,$chkStore8,$chkStore9,$chkStore10,$chkStore10,$chkStore11,$chkStore12,$chkBa1,$chkBa2,$chkBa3,$chkBa4,$chkBa5,$chkBa6,$chkBa7,$chkBa8,$chkBa9,$chkReport1,$chkReport2,$chkReport3,$chkReport4,$chkReport5,$chkReport6,$chkReport7,$chkReport8,$chkReport9,$chkReport10,$chkReport11,$chkReport12,$chkReport13,$chkReport14,$chkReport15,$chkReport16,$chkReport17,$chkReport18,$Date);	

			if($Query2->execute($UserValues))
			{
				///////////////////// LOG SECTION /////////////////////
			    //$log = "$FullName - User has been created";
				//log_entry($log);
			    ///////////////////////////////////////////////////////
				header("Location: $URL/users.php?&err=2");
				die;
			}
		}
	}
	///////////////////////////////////////////////////////
	/////////////////  Update User  ///////////////////////
	function update_user($db,$URL,$Uid)
	{
		include("thumb.php");

		$Date 	  = time();
		
		
		
		$FullName = stripslashes($_REQUEST['txtFullName']);

		$UserType = 1;
		$Lid 	  = 1;

		$MobileNo = stripslashes($_REQUEST['txtMobileNo']);
		$CurrentAddress  = stripslashes($_REQUEST['txtCurrentAddress']);
		
		$Status   = $_REQUEST['cboStatus'];
		

      	/////////////// RIGHTS SECTION /////////////////////

		if(isset($_REQUEST['chkBulk1'])) { $chkBulk1 = 1; } else{ $chkBulk1 = 0; }
		if(isset($_REQUEST['chkBulk2'])) { $chkBulk2 = 1; } else{ $chkBulk2 = 0; }
		if(isset($_REQUEST['chkBulk3'])) { $chkBulk3 = 1; } else{ $chkBulk3 = 0; }
		if(isset($_REQUEST['chkBulk4'])) { $chkBulk4 = 1; } else{ $chkBulk4 = 0; }
		if(isset($_REQUEST['chkBulk5'])) { $chkBulk5 = 1; } else{ $chkBulk5 = 0; }

		if(isset($_REQUEST['chkBrand1'])) { $chkBrand1 = 1; } else{ $chkBrand1 = 0; }
		if(isset($_REQUEST['chkBrand2'])) { $chkBrand2 = 1; } else{ $chkBrand2 = 0; }
		if(isset($_REQUEST['chkBrand3'])) { $chkBrand3 = 1; } else{ $chkBrand3 = 0; }
		if(isset($_REQUEST['chkBrand4'])) { $chkBrand4 = 1; } else{ $chkBrand4 = 0; }
		if(isset($_REQUEST['chkBrand5'])) { $chkBrand5 = 1; } else{ $chkBrand5 = 0; }
		if(isset($_REQUEST['chkBrand6'])) { $chkBrand6 = 1; } else{ $chkBrand6 = 0; }
		if(isset($_REQUEST['chkBrand7'])) { $chkBrand7 = 1; } else{ $chkBrand7 = 0; }
		if(isset($_REQUEST['chkBrand8'])) { $chkBrand8 = 1; } else{ $chkBrand8 = 0; }
		if(isset($_REQUEST['chkBrand9'])) { $chkBrand9 = 1; } else{ $chkBrand9 = 0; }
		if(isset($_REQUEST['chkBrand10'])) { $chkBrand10 = 1; } else{ $chkBrand10 = 0; }
		if(isset($_REQUEST['chkBrand11'])) { $chkBrand11 = 1; } else{ $chkBrand11 = 0; }
		if(isset($_REQUEST['chkBrand12'])) { $chkBrand12 = 1; } else{ $chkBrand12 = 0; }
		if(isset($_REQUEST['chkBrand13'])) { $chkBrand13 = 1; } else{ $chkBrand13 = 0; }
		if(isset($_REQUEST['chkBrand14'])) { $chkBrand14 = 1; } else{ $chkBrand14 = 0; }
		if(isset($_REQUEST['chkBrand15'])) { $chkBrand15 = 1; } else{ $chkBrand15 = 0; }
		
		if(isset($_REQUEST['chkStore1'])) { $chkStore1 = 1; } else{ $chkStore1 = 0; }
		if(isset($_REQUEST['chkStore2'])) { $chkStore2 = 1; } else{ $chkStore2 = 0; }
		if(isset($_REQUEST['chkStore3'])) { $chkStore3 = 1; } else{ $chkStore3 = 0; }
		if(isset($_REQUEST['chkStore4'])) { $chkStore4 = 1; } else{ $chkStore4 = 0; }
		if(isset($_REQUEST['chkStore5'])) { $chkStore5 = 1; } else{ $chkStore5 = 0; }
		if(isset($_REQUEST['chkStore6'])) { $chkStore6 = 1; } else{ $chkStore6 = 0; }
		if(isset($_REQUEST['chkStore7'])) { $chkStore7 = 1; } else{ $chkStore7 = 0; }
		if(isset($_REQUEST['chkStore8'])) { $chkStore8 = 1; } else{ $chkStore8 = 0; }
		if(isset($_REQUEST['chkStore9'])) { $chkStore9 = 1; } else{ $chkStore9 = 0; }
		if(isset($_REQUEST['chkStore10'])) { $chkStore10 = 1; } else{ $chkStore10 = 0; }
		if(isset($_REQUEST['chkStore11'])) { $chkStore11 = 1; } else{ $chkStore11 = 0; }
		if(isset($_REQUEST['chkStore12'])) { $chkStore12 = 1; } else{ $chkStore12 = 0; }
		
		if(isset($_REQUEST['chkBa1'])) { $chkBa1 = 1; } else{ $chkBa1 = 0; }
		if(isset($_REQUEST['chkBa2'])) { $chkBa2 = 1; } else{ $chkBa2 = 0; }
		if(isset($_REQUEST['chkBa3'])) { $chkBa3 = 1; } else{ $chkBa3 = 0; }
		if(isset($_REQUEST['chkBa4'])) { $chkBa4 = 1; } else{ $chkBa4 = 0; }
		if(isset($_REQUEST['chkBa5'])) { $chkBa5 = 1; } else{ $chkBa5 = 0; }
		if(isset($_REQUEST['chkBa6'])) { $chkBa6 = 1; } else{ $chkBa6 = 0; }
		if(isset($_REQUEST['chkBa7'])) { $chkBa7 = 1; } else{ $chkBa7 = 0; }
		if(isset($_REQUEST['chkBa8'])) { $chkBa8 = 1; } else{ $chkBa8 = 0; }
		if(isset($_REQUEST['chkBa9'])) { $chkBa9 = 1; } else{ $chkBa9 = 0; }
		if(isset($_REQUEST['chkBa10'])) { $chkBa10 = 1; } else{ $chkBa10 = 0; }
		
		if(isset($_REQUEST['chkReport1'])) { $chkReport1 = 1; } else{ $chkReport1 = 0; }
		if(isset($_REQUEST['chkReport2'])) { $chkReport2 = 1; } else{ $chkReport2 = 0; }
		if(isset($_REQUEST['chkReport3'])) { $chkReport3 = 1; } else{ $chkReport3 = 0; }
		if(isset($_REQUEST['chkReport4'])) { $chkReport4 = 1; } else{ $chkReport4 = 0; }
		if(isset($_REQUEST['chkReport5'])) { $chkReport5 = 1; } else{ $chkReport5 = 0; }
		if(isset($_REQUEST['chkReport6'])) { $chkReport6 = 1; } else{ $chkReport6 = 0; }
		if(isset($_REQUEST['chkReport7'])) { $chkReport7 = 1; } else{ $chkReport7 = 0; }
		if(isset($_REQUEST['chkReport8'])) { $chkReport8 = 1; } else{ $chkReport8 = 0; }
		if(isset($_REQUEST['chkReport9'])) { $chkReport9 = 1; } else{ $chkReport9 = 0; }
		if(isset($_REQUEST['chkReport10'])) { $chkReport10 = 1; } else{ $chkReport10 = 0; }
		if(isset($_REQUEST['chkReport11'])) { $chkReport11 = 1; } else{ $chkReport11 = 0; }
		if(isset($_REQUEST['chkReport12'])) { $chkReport12 = 1; } else{ $chkReport12 = 0; }
		if(isset($_REQUEST['chkReport13'])) { $chkReport13 = 1; } else{ $chkReport13 = 0; }
		if(isset($_REQUEST['chkReport14'])) { $chkReport14 = 1; } else{ $chkReport14 = 0; }
		if(isset($_REQUEST['chkReport15'])) { $chkReport15 = 1; } else{ $chkReport15 = 0; }
		if(isset($_REQUEST['chkReport16'])) { $chkReport16 = 1; } else{ $chkReport16 = 0; }
		if(isset($_REQUEST['chkReport17'])) { $chkReport17 = 1; } else{ $chkReport17 = 0; }
		if(isset($_REQUEST['chkReport18'])) { $chkReport18 = 1; } else{ $chkReport18 = 0; }
		
		////////////////////////////////////////////////////
		

		
		$Query = $db->prepare("UPDATE users SET fullname=? , mobileno1=? , address=? , ustatus=? WHERE uid=?");
		$values = array($FullName , $MobileNo , $CurrentAddress , $Status , $Uid);
	
    	$Query2 = $db->prepare("UPDATE rights SET bulk_brands=?, bulk_products=?, bulk_stores=?, bulk_ba=?, bulk_supervisor=?, add_category=?, edit_category=?, delete_category=?, add_brand=?, edit_brand=?, delete_brand=?, add_cbrand=?, edit_cbrand=?, delete_cbrand=?, add_product=?, edit_product=?, delete_product=?, add_survey=?, edit_survey=?, delete_survey=?, add_area=?, edit_area=?, delete_area=?, add_city=?, edit_city=?, delete_city=?, add_schain=?, edit_schain=?, delete_schain=?, add_store=?, edit_store=?, delete_store=?, add_ba=?, edit_ba=?, delete_ba=?, ba_attendance_remarks=?, add_assignment=?, edit_assignment=?, delete_assignment=?, add_supervisor=?, edit_supervisor=?, delete_supervisor=?, activation_report=?, ba_data_report=?, daily_sale_report=?, attendance_report=?, sales_report=?, stock_report=?, price_report=?, performance_report=?, survey_report=?, usership_report=?, visit_report=?, visit_summary_report=?, store_wise_visit_report=?, supervisor_attendance_report=?, data_input_report=?, analysis_report=?, login_report=?, client_activation_report=? WHERE uid = ?");
			
			$UserValues = array($chkBulk1,$chkBulk2,$chkBulk3,$chkBulk4,$chkBulk5,$chkBrand1,$chkBrand2,$chkBrand3,$chkBrand4,$chkBrand5,$chkBrand6,$chkBrand7,$chkBrand8,$chkBrand9,$chkBrand10,$chkBrand11,$chkBrand12,$chkBrand13,$chkBrand14,$chkBrand15,$chkStore1,$chkStore2,$chkStore3,$chkStore4,$chkStore5,$chkStore6,$chkStore7,$chkStore8,$chkStore9,$chkStore10,$chkStore10,$chkStore11,$chkStore12,$chkBa1,$chkBa2,$chkBa3,$chkBa4,$chkBa5,$chkBa6,$chkBa7,$chkBa8,$chkBa9,$chkReport1,$chkReport2,$chkReport3,$chkReport4,$chkReport5,$chkReport6,$chkReport7,$chkReport8,$chkReport9,$chkReport10,$chkReport11,$chkReport12,$chkReport13,$chkReport14,$chkReport15,$chkReport16,$chkReport17,$chkReport18,$Uid);
		
		$Query->execute($values);
		$Query2->execute($UserValues);
		///////////////////// LOG SECTION /////////////////////
	    //$log = "$FullName - User has been updated";
		//log_entry($log);
	    ///////////////////////////////////////////////////////
		header("Location: $URL/users.php?&err=3");
	}
	///////////////////////////////////////////////////////
	/////////////////  Update Profile  ///////////////////////
	function update_profile($db,$URL,$uid)
	{
		$FullName = stripslashes($_REQUEST['txtFullName']);
		$PhoneNo  = stripslashes($_REQUEST['txtPhoneNo']);
		$MobileNo = stripslashes($_REQUEST['txtMobileNo']);
		$CurrentAddress  = stripslashes($_REQUEST['txtCurrentAddress']);
		$Dob  = stripslashes($_REQUEST['txtDob']);
		$Nationality  = stripslashes($_REQUEST['txtNationality']);
		$Religion  = stripslashes($_REQUEST['txtReligion']);
		$CnicNo  = stripslashes($_REQUEST['txtCnicNo']);

		if(isset($_POST['chkRights']))
		{
			$user_rights = implode(",", $_POST['chkRights']);	
		}
		else
		{
			$user_rights = "";	
		}

		$Query = $db->prepare("UPDATE users SET fullname=? , phoneno=? , mobileno=? , currentaddress=? , dob=? , nationality=? , religion=? , cnic=? , quick_links=? WHERE uid=?");
		$values = array($FullName , $PhoneNo , $MobileNo , $CurrentAddress , $Dob , $Nationality , $Religion , $CnicNo , $user_rights , $uid);	
		$Query->execute($values);
		///////////////////// LOG SECTION /////////////////////
	    $log = "$FullName - User Profile has been updated";
		log_entry($log);
	    ///////////////////////////////////////////////////////
		header("Location: $URL/editprofile.php?&err=3");
	}
	///////////////////////////////////////////////////////
	/////////////////  Update Password  ///////////////////
	function update_password()
	{
		include("thumb.php");
		global $db;
		global $URL;
		
		$Date 	  = time();
		$UserID   = $_SESSION['user'];

		$OldPassword = stripslashes($_REQUEST['txtOldPassword']);		
		$NewPassword = stripslashes($_REQUEST['txtNewPassword']);
		$ConfirmPassword = stripslashes($_REQUEST['txtConfirmPassword']);
		$EncryptPassword = md5($NewPassword);

		$oldquery = $db->prepare("SELECT * FROM users WHERE password=? AND uid=?");
		$oldquery->execute(array(md5($OldPassword),$UserID));
		if($oldquery->rowCount() > 0)
		{
			if($NewPassword != "" && $NewPassword == $ConfirmPassword)
			{
				$Query = $db->prepare("UPDATE users SET password=? WHERE uid=?");
				$values = array($EncryptPassword , $UserID);
				if($Query->execute($values))
				{
					///////////////////// LOG SECTION /////////////////////
				    $log = "User password has been updated";
					log_entry($log);
				    ///////////////////////////////////////////////////////
					header("Location: $URL/update_password.php?&err=3");
				}	
			}
			else
			{
				header("Location: $URL/update_password.php?&err=57");
			}
		}
		else
		{
			header("Location: $URL/update_password.php?&err=58");
		}
	}
	///////////////////////////////////////////////////////
	/////////////////  Delete User  ///////////////////////
	function delete_user($Uid)
	{
		global $db;
		global $URL;
		
		$UserQuery = $db->prepare("SELECT * FROM users WHERE uid = ?");
		$UserQuery->execute(array($Uid));
		while($row = $UserQuery->fetch())
		{
			if($row['userimage'] != "")
			{
				unlink("img/users/".$row['userimage']);
			}
		}
		$Query1 = $db->prepare("DELETE FROM users WHERE uid=?");
		$Query2 = $db->prepare("DELETE FROM rights WHERE uid=?");
		if($Query1->execute(array($Uid)) && $Query2->execute(array($Uid)))
		{
			///////////////////// LOG SECTION /////////////////////
		    $log = "User has been deleted";
			log_entry($log);
		    ///////////////////////////////////////////////////////
			header("Location: users.php?err=4");
		}
	}
	/////////////////  Bulk Upload Functions  ///////////////////////

	function add_bulk_brand($db,$URL)
	{
		$date = time();
		
		$File	      = $_FILES['file']['name'];
		$TmpFile 	  = $_FILES['file']['tmp_name'];
		$ext 	 	  = pathinfo($File, PATHINFO_EXTENSION);
		$target_path  = "images/tmp_csv/";
		$target_path  = $target_path . basename($File);
		
		if($ext == "csv")
		{
			//echo("MOHSIN");die;
		    if(move_uploaded_file($TmpFile, $target_path))
			{
				$contents = file ("images/tmp_csv/".$File);
				for($i=0; $i<sizeof($contents); $i++)
				{
					$line = trim($contents[$i],'",');
					$arr = explode(',', $line);
					//$tmsno = explode('*', $arr[1]);
				//	$barcode = $arr[1];

					$pquery = $db->prepare("SELECT brname FROM brand WHERE brname = ?");
					$pquery->execute(array($arr[0]));
					if($pquery->rowCount() == 0)
					{
						$query = $db->prepare("INSERT INTO brand(brname, brdate) VALUES(?,?)");
						$values = array($arr[0], $date);	
						$query->execute($values);
					}
				}
			}
			unlink("images/tmp_csv/".$File);
			//$log = "Bulk Products have been added";
			//log_entry($log);
			header("Location: brands.php?err=2");
		}
	}


	function add_bulk_products($db,$URL)
	{
		$date = time();
		$brid   = $_REQUEST['cboBrand'];
		
		$File	      = $_FILES['file']['name'];
		$TmpFile 	  = $_FILES['file']['tmp_name'];
		$ext 	 	  = pathinfo($File, PATHINFO_EXTENSION);
		$target_path  = "images/tmp_csv/";
		$target_path  = $target_path . basename($File);
		
		if($ext == "csv")
		{
			//echo("MOHSIN");die;
		    if(move_uploaded_file($TmpFile, $target_path))
			{
				$contents = file ("images/tmp_csv/".$File);
				for($i=0; $i<sizeof($contents); $i++)
				{
					$line = trim($contents[$i],'",');
					$arr = explode(',', $line);
					//$tmsno = explode('*', $arr[1]);
				//	$barcode = $arr[1];

					$pquery = $db->prepare("SELECT pname, sku FROM products WHERE pname = ? AND sku=?");
					$pquery->execute(array($arr[0],$arr[1]));
					if($pquery->rowCount() == 0)
					{
						$query = $db->prepare("INSERT INTO products(brid, pname, sku, ptype, psize, pprice, unit_type, pweight, pdate) VALUES(?,?,?,?,?,?,?,?,?)");
						$values = array($brid, $arr[0], $arr[1], $arr[2], $arr[3], $arr[4], $arr[5], $arr[6], $date);	
						$query->execute($values);
					}
				}
			}
			unlink("images/tmp_csv/".$File);
			//$log = "Bulk Products have been added";
			//log_entry($log);
			header("Location: products.php?err=2");
		}
	}

	function add_bulk_stores($db,$URL)
	{
		$date = time();
		
		$File	      = $_FILES['file']['name'];
		$TmpFile 	  = $_FILES['file']['tmp_name'];
		$ext 	 	  = pathinfo($File, PATHINFO_EXTENSION);
		$target_path  = "images/tmp_csv/";
		$target_path  = $target_path . basename($File);
		
		if($ext == "csv")
		{
			//echo("MOHSIN");die;
		    if(move_uploaded_file($TmpFile, $target_path))
			{
				$contents = file ("images/tmp_csv/".$File);
				for($i=0; $i<sizeof($contents); $i++)
				{
					$line = trim($contents[$i],'",');
					$arr = explode(',', $line);
					//$tmsno = explode('*', $arr[1]);
				//	$barcode = $arr[1];

					$pquery = $db->prepare("SELECT store_name FROM store WHERE store_name = ?");
					$pquery->execute(array($arr[0]));
					if($pquery->rowCount() == 0)
					{
						$query = $db->prepare("INSERT INTO store(store_name, city, stlat, stlong, off_day, uniform, scarf, badge, data_sheet, device, store_card, stdate) VALUES(?,?,?,?,?,?,?,?,?,?,?,?)");
						$values = array($arr[0], $arr[1], $arr[2], $arr[3], $arr[4], $arr[5], $arr[6], $arr[7], $arr[8], $arr[9], $arr[10], $date);	
						$query->execute($values);
					}
				}
			}
			unlink("images/tmp_csv/".$File);
			//$log = "Bulk Products have been added";
			//log_entry($log);
			header("Location: products.php?err=2");
		}
	}

	function add_bulk_ba($db,$URL)
	{
		$date = time();
		
		$File	      = $_FILES['file']['name'];
		$TmpFile 	  = $_FILES['file']['tmp_name'];
		$ext 	 	  = pathinfo($File, PATHINFO_EXTENSION);
		$target_path  = "images/tmp_csv/";
		$target_path  = $target_path . basename($File);
		
		if($ext == "csv")
		{
			//echo("MOHSIN");die;
		    if(move_uploaded_file($TmpFile, $target_path))
			{
				$contents = file ("images/tmp_csv/".$File);
				for($i=0; $i<sizeof($contents); $i++)
				{
					$line = trim($contents[$i],'",');
					$arr = explode(',', $line);
					
					
					$pquery = $db->prepare("SELECT utype, cnic_no FROM users WHERE utype = ? AND cnic_no=?");
					$pquery->execute(array(4,$arr[0]));
					$num_ba = $pquery->rowCount();
					if($num_ba == 0)
					{
					
						$baquery = $db->prepare("SELECT uid, utype, ba_no FROM users WHERE utype = ? ORDER BY uid DESC LIMIT 0,1");
						$baquery->execute(array(4));
						if($baquery->rowCount() == 0)
						{
							$ba_no = 1000;
						}
						else{
							while($barow = $baquery->fetch())
							{
								$ba_no = $barow['ba_no'] + 1;	
							}	
						}
						$username = strtolower(str_replace(" ", "", $arr[1]))."_ba".$ba_no;
						$password = md5("sentient_ba");

						$query = $db->prepare("INSERT INTO users(utype, ba_no, username, password, market_name, father_name, fullname, email, mobileno1, mobileno2, emergencyno, education, marketing_exp, covid_cert, marital_status, cnic_no, address, area, city, dob, religion, bank_iban, bank_name, udate) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
						$values = array(4, $ba_no, $username, $password, $arr[2], $arr[3], $arr[1], $arr[5], $arr[6], $arr[7], $arr[8], $arr[14], $arr[15], $arr[16], $arr[12], $arr[0], $arr[10], $arr[9], $arr[11], $arr[4], $arr[13], $arr[18], $arr[17], $date);	
						$query->execute($values);
					}
				}
			}
			unlink("images/tmp_csv/".$File);
			//$log = "Bulk Products have been added";
			//log_entry($log);
			header("Location: ba.php?err=2");
		}
	}

	function add_bulk_supervisor($db,$URL)
	{
		$date = time();
		
		$File	      = $_FILES['file']['name'];
		$TmpFile 	  = $_FILES['file']['tmp_name'];
		$ext 	 	  = pathinfo($File, PATHINFO_EXTENSION);
		$target_path  = "images/tmp_csv/";
		$target_path  = $target_path . basename($File);
		
		if($ext == "csv")
		{
			//echo("MOHSIN");die;
		    if(move_uploaded_file($TmpFile, $target_path))
			{
				$contents = file ("images/tmp_csv/".$File);
				for($i=0; $i<sizeof($contents); $i++)
				{
					$line = trim($contents[$i],'",');
					$arr = explode(',', $line);
					//$tmsno = explode('*', $arr[1]);
				//	$barcode = $arr[1];

					$pquery = $db->prepare("SELECT utype, cnic_no FROM users WHERE utype = ? AND cnic_no=?");
					$pquery->execute(array(3,$arr[0]));
					if($pquery->rowCount() == 0)
					{
						$suquery = $db->prepare("SELECT uid, utype, su_no FROM users WHERE utype = ? ORDER BY uid DESC LIMIT 0,1");
						$suquery->execute(array(3));
						if($suquery->rowCount() == 0)
						{
							$su_no = 1000;
						}
						else{
							while($surow = $suquery->fetch())
							{
								$su_no = $surow['su_no'] + 1;	
							}	
						}
						$username = strtolower(str_replace(" ", "", $arr[1]))."_su".$su_no;
						$password = md5("sentient_su");

						$query = $db->prepare("INSERT INTO users(utype, su_no, username, password, fullname, mobileno1, mobileno2, mobileno3, emergencyno, cnic_no, address, city, udate) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?)");
						$values = array(3, $su_no, $username, $password, $arr[1], $arr[3], $arr[4], $arr[5], $arr[6], $arr[0], $arr[7], $arr[2], $date);	
						$query->execute($values);
					}
				}
			}
			unlink("images/tmp_csv/".$File);
			//$log = "Bulk Products have been added";
			//log_entry($log);
			header("Location: supervisors.php?err=2");
		}
	}
	/////////////////  Chain Store  ///////////////////////
	
	function add_store_chain($db,$URL)
	{
		$store_chain 	  = stripslashes($_REQUEST['txtStoreChain']);
	
		$Query = $db->prepare("INSERT INTO store_chain(store_chain) VALUES(?)");
		$values = array($store_chain);
		if($Query->execute($values))
		{
			header("Location: $URL/store_chain.php?&err=2");
			die;
		}	
	}	
	function update_store_chain($db,$URL,$stcid)
	{
		$store_chain 	  = stripslashes($_REQUEST['txtStoreChain']);

		$Query = $db->prepare("UPDATE store_chain SET store_chain=? WHERE stcid = ?");
		$values = array($store_chain,$stcid);
		if($Query->execute($values))
		{
			header("Location: $URL/store_chain.php?&err=3");
			die;
		}	
	}	
	function delete_store_chain($db,$URL,$stcid)
	{
		$Query = $db->prepare("DELETE FROM store_chain WHERE stcid=?");
		$values = array($stcid);
		if($Query->execute($values))
		{
			header("Location: $URL/store_chain.php?&err=4");
			die;
		}
	}
	/////////////////  Area  ///////////////////////
	
	function add_area($db,$URL)
	{
		$area 	  = stripslashes($_REQUEST['txtArea']);
	
		$Query = $db->prepare("INSERT INTO area(area) VALUES(?)");
		$values = array($area);
		if($Query->execute($values))
		{
			header("Location: $URL/area.php?&err=2");
			die;
		}	
	}	
	function update_area($db,$URL,$ID)
	{
		$area 	  = stripslashes($_REQUEST['txtArea']);

		$Query = $db->prepare("UPDATE area SET area=? WHERE id = ?");
		$values = array($area,$ID);
		if($Query->execute($values))
		{
			header("Location: $URL/area.php?&err=3");
			die;
		}	
	}	
	function delete_area($db,$URL,$ID)
	{
		$Query = $db->prepare("DELETE FROM area WHERE id=?");
		$values = array($ID);
		if($Query->execute($values))
		{
			header("Location: $URL/area.php?&err=4");
			die;
		}
	}
	/////////////////  Cities  ///////////////////////
	function add_city($db,$URL)
	{
		$date = time();
		$city_code = stripslashes($_REQUEST['txtCityCode']);
		$city_name = stripslashes($_REQUEST['txtCityName']);
		$region = stripslashes($_REQUEST['cboRegion']);
		$tier = stripslashes($_REQUEST['txtTier']);	

		$Query = $db->prepare("INSERT INTO cities(city_code, city_name, region, tier, citdate) VALUES(?,?,?,?,?)");	
		$values = array($city_code, $city_name, $region, $tier, $date);
		if($Query->execute($values))
		{
			///////////////////// LOG SECTION /////////////////////
		    //$log = "$color - Color has been created";
			//log_entry($log);
		    ///////////////////////////////////////////////////////
			header("Location: $URL/cities.php?&err=2");
			die;
		}
	}
	function update_city($db,$URL,$citid)
	{
		$city_code = stripslashes($_REQUEST['txtCityCode']);
		$city_name = stripslashes($_REQUEST['txtCityName']);
		$region = stripslashes($_REQUEST['cboRegion']);
		$tier = stripslashes($_REQUEST['txtTier']);	

		$Query = $db->prepare("UPDATE cities SET city_code=?, city_name=?, region=?, tier=? WHERE citid=?");	
		$values = array($city_code, $city_name, $region, $tier, $citid);
		if($Query->execute($values))
		{
			///////////////////// LOG SECTION /////////////////////
		    //$log = "$color - Color has been created";
			//log_entry($log);
		    ///////////////////////////////////////////////////////
			header("Location: $URL/cities.php?&err=3");
			die;
		}
	}
	function delete_city($db,$URL,$citid)
	{
		$Query = $db->prepare("DELETE FROM cities WHERE citid=?");
		$values = array($citid);
		if($Query->execute($values))
		{
			header("Location: $URL/cities.php?&err=4");
			die;
		}
	}
	/////////////////  Attendance Type  ///////////////////////
	function add_atremarks($db,$URL)
	{
		$date = time();
		$remarks = stripslashes($_REQUEST['txtRemarks']);
		$code = stripslashes($_REQUEST['txtCode']);
		$value = stripslashes($_REQUEST['cboValue']);

		$Query = $db->prepare("INSERT INTO attendance_type(attendance_type, attendance_code, attendance_value) VALUES(?,?,?)");	
		$values = array($remarks, $code, $value);
		if($Query->execute($values))
		{
			///////////////////// LOG SECTION /////////////////////
		    //$log = "$color - Color has been created";
			//log_entry($log);
		    ///////////////////////////////////////////////////////
			header("Location: $URL/atremarks.php?&err=2");
			die;
		}
	}
	function update_atremarks($db,$URL,$attid)
	{
		$date = time();
		$remarks = stripslashes($_REQUEST['txtRemarks']);
		$code = stripslashes($_REQUEST['txtCode']);
		$value = stripslashes($_REQUEST['cboValue']);

		$Query = $db->prepare("UPDATE attendance_type SET attendance_type=?, attendance_code=?, attendance_value=? WHERE attid=?");	
		$values = array($remarks, $code, $value, $attid);
		if($Query->execute($values))
		{
			///////////////////// LOG SECTION /////////////////////
		    //$log = "$color - Color has been created";
			//log_entry($log);
		    ///////////////////////////////////////////////////////
			header("Location: $URL/atremarks.php?&err=3");
			die;
		}
	}
	function delete_atremarks($db,$URL,$attid)
	{
		$Query = $db->prepare("DELETE FROM attendance_type WHERE attid=?");
		$values = array($attid);
		if($Query->execute($values))
		{
			header("Location: $URL/atremarks.php?&err=4");
			die;
		}
	}
	/////////////////  Vacant Remarks  ///////////////////////
	function add_varemarks($db,$URL)
	{
		$date = time();
		$remarks = stripslashes($_REQUEST['txtRemarks']);
		
		$Query = $db->prepare("INSERT INTO vacant_remarks(vacant_remarks) VALUES(?)");	
		$values = array($remarks);
		if($Query->execute($values))
		{
			///////////////////// LOG SECTION /////////////////////
		    //$log = "$color - Color has been created";
			//log_entry($log);
		    ///////////////////////////////////////////////////////
			header("Location: $URL/varemarks.php?&err=2");
			die;
		}
	}
	function update_varemarks($db,$URL,$id)
	{
		$date = time();
		$remarks = stripslashes($_REQUEST['txtRemarks']);

		$Query = $db->prepare("UPDATE vacant_remarks SET vacant_remarks=? WHERE id=?");	
		$values = array($remarks, $id);
		if($Query->execute($values))
		{
			///////////////////// LOG SECTION /////////////////////
		    //$log = "$color - Color has been created";
			//log_entry($log);
		    ///////////////////////////////////////////////////////
			header("Location: $URL/varemarks.php?&err=3");
			die;
		}
	}
	function delete_varemarks($db,$URL,$id)
	{
		$Query = $db->prepare("DELETE FROM vacant_remarks WHERE id=?");
		$values = array($id);
		if($Query->execute($values))
		{
			header("Location: $URL/varemarks.php?&err=4");
			die;
		}
	}
	/////////////////  Category  ///////////////////////
	
	function add_category($db,$URL)
	{
		$category 	  = stripslashes($_REQUEST['txtCategory']);
		$status 	  = stripslashes($_REQUEST['cboStatus']);
	
		$Query = $db->prepare("INSERT INTO category(category,cstatus,cdate) VALUES(?,?,?)");
		$values = array($category,$status,time());
		if($Query->execute($values))
		{
			header("Location: $URL/category.php?&err=2");
			die;
		}	
	}	
	function update_category($db,$URL,$CID)
	{
		$Category 	  = stripslashes($_REQUEST['txtCategory']);
		$Status 	  = stripslashes($_REQUEST['cboStatus']);

		$Query = $db->prepare("UPDATE category SET category=?,cstatus=? WHERE cid = ?");
		$values = array($Category,$Status,$CID);
		if($Query->execute($values))
		{
			header("Location: $URL/category.php?&err=3");
			die;
		}	
	}	
	function delete_category($db,$URL,$CID)
	{
		$Query = $db->prepare("DELETE FROM category WHERE cid=?");
		$values = array($CID);
		if($Query->execute($values))
		{
			header("Location: $URL/category.php?&err=4");
			die;
		}
	}
	/////////////////  Brands  ///////////////////////
	function add_brand($db,$URL)
	{
		$date = time();
		$brand = stripslashes($_REQUEST['txtBrand']);
		$status = stripslashes($_REQUEST['cboStatus']);	

		$Query = $db->prepare("INSERT INTO brand(brname,brstatus,brdate) VALUES(?,?,?)");	
		$values = array($brand, $status, $date);
		if($Query->execute($values))
		{
			///////////////////// LOG SECTION /////////////////////
		    //$log = "$color - Color has been created";
			//log_entry($log);
		    ///////////////////////////////////////////////////////
			header("Location: $URL/brands.php?&err=2");
			die;
		}
	}
	function update_brand($db,$URL,$brid)
	{
		$date = time();
		$brand = stripslashes($_REQUEST['txtBrand']);
		$status = stripslashes($_REQUEST['cboStatus']);	

		$Query = $db->prepare("UPDATE brand SET brname=?, brstatus=? WHERE brid=?");	
		$values = array($brand, $status, $brid);
		if($Query->execute($values))
		{
			///////////////////// LOG SECTION /////////////////////
		    //$log = "$color - Color has been created";
			//log_entry($log);
		    ///////////////////////////////////////////////////////
			header("Location: $URL/brands.php?&err=3");
			die;
		}
	}
	function delete_brand($db,$URL,$brid)
	{
		$Query = $db->prepare("DELETE FROM brand WHERE brid=?");
		$values = array($brid);
		if($Query->execute($values))
		{
			header("Location: $URL/brands.php?&err=4");
			die;
		}
	}
    /////////////////  Competitor Brands  ///////////////////////
	function add_combrand($db,$URL)
	{
		$date = time();
		$brand = stripslashes($_REQUEST['txtBrand']);
		$status = stripslashes($_REQUEST['cboStatus']);	

		$Query = $db->prepare("INSERT INTO cbrand(cbrname,cbrstatus,cbrdate) VALUES(?,?,?)");	
		$values = array($brand, $status, $date);
		if($Query->execute($values))
		{
			///////////////////// LOG SECTION /////////////////////
		    //$log = "$color - Color has been created";
			//log_entry($log);
		    ///////////////////////////////////////////////////////
			header("Location: $URL/combrands.php?&err=2");
			die;
		}
	}
	function update_combrand($db,$URL,$cbrid)
	{
		$date = time();
		$brand = stripslashes($_REQUEST['txtBrand']);
		$status = stripslashes($_REQUEST['cboStatus']);	

		$Query = $db->prepare("UPDATE cbrand SET cbrname=?, cbrstatus=? WHERE cbrid=?");	
		$values = array($brand, $status, $cbrid);
		if($Query->execute($values))
		{
			///////////////////// LOG SECTION /////////////////////
		    //$log = "$color - Color has been created";
			//log_entry($log);
		    ///////////////////////////////////////////////////////
			header("Location: $URL/combrands.php?&err=3");
			die;
		}
	}
	function delete_combrand($db,$URL,$cbrid)
	{
		$Query = $db->prepare("DELETE FROM cbrand WHERE cbrid=?");
		$values = array($cbrid);
		if($Query->execute($values))
		{
			header("Location: $URL/combrands.php?&err=4");
			die;
		}
	}
	/////////////////  Stores  ///////////////////////
	
	function add_store($db,$URL)
	{
		
		$Date         = time();
		$store_code    = stripslashes($_REQUEST['hdnStNo']);
		$store_name   = stripslashes($_REQUEST['txtStoreName']);
		$chain_store 		  = stripslashes($_REQUEST['cboStoreChain']);
		$city 	  = stripslashes($_REQUEST['cboCity']);
		$channel 	  = stripslashes($_REQUEST['cboChannel']);

		$lat 		  = stripslashes($_REQUEST['txtLat']);
		$long 	  = stripslashes($_REQUEST['txtLong']);

		$off_day 	  = stripslashes($_REQUEST['cboWeeklyOff']);
		$open_time 	  = stripslashes($_REQUEST['cboFromHrs']).":".stripslashes($_REQUEST['cboFromMins']);
		$close_time 	  = stripslashes($_REQUEST['cboToHrs']).":".stripslashes($_REQUEST['cboToMins']);

		$break_from 	  = stripslashes($_REQUEST['cboBrFromHrs']).":".stripslashes($_REQUEST['cboBrFromMins']);
		$break_to 	  = stripslashes($_REQUEST['cboBrToHrs']).":".stripslashes($_REQUEST['cboBrToMins']);

		$uniform 	  = stripslashes($_REQUEST['cboUniform']);
		$scarf 	  = stripslashes($_REQUEST['cboScarf']);
		$badge 	  = stripslashes($_REQUEST['cboBadge']);
		$data_sheet 	  = stripslashes($_REQUEST['cboDataSheet']);
		$device 	  = stripslashes($_REQUEST['cboDevice']);
		$store_card 	  = stripslashes($_REQUEST['cboStoreCard']);
		$document 	  = stripslashes($_REQUEST['cboDocument']);
		$long 	  = stripslashes($_REQUEST['txtLong']);


		//echo("$store_code,$store_name,$city,$chain_store,$channel,$lat,$long,$open_time,$close_time, $off_day, $break_from, $break_to, $uniform, $scarf, $badge, $data_sheet, $device, $store_card,$Date");die;

		$Query = $db->prepare("INSERT INTO store(store_code, store_name, city, chain_store, channel, stlat, stlong, open_time, close_time, off_day, break_from, break_to, uniform, scarf, badge, data_sheet, device, store_card, stdate) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
		$values = array($store_code,$store_name,$city,$chain_store,$channel,$lat,$long,$open_time,$close_time, $off_day, $break_from, $break_to, $uniform, $scarf, $badge, $data_sheet, $device, $store_card,$Date);
		if($Query->execute($values))
		{
			/*$Rid = $db->lastInsertId();
			$rawquery = $db->prepare("INSERT INTO rawlocation(lid, rid) VALUES(?,?)");
			$rawvalues = array(1,$Rid);
			$rawquery->execute($rawvalues);
			*/
			header("Location: $URL/stores.php?&err=2");
			die;
		}
	}

	function update_store($db,$URL)
	{
		
		$Date         = time();
		//$store_code   = stripslashes($_REQUEST['txtStoreCode']);
		$store_name   = stripslashes($_REQUEST['txtStoreName']);
		$chain_store 		  = stripslashes($_REQUEST['cboStoreChain']);
		$city 	  = stripslashes($_REQUEST['cboCity']);
		$channel 	  = stripslashes($_REQUEST['cboChannel']);

		$lat 		  = stripslashes($_REQUEST['txtLat']);
		$long 	  = stripslashes($_REQUEST['txtLong']);

		$off_day 	  = stripslashes($_REQUEST['cboWeeklyOff']);
		$open_time 	  = stripslashes($_REQUEST['cboFromHrs']).":".stripslashes($_REQUEST['cboFromMins']);
		$close_time 	  = stripslashes($_REQUEST['cboToHrs']).":".stripslashes($_REQUEST['cboToMins']);

		$break_from 	  = stripslashes($_REQUEST['cboBrFromHrs']).":".stripslashes($_REQUEST['cboBrFromMins']);
		$break_to 	  = stripslashes($_REQUEST['cboBrToHrs']).":".stripslashes($_REQUEST['cboBrToMins']);

		$uniform 	  = stripslashes($_REQUEST['cboUniform']);
		$scarf 	  = stripslashes($_REQUEST['cboScarf']);
		$badge 	  = stripslashes($_REQUEST['cboBadge']);
		$data_sheet 	  = stripslashes($_REQUEST['cboDataSheet']);
		$device 	  = stripslashes($_REQUEST['cboDevice']);
		$store_card 	  = stripslashes($_REQUEST['cboStoreCard']);
		$document 	  = stripslashes($_REQUEST['cboDocument']);
		$long 	  = stripslashes($_REQUEST['txtLong']);


		//echo("$store_code,$store_name,$city,$chain_store,$channel,$lat,$long,$open_time,$close_time, $off_day, $break_from, $break_to, $uniform, $scarf, $badge, $data_sheet, $device, $store_card,$Date");die;

		$Query = $db->prepare("UPDATE store SET store_name=?, city=?, chain_store=?, channel=?, stlat=?, stlong=?, open_time=?, close_time=?, off_day=?, break_from=?, break_to=?, uniform=?, scarf=?, badge=?, data_sheet=?, device=?, store_card=? WHERE stid=?");
		$values = array($store_name,$city,$chain_store,$channel,$lat,$long,$open_time,$close_time, $off_day, $break_from, $break_to, $uniform, $scarf, $badge, $data_sheet, $device, $store_card,$_REQUEST['stid']);
		if($Query->execute($values))
		{
			/*$Rid = $db->lastInsertId();
			$rawquery = $db->prepare("INSERT INTO rawlocation(lid, rid) VALUES(?,?)");
			$rawvalues = array(1,$Rid);
			$rawquery->execute($rawvalues);
			*/
			header("Location: $URL/stores.php?&err=3");
			die;
		}
	}

	function delete_store($db,$URL,$stid)
	{
		$Query = $db->prepare("DELETE FROM store WHERE stid=?");
		$values = array($stid);
		if($Query->execute($values))
		{
			header("Location: $URL/stores.php?&err=4");
			die;
		}
	}

	/////////////////  Add Brand Ambassador  /////////////////
	function add_ba($db,$URL)
	{
		include("thumb.php");
		
		
		$date 	  = time();
		$usertype = 4;
		
		$baquery = $db->prepare("SELECT uid, utype, ba_no FROM users WHERE utype = ? ORDER BY uid DESC LIMIT 0,1");
		$baquery->execute(array(4));
		if($baquery->rowCount() == 0)
		{
			$ba_no = "1000";
		}
		else
		{
			while($barow = $baquery->fetch())
			{
				$old_ba_no = $barow['ba_no'];
			}
			$ba_no = $old_ba_no + 1;
		}

		
		$cnic    = stripslashes($_REQUEST['txtCnic']);	
		$full_name = stripslashes($_REQUEST['txtFullName']);
		$market_name = stripslashes($_REQUEST['txtMarketName']);
		$father_name = stripslashes($_REQUEST['txtFatherName']);
		$dob = stripslashes($_REQUEST['txtDob']);
		$email    = stripslashes($_REQUEST['txtEmail']);	

		$username = strtolower(str_replace(" ", "", $full_name))."_ba".$ba_no;
		$password = md5("sentient_ba");
		
		$cell1    = stripslashes($_REQUEST['txtCell1']);
		$cell2    = stripslashes($_REQUEST['txtCell2']);
		$emergency_no    = stripslashes($_REQUEST['txtCell1']);	
		$address  = stripslashes($_REQUEST['txtAddress']);
		$area  = stripslashes($_REQUEST['cboArea']);
		$city  = stripslashes($_REQUEST['cboCity']);
		$marital_status  = stripslashes($_REQUEST['cboMaritalStatus']);
		$religion  = stripslashes($_REQUEST['cboReligion']);
		$education  = stripslashes($_REQUEST['cboEducation']);
		$experience  = stripslashes($_REQUEST['txtExperience']);
		$covid  = stripslashes($_REQUEST['cboCovid']);
		$skill  = stripslashes($_REQUEST['cboSkills']);
		$bank_name  = stripslashes($_REQUEST['txtBankName']);
		$account_no  = stripslashes($_REQUEST['txtAccountNo']);
		$leave_reason  = stripslashes($_REQUEST['txtLeaveReason']);
		//if($_REQUEST['txtDol'] <> '') { $dol  = $_REQUEST['txtDol']; } else{ $dol = 0;}
		
	    if($_REQUEST['txtDol'] != "") { $dol  = $_REQUEST['txtDol']; } else{ $dol = 0;}
		$blacklist_status  = stripslashes($_REQUEST['cboBlackList']);
		$blacklist_reason  = stripslashes($_REQUEST['txtBlacklistReason']);
		//$dol  = strtotime($_REQUEST['txtDol']);
		$status   = $_REQUEST['cboStatus'];

		$image       = $_FILES['image']['name'];
		if($image != "")
        {
            if ($image) 
            {
                $filename  = stripslashes($_FILES['image']['name']);
                $extension = getExtension($filename);
                $extension = strtolower($extension);
                if (($extension != "jpg") && ($extension != "jpeg") && ($extension != "png")) 
                {
                    $errors = 1;
                }
                else
                {
                    $size   = getimagesize($_FILES['image']['tmp_name']);
                    $sizekb = filesize($_FILES['image']['tmp_name']);
                    if ($sizekb > MAX_SIZE * 1024)
                    {
                        $errors = 1;
                    }
                    $A = rand(1000,1000000);
                    $image_name = $A.'.'.$extension;
                    $newname    = "../images/".$image_name;
                    $copied     = copy($_FILES['image']['tmp_name'], $newname);
                    if (!$copied) 
                    {
                        $errors = 1;
                    }
                    else
                    {
                        $thumb_name = "../images/ba/".$image_name;
                        $thumb      = make_thumb($newname,$thumb_name,WIDTH,HEIGHT);
                       	unlink("../images/".$image_name."");
                    }
                }
            }
            $user_image = $image_name;
        }
        else
        {
            $user_image = "";
        }
     	////////////////////////////////////////
	//	echo($dol."/".$_REQUEST['txtDol']);die;
		$Query = $db->prepare("INSERT INTO users(utype, ba_no, username, password, market_name, father_name, fullname, email, mobileno1, mobileno2, emergencyno, education, skills,
					 marketing_exp, covid_cert, marital_status, user_image, cnic_no, address, area, city, dob, religion, bank_iban, bank_name, blacklist_status, blacklist_reason, 
					 leave_reason, dol, ustatus, udate) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
		$values = array($usertype, $ba_no, $username, $password, $market_name, $father_name, $full_name, $email, $cell1, $cell2, $emergency_no, $education, $skill
					 , $experience , $covid, $marital_status, $user_image, $cnic, $address, $area, $city, $dob, $religion, $account_no, $bank_name , $blacklist_status , $blacklist_reason, 
					 $leave_reason, $dol, $status, $date);
		if($Query->execute($values))
		{
		   // echo("MOHSIN");die;
			///////////////////// LOG SECTION /////////////////////
		    //$log = "$FullName - User has been created";
			//log_entry($log);
		    ///////////////////////////////////////////////////////
			header("Location: $URL/ba.php?&err=2");
			die;
		}
		else
		{
			echo "\nPDO::errorInfo():\n";
			print_r($Query->errorInfo());die;
		}
	}

	/////////////////  Update Brand Ambassador  /////////////////
	function update_ba($db,$URL,$id)
	{
		include("thumb.php");
		
		$date 	  = time();
		$cnic    = stripslashes($_REQUEST['txtCnic']);	
		$full_name = stripslashes($_REQUEST['txtFullName']);
		$market_name = stripslashes($_REQUEST['txtMarketName']);
		$father_name = stripslashes($_REQUEST['txtFatherName']);
		$dob = stripslashes($_REQUEST['txtDob']);
		$email    = stripslashes($_REQUEST['txtEmail']);	
		
		$cell1    = stripslashes($_REQUEST['txtCell1']);
		$cell2    = stripslashes($_REQUEST['txtCell2']);
		$emergency_no    = stripslashes($_REQUEST['txtEmergencyNo']);	
		$address  = stripslashes($_REQUEST['txtAddress']);
		$area  = stripslashes($_REQUEST['cboArea']);
		$city  = stripslashes($_REQUEST['cboCity']);
		$marital_status  = stripslashes($_REQUEST['cboMaritalStatus']);
		$religion  = stripslashes($_REQUEST['cboReligion']);
		$education  = stripslashes($_REQUEST['cboEducation']);
		$experience  = stripslashes($_REQUEST['txtExperience']);
		$covid  = stripslashes($_REQUEST['cboCovid']);
		$skill  = stripslashes($_REQUEST['cboSkills']);
		$bank_name  = stripslashes($_REQUEST['txtBankName']);
		$account_no  = stripslashes($_REQUEST['txtAccountNo']);
		$leave_reason  = stripslashes($_REQUEST['txtLeaveReason']);
		if($_REQUEST['txtDol'] != "") { $dol  = $_REQUEST['txtDol']; } else{ $dol = 0;}
		$blacklist_status  = stripslashes($_REQUEST['cboBlackList']);
		$blacklist_reason  = stripslashes($_REQUEST['txtBlacklistReason']);
		$hdn_image  = stripslashes($_REQUEST['hdnImage']);
		

		
		$status   = $_REQUEST['cboStatus'];


		$image       = $_FILES['image']['name'];
		if($image != "")
        {
            if ($image) 
            {
                $filename  = stripslashes($_FILES['image']['name']);
                $extension = getExtension($filename);
                $extension = strtolower($extension);
                if (($extension != "jpg") && ($extension != "jpeg") && ($extension != "png")) 
                {
                    $errors = 1;
                }
                else
                {
                    $size   = getimagesize($_FILES['image']['tmp_name']);
                    $sizekb = filesize($_FILES['image']['tmp_name']);
                    if ($sizekb > MAX_SIZE * 1024)
                    {
                        $errors = 1;
                    }
                    $A = rand(1000,1000000);
                    $image_name = $A.'.'.$extension;
                    $newname    = "../images/".$image_name;
                    $copied     = copy($_FILES['image']['tmp_name'], $newname);
                    if (!$copied) 
                    {
                        $errors = 1;
                    }
                    else
                    {
                        $thumb_name = "../images/ba/".$image_name;
                        $thumb      = make_thumb($newname,$thumb_name,WIDTH,HEIGHT);
                       	unlink("../images/".$image_name."");
                       	unlink("../images/ba/".$hdn_image."");
                    }
                }
            }
            $user_image = $image_name;
        }
        else
        {
            $user_image = $hdn_image;
        }

		////////////////////////////////////////

		$Query = $db->prepare("UPDATE users SET market_name=?, father_name=?, fullname=?, email=?, mobileno1=?, mobileno2=?, emergencyno=?, education=?, skills=?,
					 marketing_exp=?, covid_cert=?, marital_status=?, user_image=?, cnic_no=?, address=?, area=?, city=?, dob=?, religion=?, bank_iban=?, bank_name=?, blacklist_status=?, blacklist_reason=?, 
					 leave_reason=?, dol=?, ustatus=? WHERE uid = ?");
		$values = array($market_name, $father_name, $full_name, $email, $cell1, $cell2, $emergency_no, $education, $skill
					 , $experience , $covid, $marital_status, $user_image, $cnic, $address, $area, $city, $dob, $religion, $account_no, $bank_name , $blacklist_status , $blacklist_reason, 
					 $leave_reason, $dol, $status, $id);
		if($Query->execute($values))
		{
			///////////////////// LOG SECTION /////////////////////
		    //$log = "$FullName - User has been created";
			//log_entry($log);
		    ///////////////////////////////////////////////////////
			header("Location: $URL/ba.php?&err=3");
			die;
		}
	}
	function delete_ba($db,$URL,$uid)
	{
		$Query = $db->prepare("DELETE FROM users WHERE uid=?");
		$values = array($uid);
		if($Query->execute($values))
		{
			header("Location: $URL/ba.php?&err=4");
			die;
		}
	}
	
	function reset_ba_password($db,$URL,$uid)
	{
		$new_password = md5($_REQUEST['txtNewPassword']);

		$query = $db->prepare("UPDATE users SET password=? WHERE uid=?");
		$values = array($new_password,$uid);
		if($query->execute($values))
		{
		  	header("Location: ba_reset_password.php?err=3");
			die;
		}
	}
	/////////////////  Add Supervisor  /////////////////
	function add_supervisor($db,$URL)
	{
		
		$date 	  = time();
		$usertype = 3;
		$lid    = stripslashes($_REQUEST['cboLocation']);	
		$su_no    = stripslashes($_REQUEST['hdnSuNo']);	
		$cnic    = stripslashes($_REQUEST['txtCnic']);	
		$full_name = stripslashes($_REQUEST['txtFullName']);
		
		$username = strtolower(str_replace(" ", "", $full_name))."_su".$su_no;
		$password = md5("sentient_su");
		
		$cell1    = stripslashes($_REQUEST['txtCell1']);
		$cell2    = stripslashes($_REQUEST['txtCell2']);
		$cell3    = stripslashes($_REQUEST['txtCell3']);
		$emergency_no    = stripslashes($_REQUEST['txtEmergencyNo']);	
		$address  = stripslashes($_REQUEST['txtAddress']);
		$area  = stripslashes($_REQUEST['cboArea']);
		$city  = stripslashes($_REQUEST['cboCity']);


		if($_REQUEST['chkAttendance']) { $su_attendance = 1; } else{ $su_attendance = 0; }

		$status   = $_REQUEST['cboStatus'];

		$file_name   = "image";
		$File 	     = $_FILES[$file_name]['name'];		
		$TmpFile     = $_FILES[$file_name]['tmp_name'];

		$ext 	 	 = pathinfo($File, PATHINFO_EXTENSION);
		$rand 		 = rand();
		$newfilename = $rand.".".$ext;
		$target_path = "../ba_app/assets/uploads/su/";
		$target_path = $target_path . basename($newfilename);
		

		if($ext == "png" || $ext == "jpg")
		{
		    if(move_uploaded_file($TmpFile, $target_path))
			{
				$user_image = $newfilename;
			}
			else
			{
				$user_image = "";
			}
		}
		else
		{
			$user_image = "";
		}

		////////////////////////////////////////

		$Query = $db->prepare("INSERT INTO users(lid, utype, su_no, su_attendance, username, password, fullname, mobileno1, mobileno2, mobileno3, emergencyno, user_image, cnic_no, address, area, city, ustatus, udate) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
		$values = array($lid, $usertype, $su_no, $su_attendance, $username, $password, $full_name, $cell1, $cell2, $cell3, $emergency_no, $user_image, $cnic, $address, $area, $city, $status, $date);
		if($Query->execute($values))
		{
			///////////////////// LOG SECTION /////////////////////
		    //$log = "$FullName - User has been created";
			//log_entry($log);
		    ///////////////////////////////////////////////////////
			header("Location: $URL/supervisors.php?&err=2");
			die;
		}
	}

	/////////////////  Update Supervisor  /////////////////
	function update_supervisor($db,$URL,$id)
	{
		$date 	  = time();
		$lid    = stripslashes($_REQUEST['cboLocation']);	
		$cnic    = stripslashes($_REQUEST['txtCnic']);	
		$full_name = stripslashes($_REQUEST['txtFullName']);
		
		$cell1    = stripslashes($_REQUEST['txtCell1']);
		$cell2    = stripslashes($_REQUEST['txtCell2']);
		$emergency_no    = stripslashes($_REQUEST['txtEmergencyNo']);	
		$address  = stripslashes($_REQUEST['txtAddress']);
		$area  = stripslashes($_REQUEST['cboArea']);
		$city  = stripslashes($_REQUEST['cboCity']);
		$hdn_image  = stripslashes($_REQUEST['hdnImage']);
		if($_REQUEST['chkAttendance']) { $su_attendance = 1; } else{ $su_attendance = 0; }
		$status   = $_REQUEST['cboStatus'];
		$hdn_image   = $_REQUEST['hdnImage'];

		$file_name   = "image";
		$File 	     = $_FILES[$file_name]['name'];		
		$TmpFile     = $_FILES[$file_name]['tmp_name'];

		$ext 	 	 = pathinfo($File, PATHINFO_EXTENSION);
		$rand 		 = rand();
		$newfilename = $rand.".".$ext;
		$target_path = "../ba_app/assets/uploads/su/";
		$target_path = $target_path . basename($newfilename);
		
		
		if($ext == "png" || $ext == "jpg")
		{
		    if(move_uploaded_file($TmpFile, $target_path))
			{
				$user_image = $newfilename;
				unlink("../ba_app/assets/uploads/su/".$hdn_image);
			}
			else
			{
				$user_image = "";
			}
		}
		else
		{
			$user_image = "";
		}

		////////////////////////////////////////

		$Query = $db->prepare("UPDATE users SET lid=?, su_attendance=?, fullname=?, mobileno1=?, mobileno2=?, emergencyno=?, user_image=?, cnic_no=?, address=?, area=?, city=?, ustatus=? WHERE uid = ?");
		$values = array($lid, $su_attendance, $full_name, $cell1, $cell2, $emergency_no, $user_image, $cnic, $address, $area, $city, $status, $id);
		if($Query->execute($values))
		{
			///////////////////// LOG SECTION /////////////////////
		    //$log = "$FullName - User has been created";
			//log_entry($log);
		    ///////////////////////////////////////////////////////
			header("Location: $URL/supervisors.php?&err=3");
			die;
		}
	}
	function delete_supervisor($db,$URL,$id)
	{
		$Query = $db->prepare("DELETE FROM users WHERE uid=?");
		$values = array($id);
		if($Query->execute($values))
		{
			header("Location: $URL/supervisors.php?&err=4");
			die;
		}
	}
	/////////////////  Assignments  ///////////////////////
	function add_assignment($db,$URL)
	{
		$date         = time();
		
		$stid 		  = stripslashes($_REQUEST['cboStore']);
		$uid 		  = stripslashes($_REQUEST['cboBa']);
		$brid 		  = stripslashes($_REQUEST['cboBrand']);
		$shift 		  = stripslashes($_REQUEST['cboShift']);
		
		
		$off_day 	  = stripslashes($_REQUEST['cboWeeklyOff']);
		
		$open_time 	  = stripslashes($_REQUEST['cboFromHrs']).":".stripslashes($_REQUEST['cboFromMins']);
		$close_time 	  = stripslashes($_REQUEST['cboToHrs']).":".stripslashes($_REQUEST['cboToMins']);

		$break_from 	  = stripslashes($_REQUEST['cboBrFromHrs']).":".stripslashes($_REQUEST['cboBrFromMins']);
		$break_to 	  = stripslashes($_REQUEST['cboBrToHrs']).":".stripslashes($_REQUEST['cboBrToMins']);
		
		$supuid 	  = stripslashes($_REQUEST['cboSupervisor']);

		if($_REQUEST['txtStoreTarget'] != "") { $store_target 	  = stripslashes($_REQUEST['txtStoreTarget']); } else{ $store_target = 0; }
		if($_REQUEST['txtSampleTarget'] != "") { $sample_target = stripslashes($_REQUEST['txtSampleTarget']); } else{ $sample_target = 0; }
		if($_REQUEST['txtDealTarget'] != "") { $deal_target = stripslashes($_REQUEST['txtDealTarget']); } else{ $deal_target = 0; }
		
		if(isset($_REQUEST['chkSample'])) { $sample_status = 1; } else{ $sample_status = 0; }
		if(isset($_REQUEST['chkDeal'])) { $deal_status = 1; } else{ $deal_status = 0; }


		$status       = $_REQUEST['cboStatus'];
		
		$Query = $db->prepare("INSERT INTO assignments(stid, brid, uid, asshift, asoffday, asbreaktime_from, asbreaktime_to, asstarttime, asofftime, storetarget, supuid, 
					sampletarget, dealtarget, sample_status, deal_status, asstatus , asdate) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
		$values = array($stid, $brid, $uid, $shift, $off_day, $break_from, $break_to, $open_time, $close_time, $store_target, $supuid, $sample_target, $deal_target, $sample_status, $deal_status, $status,$date);
		if($Query->execute($values))
		{
			$asid = $db->lastInsertId();
			if(isset($_REQUEST['hdnPid']))
			{
				for ($i = 0; $i < count($_REQUEST['hdnPid']); $i++)
				{
					if (isset ($_REQUEST['hdnPid'][$i]))
					{
						if (isset($_REQUEST['chkStatus'][$i])) { $asdstatus = 0; } else{ $asdstatus = 1; }
						$asdquery = $db->prepare("INSERT INTO assignment_detail (asid,brid,pid,asdtarget,asdstatus,asddate) VALUES(?,?,?,?,?,?)");
						$asdvalues = array($asid,$brid,$_REQUEST['hdnPid'][$i],$_REQUEST['txtQty'][$i],$asdstatus,$date);
						if(!$asdquery->execute($asdvalues))
						{
							echo "\nPDO::errorInfo():\n";
							print_r($asdquery->errorInfo());die;
						}
					}
				}
			}	
			header("Location: $URL/assignments.php?err=2");
			die;
		}
		else
		{
			echo "\nPDO::errorInfo():\n";
			print_r($Query->errorInfo());die;
		}
	}	

	function update_assignment($db,$URL,$asid)
	{
		$date         = time();	
		if(isset($_REQUEST['cboBa'])) { $uid = stripslashes($_REQUEST['cboBa']); } else{ $uid = stripslashes($_REQUEST['hdnBa']); }
		$shift 		  = stripslashes($_REQUEST['cboShift']);
		
		
		$off_day 	  = stripslashes($_REQUEST['cboWeeklyOff']);
		
		$open_time 	  = stripslashes($_REQUEST['cboFromHrs']).":".stripslashes($_REQUEST['cboFromMins']);
		$close_time 	  = stripslashes($_REQUEST['cboToHrs']).":".stripslashes($_REQUEST['cboToMins']);

		$break_from  = stripslashes($_REQUEST['cboBrFromHrs']).":".stripslashes($_REQUEST['cboBrFromMins']);
		$break_to 	  = stripslashes($_REQUEST['cboBrToHrs']).":".stripslashes($_REQUEST['cboBrToMins']);
		
		$supuid 	  = stripslashes($_REQUEST['cboSupervisor']);

		if($_REQUEST['txtStoreTarget'] != "") { $store_target 	  = stripslashes($_REQUEST['txtStoreTarget']); } else{ $store_target = 0; }
		if($_REQUEST['txtSampleTarget'] != "") { $sample_target = stripslashes($_REQUEST['txtSampleTarget']); } else{ $sample_target = 0; }
		if($_REQUEST['txtDealTarget'] != "") { $deal_target = stripslashes($_REQUEST['txtDealTarget']); } else{ $deal_target = 0; }
		

		if(isset($_REQUEST['chkSample'])) { $sample_status = 1; } else{ $sample_status = 0; }
		if(isset($_REQUEST['chkDeal'])) { $deal_status = 1; } else{ $deal_status = 0; }

		$status       = $_REQUEST['cboStatus'];
		
		$Query = $db->prepare("UPDATE assignments SET uid=?, asshift=?, asoffday=?, asbreaktime_from=?, asbreaktime_to=?, asstarttime=?, asofftime=?, storetarget=?, supuid=?,
					sampletarget=?, dealtarget=?, sample_status=?, deal_status=?, asstatus=? WHERE asid=?");
		$values = array($uid, $shift, $off_day, $break_from, $break_to, $open_time, $close_time, $store_target, $supuid, $sample_target, $deal_target, $sample_status, $deal_status, $status,$asid);
		if($Query->execute($values))
		{
			//echo($_REQUEST['hdnSku']);die;
			for ($i = 1; $i <= $_REQUEST['hdnSku']; $i++)
			{
				if(isset($_REQUEST['chkStatus'.$i])){ $asdstatus = 0; } else{ $asdstatus = 1; }
				//echo($_REQUEST['txtQty'.$i]." / ".$asdstatus);die;
				
				$asdquery = $db->prepare("UPDATE assignment_detail SET asdtarget=?, asdstatus=? WHERE asdid=?");
				$asdvalues = array($_REQUEST['txtQty'.$i],$asdstatus,$_REQUEST['hdnAsdid'.$i]);
				if(!$asdquery->execute($asdvalues))
				{
					echo "\nPDO::errorInfo():\n";
					print_r($asdquery->errorInfo());die;
				}
		}
			header("Location: $URL/assignments.php?err=3");
			die;
		}
		else
		{
			echo "\nPDO::errorInfo():\n";
			print_r($Query->errorInfo());die;
		}
	}
	
	function update_vacant_assignment($db,$URL,$asid)
	{
		$date         = time();	
		$uid 		  = stripslashes($_REQUEST['cboBa']);
		$shift 		  = stripslashes($_REQUEST['cboShift']);
		
		$off_day 	  = stripslashes($_REQUEST['cboWeeklyOff']);
		
		$open_time 	  = stripslashes($_REQUEST['cboFromHrs']).":".stripslashes($_REQUEST['cboFromMins']);
		$close_time 	  = stripslashes($_REQUEST['cboToHrs']).":".stripslashes($_REQUEST['cboToMins']);

		$break_from  = stripslashes($_REQUEST['cboBrFromHrs']).":".stripslashes($_REQUEST['cboBrFromMins']);
		$break_to 	  = stripslashes($_REQUEST['cboBrToHrs']).":".stripslashes($_REQUEST['cboBrToMins']);
		
		$supuid 	  = stripslashes($_REQUEST['cboSupervisor']);

		if($_REQUEST['txtStoreTarget'] != "") { $store_target 	  = stripslashes($_REQUEST['txtStoreTarget']); } else{ $store_target = 0; }
		if($_REQUEST['txtSampleTarget'] != "") { $sample_target = stripslashes($_REQUEST['txtSampleTarget']); } else{ $sample_target = 0; }
		if($_REQUEST['txtDealTarget'] != "") { $deal_target = stripslashes($_REQUEST['txtDealTarget']); } else{ $deal_target = 0; }

		if(isset($_REQUEST['chkSample'])) { $sample_status = 1; } else{ $sample_status = 0; }
		if(isset($_REQUEST['chkDeal'])) { $deal_status = 1; } else{ $deal_status = 0; }

		$status       = $_REQUEST['cboStatus'];
		$vacant_remarks = $_REQUEST['cboVacantRemarks'];
		
		$Query = $db->prepare("UPDATE assignments SET uid=?, asshift=?, asoffday=?, asbreaktime_from=?, asbreaktime_to=?, asstarttime=?, asofftime=?, storetarget=?, supuid=?,
					sampletarget=?, dealtarget=?, sample_status=?, deal_status=?, vacant_remarks=?, asstatus=? WHERE asid=?");
		$values = array($uid, $shift, $off_day, $break_from, $break_to, $open_time, $close_time, $store_target, $supuid, $sample_target, $deal_target, $sample_status, $deal_status, $vacant_remarks, $status,$asid);
		if($Query->execute($values))
		{
			header("Location: $URL/vacant_stores.php?err=3");
			die;
		}
		else
		{
			echo "\nPDO::errorInfo():\n";
			print_r($Query->errorInfo());die;
		}
	}

	function delete_assignment($db,$URL,$asid)
	{
		$Query1 = $db->prepare("DELETE FROM assignments WHERE asid=?");
		$Query2 = $db->prepare("DELETE FROM assignment_detail WHERE asid=?");
		
		if($Query1->execute(array($asid)) && $Query2->execute(array($asid)))
		{
			header("Location: assignments.php?err=4");
		}
	}

	function unassign_ba($db,$URL,$asid)
	{
		$date         = time();	
		$uid 		  = 0;
		
		$Query = $db->prepare("UPDATE assignments SET uid=?, unassign_date=? WHERE asid=?");
		$values = array($uid, $date, $asid);
		if($Query->execute($values))
		{
			header("Location: $URL/assignments.php?err=3");
			die;
		}
		else
		{
			echo "\nPDO::errorInfo():\n";
			print_r($Query->errorInfo());die;
		}
	}
	
	/////////////////  Surveys  ///////////////////////
	
	function add_survey($db,$URL)
	{
		$date = time();
		$brid = stripslashes($_REQUEST['cboBrand']);
		$title = stripslashes($_REQUEST['txtTitle']);
		$description = stripslashes($_REQUEST['txtDescription']);
		$status = stripslashes($_REQUEST['cboStatus']);

		$Query = $db->prepare("INSERT INTO survey(brid, surtitle, surdescription , surstatus , surdate) VALUES(?, ?, ?, ?, ?)");
		$values = array($brid,$title,$description,$status,$date);
		if($Query->execute($values))
		{
			$surid = $db->lastInsertId();
			///////////////////// LOG SECTION /////////////////////
		  //  $log = "$Name - Location has been created";
		//	log_entry($log);
		    ///////////////////////////////////////////////////////
			header("Location: $URL/editsurvey.php?surid=$surid&err=2");
			die;
		}
	}

	function update_survey($db,$URL,$surid)
	{
		$date = time();
		$title = stripslashes($_REQUEST['txtTitle']);
		$description = stripslashes($_REQUEST['txtDescription']);
		$status = stripslashes($_REQUEST['cboStatus']);

		$Query = $db->prepare("UPDATE survey SET surtitle=?, surdescription=?, surstatus=? WHERE surid=?");
		$values = array($title,$description,$status,$surid);
		if($Query->execute($values))
		{
			///////////////////// LOG SECTION /////////////////////
		  //  $log = "$Name - Location has been created";
		//	log_entry($log);
		    ///////////////////////////////////////////////////////
			header("Location: $URL/surveys.php?err=3");
			die;
		}
	}



	///////////////////////////////////////////////////

	/////////////////  Locations  ///////////////////////
	function add_location($db,$URL)
	{
		$Name = stripslashes($_REQUEST['txtName']);
		$Address = stripslashes($_REQUEST['txtAddress']);
		$City = stripslashes($_REQUEST['txtCity']);
		$Capacity = stripslashes($_REQUEST['txtCapacity']);
		$Status = stripslashes($_REQUEST['cboStatus']);

		//echo("$Name,$Address,$City,$Capacity,$Status");die;

		$Query = $db->prepare("INSERT INTO locations(lname, laddress, lcity , lcapacity , lstatus) VALUES(?, ?, ?, ?, ?)");
		$values = array($Name,$Address,$City,$Capacity,$Status);
		if($Query->execute($values))
		{
			///////////////////// LOG SECTION /////////////////////
		    $log = "$Name - Location has been created";
			log_entry($log);
		    ///////////////////////////////////////////////////////
			header("Location: $URL/locations.php?&err=2");
			die;
		}
	}
	function update_location($db,$URL,$Lid)
	{		
		$Name 	  = stripslashes($_REQUEST['txtName']);
		$Address  = stripslashes($_REQUEST['txtAddress']);
		$City 	  = stripslashes($_REQUEST['txtCity']);
		$Capacity = stripslashes($_REQUEST['txtCapacity']);
		$Status   = stripslashes($_REQUEST['cboStatus']);

		$Query = $db->prepare("UPDATE locations SET lname=? , laddress=? , lcity=? , lcapacity=? , lstatus=? WHERE lid=?");
		$values = array($Name,$Address,$City,$Capacity,$Status,$Lid);
		if($Query->execute($values))
		{
			///////////////////// LOG SECTION /////////////////////
		    $log = "$Name - Location has been updated";
			log_entry($log);
		    ///////////////////////////////////////////////////////
			header("Location: $URL/locations.php?&err=3");
			die;
		}
	}
	function delete_location($db,$URL,$Lid)
	{
		$Query = $db->prepare("DELETE FROM locations WHERE lid=?");
		$values = array($Lid);
		if($Query->execute($values))
		{
			///////////////////// LOG SECTION /////////////////////
		    $log = "$Name - Location has been deleted";
			log_entry($log);
		    ///////////////////////////////////////////////////////
			header("Location: $URL/locations.php?&err=4");
			die;
		}
	}
	
	/////////////////  Unit Type  ///////////////////////
	function add_unit($db,$URL)
	{
		$unittype = stripslashes($_REQUEST['txtUnitType']);

		$Query = $db->prepare("INSERT INTO unittype(unittype) VALUES(?)");
		$values = array($unittype);
		if($Query->execute($values))
		{
			///////////////////// LOG SECTION /////////////////////
		    $log = "$unittype - Unit Type has been created";
			log_entry($log);
		    ///////////////////////////////////////////////////////
			header("Location: $URL/units.php?&err=2");
			die;
		}
	}
	function update_unit($db,$URL,$utid)
	{
		$unittype = stripslashes($_REQUEST['txtUnitType']);
		$Query = $db->prepare("UPDATE unittype SET unittype=? WHERE utid=?");
		$values = array($unittype,$utid);
		if($Query->execute($values))
		{
			///////////////////// LOG SECTION /////////////////////
		    $log = "$unittype - Unit Type has been updated";
			log_entry($log);
		    ///////////////////////////////////////////////////////
			header("Location: $URL/units.php?&err=3");
			die;
		}
	}
	function delete_unit($db,$URL,$utid)
	{
		$Query = $db->prepare("DELETE FROM unittype WHERE utid=?");
		$values = array($utid);
		if($Query->execute($values))
		{
			///////////////////// LOG SECTION /////////////////////
		    $log = "Unit Type has been deleted";
			log_entry($log);
		    ///////////////////////////////////////////////////////
			header("Location: $URL/units.php?&err=4");
			die;
		}
	}
	
	//////////////  Update BA Sale Data

	function save_ba_qty($db,$URL,$date,$uid)
	{

		$hdn_qty = $_REQUEST['hdnQty'];
		$num = 0;
		//echo($hdn_qty);die;

		for ($i = 1; $i <= $hdn_qty; $i++)
		{
			$assid		 = "hdnid$i";
			$qty		 = "txtQty$i";

			$Query = $db->prepare("UPDATE assignment_sale SET stock_qty = ? WHERE assid = ?");
			$Values = array($_REQUEST[$qty] , $_REQUEST[$assid]);

			if(!$Query->execute($Values))
			{
				echo "\nPDO::errorInfo():\n";
				print_r($Query->errorInfo());die;
			}
		}
		header("Location: print_ba_sale_data.php?date=$date&id=$uid&type=1&err=1");
	}

	function save_ba_price($db,$URL,$date,$uid)
	{
		$hdn_qty = $_REQUEST['hdnQty'];
		$num = 0;
		//echo($hdn_qty);die;

		for ($i = 1; $i <= $hdn_qty; $i++)
		{
			$assid		 = "hdnid$i";
			$price		 = "txtPrice$i";

			$Query = $db->prepare("UPDATE assignment_sale SET sale_price = ? WHERE assid = ?");
			$Values = array($_REQUEST[$price] , $_REQUEST[$assid]);

			if(!$Query->execute($Values))
			{
				echo "\nPDO::errorInfo():\n";
				print_r($Query->errorInfo());die;
			}
		}
		header("Location: print_ba_sale_data.php?date=$date&id=$uid&type=2&err=1");
	}

	function save_ba_sale($db,$URL,$date,$uid)
	{
		$hdn_qty = $_REQUEST['hdnQty'];
		$num = 0;
		//echo($hdn_qty);die;

		for ($i = 1; $i <= $hdn_qty; $i++)
		{
			$assid		 = "hdnid$i";
			$sale_qty	 = "txtSaleQty$i";

			$Query = $db->prepare("UPDATE assignment_sale SET sale_qty = ? WHERE assid = ?");
			$Values = array($_REQUEST[$sale_qty] , $_REQUEST[$assid]);

			if(!$Query->execute($Values))
			{
				echo "\nPDO::errorInfo():\n";
				print_r($Query->errorInfo());die;
			}
		}
		header("Location: print_ba_sale_data.php?date=$date&id=$uid&type=3&err=1");
	}

	//////////////////////////////////////////////////

	/////////////////  Colors  ///////////////////////
	function add_color($db,$URL)
	{
		$color = stripslashes($_REQUEST['txtColor']);

		$Query = $db->prepare("INSERT INTO colors(color) VALUES(?)");
		$values = array($color);
		if($Query->execute($values))
		{
			///////////////////// LOG SECTION /////////////////////
		    $log = "$color - Color has been created";
			log_entry($log);
		    ///////////////////////////////////////////////////////
			header("Location: $URL/colors.php?&err=2");
			die;
		}
	}
	function update_color($db,$URL,$colorid)
	{
		$color = stripslashes($_REQUEST['txtColor']);
		$Query = $db->prepare("UPDATE colors SET color=? WHERE colorid=?");
		$values = array($color,$colorid);
		if($Query->execute($values))
		{
			///////////////////// LOG SECTION /////////////////////
		    $log = "$color - Color has been updated";
			log_entry($log);
		    ///////////////////////////////////////////////////////
			header("Location: $URL/colors.php?&err=3");
			die;
		}
	}
	function delete_color($db,$URL,$colorid)
	{
		$Query = $db->prepare("DELETE FROM colors WHERE colorid=?");
		$values = array($colorid);
		if($Query->execute($values))
		{
			///////////////////// LOG SECTION /////////////////////
		    $log = "Color has been deleted";
			log_entry($log);
		    ///////////////////////////////////////////////////////
			header("Location: $URL/colors.php?&err=4");
			die;
		}
	}



	
	///////////////////////////////////////////////////////
	/////////////////  Sub Category  //////////////////////
	
	function add_subcategory($db,$URL)
	{
		$Date = time();
		$id = stripslashes($_REQUEST['cboMainCategory']);
		$cid = stripslashes($_REQUEST['cboCategory']);
		$SubCategory = stripslashes($_REQUEST['txtSubCategory']);

		$PageTitle 	  = stripslashes($_REQUEST['txtPageTitle']);
		$PageName 	  = str_replace(array(' ', '.', ',', '&', '_', '/'), '-' , strtolower($_REQUEST['txtSubCategory']));
		$MetaTags 	  = stripslashes($_REQUEST['txtMetaTags']);
		$MetaKeywords = stripslashes($_REQUEST['txtMetaKeywords']);
		$Status 	  = stripslashes($_REQUEST['cboStatus']);

		$Query = $db->prepare("INSERT INTO subcategory(id,cid,subcategory,subpagetitle,subpagename,subtags,subkeywords,subdate,substatus) VALUES(?,?,?,?,?,?,?,?,?)");
		$values = array($id,$cid,$SubCategory,$PageTitle,$PageName,$MetaTags,$MetaKeywords,$Date,$Status);
		if($Query->execute($values))
		{
			header("Location: $URL/subcategory.php?err=2");
			die;
		}	
	}	
	function update_subcategory($db,$URL,$subid)
	{
		$Date = time();
		$subid = stripslashes($_REQUEST['subid']);
		$SubCategory = stripslashes($_REQUEST['txtSubCategory']);

		$PageTitle 	  = stripslashes($_REQUEST['txtPageTitle']);
		$PageName 	  = str_replace(array(' ', '.', ',', '&', '_', '/'), '-' , strtolower($_REQUEST['txtSubCategory']));
		$MetaTags 	  = stripslashes($_REQUEST['txtMetaTags']);
		$MetaKeywords = stripslashes($_REQUEST['txtMetaKeywords']);
		$Status 	  = stripslashes($_REQUEST['cboStatus']);

		$Query = $db->prepare("UPDATE subcategory SET subcategory=?,subpagetitle=?,subpagename=?,subtags=?,subkeywords=?,substatus=? WHERE subid=?");
		$values = array($SubCategory,$PageTitle,$PageName,$MetaTags,$MetaKeywords,$Status,$subid);
		if($Query->execute($values))
		{
			header("Location: $URL/subcategory.php?err=3");
			die;
		}	
	}	
	function delete_subcategory($db,$URL,$Subid)
	{
		$Query = $db->prepare("DELETE FROM subcategory WHERE subid=?");
		$values = array($Subid);
		if($Query->execute($values))
		{
			header("Location: $URL/subcategory.php?err=4");
			die;
		}
	}
	////////////////////////////////////////////////////
	/////////////////  Products  ///////////////////////
	function add_product($db,$URL)
	{		
		$date         = time();
		$brid 		  = stripslashes($_REQUEST['cboBrand']);
		
		$name 		  = stripslashes($_REQUEST['txtName']);
		$sku 	  = stripslashes($_REQUEST['txtSku']);
		$size 		  = stripslashes($_REQUEST['txtSize']);
		$price 		  = stripslashes($_REQUEST['txtPrice']);
		$unit_type 		  = stripslashes($_REQUEST['cboUnitType']);
		$weight  = stripslashes($_REQUEST['txtWeight']);

		$status       = $_REQUEST['cboStatus'];
		
		$Query = $db->prepare("INSERT INTO products(brid , pname , sku , psize, pprice, unit_type, pweight, pstatus , pdate) VALUES(?,?,?,?,?,?,?,?,?)");
		$values = array($brid,$name,$sku,$size,$price,$unit_type,$weight,$status,$date);
		if($Query->execute($values))
		{
		    /// add new sku to existing assignmets
			$pid = $db->lastInsertId();

			$asquery = $db->prepare("SELECT * FROM assignments WHERE brid = ? ORDER BY asid ASC");
			$asquery->execute(array($brid));
			while($asrow = $asquery->fetch())
			{
				$asid = $asrow['asid'];
				/// add sku
				$asdquery = $db->prepare("INSERT INTO assignment_detail(asid, brid, pid, asddate) VALUES(?,?,?,?)");
				$asdvalues = array($asid, $brid, $pid, time());
				$asdquery->execute($asdvalues);
			}
			header("Location: $URL/products.php?&err=3");
			die;
		}
		else
		{
			echo "\nPDO::errorInfo():\n";
			print_r($Query->errorInfo());die;
		}
	}	

	function update_product($db,$URL,$PID)
	{
		$date         = time();
		$brid 		  = stripslashes($_REQUEST['cboBrand']);
		
		$name 		  = stripslashes($_REQUEST['txtName']);
		$sku 	  = stripslashes($_REQUEST['txtSku']);
		$size 		  = stripslashes($_REQUEST['txtSize']);
		$price 		  = stripslashes($_REQUEST['txtPrice']);
		$unit_type 		  = stripslashes($_REQUEST['cboUnitType']);
		$weight  = stripslashes($_REQUEST['txtWeight']);

		$status       = $_REQUEST['cboStatus'];
		
		$Query = $db->prepare("UPDATE products SET pname=?, sku=?, psize=?, pprice=?, unit_type=?, pweight=?, pstatus=? WHERE pid=?");
		$values = array($name,$sku,$size,$price,$unit_type,$weight,$status,$PID);
		if($Query->execute($values))
		{
			header("Location: $URL/products.php?&err=3");
			die;
		}
		else
		{
			echo "\nPDO::errorInfo():\n";
			print_r($Query->errorInfo());die;
		}
	}

	function upload_image($db,$URL,$Pid)
	{
		include("thumb.php");
		
		$Date = time();
		$GalleryImage = "image";
		$image = $_FILES[$GalleryImage]['name'];
		if($image != "")
		{
			if ($image) 
			{
				$filename  = stripslashes($_FILES[$GalleryImage]['name']);
				$extension = getExtension($filename);
				$extension = strtolower($extension);
				if (($extension != "jpg") && ($extension != "jpeg") && ($extension != "png")) 
				{
					$errors = 1;
				}
				else
				{
					$size   = getimagesize($_FILES[$GalleryImage]['tmp_name']);
					$sizekb = filesize($_FILES[$GalleryImage]['tmp_name']);
	
					if ($sizekb > MAX_SIZE * 1024)
					{
						$errors = 1;
					}
					$A = rand(100000,100000000);
					$image_name = $A.'.'.$extension;
					$newname    = "../images/products/largeimages/".$image_name;
					$copied     = copy($_FILES[$GalleryImage]['tmp_name'], $newname);
					if (!$copied) 
					{
						$errors = 1;
					}
					else
					{
						$thumb_name = "../images/products/smallimages/".$image_name;
						$thumb      = make_thumb($newname,$thumb_name,WIDTH,HEIGHT);
						//unlink("../images/".$image_name);
					}
				}
			}
			$imagequery = $db->prepare("INSERT INTO images (pid,image,imgstatus,imgdate) VALUES(?,?,?,?)");
			$imagevalues = array($Pid,$image_name,0,$Date);
			$imagequery->execute($imagevalues);
		}
		header("Location: $URL/upload_image.php?pid=$Pid&err=3");
		die;
	}

	function delete_product($db,$URL,$Pid)
	{
		
		$Query1 = $db->prepare("DELETE FROM products WHERE pid=?");
		
		if($Query1->execute(array($Pid)))
		{
			header("Location: products.php?err=4");
		}
	}
	function delete_image($db,$URL,$Pid,$Imgid)
	{
		$proQuery = $db->prepare("SELECT * FROM images WHERE imgid = ?");
		$proQuery->execute(array($Imgid));
		while($row = $proQuery->fetch())
		{
			if($row['image'] != "")
			{
				unlink("../images/products/largeimages/".$row['image']);
				unlink("../images/products/smallimages/".$row['image']);
			}
		}
		$Query = $db->prepare("DELETE FROM images WHERE imgid=?");
		if($Query->execute(array($Imgid)))
		{
			header("Location: upload_image.php?pid=$Pid&err=4");
		}
	}
	function delete_product_size($db,$URL,$Szid,$Pid)
	{
		$Query = $db->prepare("DELETE FROM product_sizes WHERE szid=?");
		if($Query->execute(array($Szid)))
		{
			header("Location: editproduct.php?pid=$Pid&err=4");
		}
	}

	function add_product_recipe($db,$URL,$pid,$szid)
	{
		$Date = time();		
		if(isset($_REQUEST['cboRawMaterials']))
		{
			for ($i = 0; $i < count($_REQUEST['cboRawMaterials']); $i++)
			{
				if (isset ($_REQUEST['cboRawMaterials'][$i]))
				{
					$pquery = $db->prepare("INSERT INTO recipes (pid,szid,rid,reqty) VALUES(?,?,?,?)");
					$pvalues = array($pid,$szid,$_REQUEST['cboRawMaterials'][$i],$_REQUEST['txtQty'][$i]);
					if(!$pquery->execute($pvalues))
					{
						echo "\nPDO::errorInfo():\n";
						print_r($pquery->errorInfo());die;
					}
				}
			}
			header("Location: $URL/product_recipes.php?pid=$pid&szid=$szid&err=2");
			die;
		}
		else
		{
			header("Location: $URL/product_recipes.php?pid=$pid&szid=$szid");
			die;
		}
	}
	///////////////////////////////////////////////////////
	
	/////////////////  Downloads  /////////////////
		
	function add_download($db,$URL)
	{
		$Date 	  = time();

		$title  = stripslashes($_REQUEST['txtTitle']);
		$detail = stripslashes($_REQUEST['txtDetail']);
		
		$allowed =  array('pdf','jpg');

		$File 	   = $_FILES['file']['name'];		
		$TmpFile   = $_FILES['file']['tmp_name'];

		$ext 	   = pathinfo($File, PATHINFO_EXTENSION);
		
		//echo($ext);die;
		$rand = rand();
		//echo($rand);die;
		//echo($File);die;
		$newfilename = $rand.".".$ext;
		//echo($newfilename);die;
		$target_path  = "images/downloads/";
		$target_path  = $target_path . basename($newfilename);
		
		if($ext == "pdf" || $ext == "doc" || $ext == "docx" || $ext == "zip")
		{
		    if(move_uploaded_file($TmpFile, $target_path))
			{
				$download_file_name = $newfilename;
			}
		}
		else
		{
			$download_file_name = "";
		}
		
		$Query = $db->prepare("INSERT INTO downloads(dtitle , ddetail , dfile , dstatus , ddate) VALUES(?,?,?,?,?)");
		$values = array($title , $detail , $download_file_name , 0 , $Date);
		if($Query->execute($values))
		{
		    ///////////////////// LOG SECTION /////////////////////
		    $log = "$title - Download has been created";
			log_entry($log);
		    ///////////////////////////////////////////////////////
		    header("Location: downloads.php?err=2");
			die; 
		}
	}

	function update_download($db,$URL,$did)
	{
		$Date 	  = time();

		$title  = stripslashes($_REQUEST['txtTitle']);
		$detail = stripslashes($_REQUEST['txtDetail']);
		$hdnfile = stripslashes($_REQUEST['hdnfile']);
		
		$allowed =  array('pdf','jpg');

		$File 	   = $_FILES['file']['name'];		
		$TmpFile   = $_FILES['file']['tmp_name'];

		$ext 	   = pathinfo($File, PATHINFO_EXTENSION);
		
		//echo($ext);die;
		$rand = rand();
		//echo($rand);die;
		//echo($File);die;
		$newfilename = $rand.".".$ext;
		//echo($newfilename);die;
		$target_path  = "images/downloads/";
		$target_path  = $target_path . basename($newfilename);
		
		if($ext == "pdf" || $ext == "doc" || $ext == "docx" || $ext == "zip")
		{
		    if(move_uploaded_file($TmpFile, $target_path))
			{
				$download_file_name = ", dfile = '$newfilename'";
				unlink($target_path.$hdnfile);
			}
		}
		else
		{
			$download_file_name = "";
		}
		
		$Query = $db->prepare("UPDATE downloads SET dtitle='$title' , ddetail='$detail' $download_file_name WHERE did=$did");
		if($Query->execute())
		{
		    ///////////////////// LOG SECTION /////////////////////
		    $log = "$title - Download has been updated";
			log_entry($log);
		    ///////////////////////////////////////////////////////
		    header("Location: downloads.php?err=3");
			die; 
		}
	}
	
	function delete_download($db,$URL,$did)
	{
	    $dquery = $db->prepare("SELECT * FROM downloads WHERE did=?");
	    $dquery->execute(array($did));
	    while($drow = $dquery->fetch())
	    {
			$title = $drow['dtitle'];
	        $doc = $drow['dfile'];
	        unlink("images/downloads/".$doc);
	    }
		$Query = $db->prepare("DELETE FROM downloads WHERE did=?");
		$values = array($did);
		if($Query->execute($values))
		{
			///////////////////// LOG SECTION /////////////////////
		    $log = "$title - download record has been deleted";
			log_entry($log);
		    ///////////////////////////////////////////////////////
			header("Location: $URL/downloads.php?err=4");
			die;
		}
	}

	/////////////////  Ac Main Category  /////////////////
	function add_acmaincategory()
	{
		global $db;
		global $URL;
		
		$Date 	  = time();
		$AcMainCategory  = stripslashes($_REQUEST['txtAcMainCategory']);

		$Query = $db->prepare("INSERT INTO acmaincategory(acmaincategory) VALUES(?)");
		$values = array($AcMainCategory);
		if($Query->execute($values))
		{	
		    ///////////////////// LOG SECTION /////////////////////
		    $log = "$AcMainCategory - Account Main Category has been created";
			log_entry($log);
		    ///////////////////////////////////////////////////////
		    header("Location: acmaincategory.php?err=2");
			die; 
		}
	}
	function update_acmaincategory()
	{
		global $db;
		global $URL;
		
		$Date 	  = time();
		$Acmid  = stripslashes($_REQUEST['acmid']);
		$AcMainCategory  = stripslashes($_REQUEST['txtAcMainCategory']);

		$Query = $db->prepare("UPDATE acmaincategory SET acmaincategory=? WHERE acmid=?");
		$values = array($AcMainCategory,$Acmid);
		if($Query->execute($values))
		{	
		     ///////////////////// LOG SECTION /////////////////////
		    $log = "$AcMainCategory - Account Main Category has been updated";
			log_entry($log);
		    ///////////////////////////////////////////////////////
		    header("Location: acmaincategory.php?err=3");
			die; 
		}
	}
	
	function delete_acmaincategory($Acmid)
	{
		global $db;
		global $URL;

		$Query = $db->prepare("DELETE FROM acmaincategory WHERE acmid=?");
		$values = array($Acmid);
		if($Query->execute($values))
		{
			///////////////////// LOG SECTION /////////////////////
		    $log = "Account Main Category has been deleted";
			log_entry($log);
		    ///////////////////////////////////////////////////////
			header("Location: $URL/acmaincategory.php?err=4");
			die;
		}
	}
	////////////////////////////////////////////////////
	/////////////////  Ac Category  /////////////////
	
	function add_accategory()
	{
		global $db;
		global $URL;
		
		$Date 	  = time();
		$Acmid  = stripslashes($_REQUEST['cboAcMainCategory']);
		$AcCategory  = stripslashes($_REQUEST['txtAcCategory']);

		$Query = $db->prepare("INSERT INTO accategory(acmid,accategory) VALUES(?,?)");
		$values = array($Acmid,$AcCategory);
		if($Query->execute($values))
		{
		    ///////////////////// LOG SECTION /////////////////////
		    $log = "$AcCategory - Account Category has been created";
			log_entry($log);
		    ///////////////////////////////////////////////////////
		    header("Location: accategory.php?err=2");
			die; 
		}
	}
	function update_accategory()
	{
		global $db;
		global $URL;

		$Date 	  = time();
		$Accid  = stripslashes($_REQUEST['accid']);
		$Acmid  = stripslashes($_REQUEST['hdnAcMainCategory']);
		$AcCategory  = stripslashes($_REQUEST['txtAcCategory']);
		$Query = $db->prepare("UPDATE accategory SET accategory=? WHERE accid=?");
		$values = array($AcCategory,$Accid);
		if($Query->execute($values))
		{
		    ///////////////////// LOG SECTION /////////////////////
		    $log = "$AcCategory - Account Category has been updated";
			log_entry($log);
		    ///////////////////////////////////////////////////////
		    header("Location: accategory.php?acmid=$Acmid&err=3");
			die; 
		}
	}
	function delete_accategory($Acmid,$Accid)
	{
		global $db;
		global $URL;
		$Query = $db->prepare("DELETE FROM accategory WHERE accid=?");
		$values = array($Accid);
		if($Query->execute($values))
		{
			///////////////////// LOG SECTION /////////////////////
		    $log = "Account Category has been deleted";
			log_entry($log);
		    ///////////////////////////////////////////////////////
			header("Location: $URL/accategory.php?acmid=$Acmid&err=4");
			die;
		}
	}
	////////////////////////////////////////////////////
	/////////////////  Add Account  /////////////////
	
	function add_account($db,$URL)
	{
		$Date 	  = time();
		$Acmid    = $_REQUEST['cboMainCategory'];
		$Accid    = $_REQUEST['cboCategory'];
		$Lid    = $_REQUEST['cboLocation'];
		$Name    = stripslashes($_REQUEST['txtName']);	
		$Email    = stripslashes($_REQUEST['txtEmail']);	
		$Cnic    = stripslashes($_REQUEST['txtCnic']);	
		$ContactName = stripslashes($_REQUEST['txtContactName']);

		$Address = stripslashes($_REQUEST['txtAddress']);	
		$City = stripslashes($_REQUEST['txtCity']);
		$Phone  = stripslashes($_REQUEST['txtPhone']);
		$Mobile = stripslashes($_REQUEST['txtMobile']);
		$BankAccount  = stripslashes($_REQUEST['txtBankAccount']);
		$BankDetails  = stripslashes($_REQUEST['txtBankDetails']);

		if($_REQUEST['hdnMember'] == "0")
		{	
			$Query = $db->prepare("INSERT INTO accounts(acmid , accid , lid , aname , aemail , cnic , contactname , aaddress , acity , aphone , amobile , bankaccount , bankdetail , astatus , adate) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
			$values = array($Acmid , $Accid , $Lid , $Name , $Email , $Cnic , $ContactName , $Address , $City , $Phone , $Mobile , $BankAccount , $BankDetails , 0 , $Date);
			if($Query->execute($values))
			{
				$Aid = $db->lastInsertId();
				$Balance = $_REQUEST['txtBalance'];
				//////////// Ledger Entry ///////////////////
				$Detail = "Opening Balance - ".date("d/m/Y")."";				
				if($_REQUEST['cboType'] == 1)
				{
					$Debit		 = $Balance;
					$Credit		 = 0;
					$TotalAmount = 0 + $Balance;
				}
				if($_REQUEST['cboType'] == 2)
				{
					$Debit		 = 0;
					$Credit		 = $Balance;
					$TotalAmount = 0 - $Balance;
				}

				$ledgerquery = $db->prepare("INSERT INTO ledger(aid , detail , debit , credit , balance , ldate) VALUES(?,?,?,?,?,?)");
				$ledgervalues = array($Aid,$Detail,$Debit,$Credit,$TotalAmount,$Date);
				$ledgerquery->execute($ledgervalues);
				
			    ///////////////////// LOG SECTION /////////////////////
			    $log = "$Name ($Email) - Account has been created";
				log_entry($log);
			    ///////////////////////////////////////////////////////
			    header("Location: accounts.php?acmid=$Acmid&err=2");
				die; 
			}
		}
		else
		{
			header("Location: addaccount.php?acmid=$Acmid&err=39");
			die; 
		}
	}
	function update_account($db,$URL,$Aid)
	{
		$Date 	  = time();
		
		$Name  	      = stripslashes($_REQUEST['txtName']);	
		$Cnic  		  = stripslashes($_REQUEST['txtCnic']);
		$ContactName  = stripslashes($_REQUEST['txtContactName']);
		$Address  	  = stripslashes($_REQUEST['txtAddress']);	
		$City 	  	  = stripslashes($_REQUEST['txtCity']);
		$Phone 		  = stripslashes($_REQUEST['txtPhone']);
		$Mobile 	  = stripslashes($_REQUEST['txtMobile']);
		$BankAccount  = stripslashes($_REQUEST['txtBankAccount']);
		$BankDetails  = stripslashes($_REQUEST['txtBankDetails']);
		$Status 	 = stripslashes($_REQUEST['cboStatus']);			
	
		$Query = $db->prepare("UPDATE accounts SET aname=?, cnic=? , contactname=? , aaddress=? , acity=? , aphone=? , amobile=? , bankaccount=? , bankdetail=? , astatus=? WHERE aid=?");
		$values = array($Name , $ContactName, $Cnic , $Address , $City , $Phone , $Mobile , $BankAccount , $BankDetails , $Status , $Aid);
		if($Query->execute($values))
		{	
		    ///////////////////// LOG SECTION /////////////////////
		    $log = "$Name ($Email) - Account has been updated";
			log_entry($log);
		    ///////////////////////////////////////////////////////
		    header("Location: accounts.php?err=3");
			die; 
		}
	}
	function delete_account($Aid)
	{
		global $db;
		global $URL;

		$Query = $db->prepare("DELETE FROM accounts WHERE aid=?");
		$values = array($Aid);
		if($Query->execute($values))
		{
			///////////////////// LOG SECTION /////////////////////
		    $log = "Account has been deleted";
			log_entry($log);
		    ///////////////////////////////////////////////////////
			header("Location: $URL/accounts.php?aid=$Aid&err=4");
			die;
		}
	}

	function add_vendor($db,$URL)
	{
		$Date 	  = time();
		$Acmid    = $_REQUEST['cboMainCategory'];
		$Accid    = $_REQUEST['cboCategory'];
		$Lid    = $_REQUEST['cboLocation'];
		$Name    = stripslashes($_REQUEST['txtName']);	
		$Email    = stripslashes($_REQUEST['txtEmail']);	
		$Cnic    = stripslashes($_REQUEST['txtCnic']);	
		$ContactName = stripslashes($_REQUEST['txtContactName']);

		$Address = stripslashes($_REQUEST['txtAddress']);	
		$City = stripslashes($_REQUEST['txtCity']);
		$Phone  = stripslashes($_REQUEST['txtPhone']);
		$Mobile = stripslashes($_REQUEST['txtMobile']);
		$BankAccount  = stripslashes($_REQUEST['txtBankAccount']);
		$BankDetails  = stripslashes($_REQUEST['txtBankDetails']);

		if($_REQUEST['hdnMember'] == "0")
		{	
			$Query = $db->prepare("INSERT INTO accounts(acmid , accid , lid , aname , aemail , cnic , contactname , aaddress , acity , aphone , amobile , bankaccount , bankdetail , astatus , adate) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
			$values = array($Acmid , $Accid , $Lid , $Name , $Email , $Cnic , $ContactName , $Address , $City , $Phone , $Mobile , $BankAccount , $BankDetails , 0 , $Date);
			if($Query->execute($values))
			{
				$Aid = $db->lastInsertId();
				$Balance = $_REQUEST['txtBalance'];
				//////////// Ledger Entry ///////////////////
				$Detail = "Opening Balance - ".date("d/m/Y")."";				
				if($_REQUEST['cboType'] == 1)
				{
					$Debit		 = $Balance;
					$Credit		 = 0;
					$TotalAmount = 0 + $Balance;
				}
				if($_REQUEST['cboType'] == 2)
				{
					$Debit		 = 0;
					$Credit		 = $Balance;
					$TotalAmount = 0 - $Balance;
				}

				$ledgerquery = $db->prepare("INSERT INTO ledger(aid , detail , debit , credit , balance , ldate) VALUES(?,?,?,?,?,?)");
				$ledgervalues = array($Aid,$Detail,$Debit,$Credit,$TotalAmount,$Date);
				$ledgerquery->execute($ledgervalues);
				
			    ///////////////////// LOG SECTION /////////////////////
			    $log = "$Name ($Email) - Vendor Account has been created";
				log_entry($log);
			    ///////////////////////////////////////////////////////
			    header("Location: vendors.php?err=2");
				die; 
			}
		}
		else
		{
			header("Location: addaccount.php?acmid=$Acmid&err=39");
			die; 
		}
	}
	function update_vendor($db,$URL,$Aid)
	{
		$Date 	  = time();
		$Name  	      = stripslashes($_REQUEST['txtName']);	
		$Cnic  		  = stripslashes($_REQUEST['txtCnic']);
		$ContactName  = stripslashes($_REQUEST['txtContactName']);
		$Address  	  = stripslashes($_REQUEST['txtAddress']);	
		$City 	  	  = stripslashes($_REQUEST['txtCity']);
		$Phone 		  = stripslashes($_REQUEST['txtPhone']);
		$Mobile 	  = stripslashes($_REQUEST['txtMobile']);
		$BankAccount  = stripslashes($_REQUEST['txtBankAccount']);
		$BankDetails  = stripslashes($_REQUEST['txtBankDetails']);
		$Status 	 = stripslashes($_REQUEST['cboStatus']);			
	
		$Query = $db->prepare("UPDATE accounts SET aname=?, cnic=? , contactname=? , aaddress=? , acity=? , aphone=? , amobile=? , bankaccount=? , bankdetail=? , astatus=? WHERE aid=?");
		$values = array($Name , $ContactName, $Cnic , $Address , $City , $Phone , $Mobile , $BankAccount , $BankDetails , $Status , $Aid);
		if($Query->execute($values))
		{	
		    ///////////////////// LOG SECTION /////////////////////
		    $log = "$Name ($Email) - Vendor Account has been updated";
			log_entry($log);
		    ///////////////////////////////////////////////////////
		    header("Location: vendors.php?err=3");
			die; 
		}
	}
	function delete_vendor($Aid)
	{
		global $db;
		global $URL;

		$Query = $db->prepare("DELETE FROM accounts WHERE aid=?");
		$values = array($Aid);
		if($Query->execute($values))
		{
			///////////////////// LOG SECTION /////////////////////
		    $log = "Vendor Account has been deleted";
			log_entry($log);
		    ///////////////////////////////////////////////////////
			header("Location: $URL/vendors.php?err=4");
			die;
		}
	}
	///////////////////////////////////////////////////////
	/////////////////  Add Member  /////////////////
	
	function add_member($db,$URL)
	{
		$Date  = time();
		$lid   = $_REQUEST['cboLocation'];
		
		$FirstName   	 = stripslashes($_REQUEST['txtFirstName']);	
		$LastName   	 = stripslashes($_REQUEST['txtLastName']);	
		$Email   		 = stripslashes($_REQUEST['txtEmail']);
		$Cnic 		 	 = stripslashes($_REQUEST['txtCnic']);
		
		$Address 		 = stripslashes($_REQUEST['txtAddress']);	
		$City 			 = stripslashes($_REQUEST['txtCity']);
		$Phone 			 = stripslashes($_REQUEST['txtPhone']);
		$Mobile 		 = stripslashes($_REQUEST['txtMobile']);
		$BusinessType 	 = stripslashes($_REQUEST['txtBusinessType']);
		$CompanyName  	 = stripslashes($_REQUEST['txtCompanyName']);
		$CompanyAddress  = stripslashes($_REQUEST['txtCompanyAddress']);
		$CompanyPhone  	 = stripslashes($_REQUEST['txtCompanyPhone']);

		if($_REQUEST['hdnMember'] == "0")
		{
			$Query = $db->prepare("INSERT INTO members(lid , mfirstname, mlastname , memail , cnic , maddress , mcity , mphone , mmobile , businesstype , mconame, mcoaddress, mcophone, mdate) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
			$values = array($lid , $FirstName, $LastName , $Email , $Cnic , $Address , $City , $Phone , $Mobile , $BusinessType , $CompanyName, $CompanyAddress, $CompanyPhone , $Date);
			if($Query->execute($values))
			{
				$mid = $db->lastInsertId();

				// Ledger Entry
				$lquery = $db->prepare("INSERT INTO ledger(mid,ldate) VALUES(?,?)");
     			$lquery->execute(array($mid,$Date));
				
			    ///////////////////// LOG SECTION /////////////////////
			    $log = "$FirstName $LastName ($Email) - Member Account has been created";
				log_entry($log);
			    ///////////////////////////////////////////////////////
			    header("Location: members.php?err=2");
				die; 
			}
			else
			{
				echo "\nPDO::errorInfo():\n";
				print_r($db->errorInfo());die;
			}
		}
		else
		{
			header("Location: addmember.php?err=39");
			die; 
		}
	}

	function update_member($db,$URL,$mid)
	{
		$Date  = time();
		
		$FirstName   	 = stripslashes($_REQUEST['txtFirstName']);	
		$LastName   	 = stripslashes($_REQUEST['txtLastName']);	
		
		$Address 		 = stripslashes($_REQUEST['txtAddress']);	
		$City 			 = stripslashes($_REQUEST['txtCity']);
		$Phone 			 = stripslashes($_REQUEST['txtPhone']);
		$Mobile 		 = stripslashes($_REQUEST['txtMobile']);
		$BusinessType 	 = stripslashes($_REQUEST['txtBusinessType']);
		$CompanyName  	 = stripslashes($_REQUEST['txtCompanyName']);
		$CompanyAddress  = stripslashes($_REQUEST['txtCompanyAddress']);
		$CompanyPhone  	 = stripslashes($_REQUEST['txtCompanyPhone']);

		$Query = $db->prepare("UPDATE member SET mfirstname=?, mlastname=? , maddress=? , mcity=? , mphone=? , mmobile=?, businesstype=?, mconame=?, mcoaddress=?, mcophone=? WHERE mid=?");
		$values = array($FirstName, $LastName , $Address , $City , $Phone , $Mobile , $BusinessType , $CompanyName, $CompanyAddress, $CompanyPhone , $mid);
		if($Query->execute($values))
		{			
		    ///////////////////// LOG SECTION /////////////////////
		    $log = "FirstName $LastName Member Account has been updated";
			log_entry($log);
		    ///////////////////////////////////////////////////////
		    header("Location: members.php?err=3");
			die; 
		}
	}
	function delete_member($db,$URL,$mid)
	{
		$Query = $db->prepare("DELETE FROM members WHERE mid=?");
		$values = array($Aid);
		if($Query->execute($values))
		{
			///////////////////// LOG SECTION /////////////////////
		    $log = "Member Account has been deleted";
			log_entry($log);
		    ///////////////////////////////////////////////////////
			header("Location: members.php?err=4");
			die;
		}
	}

	//////////////////////////////////////////////////////
	/////////////////  Subscription  /////////////////

	function add_subscription($db,$URL)
	{
		include("sub_thumb.php");

		$Date  	  = time();		
		$ExpDate  = time() + 1296000;  // After 15 Days		
		
		$plid 			= $_REQUEST['cboPlan'];
		$aid 			= $_REQUEST['cboCustomer'];

		$lid 			= $_REQUEST['cboLocation'];
		$flid 			= $_REQUEST['cboFloor'];
		$title   		= $_REQUEST['txtTitle'];
		$nummembers 	= $_REQUEST['txtTeam'];

		$startdate   	= strtotime(str_replace("/", "-", $_REQUEST['txtStartDate']));

		if($_REQUEST['txtEndDate'] != '') { $enddate = strtotime(str_replace("/", "-", $_REQUEST['txtEndDate'])); } else{ $enddate = 0; }

		$price 			  = $_REQUEST['txtPrice'];
		$deposit 		  = $_REQUEST['txtDeposit'];
		$office_setup     = $_REQUEST['txtOfficeSetup'];

		$print_limit 	  = $_REQUEST['txtPrintLimit'];
		$print_rate 	  = $_REQUEST['txtPrintPrice'];

		$generator_limit  = $_REQUEST['txtGeneratorLimit'];
		$generator_rate   = $_REQUEST['txtGeneratorPrice'];

		$electricity_limit  = $_REQUEST['txtElectricityLimit'];
		$electricity_rate   = $_REQUEST['txtElectricityPrice'];

		$gas_limit  = $_REQUEST['txtGasLimit'];
		$gas_rate   = $_REQUEST['txtGasPrice'];

		$card_limit  = $_REQUEST['txtCardLimit'];
		$card_rate   = $_REQUEST['txtCardPrice'];

		$card_lost_limit  = $_REQUEST['txtCardLostLimit'];
		$card_lost_rate   = $_REQUEST['txtCardLostPrice'];

		$hdnMembership   = $_REQUEST['hdnMembership'];

		if(isset($_REQUEST['chkShow'])) { $chkShow = 1; } else{ $chkShow = 0; }

		$image       = $_FILES['image']['name'];
		if($image != "")
		{
			if ($image) 
			{
				$filename  = stripslashes($_FILES['image']['name']);
				$extension = getExtension($filename);
				$extension = strtolower($extension);
				if (($extension != "jpg") && ($extension != "jpeg") && ($extension != "png")) 
				{
					$errors = 1;
				}
				else
				{
					$size   = getimagesize($_FILES['image']['tmp_name']);
					$sizekb = filesize($_FILES['image']['tmp_name']);
					if ($sizekb > MAX_SIZE * 1024)
					{
						$errors = 1;
					}
					$A = rand(1000,1000000);
					$image_name = $A.'.'.$extension;
					$newname    = "../images/".$image_name;
					$copied     = copy($_FILES['image']['tmp_name'], $newname);
					if (!$copied) 
					{
						$errors = 1;
					}
					else
					{
						$thumb_name = "../images/members/logos/".$image_name;
						$thumb      = make_thumb($newname,$thumb_name,WIDTH,HEIGHT);
						unlink("../images/".$image_name."");
					}
				}
			}
			$member_logo = $image_name;
		}
		else
		{
			$member_logo = "";
		}

		$aquery = $db->prepare("SELECT * FROM accounts WHERE aid=?");
		$aquery->execute(array($aid));
		while($arow = $aquery->fetch())
		{
			$gtno = $arow['gtno'];
		}

		///////////  Calculate Subscription Invoice Amount /////////////
		/// 30 days billing cycle		
		$currentday = date("d");
		$totaldays = 30 - $currentday + 1;
		$dayprice  = $price / 30;
		$firstmonthunitprice = $dayprice * $totaldays;
		$firstmonthtotalprice = round($firstmonthunitprice * $nummembers);
		$totaldeposit = round($deposit * $nummembers);
		$grandtotal = $firstmonthtotalprice + $totaldeposit + $office_setup;
		
		if($hdnMembership == 0)
		{
			$Query = $db->prepare("INSERT INTO subscriptions(plid , aid , lid , flid , subtitle , sublogo , show_logo , nummembers , startdate , enddate , subunitprice , subtotalprice , subdeposit , subtotaldeposit , 
			subofficesetup , printlimit , printrate , generatorlimit , generatorrate , electricitylimit , electricityrate , gaslimit , gasrate , cardlimit , cardrate , cardlostlimit , cardlostrate  , subdate) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
			$Values = array($plid,$aid,$lid,$flid,$title,$member_logo,$chkShow,$nummembers,$startdate,$enddate,$price,$firstmonthtotalprice,$deposit,$totaldeposit,$office_setup,$print_limit,$print_rate,$generator_limit,$generator_rate,$electricity_limit,$electricity_rate,$gas_limit,$gas_rate,$card_limit,$card_rate,$card_lost_limit,$card_lost_rate,$Date);
			if($Query->execute($Values))
			{
				$subid = $db->lastInsertId();

				//////// Assigning GT Number to Subscription  ///////
				$subgtno = str_pad($subid, 2 , "0", STR_PAD_LEFT);
				$sub_gtno = "$gtno-$subgtno";
				$subquery = $db->prepare("UPDATE subscriptions SET subgtno = ? WHERE subid = ?");
				$subquery->execute(array($sub_gtno,$subid));
				
				/////////////   Entry for Sub Members  /////////////
				$gtcount = 0;
				for ($i = 1; $i <= $nummembers; $i++)
				{
					$sm_gtno = "$gtno-$subid-".str_pad($i, 2 , "0", STR_PAD_LEFT);
					$mquery = $db->prepare("INSERT INTO submembers(aid , lid , subid , smgtno , smdate) VALUES(?,?,?,?,?)");
					$mvalues = array($aid , $lid , $subid , $sm_gtno , $Date);
					$mquery->execute($mvalues);
				}
			
				/// Add Conference Room Hrs Limit and PerHr Price ///
				
				$arquery = $db->prepare("SELECT * FROM arights WHERE aid = ?");
				$arquery->execute(array($aid));
				while($arow = $arquery->fetch())
				{
					$conference_room = $arow['conference_room'];
					$meeting_room = $arow['meeting_room'];
				}
				$slquery1 = $db->prepare("SELECT * FROM slots WHERE slid IN ($conference_room)");
				$slquery1->execute();
				while($slrow1 = $slquery1->fetch())
				{
					$slid = $slrow1['slid'];
					
					$txtconfhrslimit = "txtConfHrsLimit$slid";
					$txtconfhrsrate  = "txtConfHrsRate$slid";
					$txtconfinterval = "txtConfInterval$slid";
					
					$conf_hrslimit = $_REQUEST[$txtconfhrslimit];
					$conf_hrsrate  = $_REQUEST[$txtconfhrsrate];
					$conf_interval = $_REQUEST[$txtconfinterval];

					$confquery  = $db->prepare("INSERT INTO subslots(slid, aid, subid, subsllimit, subslrate, subinterval) VALUES(?,?,?,?,?,?)");
					$confvalues = array($slid,$aid,$subid,$conf_hrslimit,$conf_hrsrate,$conf_interval);
					$confquery->execute($confvalues);
				}

				///////////////////////////////////////////////////////////////
				/// Add Meeting Room Hrs Limit and PerHr Price ///

				$slquery2 = $db->prepare("SELECT * FROM slots WHERE slid IN ($meeting_room)");
				$slquery2->execute();
				while($slrow2 = $slquery2->fetch())
				{
					$slid = $slrow2['slid'];
					
					$txtmeetinghrslimit = "txtMeetingHrsLimit$slid";
					$txtmeetinghrsrate  = "txtMeetingHrsRate$slid";
					$txtmeetinginterval = "txtMeetingInterval$slid";
					
					$meeting_hrslimit = $_REQUEST[$txtmeetinghrslimit];
					$meeting_hrsrate  = $_REQUEST[$txtmeetinghrsrate];
					$meeting_interval = $_REQUEST[$txtmeetinginterval];

					$meetingquery  = $db->prepare("INSERT INTO subslots(slid, aid, subid, subsllimit, subslrate, subinterval) VALUES(?,?,?,?,?,?)");
					$meetingvalues = array($slid,$aid,$subid,$meeting_hrslimit,$meeting_hrsrate,$meeting_interval);
					$meetingquery->execute($meetingvalues);
				}
				///////////////////////////////////////////////////////////////

				///////////////////// LOG SECTION /////////////////////
			    $log = "Subscription# $sub_gtno for $gtno as $title has been created";
				log_entry($log);
				header("Location: subscriptions.php?err=2");
			}
		}
		else
		{
			header("Location: addsubs.php?err=44");
		}
	}

	function update_subscription($db,$URL,$subid)
	{
		include("sub_thumb.php");

		$Date 	 		= time();		
		
		$aid   			= $_REQUEST['hdnAid'];
		$lid   			= $_REQUEST['hdnLid'];
		$flid 			= $_REQUEST['cboFloor'];
		$plid   		= $_REQUEST['cboPlan'];

		$title   		= $_REQUEST['txtTitle'];
		$deposit   		= $_REQUEST['txtDeposit'];
		$officesetup   	= $_REQUEST['txtOfficeSetup'];

		if($_REQUEST['txtStartDate'] != '') { $startdate = strtotime(str_replace("/", "-", $_REQUEST['txtStartDate'])); } else{ $startdate = 0; }
		if($_REQUEST['txtEndDate'] != '') { $enddate = strtotime(str_replace("/", "-", $_REQUEST['txtEndDate'])); } else{ $enddate = 0; }

		$price 			  = $_REQUEST['txtPrice'];
		$print_limit 	  = $_REQUEST['txtPrintLimit'];
		$print_rate 	  = $_REQUEST['txtPrintPrice'];
		$generator_limit  = $_REQUEST['txtGeneratorLimit'];
		$generator_rate   = $_REQUEST['txtGeneratorPrice'];

		$electricity_limit  = $_REQUEST['txtElectricityLimit'];
		$electricity_rate   = $_REQUEST['txtElectricityPrice'];

		$gas_limit  = $_REQUEST['txtGasLimit'];
		$gas_rate   = $_REQUEST['txtGasPrice'];

		$card_limit  = $_REQUEST['txtCardLimit'];
		$card_rate   = $_REQUEST['txtCardPrice'];

		$card_lost_limit  = $_REQUEST['txtCardLostLimit'];
		$card_lost_rate   = $_REQUEST['txtCardLostPrice'];

		if(isset($_REQUEST['chkShow'])) { $chkShow = 1; } else{ $chkShow = 0; }

		$startdate   	= strtotime(str_replace("/", "-", $_REQUEST['txtStartDate']));

		if($_REQUEST['txtEndDate'] != '') { $enddate = strtotime(str_replace("/", "-", $_REQUEST['txtEndDate'])); } else{ $enddate = 0; }

		$status   		= $_REQUEST['cboStatus'];
		$archived   	= $_REQUEST['cboArchive'];

		$hdnLogo   	= $_REQUEST['hdnLogo'];
		
		$image       = $_FILES['image']['name'];
		if($image != "")
		{
			if ($image) 
			{
				$filename  = stripslashes($_FILES['image']['name']);
				$extension = getExtension($filename);
				$extension = strtolower($extension);
				if (($extension != "jpg") && ($extension != "jpeg") && ($extension != "png")) 
				{
					$errors = 1;
				}
				else
				{
					$size   = getimagesize($_FILES['image']['tmp_name']);
					$sizekb = filesize($_FILES['image']['tmp_name']);
					if ($sizekb > MAX_SIZE * 1024)
					{
						$errors = 1;
					}
					$A = rand(1000,1000000);
					$image_name = $A.'.'.$extension;
					$newname    = "../images/".$image_name;
					$copied     = copy($_FILES['image']['tmp_name'], $newname);
					if (!$copied) 
					{
						$errors = 1;
					}
					else
					{
						$thumb_name = "../images/members/logos/".$image_name;
						$thumb      = make_thumb($newname,$thumb_name,WIDTH,HEIGHT);
						unlink("../images/".$image_name."");
						unlink("../images/members/logos/".$hdnLogo."");
					}
				}
			}
			$member_logo = $image_name;
		}
		else
		{
			$member_logo = $hdnLogo;
		}

		$num   = $_REQUEST['txtNum'];
		$totalmembers = $_REQUEST['hdnNumMembers'] + $num;

		if($num > 0)
		{
			for ($i = 1; $i <= $num; $i++)
			{
				$hdnSmGtno	 = "hdnSmGtno$i";
				$Name		 = "txtName$i";
				$Email	 	 = "txtEmail$i";
				$Dob 	   	 = "txtDob$i";
				$Mobile 	 = "txtMobile$i";
				$Cnic 		 = "txtCnic$i";
				$Address 	 = "txtAddress$i";	

				$SubQuery = $db->prepare("INSERT INTO submembers(aid , lid , subid , smgtno , smname , smemail , smmobile , smcnic , smdob , smaddress , smdate) VALUES(?,?,?,?,?,?,?,?,?,?,?)");
				$SubValues = array($aid , $lid , $subid , $_REQUEST[$hdnSmGtno] , $_REQUEST[$Name] , $_REQUEST[$Email] , $_REQUEST[$Mobile] , $_REQUEST[$Cnic] , $_REQUEST[$Dob] , $_REQUEST[$Address] , $Date);
				
				if(!$SubQuery->execute($SubValues))
				{
					echo "\nPDO::errorInfo():\n";
					print_r($db->errorInfo());die;
				}
			}
		}

		/// Add Conference Room Hrs Limit and PerHr Price ///
				
		$arquery = $db->prepare("SELECT * FROM arights WHERE aid = ?");
		$arquery->execute(array($aid));
		while($arow = $arquery->fetch())
		{
			$conference_room = $arow['conference_room'];
			$meeting_room = $arow['meeting_room'];
		}

		$slquery1 = $db->prepare("SELECT * FROM slots WHERE slid IN ($conference_room)");
		$slquery1->execute();
		while($slrow1 = $slquery1->fetch())
		{
			$slid = $slrow1['slid'];
			
			$txtconfhrslimit = "txtConfHrsLimit$slid";
			$txtconfhrsrate  = "txtConfHrsRate$slid";
			$txtconfinterval = "txtConfInterval$slid";
			
			$conf_hrslimit = $_REQUEST[$txtconfhrslimit];
			$conf_hrsrate  = $_REQUEST[$txtconfhrsrate];
			$conf_interval = $_REQUEST[$txtconfinterval];

			$cquery = $db->prepare("SELECT * FROM subslots WHERE slid=? AND aid=? AND subid=?");
			$cquery->execute(array($slid,$aid,$subid));

			if($cquery->rowCount() == 0)
			{
				$confquery  = $db->prepare("INSERT INTO subslots(slid, aid, subid, subsllimit, subslrate, subinterval) VALUES(?,?,?,?,?,?)");
				$confvalues = array($slid,$aid,$subid,$conf_hrslimit,$conf_hrsrate,$conf_interval);
				$confquery->execute($confvalues);	
			}
			else
			{
				$confquery  = $db->prepare("UPDATE subslots SET subsllimit=?, subslrate=?, subinterval=? WHERE slid=? AND aid=? AND subid=?");
				$confvalues = array($conf_hrslimit,$conf_hrsrate,$conf_interval,$slid,$aid,$subid);
				$confquery->execute($confvalues);
			}	
		}

		///////////////////////////////////////////////////////////////
		/// Add Meeting Room Hrs Limit and PerHr Price ///

		$slquery2 = $db->prepare("SELECT * FROM slots WHERE slid IN ($meeting_room)");
		$slquery2->execute();
		while($slrow2 = $slquery2->fetch())
		{
			$slid = $slrow2['slid'];
			
			$txtmeetinghrslimit = "txtMeetingHrsLimit$slid";
			$txtmeetinghrsrate  = "txtMeetingHrsRate$slid";
			$txtmeetinginterval = "txtMeetingInterval$slid";
			
			$meeting_hrslimit = $_REQUEST[$txtmeetinghrslimit];
			$meeting_hrsrate  = $_REQUEST[$txtmeetinghrsrate];
			$meeting_interval = $_REQUEST[$txtmeetinginterval];

			$mquery = $db->prepare("SELECT * FROM subslots WHERE slid=? AND aid=? AND subid=?");
			$mquery->execute(array($slid,$aid,$subid));
			
			if($cquery->rowCount() == 0)
			{
				$meetingquery  = $db->prepare("INSERT INTO subslots(slid, aid, subid, subsllimit, subslrate, subinterval) VALUES(?,?,?,?,?,?)");
				$meetingvalues = array($slid,$aid,$subid,$meeting_hrslimit,$meeting_hrsrate,$meeting_interval);
				$meetingquery->execute($meetingvalues);
			}
			else
			{
				$meetingquery  = $db->prepare("UPDATE subslots SET subsllimit=?, subslrate=?, subinterval=? WHERE slid=? AND aid=? AND subid=?");
				$meetingvalues = array($meeting_hrslimit,$meeting_hrsrate,$meeting_interval,$slid,$aid,$subid);
				$meetingquery->execute($meetingvalues);
			}
		}

		///////////////////////////////////////////////////////////////

		$Query = $db->prepare("UPDATE subscriptions SET plid=?, flid=? , subtitle=? , sublogo=? , show_logo=? , startdate=? , enddate=? , subdeposit=? , subofficesetup=? , nummembers=? , subunitprice=? , printlimit=? , printrate=? , generatorlimit=? , generatorrate=? , electricitylimit=? , electricityrate=? , gaslimit=? , gasrate=? , cardlimit=? , cardrate=? , cardlostlimit=? , cardlostrate=? , substatus=? , subarchived=? WHERE subid=?");
		$Values = array($plid,$flid,$title,$member_logo,$chkShow,$startdate,$enddate,$deposit,$officesetup,$totalmembers,$price,$print_limit,$print_rate,$generator_limit,$generator_rate,$electricity_limit,$electricity_rate,$gas_limit,$gas_rate,$card_limit,$card_rate,$card_lost_limit,$card_lost_rate,$status,$archived,$subid);
		if($Query->execute($Values))
		{
			$log = "Subscription# $title has been updated";
			log_entry($log);
			header("Location: editsubs.php?subid=$subid&err=3");
		}
	}

	function delete_subscription($db,$URL,$subid)
	{
		$query1 = $db->prepare("DELETE FROM subscriptions  WHERE subid=?");
		$query2 = $db->prepare("DELETE FROM submembers  WHERE subid=?");

		if($query1->execute(array($subid)) && $query2->execute(array($subid)))
		{
			$log = "Subscription has been deleted";
			log_entry($log);
			header("Location: subscriptions.php?err=4");
		}
	}

	/////////////////  Update Registration  ///////////////////////
	function update_register($db,$URL,$rid)
	{
		$FirstName = stripslashes($_REQUEST['txtFirstName']);	
		$LastName  = stripslashes($_REQUEST['txtLastName']);	
		$Email     = stripslashes($_REQUEST['txtEmail']);	
		$Mobile    = stripslashes($_REQUEST['txtMobile']);
		$Phone     = stripslashes($_REQUEST['txtPhone']);
		$Address   = stripslashes($_REQUEST['txtAddress']);	
		$City 	   = stripslashes($_REQUEST['txtCity']);
		$State 	   = stripslashes($_REQUEST['txtState']);

		//////////// Update Registration Status ///////////////////
		$query = $db->prepare("UPDATE register SET firstname=?, lastname=?, email=?, mobileno=?, phoneno=?, address=?, city=?, state=? WHERE rid=?");
		$values = array($FirstName,$LastName,$Email,$Mobile,$Phone,$Address,$City,$State,$rid);

		if($query->execute($values))
		{
			header("Location: editregistration.php?rid=$rid&err=3");
			die;	
		}
	}
	///////////////////////////////////////////////////////
	/////////////////  Upgrade Registration to Customer Account  ///////////////////////
	function upgrade_to_customer($db,$URL,$rid)
	{
		$Date 			= time();
		$Name    		= stripslashes($_REQUEST['txtFirstName']." ".$_REQUEST['txtLastName']);	
		$Email    		= stripslashes($_REQUEST['txtEmail']);	
		$Mobile 		= stripslashes($_REQUEST['txtMobile']);
		$Phone  		= stripslashes($_REQUEST['txtPhone']);
		$Address 		= stripslashes($_REQUEST['txtAddress']);	
		$City 			= stripslashes($_REQUEST['txtCity']);

		///////////// Check for the Last GM Number ////////////

		$aquery = $db->prepare("SELECT * FROM accounts WHERE acmid=? ORDER BY aid DESC LIMIT 0,1");
		$aquery->execute(array(1));
		while($arow = $aquery->fetch())
		{
			if($arow['gtno'] != "")
			{
				$agtno = explode("-", $arow['gtno']);
				$gt_no = $agtno[1] + 1;	
				$gtno = "GT-".$gt_no;
			}
			else
			{
				$gtno = "GT-1001";
			}
		}

		$query = $db->prepare("INSERT INTO accounts(acmid , lid , aname , aemail , aaddress , acity , aphone , amobile , astatus , adate) VALUES(?,?,?,?,?,?,?,?,?,?)");
		$values = array(1 , 1 , $Name , $Email , $Address , $City , $Phone , $Mobile , 0 , $Date);
		if($query->execute($values))
		{
			$Aid = $db->lastInsertId();

			//////////// Assign GT Number ///////////////////
			$updqtquery = $db->prepare("UPDATE accounts SET gtno=? WHERE aid=?");
			$updqtquery->execute(array($gtno,$Aid));

			//////////// Ledger Entry ///////////////////
			$Detail = "Opening Balance - ".date("d/m/Y")."";							
			$Debit		 = 0;
			$Credit		 = 0;
			$TotalAmount = 0;
			$ledgerquery = $db->prepare("INSERT INTO ledger(aid , detail , debit , credit , balance , ldate) VALUES(?,?,?,?,?,?)");
			$ledgervalues = array($Aid,$Detail,$Debit,$Credit,$TotalAmount,$Date);
			$ledgerquery->execute($ledgervalues);

			//////////// Update Registration Status ///////////////////
			$updqtquery = $db->prepare("UPDATE register SET rstatus=? WHERE rid=?");
			$updqtquery->execute(array(1,$rid));

		    ///////////////////// LOG SECTION /////////////////////
		    $log = "$Name ($Email) - Customer Account has been created";
			log_entry($log);
		    ///////////////////////////////////////////////////////

		    header("Location: editcustomer.php?aid=$Aid&err=2");
			die; 
		}
	}
	///////////////////////////////////////////////////////
	/////////////////  Add Customer  /////////////////
	
	function add_customer($db,$URL)
	{
		$Date 	  		= time();
		$Acmid    		= 1;
		
		$Lid    		= $_REQUEST['cboLocation'];
		$Name    		= stripslashes($_REQUEST['txtName']);	
		$Email    		= stripslashes($_REQUEST['txtEmail']);	
		$Cnic 			= stripslashes($_REQUEST['txtCnic']);
		
		$Address 		= stripslashes($_REQUEST['txtAddress']);	
		$City 			= stripslashes($_REQUEST['txtCity']);
		$Phone  		= stripslashes($_REQUEST['txtPhone']);
		$Mobile 		= stripslashes($_REQUEST['txtMobile']);
		$BusinessType   = stripslashes($_REQUEST['txtBusinessType']);
		$BusinessDetail = stripslashes($_REQUEST['txtBusinessDetail']);
		$CompanyName  	= stripslashes($_REQUEST['txtCompanyName']);
		$CompanyAddress = stripslashes($_REQUEST['txtCompanyAddress']);
		$CompanyPhone   = stripslashes($_REQUEST['txtCompanyPhone']);

		/////////////// RIGHTS SECTION /////////////////////

		if(isset($_REQUEST['chkRights1']))  { $chkRights1 = 1; }  else{ $chkRights1 = 0; }
		if(isset($_REQUEST['chkRights2']))  { $chkRights2 = 1; }  else{ $chkRights2 = 0; }
		if(isset($_REQUEST['chkRights3']))  { $chkRights3 = 1; }  else{ $chkRights3 = 0; }
		if(isset($_REQUEST['chkRights4']))  { $chkRights4 = 1; }  else{ $chkRights4 = 0; }
		if(isset($_REQUEST['chkRights5']))  { $chkRights5 = 1; }  else{ $chkRights5 = 0; }
		if(isset($_REQUEST['chkRights6']))  { $chkRights6 = 1; }  else{ $chkRights6 = 0; }
		if(isset($_REQUEST['chkRights7']))  { $chkRights7 = 1; }  else{ $chkRights7 = 0; }
		if(isset($_REQUEST['chkRights8']))  { $chkRights8 = 1; }  else{ $chkRights8 = 0; }
		if(isset($_REQUEST['chkRights9']))  { $chkRights9 = 1; }  else{ $chkRights9 = 0; }
		if(isset($_REQUEST['chkRights10'])) { $chkRights10 = 1; } else{ $chkRights10 = 0; }

		if(isset($_POST['chkConference']))
		{
			$cust_conference = implode(",", $_POST['chkConference']);	
		}
		else
		{
			$cust_conference = 8;	
		}

		if(isset($_POST['chkMeeting']))
		{
			$cust_meeting = implode(",", $_POST['chkMeeting']);	
		}
		else
		{
			$cust_meeting = 12;	
		}

		///////////// Check for the Last GM Number ////////////

		$aquery = $db->prepare("SELECT * FROM accounts WHERE acmid=? ORDER BY aid DESC LIMIT 0,1");
		$aquery->execute(array(1));
		while($arow = $aquery->fetch())
		{
			if($arow['gtno'] != "")
			{
				$agtno = explode("-", $arow['gtno']);
				$gt_no = $agtno[1] + 1;	
				$gtno = "GT-".$gt_no;
			}
			else
			{
				$gtno = "GT-1001";
			}
		}
		
		///////////////////////////////////////////////////////
		
		if($_REQUEST['hdnCustomer'] == "0" && $_REQUEST['hdnEmail'] == "0" && $_REQUEST['hdnCnic'] == "0")
		{
			$Query = $db->prepare("INSERT INTO accounts(acmid , lid , aname , aemail , cnic , aaddress , acity , aphone , amobile , businesstype, businessdetail, aconame, acoaddress, acophone , astatus , adate) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
			$values = array($Acmid , $Lid , $Name , $Email , $Cnic , $Address , $City , $Phone , $Mobile , $BusinessType , $BusinessDetail , $CompanyName , $CompanyAddress, $CompanyPhone , 0 , $Date);
			if($Query->execute($values))
			{
				$Aid = $db->lastInsertId();

				//////////// Assign Rights ///////////////////
				$arquery = $db->prepare("INSERT INTO arights(aid,membership,invoice,conference_booking,meeting_booking,update_profile,change_password,support,notification, amenities, amenity_report, conference_room, meeting_room) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?)");
				$arvalues = array($Aid,$chkRights1,$chkRights2,$chkRights3,$chkRights4,$chkRights5,$chkRights6,$chkRights7,$chkRights8,$chkRights9,$chkRights10,$cust_conference,$cust_meeting);
				$arquery->execute($arvalues);

				//////////// Assign GT Number ///////////////////
				$updqtquery = $db->prepare("UPDATE accounts SET gtno=? WHERE aid=?");
				$updqtquery->execute(array($gtno,$Aid));

				//////////// Ledger Entry ///////////////////
				$Detail = "Opening Balance - ".date("d/m/Y")."";							
				$Debit		 = 0;
				$Credit		 = 0;
				$TotalAmount = 0;
				$ledgerquery = $db->prepare("INSERT INTO ledger(aid , detail , debit , credit , balance , ldate) VALUES(?,?,?,?,?,?)");
				$ledgervalues = array($Aid,$Detail,$Debit,$Credit,$TotalAmount,$Date);
				$ledgerquery->execute($ledgervalues);

			    ///////////////////// LOG SECTION /////////////////////
			    $log = "$Name ($Email) - Customer Account has been created";
				log_entry($log);
			    ///////////////////////////////////////////////////////
			    header("Location: customers.php?err=2");
				die; 
			}
		}
		else
		{
			header("Location: addcustomer.php?err=41");
			die; 
		}
	}

	function update_customer($db,$URL,$Aid)
	{
		$Date 	  = time();
		
		$Name 			= stripslashes($_REQUEST['txtName']);	
		$Email 			= stripslashes($_REQUEST['txtEmail']);
		$Cnic 			= stripslashes($_REQUEST['txtCnic']);	
		$Address 		= stripslashes($_REQUEST['txtAddress']);	
		$City 			= stripslashes($_REQUEST['txtCity']);
		$Phone  		= stripslashes($_REQUEST['txtPhone']);
		$Mobile 		= stripslashes($_REQUEST['txtMobile']);
		$BusinessType  	= stripslashes($_REQUEST['txtBusinessType']);
		$BusinessDetail = stripslashes($_REQUEST['txtBusinessDetail']);
		$CompanyName  	= stripslashes($_REQUEST['txtCompanyName']);
		$CompanyAddress = stripslashes($_REQUEST['txtCompanyAddress']);
		$CompanyPhone   = stripslashes($_REQUEST['txtCompanyPhone']);

		$Status   		= stripslashes($_REQUEST['cboStatus']);
		$Archived   	= stripslashes($_REQUEST['cboArchive']);

		/////////////// RIGHTS SECTION /////////////////////

		if(isset($_REQUEST['chkRights1']))  { $chkRights1 = 1; }  else{ $chkRights1 = 0; }
		if(isset($_REQUEST['chkRights2']))  { $chkRights2 = 1; }  else{ $chkRights2 = 0; }
		if(isset($_REQUEST['chkRights3']))  { $chkRights3 = 1; }  else{ $chkRights3 = 0; }
		if(isset($_REQUEST['chkRights4']))  { $chkRights4 = 1; }  else{ $chkRights4 = 0; }
		if(isset($_REQUEST['chkRights5']))  { $chkRights5 = 1; }  else{ $chkRights5 = 0; }
		if(isset($_REQUEST['chkRights6']))  { $chkRights6 = 1; }  else{ $chkRights6 = 0; }
		if(isset($_REQUEST['chkRights7']))  { $chkRights7 = 1; }  else{ $chkRights7 = 0; }
		if(isset($_REQUEST['chkRights8']))  { $chkRights8 = 1; }  else{ $chkRights8 = 0; }
		if(isset($_REQUEST['chkRights9']))  { $chkRights9 = 1; }  else{ $chkRights9 = 0; }
		if(isset($_REQUEST['chkRights10'])) { $chkRights10 = 1; } else{ $chkRights10 = 0; }

		if(isset($_POST['chkConference']))
		{
			$cust_conference = implode(",", $_POST['chkConference']);	
		}
		else
		{
			$cust_conference = 8;	
		}

		if(isset($_POST['chkMeeting']))
		{
			$cust_meeting = implode(",", $_POST['chkMeeting']);	
		}
		else
		{
			$cust_meeting = 12;	
		}

		if($Archived == 1)
		{
			$Status = 1;
			$SubQuery = $db->prepare("UPDATE subscriptions SET subarchived = ?, substatus = ? WHERE aid=?");
			$SubQuery->execute(array(1,1,$Aid));

			$SubQuery = $db->prepare("UPDATE submembers SET smarchived = ?, smstatus = ? WHERE aid=?");
			$SubQuery->execute(array(1,1,$Aid));
		}

		if(isset($_REQUEST['chkUnArchived']))
		{
			if($Archived == 0)
			{
				$Status   = 0;
				$SubQuery = $db->prepare("UPDATE subscriptions SET subarchived = ?, substatus = ? WHERE aid=?");
				$SubQuery->execute(array(0,0,$Aid));

				$SubQuery = $db->prepare("UPDATE submembers SET smarchived = ?, smstatus = ? WHERE aid=?");
				$SubQuery->execute(array(0,0,$Aid));
			}
			else
			{
				$Status = stripslashes($_REQUEST['cboStatus']);
			}
		}

		$Query = $db->prepare("UPDATE accounts SET aname=? , aemail=? , cnic=? , aaddress=? , acity=? , aphone=? , amobile=? , businesstype=? , businessdetail=? , aconame=? , acoaddress=? , acophone=? , astatus = ? , acarchived = ? WHERE aid=?");
		$values = array($Name , $Email , $Cnic , $Address , $City , $Phone , $Mobile , $BusinessType , $BusinessDetail , $CompanyName , $CompanyAddress , $CompanyPhone , $Status , $Archived , $Aid);
		
		//////////// Assign Rights ///////////////////
		$aquery = $db->prepare("SELECT * FROM arights WHERE aid=?");
		$aquery->execute(array($Aid));
		if($aquery->rowCount() == 0)
		{
			$arquery = $db->prepare("INSERT INTO arights(aid,membership,invoice,conference_booking,meeting_booking,update_profile,change_password,support,notification,amenities,amenity_report,conference_room, meeting_room) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?)");
			$arvalues = array($Aid,$chkRights1,$chkRights2,$chkRights3,$chkRights4,$chkRights5,$chkRights6,$chkRights7,$chkRights8,$chkRights9,$chkRights10,$cust_conference,$cust_meeting);
		}
		else
		{
			$arquery = $db->prepare("UPDATE arights SET membership=?,invoice=?,conference_booking=?,meeting_booking=?,update_profile=?,change_password=?,support=?,notification=?,amenities=?,amenity_report=?, conference_room=?, meeting_room=? WHERE aid=?");
			$arvalues = array($chkRights1,$chkRights2,$chkRights3,$chkRights4,$chkRights5,$chkRights6,$chkRights7,$chkRights8,$chkRights9,$chkRights10,$cust_conference,$cust_meeting,$Aid);
		}
		
		if($Query->execute($values) && $arquery->execute($arvalues))
		{			
			    ///////////////////// LOG SECTION /////////////////////
		    $log = "$Name ($Email) - Customer Account has been updated";
			log_entry($log);
		    ///////////////////////////////////////////////////////
		    header("Location: editcustomer.php?aid=$Aid&err=3");
			die; 
		}
	}
	function send_password($db,$URL,$Aid)
	{
		require("phpmailer/PHPMailerAutoload.php");
		$Date = time();

		/////////////// RIGHTS SECTION /////////////////////
		if(isset($_REQUEST['chkRights1'])) { $chkRights1 = 1; } else{ $chkRights1 = 0; }
		if(isset($_REQUEST['chkRights2'])) { $chkRights2 = 1; } else{ $chkRights2 = 0; }
		if(isset($_REQUEST['chkRights3'])) { $chkRights3 = 1; } else{ $chkRights3 = 0; }
		if(isset($_REQUEST['chkRights4'])) { $chkRights4 = 1; } else{ $chkRights4 = 0; }
		if(isset($_REQUEST['chkRights5'])) { $chkRights5 = 1; } else{ $chkRights5 = 0; }
		if(isset($_REQUEST['chkRights6'])) { $chkRights6 = 1; } else{ $chkRights6 = 0; }
		if(isset($_REQUEST['chkRights7'])) { $chkRights7 = 1; } else{ $chkRights7 = 0; }

		//////////// Assign Rights ///////////////////
		$aquery = $db->prepare("SELECT * FROM arights WHERE aid=?");
		$aquery->execute(array($Aid));
		if($aquery->rowCount() == 0)
		{
			$arquery = $db->prepare("INSERT INTO arights(aid,membership,invoice,conference_booking,meeting_booking,change_password,support,notification) VALUES(?,?,?,?,?,?,?,?)");
			$arvalues = array($Aid,$chkRights1,$chkRights2,$chkRights3,$chkRights4,$chkRights5,$chkRights6,$chkRights7);
		}
		else
		{
			$arquery = $db->prepare("UPDATE arights SET membership=?,invoice=?,conference_booking=?,meeting_booking=?,change_password=?,support=?,notification=? WHERE aid=?");
			$arvalues = array($chkRights1,$chkRights2,$chkRights3,$chkRights4,$chkRights5,$chkRights6,$chkRights7,$Aid);
		}

		$query = $db->prepare("SELECT * FROM accounts WHERE aid=?");
		$query->execute(array($Aid));
		while($row = $query->fetch())
		{
			$aid   = $row['aid'];
			$gtno  = $row['gtno'];	
			$name  = $row['aname'];
			$email = $row['aemail'];	
			
			$password = random_strings(10);

			$enpassword = md5($password);

			$uquery = $db->prepare("UPDATE accounts SET apassword=?, passdate=? WHERE aid=?");
			$uvalues = array($enpassword,$Date,$aid);

			$message = "Hi $name, <br> Your memebers portal account has been created on GITMIT CO-WORKING SPACE, Given below are the login details for your members portal account. <br><br>
						Link: <a href='https://www.gitmit.com/login'>https://www.gitmit.com/login</a><br>
						Username: $email<br>
						Password: $password<br><br> GITMIT CO-WORKING SPACE";
			if($uquery->execute($uvalues))
			{
				////////////////////////////////////////////////////////

				$mail = new PHPMailer;				   
				$mail->setFrom('no_reply@gitmit.com', 'GITMIT CO-WORKING SPACE');
				$mail->addAddress($email);            // Name is optional
				$mail->addBCC('mumtaz@lanwan.com.au');
				$mail->isHTML(true);                                   // Set email format to HTML

				$mail->Subject = "Members Portal Login Details";
				$mail->Body    = $message;
				$mail->AltBody = "This is the body in plain text for non-HTML mail clients";
			  	//$mail->send();

			  	///////////////////// LOG SECTION /////////////////////
			    $log = "$name ($email) - Customer Account Login Details Sent!";
				log_entry($log);
			    ///////////////////////////////////////////////////////
			  	header("Location: editcustomer.php?aid=$Aid&err=55");
				die; 
			}
		}
	}
	function reset_password($db,$URL,$Aid)
	{
		require("phpmailer/PHPMailerAutoload.php");
		$Date = time();

		/////////////// RIGHTS SECTION /////////////////////

		if(isset($_REQUEST['chkRights1'])) { $chkRights1 = 1; } else{ $chkRights1 = 0; }
		if(isset($_REQUEST['chkRights2'])) { $chkRights2 = 1; } else{ $chkRights2 = 0; }
		if(isset($_REQUEST['chkRights3'])) { $chkRights3 = 1; } else{ $chkRights3 = 0; }
		if(isset($_REQUEST['chkRights4'])) { $chkRights4 = 1; } else{ $chkRights4 = 0; }
		if(isset($_REQUEST['chkRights5'])) { $chkRights5 = 1; } else{ $chkRights5 = 0; }
		if(isset($_REQUEST['chkRights6'])) { $chkRights6 = 1; } else{ $chkRights6 = 0; }
		if(isset($_REQUEST['chkRights7'])) { $chkRights7 = 1; } else{ $chkRights7 = 0; }

		//////////// Assign Rights ///////////////////
		$aquery = $db->prepare("SELECT * FROM arights WHERE aid=?");
		$aquery->execute(array($Aid));
		if($aquery->rowCount() == 0)
		{
			$arquery = $db->prepare("INSERT INTO arights(aid,membership,invoice,conference_booking,meeting_booking,change_password,support,notification) VALUES(?,?,?,?,?,?,?,?)");
			$arvalues = array($Aid,$chkRights1,$chkRights2,$chkRights3,$chkRights4,$chkRights5,$chkRights6,$chkRights7);
		}
		else
		{
			$arquery = $db->prepare("UPDATE arights SET membership=?,invoice=?,conference_booking=?,meeting_booking=?,change_password=?,support=?,notification=? WHERE aid=?");
			$arvalues = array($chkRights1,$chkRights2,$chkRights3,$chkRights4,$chkRights5,$chkRights6,$chkRights7,$Aid);
		}

		$query = $db->prepare("SELECT * FROM accounts WHERE aid=?");
		$query->execute(array($Aid));
		while($row = $query->fetch())
		{
			$aid   = $row['aid'];
			$gtno  = $row['gtno'];	
			$name  = $row['aname'];
			$email = $row['aemail'];	
			
			$password = random_strings(10);

			$enpassword = md5($password);

			$uquery = $db->prepare("UPDATE accounts SET apassword=?, passdate=? WHERE aid=?");
			$uvalues = array($enpassword,$Date,$aid);

			$message = "Hi $name, <br> Your memebers portal account password has been reset by admin on GITMIT CO-WORKING SPACE, Given below are the login details for your members portal account. <br><br>
						Link: <a href='https://www.gitmit.com/login'>https://www.gitmit.com/login</a><br>
						Username: $email<br>
						Password: $password<br><br> GITMIT CO-WORKING SPACE";
			if($uquery->execute($uvalues))
			{
				////////////////////////////////////////////////////////

				$mail = new PHPMailer;				   
				$mail->setFrom('no_reply@gitmit.com', 'GITMIT CO-WORKING SPACE');
				$mail->addAddress($email);            // Name is optional
				$mail->addBCC('info@gitmit.com');
				$mail->isHTML(true);                                  	  // Set email format to HTML

				$mail->Subject = "Members Portal Password Reset";
				$mail->Body    = $message;
				$mail->AltBody = "This is the body in plain text for non-HTML mail clients";
			  	$mail->send();

			  	///////////////////// LOG SECTION /////////////////////
			    $log = "$name ($email) - Customer Account Password Rest!";
				log_entry($log);
			    ///////////////////////////////////////////////////////
			  	header("Location: editcustomer.php?aid=$Aid&err=59");
				die;
			}
		}
	}
	function delete_customer($Aid)
	{
		global $db;
		global $URL;

		$Query = $db->prepare("DELETE FROM accounts WHERE aid=?");
		$values = array($Aid);
		if($Query->execute($values))
		{
			///////////////////// LOG SECTION /////////////////////
		    $log = "Customer Account has been deleted";
			log_entry($log);
		    ///////////////////////////////////////////////////////
			header("Location: $URL/customers.php?err=4");
			die;
		}
	}

	/////////////   Update Additional Member //////////////////

	function update_submember($db,$URL,$smid)
	{
		include("sub_thumb.php");

		$Date     = time();
		$Num 	  = stripslashes($_REQUEST['cboNum']);
		$name 	  = stripslashes($_REQUEST['txtName']);
		$email    = stripslashes($_REQUEST['txtEmail']);
		$designation = stripslashes($_REQUEST['txtDesignation']);
		$nationality = stripslashes($_REQUEST['txtNationality']);
		$mobile 	 = stripslashes($_REQUEST['txtMobile']);
		$cnic 		 = stripslashes($_REQUEST['txtCnic']);		
		$dob 		 = $_REQUEST['txtDob'];
		$address  = $_REQUEST['txtAddress'];
		$testimonial  = $_REQUEST['txtTestimonial'];
		$Archive  = $_REQUEST['cboArchive'];
		$Status   = $_REQUEST['cboStatus'];		
		$hdnImage = stripslashes($_REQUEST['hdnImage']);

		if(isset($_REQUEST['chkShow'])) { $chkShow = 1; } else{ $chkShow = 0; }

		if($_REQUEST['hdnName'] == "0" && $_REQUEST['hdnEmail'] == "0" && $_REQUEST['hdnCnic'] == "0")
		{
			$image       = $_FILES['image']['name'];
			if($image != "")
	        {
	            if ($image) 
	            {
	                $filename  = stripslashes($_FILES['image']['name']);
	                $extension = getExtension($filename);
	                $extension = strtolower($extension);
	                if (($extension != "jpg") && ($extension != "jpeg") && ($extension != "png")) 
	                {
	                    $errors = 1;
	                }
	                else
	                {
	                    $size   = getimagesize($_FILES['image']['tmp_name']);
	                    $sizekb = filesize($_FILES['image']['tmp_name']);
	                    if ($sizekb > MAX_SIZE * 1024)
	                    {
	                        $errors = 1;
	                    }
	                    $A = rand(1000,1000000);
	                    $image_name = $A.'.'.$extension;
	                    $newname    = "../images/".$image_name;
	                    $copied     = copy($_FILES['image']['tmp_name'], $newname);
	                    if (!$copied) 
	                    {
	                        $errors = 1;
	                    }
	                    else
	                    {
	                        $thumb_name = "../images/members/images/".$image_name;
	                        $thumb      = make_thumb($newname,$thumb_name,WIDTH,HEIGHT);
	                       	unlink("../images/".$image_name."");
	                    }
	                }
	            }
	            $member_image = $image_name;
	            unlink("../images/members/images/".$hdnImage);
	        }
	        else
	        {
	            $member_image = $hdnImage;
	        }

			for ($i = 1; $i <= $Num; $i++)
			{
				$allowed =  array('pdf','jpg');

				$file_name   = "image$i";
				$File 	     = $_FILES[$file_name]['name'];		
				$TmpFile     = $_FILES[$file_name]['tmp_name'];

				$ext 	 	 = pathinfo($File, PATHINFO_EXTENSION);
				$rand 		 = rand();
				$newfilename = $rand."_".$i.".".$ext;
				$target_path = "../images/members/docs/";
				$target_path = $target_path . basename($newfilename);
				
				if($ext == "pdf" || $ext == "jpg")
				{
				    if(move_uploaded_file($TmpFile, $target_path))
					{
						$filequery = $db->prepare("INSERT INTO mfiles(smid,mfile,mfdate) VALUES(?,?,?)");
						$filevalues = array($smid,$newfilename,$Date);
						$filequery->execute($filevalues);
					}
				}
			}

	        $Query = $db->prepare("UPDATE submembers SET smname=? , smemail=? , smdesignation=?, smnationality=?, smmobile=? , smcnic=? , smdob=? , smaddress=? , smtestimonial=? , show_testimonial=? , smimage=?, smarchived=?, smstatus=? WHERE smid=?");
			$values = array($name,$email,$designation,$nationality,$mobile,$cnic,$dob,$address,$testimonial,$chkShow,$member_image,$Archive,$Status,$smid);
			if($Query->execute($values))
			{
				///////////////////// LOG SECTION /////////////////////
			    $log = "$name - Additional Member has been update";
				log_entry($log);
			    ///////////////////////////////////////////////////////
				header("Location: $URL/submembers.php?&err=3");
				die;
			}
		}
		else{
			header("Location: $URL/editsubmember.php?smid=$smid&err=45");
			die;
		}	
	}

	/////////////   Delete Additional Member //////////////////
	
	function delete_submember($db,$URL,$smid)
	{	
		$smQuery = $db->prepare("SELECT * FROM submembers WHERE smid = ?");
		$smQuery->execute(array($smid));
		while($row = $smQuery->fetch())
		{
			if($row['smimage'] != "")
			{
				unlink("../images/submembers/images/".$row['smimage']);
			}
		}

		$dQuery = $db->prepare("SELECT * FROM mfiles WHERE smid = ?");
		$dQuery->execute(array($smid));
		while($drow = $dQuery->fetch())
		{
			if($drow['mfile'] != "")
			{
				unlink("../images/submembers/docs/".$row['mfile']);
			}
		}
		$Query1 = $db->prepare("DELETE FROM submembers WHERE smid=?");
		$Query2 = $db->prepare("DELETE FROM mfiles WHERE smid=?");
		
		if($Query1->execute(array($smid)) && $Query2->execute(array($smid)))
		{
			///////////////////// LOG SECTION /////////////////////
		    $log = "Additional Member has been deleted";
			log_entry($log);
		    ///////////////////////////////////////////////////////
			header("Location: $URL/submembers.php?err=4");
		}
	}

	/////////////   Send Login Detail Additional Member //////////////////

	function send_smpassword($db,$URL,$Smid)
	{
		require("phpmailer/PHPMailerAutoload.php");
		$Date = time();

		$query = $db->prepare("SELECT * FROM submembers SM INNER JOIN accounts A ON SM.aid = A.aid WHERE SM.smid=?");
		$query->execute(array($Smid));
		while($row = $query->fetch())
		{
			$smid  = $row['smid'];
			$aid   = $row['aid'];
			$smgtno  = $row['smgtno'];	
			$name  = $row['smname'];
			$email = $row['smemail'];	

			$member_email = $row['aemail'];	
			
			$password = random_strings(10);

			$enpassword = md5($password);

			$uquery = $db->prepare("UPDATE submembers SET smpassword=?, smpassdate=? WHERE smid=?");
			$uvalues = array($enpassword,$Date,$smid);

			$message = "Hi $name, <br><br> Your additional memebers portal account has been created on GITMIT CO-WORKING SPACE, Given below are the login details for your additional members portal account. <br><br>
						Link: <a href='https://www.gitmit.com/login'>https://www.gitmit.com/login</a><br>
						Username: $email<br>
						Password: $password<br>
						Account Type: Additional Member<br><br> GITMIT CO-WORKING SPACE";
			
			if($uquery->execute($uvalues))
			{
				////////////////////////////////////////////////////////

				$mail = new PHPMailer;				   
				$mail->setFrom('no_reply@gitmit.com', 'GITMIT CO-WORKING SPACE');
				$mail->addAddress($email);            // Name is optional
				$mail->addBCC('mumtaz@lanwan.com.au');
				$mail->addBCC($member_email);
				$mail->isHTML(true);                                   // Set email format to HTML

				$mail->Subject = "Additional Members Portal Login Details";
				$mail->Body    = $message;
				$mail->AltBody = "This is the body in plain text for non-HTML mail clients";
			  	$mail->send();

			  	///////////////////// LOG SECTION /////////////////////
			    $log = "$name ($email) - Additional Member Account Login Details Sent!";
				log_entry($log);
			    ///////////////////////////////////////////////////////
			  	header("Location: editsubmember.php?smid=$Smid&err=61");
				die; 
			}
		}
	}
	function reset_smpassword($db,$URL,$Smid)
	{
		require("phpmailer/PHPMailerAutoload.php");
		$Date = time();

		$query = $db->prepare("SELECT * FROM submembers SM INNER JOIN accounts A ON SM.aid = A.aid WHERE SM.smid=?");
		$query->execute(array($Smid));
		while($row = $query->fetch())
		{
			$smid   = $row['smid'];
			$aid    = $row['aid'];
			$smgtno = $row['smgtno'];	
			$name   = $row['smname'];
			$email  = $row['smemail'];

			$member_email = $row['aemail'];		
			
			$password = random_strings(10);

			$enpassword = md5($password);

			$uquery = $db->prepare("UPDATE submembers SET smpassword=?, smpassdate=? WHERE smid=?");
			$uvalues = array($enpassword,$Date,$smid);

			$message = "Hi $name, <br> Your additional memebers portal account password has been reset on GITMIT CO-WORKING SPACE, Given below are the login details for your additional members portal account. <br><br>
						Link: <a href='https://www.gitmit.com/login'>https://www.gitmit.com/login</a><br>
						Username: $email<br>
						Password: $password<br>
						Type: Additional Member<br><br> GITMIT CO-WORKING SPACE";
						
			if($uquery->execute($uvalues))
			{
				////////////////////////////////////////////////////////

				$mail = new PHPMailer;				   
				$mail->setFrom('no_reply@gitmit.com', 'GITMIT CO-WORKING SPACE');
				$mail->addAddress($email);            // Name is optional
				$mail->addBCC('mumtaz@lanwan.com.au');
				$mail->addBCC($member_email);
				$mail->isHTML(true);                                   // Set email format to HTML

				$mail->Subject = "Additional Members Portal Password Reset Details";
				$mail->Body    = $message;
				$mail->AltBody = "This is the body in plain text for non-HTML mail clients";
			  	$mail->send();

			  	///////////////////// LOG SECTION /////////////////////
			    $log = "$name ($email) - Additional Member Account Login Details Sent!";
				log_entry($log);
			    ///////////////////////////////////////////////////////
			  	header("Location: editsubmember.php?smid=$Smid&err=61");
				die; 
			}
		}
	}

	/////////////////  Cash Receipt  ///////////////////////
	
	function add_cash_receipt($db,$URL)
	{
		$Date           = time();
		$Amount         = $_REQUEST['txtAmount'];
		$PayAcmid		= $_REQUEST['cboMainCategory'];
		$PayAccount     = $_REQUEST['cboAccount'];
		$ReceiveAccount = $_REQUEST['cboAccount1'];
		$Detail         = $_REQUEST['txtDetail'];

		/*
					Customer Account
			
					Debit		Credit		Balance
					35000		30000		  5000		1 sale total bill 35000 paid 30000 balance 5000
			    	15000				 	 20000		credit given to customer 50000 balance 55000
			----------------------------------------			
			Total	50000		30000		 20000
			----------------------------------------

			/////////////////////////////////////////////
			
					Cash Account
					
					Debit		Credit		Balance
					30000   	 	0		30000
							    15000		15000		
			---------------------------------------------		
			Total	30000		15000		15000
			---------------------------------------------
		*/

		/////////////// Pay Account //////////////
		chk_ledger($db,$URL,$PayAccount);
		$PayAcQuery = $db->prepare("SELECT * FROM ledger L INNER JOIN accounts A ON L.aid = A.aid WHERE L.aid = ? ORDER BY L.leid DESC LIMIT 0,1");
		$PayAcQuery->execute(array($PayAccount));
		while($PayAcRow = $PayAcQuery->fetch())
		{
		  $PayAccName      = $PayAcRow['aname'];
		  $OldPayAcBalance = $PayAcRow['balance'];
		}
		$CurrentPayAcBalance     = $OldPayAcBalance - $Amount;
		ledger_entry($PayAccount,$Detail,0,$Amount,$CurrentPayAcBalance,$Date);

		/////////////// Receive Account //////////////
		chk_ledger($db,$URL,$ReceiveAccount);
		$ReceiveAcQuery = $db->prepare("SELECT * FROM ledger L INNER JOIN accounts A ON L.aid = A.aid WHERE L.aid = ? ORDER BY L.leid DESC LIMIT 0,1");
		$ReceiveAcQuery->execute(array($ReceiveAccount));
		while($ReceiveAcRow = $ReceiveAcQuery->fetch())
		{
		  $ReceiveAccName      = $ReceiveAcRow['aname'];
		  $OldReceiveAcBalance = $ReceiveAcRow['balance'];
		}
		$CurrentReceiveAcBalance = $Amount + $OldReceiveAcBalance;
		ledger_entry($ReceiveAccount,$Detail,$Amount,0,$CurrentReceiveAcBalance,$Date);

		///////////////////// LOG SECTION /////////////////////
	    $log = "Cash Receipt Entry - From: $PayAccName | To: $ReceiveAccName Amount: ".number_format($Amount)."";
		log_entry($log);
	    ///////////////////////////////////////////////////////
		header("Location: $URL/cash_receipt.php?err=2&date=$Date");
	}
	///////////////////////////////////////////////////////
	/////////////////  Cash Payment  //////////////////////
	function add_cash_payment($db,$URL)
	{
		$Date           = time();
		$Amount         = $_REQUEST['txtAmount'];
		$PayAccount     = $_REQUEST['cboAccount'];
		$ReceiveAccount = $_REQUEST['cboAccount1'];
		$Detail         = $_REQUEST['txtDetail'];

		/*
					Customer Account
			
					Debit		Credit		Balance
					35000		30000		  5000		1 sale total bill 35000 paid 30000 balance 5000
			    	15000				 	 20000		credit given to customer 50000 balance 55000
			----------------------------------------			
			Total	50000		30000		 20000
			----------------------------------------

			/////////////////////////////////////////////
			
					Cash Account
					
					Debit		Credit		Balance
					30000   	 	0		30000
							    15000		15000		
			---------------------------------------------		
			Total	30000		15000		15000
			---------------------------------------------
		*/

		/////////////// Pay Account //////////////
		chk_ledger($db,$URL,$PayAccount);
		$PayAcQuery = $db->prepare("SELECT * FROM ledger L INNER JOIN accounts A ON L.aid = A.aid WHERE L.aid = ? ORDER BY L.leid DESC LIMIT 0,1");
		$PayAcQuery->execute(array($PayAccount));
		while($PayAcRow = $PayAcQuery->fetch())
		{
		  $PayAccName      = $PayAcRow['aname'];
		  $OldPayAcBalance = $PayAcRow['balance'];
		}
		$CurrentPayAcBalance     = $OldPayAcBalance - $Amount;
		ledger_entry($PayAccount,$Detail,0,$Amount,$CurrentPayAcBalance,$Date);

		/////////////// Receive Account //////////////
		chk_ledger($db,$URL,$ReceiveAccount);
		$ReceiveAcQuery = $db->prepare("SELECT * FROM ledger L INNER JOIN accounts A ON L.aid = A.aid WHERE L.aid = ? ORDER BY L.leid DESC LIMIT 0,1");
		$ReceiveAcQuery->execute(array($ReceiveAccount));
		while($ReceiveAcRow = $ReceiveAcQuery->fetch())
		{
		  $ReceiveAccName      = $ReceiveAcRow['aname'];
		  $OldReceiveAcBalance = $ReceiveAcRow['balance'];
		}
		$CurrentReceiveAcBalance = $Amount + $OldReceiveAcBalance;
		ledger_entry($ReceiveAccount,$Detail,$Amount,0,$CurrentReceiveAcBalance,$Date);

		///////////////////// LOG SECTION /////////////////////
	    $log = "Cash Payment Entry - From: $PayAccName | To: $ReceiveAccName Amount: ".number_format($Amount)."";
		log_entry($log);
	    ///////////////////////////////////////////////////////
		header("Location: $URL/cash_payment.php?err=2&date=$Date");		
	}
	///////////////////////////////////////////////////////
	/////////////////  Single Ledger Entry  //////////////////////
	function single_ledger_entry($db,$URL)
	{
		$Date   = time();
		$Amount = $_REQUEST['txtAmount'];
		$Aid    = $_REQUEST['cboAccount'];
		$Type 	= $_REQUEST['cboType'];
		$Detail = $_REQUEST['txtDetail'];

		/*
					Customer Account
			
					Debit		Credit		Balance
					35000		30000		  5000		1 sale total bill 35000 paid 30000 balance 5000
			    	15000				 	 20000		credit given to customer 50000 balance 55000
			----------------------------------------			
			Total	50000		30000		 20000
			----------------------------------------

			/////////////////////////////////////////////
			
					Cash Account
					
					Debit		Credit		Balance
					30000   	 	0		30000
							    15000		15000		
			---------------------------------------------		
			Total	30000		15000		15000
			---------------------------------------------
		*/

		/////////////// Account //////////////
		
		$acquery = $db->prepare("SELECT * FROM ledger WHERE aid = ? ORDER BY leid DESC LIMIT 0,1");
		$acquery->execute(array($Aid));
		if($acquery->rowCount() == 0)
		{
			$OldBalance = 0;
		}
		else
		{
			while($acrow = $acquery->fetch())
			{
				$OldBalance = $acrow['balance'];
			}
		}

		if($Type == 0) // Debit (It Will add amount)
		{
			$LedgerAmount = $OldBalance + $Amount;
			ledger_entry($Aid,$Detail,$Amount,0,$LedgerAmount,$Date);
		}
		else
		{
			$LedgerAmount = $OldBalance - $Amount;
			ledger_entry($Aid,$Detail,0,$Amount,$LedgerAmount,$Date);
		}	
	
		///////////////////// LOG SECTION /////////////////////
	    $log = "Ledger Single Entry Amount: ".number_format($Amount)."";
		log_entry($log);
	    ///////////////////////////////////////////////////////
		header("Location: $URL/ledger_entry.php?err=2&date=$Date");		
	}

	///////////////////////////////////////////////////////
	////////////////// Purchase ///////////////////////////

	function add_purchase($db,$URL)
	{
		$Date  = time();
		if(isset($_SESSION['user']))
    	{
    		$Uid = $_SESSION['user'];
    	}
    	else
    	{
    		$Uid = $_COOKIE['user'];
    	}
		$Lid = 1;
		$CrAid = $_REQUEST['cboCredit'];
		$VeAid = $_REQUEST['cboAccount'];
		
		$Remarks   		= $_REQUEST['txtRemarks'];
		$GrandTotalCost = $_REQUEST['txtGrandTotalCost'] - $_REQUEST['txtDiscount'];
		$Discount 	 	= $_REQUEST['txtDiscount'];
		$Paid 	 		= $_REQUEST['txtPaid'];
		$Balance 		= $_REQUEST['txtBalance'];
		
		$Query = $db->prepare("INSERT INTO purchase(uid , aid , lid , purremarks , purtotal, purdiscount, purpaid, purbalance , purstatus , purdate) VALUES(?,?,?,?,?,?,?,?,?,?)");
		$Values = array($Uid,$VeAid,$Lid,$Remarks,$GrandTotalCost,$Discount,$Paid,$Balance,0,$Date);
		if($Query->execute($Values))
		{
			$Purid = $db->lastInsertId();
			for ($i = 1; $i <= $_REQUEST['cboNum']; $i++)
			{
				$Raw_id		 = explode(",",$_REQUEST["cboRawMaterial$i"]);
				$Rmid = $Raw_id[0];
				$Rid = $Raw_id[1];
				$Qty	 	 = "txtQty$i";
				$UnitCost 	 = "txtUnitCost$i";
				$TotalCost 	 = "txtTotalCost$i";
				
				/// Add Product Batch Entry ///
				$pbquery = $db->prepare("SELECT * FROM pbatch WHERE rid = ? ORDER BY pbid DESC LIMIT 0,1");
				$pbquery->execute(array($Rid));
				if($pbquery->rowCount() > 0)
				{
					while($pbrow = $pbquery->fetch())
					{
						$pbatchno = $pbrow['pbatchno'];
					}
					$BatchNo = $pbatchno + 1;
				}
				else
				{
					$BatchNo = 1;
				}

				$PBatchQuery = $db->prepare("INSERT INTO pbatch(lid , rid , purid , purprice , pbatchno , pbstock , pbleft , pbdate) VALUES(?,?,?,?,?,?,?,?)");
				$PBatchValues = array(1,$Rid,$Purid,$_REQUEST[$UnitCost],$BatchNo,$_REQUEST[$Qty],$_REQUEST[$Qty],$Date);

				$PurDetailQuery = $db->prepare("INSERT INTO purchasedetail(purid , aid , lid , rmid , rid , purqty , unitcost , totalcost , purdate) VALUES(?,?,?,?,?,?,?,?,?)");
				$PurDetailValues = array($Purid , $VeAid , $Lid , $Rmid , $Rid , $_REQUEST[$Qty] , $_REQUEST[$UnitCost] , $_REQUEST[$TotalCost] , $Date);
				
				if(!$PurDetailQuery->execute($PurDetailValues))
				{
					echo "\nPDO::errorInfo():\n";
					print_r($db->errorInfo());die;
				}
				if(!$PBatchQuery->execute($PBatchValues))
				{
					echo "\nPDO::errorInfo():\n";
					print_r($PBatchQuery->errorInfo());die;
				}

				$RawQuery = $db->prepare("SELECT * FROM rawlocation WHERE lid = ? AND rid = ?");
				$RawQuery->execute(array($Lid,$Rid));
				
				$NumLocationRaw = $RawQuery->rowCount();
				if($NumLocationRaw == 0)
				{
					$rawlocationquery = $db->prepare("INSERT INTO rawlocation(lid , rid , qty) VALUES(? , ? , ?)");
					$rawlocationvalues = array($Lid , $Rid , $_REQUEST[$Qty]);
				}
				else
				{
					while($Rawrow = $RawQuery->fetch())
					{
						$OldQty = $Rawrow['qty'];
					}
					$NewQty = $OldQty + $_REQUEST[$Qty];
					$rawlocationquery = $db->prepare("UPDATE rawlocation SET qty = ? WHERE lid = ? AND rid = ?");
					$rawlocationvalues = array($NewQty , $Lid , $Rid);
				}
				$rawlocationquery->execute($rawlocationvalues);
			}
			
			//////////// Vendor Ledger Entry ///////////////////
			chk_ledger($db,$URL,$VeAid);
			$VeQuery = $db->prepare("SELECT * FROM ledger L INNER JOIN accounts A ON L.aid = A.aid WHERE L.aid = ? ORDER BY L.leid DESC LIMIT 0,1");
			$VeQuery->execute(array($VeAid));
			while($VeRow = $VeQuery->fetch())
			{
			  $VendorName  = $VeRow['aname'];
			  $VendorEmail = $VeRow['aemail'];
			  $OldVendorBalance = $VeRow['balance'];
			}
			$Detail = "Purchase Invoice # $Purid Created for $VendorName ($VendorEmail)";		
			$VeDebit = $Paid;
			$VeCredit = $_REQUEST['txtGrandTotalCost'];
			$VeBalance = $Paid - $GrandTotalCost + $OldVendorBalance;
			ledger_entry($VeAid,$Detail,$VeDebit,$VeCredit,$VeBalance,$Date);

			//////////// Credit Ledger Entry ///////////////////
			chk_ledger($db,$URL,$CrAid);
			$CrQuery = $db->prepare("SELECT * FROM ledger L INNER JOIN accounts A ON L.aid = A.aid WHERE L.aid = ? ORDER BY L.leid DESC LIMIT 0,1");
			$CrQuery->execute(array($CrAid));
			while($CrRow = $CrQuery->fetch())
			{
			  $CreditName  = $CrRow['aname'];
			  $CreditEmail = $CrRow['aemail'];
			  $OldCreditBalance = $CrRow['balance'];
			}		
			$CrDebit = 0;
			$CrCredit = $Paid;
			$CrBalance = $OldCreditBalance - $Paid;
			ledger_entry($CrAid,$Detail,$CrDebit,$CrCredit,$CrBalance,$Date);

			///////////////////// LOG SECTION /////////////////////
		    $log = "Purchase Invoice # $Purid Created for $VendorName ($VendorEmail)";
			log_entry($log);
		    ///////////////////////////////////////////////////////
			header("Location: purchase.php?err=2");
		}
		else
		{
			echo "\nPDO::errorInfo():\n";
			print_r($Query->errorInfo());die;
		}
	}
	function delete_purchase($db,$URL,$Purid)
	{
	    $purquery = $db->prepare("SELECT * FROM purchasedetail WHERE purid=?");
		$purquery->execute(array($Purid));
		while($purrow = $purquery->fetch())
		{
			$rid = $purrow['rid'];
			$purqty = $purrow['purqty'];

			$update_stock = $db->prepare("UPDATE rawlocation SET qty = qty - ? WHERE rid=?");
			$update_stock->execute(array($purqty,$rid));
		}
		$Query1 = $db->prepare("DELETE FROM purchase WHERE purid=?");
		$Query2 = $db->prepare("DELETE FROM purchasedetail WHERE purid=?");
		$Query3 = $db->prepare("DELETE FROM pbatch WHERE purid=?");
		
		if($Query1->execute(array($Purid)) && $Query2->execute(array($Purid)) && $Query3->execute(array($Purid)))
		{
			header("Location: purchase.php?err=4");
		}
	}
	function add_tmp_purchase($db,$URL,$pdate)
	{
		$query = $db->prepare("SELECT prodid,proid,pid,szid,proqty,prodate FROM prodetail WHERE prodate=?");
		$query->execute(array($_REQUEST['pdate']));
		while($row = $query->fetch())
		{
			$prodid 	 = $row['prodid'];
			$pid 	 = $row['pid'];
			$szid 	 = $row['szid'];
			$proqty   = $row['proqty'];

			$szquery = $db->prepare("SELECT * FROM product_sizes WHERE szid=?");
			$szquery->execute(array($szid));
			while($szrow = $szquery->fetch())
			{
				$reid = $szrow['reid'];
			}

			$requery = $db->prepare("SELECT * FROM recipedetail RE INNER JOIN rawmaterials RAW ON RE.rid = RAW.rid WHERE RE.reid = ? ORDER BY redid ASC");
			$requery->execute(array($reid));
			while($rerow = $requery->fetch())
			{
				$rmid = $rerow['rmid'];
				$rid = $rerow['rid'];
				$rname = $rerow['rname'];
				$unit_qty = $rerow['reqty'];
				$total_qty = $proqty * $unit_qty;
				
				//echo($prodid." / ".$proqty." / ".$total_qty);die;

				$tpurquery = $db->prepare("SELECT * FROM tmp_purchase WHERE rid=? AND tpurdate=?");
				$tpurquery->execute(array($rid,$pdate));
				if($tpurquery->rowCount() == 0)
				{
					$pur_query = $db->prepare("INSERT INTO tmp_purchase(rmid,rid,purqty,tpurdate) VALUES(?,?,?,?)");
					$pur_values = array($rmid,$rid,$total_qty,$pdate);
				}else{
					$pur_query = $db->prepare("UPDATE tmp_purchase SET purqty = purqty + ? WHERE  rid=? AND tpurdate=?");
					$pur_values = array($total_qty,$rid,$pdate);
				}
				$pur_query->execute($pur_values);
			}
		}	
	}
	//////////////////////  Work Order  ////////////////////////////
	function add_procurement($db,$URL,$pdate)
	{
		$Date = time();
		$Title = $_REQUEST['txtTitle'];	
		
		$Query = $db->prepare("UPDATE procurement SET protitle=? WHERE prodate=?");
		$Values = array($Title,$pdate);
		if($Query->execute($Values))
		{
			///////////////////// LOG SECTION /////////////////////
		    //$log = "Procurement # $Woid Updated";
			//log_entry($log);
		    ///////////////////////////////////////////////////////
			header("Location: addprocurement.php?pdate=$pdate&err=3");
		}
		else
		{
			echo "\nPDO::errorInfo():\n";
			print_r($Query->errorInfo());die;
		}
	}

	function add_workorder($db,$URL)
	{
		$Date = time();
		$Uid = 1;
		$Lid  = 1;
		if(isset($_POST['cboStaff'])) {$Aid = implode(",", $_POST['cboStaff']); } else{$Aid = "";}
		$Remarks = $_REQUEST['txtRemarks'];	
		$StartDate = strtotime(str_replace("/", "-", $_REQUEST['txtStartDate']));

		if($_REQUEST['txtCompleteDate'] != "") { $CompleteDate = strtotime(str_replace("/", "-", $_REQUEST['txtCompleteDate'])); } else{ $CompleteDate = 0; }
		
		$Query = $db->prepare("INSERT INTO workorder(aid , lid , uid , woremarks , startdate, completedate , wostatus , wodate) VALUES(?,?,?,?,?,?,?,?)");
		$Values = array($Aid,$Lid,$Uid,$Remarks,$StartDate,$CompleteDate,0,$Date);
		if($Query->execute($Values))
		{

			$Woid = $db->lastInsertId();
			for ($i = 0; $i < count($_REQUEST['cboProducts']); $i++)
			{
				if (isset($_REQUEST['cboProducts'][$i]) && $_REQUEST['cboProducts'][$i] > 0)
				{
					$ii = $i + 1;
					$txtQty = "txtQty".$ii;
					$hdnPid = "hdnPid".$ii;
					$hdnSzid = "hdnSzid".$ii;
					for ($j = 0; $j < count($_REQUEST[$txtQty]); $j++)
					{
						if (isset($_REQUEST[$txtQty][$j]) && $_REQUEST[$txtQty][$j] > 0)
						{
							//echo($j.". ".$_REQUEST[$hdnPid][$j].", ".$_REQUEST[$hdnSzid][$j].", ".$_REQUEST[$txtQty][$j]);
							//echo("<br>");
							$sizeqty = $_REQUEST[$txtQty][$j];
							$WoDetailQuery = $db->prepare("INSERT INTO workorderdetail(woid , aid , lid , uid , pid , szid , woqty , wostartdate) VALUES(?,?,?,?,?,?,?,?)");
							$WoDetailValues = array($Woid , $Aid , $Lid , $Uid , $_REQUEST[$hdnPid][$j] , $_REQUEST[$hdnSzid][$j] , $_REQUEST[$txtQty][$j] , $StartDate);
							
							if($WoDetailQuery->execute($WoDetailValues))
							{
								$Wodid = $db->lastInsertId();
								$wdquery = $db->prepare("SELECT wodid,pid,szid FROM workorderdetail WHERE wodid=?");
								$wdquery->execute(array($Wodid));
								while($wdrow = $wdquery->fetch())
								{
									$pid = $wdrow['pid'];
									$szid = $wdrow['szid'];
								}

								///// Generate Barcodes /////
								for ($k = 1; $k <= $sizeqty; $k++)
								{
									$psquery = $db->prepare("SELECT * FROM product_sizes PS INNER JOIN products P ON PS.pid = P.pid WHERE PS.szid = ?");
									$psquery->execute(array($szid));
									while($psrow = $psquery->fetch())
									{
										$barcode_counter = $psrow['barcode_counter'];
										$barcode = $psrow['pid'].$psrow['size'].$barcode_counter;
									}
									$barquery = $db->prepare("INSERT INTO product_barcodes(uid,lid,pid,szid,woid,wodid,barcode,bcdate) VALUES(?,?,?,?,?,?,?,?)");
									$barvalues = array($Uid,$Lid,$pid,$szid,$Woid,$Wodid,$barcode,$Date);
									if($barquery->execute($barvalues))
									{
										$upsquery = $db->prepare("UPDATE product_sizes SET barcode_counter = barcode_counter + ? WHERE szid=?");
										$upsquery->execute(array(1,$szid));
									}
								}	
							}
							else{
								echo "\nPDO::errorInfo():\n";
								print_r($WoDetailQuery->errorInfo());die;
							}

							// ///// Transfer Raw Material to in progress /////
							$sizequery = $db->prepare("SELECT * FROM product_sizes WHERE szid=?");
							$sizequery->execute(array($_REQUEST[$hdnSzid][$j]));
							while($sizerow = $sizequery->fetch())
							{
								$reid = $sizerow['reid'];
							}

							$resquery = $db->prepare("SELECT * FROM recipedetail WHERE reid = ? ORDER BY redid ASC");
							$resquery->execute(array($reid));
							while($resrow = $resquery->fetch())
							{
								$rid 	= $resrow['rid'];
								$resqty = $resrow['reqty'];
								
								$rawqty = $resqty * $_REQUEST[$txtQty][$j];

								$rlquery = $db->prepare("UPDATE rawlocation SET qty = qty - ?, inprog_qty = inprog_qty + ? WHERE lid = ? AND rid = ?");
								$rlvalues = array($rawqty,$rawqty,$Lid,$rid);
								if(!$rlquery->execute($rlvalues))
								{
									echo "\nPDO::errorInfo():\n";
									print_r($rlquery->errorInfo());die;
								}
							}

							// ///// Transfer Stock Location to in progress /////

							$sl_query = $db->prepare("SELECT * FROM stocklocation WHERE lid = ? AND pid = ? AND szid = ?");
							$sl_query->execute(array($Lid,$_REQUEST[$hdnPid][$j],$_REQUEST[$hdnSzid][$j]));
							if($sl_query->rowCount() == 0)
							{
								$slquery = $db->prepare("INSERT INTO stocklocation(lid, pid, szid, slinprog_qty) VALUES(?,?,?,?)");
								$slvalues = array($Lid,$_REQUEST[$hdnPid][$j],$_REQUEST[$hdnSzid][$j],$_REQUEST[$txtQty][$j]);
								if(!$slquery->execute($slvalues))
								{
									echo "\nPDO::errorInfo():\n";
									print_r($slquery->errorInfo());die;
								}
							}
							else
							{
								$uslquery = $db->prepare("UPDATE stocklocation SET slinprog_qty = slinprog_qty + ? WHERE lid = ? AND pid = ? AND szid = ?");
								$uslvalues = array($_REQUEST[$txtQty][$j],$Lid,$_REQUEST[$hdnPid][$j],$_REQUEST[$hdnSzid][$j]);
								if(!$uslquery->execute($uslvalues))
								{
									echo "\nPDO::errorInfo():\n";
									print_r($uslquery->errorInfo());die;
								}		
							}
						}
							
					}

				}		

			}

			///////////////////// LOG SECTION /////////////////////
		    $log = "Work Order # $Woid Created";
			log_entry($log);
		    ///////////////////////////////////////////////////////
		
			header("Location: workorders.php?err=2");
		}
		else
		{
			echo "\nPDO::errorInfo():\n";
			print_r($Query->errorInfo());die;
		}
	}

	function update_workorder($db,$URL,$woid)
	{
		$Date 		   = time();
		$Uid 		   = 1;
		$Lid  	 	   = 1;
		$Remarks 	   = $_REQUEST['txtRemarks'];	
		$hdnWorkDetail = $_REQUEST['hdnWorkDetail'];	
		$Status 	   = $_REQUEST['cboStatus'];

		if($_REQUEST['txtCompleteDate'] != "") { $CompleteDate = strtotime(str_replace("/", "-", $_REQUEST['txtCompleteDate'])); } else{ $CompleteDate = 0; }
				
		$Query = $db->prepare("UPDATE workorder SET woremarks=?, completedate=?, wostatus=? WHERE woid=?");
		$Values = array($Remarks,$CompleteDate,$Status,$woid);
		if($Query->execute($Values))
		{
			///////////////////// LOG SECTION /////////////////////
		    $log = "Work Order # $Woid Updated";
			log_entry($log);
		    ///////////////////////////////////////////////////////
			header("Location: workorders.php?err=3");
		}
		else
		{
			echo "\nPDO::errorInfo():\n";
			print_r($Query->errorInfo());die;
		}
	}

	function delete_workorder($db,$URL,$woid)
	{
		$woquery = $db->prepare("SELECT * FROM workorderdetail WHERE woid = ?");
		$woquery->execute(array($woid));
		while($worow = $woquery->fetch())
		{
			$lid = 1;
			$pid = $worow['pid'];
			$szid = $worow['szid'];
			$qty = $worow['woqty'];
		
			///// Transfer Raw Material from in progress to instock /////
			$sizequery = $db->prepare("SELECT * FROM product_sizes WHERE szid=?");
			$sizequery->execute(array($szid));
			while($sizerow = $sizequery->fetch())
			{
				$reid = $sizerow['reid'];
			}
            
			$resquery = $db->prepare("SELECT * FROM recipedetail WHERE reid = ? ORDER BY redid ASC");
			$resquery->execute(array($reid));
			while($resrow = $resquery->fetch())
			{
			    
				$rid 	= $resrow['rid'];
				$resqty = $resrow['reqty'];
				
				$rawqty = $resqty * $qty;
                
                //echo($rawqty.",".$rawqty.",".$lid.",".$rid);die;
                
				$rlquery = $db->prepare("UPDATE rawlocation SET qty = qty + ?, inprog_qty = inprog_qty - ? WHERE lid = ? AND rid = ?");
				$rlvalues = array($rawqty,$rawqty,$lid,$rid);
				if(!$rlquery->execute($rlvalues))
				{
					echo "\nPDO::errorInfo():\n";
					print_r($rlquery->errorInfo());die;
				}
			}
			//echo("RAZA");die;
			$uslquery = $db->prepare("UPDATE stocklocation SET slinprog_qty = slinprog_qty - ? WHERE lid = ? AND pid = ? AND szid = ?");
			$uslvalues = array($qty,$lid,$pid,$szid);
			if(!$uslquery->execute($uslvalues))
			{
				echo "\nPDO::errorInfo():\n";
				print_r($uslquery->errorInfo());die;
			}
		}
		$query1 = $db->prepare("DELETE FROM workorder WHERE woid=?");
		$query2 = $db->prepare("DELETE FROM workorderdetail WHERE woid=?");
		$query3 = $db->prepare("DELETE FROM product_barcodes WHERE woid=?");
		
		if($query1->execute(array($woid)) && $query2->execute(array($woid)) && $query3->execute(array($woid)))
		{
			///////////////////// LOG SECTION /////////////////////
		    $log = "Work Order # $woid has been Deleted";
			log_entry($log);
		    ///////////////////////////////////////////////////////
		
			header("Location: workorders.php?err=4");	
		}
	}

	function submit_barcode($db,$URL,$pid,$szid,$woid,$wodid)
	{
	    
		$Date 	 = time();
		$Uid 	 = 1;
		$Lid  	 = 1;
		$barcode = trim($_REQUEST['txtBarCode']);
		$type 	 = $_REQUEST['rdoType'];	

		$bcquery = $db->prepare("SELECT bcid,barcode FROM product_barcodes WHERE barcode=? AND bcstatus=?");
		$bcquery->execute(array($barcode,0));
		if($bcquery->rowCount() == 0)
		{
			header("Location: barcodes_workorder.php?pid=$pid&szid=$szid&woid=$woid&wodid=$wodid&err=19");	
			die;
		}
		else
		{
		    
			while($bcrow = $bcquery->fetch())
			{
				$bcid = $bcrow['bcid'];	
			}
			
			///// Subtract Raw Material from in progress /////
			$sizequery = $db->prepare("SELECT * FROM product_sizes WHERE szid=?");
			$sizequery->execute(array($szid));
			while($sizerow = $sizequery->fetch())
			{
				$reid = $sizerow['reid'];
			}
            //echo($reid."/".$szid);die;
			$requery = $db->prepare("SELECT * FROM recipedetail WHERE reid = ? ORDER BY redid ASC");
			$requery->execute(array($reid));
			while($rerow = $requery->fetch())
			{
			    
				$rid 	= $rerow['rid'];
				$reqty = $rerow['reqty'];
				
				$rlquery = $db->prepare("UPDATE rawlocation SET inprog_qty = inprog_qty - ? WHERE lid = ? AND rid = ?");
				$rlvalues = array($reqty,$Lid,$rid);
				if(!$rlquery->execute($rlvalues))
				{
					echo "\nPDO::errorInfo():\n";
					print_r($rlquery->errorInfo());die;
				}

				////////////////// Batch Qty ///////////////////
				$pbquery = $db->prepare("SELECT * FROM pbatch WHERE lid = ? AND rid = ? AND pbstock > pbconsumed ORDER BY pbid ASC LIMIT 0,1");
				$pbquery->execute(array($Lid,$rid));
				if($pbquery->rowCount() > 0)
				{
				    
					while($pbrow = $pbquery->fetch())
					{
						$pbid = $pbrow['pbid'];
						$purprice = $pbrow['purprice'];
						$purtotalprice[] = $pbrow['purprice'] * $reqty;
						$pbstock = $pbrow['pbstock'];
						$pbconsumed = $pbrow['pbconsumed'];
						$pbleft = $pbrow['pbleft'];
					}

					if($reqty <= $pbleft)
					{
						$upbquery = $db->prepare("UPDATE pbatch SET pbconsumed = pbconsumed + ? , pbleft = pbleft - ? WHERE pbid = ?");
						$upbvalues = array($reqty, $reqty, $pbid);
						if(!$upbquery->execute($upbvalues))
						{
							echo "\nPDO::errorInfo():\n";
							print_r($upbquery->errorInfo());die;
						}
					}
					else
					{
						///// If the current batch has less products then recipe qty then it will take the qty from current batch and the rest from the next batch /////
						$upbquery1 = $db->prepare("UPDATE pbatch SET pbconsumed = ? , pbleft = ? WHERE pbid = ?");
						$upbvalues1 = array($pbstock,0,$pbid);
						if(!$upbquery1->execute($upbvalues1))
						{
							echo "\nPDO::errorInfo():\n";
							print_r($upbquery1->errorInfo());die;
						}

						///// Now we'll subtract rest of the qty from the next batch /////
						$pbquery1 = $db->prepare("SELECT * FROM pbatch WHERE rid = ? AND lid = ? AND pbid > ? LIMIT 0,1");
						$pbquery1->execute(array($rid,$Lid,$pbid));
						if($pbquery1->rowCount() > 0)
						{
							while($pbrow1 = $pbquery1->fetch())
							{
								$pbid1 		 = $pbrow1['pbid'];
							}

							$current_qty = $reqty - $pbleft;
							$upbquery2 = $db->prepare("UPDATE pbatch SET pbconsumed = pbconsumed + ? , pbleft = pbleft - ? WHERE pbid = ?");
							$upbvalues2 = array($current_qty,$current_qty,$pbid1);
							if(!$upbquery2->execute($upbvalues2))
							{
								echo "\nPDO::errorInfo():\n";
								print_r($upbquery2->errorInfo());die;
							}
						}
					}
				} // Batch Calculation Completed
				
				if(isset($purtotalprice)){
					$unit_cost_price = array_sum($purtotalprice);	
				}else{
					$unit_cost_price = 0;
				}
				
				//echo("$type,$unit_cost_price,1,time,$bcid");
				
				$update_bcquery = $db->prepare("UPDATE product_barcodes SET bctype = ?, cost_price = ?, bcstatus = ?, entry_date = ? WHERE bcid=?");
				$update_values = array($type,$unit_cost_price,1,time(),$bcid);
				if($update_bcquery->execute($update_values))
				{
				    ///// Transfer Stock Location from on progress to complete /////
        			$wod_query = $db->prepare("SELECT * FROM workorderdetail WHERE woid =? AND szid=?");
        			$wod_query->execute(array($woid,$szid));
        			while($wod_row = $wod_query->fetch())
        			{
        				$wo_qty = $wod_row['woqty'];
        				$wo_comqty = $wod_row['comqty'];
        			}	
        			if($wo_qty > $wo_comqty)
        			{
        				$wodquery = $db->prepare("UPDATE workorderdetail SET comqty = comqty + 1 WHERE woid = ? AND wodid = ? AND szid = ?");
        				$wodquery->execute(array($woid,$wodid,$szid));
        
        				$uslquery = $db->prepare("UPDATE stocklocation SET slqty = slqty + ?, slinprog_qty = slinprog_qty - ? WHERE lid = ? AND pid = ? AND szid = ?");
        				$uslvalues = array(1,1,$Lid,$pid,$szid);
        				if(!$uslquery->execute($uslvalues))
        				{
        					echo "\nPDO::errorInfo():\n";
        					print_r($uslquery->errorInfo());die;
        				}	
        			}
				}
				else{
				    
					echo "\nPDO::errorInfo():\n";
					print_r($update_bcquery->errorInfo());die;
				}
			}// Recipe Query End

			

			///////////////////// LOG SECTION /////////////////////
		    $log = "Barcode created successfully";
			log_entry($log);
		    ///////////////////////////////////////////////////////
			header("Location: barcodes_workorder.php?pid=$pid&szid=$szid&woid=$woid&wodid=$wodid&err=3");
		}
	}
	
	function cancel_item($db,$URL,$barcode,$pid,$szid,$woid,$wodid)
	{
		$bcquery = $db->prepare("SELECT bcid,barcode FROM product_barcodes WHERE barcode=? AND bcstatus=?");
		$bcquery->execute(array($barcode,0));
		if($bcquery->rowCount() == 0)
		{
			header("Location: barcodes_workorder.php?pid=$pid&szid=$szid&woid=$woid&wodid=$wodid&err=19");	
			die;
		}
		else
		{

			while($bcrow = $bcquery->fetch())
			{
				$bcid = $bcrow['bcid'];	
			}
			
			///// Return Raw Material from in progress to Instock /////
			$sizequery = $db->prepare("SELECT * FROM product_sizes WHERE szid=?");
			$sizequery->execute(array($szid));
			while($sizerow = $sizequery->fetch())
			{
				$reid = $sizerow['reid'];
			}

		
			$requery = $db->prepare("SELECT * FROM recipedetail WHERE reid = ? ORDER BY redid ASC");
			$requery->execute(array($reid));
			while($rerow = $requery->fetch())
			{
				$rid 	= $rerow['rid'];
				$reqty = $rerow['reqty'];
				
				$rlquery = $db->prepare("UPDATE rawlocation SET qty = qty + ?,inprog_qty = inprog_qty - ? WHERE lid = ? AND rid = ?");
				$rlvalues = array($reqty,$reqty,1,$rid);
				if(!$rlquery->execute($rlvalues))
				{
					echo "\nPDO::errorInfo():\n";
					print_r($rlquery->errorInfo());die;
				}
				
			}// Recipe Query End

			///// Transfer Stock Location from in progress to complete /////
			/*$wod_query = $db->prepare("SELECT * FROM workorderdetail WHERE woid =? AND szid=?");
			$wod_query->execute(array($woid,$szid));
			while($wod_row = $wod_query->fetch())
			{
				$wo_qty = $wod_row['woqty'];
				$wo_comqty = $wod_row['comqty'];
			}	*/	
			/*if($wo_qty > $wo_comqty)
			{
				
			}*/
			
			$wodquery = $db->prepare("UPDATE workorderdetail SET comqty = comqty + 1 WHERE woid = ? AND wodid = ? AND szid = ?");
			$wodquery->execute(array($woid,$wodid,$szid));

			$uslquery = $db->prepare("UPDATE stocklocation SET slqty = slqty + ?, slinprog_qty = slinprog_qty - ? WHERE lid = ? AND pid = ? AND szid = ?");
			$uslvalues = array(1,1,$Lid,$pid,$szid);
			if(!$uslquery->execute($uslvalues))
			{
				echo "\nPDO::errorInfo():\n";
				print_r($uslquery->errorInfo());die;
			}

			$barquery = $db->prepare("UPDATE product_barcodes SET bcstatus = ? WHERE barcode = ?");
			$barvalues = array(3,$barcode);
			if(!$barquery->execute($barvalues))
			{
				echo "\nPDO::errorInfo():\n";
				print_r($barquery->errorInfo());die;
			}

			///////////////////// LOG SECTION /////////////////////
		    $log = "Barcode canceled successfully";
			log_entry($log);
		    ///////////////////////////////////////////////////////
			header("Location: barcodes_workorder.php?pid=$pid&szid=$szid&woid=$woid&wodid=$wodid&err=3");
		}
	}
	///////////////////// Add Sale /////////////////////

	function add_sale($db,$URL,$userid,$sessionid)
	{
	    
    	$uid = 1;
    	
		$Date 	 = time();		
		$DeAid 	 = 1;
		$CuAid   = $_REQUEST['cboCustomer'];

		$name = $_REQUEST['txtName'];
		$email = $_REQUEST['txtEmail'];
		$mobileno = $_REQUEST['txtMobileNo'];
		$address = $_REQUEST['txtAddress'];
		$remarks = $_REQUEST['txtRemarks'];
		    
		$GrandTotalCost = $_REQUEST['txtGrandTotalCost'];
		$Paid 	 		= $_REQUEST['txtPaid'];
		$Balance 		= $_REQUEST['txtBalance'];
		$Status 		= 0;
		if($Status == 0)
		{
			$Paid = 0;	
			$Balance = $GrandTotalCost;
		}
		else
		{
			$Paid = $GrandTotalCost;	
			$Balance = 0;
		}

		$num_tmp_query = $db->prepare("SELECT tbcid FROM tmp_product_barcodes WHERE sessionid=?");
		$num_tmp_query->execute(array($sessionid));
		$total_qty = $num_tmp_query->rowCount();

		$tmp_query = $db->prepare("SELECT sum(sell_price) as total_amount FROM tmp_product_barcodes WHERE sessionid=?");
		$tmp_query->execute(array($sessionid));
		while($tmp_row = $tmp_query->fetch())
		{
			$total_amount = $tmp_row['total_amount'];
		}

		//$uid 			= $_SESSION['user'];
		$Query = $db->prepare("INSERT INTO invoices(aid, lid, uid, totalqty, totalamount , paid , balance , invname, invemail, invmobileno, invaddress, invremarks , invstatus , invdate) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
		$Values = array($CuAid,1,$userid,$total_qty,$GrandTotalCost,$Paid,$Balance,$name,$email,$mobileno,$address,$remarks,0,$Date);
		if($Query->execute($Values))
		{
			$Invid = $db->lastInsertId();

			$tmpquery = $db->prepare("SELECT * FROM tmp_product_barcodes WHERE sessionid=? ORDER by tbcid ASC");
			$tmpquery->execute(array($sessionid));
			while($tmprow = $tmpquery->fetch())
			{
				$pid = $tmprow['pid'];
				$szid = $tmprow['szid'];
				$barcode = $tmprow['barcode'];
				$sell_price = $tmprow['sell_price'];

				$update_query = $db->prepare("UPDATE product_barcodes SET invid=?, sell_price=?, sell_date=?, bcstatus=? WHERE barcode=?");
				$update_array = array($Invid, $sell_price, time(), 2, $barcode);
				$update_query->execute($update_array);

				$update_stock = $db->prepare("UPDATE stocklocation SET slqty=slqty-? WHERE lid=? AND pid=? AND szid=?");
				$update_sarray = array(1,1,$pid,$szid);
				$update_stock->execute($update_sarray);
			}

			//////////// Customer Ledger Entry ///////////////////
			/*$CuQuery = $db->prepare("SELECT * FROM ledger L INNER JOIN accounts A ON L.aid = A.aid WHERE L.aid = ? ORDER BY L.leid DESC LIMIT 0,1");
			$CuQuery->execute(array($CuAid));
			while($CuRow = $CuQuery->fetch())
			{
			  $CustomerGtNo  = $CuRow['gtno'];
			  $CustomerName  = $CuRow['aname'];
			  $CustomerEmail = $CuRow['aemail'];
			  $OldCustomerBalance = $CuRow['balance'];
			}
			$Detail = "<a href='print_gen_invoice.php?invid=$Invid'>Sale Invoice # $Invid Created for $CustomerGtNo-$CustomerName ($CustomerEmail)</a> | $Remarks";		
			$CuDebit = $_REQUEST['txtPaid'];
			$CuCredit = $_REQUEST['txtGrandTotalCost'];
			
			$CurrentBalance = $CuCredit - $CuDebit;

			$CuBalance = $OldCustomerBalance + $CurrentBalance;
			ledger_entry($CuAid,$Detail,$CuDebit,$CuCredit,$CuBalance,$Date);

			//////////// Debit Ledger Entry ///////////////////
			$DeQuery = $db->prepare("SELECT * FROM ledger L INNER JOIN accounts A ON L.aid = A.aid WHERE L.aid = ? ORDER BY L.leid DESC LIMIT 0,1");
			$DeQuery->execute(array($DeAid));
			while($DeRow = $DeQuery->fetch())
			{
			  $DebitName  = $DeRow['aname'];
			  $DebitEmail = $DeRow['aemail'];
			  $OldDebitBalance = $DeRow['balance'];
			}		
			$DeDebit = 0;
			$DeCredit = $_REQUEST['txtPaid'];
			$DeBalance = $OldDebitBalance + $_REQUEST['txtPaid'];
			ledger_entry($DeAid,$Detail,$DeDebit,$DeCredit,$DeBalance,$Date);

			$delquery = $db->prepare("DELETE FROM temp_invoicedetail WHERE sessionid = ?");
			$delquery->execute(array(session_id()));
			*/
			///////////////////// LOG SECTION /////////////////////
		    $log = "<a href='print_gen_invoice.php?invid=$Invid'>Sale Invoice # $Invid Created for $name-$email | $remarks";
			log_entry($log);
		    ///////////////////////////////////////////////////////
			//// Delete Tmp Invoice Record ////
			$delquery1 = $db->prepare("DELETE FROM tmp_invoice WHERE sessionid = ?");
			$delquery2 = $db->prepare("DELETE FROM tmp_product_barcodes WHERE sessionid = ?");

			$delquery1->execute(array($sessionid));
			$delquery2->execute(array($sessionid));
			///////////////////// LOG SECTION /////////////////////
		    $log = "Cafe Sale Invoice # $Invid Created for Cash Sale | $Remarks";
			log_entry($log);
		    ///////////////////////////////////////////////////////
			header("Location: pos.php?invid=$Invid&err=22");
		}
		else
        {
          echo "\nPDO::errorInfo():\n";
          print_r($Query->errorInfo());die;
        }
	}

	function add_shopify_sale($db,$URL,$id,$order_number)
	{
	    if(isset($_SESSION['user']))
    	{
    		$uid = $_SESSION['user'];
    	}
    	else
    	{
    		$uid = $_COOKIE['user'];
    	}
	    
		$Date 	 = time();
		$DeAid 	 = 1;
		$CuAid   = 1;

		$orquery = $db->prepare("SELECT * FROM orders O INNER JOIN order_shipping OS ON O.order_number = OS.order_number WHERE O.order_number = ?");
		$orquery->execute(array($order_number));
		while($orrow =$orquery->fetch())
		{
			$id = $orrow['id'];
			$name = $orrow['customer_name'];
			$email = $orrow['customer_email'];
			$mobileno = $orrow['customer_phone'];;
			$address = $orrow['address'].", ".$orrow['city'].", ".$orrow['country'].", ".$orrow['zip'];
			$remarks = $orrow['title'];
			$GrandTotalCost = $orrow['order_total'];
			$Paid 	 		= $orrow['order_total'];
			$Balance 		= 0;
		}
		    
		$Status 	= 0;
		if($Status == 0)
		{
			$Paid = 0;	
			$Balance = $GrandTotalCost;
		}
		else
		{
			$Paid = $GrandTotalCost;	
			$Balance = 0;
		}

		$order_details_query = $db->prepare("SELECT order_number, SUM(item_quantity) AS total_qty FROM order_details WHERE order_number=?");
		$order_details_query->execute(array($order_number));
		while($orderdetailrow = $order_details_query->fetch())
		{
			$total_qty = $orderdetailrow['total_qty'];
		}

		$tmp_query = $db->prepare("SELECT * FROM tmp_order WHERE order_number=?");
		$tmp_query->execute(array($order_number));
		$num_tmp_order = $tmp_query->rowCount();

		if($total_qty == $num_tmp_order)
		{
			$Query = $db->prepare("INSERT INTO invoices(aid, lid, uid, totalqty, totalamount , paid , balance , invname, invemail, invmobileno, invaddress, invremarks , invstatus , invdate) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
			$Values = array($CuAid,1,$uid,$total_qty,$GrandTotalCost,$Paid,$Balance,$name,$email,$mobileno,$address,$remarks,0,$Date);
			if($Query->execute($Values))
			{
				$Invid = $db->lastInsertId();

				$tmpquery = $db->prepare("SELECT * FROM tmp_order WHERE order_number=? ORDER by id ASC");
				$tmpquery->execute(array($order_number));
				while($tmprow = $tmpquery->fetch())
				{
					$pid = $tmprow['pid'];
					$szid = $tmprow['szid'];
					$barcode = $tmprow['barcode'];
					$sell_price = $tmprow['sale_price'];

					$update_query = $db->prepare("UPDATE product_barcodes SET invid=?, sell_price=?, sell_date=?, bcstatus=? WHERE barcode=?");
					$update_array = array($Invid, $sell_price, time(), 2, $barcode);
					$update_query->execute($update_array);

					$update_stock = $db->prepare("UPDATE stocklocation SET slqty=slqty-? WHERE lid=? AND pid=? AND szid=?");
					$update_sarray = array(1,1,$pid,$szid);
					$update_stock->execute($update_sarray);
				}

				//////////// Customer Ledger Entry ///////////////////
				/*$CuQuery = $db->prepare("SELECT * FROM ledger L INNER JOIN accounts A ON L.aid = A.aid WHERE L.aid = ? ORDER BY L.leid DESC LIMIT 0,1");
				$CuQuery->execute(array($CuAid));
				while($CuRow = $CuQuery->fetch())
				{
				  $CustomerGtNo  = $CuRow['gtno'];
				  $CustomerName  = $CuRow['aname'];
				  $CustomerEmail = $CuRow['aemail'];
				  $OldCustomerBalance = $CuRow['balance'];
				}
				$Detail = "<a href='print_gen_invoice.php?invid=$Invid'>Sale Invoice # $Invid Created for $CustomerGtNo-$CustomerName ($CustomerEmail)</a> | $Remarks";		
				$CuDebit = $_REQUEST['txtPaid'];
				$CuCredit = $_REQUEST['txtGrandTotalCost'];
				
				$CurrentBalance = $CuCredit - $CuDebit;

				$CuBalance = $OldCustomerBalance + $CurrentBalance;
				ledger_entry($CuAid,$Detail,$CuDebit,$CuCredit,$CuBalance,$Date);

				//////////// Debit Ledger Entry ///////////////////
				$DeQuery = $db->prepare("SELECT * FROM ledger L INNER JOIN accounts A ON L.aid = A.aid WHERE L.aid = ? ORDER BY L.leid DESC LIMIT 0,1");
				$DeQuery->execute(array($DeAid));
				while($DeRow = $DeQuery->fetch())
				{
				  $DebitName  = $DeRow['aname'];
				  $DebitEmail = $DeRow['aemail'];
				  $OldDebitBalance = $DeRow['balance'];
				}		
				$DeDebit = 0;
				$DeCredit = $_REQUEST['txtPaid'];
				$DeBalance = $OldDebitBalance + $_REQUEST['txtPaid'];
				ledger_entry($DeAid,$Detail,$DeDebit,$DeCredit,$DeBalance,$Date);

				$delquery = $db->prepare("DELETE FROM temp_invoicedetail WHERE sessionid = ?");
				$delquery->execute(array(session_id()));
				*/
				///////////////////// LOG SECTION /////////////////////
			    $log = "<a href='print_gen_invoice.php?invid=$Invid'>Sale Invoice # $Invid Created for $name-$email | $remarks";
				log_entry($log);
			    ///////////////////////////////////////////////////////
				//// Delete Tmp Invoice Record ////
				$delquery = $db->prepare("DELETE FROM tmp_order WHERE order_number = ?");
				$delquery->execute(array($order_number));
				///////////////////// LOG SECTION /////////////////////
			    $log = "Sale Invoice # $Invid Created";
				log_entry($log);
			    ///////////////////////////////////////////////////////
				header("Location: view_invoice.php?invid=$Invid");
			}
			else
	        {
	          echo "\nPDO::errorInfo():\n";
	          print_r($Query->errorInfo());die;
	        }	
		}
		else
		{
			header("Location: order_detail.php?id=$id&err=62");
		}
	}

	///// auto generates the invoice in the background and update status of the shopify order
	function add_shopify_sale1($db,$URL,$order_number)
	{
	    if(isset($_SESSION['user']))
    	{
    		$uid = $_SESSION['user'];
    	}
    	else
    	{
    		$uid = $_COOKIE['user'];
    	}
	    
		$Date 	 = time();
		$DeAid 	 = 1;
		$CuAid   = 1;

		$orquery = $db->prepare("SELECT * FROM orders WHERE order_number = ?");
		$orquery->execute(array($order_number));
		while($orrow =$orquery->fetch())
		{
			$id = $orrow['id'];
			$name = $orrow['customer_name'];
			$email = $orrow['customer_email'];
			$GrandTotalCost = $orrow['order_total'];
			$Paid 	 		= $orrow['order_total'];
			$Balance 		= 0;
		}
		$osquery = $db->prepare("SELECT * FROM order_shipping WHERE order_number = ?");
		$osquery->execute(array($order_number));
		if($osquery->rowCount() > 0)
		{
			while($osrow =$osquery->fetch())
			{
				$mobileno = $osrow['phone'];
				$address = $osrow['address'].", ".$osrow['city'].", ".$osrow['country'].", ".$osrow['zip'];
				$remarks = $osrow['title'];
			}	
		}
		else
		{
			$mobileno = "";
			$address = "";
			$remarks = "";
		}
		    
		$Status 	= 0;
		if($Status == 0)
		{
			$Paid = 0;	
			$Balance = $GrandTotalCost;
		}
		else
		{
			$Paid = $GrandTotalCost;	
			$Balance = 0;
		}

		$order_details_query = $db->prepare("SELECT order_number, SUM(item_quantity) AS total_qty FROM order_details WHERE order_number=?");
		$order_details_query->execute(array($order_number));
		while($orderdetailrow = $order_details_query->fetch())
		{
			$total_qty = $orderdetailrow['total_qty'];
		}

		$Query = $db->prepare("INSERT INTO invoices(aid, lid, uid, order_number, totalqty, totalamount , paid , balance , invname, invemail, invmobileno, invaddress, invremarks , invstatus , invdate) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
		$Values = array($CuAid,1,$uid,$order_number,$total_qty,$GrandTotalCost,$Paid,$Balance,$name,$email,$mobileno,$address,$remarks,0,$Date);

		if($Query->execute($Values))
		{
			//echo("$CuAid,1,$uid,$total_qty,$GrandTotalCost,$Paid,$Balance,$name,$email,$mobileno,$address,$remarks,0,$Date");die;
			$Invid = $db->lastInsertId();

			$bcquery = $db->prepare("SELECT * FROM product_barcodes WHERE order_number=? ORDER by bcid ASC");
			$bcquery->execute(array($order_number));
			while($bcrow = $bcquery->fetch())
			{
				$pid = $bcrow['pid'];
				$szid = $bcrow['szid'];
				$barcode = $bcrow['barcode'];
				
				$update_query = $db->prepare("UPDATE product_barcodes SET invid=?, sell_date=?, bcstatus=? WHERE barcode=?");
				$update_array = array($Invid, time(), 2, $barcode);
				if(!$update_query->execute($update_array))
		        {
		          echo "\nPDO::errorInfo():\n";
		          print_r($update_query->errorInfo());die;
		        }

				$update_stock = $db->prepare("UPDATE stocklocation SET slqty=slqty-? WHERE lid=? AND pid=? AND szid=?");
				$update_sarray = array(1,1,$pid,$szid);
				if(!$update_stock->execute($update_sarray))
		        {
		          echo "\nPDO::errorInfo():\n";
		          print_r($update_stock->errorInfo());die;
		        }
		        
		        $order_query = $db->prepare("UPDATE orders SET order_status=? WHERE order_number=?");
				$order_values = array(1,$order_number);
				if(!$order_query->execute($order_values))
		        {
		          echo "\nPDO::errorInfo():\n";
		          print_r($order_query->errorInfo());die;
		        }
			}

			//////////// Customer Ledger Entry ///////////////////
			/*$CuQuery = $db->prepare("SELECT * FROM ledger L INNER JOIN accounts A ON L.aid = A.aid WHERE L.aid = ? ORDER BY L.leid DESC LIMIT 0,1");
			$CuQuery->execute(array($CuAid));
			while($CuRow = $CuQuery->fetch())
			{
			  $CustomerGtNo  = $CuRow['gtno'];
			  $CustomerName  = $CuRow['aname'];
			  $CustomerEmail = $CuRow['aemail'];
			  $OldCustomerBalance = $CuRow['balance'];
			}
			$Detail = "<a href='print_gen_invoice.php?invid=$Invid'>Sale Invoice # $Invid Created for $CustomerGtNo-$CustomerName ($CustomerEmail)</a> | $Remarks";		
			$CuDebit = $_REQUEST['txtPaid'];
			$CuCredit = $_REQUEST['txtGrandTotalCost'];
			
			$CurrentBalance = $CuCredit - $CuDebit;

			$CuBalance = $OldCustomerBalance + $CurrentBalance;
			ledger_entry($CuAid,$Detail,$CuDebit,$CuCredit,$CuBalance,$Date);

			//////////// Debit Ledger Entry ///////////////////
			$DeQuery = $db->prepare("SELECT * FROM ledger L INNER JOIN accounts A ON L.aid = A.aid WHERE L.aid = ? ORDER BY L.leid DESC LIMIT 0,1");
			$DeQuery->execute(array($DeAid));
			while($DeRow = $DeQuery->fetch())
			{
			  $DebitName  = $DeRow['aname'];
			  $DebitEmail = $DeRow['aemail'];
			  $OldDebitBalance = $DeRow['balance'];
			}		
			$DeDebit = 0;
			$DeCredit = $_REQUEST['txtPaid'];
			$DeBalance = $OldDebitBalance + $_REQUEST['txtPaid'];
			ledger_entry($DeAid,$Detail,$DeDebit,$DeCredit,$DeBalance,$Date);

			$delquery = $db->prepare("DELETE FROM temp_invoicedetail WHERE sessionid = ?");
			$delquery->execute(array(session_id()));
			*/
			///////////////////// LOG SECTION /////////////////////
		    //$log = "<a href='print_invoice.php?invid=$Invid'>Sale Invoice # $Invid Created for $name-$email | $remarks";
			//log_entry($log);
		    ///////////////////////////////////////////////////////
			///////////////////// LOG SECTION /////////////////////
		    $log = "Sale Invoice # $Invid Created";
			log_entry($log);
		    ///////////////////////////////////////////////////////
			//header("Location: view_invoice.php?invid=$Invid");
		}
		else
        {
          echo "\nPDO::errorInfo():\n";
          print_r($Query->errorInfo());die;
        }
	}

	function email_gst_invoice($db,$URL,$invid)
	{
		$invid = $_REQUEST['invid'];

		$message = '<table align="center" style="font-family: arial;" width="850" cellspacing="0" cellpadding="0">
						<tr>
							<td width="550" align="left" valign="top">
								<img src="'.$URL.'/images/corios-logo.png.png" width="200">
								<br><br>
								<b>Building # 95/96, Street 8-C, Feroz Colony Outfall Road</b>
								<br>
								<b>Lahore</b>
								<br>
								<b>0300 4806769</b>
								<br>
								<b>0324 5131870</b>
							</td>';
		$query = $db->prepare("SELECT * FROM invoices I INNER JOIN accounts A ON I.aid = A.aid WHERE I.invid = ?");
		$query->execute(array($invid));
		while($row = $query->fetch())
		{
			$invid = $row['invid'];
			$invno = "GST-".str_pad($row['invno'], 4, "0", STR_PAD_LEFT);
			$aid = $row['aid'];
			$uid = $row['uid'];

			$totalqty    = $row['totalqty'];
			$subtotal = $row['totalamount'] + $row['discount'];
			$discount = $row['discount'];
			$totalamount = $row['totalamount'];
			$paid = $row['paid'];
			$balance = $row['balance'];
		$message.=			'<td width="300" align="left" valign="top">
								<h1>Customer Invoice</h1>
								<br>
								<b>'.$invno.'</b>
								<br>
								<b>'.$row['aname'].'</b>
								<br>
								<b>'.date("d/m/Y",$row['invdate']).'</b>
								<br>
								<b>'.$row['aconame'].'</b>
								<br>
								<b>'.$row['aaddress'].' '.$row['acity'].'</b>
							</td>
						</tr>
					</table>
					<br><br>
					<table align="center" width="850" style="border: 1px solid #CCC; font-family: arial;">
						<tr class="title">
							<td style="border: 1px solid #CCC;" width="50" align="center" bgcolor="#54271D" height="25">&nbsp;<span style="color: #fff; font-weight: bold;">Sr No</span></td>
							<td style="border: 1px solid #CCC;" align="left" bgcolor="#54271D" height="15">&nbsp;<b style="color: white;">Details</b></td>
							<td style="border: 1px solid #CCC;" width="100" align="right" bgcolor="#54271D" height="15"><b style="color: white;">Price</b>&nbsp;</td>
							<td style="border: 1px solid #CCC;" width="50" align="center" bgcolor="#54271D" height="15"><b style="color: white;">Qty</b></td>
							<td style="border: 1px solid #CCC;" width="150" align="right" bgcolor="#54271D" height="15"><b style="color: white;">Total</b>&nbsp;</td>
						</tr>';
			$count = 0;
			$invquery = $db->prepare("SELECT * FROM invoicedetail WHERE invid = ?");
			$invquery->execute(array($invid));
			while($invrow = $invquery->fetch())
			{
				$count++;
		$message.=		'<tr>
							<td style="border: 1px solid #CCC;" align="center" class="title" height="25">&nbsp;'.$count.'</td>
							<td style="border: 1px solid #CCC;" align="left">&nbsp;'.$invrow['invdetail'].'</td>
							<td style="border: 1px solid #CCC;" align="right">'.number_format($invrow['invprice']).'&nbsp;</td>
							<td style="border: 1px solid #CCC;" align="center">'.$invrow['invqty'].'</td>
							<td style="border: 1px solid #CCC;" align="right">'.number_format($invrow['invtotalprice']).'&nbsp;</td>
						</tr>';
			}			
		$message.=		'<tr>
							<td style="border: 1px solid #CCC;" align="right" height="35" colspan="4"><b>Total</b>&nbsp;</td>
							<td style="border: 1px solid #CCC;" align="right"> <b>'.number_format($row['totalamount']).'</b>&nbsp;</td>
						</tr>
						<tr>
							<td style="border: 1px solid #CCC;" align="right" height="35" colspan="4"><b>Paid</b>&nbsp;</td>
							<td style="border: 1px solid #CCC;" align="right"> <b>'.number_format($row['paid']).'</b>&nbsp;</td>
						</tr>
						<tr>
							<td style="border: 1px solid #CCC;" align="right" height="35" colspan="4"><b>Balance</b>&nbsp;</td>
							<td style="border: 1px solid #CCC;" align="right"> <b>'.number_format($row['balance']).'</b>&nbsp;</td>
						</tr>
					</table>';

			///////////////// PDF Creation //////////////////////////
			require_once __DIR__ . '/vendor/autoload.php';
			$mpdf = new \Mpdf\Mpdf();
			$pdf_file_name = "GIN ".$row['invid']." GITMIT.pdf";

			$mpdf->WriteHTML($message);
			$mpdf->Output($pdf_file_name,"F");
            
        	////////////////////////////////////////////////////////

			require("phpmailer/PHPMailerAutoload.php");

			$mail = new PHPMailer;
			   
			$mail->setFrom('sales@gitmit.com', 'GITMIT CO-WORKING SPACE');
			$mail->addAddress($row['aemail']);     // Add a recipient
			$mail->addBCC('mumtaz@lanwan.com.au');
			$mail->addBCC('info@gitmit.com');
			$mail->addAttachment($pdf_file_name,$pdf_file_name);  // Add attachments
			$mail->isHTML(true);                                  	  // Set email format to HTML

			$mail->Subject = "Customer Invoice GIN ".$row['invid']."";
			$mail->Body    = $message;
			$mail->AltBody = "This is the body in plain text for non-HTML mail clients";

		  	if(!$mail->send()) {
		    	echo 'Message could not be sent.';
		    	echo 'Mailer Error: ' . $mail->ErrorInfo;
		  	} else {
		  		unlink($pdf_file_name);

		  		///////////////////// LOG SECTION /////////////////////
			    $log = "<a href='print_gen_invoice.php?invid=$invid'>Sale Invoice GIN-$invid Emailed to Customer";
				log_entry($log);
			    ///////////////////////////////////////////////////////
		    	header("Location: view_invoice.php?invid=".$row['invid']."&err=15");
		  	}
		}
	}

	function add_income_sale($db,$URL,$uid)
	{
		$Date  = time();	
		$Session 	 = session_id();
		$DeAid = $_REQUEST['cboAccount'];
		$CuAid = 1;
		$Lid   = 1;
		$Uid   = 1;

		$hdnInvNo   	= $_REQUEST['hdnInvNo'];
		$Remarks   		= $_REQUEST['txtRemarks'];
		$TotalQty 		= $_REQUEST['hdnQty'];
		$GrandTotalCost = $_REQUEST['txtGrandTotalCost'] - $_REQUEST['txtDiscount'];
		$Discount 	 	= $_REQUEST['txtDiscount'];
		$Paid 	 		= $_REQUEST['txtPaid'];
		$Balance 		= $_REQUEST['txtBalance'];
		$Status 		= 0;

		//echo($_REQUEST['txtInvNo'].", ".$hdnInvNo);die;
		//$uid 			= $_SESSION['user'];
		$Query = $db->prepare("INSERT INTO invoices(aid , lid , uid , invno , invtype , remarks , totalqty , totalamount , discount , paid , balance , invstatus , invdate) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?)");
		$Values = array($DeAid,$Lid,$Uid,$hdnInvNo,2,$Remarks,$TotalQty,$GrandTotalCost,$Discount,$Paid,$Balance,$Status,$Date);
		if($Query->execute($Values))
		{
			$Invid = $db->lastInsertId();
			for ($i = 1; $i <= $_REQUEST['hdnNum']; $i++)
			{
				$Pid		 = "hdnPid$i";
				$Qty	 	 = "txtQty$i";
				$UnitCost 	 = "txtUnitCost$i";
				$TotalCost 	 = "txtTotalCost$i";
				$InvDetailQuery = $db->prepare("INSERT INTO invoicedetail(invid , pid , invqty , unitprice , totalprice , invdate) VALUES(?,?,?,?,?,?)");
				$InvDetailValues = array($Invid , $_REQUEST[$Pid] , $_REQUEST[$Qty] , $_REQUEST[$UnitCost] , $_REQUEST[$TotalCost] , $Date);
				
				if(!$InvDetailQuery->execute($InvDetailValues))
				{
					echo "\nPDO::errorInfo():\n";
					print_r($db->errorInfo());die;
				}

				///// Update Stock /////
				$stockquery = $db->prepare("SELECT * FROM stocklocation WHERE lid=? AND pid=?");
				$stockquery->execute(array($Lid,$_REQUEST[$Pid]));
				if($stockquery->rowCount() == 0)
				{
					$sl_query = $db->prepare("INSERT INTO stocklocation(lid,pid) VALUES(?,?)");
					$sl_values = array($Lid,$_REQUEST[$Pid]);
					$sl_query->execute($sl_values);	
				}
				$slquery = $db->prepare("UPDATE stocklocation SET slqty = slqty - ? WHERE lid = ? AND pid = ?");
				$slvalues = array($_REQUEST[$Qty],$Lid,$_REQUEST[$Pid]);
				$slquery->execute($slvalues);
			}
			$invquery = $db->prepare("SELECT invid,SUM(invqty) AS total_qty FROM invoicedetail WHERE invid=?");
			$invquery->execute(array($Invid));
			while($invrow = $invquery->fetch())
			{
				$total_qty = $invrow['total_qty'];
				/// Update Invoice Qty ///
				$inv_update_query = $db->prepare("UPDATE invoices SET totalqty=? WHERE invid=?");
				$inv_update_query->execute(array($total_qty,$Invid));
			}

			//////////// Debit Customer Ledger Entry ///////////////////
			chk_ledger($db,$URL,$DeAid);
			$DeQuery = $db->prepare("SELECT * FROM ledger L INNER JOIN accounts A ON L.aid = A.aid WHERE L.aid = ? ORDER BY L.leid DESC LIMIT 0,1");
			$DeQuery->execute(array($DeAid));
			if($DeQuery->rowCount() == 0)
			{
				$OldCustomerBalance = 0;	
			}
			else
			{
				while($DeRow = $DeQuery->fetch())
				{
				  $CustomerName  = $DeRow['aname'];
				  $CustomerEmail = $DeRow['aemail'];
				  $OldCustomerBalance = $DeRow['balance'];
				}	
			}
			
			$Detail = "<a href='print_income_invoice.php?invid=$Invid'>Income Tax Sale Invoice # $hdnInvNo Created for $CustomerName ($CustomerEmail)</a> | $Remarks";		
			$DeDebit = $_REQUEST['txtGrandTotalCost'];
			$DeCredit = $Paid;

			$CurrentBalance = $DeDebit - $DeCredit;

			$DeBalance = $OldCustomerBalance + $CurrentBalance;
			ledger_entry($DeAid,$Detail,$DeDebit,$DeCredit,$DeBalance,$Date);

			//////////// Credit Ledger Entry ///////////////////
			if($Paid > 0)
			{
				chk_ledger($db,$URL,$CuAid);
				$CuQuery = $db->prepare("SELECT * FROM ledger L INNER JOIN accounts A ON L.aid = A.aid WHERE L.aid = ? ORDER BY L.leid DESC LIMIT 0,1");
				$CuQuery->execute(array($CuAid));
				if($CuQuery->rowCount() == 0)
				{
					$OldCreditBalance = 0;	
				}
				else
				{
					while($CuRow = $CuQuery->fetch())
					{
					  $CreditName  = $CuRow['aname'];
					  $CreditEmail = $CuRow['aemail'];
					  $OldCreditBalance = $CuRow['balance'];
					}	
				}
				
				$CuDebit = $Paid;
				$CuCredit = 0;
				$CuBalance = $OldCreditBalance + $Paid;

				//echo($CuBalance."<br>");
				//echo("$OldCreditBalance + $Paid <br>");
				//echo("$CuAid,$Detail,$CuDebit,0,$CuBalance,$Date");die;	
				ledger_entry($CuAid,$Detail,$CuDebit,0,$CuBalance,$Date);	
			}
			//////////// Income Tax 1% entery to the Income Tax reference account ///////////////////
			$gst_account = 86;
			$income_account = 87;
			$Income_Amount = $GrandTotalCost * 1 / 100;
			$IncomeQuery = $db->prepare("SELECT * FROM ledger WHERE aid = ? ORDER BY leid DESC LIMIT 0,1");
			$IncomeQuery->execute(array($income_account));
			if($IncomeQuery->rowCount() == 0)
			{
				$OldIncomeBalance = 0;	
			}
			else
			{
				while($IncomeRow = $IncomeQuery->fetch())
				{
				  $OldIncomeBalance = $IncomeRow['balance'];
				}	
			}

			$IncomeDebit = $Income_Amount;
			$IncomeCredit = 0;
			$IncomeBalance = $OldIncomeBalance + $Income_Amount;			
			ledger_entry($income_account,$Detail,$IncomeDebit,$IncomeCredit,$IncomeBalance,$Date);	
			
			$delquery = $db->prepare("DELETE FROM tmp_invoicedetail WHERE sessionid = ?");
			if(!$delquery->execute(array($Session)))
			{
				echo "\nPDO::errorInfo():\n";
				print_r($delquery->errorInfo());die;
			}

			///////////////////// LOG SECTION /////////////////////
		    $log = "<a href='print_income_invoice.php?invid=$Invid'>GST Sale Invoice # $hdnInvNo Created for $CustomerName ($CustomerEmail)</a> | $Remarks";
			log_entry($log);
		    ///////////////////////////////////////////////////////
			header("Location: view_income_invoice.php?invid=$Invid&err=22");
		}
	}

	function add_cash_sale($db,$URL,$uid)
	{
		$Date  = time();	
		$Session 	 = session_id();
		$DeAid = $_REQUEST['cboAccount'];
		$CuAid = 1;
		$Lid   = 1;
		$Uid   = 1;

		$hdnInvNo   	= $_REQUEST['hdnInvNo'];
		$Remarks   		= $_REQUEST['txtRemarks'];
		$TotalQty 		= $_REQUEST['hdnQty'];
		$GrandTotalCost = $_REQUEST['txtGrandTotalCost'] - $_REQUEST['txtDiscount'];
		$Discount 	 	= $_REQUEST['txtDiscount'];
		$Paid 	 		= $_REQUEST['txtPaid'];
		$Balance 		= $_REQUEST['txtBalance'];
		$Status 		= 0;

		//echo($_REQUEST['txtInvNo'].", ".$hdnInvNo);die;
		//$uid 			= $_SESSION['user'];
		$Query = $db->prepare("INSERT INTO invoices(aid , lid , uid , invno , invtype , remarks , totalqty , totalamount , discount , paid , balance , invstatus , invdate) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?)");
		$Values = array($DeAid,$Lid,$Uid,$hdnInvNo,3,$Remarks,$TotalQty,$GrandTotalCost,$Discount,$Paid,$Balance,$Status,$Date);
		if($Query->execute($Values))
		{
			$Invid = $db->lastInsertId();
			for ($i = 1; $i <= $_REQUEST['hdnNum']; $i++)
			{
				$Pid		 = "hdnPid$i";
				$Qty	 	 = "txtQty$i";
				$UnitCost 	 = "txtUnitCost$i";
				$TotalCost 	 = "txtTotalCost$i";
				$InvDetailQuery = $db->prepare("INSERT INTO invoicedetail(invid , pid , invqty , unitprice , totalprice , invdate) VALUES(?,?,?,?,?,?)");
				$InvDetailValues = array($Invid , $_REQUEST[$Pid] , $_REQUEST[$Qty] , $_REQUEST[$UnitCost] , $_REQUEST[$TotalCost] , $Date);
				
				if(!$InvDetailQuery->execute($InvDetailValues))
				{
					echo "\nPDO::errorInfo():\n";
					print_r($db->errorInfo());die;
				}

				///// Update Stock /////
				$stockquery = $db->prepare("SELECT * FROM stocklocation WHERE lid=? AND pid=?");
				$stockquery->execute(array($Lid,$_REQUEST[$Pid]));
				if($stockquery->rowCount() == 0)
				{
					$sl_query = $db->prepare("INSERT INTO stocklocation(lid,pid) VALUES(?,?)");
					$sl_values = array($Lid,$_REQUEST[$Pid]);
					$sl_query->execute($sl_values);	
				}
				$slquery = $db->prepare("UPDATE stocklocation SET slqty = slqty - ? WHERE lid = ? AND pid = ?");
				$slvalues = array($_REQUEST[$Qty],$Lid,$_REQUEST[$Pid]);
				$slquery->execute($slvalues);
			}
			$invquery = $db->prepare("SELECT invid,SUM(invqty) AS total_qty FROM invoicedetail WHERE invid=?");
			$invquery->execute(array($Invid));
			while($invrow = $invquery->fetch())
			{
				$total_qty = $invrow['total_qty'];
				/// Update Invoice Qty ///
				$inv_update_query = $db->prepare("UPDATE invoices SET totalqty=? WHERE invid=?");
				$inv_update_query->execute(array($total_qty,$Invid));
			}

			//////////// Debit Customer Ledger Entry ///////////////////
			chk_ledger($db,$URL,$DeAid);
			$DeQuery = $db->prepare("SELECT * FROM ledger L INNER JOIN accounts A ON L.aid = A.aid WHERE L.aid = ? ORDER BY L.leid DESC LIMIT 0,1");
			$DeQuery->execute(array($DeAid));
			if($DeQuery->rowCount() == 0)
			{
				$OldCustomerBalance = 0;	
			}
			else
			{
				while($DeRow = $DeQuery->fetch())
				{
				  $CustomerName  = $DeRow['aname'];
				  $CustomerEmail = $DeRow['aemail'];
				  $OldCustomerBalance = $DeRow['balance'];
				}	
			}
			
			$Detail = "<a href='print_cash_invoice.php?invid=$Invid'>Cash Sale Invoice # $hdnInvNo Created for $CustomerName ($CustomerEmail)</a> | $Remarks";		
			$DeDebit = $_REQUEST['txtGrandTotalCost'];
			$DeCredit = $Paid;

			$CurrentBalance = $DeDebit - $DeCredit;

			$DeBalance = $OldCustomerBalance + $CurrentBalance;
			ledger_entry($DeAid,$Detail,$DeDebit,$DeCredit,$DeBalance,$Date);

			//////////// Credit Ledger Entry ///////////////////
			if($Paid > 0)
			{
				chk_ledger($db,$URL,$CuAid);
				$CuQuery = $db->prepare("SELECT * FROM ledger L INNER JOIN accounts A ON L.aid = A.aid WHERE L.aid = ? ORDER BY L.leid DESC LIMIT 0,1");
				$CuQuery->execute(array($CuAid));
				if($CuQuery->rowCount() == 0)
				{
					$OldCreditBalance = 0;	
				}
				else
				{
					while($CuRow = $CuQuery->fetch())
					{
					  $CreditName  = $CuRow['aname'];
					  $CreditEmail = $CuRow['aemail'];
					  $OldCreditBalance = $CuRow['balance'];
					}	
				}
				
				$CuDebit = $Paid;
				$CuCredit = 0;
				$CuBalance = $OldCreditBalance + $Paid;
				ledger_entry($CuAid,$Detail,$CuDebit,0,$CuBalance,$Date);	
			}
				
			$delquery = $db->prepare("DELETE FROM tmp_invoicedetail WHERE sessionid = ?");
			if(!$delquery->execute(array($Session)))
			{
				echo "\nPDO::errorInfo():\n";
				print_r($delquery->errorInfo());die;
			}

			///////////////////// LOG SECTION /////////////////////
		    $log = "<a href='print_cash_invoice.php?invid=$Invid'>Cash Sale Invoice # $hdnInvNo Created for $CustomerName ($CustomerEmail)</a> | $Remarks";
			log_entry($log);
		    ///////////////////////////////////////////////////////
			header("Location: view_cash_invoice.php?invid=$Invid&err=22");
		}
	}

	function pdf_invoice($db,$URL,$invid)
	{
		$message = '<table align="center" style="font-family: arial;" width="850" cellspacing="0" cellpadding="0">
						<tr>
							<td width="650" align="left" valign="top">
								<img src="'.$URL.'/images/corios-logo.png" width="200">
								<br><br>
								<b>Building # 95/96, Street 8-C, Feroz Colony Outfall Road</b>
								<br>
								<b>Lahore</b>
								<br>
								<b>0300 4806769</b>
								<br>
								<b>0324 5131870</b>
							</td>';
		$query = $db->prepare("SELECT * FROM invoices I INNER JOIN accounts A ON I.aid = A.aid WHERE I.invid = ?");
		$query->execute(array($invid));
		while($row = $query->fetch())
		{
		$message.=			'<td width="300" align="left" valign="top">
								<h1>Customer Invoice</h1>
								<br>
								<b>'.$row['gtno'].'</b>
								<br>
								<b>'.$row['aname'].'</b>
								<br>
								<b>GIN-'.$row['invid'].' &nbsp;-&nbsp; '.date("d/m/Y",$row['invdate']).'</b>
								<br>
								<b>'.$row['aconame'].'</b>
								<br>
								<b>'.$row['aaddress'].' '.$row['acity'].'</b>
							</td>
						</tr>
					</table>
					<br><br>
					<table align="center" width="850" style="border: 1px solid #CCC; font-family: arial;">
						<tr class="title">
							<td style="border: 1px solid #CCC;" width="50" align="center" bgcolor="#54271D" height="25">&nbsp;<span style="color: #fff; font-weight: bold;">Sr No</span></td>
							<td style="border: 1px solid #CCC;" align="left" bgcolor="#54271D" height="15">&nbsp;<b style="color: white;">Details</b></td>
							<td style="border: 1px solid #CCC;" width="100" align="right" bgcolor="#54271D" height="15"><b style="color: white;">Price</b>&nbsp;</td>
							<td style="border: 1px solid #CCC;" width="50" align="center" bgcolor="#54271D" height="15"><b style="color: white;">Qty</b></td>
							<td style="border: 1px solid #CCC;" width="150" align="right" bgcolor="#54271D" height="15"><b style="color: white;">Total</b>&nbsp;</td>
						</tr>';
			$count = 0;
			$invquery = $db->prepare("SELECT * FROM invoicedetail WHERE invid = ?");
			$invquery->execute(array($invid));
			while($invrow = $invquery->fetch())
			{
				$count++;
		$message.=		'<tr>
							<td style="border: 1px solid #CCC;" align="center" class="title" height="25">&nbsp;'.$count.'</td>
							<td style="border: 1px solid #CCC;" align="left">&nbsp;'.$invrow['invdetail'].'</td>
							<td style="border: 1px solid #CCC;" align="right">'.number_format($invrow['invprice']).'&nbsp;</td>
							<td style="border: 1px solid #CCC;" align="center">'.$invrow['invqty'].'</td>
							<td style="border: 1px solid #CCC;" align="right">'.number_format($invrow['invtotalprice']).'&nbsp;</td>
						</tr>';
			}			
		$message.=		'<tr>
							<td style="border: 1px solid #CCC;" align="right" height="35" colspan="4"><b>Total</b>&nbsp;</td>
							<td style="border: 1px solid #CCC;" align="right"> <b>'.number_format($row['totalamount']).'</b>&nbsp;</td>
						</tr>
						<tr>
							<td style="border: 1px solid #CCC;" align="right" height="35" colspan="4"><b>Paid</b>&nbsp;</td>
							<td style="border: 1px solid #CCC;" align="right"> <b>'.number_format($row['paid']).'</b>&nbsp;</td>
						</tr>
						<tr>
							<td style="border: 1px solid #CCC;" align="right" height="35" colspan="4"><b>Balance</b>&nbsp;</td>
							<td style="border: 1px solid #CCC;" align="right"> <b>'.number_format($row['balance']).'</b>&nbsp;</td>
						</tr>
					</table>
					<br><br>
					<table align="center" width="850" style="border: 1px solid #CCC; font-family: arial;">
						<tr class="footer" style="background-color: #107E7F">
							<td align="center" colspan="2">
								<span style="font-size: 12px; color: #fff; font-weight: bold;">	
									Thanks for Doing Business With Us <br> We are Always Happy to Serve You
								</span>
							</td>
						</tr>
					</table>';
			
			///////////////// PDF Creation //////////////////////////
			require_once __DIR__ . '/vendor/autoload.php';
			$mpdf = new \Mpdf\Mpdf();
			$pdf_file_name = "GIN-".$row['invid']." GITMIT.pdf";

			$mpdf->WriteHTML($message);
			$mpdf->Output($pdf_file_name,"D");
			die;
		}
	}

	function email_invoice($db,$URL,$invid)
	{
		$invid = $_REQUEST['invid'];

		$message = '<table align="center" style="font-family: arial;" width="850" cellspacing="0" cellpadding="0">
						<tr>
							<td width="650" align="left" valign="top">
								<img src="'.$URL.'/images/corios-logo.png" width="200">
								<br><br>
								<b>Building # 95/96, Street 8-C, Feroz Colony Outfall Road</b>
								<br>
								<b>Lahore</b>
								<br>
								<b>0300 4806769</b>
								<br>
								<b>0324 5131870</b>
							</td>';
		$query = $db->prepare("SELECT * FROM invoices I INNER JOIN accounts A ON I.aid = A.aid WHERE I.invid = ?");
		$query->execute(array($invid));
		while($row = $query->fetch())
		{
		$message.=			'<td width="300" align="left" valign="top">
								<h1>Customer Invoice</h1>
								<br>
								<b>'.$row['gtno'].'</b>
								<br>
								<b>'.$row['aname'].'</b>
								<br>
								<b>GIN-'.$row['invid'].' &nbsp;-&nbsp; '.date("d/m/Y",$row['invdate']).'</b>
								<br>
								<b>'.$row['aconame'].'</b>
								<br>
								<b>'.$row['aaddress'].' '.$row['acity'].'</b>
							</td>
						</tr>
					</table>
					<br><br>
					<table align="center" width="850" style="border: 1px solid #CCC; font-family: arial;">
						<tr class="title">
							<td style="border: 1px solid #CCC;" width="50" align="center" bgcolor="#54271D" height="25">&nbsp;<span style="color: #fff; font-weight: bold;">Sr No</span></td>
							<td style="border: 1px solid #CCC;" align="left" bgcolor="#54271D" height="15">&nbsp;<b style="color: white;">Details</b></td>
							<td style="border: 1px solid #CCC;" width="100" align="right" bgcolor="#54271D" height="15"><b style="color: white;">Price</b>&nbsp;</td>
							<td style="border: 1px solid #CCC;" width="50" align="center" bgcolor="#54271D" height="15"><b style="color: white;">Qty</b></td>
							<td style="border: 1px solid #CCC;" width="150" align="right" bgcolor="#54271D" height="15"><b style="color: white;">Total</b>&nbsp;</td>
						</tr>';
			$count = 0;
			$invquery = $db->prepare("SELECT * FROM invoicedetail WHERE invid = ?");
			$invquery->execute(array($invid));
			while($invrow = $invquery->fetch())
			{
				$count++;
		$message.=		'<tr>
							<td style="border: 1px solid #CCC;" align="center" class="title" height="25">&nbsp;'.$count.'</td>
							<td style="border: 1px solid #CCC;" align="left">&nbsp;'.$invrow['invdetail'].'</td>
							<td style="border: 1px solid #CCC;" align="right">'.number_format($invrow['invprice']).'&nbsp;</td>
							<td style="border: 1px solid #CCC;" align="center">'.$invrow['invqty'].'</td>
							<td style="border: 1px solid #CCC;" align="right">'.number_format($invrow['invtotalprice']).'&nbsp;</td>
						</tr>';
			}			
		$message.=		'<tr>
							<td style="border: 1px solid #CCC;" align="right" height="35" colspan="4"><b>Total</b>&nbsp;</td>
							<td style="border: 1px solid #CCC;" align="right"> <b>'.number_format($row['totalamount']).'</b>&nbsp;</td>
						</tr>
						<tr>
							<td style="border: 1px solid #CCC;" align="right" height="35" colspan="4"><b>Paid</b>&nbsp;</td>
							<td style="border: 1px solid #CCC;" align="right"> <b>'.number_format($row['paid']).'</b>&nbsp;</td>
						</tr>
						<tr>
							<td style="border: 1px solid #CCC;" align="right" height="35" colspan="4"><b>Balance</b>&nbsp;</td>
							<td style="border: 1px solid #CCC;" align="right"> <b>'.number_format($row['balance']).'</b>&nbsp;</td>
						</tr>
					</table>';

			///////////////// PDF Creation //////////////////////////
			require_once __DIR__ . '/vendor/autoload.php';
			$mpdf = new \Mpdf\Mpdf();
			$pdf_file_name = "GIN ".$row['invid']." GITMIT.pdf";

			$mpdf->WriteHTML($message);
			$mpdf->Output($pdf_file_name,"F");
            
        	////////////////////////////////////////////////////////

			require("phpmailer/PHPMailerAutoload.php");

			$mail = new PHPMailer;
			   
			$mail->setFrom('sales@gitmit.com', 'GITMIT CO-WORKING SPACE');
			$mail->addAddress($row['aemail']);     // Add a recipient
			$mail->addBCC('mumtaz@lanwan.com.au');
			$mail->addBCC('info@gitmit.com');
			$mail->addAttachment($pdf_file_name,$pdf_file_name);  // Add attachments
			$mail->isHTML(true);                                  	  // Set email format to HTML

			$mail->Subject = "Customer Invoice GIN ".$row['invid']."";
			$mail->Body    = $message;
			$mail->AltBody = "This is the body in plain text for non-HTML mail clients";

		  	if(!$mail->send()) {
		    	echo 'Message could not be sent.';
		    	echo 'Mailer Error: ' . $mail->ErrorInfo;
		  	} else {
		  		unlink($pdf_file_name);

		  		///////////////////// LOG SECTION /////////////////////
			    $log = "<a href='print_gen_invoice.php?invid=$invid'>Sale Invoice GIN-$invid Emailed to Customer";
				log_entry($log);
			    ///////////////////////////////////////////////////////
		    	header("Location: view_invoice.php?invid=".$row['invid']."&err=15");
		  	}
		}
	}

	function update_invoice($db,$URL,$invid)
	{
		$status = $_REQUEST['cboStatus'];
		$totalamount = $_REQUEST['hdnTotalAmount'];
		
		$query = $db->prepare("UPDATE invoices SET paid = ? , balance = ? , invstatus = ? WHERE invid = ?");

		if($status == 1)
		{
			$values = array($totalamount, 0, $status, $invid);
		}
		else
		{
			$values = array(0, $totalamount, $status, $invid);
		}

		if($query->execute($values))
		{
			///////////////////// LOG SECTION /////////////////////
		    $log = "<a href='print_gen_invoice.php?invid=$invid'>Sale Invoice # $invid Updated";
			log_entry($log);
		    ///////////////////////////////////////////////////////
			header("Location: view_invoice.php?invid=$invid&err=3");	
		}
		else
		{
			echo "\nPDO::errorInfo():\n";
			print_r($query->errorInfo());die;
		}
	}

	function cancel_sale($db,$URL)
	{
		$delquery = $db->prepare("DELETE FROM temp_invoicedetail WHERE sessionid = ?");
		$delquery->execute(array(session_id()));

		header("Location: gen_invoices.php?&err=23");
	}

	function delete_invoice_item($db,$URL,$tinvdid)
	{
		$delquery = $db->prepare("DELETE FROM temp_invoicedetail WHERE sessionid = ?");
		$delquery->execute(array(session_id()));

		header("Location: addinvoice.php?&err=23");
	}

	function add_return($db,$URL)
	{
		$Date  = time();	
		$rtype = $_REQUEST['cboReturnType'];
		$invid = $_REQUEST['cboInvoice'];
		$remarks = $_REQUEST['txtRemarks'];
		$status = 0;
		$Detail = "Product Returned | $remarks";
		
		$allowed =  array('pdf','jpg');

		$File 	   = $_FILES['image']['name'];		
		$TmpFile   = $_FILES['image']['tmp_name'];

		$ext 	   = pathinfo($File, PATHINFO_EXTENSION);
		$rand = rand();
		$newfilename = $rand.".".$ext;
		$target_path  = "images/returns/";
		$target_path  = $target_path . basename($newfilename);
		
		if($ext == "png" || $ext == "PNG" || $ext == "jpg" || $ext == "JPG" || $ext == "pdf" || $ext == "doc" || $ext == "docx" || $ext == "zip")
		{
		    if(move_uploaded_file($TmpFile, $target_path))
			{
				$return_file_name = $newfilename;
			}
		}
		else
		{
			$return_file_name = "";
		}
	
		$Query = $db->prepare("INSERT INTO returns(rtype , invid , rimage , remarks , rstatus , rdate) VALUES(?,?,?,?,?,?)");
		$Values = array($rtype,$invid,$return_file_name,$remarks,$status,$Date);
		if($Query->execute($Values))
		{
			$rid = $db->lastInsertId();
			
			if(isset($_REQUEST['chkCheckbox']))
			{
				for ($i = 0; $i < count($_REQUEST['chkCheckbox']); $i++)
				{
					if (isset ($_REQUEST['chkCheckbox'][$i]))
					{
						$rdquery = $db->prepare("INSERT INTO returndetail(rid,pid,return_barcode,replace_barcode,amount_type,amount) VALUES(?,?,?,?,?,?)");
						$rdvalues = array($rid,$_REQUEST['hdnPID'][$i],$_REQUEST['chkCheckbox'][$i],$_REQUEST['txtReplaceBarCode'][$i],$_REQUEST['cboType'][$i],$_REQUEST['txtAmount'][$i]);
						$rdquery->execute($rdvalues);
						
						// echo($_REQUEST['txtReplaceBarCode'][$i]);die;
						// //echo("SELECT * FROM product_barcodes WHERE barcode = ".$_REQUEST['txtReplaceBarCode'][$i]." AND bcstatus = 1");die;
						// if($_REQUEST['txtReplaceBarCode'][$i] != 0)
						// {
						// 	$bcquery = $db->prepare("SELECT * FROM product_barcodes WHERE barcode = '".$_REQUEST['txtReplaceBarCode'][$i]."' AND bcstatus = 1");
						// 	$bcquery->execute();
						// 	if($bcquery->rowCount() > 0)
						// 	{
						// 		$rdquery = $db->prepare("INSERT INTO returndetail(rid,pid,return_barcode,replace_barcode,amount_type,amount) VALUES(?,?,?,?,?,?)");
						// 		$rdvalues = array($rid,$_REQUEST['hdnPID'][$i],$_REQUEST['chkCheckbox'][$i],$_REQUEST['txtReplaceBarCode'][$i],$_REQUEST['cboType'][$i],$_REQUEST['txtAmount'][$i]);
						// 		$rdquery->execute($rdvalues);	
						// 	}	
						// 	else
						// 	{
						// 		$delrequery1 = $db->prepare("DELETE FROM returns WHERE rid = ?");
						// 		$delrequery2 = $db->prepare("DELETE FROM returndetail WHERE rid = ?");
								
						// 		if($delrequery1->execute(array($rid)) && $delrequery2->execute(array($rid))){
						// 			header("Location: add_return.php?invid=$invid&err=9");
						// 			die;
						// 		}
						// 	}
						// }
						// else
						// {

						// }
						
					}
				}
			}

			///// Update Stock /////
			// $slquery = $db->prepare("UPDATE stocklocation SET slqty = slqty + ? WHERE lid = ? AND pid = ?");
			// $slvalues = array($qty,$lid,$pid);
			// $slquery->execute($slvalues);
			// if($amount > 0)
			// {
			// 	/////////////// Pay Account //////////////
			// 	$PayAcQuery = $db->prepare("SELECT * FROM ledger L INNER JOIN accounts A ON L.aid = A.aid WHERE L.aid = ? ORDER BY L.leid DESC LIMIT 0,1");
			// 	$PayAcQuery->execute(array($aid));
			// 	while($PayAcRow = $PayAcQuery->fetch())
			// 	{
			// 		$PayAccName      = $PayAcRow['aname'];
			// 		$OldPayAcBalance = $PayAcRow['balance'];
			// 	}
			// 	$CurrentPayAcBalance     = $OldPayAcBalance - $amount;
			// 	ledger_entry($aid,$Detail,0,$amount,$CurrentPayAcBalance,$Date);

			// 	/////////////// Receive Account //////////////
			// 	$ReceiveAcQuery = $db->prepare("SELECT * FROM ledger L INNER JOIN accounts A ON L.aid = A.aid WHERE L.aid = ? ORDER BY L.leid DESC LIMIT 0,1");
			// 	$ReceiveAcQuery->execute(array(1));
			// 	while($ReceiveAcRow = $ReceiveAcQuery->fetch())
			// 	{
			// 		$ReceiveAccName      = $ReceiveAcRow['aname'];
			// 		$OldReceiveAcBalance = $ReceiveAcRow['balance'];
			// 	}
			// 	$CurrentReceiveAcBalance = $amount + $OldReceiveAcBalance;
			// 	ledger_entry(1,$Detail,$amount,0,$CurrentReceiveAcBalance,$Date);
			// }


			///////////////////// LOG SECTION /////////////////////
		   	log_entry($Detail);
		    ///////////////////////////////////////////////////////
			header("Location: editreturn.php?rid=$rid&err=2");
		}
	}

	function add_shopify_return($db,$URL)
	{
		$Date  = time();	
		$rtype = $_REQUEST['cboReturnType'];
		$barcode = $_REQUEST['txtBarcode'];
		$status = 0;
		
		$bcquery = $db->prepare("SELECT * FROM product_barcodes WHERE barcode = ? AND bcstatus = ?");
		$bcquery->execute(array($barcode,2));
		if($bcquery->rowCount() == 0){
			header("Location: add_shopify_return.php?err=9");
			die;
		}else{

			while($bcrow = $bcquery->fetch())
			{
				$pid = $bcrow['pid'];
				$szid = $bcrow['szid'];
				$order_number = $bcrow['order_number'];
				$Detail = "Shopify Item Returned | Shopify Order: $order_number | Item Barcode: $barcode";
			}

			$Query = $db->prepare("INSERT INTO returns(rtype , remarks , rdate) VALUES(?,?,?)");
			$Values = array($rtype,$Detail,$Date);
			if($Query->execute($Values))
			{
				$rid = $db->lastInsertId();

				$rdquery = $db->prepare("INSERT INTO returndetail(rid,pid,return_barcode) VALUES(?,?,?)");
				$rdvalues = array($rid,$pid,$barcode);
				if($rdquery->execute($rdvalues))
				{
					$uquery = $db->prepare("UPDATE product_barcodes SET bcstatus = ?, bcremarks = ? WHERE barcode=?");
					$uvalues = array(1,$Detail,$barcode);
					$uquery->execute($uvalues);
				}
				///////////////////// LOG SECTION /////////////////////
			   	log_entry($Detail);
			    ///////////////////////////////////////////////////////
				header("Location: add_shopify_return.php?err=2");
			}
		}
	}

	function finalize_return($db,$URL,$rid)
	{
		$Date  = time();	

		$query = $db->prepare("SELECT * FROM returndetail RT INNER JOIN returns R ON RT.rid = R.rid INNER JOIN invoices INV ON R.invid = INV.invid WHERE RT.rid=?");
		$query->execute(array($rid));
		while($row = $query->fetch())
		{
		    
			$pid = $row['pid'];
			$invid = $row['invid'];
			if($row['order_number'] != 0) { $order_number = "Shopify Order: ".$row['order_number']; } else{ $order_number = ""; }
			$aid = 1;
			$return_barcode = $row['return_barcode'];
			$replace_barcode = $row['replace_barcode'];
			$amount_type = $row['amount_type'];
			$amount = $row['amount'];
			$remarks = "$return_barcode returned and replaced by $replace_barcode (Invoice # $invid $order_number)";
			$Detail = $remarks;
			
			///// Update Return Item Stock /////
			$slquery1 = $db->prepare("UPDATE stocklocation SET slqty = slqty + ? WHERE lid = ? AND pid = ?");
			$slvalues1 = array(1,1,$pid);
            
            $pbquery1 = $db->prepare("UPDATE product_barcodes SET bcremarks=?, bcstatus=? WHERE barcode=?");
			$pbvalues1 = array($remarks,1,$return_barcode);
			
			$slquery1->execute($slvalues1);
			$pbquery1->execute($pbvalues1);
				
			if($replace_barcode > 0)
			{
				$bcquery = $db->prepare("SELECT * FROM product_barcodes WHERE barcode=?");	
				$bcquery->execute(array($replace_barcode));
				while($bcrow = $bcquery->fetch())
				{
					$replace_pid = $bcrow['pid'];
				}

				///// Update Replace Item Stock /////
				$slquery2 = $db->prepare("UPDATE stocklocation SET slqty = slqty - ? WHERE lid = ? AND pid = ?");
				$slvalues2 = array(1,1,$replace_pid);

				$pbquery2 = $db->prepare("UPDATE product_barcodes SET bcremarks=?, bcstatus=? WHERE barcode=?");
				$pbvalues2 = array($remarks,2,$replace_barcode);

				$slquery2->execute($slvalues2);
				$pbquery2->execute($pbvalues2);	
			}
			
			if($amount > 0)
			{
				if($amount_type == 1)
				{
					/////////////// Pay Account //////////////
					$PayAcQuery = $db->prepare("SELECT * FROM ledger L INNER JOIN accounts A ON L.aid = A.aid WHERE L.aid = ? ORDER BY L.leid DESC LIMIT 0,1");
					$PayAcQuery->execute(array($aid));
					while($PayAcRow = $PayAcQuery->fetch())
					{
						$PayAccName      = $PayAcRow['aname'];
						$OldPayAcBalance = $PayAcRow['balance'];
					}
					$CurrentPayAcBalance     = $OldPayAcBalance - $amount;
					ledger_entry($aid,$Detail,0,$amount,$CurrentPayAcBalance,$Date);
	
				}
				else
				{
					/////////////// Receive Account //////////////
					$ReceiveAcQuery = $db->prepare("SELECT * FROM ledger L INNER JOIN accounts A ON L.aid = A.aid WHERE L.aid = ? ORDER BY L.leid DESC LIMIT 0,1");
					$ReceiveAcQuery->execute(array($aid));
					while($ReceiveAcRow = $ReceiveAcQuery->fetch())
					{
						$ReceiveAccName      = $ReceiveAcRow['aname'];
						$OldReceiveAcBalance = $ReceiveAcRow['balance'];
					}
					$CurrentReceiveAcBalance = $amount + $OldReceiveAcBalance;
					ledger_entry(1,$Detail,$amount,0,$CurrentReceiveAcBalance,$Date);	
				}
			}
		}
		$requery = $db->prepare("UPDATE returns SET rstatus = ? WHERE rid=?");
		if($requery->execute(array(1,$rid)))
		{
			header("Location: returns.php?err=3");
		}
	}

	function cancel_return($db,$URL,$rid)
	{
		$Date  = time();	
		
		$Query1 = $db->prepare("DELETE FROM returns WHERE rid=?");
		$Query2 = $db->prepare("DELETE FROM returndetail WHERE rid=?");
		$Values = array($rid);
		
		if($Query1->execute($Values) && $Query2->execute($Values))
		{
			///////////////////// LOG SECTION /////////////////////
		   	$Detail = "Return ID $rid has been removed";
		   	log_entry($Detail);
		    ///////////////////////////////////////////////////////
			header("Location: returns.php?err=4");
		}
	}

	function add_purchase_return($db,$URL)
	{
		$Date  = time();	
		$aid = $_REQUEST['cboVendor'];
		$purid = $_REQUEST['cboPurchaseInvoice'];
		$lid = $_REQUEST['hdnLid'];
		$rid = $_REQUEST['cboRawMaterial'];
		$qty = $_REQUEST['txtQty'];
		$amount = $_REQUEST['txtAmount'];
		$remarks = $_REQUEST['txtRemarks'];
		$Detail = "Raw Material Returned | $remarks";
		//echo("$aid,$invid,$pid,$qty,$amount,$remarks,0,$Date");die;
		$Query = $db->prepare("INSERT INTO pur_returns(aid , purid , rid , qty , reamount , reremarks , restatus , redate) VALUES(?,?,?,?,?,?,?,?)");
		$Values = array($aid,$purid,$rid,$qty,$amount,$remarks,0,$Date);
		if($Query->execute($Values))
		{
			$pureid = $db->lastInsertId();
			///// Update Stock /////
			$rlquery = $db->prepare("UPDATE rawlocation SET qty = qty - ? WHERE lid = ? AND rid = ?");
			$rlvalues = array($qty,$lid,$rid);
			$rlquery->execute($rlvalues);
			if($amount > 0)
			{
				/////////////// Pay Account //////////////
				$PayAcQuery = $db->prepare("SELECT * FROM ledger L INNER JOIN accounts A ON L.aid = A.aid WHERE L.aid = ? ORDER BY L.leid DESC LIMIT 0,1");
				$PayAcQuery->execute(array(1));
				while($PayAcRow = $PayAcQuery->fetch())
				{
					$PayAccName      = $PayAcRow['aname'];
					$OldPayAcBalance = $PayAcRow['balance'];
				}
				$CurrentPayAcBalance     = $OldPayAcBalance - $amount;
				ledger_entry(1,$Detail,0,$amount,$CurrentPayAcBalance,$Date);

				/////////////// Receive Account //////////////
				$ReceiveAcQuery = $db->prepare("SELECT * FROM ledger L INNER JOIN accounts A ON L.aid = A.aid WHERE L.aid = ? ORDER BY L.leid DESC LIMIT 0,1");
				$ReceiveAcQuery->execute(array($aid));
				while($ReceiveAcRow = $ReceiveAcQuery->fetch())
				{
					$ReceiveAccName      = $ReceiveAcRow['aname'];
					$OldReceiveAcBalance = $ReceiveAcRow['balance'];
				}
				$CurrentReceiveAcBalance = $amount + $OldReceiveAcBalance;
				ledger_entry($aid,$Detail,$amount,0,$CurrentReceiveAcBalance,$Date);
			}
			///////////////////// LOG SECTION /////////////////////
		   	log_entry($Detail);
		    ///////////////////////////////////////////////////////
			header("Location: view_purchase_return.php?pureid=$pureid&err=2");
		}
	}

	function add_quotation($db,$URL)
	{
		$Date  = time();				
		$Name   		= $_REQUEST['txtName'];
		$Email   		= $_REQUEST['txtEmail'];
		$Mobile   		= $_REQUEST['txtMobile'];
		$Remarks   		= $_REQUEST['txtRemarks'];
		$GrandTotalCost = $_REQUEST['txtGrandTotalCost'];
		
		$Query = $db->prepare("INSERT INTO quotations(name, email, mobile , remarks , totalamount , qdate) VALUES(?,?,?,?,?,?)");
		$Values = array($Name,$Email,$Mobile,$Remarks,$GrandTotalCost,$Date);
		if($Query->execute($Values))
		{
			$Qid = $db->lastInsertId();
			for ($i = 1; $i <= $_REQUEST['hdnNum']; $i++)
			{
				$Detail		 = "txtDetail$i";
				$Qty	 	 = "txtQty$i";
				$UnitCost 	 = "txtUnitCost$i";
				$TotalCost 	 = "txtTotalCost$i";
				$InvDetailQuery = $db->prepare("INSERT INTO qdetail(qid , qdetail , price , qty , totalprice , qdate) VALUES(?,?,?,?,?,?)");
				$InvDetailValues = array($Qid , $_REQUEST[$Detail] , $_REQUEST[$UnitCost] , $_REQUEST[$Qty] , $_REQUEST[$TotalCost] , $Date);
				
				if(!$InvDetailQuery->execute($InvDetailValues))
				{
					echo "\nPDO::errorInfo():\n";
					print_r($db->errorInfo());die;
				}
			}
			session_regenerate_id();
			header("Location: view_quotation.php?qid=$Qid&err=46");
		}
	}
	
	function pdf_quotation($db,$URL,$qid)
	{
		$message = '<table align="center" style="font-family: arial;" width="850" cellspacing="0" cellpadding="0">
						<tr>
							<td width="650" align="left" valign="top">
								<img src="'.$URL.'/images/corios-logo.png" width="200">
								<br><br>
								<b>Building # 95/96, Street 8-C, Feroz Colony Outfall Road</b>
								<br>
								<b>Lahore</b>
								<br>
								<b>0300 4806769</b>
								<br>
								<b>0324 5131870</b>
							</td>';
		$query = $db->prepare("SELECT * FROM quotations WHERE qid = ?");
		$query->execute(array($qid));
		while($row = $query->fetch())
		{
		$message.=			'<td width="350" align="left" valign="top">
								
								<b>'.$row['name'].'</b>
								<br>
								<b>'.$row['email'].'</b>
								<br>
								<b>'.$row['mobile'].'</b>
								<br>
								<b>QIN-'.$row['qid'].' &nbsp;-&nbsp; '.date("d/m/Y",$row['qdate']).'</b>
								<br>
							</td>
						</tr>
					</table>
					<br><br>
					<table align="center" width="850" style="border: 1px solid #CCC; font-family: arial;">
						<tr class="title">
							<td style="border: 1px solid #CCC;" width="50" align="center" bgcolor="#54271D" height="25">&nbsp;<span style="color: #fff; font-weight: bold;">Sr No</span></td>
							<td style="border: 1px solid #CCC;" align="left" bgcolor="#54271D" height="15">&nbsp;<b style="color: white;">Details</b></td>
							<td style="border: 1px solid #CCC;" width="100" align="right" bgcolor="#54271D" height="15"><b style="color: white;">Price</b>&nbsp;</td>
							<td style="border: 1px solid #CCC;" width="50" align="center" bgcolor="#54271D" height="15"><b style="color: white;">Qty</b></td>
							<td style="border: 1px solid #CCC;" width="150" align="right" bgcolor="#54271D" height="15"><b style="color: white;">Total</b>&nbsp;</td>
						</tr>';
						$count = 0;
						$invquery = $db->prepare("SELECT * FROM qdetail WHERE qid = ?");
						$invquery->execute(array($qid));
						while($invrow = $invquery->fetch())
						{
							$count++;
							
		$message .=		'<tr>
							<td style="border: 1px solid #CCC;" align="center" class="title" style="color: #FFFFFF" height="25">&nbsp;'.$count.'</td>
							<td style="border: 1px solid #CCC;" align="left">&nbsp;'.$invrow['qdetail'].'</td>
							<td style="border: 1px solid #CCC;" align="right">'.number_format($invrow['price']).'&nbsp;</td>
							<td style="border: 1px solid #CCC;" align="center">'.$invrow['qty'].'</td>
							<td style="border: 1px solid #CCC;" align="right">'.number_format($invrow['totalprice']).'&nbsp;</td>
						</tr>';
						}	
		$message.=		'<tr>
							<td style="border: 1px solid #CCC;" align="right" height="35" colspan="4"><b>Total</b>&nbsp;</td>
							<td style="border: 1px solid #CCC;" align="right"> <b>'.number_format($row['totalamount']).'</b>&nbsp;</td>
						</tr>
					</table>
					<br><br>
					<table align="center" width="850" style="border: 1px solid #CCC; font-family: arial;">
						<tr class="footer" style="background-color: #107E7F">
							<td align="center" colspan="2">
								<span style="font-size: 12px; color: #fff; font-weight: bold;">	
									Thanks for Doing Business With Us <br> We are Always Happy to Serve You
								</span>
							</td>
						</tr>
					</table>';
			
			///////////////// PDF Creation //////////////////////////

			require_once __DIR__ . '/vendor/autoload.php';
			$mpdf = new \Mpdf\Mpdf();
			$pdf_file_name = "GITMIT Quotation QIN-".$row['qid'].".pdf";

			$mpdf->WriteHTML($message);
			$mpdf->Output($pdf_file_name,"D");
			die;
        	////////////////////////////////////////////////////////
			header("Location: view_quotation.php?qid=".$row['qid']."&err=48");
		}
	}

	function email_quotation($db,$URL,$qid)
	{
		$message = '<table align="center" style="font-family: arial;" width="850" cellspacing="0" cellpadding="0">
						<tr>
							<td width="650" align="left" valign="top">
								<img src="'.$URL.'/images/corios-logo.png" width="200">
								<br><br>
								<b>Building # 95/96, Street 8-C, Feroz Colony Outfall Road</b>
								<br>
								<b>Lahore</b>
								<br>
								<b>0300 4806769</b>
								<br>
								<b>0324 5131870</b>
							</td>';
		$query = $db->prepare("SELECT * FROM quotations WHERE qid = ?");
		$query->execute(array($qid));
		while($row = $query->fetch())
		{
		$message.=			'<td width="350" align="left" valign="top">
								
								<b>'.$row['name'].'</b>
								<br>
								<b>'.$row['email'].'</b>
								<br>
								<b>'.$row['mobile'].'</b>
								<br>
								<b>QIN-'.$row['qid'].' &nbsp;-&nbsp; '.date("d/m/Y",$row['qdate']).'</b>
								<br>
							</td>
						</tr>
					</table>
					<br><br>
					<table align="center" width="850" style="border: 1px solid #CCC; font-family: arial;">
						<tr class="title">
							<td style="border: 1px solid #CCC;" width="50" align="center" bgcolor="#54271D" height="25">&nbsp;<span style="color: #fff; font-weight: bold;">Sr No</span></td>
							<td style="border: 1px solid #CCC;" align="left" bgcolor="#54271D" height="15">&nbsp;<b style="color: white;">Details</b></td>
							<td style="border: 1px solid #CCC;" width="100" align="right" bgcolor="#54271D" height="15"><b style="color: white;">Price</b>&nbsp;</td>
							<td style="border: 1px solid #CCC;" width="50" align="center" bgcolor="#54271D" height="15"><b style="color: white;">Qty</b></td>
							<td style="border: 1px solid #CCC;" width="150" align="right" bgcolor="#54271D" height="15"><b style="color: white;">Total</b>&nbsp;</td>
						</tr>';
						$count = 0;
						$invquery = $db->prepare("SELECT * FROM qdetail WHERE qid = ?");
						$invquery->execute(array($qid));
						while($invrow = $invquery->fetch())
						{
							$count++;
							
		$message .=		'<tr>
							<td style="border: 1px solid #CCC;" align="center" class="title" style="color: #FFFFFF" height="25">&nbsp;'.$count.'</td>
							<td style="border: 1px solid #CCC;" align="left">&nbsp;'.$invrow['qdetail'].'</td>
							<td style="border: 1px solid #CCC;" align="right">'.number_format($invrow['price']).'&nbsp;</td>
							<td style="border: 1px solid #CCC;" align="center">'.$invrow['qty'].'</td>
							<td style="border: 1px solid #CCC;" align="right">'.number_format($invrow['totalprice']).'&nbsp;</td>
						</tr>';
						}	
		$message.=		'<tr>
							<td style="border: 1px solid #CCC;" align="right" height="35" colspan="4"><b>Total</b>&nbsp;</td>
							<td style="border: 1px solid #CCC;" align="right"> <b>'.number_format($row['totalamount']).'</b>&nbsp;</td>
						</tr>
					</table>
					<br><br>
					<table align="center" width="850" style="border: 1px solid #CCC; font-family: arial;">
						<tr class="footer" style="background-color: #107E7F">
							<td align="center" colspan="2">
								<span style="font-size: 12px; color: #fff; font-weight: bold;">	
									Thanks for Doing Business With Us <br> We are Always Happy to Serve You
								</span>
							</td>
						</tr>
					</table>';
			
			///////////////// PDF Creation //////////////////////////
			require_once __DIR__ . '/vendor/autoload.php';
			$mpdf = new \Mpdf\Mpdf();
			$pdf_file_name = "GITMIT Quotation QIN-".$row['qid'].".pdf";

			$mpdf->WriteHTML($message);
			$mpdf->Output($pdf_file_name,"F");
			
        	////////////////////////////////////////////////////////
			
			require("phpmailer/PHPMailerAutoload.php");

			$mail = new PHPMailer;
			   
			$mail->setFrom('sales@gitmit.com', 'GITMIT CO-WORKING SPACE');
			$mail->addAddress($row['email']);            // Name is optional
			$mail->addBCC('mumtaz@lanwan.com.au');
			$mail->addAttachment($pdf_file_name,$pdf_file_name);  	  // Add attachments
			$mail->isHTML(true);                                  	  // Set email format to HTML

			$mail->Subject = "Customer Quotation QIN-".$row['qid']."";
			$mail->Body    = $message;
			$mail->AltBody = "This is the body in plain text for non-HTML mail clients";

		  	if(!$mail->send()) {
		    	echo 'Message could not be sent.';
		    	echo 'Mailer Error: ' . $mail->ErrorInfo;
		  	} else {
		  		unlink($pdf_file_name);

		  		///////////////////// LOG SECTION /////////////////////
			    $log = "Customer Quotation QIN-".$row['qid']." Created";
				log_entry($log);
			    ///////////////////////////////////////////////////////
		    	header("Location: view_quotation.php?qid=".$row['qid']."&err=48");
		  	}
		}
	}

	function cancel_quotation($db,$URL)
	{
		$delquery = $db->prepare("DELETE FROM temp_qdetail WHERE sessionid = ?");
		$delquery->execute(array(session_id()));

		header("Location: quotations.php?&err=47");
	}

	
	function ticket_reply($db,$URL,$tid)
	{
		$Date = time();
		
		if($_REQUEST['cboStatus'] == 4) { $status = 4; } else{ $status = 2; }

		$query1 = $db->prepare("INSERT INTO ticket_reply(tid , reply , trdate) VALUES(?,?,?)");
		$values1 = array($tid , $_REQUEST['txtMessage'] , $Date);
		
		$query2 = $db->prepare("UPDATE tickets SET tstatus = ? WHERE tid=?");
		$values2 = array($status,$tid);

		if($query1->execute($values1) && $query2->execute($values2))
		{
			///////////////////// LOG SECTION /////////////////////
		    $log = "Ticket# $tid reply sent";
			log_entry($log);
		    ///////////////////////////////////////////////////////
			header("Location: view_ticket.php?tid=$tid&err=51");		
		}	
	}

	///////////// Check for Conference Room Amenity Entry ////////////////

	function chk_booking_amenity($db,$URL)
	{
		//	Amenity Type == "2" == "Meetin Room Hrs"; }
		//	Amenity Type == "3" == "Conference Room Hrs"; }
		$Date = time();
		
		$bquery = $db->prepare("SELECT * FROM booking WHERE bookdate < $Date AND bstatus = 0");
		$bquery->execute();
		while($brow = $bquery->fetch())
		{
			$aid   = $brow['aid'];
			$subid = $brow['subid'];
			$bid   = $brow['bid'];
			$slid  = $brow['slid'];
			
			if($brow['btype'] == 1) { $amenity_type = 3;} else{ $amenity_type = 2;}
			$numhrs = $brow['numhrs'];
			
			$query1 = $db->prepare("INSERT INTO amenity_log(aid,subid,bid,amtype,slid,amvalue,amdate) VALUES(?,?,?,?,?,?,?)");
			$values1 = array($aid,$subid,$bid,$amenity_type,$slid,$numhrs,$Date);

			$query2 = $db->prepare("UPDATE booking SET bstatus = ? WHERE bid = ?");
			$values2 = array(1,$bid);			
			
			$query1->execute($values1);
			$query2->execute($values2);
		}
	}
	//////////////////////////////////////////////////////////////////////

	function add_conference($db,$URL)
	{
		$Date = time();
		if($_REQUEST['txtTitle'] != "") { $title = $_REQUEST['txtTitle']; } else{ $title = "Busy"; }
	    
	    $aid   = $_REQUEST['cboCustomer'];
	    $subid = $_REQUEST['cboMembership'];
	    $slid  = $_REQUEST['cboSlot'];

	    $book_date = str_replace("/", "-", $_REQUEST['txtBookDate']);
	    
	    $from_time = $_REQUEST['cboFromHrs'].":".$_REQUEST['cboFromMins'];
	    $to_time   = $_REQUEST['cboToHrs'].":".$_REQUEST['cboToMins'];
	    
	    $bookdate_from = strtotime($book_date." ".$from_time);
	    $bookdate_to   = strtotime($book_date." ".$to_time);
	    $totalhrs = $bookdate_to - $bookdate_from;
	    $totalhrs = $totalhrs / 3600;
	    $status = $_REQUEST['cboStatus'];

	    $slquery = $db->prepare("SELECT * FROM slots WHERE slid=?");
	    $slquery->execute(array($slid));
	    while($slrow = $slquery->fetch())
	    {
	    	$sltitle = $slrow['sltitle'];
	    }

	    $cquery = $db->prepare("SELECT * FROM accounts WHERE aid=?");
	    $cquery->execute(array($aid));
	    while($crow = $cquery->fetch())
	    {
	    	$gtno = $crow['gtno'];
	    	$name = $crow['aname'];
	    	$email = $crow['aemail'];
	    }

	    $message = '<table align="center" width="850" cellspacing="0" cellpadding="0">
						<tr>
							<td align="center">
								<img src="'.$URL.'/images/voucher_header.jpg" width="650">
							</td>
						</tr>
						<tr><td>&nbsp;</td></tr>
					</table>
					<table style="font-family:arial;" cellpadding="0" cellspacing="0" align="center" width="850" border="1" style="border: 1px solid #eee;">
						<tr class="title">
							<td width="50" colspan="2" align="center" bgcolor="#54271D" height="35">&nbsp;<span class="title-font" style="color:white;">Conference Room Booking Receipt</span></td>
						</tr>
						<tr>
							<td align="left" width="200" class="title" height="35">&nbsp;<b>Conference Room</b></td>
							<td align="left" class="title" height="35">&nbsp;'.$sltitle.'</td>
						</tr>
						<tr>
							<td align="left" width="200" class="title" height="35">&nbsp;<b>Title</b></td>
							<td align="left" class="title" height="35">&nbsp;'.$title.'</td>
						</tr>
						<tr>
							<td align="left" width="200" class="title" height="35">&nbsp;<b>Cutomer</b></td>
							<td align="left" class="title" height="35">&nbsp;'.$gtno.' '.$name.' - '.$email.'</td>
						</tr>
						<tr>
							<td align="left" width="200" class="title" height="35">&nbsp;<b>Booking Date</b></td>
							<td align="left" class="title" height="35">&nbsp;'.$_REQUEST['txtBookDate'].'</td>
						</tr>
						<tr>
							<td align="left" width="200" class="title" height="35">&nbsp;<b>Timings</b></td>
							<td align="left" class="title" height="35">&nbsp;'.date("h:i A",$bookdate_from).' to '.date("h:i A",$bookdate_to).'</td>
						</tr>
						
						<tr>
							<td align="left" class="title" height="35">&nbsp;<b>Number of Hrs</b></td>
							<td align="left" class="title" height="35">&nbsp;'.number_format($totalhrs).'</td>
						</tr>
						<tr>
							<td align="left" class="title" height="35">&nbsp;<b>Date Created</b></td>
							<td align="left" class="title" height="35">&nbsp;'.date("d/m/Y",$Date).'</td>
						</tr>
					</table>';
		
	    if($bookdate_to < $bookdate_from)
	    {
	    	header("Location: addconference_log.php?err=53"); die; 
	    }

	    $chkquery = $db->prepare("SELECT * FROM booking WHERE (btype = 1 AND slid = $slid) AND (btimefrom BETWEEN $bookdate_from + 1 AND $bookdate_to + 1 OR btimeto BETWEEN $bookdate_from + 1 AND $bookdate_to + 1)");
	    $chkquery->execute();
	    if($chkquery->rowCount() > 0)
	    {
	    	header("Location: addconference_log.php?err=54"); die; 
	    }

	    $Query = $db->prepare("INSERT INTO booking(subid,aid,slid,btype,btitle,bookdate,btimefrom,btimeto,numhrs,bdate) VALUES(?,?,?,?,?,?,?,?,?,?)");
	    $Values = array($subid,$aid,$slid,1,$title,strtotime($book_date),$bookdate_from,$bookdate_to,$totalhrs,$Date);
	    if($Query->execute($Values))
	    {
	    	$bid = $db->lastInsertId();

	    	if($bookdate_from < $Date)
		    {
		    	$amquery = $db->prepare('INSERT INTO amenity_log(aid,subid,bid,amtype,slid,amvalue,amdate) VALUES(?,?,?,?,?,?,?)');
		    	$amvalues = array($aid,$subid,$bid,3,$slid,$totalhrs,$Date);
		    	if($amquery->execute($amvalues))
		    	{
		    		$bquery = $db->prepare("UPDATE booking SET bstatus = ? WHERE bid=?");
		    		$bquery->execute(array(1,$bid));
		    	}
		    }

	    	require("phpmailer/PHPMailerAutoload.php");

	    	//// Send Conference Booking Email to Customer
			$mail = new PHPMailer;
			   
			$mail->setFrom('no_reply@gitmit.com', 'GITMIT CO-WORKING SPACE');
			$mail->addAddress($email);            // Name is optional
			$mail->addBCC('mumtaz@lanwan.com.au');
			$mail->isHTML(true);                                  	  // Set email format to HTML

			$mail->Subject = "Conference Room Booking Confirmation";
			$mail->Body    = $message;
			$mail->AltBody = "This is the body in plain text for non-HTML mail clients";
		  	$mail->send();

	    	///////////////////// LOG SECTION /////////////////////
		    $log = "Conference Room ($sltitle) booked for $gtno $name on ".$_REQUEST['txtBookDate']."";
			log_entry($log);
		    ///////////////////////////////////////////////////////
	        header("Location: editconference_log.php?bid=$bid&err=3");
	    }
	}

	function update_conference($db,$URL,$bid,$send_email)
	{
		$Date = time();
		
		$gtno  	  = $_REQUEST['hdngtno'];
		$name  	  = $_REQUEST['hdnname'];
	    $email = $_REQUEST['hdnemail'];

	    $subgtno  = $_REQUEST['hdnsubgtno'];
	    $subtitle = $_REQUEST['hdnsubtitle'];
	    $sltitle = $_REQUEST['hdnsltitle'];

		if($_REQUEST['title'] != "") { $title = $_REQUEST['title']; } else{ $title = "Busy"; }
	    
	    $book_date = str_replace("/", "-", $_REQUEST['book_date']);
	    
	    $from_time = $_REQUEST['fromhrs'].":".$_REQUEST['frommins'];
	    $to_time   = $_REQUEST['tohrs'].":".$_REQUEST['tomins'];
	    
	    $bookdate_from = strtotime($book_date." ".$from_time);
	    $bookdate_to   = strtotime($book_date." ".$to_time);
	    
	    $totalhrs = $bookdate_to - $bookdate_from;
	    $totalhrs = $totalhrs / 3600;
	    
	    /// Previous Booking Timmings ///

	    $hdnfromhrs  = $_REQUEST['hdnfromtime'];
	    $hdnfrommins = $_REQUEST['hdnfrommins'];

	    $hdntohrs  = $_REQUEST['hdntotime'];
	    $hdntomins = $_REQUEST['hdntomins'];

	    $hdnfrom_time = $hdnfromhrs.":".$hdnfrommins;
	    $hdnto_time   = $hdntohrs.":".$hdntomins;

	    $hdnbookdate_from = strtotime($book_date." ".$hdnfrom_time);
	    $hdnbookdate_to   = strtotime($book_date." ".$hdnto_time);
	    
	    

	    $hdnnumhrs = $_REQUEST['hdnnumhrs'];
	    
	    if($from_time == $hdnfromhrs.":".$hdnfrommins && $to_time == $hdntohrs.":".$hdntomins)
	    {
	    	$hrs_difference = number_format($hdnnumhrs,2);	
	    }
	    else
	    {
	    	$hrs_difference = number_format($totalhrs,2);
	    }

	  //  echo("previous: $hdnfromhrs:$hdnfrommins | $hdntohrs:$hdntomins = $hdnnumhrs <br> current: $from_time | $to_time = $totalhrs <br> Hrs Difference = $hrs_difference");
	  //  die;

	    $message = '<table align="center" width="850" cellspacing="0" cellpadding="0">
						<tr>
							<td align="center">
								<img src="'.$URL.'/images/voucher_header.jpg" width="650">
							</td>
						</tr>
						<tr><td>&nbsp;</td></tr>
					</table>
					<table style="font-family:arial;" cellpadding="0" cellspacing="0" align="center" width="850" border="1" style="border: 1px solid #eee;">
						<tr class="title">
							<td width="50" colspan="2" align="center" bgcolor="#54271D" height="35">&nbsp;<span class="title-font" style="color:white;">Conference Room Booking Update</span></td>
						</tr>
						<tr>
							<td align="left" width="200" class="title" height="35">&nbsp;<b>Conference Room</b></td>
							<td align="left" class="title" height="35">&nbsp;'.$sltitle.'</td>
						</tr>
						<tr>
							<td align="left" width="200" class="title" height="35">&nbsp;<b>Title</b></td>
							<td align="left" class="title" height="35">&nbsp;'.$title.'</td>
						</tr>
						<tr>
							<td align="left" width="200" class="title" height="35">&nbsp;<b>Cutomer</b></td>
							<td align="left" class="title" height="35">&nbsp;'.$gtno.' '.$name.' - '.$email.'</td>
						</tr>
						<tr>
							<td align="left" width="200" class="title" height="35">&nbsp;<b>Booking Date</b></td>
							<td align="left" class="title" height="35">&nbsp;'.$_REQUEST['book_date'].'</td>
						</tr>
						<tr>
							<td align="left" width="200" class="title" height="35">&nbsp;<b>Previous Timings</b></td>
							<td align="left" class="title" height="35">&nbsp;'.date("h:i A",$hdnbookdate_from).' to '.date("h:i A",$hdnbookdate_to).'</td>
						</tr>
						<tr>
							<td align="left" width="200" class="title" height="35">&nbsp;<b>Updated Timings</b></td>
							<td align="left" class="title" height="35">&nbsp;'.date("h:i A",$bookdate_from).' to '.date("h:i A",$bookdate_to).'</td>
						</tr>
						<tr>
							<td align="left" class="title" height="35">&nbsp;<b>Number of Hrs</b></td>
							<td align="left" class="title" height="35">&nbsp;'.$hrs_difference.'</td>
						</tr>
						<tr>
							<td align="left" class="title" height="35">&nbsp;<b>Date Updated</b></td>
							<td align="left" class="title" height="35">&nbsp;'.date("d/m/Y",$Date).'</td>
						</tr>
					</table>';
		//echo($message);die;
	    /*
	    if($bookdate_from < $Date)
	    {
	      header("Location: editconference_log.php?bid=$bid&err=52"); die; 
	    }
		*/
	    if($bookdate_to < $bookdate_from)
	    {
	      header("Location: editconference_log.php?bid=$bid&err=53"); die; 
	    }

	    $chkquery = $db->prepare("SELECT * FROM booking WHERE (btype = 1 AND slid = $slid AND bid <> $bid) AND (btimefrom BETWEEN $bookdate_from AND $bookdate_to OR btimeto BETWEEN $bookdate_from AND $bookdate_to)");
	    $chkquery->execute();
	    if($chkquery->rowCount() > 0)
	    {
	      header("Location: editconference_log.php?bid=$bid&err=54"); die; 
	    }

	    $amQuery = $db->prepare("SELECT * FROM amenity_log WHERE bid = ?");
	    $amQuery->execute(array($bid));
	    if($amQuery->rowCount() > 0)
	    {
	    	$aQuery = $db->prepare("UPDATE amenity_log SET amvalue=? WHERE bid=?");
	    	$aQuery->execute(array($hrs_difference,$bid));
	    }

	    $Query = $db->prepare("UPDATE booking SET btitle=?, bookdate=?, btimefrom=?, btimeto=?, numhrs=? WHERE bid=?");
	    $Values = array($title,strtotime($book_date),$bookdate_from,$bookdate_to,$hrs_difference,$bid);
	    if($Query->execute($Values))
	    {
	    	if($send_email == 1)
	    	{
	    		require("phpmailer/PHPMailerAutoload.php");
		    	//// Send Conference Booking Email to Customer
				$mail = new PHPMailer;			   
				$mail->setFrom('no_reply@gitmit.com', 'GITMIT CO-WORKING SPACE');
				$mail->addAddress($email);            // Name is optional
				$mail->addBCC('mumtaz@lanwan.com.au');
				$mail->isHTML(true);                                  	  // Set email format to HTML

				$mail->Subject = "Conference Room Booking Modified";
				$mail->Body    = $message;
				$mail->AltBody = "This is the body in plain text for non-HTML mail clients";
			  	$mail->send();	
	    	}
	    	
	    	///////////////////// LOG SECTION /////////////////////
		    $log = "Conference Room ($sltitle) booked for $gtno $name on ".$_REQUEST['txtBookDate']." has been updated";
			log_entry($log);
		    ///////////////////////////////////////////////////////
	        header("Location: editconference_log.php?bid=$bid&err=3");
	    }
	}

	function add_meeting($db,$URL)
	{
		$Date = time();
		if($_REQUEST['txtTitle'] != "") { $title = $_REQUEST['txtTitle']; } else{ $title = "Busy"; }
	    
	    $aid   = $_REQUEST['cboCustomer'];
	    $subid = $_REQUEST['cboMembership'];
	    $slid  = $_REQUEST['cboSlot'];
	    $book_date = str_replace("/", "-", $_REQUEST['txtBookDate']);
	    $from_time = $_REQUEST['cboFromHrs'].":".$_REQUEST['cboFromMins'];
	    $to_time   = $_REQUEST['cboToHrs'].":".$_REQUEST['cboToMins'];
	    $bookdate_from = strtotime($book_date." ".$from_time);
	    $bookdate_to   = strtotime($book_date." ".$to_time);
	    $totalhrs = $bookdate_to - $bookdate_from;
	    $totalhrs = $totalhrs / 3600;
	    $status = $_REQUEST['cboStatus'];

	    $slquery = $db->prepare("SELECT * FROM slots WHERE slid=?");
	    $slquery->execute(array($slid));
	    while($slrow = $slquery->fetch())
	    {
	    	$sltitle = $slrow['sltitle'];
	    }

	    $cquery = $db->prepare("SELECT * FROM accounts WHERE aid=?");
	    $cquery->execute(array($aid));
	    while($crow = $cquery->fetch())
	    {
	    	$gtno = $crow['gtno'];
	    	$name = $crow['aname'];
	    	$email = $crow['aemail'];
	    }

	    $message = '<table align="center" width="850" cellspacing="0" cellpadding="0">
						<tr>
							<td align="center">
								<img src="'.$URL.'/images/voucher_header.jpg" width="650">
							</td>
						</tr>
						<tr><td>&nbsp;</td></tr>
					</table>
					<table style="font-family:arial;" cellpadding="0" cellspacing="0" align="center" width="850" border="1" style="border: 1px solid #eee;">
						<tr class="title">
							<td width="50" colspan="2" align="center" bgcolor="#54271D" height="35">&nbsp;<span class="title-font" style="color:white;">Meeting Room Booking Receipt</span></td>
						</tr>
						<tr>
							<td align="left" width="200" class="title" height="35">&nbsp;<b>Meeting Room</b></td>
							<td align="left" class="title" height="35">&nbsp;'.$sltitle.'</td>
						</tr>
						<tr>
							<td align="left" width="200" class="title" height="35">&nbsp;<b>Title</b></td>
							<td align="left" class="title" height="35">&nbsp;'.$title.'</td>
						</tr>
						<tr>
							<td align="left" width="200" class="title" height="35">&nbsp;<b>Cutomer</b></td>
							<td align="left" class="title" height="35">&nbsp;'.$gtno.' '.$name.' - '.$email.'</td>
						</tr>
						<tr>
							<td align="left" width="200" class="title" height="35">&nbsp;<b>Booking Date</b></td>
							<td align="left" class="title" height="35">&nbsp;'.$_REQUEST['txtBookDate'].'</td>
						</tr>
						<tr>
							<td align="left" width="200" class="title" height="35">&nbsp;<b>Timings</b></td>
							<td align="left" class="title" height="35">&nbsp;'.date("h:i A",$bookdate_from).' to '.date("h:i A",$bookdate_to).'</td>
						</tr>
						<tr>
							<td align="left" class="title" height="35">&nbsp;<b>Number of Hrs</b></td>
							<td align="left" class="title" height="35">&nbsp;'.number_format($totalhrs).'</td>
						</tr>
						<tr>
							<td align="left" class="title" height="35">&nbsp;<b>Date Created</b></td>
							<td align="left" class="title" height="35">&nbsp;'.date("d/m/Y",$Date).'</td>
						</tr>
					</table>';

		/*
	    if($bookdate_from < $Date)
	    {
	      header("Location: addmeeting_log.php?err=52"); die; 
	    }
		*/
	    if($bookdate_to < $bookdate_from)
	    {
	      header("Location: addmeeting_log.php?err=53"); die; 
	    }

	    $chkquery = $db->prepare("SELECT * FROM booking WHERE (btype = 1 AND slid = $slid) AND (btimefrom BETWEEN $bookdate_from AND $bookdate_to OR btimeto BETWEEN $bookdate_from AND $bookdate_to)");
	    $chkquery->execute();
	    if($chkquery->rowCount() > 0)
	    {
	      header("Location: addmeeting_log.php?err=54"); die; 
	    }

	    $Query = $db->prepare("INSERT INTO booking(subid,aid,slid,btype,btitle,bookdate,btimefrom,btimeto,numhrs,bdate) VALUES(?,?,?,?,?,?,?,?,?,?)");
	    $Values = array($subid,$aid,$slid,2,$title,strtotime($book_date),$bookdate_from,$bookdate_to,$totalhrs,$Date);
	    if($Query->execute($Values))
	    {
	    	$bid = $db->lastInsertId();

	    	if($bookdate_from < $Date)
		    {
		    	$amquery = $db->prepare('INSERT INTO amenity_log(aid,subid,bid,amtype,slid,amvalue,amdate) VALUES(?,?,?,?,?,?,?)');
		    	$amvalues = array($aid,$subid,$bid,2,$slid,$totalhrs,$Date);
		    	if($amquery->execute($amvalues))
		    	{
		    		$bquery = $db->prepare("UPDATE booking SET bstatus = ? WHERE bid=?");
		    		$bquery->execute(array(1,$bid));
		    	}
		    }

	    	require("phpmailer/PHPMailerAutoload.php");

	    	//// Send Conference Booking Email to Customer
			$mail = new PHPMailer;			   
			$mail->setFrom('no_reply@gitmit.com', 'GITMIT CO-WORKING SPACE');
			$mail->addAddress($email);            // Name is optional
			$mail->addBCC('mumtaz@lanwan.com.au');
			$mail->isHTML(true);                                  	  // Set email format to HTML

			$mail->Subject = "Meeting Room Booking Confirmation";
			$mail->Body    = $message;
			$mail->AltBody = "This is the body in plain text for non-HTML mail clients";
		  	$mail->send();

	    	///////////////////// LOG SECTION /////////////////////
		    $log = "Meeting Room ($sltitle) booked for $gtno $name on ".$_REQUEST['txtBookDate']."";
			log_entry($log);
		    ///////////////////////////////////////////////////////
	        header("Location: editmeeting_log.php?bid=$bid&err=3");
	    }
	}

	function update_meeting($db,$URL,$bid,$send_email)
	{
		$Date = time();
		
		$gtno  	  = $_REQUEST['hdngtno'];
		$name  	  = $_REQUEST['hdnname'];
	    $email = $_REQUEST['hdnemail'];

	    $subgtno  = $_REQUEST['hdnsubgtno'];
	    $subtitle = $_REQUEST['hdnsubtitle'];
	    $sltitle = $_REQUEST['hdnsltitle'];

		if($_REQUEST['title'] != "") { $title = $_REQUEST['title']; } else{ $title = "Busy"; }
	    
	    $book_date = str_replace("/", "-", $_REQUEST['book_date']);
	    
	    $from_time = $_REQUEST['fromhrs'].":".$_REQUEST['frommins'];
	    $to_time   = $_REQUEST['tohrs'].":".$_REQUEST['tomins'];
	    
	    $bookdate_from = strtotime($book_date." ".$from_time);
	    $bookdate_to   = strtotime($book_date." ".$to_time);
	    
	    $totalhrs = $bookdate_to - $bookdate_from;
	    $totalhrs = $totalhrs / 3600;
	    
	    /// Previous Booking Timmings ///

	    $hdnfromhrs  = $_REQUEST['hdnfromtime'];
	    $hdnfrommins = $_REQUEST['hdnfrommins'];

	    $hdntohrs  = $_REQUEST['hdntotime'];
	    $hdntomins = $_REQUEST['hdntomins'];

	    $hdnfrom_time = $hdnfromhrs.":".$hdnfrommins;
	    $hdnto_time   = $hdntohrs.":".$hdntomins;

	    $hdnbookdate_from = strtotime($book_date." ".$hdnfrom_time);
	    $hdnbookdate_to   = strtotime($book_date." ".$hdnto_time);
	    
	    $hdnnumhrs = $_REQUEST['hdnnumhrs'];
	    
	    if($from_time == $hdnfromhrs.":".$hdnfrommins && $to_time == $hdntohrs.":".$hdntomins)
	    {
	    	$hrs_difference = number_format($hdnnumhrs,2);	
	    }
	    else
	    {
	    	$hrs_difference = number_format($totalhrs,2);
	    }

	  //  echo("previous: $hdnfromhrs:$hdnfrommins | $hdntohrs:$hdntomins = $hdnnumhrs <br> current: $from_time | $to_time = $totalhrs <br> Hrs Difference = $hrs_difference");
	  //  die;

	    $message = '<table align="center" width="850" cellspacing="0" cellpadding="0">
						<tr>
							<td align="center">
								<img src="'.$URL.'/images/voucher_header.jpg" width="650">
							</td>
						</tr>
						<tr><td>&nbsp;</td></tr>
					</table>
					<table style="font-family:arial;" cellpadding="0" cellspacing="0" align="center" width="850" border="1" style="border: 1px solid #eee;">
						<tr class="title">
							<td width="50" colspan="2" align="center" bgcolor="#54271D" height="35">&nbsp;<span class="title-font" style="color:white;">Meeting Room Booking Update</span></td>
						</tr>
						<tr>
							<td align="left" width="200" class="title" height="35">&nbsp;<b>Meeting Room</b></td>
							<td align="left" class="title" height="35">&nbsp;'.$sltitle.'</td>
						</tr>
						<tr>
							<td align="left" width="200" class="title" height="35">&nbsp;<b>Title</b></td>
							<td align="left" class="title" height="35">&nbsp;'.$title.'</td>
						</tr>
						<tr>
							<td align="left" width="200" class="title" height="35">&nbsp;<b>Cutomer</b></td>
							<td align="left" class="title" height="35">&nbsp;'.$gtno.' '.$name.' - '.$email.'</td>
						</tr>
						<tr>
							<td align="left" width="200" class="title" height="35">&nbsp;<b>Booking Date</b></td>
							<td align="left" class="title" height="35">&nbsp;'.$_REQUEST['book_date'].'</td>
						</tr>
						<tr>
							<td align="left" width="200" class="title" height="35">&nbsp;<b>Previous Timings</b></td>
							<td align="left" class="title" height="35">&nbsp;'.date("h:i A",$hdnbookdate_from).' to '.date("h:i A",$hdnbookdate_to).'</td>
						</tr>
						<tr>
							<td align="left" width="200" class="title" height="35">&nbsp;<b>Updated Timings</b></td>
							<td align="left" class="title" height="35">&nbsp;'.date("h:i A",$bookdate_from).' to '.date("h:i A",$bookdate_to).'</td>
						</tr>
						<tr>
							<td align="left" class="title" height="35">&nbsp;<b>Number of Hrs</b></td>
							<td align="left" class="title" height="35">&nbsp;'.$hrs_difference.'</td>
						</tr>
						<tr>
							<td align="left" class="title" height="35">&nbsp;<b>Date Updated</b></td>
							<td align="left" class="title" height="35">&nbsp;'.date("d/m/Y",$Date).'</td>
						</tr>
					</table>';
		//echo($message);die;
	    /*
	    if($bookdate_from < $Date)
	    {
	      header("Location: editconference_log.php?bid=$bid&err=52"); die; 
	    }
		*/
	    if($bookdate_to < $bookdate_from)
	    {
	      header("Location: editmeeting_log.php?bid=$bid&err=53"); die; 
	    }

	    $chkquery = $db->prepare("SELECT * FROM booking WHERE (btype = 2 AND slid = $slid AND bid <> $bid) AND (btimefrom BETWEEN $bookdate_from AND $bookdate_to OR btimeto BETWEEN $bookdate_from AND $bookdate_to)");
	    $chkquery->execute();
	    if($chkquery->rowCount() > 0)
	    {
	      header("Location: editmeeting_log.php?bid=$bid&err=54"); die; 
	    }

	    $amQuery = $db->prepare("SELECT * FROM amenity_log WHERE bid = ?");
	    $amQuery->execute(array($bid));
	    if($amQuery->rowCount() > 0)
	    {
	    	$aQuery = $db->prepare("UPDATE amenity_log SET amvalue=? WHERE bid=?");
	    	$aQuery->execute(array($hrs_difference,$bid));
	    }

	    $Query = $db->prepare("UPDATE booking SET btitle=?, bookdate=?, btimefrom=?, btimeto=?, numhrs=? WHERE bid=?");
	    $Values = array($title,strtotime($book_date),$bookdate_from,$bookdate_to,$hrs_difference,$bid);
	    if($Query->execute($Values))
	    {
	    	if($send_email == 1)
	    	{
	    		require("phpmailer/PHPMailerAutoload.php");
		    	//// Send Conference Booking Email to Customer
				$mail = new PHPMailer;			   
				$mail->setFrom('no_reply@gitmit.com', 'GITMIT CO-WORKING SPACE');
				$mail->addAddress($email);            // Name is optional
				$mail->addBCC('mumtaz@lanwan.com.au');
				$mail->isHTML(true);                                  	  // Set email format to HTML

				$mail->Subject = "Meeting Room Booking Modified";
				$mail->Body    = $message;
				$mail->AltBody = "This is the body in plain text for non-HTML mail clients";
			  	$mail->send();	
	    	}
	    	
	    	///////////////////// LOG SECTION /////////////////////
		    $log = "Meeting Room ($sltitle) booked for $gtno $name on ".$_REQUEST['txtBookDate']." has been updated";
			log_entry($log);
		    ///////////////////////////////////////////////////////
	        header("Location: editmeeting_log.php?bid=$bid&err=3");
	    }
	}

	function delete_booking($db,$URL,$bid,$btype)
	{
		$query1 = $db->prepare("DELETE FROM booking WHERE bid=?");		
		if($query1->execute(array($bid)))
		{
			if($btype == 1)
			{
				header("Location: conference_log.php?err=4");die;		
			}
			else
			{
				header("Location: meeting_log.php?err=4");die;		
			}
		}
	}

	function random_strings($length_of_string) 
	{ 
	    // String of all alphanumeric character 
	    $str_result = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz'; 
	    // Shufle the $str_result and returns substring of specified length
	    return substr(str_shuffle($str_result),0, $length_of_string); 
	}

	function add_notification($db,$URL)
	{
		require("phpmailer/PHPMailerAutoload.php");

		$Date = time();
		$aid 	 = implode(",", $_POST['cboCustomer']);
		$subject = $_REQUEST['txtSubject'];
		$message = $_REQUEST['txtMessage'];

		$query = $db->prepare("INSERT INTO notifications(aid, subject, message, ndate) VALUES(?,?,?,?)");
		$values = array($aid, $subject, $message , $Date);
		
		if($query->execute($values))
		{
			$explode_aid = explode(',',$aid);
			foreach($explode_aid as $cust_aid)
			{
				$cust_query = $db->prepare("SELECT * FROM accounts WHERE aid=?");
				$cust_query->execute(array($cust_aid));
				while($custrow = $cust_query->fetch())
				{
					$cust_name = $custrow['aname'];
					$cust_email = $custrow['aemail'];
				}
				//// Send Email To All Customer
				$mail = new PHPMailer;
				   
				$mail->setFrom('no_reply@gitmit.com', 'GITMIT CO-WORKING SPACE');
				$mail->addAddress($cust_email);            // Name is optional
				$mail->addBCC('mumtaz@lanwan.com.au');
				$mail->addAttachment($pdf_file_name,$pdf_file_name);  	  // Add attachments
				$mail->isHTML(true);                                  	  // Set email format to HTML

				$mail->Subject = "Customer Notification - $subject";
				$mail->Body    = $message;
				$mail->AltBody = "This is the body in plain text for non-HTML mail clients";
			  	$mail->send();
			}

			///////////////////// LOG SECTION /////////////////////
		    $log = "Notification : $subject Created";
			log_entry($log);
		    ///////////////////////////////////////////////////////
			header("Location: notifications.php?err=2");		
		}	
	}

	/////////////////  Update Page  ///////////////////////
	function update_page($db,$URL,$ID)
	{
		$Description = $_REQUEST['txtDescription'];
        $Query = $db->prepare("UPDATE pages SET description=? WHERE id=?");
		$values = array($Description, $ID);
	
		if($Query->execute($values))
		{
			header("Location: page.php?id=$ID&err=3");
			die;
		}
	}

	/////////////////  Create Pending Inoivce  ///////////////////////
	function add_pendinginvoice($db,$URL)
	{
		$Date = time();
		$month = $_REQUEST['cboMonth'];
		
		$remarks = "Membership Invoice for the Month of $month";
		$implode_subid  = implode(",", $_POST['cboMembership']);

		$explode_subid = explode(',',$implode_subid);
		foreach($explode_subid as $sub_id)
		{
			if($sub_id == 0)
			{
				$subquery = $db->prepare("SELECT * FROM subscriptions WHERE substatus = ? AND subarchived = ?");
				$subquery->execute(array(0,0));
			}
			else
			{
				$subquery = $db->prepare("SELECT * FROM subscriptions WHERE substatus = ? AND subarchived = ? AND subid=?");
				$subquery->execute(array(0,0,$sub_id));
			}
			while($subrow = $subquery->fetch())
			{
				$aid   = $subrow['aid'];
				$subid 	= $subrow['subid'];

				$subquery = $db->prepare("SELECT * FROM subscriptions WHERE aid = ? AND subid = ? AND substatus = ? AND  subarchived = ?");
				$subquery->execute(array($aid,$subid,0,0));
				while($subrow = $subquery->fetch())
				{
					$Date = time();
					$remarks = "Membership Invoice for the Month of ".date("F, Y")."";
					$aid   = $subrow['aid'];
					$subid 	= $subrow['subid'];

					$printlimit 	 = $subrow['printlimit'];
					$printrate 	 	 = $subrow['printrate'];

					$generatorlimit  = $subrow['generatorlimit'];
					$generatorrate   = $subrow['generatorrate'];	

					$electricitylimit = $subrow['electricitylimit'];
					$electricityrate  = $subrow['electricityrate'];	

					$gaslimit 		  = $subrow['gaslimit'];
					$gasrate 		  = $subrow['gasrate'];	

					$cardlimit 		  = $subrow['cardlimit'];
					$cardrate 		  = $subrow['cardrate'];

					$cardlostlimit 	  = $subrow['cardlostlimit'];
					$cardlostrate 	  = $subrow['cardlostrate'];	

					$pending_invoice = $db->prepare("SELECT * FROM pending_invoices WHERE aid=? AND subid=? AND remarks=?");
					$pending_invoice->execute(array($aid,$subid,$remarks));
					$num_pending_invoice = $pending_invoice->rowCount();

					$member_invoice = $db->prepare("SELECT * FROM invoices WHERE aid=? AND subid=? AND remarks=?");
					$member_invoice->execute(array($aid,$subid,$remarks));
					$num_member_invoice = $member_invoice->rowCount();

					if($num_pending_invoice == 0 && $num_member_invoice == 0)
					{
						$invquery = $db->prepare("INSERT INTO pending_invoices(aid, subid, remarks, pinvdate) VALUES(?,?,?,?)");
						$inv_values = array($aid,$subid,$remarks,$Date);
						if($invquery->execute($inv_values))
						{
							$pinvid = $db->lastInsertId();

							//// Total Active Additional Members ////
							$smquery = $db->prepare("SELECT * FROM submembers WHERE smname <> '' AND smarchived = 0 AND smstatus = 0 AND subid=$subid");
							$smquery->execute();
							$num_members = $smquery->rowCount(); // Note: All Addtional Members whos name are entered and there status and archived status is active will be counted in the invoice 

							$unitprice = $subrow['subunitprice'];
							$totalprice = $num_members * $unitprice;
							//////////////////////////////////////////

							// echo("Total Members: $num_members x $unitprice = $totalprice <br><br>");

							/// Total Memebers Entry
							
							$total_members_entry = "Total Members: $num_members x $unitprice = $totalprice";
							
							$invdquery1 = $db->prepare("INSERT INTO pending_invoicedetail(pinvid,invdetail,invprice,invqty,invtotalprice,pinvdate) VALUES(?,?,?,?,?,?)");
							$invdvalues1 = array($pinvid,$total_members_entry,$unitprice,$num_members,$totalprice,$Date);
							$invdquery1->execute($invdvalues1);

							//// Calculate Total Hours & Extra Price for Extra Hrs for Conference & Meeting Rooms ////

							$conquery = $db->prepare("SELECT aid,subid,slid,SUM(amvalue) total_qty FROM amenity_log WHERE slid <> ? AND aid=? AND subid=? AND is_charged=? GROUP BY slid");
							$conquery->execute(array(0,$aid,$subid,0));
							while($conrow = $conquery->fetch())
							{
								$slid 	   = $conrow['slid'];
								$total_qty = $conrow['total_qty'];

								///  Convert extra units to Hrs & Mins ///
								$total_seconds = $total_qty * 3600;

			                    $total_days = floor($total_seconds / 86400);
			                    $total_seconds %= 86400;

			                    $total_hours = floor($total_seconds / 3600);
			                    $total_seconds %= 3600;

			                    $total_minutes = floor($total_seconds / 60);
			                    $total_seconds %= 60;

			                    $total_time = str_pad($total_hours, 2, "0", STR_PAD_LEFT).":".str_pad($total_minutes, 2, "0", STR_PAD_LEFT);
			                    ////////////////////////////////////////////

								$subslquery = $db->prepare("SELECT * FROM subslots SS INNER JOIN slots S ON SS.slid = S.slid WHERE SS.slid=? AND SS.aid=? AND SS.subid=?");
								$subslquery->execute(array($slid,$aid,$subid));
								while($subslrow = $subslquery->fetch())
								{
									$sltitle = $subslrow['sltitle'];
									$sublimit = $subslrow['subsllimit'];
									$subrate  = $subslrow['subslrate'];
								}

								if($total_qty > $sublimit)
								{
									$extra_hrs = $total_qty - $sublimit;
									$extra_amount = round($subrate * $extra_hrs);

									if(strlen(substr(strrchr($extra_hrs, "."), 1)) != 0) { $extra_hrs = str_replace(",","",number_format($extra_hrs,2)); } else{ $extra_hrs = $extra_hrs; }
									//if(strlen(substr(strrchr($extra_amount, "."), 1)) != 0) { $extra_amount = str_replace(",","",number_format($extra_amount,2)); } else{ $extra_amount = $extra_amount; }

									///  Convert extra units to Hrs & Mins ///
									$extra_seconds = $extra_hrs * 3600;

				                    $extra_days = floor($extra_seconds / 86400);
				                    $extra_seconds %= 86400;

				                    $extra_hours = floor($extra_seconds / 3600);
				                    $extra_seconds %= 3600;

				                    $extra_minutes = floor($extra_seconds / 60);
				                    $extra_seconds %= 60;

				                    $extra_time = str_pad($extra_hours, 2, "0", STR_PAD_LEFT).":".str_pad($extra_minutes, 2, "0", STR_PAD_LEFT);
				                    ////////////////////////////////////////////

									// echo("$sltitle : Rate = $subrate  ||  Limit = $sublimit || Consumed = $total_qty || $total_qty - $sublimit = $extra_hrs * $subrate = $extra_amount <br><br>");

									/// Total Conference & Meeting Room Hrs Entry ///
									$hrs_detail = "$sltitle : Rate = $subrate  ||  Limit = ".str_pad($sublimit, 2, "0", STR_PAD_LEFT).":00 || Consumed = $total_time || $total_time - ".str_pad($sublimit, 2, "0", STR_PAD_LEFT).":00 = $extra_time";
									$invdquery2 = $db->prepare("INSERT INTO pending_invoicedetail(pinvid,invdetail,invprice,invqty,invtotalprice,pinvdate) VALUES(?,?,?,?,?,?)");
									$invdvalues2 = array($pinvid,$hrs_detail,$subrate,$extra_hrs,$extra_amount,$Date);
									$invdquery2->execute($invdvalues2);
								}
							}

							////////////////////////////////////////////////////////////////////////////////
						
							//// Calculate Total Printing & Generator Hrs & Prices ////
							
							$prquery = $db->prepare("SELECT amtype,aid,subid,SUM(amvalue) total_qty FROM amenity_log WHERE amtype IN (?,?,?,?,?,?) AND aid=? AND subid=? AND is_charged=? GROUP BY amtype");
							$prquery->execute(array(1,4,5,6,7,8,$aid,$subid,0));
							while($prrow = $prquery->fetch())
							{
								$total_qty = $prrow['total_qty'];

								if($prrow['amtype'] == 1)
								{
									$amtype = "Paper Printing";
									if($total_qty > $printlimit)
									{
										$extra_prints       = $total_qty - $printlimit;
										$extra_print_amount = $printrate * $extra_prints;
										
										// echo("$amtype: Rate: $printrate || Limit: $printlimit || Consumed: $total_qty || $total_qty - $extra_prints * $printrate = $extra_print_amount <br><br>");	

										/// Total Print Entry ///
										$print_detail = "$amtype: Rate: $printrate || Limit: $printlimit || Consumed: $total_qty || $total_qty - $extra_prints * $printrate = $extra_print_amount";
										$invdquery3   = $db->prepare("INSERT INTO pending_invoicedetail(pinvid,invdetail,invprice,invqty,invtotalprice,pinvdate) VALUES(?,?,?,?,?,?)");
										$invdvalues3  = array($pinvid,$print_detail,$printrate,$extra_prints,$extra_print_amount,$Date);
										$invdquery3->execute($invdvalues3);
									}
								}
								if($prrow['amtype'] == 4)
								{
									$amtype = "Generator";

									if($total_qty > $generatorlimit)
									{
										$extra_hrs        = $total_qty - $generatorlimit;
										$extra_hrs_amount = $generatorrate * $extra_hrs;
										
										// echo("$amtype: Rate: $generatorrate || Limit: $generatorlimit || Consumed: $total_qty || $total_qty - $extra_hrs * $generatorrate = $extra_hrs_amount <br><br>");

										/// Total Generator Entry ///
										$generator_detail = "$amtype: Rate: $generatorrate || Limit: $generatorlimit || Consumed: $total_qty || $total_qty - $extra_hrs * $generatorrate = $extra_hrs_amount";
										$invdquery4   = $db->prepare("INSERT INTO pending_invoicedetail(pinvid,invdetail,invprice,invqty,invtotalprice,pinvdate) VALUES(?,?,?,?,?,?)");
										$invdvalues4  = array($pinvid,$generator_detail,$generatorrate,$extra_hrs,$extra_hrs_amount,$Date);
										$invdquery4->execute($invdvalues4);	
									}
								}
								if($prrow['amtype'] == 5)
								{
									$amtype = "Electricity";

									if($total_qty > $electricitylimit)
									{
										$extra_hrs        = $total_qty - $electricitylimit;
										$extra_hrs_amount = $electricityrate * $extra_hrs;
										
										// echo("$amtype: Rate: $electricityrate || Limit: $electricitylimit || Consumed: $total_qty || $total_qty - $extra_hrs * $electricityrate = $extra_hrs_amount <br><br>");

										/// Total Electricity Entry ///
										$electricity_detail = "$amtype: Rate: $electricityrate || Limit: $electricitylimit || Consumed: $total_qty || $total_qty - $extra_hrs * $electricityrate = $extra_hrs_amount";
										$invdquery5   = $db->prepare("INSERT INTO pending_invoicedetail(pinvid,invdetail,invprice,invqty,invtotalprice,pinvdate) VALUES(?,?,?,?,?,?)");
										$invdvalues5  = array($pinvid,$electricity_detail,$electricityrate,$extra_hrs,$extra_hrs_amount,$Date);
										$invdquery5->execute($invdvalues5);	
									}
								}
								if($prrow['amtype'] == 6)
								{
									$amtype = "Gas";

									if($total_qty > $gaslimit)
									{
										$extra_hrs        = $total_qty - $gaslimit;
										$extra_hrs_amount = $gasrate * $extra_hrs;
										
										// echo("$amtype: Rate: $gasrate || Limit: $gaslimit || Consumed: $total_qty || $total_qty - $extra_hrs * $gasrate = $extra_hrs_amount <br><br>");

										/// Total Gas Entry ///
										$gas_detail = "$amtype: Rate: $gasrate || Limit: $gaslimit || Consumed: $total_qty || $total_qty - $extra_hrs * $gasrate = $extra_hrs_amount";
										$invdquery6   = $db->prepare("INSERT INTO pending_invoicedetail(pinvid,invdetail,invprice,invqty,invtotalprice,pinvdate) VALUES(?,?,?,?,?,?)");
										$invdvalues6  = array($pinvid,$gas_detail,$gasrate,$extra_hrs,$extra_hrs_amount,$Date);
										$invdquery6->execute($invdvalues6);	
									}
								}
								if($prrow['amtype'] == 7)
								{
									$amtype = "GITMIT Card Replacement";

									if($total_qty > $cardlimit)
									{
										$extra_units        = $total_qty - $cardlimit;
										$extra_units_amount = $cardrate * $extra_units;
										
										// echo("$amtype: Rate: $gasrate || Limit: $gaslimit || Consumed: $total_qty || $total_qty - $extra_hrs * $gasrate = $extra_hrs_amount <br><br>");

										/// Total GITMIT Card Replacement Entry ///
										$card_detail = "$amtype: Rate: $cardrate || Limit: $cardlimit || Consumed: $total_qty || $total_qty - $extra_units * $cardrate = $extra_units_amount";
										$invdquery7   = $db->prepare("INSERT INTO pending_invoicedetail(pinvid,invdetail,invprice,invqty,invtotalprice,pinvdate) VALUES(?,?,?,?,?,?)");
										$invdvalues7  = array($pinvid,$card_detail,$cardrate,$extra_units,$extra_units_amount,$Date);
										$invdquery7->execute($invdvalues7);	
									}
								}
								if($prrow['amtype'] == 8)
								{
									$amtype = "GITMIT Card Lost / Not Returned";

									if($total_qty > $cardlostlimit)
									{
										$extra_units        = $total_qty - $cardlostlimit;
										$extra_units_amount = $cardlostrate * $extra_units;
										
										/// Total GITMIT Card Lost Entry ///
										$card_lost_detail = "$amtype: Rate: $cardlostrate || Limit: $cardlostlimit || Consumed: $total_qty || $total_qty - $extra_units * $cardlostrate = $extra_units_amount";
										$invdquery8   = $db->prepare("INSERT INTO pending_invoicedetail(pinvid,invdetail,invprice,invqty,invtotalprice,pinvdate) VALUES(?,?,?,?,?,?)");
										$invdvalues8  = array($pinvid,$card_lost_detail,$cardlostrate,$extra_units,$extra_units_amount,$Date);
										$invdquery8->execute($invdvalues8);	
									}
								}
							}

							////////////////////////////////////////////////////////////////////////////////
						
							//// Calculate Total Of Invoice and update to Pending Invoice ////

							$spquery = $db->prepare("SELECT pinvid,SUM(invtotalprice) AS total_amount FROM pending_invoicedetail WHERE pinvid = ?");
							$spquery->execute(array($pinvid));
							while($sprow = $spquery->fetch())
							{
								$total_amount = $sprow['total_amount'];
							}

							$uquery = $db->prepare("UPDATE pending_invoices SET totalamount=? WHERE pinvid=?");
							$uquery->execute(array($total_amount,$pinvid));

							/// Update Amenity Log Status to Charged (Add to pending Invoice) //// 

							$uquery = $db->prepare("UPDATE amenity_log SET is_charged=? WHERE aid=? AND subid=? AND is_charged=?");
							$uquery->execute(array(1,$aid,$subid,0));
						}
					}
				}
			}
			if($sub_id == 0){ header("Location: pending_invoices.php?err=2");die;}
		}
		header("Location: pending_invoices.php?err=2");die;	
	}
	
	function delete_pending_invoice($db,$URL,$pinvid)
	{
		$query1 = $db->prepare("DELETE FROM pending_invoices WHERE pinvid=?");
		$query2 = $db->prepare("DELETE FROM pending_invoicedetail WHERE pinvid=?");
		
		if($query1->execute(array($pinvid)) && $query2->execute(array($pinvid)))
		{
			header("Location: pending_invoices.php?err=4");die;		
		}
	}
	////////////////////////////////////////////////////////////
	/////////////////  Admin Dashboard  ///////////////////////
	function member_log_entry($db,$URL,$log)
	{
	    $LogQuery = $db->prepare("INSERT INTO alogdetail(alogid , aid , detail , aldate) VALUES(?,?,?,?)");
	    $LogValues = array($_SESSION['alogid'] , $_SESSION['aid'] , $log , time());
	    $LogQuery->execute($LogValues);
	}
	function admin_dashboard($db,$URL,$aid)
	{
		$query = $db->prepare("SELECT * FROM accounts WHERE aid = ?");
	    $values = array($aid);
	   	$query->execute($values);
	   	while($row = $query->fetch())
	    {
	        $AID  = $row['aid'];
	        $AcName  = $row['aname'];
	        $AcEmail  = $row['aemail'];
	    }

	    $_SESSION['aid']    = $AID;
	    $_SESSION['aname']  = $AcName;
	    $_SESSION['aemail'] = $AcEmail;
	    $_SESSION['atype']  = 0;

	    $logdate    = time();
	    $deletedate = $logdate + 864000;
	    $ip         = $_SERVER['REMOTE_ADDR'];
		
	    // Log Entry
	    $LogQuery = $db->prepare("INSERT INTO alogreport(aid , ip , alogdate , deletedate) VALUES(?,?,?,?)");
	    $LogValues = array($AID , $ip , $logdate , $deletedate);
	    if($LogQuery->execute($LogValues))
	    {

	        $alogid = $db->lastInsertId();      
	        $_SESSION['alogid'] = $alogid;

	        ////////// Log Entry //////////
	        $log = "$AcName - $AcEmail loggedin to the members portal";
	        member_log_entry($db,$URL,$log);
	        ///////////////////////////////
	        //echo($_SESSION['aname']);die;
			$link = "<script>window.open('../dashboard', 'width=710,height=555,left=160,top=170')</script>";
			echo $link;
		}	
	}
?>