<?php
// Simple per-request cache helpers to avoid repeated DB hits for reference data

function cacheGet(string $key)
{
	static $cache = [];
	return $cache[$key] ?? null;
}

function cacheSet(string $key, $value)
{
	static $cache = [];
	$cache[$key] = $value;
	return $value;
}

function getRawMaterialsCatalog(PDO $db)
{
	$cacheKey = 'rawmaterials_catalog_v1';
	$cached = cacheGet($cacheKey);
	if ($cached !== null) {
		return $cached;
	}
	$stmt = $db->prepare("SELECT RAW.rid, RAW.rmid, RAW.rcid, RM.rmaincategory, RAW.rname, RC.rcategory
						  FROM rawmaterials RAW
						  INNER JOIN rmaincategory RM ON RAW.rmid = RM.rmid
						  LEFT JOIN rcategory RC ON RAW.rcid = RC.rcid
						  ORDER BY RAW.rname ASC");
	$stmt->execute();
	$result = $stmt->fetchAll();
	return cacheSet($cacheKey, $result);
}

?>


