<?php
	include("includes/functions.php");
	include("includes/session.php");
	include("includes/errors.php");
	chk_login();

	$GenQuery = $db->prepare("SELECT * FROM geninfo");
	$GenQuery->execute();
	while($GenObj = $GenQuery->fetch())
	{
		$GenAddress	 = $GenObj['address']; 
		$GenWebsite	 = $GenObj['website']; 
		$GenEmail	 = $GenObj['email']; 
		$GenPhone	 = $GenObj['phone']; 
		$GenTagLine	 = $GenObj['tagline']; 
		$GenPwdEmail = $GenObj['pwdemail'];
		$GenPayDate	 = date("d-m-Y",$GenObj['paydate']); 
	}
	
	if(isset($_REQUEST['btnSubmit']))
	{
		funds_transfer();
	}
?>
<!doctype html>
<html>
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
	<!-- Apple devices fullscreen -->
	<meta name="apple-mobile-web-app-capable" content="yes" />
	<!-- Apple devices fullscreen -->
	<meta names="apple-mobile-web-app-status-bar-style" content="black-translucent" />

	<title>Sentient - Members Funds Transfer</title>

	<!-- Bootstrap -->
	<link rel="stylesheet" href="css/bootstrap.min.css">
	<!-- jQuery UI -->
	<link rel="stylesheet" href="css/plugins/jquery-ui/jquery-ui.min.css">
	<!-- dataTables -->
	<link rel="stylesheet" href="css/plugins/datatable/TableTools.css">
	<!-- chosen -->
	<link rel="stylesheet" href="css/plugins/chosen/chosen.css">
	<!-- Theme CSS -->
	<link rel="stylesheet" href="css/style.css">
	<!-- Color CSS -->
	<link rel="stylesheet" href="css/themes.css">

	<!-- Ajax -->
	<script src="ajax/ajaxfunctions.js"></script>

	<!-- jQuery -->
	<script src="js/jquery.min.js"></script>

	<!-- Nice Scroll -->
	<script src="js/plugins/nicescroll/jquery.nicescroll.min.js"></script>
	<!-- imagesLoaded -->
	<script src="js/plugins/imagesLoaded/jquery.imagesloaded.min.js"></script>
	<!-- jQuery UI -->
	<script src="js/plugins/jquery-ui/jquery-ui.js"></script>
	<!-- slimScroll -->
	<script src="js/plugins/slimscroll/jquery.slimscroll.min.js"></script>
	<!-- Bootstrap -->
	<script src="js/bootstrap.min.js"></script>
	<!-- Bootbox -->
	<script src="js/plugins/bootbox/jquery.bootbox.js"></script>
	
	<!-- Datepicker -->
	<script src="js/plugins/datepicker/bootstrap-datepicker.js"></script>
	
	<!-- New DataTables -->
	<script src="js/plugins/momentjs/jquery.moment.min.js"></script>
	<script src="js/plugins/momentjs/moment-range.min.js"></script>
	<script src="js/plugins/datatables/jquery.dataTables.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.tableTools.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.colReorder.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.colVis.min.js"></script>
	<script src="js/plugins/datatables/extensions/dataTables.scroller.min.js"></script>

	<!-- Chosen -->
	<script src="js/plugins/chosen/chosen.jquery.min.js"></script>

	<!-- Theme framework -->
	<script src="js/eakroko.min.js"></script>
	<!-- Theme scripts -->
	<script src="js/application.min.js"></script>
	<!-- Just for demonstration -->
	<script src="js/demonstration.min.js"></script>
	<script language="javascript" type="text/javascript">
		function PrintLedger()
		{
			//alert("Mohsin");return false;
			var acmid = document.Form.cboMainCategory.value;
			var aid = document.Form.cboAccount.value;

			var startdate = document.Form.startdate.value;
			var enddate = document.Form.enddate.value;

			window.open( "print_ledger.php?acmid="+acmid+"&aid="+aid+"&startdate="+startdate+"&enddate="+enddate+"", "myWindow", "status = 1, scrollbars=1, height = 650, WIDTH= 900, resizable = 1, top = 0" )
		}

		function getaccount(acmid)
		{
			var url	  		= "chk_account.php?acmid="+acmid;
			var containerid = "ShowAccount";
			return GetPage(url, containerid);
		}
		
	</script>
	<!--[if lte IE 9]>
	<script src="js/plugins/placeholder/jquery.placeholder.min.js"></script>
	<script>
		$(document).ready(function () {
			$('input, textarea').placeholder();
		});
	</script>
	<![endif]-->

	<!-- Favicon -->
	<link rel="shortcut icon" href="../img/favicon.png" />
	<!-- Apple devices Homescreen icon -->
	<link rel="apple-touch-icon-precomposed" href="img/apple-touch-icon-precomposed.png" />

</head>

<body class='theme-grey'>
<!-- HEADER START -->
<?php include("top.php"); ?>
<!-- HEADER END -->
<div class="container-fluid" id="content">
<div id="left">
	<form action="search-results.php" method="GET" class='search-form'>
		<div class="search-pane">
			<input type="text" name="search" placeholder="Search here...">
			<button type="submit">
				<i class="fa fa-search"></i>
			</button>
		</div>
	</form>
	<!-- QUICK LINKS -->
	<?php include("left.php"); ?>
	<!-- QUICK LINKS -->
</div>
<div id="main">
<div class="container-fluid">
<div class="page-header">
	<div class="pull-left">
		<h1><i class="fa fa-table"></i> Member Funds Transfer</h1>
	</div>
	<div class="pull-right">
	</div>
</div>
<div class="breadcrumbs">
	<ul>
		<li>
			<a href="main.php">Home</a>
			<i class="fa fa-angle-right"></i>
		</li>
		<li>
			<a href="funds_transfer.php">Member Funds Transfer</a>
			<i class="fa fa-angle-right"></i>
		</li>
		
	</ul>
	<div class="close-bread">
		<a href="#">
			<i class="fa fa-times"></i>
		</a>
	</div>
</div>
<?php
	if(isset($_REQUEST['err']))
	{
?>
<div class="alert alert-success alert-dismissable">
	<button type="button" class="close" data-dismiss="alert">&times;</button>
	<?php echo($ErrMsg); ?>
</div>
<?php
	}
?>
<div class="row">
	<div class="col-sm-12">
		<div class="box box-color box-bordered">
			<div class="box-title">
				<h3>Funds Transfer (Last Payout: <?php echo($GenPayDate); ?>)</h3>

			</div>
			<div class="box-content nopadding">
				<form name="Form" method="post">
				<table class="table table-hover table-nomargin dataTable">
					<?php
						$query = $db->prepare("SELECT COUNT(aid) AS total_member, SUM(dirbonus) AS dir_bonus, SUM(indirbonus) AS indir_bonus, SUM(prbonus) AS pr_bonus, 
											SUM(prlevel1) AS pr_level1, SUM(prlevel2) AS pr_level2, SUM(prlevel3) AS pr_level3, SUM(prlevel4) AS pr_level4, SUM(prlevel5) AS pr_level5, 
											SUM(lead1) AS lead_level1, SUM(lead2) AS lead_level2, SUM(lead3) AS lead_level3, SUM(lead4) AS lead_level4, SUM(lead5) AS lead_level5 FROM tmp_ledger");
						$query->execute();
						while($row = $query->fetch())
						{
							$total_member = $row['total_member'];
							$dir_bonus 	  = $row['dir_bonus'];
							$indir_bonus  = $row['indir_bonus'];

							$pr_bonus  = $row['pr_bonus'];
							$pr_level1 = $row['pr_level1'];
							$pr_level2 = $row['pr_level2'];
							$pr_level3 = $row['pr_level3'];
							$pr_level4 = $row['pr_level4'];
							$pr_level5 = $row['pr_level5'];
							
							$total_prlevel = $pr_level1 + $pr_level2 + $pr_level3 + $pr_level4 + $pr_level5;

							$lead_level1 = $row['lead_level1'];
							$lead_level2 = $row['lead_level2'];
							$lead_level3 = $row['lead_level3'];
							$lead_level4 = $row['lead_level4'];
							$lead_level5 = $row['lead_level5'];

							$total_leadlevel = $lead_level1 + $lead_level2 + $lead_level3 + $lead_level4 + $lead_level5;
						}
					?>
					<tbody>
					<tr>
						<td width="500" ><h2>Total Members</h2></td>
						<td width="500"><h2><?php echo($total_member); ?></h2></td>
					</tr>
					<tr>
						<td width="500" ><h2>Direct Bonus</h2></td>
						<td width="500"><h2>PKR <?php echo(number_format($dir_bonus)); ?>/-</h2></td>
					</tr>
					<tr>
						<td width="500" ><h2>Indirect Bonus</h2></td>
						<td width="500"><h2>PKR <?php echo(number_format($indir_bonus)); ?>/-</h2></td>
					</tr>
					<tr>
						<td width="500" ><h2>Portfolio Bonus</h2></td>
						<td width="500"><h2>PKR <?php echo(number_format($pr_bonus)); ?>/-</h2></td>
					</tr>
					<tr>
						<td width="500" ><h2>Portfolio Level Bonus</h2></td>
						<td width="500">
							<table width="100%">
								<tr>
									<td><h3>L1: <?php echo($pr_level1); ?></h3></td>
									<td><h3>L2: <?php echo($pr_level2); ?></h3></td>
									<td><h3>L3: <?php echo($pr_level3); ?></h3></td>
									<td><h3>L4: <?php echo($pr_level4); ?></h3></td>
									<td><h3>L5: <?php echo($pr_level5); ?></h3></td>
								</tr>
								<tr>
									<td align="left" colspan="5"><h3>Total: <?php echo($total_prlevel); ?></h3></td>
								</tr>
							</table>
						</td>
					</tr>
					<tr>
						<td width="500" ><h2>Leadership Bonus</h2></td>
						<td width="500">
							<table width="100%">
								<tr>
									<td><h3>L1: <?php echo($lead_level1); ?></h3></td>
									<td><h3>L2: <?php echo($lead_level2); ?></h3></td>
									<td><h3>L3: <?php echo($lead_level3); ?></h3></td>
									<td><h3>L4: <?php echo($lead_level4); ?></h3></td>
									<td><h3>L5: <?php echo($lead_level5); ?></h3></td>
								</tr>
								<tr>
									<td align="left" colspan="5"><h3>Total: <?php echo($total_leadlevel); ?></h3></td>
								</tr>
							</table>
						</td>
					</tr>
					<tr>
						<td colspan="2" align="right">
							<div class="form-actions">
								<input name="btnSubmit" type="submit" class="btn btn-danger" value="  Submit Payment  " onclick="return PrintLedger();">
								<input name="btnCancel" type="submit" class="btn btn-primary" value="  Cancel  ">
							</div>
						</td>
					</tr>
					</tbody>
				</table>
				</form>
			</div>
		</div>
	</div>
</div>
</div>
</div>
</div>
</body>
</html>