<?php
	include("includes/functions.php");
	include("includes/session.php");
	include("includes/errors.php");
	chk_login();

	if(isset($_REQUEST['btnSubmit']))
	{
		update_store($db,$URL,$_REQUEST['stid']);
	}
?>
<!doctype html>
<html>
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
	<!-- Apple devices fullscreen -->
	<meta name="apple-mobile-web-app-capable" content="yes" />
	<!-- Apple devices fullscreen -->
	<meta names="apple-mobile-web-app-status-bar-style" content="black-translucent" />

	<title>Sentient - Update Store</title>
	
	<!-- Bootstrap -->
	<link rel="stylesheet" href="css/bootstrap.min.css">
	<!-- jQuery UI -->
	<link rel="stylesheet" href="css/plugins/jquery-ui/jquery-ui.min.css">
	<!-- PageGuide -->
	<link rel="stylesheet" href="css/plugins/pageguide/pageguide.css">
	<!-- Fullcalendar -->
	<link rel="stylesheet" href="css/plugins/fullcalendar/fullcalendar.css">
	<link rel="stylesheet" href="css/plugins/fullcalendar/fullcalendar.print.css" media="print">
	<!-- Tagsinput -->
	<link rel="stylesheet" href="css/plugins/tagsinput/jquery.tagsinput.css">
	<!-- chosen -->
	<link rel="stylesheet" href="css/plugins/chosen/chosen.css">
	<!-- multi select -->
	<link rel="stylesheet" href="css/plugins/multiselect/multi-select.css">
	<!-- timepicker -->
	<link rel="stylesheet" href="css/plugins/timepicker/bootstrap-timepicker.min.css">
	<!-- colorpicker -->
	<link rel="stylesheet" href="css/plugins/colorpicker/colorpicker.css">
	<!-- Datepicker -->
	<link rel="stylesheet" href="css/plugins/datepicker/datepicker.css">
	<!-- Daterangepicker -->
	<link rel="stylesheet" href="css/plugins/daterangepicker/daterangepicker.css">
	<!-- Plupload -->
	<link rel="stylesheet" href="css/plugins/plupload/jquery.plupload.queue.css">
	<!-- select2 -->
	<link rel="stylesheet" href="css/plugins/select2/select2.css">
	<!-- icheck -->
	<link rel="stylesheet" href="css/plugins/icheck/all.css">
	<!-- Theme CSS -->
	<link rel="stylesheet" href="css/style.css">
	<!-- Color CSS -->
	<link rel="stylesheet" href="css/themes.css">


	<!-- jQuery -->
	<script src="js/jquery.min.js"></script>

	<!-- Nice Scroll -->
	<script src="js/plugins/nicescroll/jquery.nicescroll.min.js"></script>
	<!-- imagesLoaded -->
	<script src="js/plugins/imagesLoaded/jquery.imagesloaded.min.js"></script>
	<!-- jQuery UI -->
	<script src="js/plugins/jquery-ui/jquery-ui.js"></script>
	<!-- Bootstrap -->
	<script src="js/bootstrap.min.js"></script>
	<!-- Bootbox -->
	<script src="js/plugins/bootbox/jquery.bootbox.js"></script>
	<!-- Masked inputs -->
	<script src="js/plugins/maskedinput/jquery.maskedinput.min.js"></script>
	<!-- TagsInput -->
	<script src="js/plugins/tagsinput/jquery.tagsinput.min.js"></script>
	<!-- Datepicker -->
	<script src="js/plugins/datepicker/bootstrap-datepicker.js"></script>
	<!-- Daterangepicker -->
	<script src="js/plugins/daterangepicker/moment.min.js"></script>
	<script src="js/plugins/daterangepicker/daterangepicker.js"></script>
	<!-- Timepicker -->
	<script src="js/plugins/timepicker/bootstrap-timepicker.min.js"></script>
	<!-- Colorpicker -->
	<script src="js/plugins/colorpicker/bootstrap-colorpicker.js"></script>
	<!-- Chosen -->
	<script src="js/plugins/chosen/chosen.jquery.min.js"></script>
	<!-- MultiSelect -->
	<script src="js/plugins/multiselect/jquery.multi-select.js"></script>
	<!-- CKEditor -->
	<script src="js/plugins/ckeditor/ckeditor.js"></script>
	<!-- PLUpload -->
	<script src="js/plugins/plupload/plupload.full.min.js"></script>
	<script src="js/plugins/plupload/jquery.plupload.queue/jquery.plupload.queue.min.js"></script>
	<!-- Custom file upload -->
	<script src="js/plugins/fileupload/bootstrap-fileupload.min.js"></script>
	<script src="js/plugins/mockjax/jquery.mockjax.js"></script>
	<!-- select2 -->
	<script src="js/plugins/select2/select2.min.js"></script>
	<!-- icheck -->
	<script src="js/plugins/icheck/jquery.icheck.min.js"></script>
	<!-- complexify -->
	<script src="js/plugins/complexify/jquery.complexify-banlist.min.js"></script>
	<script src="js/plugins/complexify/jquery.complexify.min.js"></script>
	<!-- Mockjax -->
	<script src="js/plugins/mockjax/jquery.mockjax.js"></script>

	<!-- Theme framework -->
	<script src="js/eakroko.min.js"></script>
	<!-- Theme scripts -->
	<script src="js/application.min.js"></script>
	<!-- Just for demonstration -->
	<script src="js/demonstration.min.js"></script>

	
</head>

<body class='theme-grey'>
	<!-- HEADER START -->
	<?php include("top.php"); ?>
	<!-- HEADER END -->
	<div class="container-fluid" id="content">
		<div id="left">
			<form action="search-results.html" method="GET" class='search-form'>
				<div class="search-pane">
					<input type="text" name="search" placeholder="Search here...">
					<button type="submit">
						<i class="fa fa-search"></i>
					</button>
				</div>
			</form>
			<!-- QUICK LINKS -->
			<?php include("left.php"); ?>
			<!-- QUICK LINKS -->	
		</div>
		<div id="main">
			<div class="container-fluid">
				<div class="page-header">
					<div class="pull-left">
						<h1>Update Store</h1>
					</div>
				</div>
				<div class="breadcrumbs">
					<ul>
						<li>
							<a href="main.php">Home</a>
							<i class="fa fa-angle-right"></i>
						</li>
						<li>
							<a href="stores.php">Manage Stores</a>
							<i class="fa fa-angle-right"></i>
						</li>
						<li>
							<a href="addstore.php?">Create New Store</a>
						</li>
					</ul>
					<div class="close-bread">
						<a href="#">
							<i class="fa fa-times"></i>
						</a>
					</div>
				</div>
				<form name="Form" action="#" method="POST" class='form-horizontal form-validate' id="bb" enctype="MULTIPART/FORM-DATA">
				<div class="row">
					<div class="col-sm-12">
						<div class="box">
							<div class="box-content">
									<div id="ShowUser"></div>
									<div id="GetProduct"></div>
									<?php
										if(isset($_REQUEST['err']))
										{
									?>
									<div class="alert alert-danger alert-dismissable">
										<button type="button" class="close" data-dismiss="alert">&times;</button>
										<?php echo($ErrMsg); ?>
									</div>
									<?php
										}
										$query = $db->prepare("SELECT * FROM store WHERE stid = ?");
										$query->execute(array($_REQUEST['stid']));
										while($row = $query->fetch())
										{

									?>
									
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Store Code</label>
										<div class="col-sm-10">
											<span style="color:red; font-weight: bold;">ST-<?php echo($row['store_code']); ?></span>
											<input type="hidden" name="hdnStNo" value="<?php echo($row['store_code']); ?>">
										</div>
									</div>
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Store Name</label>
										<div class="col-sm-10">
											<input type="text" name="txtStoreName" id="textfield" class="form-control" data-rule-required="true" data-rule-minlength="1" value="<?php echo($row['store_name']); ?>">
										</div>
									</div>
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Store Chain</label>
										<div class="col-sm-10">
											<select name="cboStoreChain" class="chosen-select control-label col-sm-4">
												<option value="">Select Store Chain</option>
												<?php
													$chain_store = $row['chain_store'];

													$scquery = $db->prepare("SELECT * FROM store_chain ORDER BY store_chain ASC");
													$scquery->execute();
													while($scrow = $scquery->fetch())
													{
												?>
												<option <?php if($chain_store == $scrow['store_chain']) { echo("SELECTED"); } ?> value="<?php echo($scrow['store_chain']); ?>"><?php echo($scrow['store_chain']); ?></option>
												<?php } ?>
											</select>
										</div>
									</div>
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">City</label>
										<div class="col-sm-10">
											<select name="cboCity" class="chosen-select control-label col-sm-4">
												<option value="">Select City</option>
												<?php
													$city = $row['city'];
													$ciquery = $db->prepare("SELECT * FROM cities ORDER BY city_name ASC");
													$ciquery->execute();
													while($cirow = $ciquery->fetch())
													{
												?>
												<option <?php if($city == $cirow['city_name']) { echo("SELECTED"); } ?> value="<?php echo($cirow['city_name']); ?>"><?php echo($cirow['city_code']); ?> - <?php echo($cirow['city_name']); ?></option>
												<?php } ?>
											</select>
										</div>
									</div>

									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Channel</label>
										<div class="col-sm-10">
											<select name="cboChannel" class="chosen-select control-label col-sm-4">
												<option value="">Select Channel</option>
												<option <?php if($row['channel'] == "LMT") { echo("SELECTED"); } ?> value="LMT">LMT</option>
												<option <?php if($row['channel'] == "IMT") { echo("SELECTED"); } ?> value="IMT">IMT</option>
												<option <?php if($row['channel'] == "GT") { echo("SELECTED"); } ?> value="GT">GT</option>
												<option <?php if($row['channel'] == "Key Accounts") { echo("SELECTED"); } ?> value="Key Accounts">Key Accounts</option>
											</select>
										</div>
									</div>
									
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Coordinates</label>
										<div class="col-sm-5">
											<input type="text" name="txtLat" id="textfield" class="form-control" data-rule-required="true" data-rule-minlength="1" value="<?php echo($row['stlat']); ?>">
										</div>
										<div class="col-sm-5">
											<input type="text" name="txtLong" id="textfield" class="form-control" data-rule-required="true" data-rule-minlength="1" value="<?php echo($row['stlong']); ?>">
										</div>
									</div>
									
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Off Day</label>
										<div class="col-sm-10">
											<select name="cboWeeklyOff" class="control-label col-sm-4">
												<option value="">Select Off Day</option>
												<?php
													$off_day = $row['off_day'];
													$wquery = $db->prepare("SELECT weekday FROM weekdays");
													$wquery->execute();
													while($wrow = $wquery->fetch())
													{
												?>
												<option <?php if($off_day == $wrow['weekday']) { echo("SELECTED"); } ?> value="<?php echo($wrow['weekday']); ?>"><?php echo($wrow['weekday']); ?></option>
												<?php
													}
												?>
												
											</select>
										</div>
									</div>

									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Shift Timing</label>
										<div class="col-sm-1">
											From
										</div>
										<div class="col-sm-3">
											<?php
												$open_time = explode(":", $row['open_time']);
												$open_hr = $open_time[0];
												$open_min = $open_time[1];

												$close_time = explode(":", $row['close_time']);
												$close_hr = $close_time[0];
												$close_min = $close_time[1];

												$break_from = explode(":", $row['break_from']);
												$break_from_hr = $break_from[0];
												$break_from_min = $break_from[1];

												$break_to = explode(":", $row['break_to']);
												$break_to_hr = $break_to[0];
												$break_to_min = $break_to[1];

												
											?>
											<select name="cboFromHrs" class="control-label col-sm-4">
												<option value="">Hrs</option>
												<?php
													$hrquery1 = $db->prepare("SELECT hrs FROM hrs");
													$hrquery1->execute();
													while($hrrow1 = $hrquery1->fetch())
													{
												?>
												<option <?php if($open_hr == $hrrow1['hrs']) { echo("SELECTED"); } ?> value="<?php echo($hrrow1['hrs']); ?>"><?php echo($hrrow1['hrs']); ?></option>
												<?php
													}
												?>
											</select>
											<select name="cboFromMins" class="control-label col-sm-4">
												<option value="00">00</option>
											</select>
										</div>
										<div class="col-sm-1">
											To
										</div>
										<div class="col-sm-3">
											<select name="cboToHrs" class="control-label col-sm-4">
												<option value="">Hrs</option>
												<?php
													$hrquery2 = $db->prepare("SELECT hrs FROM hrs");
													$hrquery2->execute();
													while($hrrow2 = $hrquery2->fetch())
													{
												?>
												<option <?php if($close_hr == $hrrow2['hrs']) { echo("SELECTED"); } ?> value="<?php echo($hrrow2['hrs']); ?>"><?php echo($hrrow2['hrs']); ?></option>
												<?php
													}
												?>
											</select>
											<select name="cboToMins" class="control-label col-sm-4">
												<option value="00">00</option>
											</select>
										</div>

									</div>


									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Break Timing</label>
										<div class="col-sm-1">
											From
										</div>
										<div class="col-sm-3">
											<select name="cboBrFromHrs" class="control-label col-sm-4">
												<option value="">Hrs</option>
												<?php
													$hrquery3 = $db->prepare("SELECT hrs FROM hrs");
													$hrquery3->execute();
													while($hrrow3 = $hrquery3->fetch())
													{
												?>
												<option <?php if($break_from_hr == $hrrow3['hrs']) { echo("SELECTED"); } ?> value="<?php echo($hrrow3['hrs']); ?>"><?php echo($hrrow3['hrs']); ?></option>
												<?php
													}
												?>
											</select>
											<select name="cboBrFromMins" class="control-label col-sm-4">
												<option value="00">00</option>
											</select>
										</div>
										<div class="col-sm-1">
											To
										</div>
										<div class="col-sm-3">
											<select name="cboBrToHrs" class="control-label col-sm-4">
												<option value="">Hrs</option>
												<?php
													$hrquery4 = $db->prepare("SELECT hrs FROM hrs");
													$hrquery4->execute();
													while($hrrow4 = $hrquery4->fetch())
													{
												?>
												<option <?php if($break_to_hr == $hrrow4['hrs']) { echo("SELECTED"); } ?> value="<?php echo($hrrow4['hrs']); ?>"><?php echo($hrrow4['hrs']); ?></option>
												<?php
													}
												?>
											</select>
											<select name="cboBrToMins" class="control-label col-sm-4">
												<option value="00">00</option>
											</select>
										</div>

									</div>


									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Uniform</label>
										<div class="col-sm-10">
											<select name="cboUniform" class="control-label col-sm-4">
												<option <?php if($row['uniform'] == "Western") { echo("SELECTED"); } ?> value="Western">Western</option>
												<option <?php if($row['uniform'] == "Eastern") { echo("SELECTED"); } ?> value="Eastern">Eastern</option>
												<option <?php if($row['uniform'] == "Not Allowed") { echo("SELECTED"); } ?> value="Not Allowed">Not Allowed</option>
												<option <?php if($row['uniform'] == "Abaayah with Coat") { echo("SELECTED"); } ?> value="Abaayah with Coat">Abaayah with Coat</option>
												<option <?php if($row['uniform'] == "Abaayah Only (LOV)") { echo("SELECTED"); } ?> value="Abaayah Only (LOV)">Abaayah Only (LOV)</option>
												<option <?php if($row['uniform'] == "Western") { echo("SELECTED"); } ?> value="Western">Western</option>
											</select>
										</div>
									</div>

									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Scarf</label>
										<div class="col-sm-10">
											<select name="cboScarf" class="control-label col-sm-4">
												<option <?php if($row['scarf'] == "Yes") { echo("SELECTED"); } ?> value="Yes">Yes</option>
												<option <?php if($row['scarf'] == "No") { echo("SELECTED"); } ?> value="No">No</option>
											</select>
										</div>
									</div>

									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Badge</label>
										<div class="col-sm-10">
											<select name="cboBadge" class="control-label col-sm-4">
												<option <?php if($row['badge'] == "Yes") { echo("SELECTED"); } ?> value="Yes">Yes</option>
												<option <?php if($row['badge'] == "No") { echo("SELECTED"); } ?> value="No">No</option>
											</select>
										</div>
									</div>
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Data Sheet</label>
										<div class="col-sm-10">
											<select name="cboDataSheet" class="control-label col-sm-4">
												<option <?php if($row['data_sheet'] == "Yes") { echo("SELECTED"); } ?> value="Yes">Yes</option>
												<option <?php if($row['data_sheet'] == "No") { echo("SELECTED"); } ?> value="No">No</option>
											</select>
										</div>
									</div>
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Device</label>
										<div class="col-sm-10">
											<select name="cboDevice" class="control-label col-sm-4">
												<option <?php if($row['device'] == "Yes") { echo("SELECTED"); } ?> value="Allowed">Allowed</option>
												<option <?php if($row['device'] == "No") { echo("SELECTED"); } ?> value="Not Allowed">Not Allowed</option>
											</select>
										</div>
									</div>
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Store Card</label>
										<div class="col-sm-10">
											<select name="cboStoreCard" class="control-label col-sm-4">
												<option <?php if($row['store_card'] == "Yes") { echo("SELECTED"); } ?> value="Yes">Yes</option>
												<option <?php if($row['store_card'] == "No") { echo("SELECTED"); } ?> value="No">No</option>
											</select>
										</div>
									</div>
									<div class="form-group">
										<label for="textfield" class="control-label col-sm-2">Documentation Requested</label>
										<div class="col-sm-10">
											<select name="cboDocument" class="control-label col-sm-4">
												<option value="Yes">Yes</option>
												<option value="No">No</option>
											</select>
										</div>
									</div>
								
								<?php } ?>
									
									
									
									
									
									
								</div>	
							</div>
						</div>
					</div>
					<div class="form-actions">
						<input name="btnSubmit" type="submit" class="btn btn-primary" value="  Save  ">
						<a href="stores.php" name="btnCancel" class="btn">Cancel</a>
					</div>
				</div>
				
				
				</form>
			</div>
		</div>
	</div>
</body>
</html>
